/*! For license information please see index.js.LICENSE.txt */
define(["module","@jupyter-widgets/base"],((t,e)=>(()=>{var n={1195:(t,e,i)=>{(e=i(1364)(!1)).push([t.id,"/* Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n.leaflet-container {\n  height: 100%;\n  width: 100%;\n}\n\n.jupyter-widgets.leaflet-widgets {\n  height: 400px;\n  overflow: hidden;\n  flex: 1 1 auto;\n}\n\n.jp-LinkedOutputView .jupyter-widgets.leaflet-widgets {\n  min-height: 360px; /* Min-height required for mirred output in jlab < 0.31.6 */\n  height: 100%;\n}\n\n/* Leaflet crispness override */\n.crisp-image {\n  /* Preserve crisp pixels with scaled up images */\n  image-rendering: optimizeSpeed; /* Legal fallback */\n  image-rendering: -moz-crisp-edges; /* Firefox        */\n  image-rendering: -o-crisp-edges; /* Opera          */\n  image-rendering: -webkit-optimize-contrast; /* Safari         */\n  image-rendering: optimize-contrast; /* CSS3 Proposed  */\n  image-rendering: crisp-edges; /* CSS4 Proposed  */\n  image-rendering: pixelated; /* CSS4 Proposed  */\n  -ms-interpolation-mode: nearest-neighbor; /* IE8+           */\n}\n\n/* JupyterLab themes support */\n/* Popup */\n.leaflet-popup-content-wrapper,\n.leaflet-popup-tip {\n  background-color: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n  border-width: var(--jp-border-width);\n  border-color: var(--jp-border-color1);\n}\n\n/* Basic controls */\n.leaflet-bar a,\n.leaflet-bar a:hover {\n  background-color: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n  border-width: var(--jp-border-width);\n  border-color: var(--jp-border-color1);\n}\n\n.leaflet-bar a:hover {\n  background-color: var(--jp-layout-color2);\n  color: var(--jp-ui-font-color2);\n}\n\n.leaflet-bar a.leaflet-disabled {\n  background-color: var(--jp-layout-color3);\n  color: var(--jp-ui-font-color3);\n}\n\n/* Widget control */\n.leaflet-widgetcontrol {\n  background: var(--jp-layout-color1);\n  border-radius: 4.5px;\n  box-shadow: 4px 5px 8px 0px #9e9e9e;\n}\n\n/* SplitMap control */\n.leaflet-sbs-divider {\n  background-color: var(--jp-layout-color1);\n}\n\n.leaflet-sbs-range::-webkit-slider-thumb {\n  background-color: var(--jp-layout-color1);\n  border-width: var(--jp-border-width);\n  border-color: var(--jp-border-color1);\n}\n\n.leaflet-sbs-range::-ms-thumb {\n  background-color: var(--jp-layout-color1);\n  border-width: var(--jp-border-width);\n  border-color: var(--jp-border-color1);\n}\n\n.leaflet-sbs-range::-moz-range-thumb {\n  background-color: var(--jp-layout-color1);\n  border-width: var(--jp-border-width);\n  border-color: var(--jp-border-color1);\n}\n\n/* Measure control */\n.leaflet-control-measure {\n  background-color: var(--jp-layout-color1);\n  border-width: var(--jp-border-width);\n  border-color: var(--jp-border-color1);\n  color: var(--jp-ui-font-color1);\n}\n\n/* Layers control */\n.leaflet-control-layers {\n  background-color: var(--jp-layout-color1);\n  border-width: var(--jp-border-width);\n  border-color: var(--jp-border-color1);\n  color: var(--jp-ui-font-color1);\n}\n\n.leaflet-control-layers-expanded {\n  background-color: var(--jp-layout-color1);\n  border-width: var(--jp-border-width);\n  border-color: var(--jp-border-color1);\n  color: var(--jp-ui-font-color1);\n}\n\n/* Attribution control */\n.leaflet-container .leaflet-control-attribution {\n  background-color: var(--jp-layout-color1);\n  border-width: var(--jp-border-width);\n  border-color: var(--jp-border-color1);\n  color: var(--jp-ui-font-color1);\n}\n\n.leaflet-control-velocity.leaflet-control {\n  background: var(--jp-layout-color1);\n  margin: 0;\n  padding: 0 5px;\n  color: var(--jp-ui-font-color1);\n  font-size: 11px;\n}\n\n/* Legend Control */\ndiv.leaflet-control-legend {\n  color: var(--jp-ui-font-color1);\n  line-height: 18px;\n  width: auto;\n  background-color: var(--jp-layout-color1);\n  border-width: var(--jp-border-width);\n  border-color: var(--jp-border-color1);\n  border-radius: 4.5px;\n  box-shadow: 0 1px 5px rgba(0, 0, 0, 0.4);\n  padding: 6px 10px 6px 6px;\n}\n\ndiv.leaflet-control-legend > h4 {\n  padding: 0;\n  margin: 0;\n  margin-bottom: 5px;\n}\n\ndiv.leaflet-control-legend > i {\n  width: 18px;\n  height: 18px;\n  float: left;\n  margin-right: 8px;\n}\n\ndiv.leaflet-control-legend > p {\n  display: inline-block;\n}\n\n/* Magnifying Glass */\n.leaflet-magnifying-glass {\n  border-radius: 50%;\n  border: 1px solid gray;\n  box-shadow: 0 0 5px gray;\n  position: absolute;\n  overflow: hidden;\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\n\n.leaflet-magnifying-glass > .leaflet-container {\n  height: 100%;\n  width: 100%;\n}\n\n/* Webkit-only workaround for the border-radius clipping bug,\napplied to the map container */\n.leaflet-magnifying-glass-webkit {\n  border-radius: 50%;\n  -webkit-mask-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAA5JREFUeNpiYGBgAAgwAAAEAAGbA+oJAAAAAElFTkSuQmCC);\n}\n",""]),t.exports=e},1901:(t,e,i)=>{(e=i(1364)(!1)).push([t.id,'.marker-icon,.marker-icon:focus{background-color:#fff;border:1px solid #3388ff;border-radius:50%;margin:-8px 0 0 -8px!important;width:14px!important;height:14px!important;outline:0;transition:opacity ease .3s}.marker-icon-middle,.marker-icon-middle:focus{opacity:.7;margin:-6px 0 0 -6px!important;width:10px!important;height:10px!important}.leaflet-pm-draggable{cursor:move!important}.cursor-marker{cursor:crosshair;pointer-events:none;opacity:0}.cursor-marker.visible{opacity:1!important}.geoman-draw-cursor{cursor:crosshair}.rect-style-marker,.rect-start-marker{opacity:0}.rect-style-marker.visible,.rect-start-marker.visible{opacity:1!important}.vertexmarker-disabled{opacity:.7}.pm-text-marker{width:0;height:0}.pm-textarea{background-color:#fff;color:#000;resize:none;border:none;outline:0;cursor:pointer;border-radius:3px;padding-left:7px;padding-bottom:0;padding-top:4px}.leaflet-pm-draggable .pm-textarea{cursor:move}.pm-textarea:focus,.pm-textarea:focus-within,.pm-textarea:focus-visible,.pm-textarea:active{border:2px solid #000;outline:0}.pm-textarea.pm-disabled{border:none;user-select:none}.pm-textarea.pm-hasfocus{cursor:auto}.leaflet-pm-toolbar .leaflet-buttons-control-button{padding:5px;box-sizing:border-box;position:relative;z-index:3}.leaflet-pm-toolbar .leaflet-pm-actions-container a.leaflet-pm-action:first-child:not(.pos-right),.leaflet-pm-toolbar .leaflet-pm-actions-container a.leaflet-pm-action:last-child.pos-right{border-radius:0}.leaflet-pm-toolbar .button-container a.leaflet-buttons-control-button{border-radius:0}.leaflet-pm-toolbar .button-container:last-child a.leaflet-buttons-control-button{border-radius:0 0 2px 2px}.leaflet-pm-toolbar .button-container:first-child a.leaflet-buttons-control-button{border-radius:2px 2px 0 0}.leaflet-pm-toolbar .button-container:last-child a.leaflet-buttons-control-button{border-bottom:none}.leaflet-pm-toolbar .control-fa-icon{font-size:19px;line-height:24px}.leaflet-pm-toolbar .control-icon{width:100%;height:100%;box-sizing:border-box;background-size:contain;background-repeat:no-repeat;background-position:center center}.leaflet-pm-toolbar .leaflet-pm-icon-marker{background-image:url(\'data:image/svg+xml,<?xml version="1.0" encoding="UTF-8"?>%0A<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">%0A    \x3c!-- Generator: Sketch 52.5 (67469) - http://www.bohemiancoding.com/sketch --\x3e%0A    <title>Atoms/Icons/Tools/Marker</title>%0A    <desc>Created with Sketch.</desc>%0A    <defs>%0A        <path d="M15.5,24.8782959 C15.2909201,24.8772219 15.1744857,24.8467817 14.6590866,24.2354163 C10.2196955,19.4118054 8,15.5014392 8,12.5043177 C8,8.35979746 11.3578644,5 15.5,5 C19.6421356,5 23,8.35979746 23,12.5043177 C23,17 18.2878217,21.9268378 16.3336601,24.2440186 C15.8224622,24.8501802 15.7090799,24.8793699 15.5,24.8782959 Z M15.5,15.5326948 C17.275201,15.5326948 18.7142857,14.1180004 18.7142857,12.3728864 C18.7142857,10.6277723 17.275201,9.21307792 15.5,9.21307792 C13.724799,9.21307792 12.2857143,10.6277723 12.2857143,12.3728864 C12.2857143,14.1180004 13.724799,15.5326948 15.5,15.5326948 Z" id="path-1"></path>%0A    </defs>%0A    <g id="Symbols" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">%0A        <g id="Atoms/Icons/Tools/Marker" transform="translate(-3.000000, -3.000000)">%0A            <mask id="mask-2" fill="white">%0A                <use xlink:href="%23path-1"></use>%0A            </mask>%0A            <use id="Mask" fill="%235B5B5B" fill-rule="nonzero" xlink:href="%23path-1"></use>%0A        </g>%0A    </g>%0A</svg>\')}.leaflet-pm-toolbar .leaflet-pm-icon-polygon{background-image:url(\'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 24 24">%0A  <defs>%0A    <path id="polygon-a" d="M19.4206892,9.16509725 C19.1523681,8.66992914 19,8.10275831 19,7.5 C19,5.56700338 20.5670034,4 22.5,4 C24.4329966,4 26,5.56700338 26,7.5 C26,9.26323595 24.6961471,10.7219407 23,10.9645556 L23,19.0354444 C24.6961471,19.2780593 26,20.736764 26,22.5 C26,24.4329966 24.4329966,26 22.5,26 C20.736764,26 19.2780593,24.6961471 19.0354444,23 L10.9645556,23 C10.7219407,24.6961471 9.26323595,26 7.5,26 C5.56700338,26 4,24.4329966 4,22.5 C4,20.5670034 5.56700338,19 7.5,19 C8.10275831,19 8.66992914,19.1523681 9.16509725,19.4206892 L19.4206892,9.16509725 Z M20.8349073,10.5793063 L10.5793108,20.8349027 C10.6086731,20.8890888 10.6366469,20.9441372 10.6631844,21 L19.3368156,21 C19.6825775,20.272154 20.272154,19.6825775 21,19.3368156 L21,10.6631844 C20.9441372,10.6366469 20.8890888,10.6086731 20.8349027,10.5793108 Z M22.5,9 C23.3284271,9 24,8.32842712 24,7.5 C24,6.67157288 23.3284271,6 22.5,6 C21.6715729,6 21,6.67157288 21,7.5 C21,8.32842712 21.6715729,9 22.5,9 Z M22.5,24 C23.3284271,24 24,23.3284271 24,22.5 C24,21.6715729 23.3284271,21 22.5,21 C21.6715729,21 21,21.6715729 21,22.5 C21,23.3284271 21.6715729,24 22.5,24 Z M7.5,24 C8.32842712,24 9,23.3284271 9,22.5 C9,21.6715729 8.32842712,21 7.5,21 C6.67157288,21 6,21.6715729 6,22.5 C6,23.3284271 6.67157288,24 7.5,24 Z"/>%0A  </defs>%0A  <g fill="none" fill-rule="evenodd" transform="translate(-3 -3)">%0A    <mask id="polygon-b" fill="%23fff">%0A      <use xlink:href="%23polygon-a"/>%0A    </mask>%0A    <use fill="%235B5B5B" fill-rule="nonzero" xlink:href="%23polygon-a"/>%0A    <g fill="%235B5B5B" mask="url(%23polygon-b)">%0A      <rect width="30" height="30"/>%0A    </g>%0A  </g>%0A</svg>%0A\')}.leaflet-pm-toolbar .leaflet-pm-icon-polyline{background-image:url(\'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 24 24">%0A  <defs>%0A    <path id="line-a" d="M9.16509725,19.4206892 L18.4206892,10.1650973 C18.1523681,9.66992914 18,9.10275831 18,8.5 C18,6.56700338 19.5670034,5 21.5,5 C23.4329966,5 25,6.56700338 25,8.5 C25,10.4329966 23.4329966,12 21.5,12 C20.8972417,12 20.3300709,11.8476319 19.8349027,11.5793108 L10.5793108,20.8349027 C10.8476319,21.3300709 11,21.8972417 11,22.5 C11,24.4329966 9.43299662,26 7.5,26 C5.56700338,26 4,24.4329966 4,22.5 C4,20.5670034 5.56700338,19 7.5,19 C8.10275831,19 8.66992914,19.1523681 9.16509725,19.4206892 Z M21.5,10 C22.3284271,10 23,9.32842712 23,8.5 C23,7.67157288 22.3284271,7 21.5,7 C20.6715729,7 20,7.67157288 20,8.5 C20,9.32842712 20.6715729,10 21.5,10 Z M7.5,24 C8.32842712,24 9,23.3284271 9,22.5 C9,21.6715729 8.32842712,21 7.5,21 C6.67157288,21 6,21.6715729 6,22.5 C6,23.3284271 6.67157288,24 7.5,24 Z"/>%0A  </defs>%0A  <g fill="none" fill-rule="evenodd" transform="translate(-3 -3)">%0A    <mask id="line-b" fill="%23fff">%0A      <use xlink:href="%23line-a"/>%0A    </mask>%0A    <use fill="%235B5B5B" fill-rule="nonzero" xlink:href="%23line-a"/>%0A    <g fill="%235B5B5B" mask="url(%23line-b)">%0A      <rect width="30" height="30"/>%0A    </g>%0A  </g>%0A</svg>%0A\')}.leaflet-pm-toolbar .leaflet-pm-icon-circle{background-image:url(\'data:image/svg+xml,<?xml version="1.0" encoding="UTF-8"?>%0A<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">%0A    \x3c!-- Generator: Sketch 52.5 (67469) - http://www.bohemiancoding.com/sketch --\x3e%0A    <title>Atoms/Icons/Tools/Circle</title>%0A    <desc>Created with Sketch.</desc>%0A    <defs>%0A        <path d="M18.2897751,6.78602275 C18.8924131,6.29464981 19.661797,6 20.5,6 C22.4329966,6 24,7.56700338 24,9.5 C24,10.338203 23.7053502,11.1075869 23.2139772,11.7102249 C23.719599,12.8712053 24,14.1528571 24,15.5 C24,20.7467051 19.7467051,25 14.5,25 C9.25329488,25 5,20.7467051 5,15.5 C5,10.2532949 9.25329488,6 14.5,6 C15.8471429,6 17.1287947,6.28040098 18.2897751,6.78602275 Z M17.1504228,8.4817586 C16.3263581,8.17039236 15.4330777,8 14.5,8 C10.3578644,8 7,11.3578644 7,15.5 C7,19.6421356 10.3578644,23 14.5,23 C18.6421356,23 22,19.6421356 22,15.5 C22,14.5669223 21.8296076,13.6736419 21.5182414,12.8495772 C21.1960383,12.9473968 20.8541622,13 20.5,13 C18.5670034,13 17,11.4329966 17,9.5 C17,9.14583778 17.0526032,8.80396169 17.1504228,8.4817586 Z M14.5,17 C13.6715729,17 13,16.3284271 13,15.5 C13,14.6715729 13.6715729,14 14.5,14 C15.3284271,14 16,14.6715729 16,15.5 C16,16.3284271 15.3284271,17 14.5,17 Z M20.5,11 C21.3284271,11 22,10.3284271 22,9.5 C22,8.67157288 21.3284271,8 20.5,8 C19.6715729,8 19,8.67157288 19,9.5 C19,10.3284271 19.6715729,11 20.5,11 Z" id="path-1"></path>%0A    </defs>%0A    <g id="Symbols" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">%0A        <g id="Atoms/Icons/Tools/Circle" transform="translate(-3.000000, -3.000000)">%0A            <mask id="mask-2" fill="white">%0A                <use xlink:href="%23path-1"></use>%0A            </mask>%0A            <use id="Mask" fill="%235B5B5B" fill-rule="nonzero" xlink:href="%23path-1"></use>%0A            <g id="Atoms/Color/Grey" mask="url(%23mask-2)" fill="%235B5B5B">%0A                <rect id="Rectangle" x="0" y="0" width="30" height="30"></rect>%0A            </g>%0A        </g>%0A    </g>%0A</svg>\')}.leaflet-pm-toolbar .leaflet-pm-icon-circle-marker{background-image:url(\'data:image/svg+xml,<?xml version="1.0" encoding="UTF-8"?>%0A%0A<svg viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg" stroke="%235B5B5B" stroke-width="8"%0A     fill="none">%0A<circle cx="50" cy="50" r="35"/>%0A  <circle cx="50" cy="50" r="3" fill="%235B5B5B"/>%0A</svg>\')}.leaflet-pm-toolbar .leaflet-pm-icon-rectangle{background-image:url(\'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 24 24">%0A  <defs>%0A    <path id="rectangle-a" d="M23,10.9645556 L23,19.0354444 C24.6961471,19.2780593 26,20.736764 26,22.5 C26,24.4329966 24.4329966,26 22.5,26 C20.736764,26 19.2780593,24.6961471 19.0354444,23 L10.9645556,23 C10.7219407,24.6961471 9.26323595,26 7.5,26 C5.56700338,26 4,24.4329966 4,22.5 C4,20.736764 5.30385293,19.2780593 7,19.0354444 L7,10.9645556 C5.30385293,10.7219407 4,9.26323595 4,7.5 C4,5.56700338 5.56700338,4 7.5,4 C9.26323595,4 10.7219407,5.30385293 10.9645556,7 L19.0354444,7 C19.2780593,5.30385293 20.736764,4 22.5,4 C24.4329966,4 26,5.56700338 26,7.5 C26,9.26323595 24.6961471,10.7219407 23,10.9645556 Z M21,10.6631844 C20.272154,10.3174225 19.6825775,9.72784598 19.3368156,9 L10.6631844,9 C10.3174225,9.72784598 9.72784598,10.3174225 9,10.6631844 L9,19.3368156 C9.72784598,19.6825775 10.3174225,20.272154 10.6631844,21 L19.3368156,21 C19.6825775,20.272154 20.272154,19.6825775 21,19.3368156 L21,10.6631844 Z M7.5,9 C8.32842712,9 9,8.32842712 9,7.5 C9,6.67157288 8.32842712,6 7.5,6 C6.67157288,6 6,6.67157288 6,7.5 C6,8.32842712 6.67157288,9 7.5,9 Z M22.5,9 C23.3284271,9 24,8.32842712 24,7.5 C24,6.67157288 23.3284271,6 22.5,6 C21.6715729,6 21,6.67157288 21,7.5 C21,8.32842712 21.6715729,9 22.5,9 Z M22.5,24 C23.3284271,24 24,23.3284271 24,22.5 C24,21.6715729 23.3284271,21 22.5,21 C21.6715729,21 21,21.6715729 21,22.5 C21,23.3284271 21.6715729,24 22.5,24 Z M7.5,24 C8.32842712,24 9,23.3284271 9,22.5 C9,21.6715729 8.32842712,21 7.5,21 C6.67157288,21 6,21.6715729 6,22.5 C6,23.3284271 6.67157288,24 7.5,24 Z"/>%0A  </defs>%0A  <g fill="none" fill-rule="evenodd" transform="translate(-3 -3)">%0A    <mask id="rectangle-b" fill="%23fff">%0A      <use xlink:href="%23rectangle-a"/>%0A    </mask>%0A    <use fill="%235B5B5B" fill-rule="nonzero" xlink:href="%23rectangle-a"/>%0A    <g fill="%235B5B5B" mask="url(%23rectangle-b)">%0A      <rect width="30" height="30"/>%0A    </g>%0A  </g>%0A</svg>%0A\')}.leaflet-pm-toolbar .leaflet-pm-icon-delete{background-image:url(\'data:image/svg+xml,<?xml version="1.0" encoding="UTF-8"?>%0A<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">%0A    \x3c!-- Generator: Sketch 52.5 (67469) - http://www.bohemiancoding.com/sketch --\x3e%0A    <title>Atoms/Icons/Tools/Eraser</title>%0A    <desc>Created with Sketch.</desc>%0A    <defs>%0A        <path d="M17.7874219,18.4812552 L11.6480079,13.3498184 L6.40466009,19.3816001 L10.5539156,22.9884929 L13.86934,22.9884929 L17.7874219,18.4812552 Z M16.5074252,22.9884929 L26.0000002,22.9884929 L26.0000002,24.9884929 L10.0000002,24.9884929 L9.80708313,24.9884929 L5.09254204,20.8910192 C4.25891285,20.1663564 4.17057814,18.9031112 4.89524093,18.069482 L16.0482444,5.23941916 C16.7729072,4.40578998 18.0361525,4.31745526 18.8697816,5.04211806 L24.9074583,10.2905903 C25.7410875,11.0152531 25.8294222,12.2784983 25.1047594,13.1121275 L16.5074252,22.9884929 Z" id="path-1"></path>%0A    </defs>%0A    <g id="Symbols" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">%0A        <g id="Atoms/Icons/Tools/Eraser" transform="translate(-3.000000, -3.000000)">%0A            <mask id="mask-2" fill="white">%0A                <use xlink:href="%23path-1"></use>%0A            </mask>%0A            <use id="Combined-Shape" fill="%235B5B5B" fill-rule="nonzero" xlink:href="%23path-1"></use>%0A        </g>%0A    </g>%0A</svg>\')}.leaflet-pm-toolbar .leaflet-pm-icon-edit{background-image:url(\'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 24 24">%0A  <defs>%0A    <path id="edit_anchor-a" d="M13.5,11 C11.5670034,11 10,9.43299662 10,7.5 C10,5.56700338 11.5670034,4 13.5,4 C15.4329966,4 17,5.56700338 17,7.5 C17,9.43299662 15.4329966,11 13.5,11 Z M13.5,9 C14.3284271,9 15,8.32842712 15,7.5 C15,6.67157288 14.3284271,6 13.5,6 C12.6715729,6 12,6.67157288 12,7.5 C12,8.32842712 12.6715729,9 13.5,9 Z M12.0002889,7.52973893 C12.0125983,8.16273672 12.4170197,8.6996643 12.9807111,8.90767966 L3,15 L3,13 L12.0002889,7.52973893 Z M14.2172722,6.18228472 L19.453125,3 L22.6589355,3 L14.989102,7.68173885 C14.9962971,7.62216459 15,7.56151472 15,7.5 C15,6.93138381 14.6836098,6.4366645 14.2172722,6.18228472 Z M23.4434042,19.2851736 L20.1282799,19.2851736 L21.8729983,23.5349525 C21.9945296,23.8295773 21.8556546,24.1599209 21.5778734,24.2849208 L20.0414675,24.9545142 C19.7550613,25.0795141 19.4338738,24.9366704 19.3123426,24.6509518 L17.6544367,20.6154541 L14.9461873,23.4010151 C14.5852811,23.7721711 14,23.4860463 14,22.9992653 L14,9.57183533 C14,9.05933561 14.6225311,8.809492 14.946156,9.17008555 L23.8340292,18.3120179 C24.1925291,18.6613615 23.9279979,19.2851736 23.4434042,19.2851736 Z"/>%0A  </defs>%0A  <g fill="none" fill-rule="evenodd" transform="translate(-3 -3)">%0A    <mask id="edit_anchor-b" fill="%23fff">%0A      <use xlink:href="%23edit_anchor-a"/>%0A    </mask>%0A    <use fill="%235B5B5B" fill-rule="nonzero" xlink:href="%23edit_anchor-a"/>%0A    <g fill="%235B5B5B" mask="url(%23edit_anchor-b)">%0A      <rect width="30" height="30"/>%0A    </g>%0A  </g>%0A</svg>%0A\')}.leaflet-pm-toolbar .leaflet-pm-icon-drag{background-image:url(\'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 24 24">%0A  <defs>%0A    <path id="move-a" d="M21,14 L21,10 L27,15 L21,20 L21,16 L16,16 L16,21 L20,21 L15,27 L10,21 L14,21 L14,16 L9,16 L9,20 L3,15 L9,10 L9,14 L14,14 L14,9 L10,9 L15,3 L20,9 L16,9 L16,14 L21,14 Z"/>%0A  </defs>%0A  <g fill="none" fill-rule="evenodd" transform="translate(-3 -3)">%0A    <mask id="move-b" fill="%23fff">%0A      <use xlink:href="%23move-a"/>%0A    </mask>%0A    <use fill="%23D8D8D8" xlink:href="%23move-a"/>%0A    <g fill="%235B5B5B" mask="url(%23move-b)">%0A      <rect width="30" height="30"/>%0A    </g>%0A  </g>%0A</svg>%0A\')}.leaflet-pm-toolbar .leaflet-pm-icon-cut{background-image:url(\'data:image/svg+xml,<?xml version="1.0" encoding="UTF-8"?>%0A<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">%0A    \x3c!-- Generator: Sketch 52.5 (67469) - http://www.bohemiancoding.com/sketch --\x3e%0A    <title>Atoms/Icons/Tools/Scissors</title>%0A    <desc>Created with Sketch.</desc>%0A    <defs>%0A        <path d="M12.9691574,13.4939435 L21.0317032,5.54167013 L23.4649499,5.67722957 L17.0470713,14.5106816 L27.5660336,17.1333535 L25.7891944,18.8012588 L14.5854951,17.8987506 L13.6487955,19.188007 C13.794639,19.2650958 13.9367985,19.3534417 14.0741377,19.4532245 C15.6379648,20.5894114 15.9846357,22.7782052 14.8484488,24.3420324 C13.7122619,25.9058595 11.5234681,26.2525304 9.95964096,25.1163435 C8.39581384,23.9801565 8.04914296,21.7913627 9.18532986,20.2275356 C9.74587276,19.4560145 10.5626188,18.9807475 11.4341218,18.8336407 L12.6805656,17.1180579 L12.5239724,16.3747216 L11.9506932,15.3012391 L9.89310646,14.7882251 C9.13093796,15.2357261 8.19977854,15.3966447 7.27445355,15.1659352 C5.39887519,14.698301 4.25751094,12.7987519 4.72514515,10.9231736 C5.19277935,9.04759519 7.09232846,7.90623094 8.96790682,8.37386515 C10.8434852,8.84149935 11.9848494,10.7410485 11.5172152,12.6166268 C11.4761464,12.7813449 11.4240335,12.9404001 11.3618627,13.0931999 L12.9691574,13.4939435 Z M7.75829735,13.2253438 C8.56211664,13.4257584 9.37620912,12.9366023 9.57662378,12.132783 C9.77703844,11.3289637 9.28788233,10.5148713 8.48406303,10.3144566 C7.68024373,10.1140419 6.86615126,10.603198 6.6657366,11.4070173 C6.46532194,12.2108366 6.95447805,13.0249291 7.75829735,13.2253438 Z M10.8033639,21.4031061 C10.3164266,22.0733177 10.4649998,23.0113722 11.1352115,23.4983095 C11.8054231,23.9852467 12.7434776,23.8366735 13.2304148,23.1664619 C13.7173521,22.4962502 13.5687788,21.5581957 12.8985672,21.0712585 C12.2283556,20.5843212 11.2903011,20.7328945 10.8033639,21.4031061 Z" id="path-1"></path>%0A    </defs>%0A    <g id="Symbols" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">%0A        <g id="Atoms/Icons/Tools/Scissors" transform="translate(-3.000000, -3.000000)">%0A            <mask id="mask-2" fill="white">%0A                <use xlink:href="%23path-1"></use>%0A            </mask>%0A            <use id="Mask" fill="%235B5B5B" fill-rule="nonzero" transform="translate(16.093194, 15.663351) rotate(-32.000000) translate(-16.093194, -15.663351) " xlink:href="%23path-1"></use>%0A        </g>%0A    </g>%0A</svg>\')}.leaflet-pm-toolbar .leaflet-pm-icon-snapping{background-image:url(\'data:image/svg+xml,<?xml version="1.0" encoding="UTF-8"?>%0A<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">%0A    \x3c!-- Generator: Sketch 57.1 (83088) - https://sketch.com --\x3e%0A    <title>Atoms/Icons/Tools/Magnet</title>%0A    <desc>Created with Sketch.</desc>%0A    <defs>%0A        <path d="M21.9994759,10.9428183 L21.9999985,16.3710417 C22,16.6872007 22,17.0058278 22,17.3269411 C22,21.5646545 18.6421356,25 14.5,25 C10.3578644,25 7,21.5646545 7,17.3269411 L7.00087508,10.9907507 L11.0022808,10.9984125 C11.0017033,11.6980114 11.001247,12.4168248 11.0008992,13.1554887 L11,17.3269411 C11,19.3756809 12.5876841,21 14.5,21 C16.4123159,21 18,19.3756809 18,17.3269411 C18,15.0702032 17.9995696,12.9619668 17.998539,10.9910032 L21.9994759,10.9428183 Z M10,7 C10.5522847,7 11,7.44771525 11,8 L11,10 L7,10 L7,8 C7,7.44771525 7.44771525,7 8,7 L10,7 Z M21,7 C21.5522847,7 22,7.44771525 22,8 L22,10 L18,10 L18,8 C18,7.44771525 18.4477153,7 19,7 L21,7 Z" id="path-1"></path>%0A    </defs>%0A    <g id="Symbols" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">%0A        <g id="Atoms/Icons/Tools/Magnet" transform="translate(-3.000000, -3.000000)">%0A            <mask id="mask-2" fill="white">%0A                <use xlink:href="%23path-1"></use>%0A            </mask>%0A            <use id="Mask" fill="%235B5B5B" fill-rule="nonzero" transform="translate(14.500000, 16.000000) rotate(45.000000) translate(-14.500000, -16.000000) " xlink:href="%23path-1"></use>%0A        </g>%0A    </g>%0A</svg>\')}.leaflet-pm-toolbar .leaflet-pm-icon-rotate{background-image:url(\'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 24 24">%0A    <defs>%0A        <path id="rotate" d="M21.2,5.8c-0.1-0.2-0.2-0.3-0.3-0.5l-0.1-0.2c-0.1-0.2-0.2-0.3-0.3-0.5l-0.1-0.2c-0.1-0.2-0.2-0.3-0.4-0.5l-0.2-0.3l2.8-3.1L18,0.6l-4.6,0.1l0.5,4.5l0.5,4.5l3.2-3.6v0.1l0.1,0.2c0.1,0.1,0.1,0.2,0.2,0.2l0.1,0.2C18,7,18,7.1,18.1,7.2c0.3,0.7,0.6,1.4,0.7,2.1c0.2,1.4,0,2.9-0.6,4.2L18,13.9L17.9,14l-0.3,0.5l-0.1,0.2c-0.2,0.2-0.4,0.5-0.6,0.7c-0.5,0.5-1.1,1-1.7,1.3c-0.6,0.4-1.3,0.6-2.1,0.8c-0.7,0.1-1.5,0.2-2.2,0.1c-0.8-0.1-1.5-0.3-2.2-0.5c-0.7-0.3-1.3-0.7-1.9-1.2l-0.4-0.4l-0.2-0.3L6,15c-0.1-0.1-0.2-0.2-0.2-0.3l-0.3-0.4l-0.1-0.1l-0.2-0.4c0-0.1-0.1-0.1-0.1-0.2l-0.3-0.5l-0.1-0.2c-0.1-0.3-0.2-0.6-0.3-0.9c-0.2-0.8-0.3-1.6-0.3-2.4c0-0.2,0-0.3,0-0.5V8.9c0-0.2,0-0.3,0.1-0.4l0.1-0.6l0.2-0.6c0.3-0.8,0.7-1.5,1.2-2.2c0.5-0.7,1.1-1.3,1.8-1.8c0.2-0.1,0.3-0.4,0.1-0.6C7.5,2.6,7.4,2.5,7.3,2.5H7.1L7,2.6C6.1,3,5.4,3.6,4.7,4.2C4,4.9,3.5,5.7,3,6.6c-0.9,1.8-1.2,3.8-0.8,5.8c0.1,0.5,0.2,0.9,0.3,1.4l0.3,0.8C2.9,14.7,3,14.8,3,15l0.2,0.4c0,0.1,0.1,0.2,0.1,0.2l0.3,0.5c0.1,0.2,0.2,0.3,0.3,0.5l0.1,0.2c0.1,0.1,0.2,0.3,0.3,0.4L5,17.8c0.7,0.7,1.6,1.3,2.5,1.8c0.9,0.5,1.9,0.8,3,0.9c0.5,0.1,1,0.1,1.5,0.1c0.6,0,1.1,0,1.6-0.1c1-0.2,2.1-0.5,3-1l0.2-0.1c0.2-0.1,0.3-0.2,0.5-0.3l0.7-0.4c0.2-0.1,0.3-0.2,0.4-0.3l0.2-0.2c0.2-0.1,0.4-0.3,0.5-0.5l0.1-0.1c0.3-0.3,0.7-0.7,0.9-1l0.6-0.9l0.4-0.6c1-1.9,1.4-4.1,1.1-6.2C22,7.8,21.7,6.7,21.2,5.8z"/>%0A    </defs>%0A    <g fill="none" fill-rule="evenodd" transform="translate(0 2)">%0A        <mask id="rotate-b" fill="%23fff">%0A            <use xlink:href="%23rotate"/>%0A        </mask>%0A        <use fill="%235B5B5B" fill-rule="nonzero" xlink:href="%23rotate"/>%0A        <g fill="%235B5B5B" mask="url(%23rotate-b)">%0A            <rect width="30" height="30"/>%0A        </g>%0A    </g>%0A</svg>%0A\')}.leaflet-pm-toolbar .leaflet-pm-icon-text{background-image:url(\'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><defs><style>.cls-1{fill:none;stroke:%235b5b5b;stroke-linecap:round;stroke-linejoin:round;stroke-width:2.5px;}<\\/style></defs><title>Text</title><g id="Ebene_2" data-name="Ebene 2"><polyline class="cls-1" points="19.64 7.27 19.64 4 12 4 12 20 15.91 20 8.09 20 12 20 12 4 4.36 4 4.36 7.27"/></g></svg>\')}.leaflet-buttons-control-button:hover,.leaflet-buttons-control-button:focus{cursor:pointer;background-color:#f4f4f4}.active>.leaflet-buttons-control-button{box-shadow:inset 0 -1px 5px 2px #514d4d4f}.leaflet-buttons-control-text-hide{display:none}.button-container{position:relative}.button-container .leaflet-pm-actions-container{z-index:2;position:absolute;top:0;left:100%;display:none;white-space:nowrap;direction:ltr}.leaflet-right .leaflet-pm-toolbar .button-container .leaflet-pm-actions-container{right:100%;left:auto}.button-container.active .leaflet-pm-actions-container{display:block}.button-container .leaflet-pm-actions-container:not(.pos-right) a.leaflet-pm-action:last-child{border-radius:0 3px 3px 0;border-right:0}.button-container .leaflet-pm-actions-container.pos-right a.leaflet-pm-action:first-child{border-radius:3px 0 0 3px}.button-container .leaflet-pm-actions-container.pos-right a.leaflet-pm-action:last-child{border-right:0}.button-container .leaflet-pm-actions-container .leaflet-pm-action{padding:0 10px;background-color:#666;color:#fff;display:inline-block;width:auto;border-right:1px solid #eee;user-select:none;border-bottom:none;height:29px;line-height:29px}.leaflet-pm-toolbar .button-container:first-child.pos-right.active a.leaflet-buttons-control-button{border-top-left-radius:0}.leaflet-pm-toolbar .button-container:first-child.active:not(.pos-right) a.leaflet-buttons-control-button{border-top-right-radius:0}.button-container .leaflet-pm-actions-container .leaflet-pm-action:hover,.button-container .leaflet-pm-actions-container .leaflet-pm-action:focus{cursor:pointer;background-color:#777}.leaflet-pm-toolbar.activeChild{z-index:801}.leaflet-buttons-control-button.pm-disabled{background-color:#f4f4f4}.leaflet-buttons-control-button.pm-disabled>.control-icon{filter:opacity(.6)}\n',""]),t.exports=e},7362:(t,e,i)=>{var n=i(1364),r=i(3615),o=i(7024),s=i(8249),a=i(1071);e=n(!1);var l=r(o),h=r(s),c=r(a);e.push([t.id,"/* Default icon options */\n.leaflet-default-icon-icon {\n\tbackground-image: url("+l+"), url("+h+"); /* normal[, Retina] */\n\tcursor: url("+l+"), url("+h+"), auto; /* normal[, Retina], auto for compliance with cursor syntax */\n\twidth: 25px;\n\theight: 41px;\n\tmargin: -41px -12px; /* margin top and left to reversely position iconAnchor */\n\t}\n.leaflet-default-icon-shadow {\n\tbackground-image: url("+c+"); /* normal[, Retina] */\n\tcursor: url("+c+"), auto; /* normal[, Retina], auto */\n\twidth: 41px;\n\theight: 41px;\n\tmargin: -41px -12px; /* margin top and left to reversely position shadowAnchor */\n\t}\n.leaflet-default-icon-popup {\n\tmargin: -34px 1px; /* margin top and left to position popupAnchor */\n\t}\n.leaflet-default-icon-tooltip {\n\tmargin: -28px 16px; /* margin top and left to position tooltipAnchor, even if direction 'bottom' or 'right' */\n\t}\n",""]),t.exports=e},6080:(t,e,i)=>{var n=i(1364),r=i(3615),o=i(2223),s=i(5200),a=i(8304);e=n(!1);var l=r(o),h=r(s),c=r(a);e.push([t.id,".leaflet-draw-section{position:relative}.leaflet-draw-toolbar{margin-top:12px}.leaflet-draw-toolbar-top{margin-top:0}.leaflet-draw-toolbar-notop a:first-child{border-top-right-radius:0}.leaflet-draw-toolbar-nobottom a:last-child{border-bottom-right-radius:0}.leaflet-draw-toolbar a{background-image:url("+l+");background-image:linear-gradient(transparent,transparent),url("+h+");background-repeat:no-repeat;background-size:300px 30px;background-clip:padding-box}.leaflet-retina .leaflet-draw-toolbar a{background-image:url("+c+");background-image:linear-gradient(transparent,transparent),url("+h+')}\n.leaflet-draw a{display:block;text-align:center;text-decoration:none}.leaflet-draw a .sr-only{position:absolute;width:1px;height:1px;padding:0;margin:-1px;overflow:hidden;clip:rect(0,0,0,0);border:0}.leaflet-draw-actions{display:none;list-style:none;margin:0;padding:0;position:absolute;left:26px;top:0;white-space:nowrap}.leaflet-touch .leaflet-draw-actions{left:32px}.leaflet-right .leaflet-draw-actions{right:26px;left:auto}.leaflet-touch .leaflet-right .leaflet-draw-actions{right:32px;left:auto}.leaflet-draw-actions li{display:inline-block}\n.leaflet-draw-actions li:first-child a{border-left:0}.leaflet-draw-actions li:last-child a{-webkit-border-radius:0 4px 4px 0;border-radius:0 4px 4px 0}.leaflet-right .leaflet-draw-actions li:last-child a{-webkit-border-radius:0;border-radius:0}.leaflet-right .leaflet-draw-actions li:first-child a{-webkit-border-radius:4px 0 0 4px;border-radius:4px 0 0 4px}.leaflet-draw-actions a{background-color:#919187;border-left:1px solid #AAA;color:#FFF;font:11px/19px "Helvetica Neue",Arial,Helvetica,sans-serif;line-height:28px;text-decoration:none;padding-left:10px;padding-right:10px;height:28px}\n.leaflet-touch .leaflet-draw-actions a{font-size:12px;line-height:30px;height:30px}.leaflet-draw-actions-bottom{margin-top:0}.leaflet-draw-actions-top{margin-top:1px}.leaflet-draw-actions-top a,.leaflet-draw-actions-bottom a{height:27px;line-height:27px}.leaflet-draw-actions a:hover{background-color:#a0a098}.leaflet-draw-actions-top.leaflet-draw-actions-bottom a{height:26px;line-height:26px}.leaflet-draw-toolbar .leaflet-draw-draw-polyline{background-position:-2px -2px}.leaflet-touch .leaflet-draw-toolbar .leaflet-draw-draw-polyline{background-position:0 -1px}\n.leaflet-draw-toolbar .leaflet-draw-draw-polygon{background-position:-31px -2px}.leaflet-touch .leaflet-draw-toolbar .leaflet-draw-draw-polygon{background-position:-29px -1px}.leaflet-draw-toolbar .leaflet-draw-draw-rectangle{background-position:-62px -2px}.leaflet-touch .leaflet-draw-toolbar .leaflet-draw-draw-rectangle{background-position:-60px -1px}.leaflet-draw-toolbar .leaflet-draw-draw-circle{background-position:-92px -2px}.leaflet-touch .leaflet-draw-toolbar .leaflet-draw-draw-circle{background-position:-90px -1px}\n.leaflet-draw-toolbar .leaflet-draw-draw-marker{background-position:-122px -2px}.leaflet-touch .leaflet-draw-toolbar .leaflet-draw-draw-marker{background-position:-120px -1px}.leaflet-draw-toolbar .leaflet-draw-draw-circlemarker{background-position:-273px -2px}.leaflet-touch .leaflet-draw-toolbar .leaflet-draw-draw-circlemarker{background-position:-271px -1px}.leaflet-draw-toolbar .leaflet-draw-edit-edit{background-position:-152px -2px}.leaflet-touch .leaflet-draw-toolbar .leaflet-draw-edit-edit{background-position:-150px -1px}\n.leaflet-draw-toolbar .leaflet-draw-edit-remove{background-position:-182px -2px}.leaflet-touch .leaflet-draw-toolbar .leaflet-draw-edit-remove{background-position:-180px -1px}.leaflet-draw-toolbar .leaflet-draw-edit-edit.leaflet-disabled{background-position:-212px -2px}.leaflet-touch .leaflet-draw-toolbar .leaflet-draw-edit-edit.leaflet-disabled{background-position:-210px -1px}.leaflet-draw-toolbar .leaflet-draw-edit-remove.leaflet-disabled{background-position:-242px -2px}.leaflet-touch .leaflet-draw-toolbar .leaflet-draw-edit-remove.leaflet-disabled{background-position:-240px -2px}\n.leaflet-mouse-marker{background-color:#fff;cursor:crosshair}.leaflet-draw-tooltip{background:#363636;background:rgba(0,0,0,0.5);border:1px solid transparent;-webkit-border-radius:4px;border-radius:4px;color:#fff;font:12px/18px "Helvetica Neue",Arial,Helvetica,sans-serif;margin-left:20px;margin-top:-21px;padding:4px 8px;position:absolute;visibility:hidden;white-space:nowrap;z-index:6}.leaflet-draw-tooltip:before{border-right:6px solid black;border-right-color:rgba(0,0,0,0.5);border-top:6px solid transparent;border-bottom:6px solid transparent;content:"";position:absolute;top:7px;left:-7px}\n.leaflet-error-draw-tooltip{background-color:#f2dede;border:1px solid #e6b6bd;color:#b94a48}.leaflet-error-draw-tooltip:before{border-right-color:#e6b6bd}.leaflet-draw-tooltip-single{margin-top:-12px}.leaflet-draw-tooltip-subtext{color:#f8d5e4}.leaflet-draw-guide-dash{font-size:1%;opacity:.6;position:absolute;width:5px;height:5px}.leaflet-edit-marker-selected{background-color:rgba(254,87,161,0.1);border:4px dashed rgba(254,87,161,0.6);-webkit-border-radius:4px;border-radius:4px;box-sizing:content-box}\n.leaflet-edit-move{cursor:move}.leaflet-edit-resize{cursor:pointer}.leaflet-oldie .leaflet-draw-toolbar{border:1px solid #999}',""]),t.exports=e},6328:(t,e,i)=>{var n=i(1364),r=i(3615),o=i(9766),s=i(6622);e=n(!1);var a=r(o),l=r(s);e.push([t.id,".leaflet-control-fullscreen a {\n  background:#fff url("+a+") no-repeat 0 0;\n  background-size:26px 52px;\n  }\n  .leaflet-touch .leaflet-control-fullscreen a {\n    background-position: 2px 2px;\n    }\n  .leaflet-fullscreen-on .leaflet-control-fullscreen a {\n    background-position:0 -26px;\n    }\n  .leaflet-touch.leaflet-fullscreen-on .leaflet-control-fullscreen a {\n    background-position: 2px -24px;\n    }\n\n/* Do not combine these two rules; IE will break. */\n.leaflet-container:-webkit-full-screen {\n  width:100%!important;\n  height:100%!important;\n  }\n.leaflet-container.leaflet-fullscreen-on {\n  width:100%!important;\n  height:100%!important;\n  }\n\n.leaflet-pseudo-fullscreen {\n  position:fixed!important;\n  width:100%!important;\n  height:100%!important;\n  top:0!important;\n  left:0!important;\n  z-index:99999;\n  }\n\n@media\n  (-webkit-min-device-pixel-ratio:2),\n  (min-resolution:192dpi) {\n    .leaflet-control-fullscreen a {\n      background-image:url("+l+");\n    }\n  }\n",""]),t.exports=e},9499:(t,e,i)=>{var n=i(1364),r=i(3615),o=i(9155),s=i(9852),a=i(6630),l=i(1133),h=i(2434),c=i(5953),u=i(1558),d=i(9181),p=i(4994),f=i(9393),m=i(9884),g=i(2387);e=n(!1);var _=r(o),y=r(s),v=r(a),b=r(l),x=r(h),w=r(c),L=r(u),M=r(d),k=r(p),C=r(f),A=r(m),P=r(g);e.push([t.id,".leaflet-control-measure h3,.leaflet-measure-resultpopup h3{margin:0 0 12px;padding-bottom:10px;border-bottom:1px solid #ddd}.leaflet-control-measure p,.leaflet-measure-resultpopup p{margin:10px 0 0;line-height:1.5em}.leaflet-control-measure p:first-child,.leaflet-measure-resultpopup p:first-child{margin-top:0}.leaflet-control-measure .tasks,.leaflet-measure-resultpopup .tasks{margin:12px 0 0;padding:10px 0 0;border-top:1px solid #ddd;text-align:right;list-style:none;list-style-image:none}.leaflet-control-measure .tasks li,.leaflet-measure-resultpopup .tasks li{display:inline;margin:0 10px 0 0}.leaflet-control-measure .tasks li:last-child,.leaflet-measure-resultpopup .tasks li:last-child{margin-right:0}.leaflet-control-measure .coorddivider,.leaflet-measure-resultpopup .coorddivider{color:#999}.leaflet-control-measure{max-width:280px;background:#fff}.leaflet-control-measure .leaflet-control-measure-toggle,.leaflet-control-measure .leaflet-control-measure-toggle:hover{background-size:14px 14px;background-image:url("+_+");border:0;border-radius:4px;text-indent:100%;white-space:nowrap;overflow:hidden}.leaflet-touch .leaflet-control-measure .leaflet-control-measure-toggle,.leaflet-touch .leaflet-control-measure .leaflet-control-measure-toggle:hover{border-radius:2px}.leaflet-retina .leaflet-control-measure .leaflet-control-measure-toggle,.leaflet-retina .leaflet-control-measure .leaflet-control-measure-toggle:hover{background-image:url("+y+")}.leaflet-touch .leaflet-control-measure .leaflet-control-measure-toggle,.leaflet-touch .leaflet-control-measure .leaflet-control-measure-toggle:hover{background-size:16px 16px}.leaflet-control-measure .startprompt h3{margin-bottom:10px}.leaflet-control-measure .startprompt .tasks{margin-top:0;padding-top:0;border-top:0;text-align:left}.leaflet-control-measure .leaflet-control-measure-interaction{padding:10px 12px}.leaflet-control-measure .results .group{margin-top:10px;padding-top:10px;border-top:1px dotted #eaeaea}.leaflet-control-measure .results .group:first-child{margin-top:0;padding-top:0;border-top:0}.leaflet-control-measure .results .heading{margin-right:5px;color:#999}.leaflet-control-measure a.start{display:inline;width:auto;height:auto;padding-left:20px;margin-right:4px;line-height:1em;border:0;text-align:left;background-image:url("+v+");background-repeat:no-repeat;background-position:0 50%;background-size:12px 12px;color:#5e66cc;text-decoration:none}.leaflet-control-measure a.start,.leaflet-control-measure a.start:hover{background-color:transparent}.leaflet-retina .leaflet-control-measure a.start{background-image:url("+b+")}.leaflet-control-measure a.start:hover{opacity:.5;text-decoration:none}.leaflet-control-measure a.cancel{display:inline;width:auto;height:auto;padding-left:20px;margin-right:4px;line-height:1em;border:0;text-align:left;background-image:url("+x+");background-repeat:no-repeat;background-position:0 50%;background-size:12px 12px;color:#5e66cc;text-decoration:none}.leaflet-control-measure a.cancel,.leaflet-control-measure a.cancel:hover{background-color:transparent}.leaflet-retina .leaflet-control-measure a.cancel{background-image:url("+w+")}.leaflet-control-measure a.cancel:hover{opacity:.5;text-decoration:none}.leaflet-control-measure a.finish{display:inline;width:auto;height:auto;padding-left:20px;margin-right:4px;line-height:1em;border:0;text-align:left;background-image:url("+L+");background-repeat:no-repeat;background-position:0 50%;background-size:12px 12px;color:#5e66cc;text-decoration:none}.leaflet-control-measure a.finish,.leaflet-control-measure a.finish:hover{background-color:transparent}.leaflet-retina .leaflet-control-measure a.finish{background-image:url("+M+")}.leaflet-control-measure a.finish:hover{opacity:.5;text-decoration:none}.leaflet-measure-resultpopup a.zoomto{display:inline;width:auto;height:auto;padding-left:20px;margin-right:4px;line-height:1em;border:0;text-align:left;background-image:url("+k+");background-repeat:no-repeat;background-position:0 50%;background-size:12px 12px;color:#5e66cc;text-decoration:none}.leaflet-measure-resultpopup a.zoomto,.leaflet-measure-resultpopup a.zoomto:hover{background-color:transparent}.leaflet-retina .leaflet-measure-resultpopup a.zoomto{background-image:url("+C+")}.leaflet-measure-resultpopup a.zoomto:hover{opacity:.5;text-decoration:none}.leaflet-measure-resultpopup a.deletemarkup{display:inline;width:auto;height:auto;padding-left:20px;margin-right:4px;line-height:1em;border:0;text-align:left;background-image:url("+A+");background-repeat:no-repeat;background-position:0 50%;background-size:12px 12px;color:#5e66cc;text-decoration:none}.leaflet-measure-resultpopup a.deletemarkup,.leaflet-measure-resultpopup a.deletemarkup:hover{background-color:transparent}.leaflet-retina .leaflet-measure-resultpopup a.deletemarkup{background-image:url("+P+")}.leaflet-measure-resultpopup a.deletemarkup:hover{opacity:.5;text-decoration:none}",""]),t.exports=e},3867:(t,e,i)=>{var n=i(1364),r=i(3615),o=i(7590),s=i(5784);e=n(!1);var a=r(o),l=r(s);e.push([t.id,"/* \n * Leaflet Control Search v2.9.7 - 2019-01-14 \n * \n * Copyright 2019 Stefano Cudini \n * stefano.cudini@gmail.com \n * http://labs.easyblog.it/ \n * \n * Licensed under the MIT license. \n * \n * Demo: \n * http://labs.easyblog.it/maps/leaflet-search/ \n * \n * Source: \n * git@github.com:stefanocudini/leaflet-search.git \n * \n */\n \n.leaflet-container .leaflet-control-search {\n\tposition:relative;\n\tfloat:left;\n\tbackground:#fff;\n\tcolor:#1978cf;\n\tborder: 2px solid rgba(0,0,0,0.2);\n\tbackground-clip: padding-box;\n\t-moz-border-radius: 4px;\n\t-webkit-border-radius: 4px;\n\tborder-radius: 4px;\n\tbackground-color: rgba(255, 255, 255, 0.8);\n\tz-index:1000;\t\n\tmargin-left: 10px;\n\tmargin-top: 10px;\n}\n.leaflet-control-search.search-exp {/*expanded*/\n\tbackground: #fff;\n\tborder: 2px solid rgba(0,0,0,0.2);\n\tbackground-clip: padding-box;\t\n}\n.leaflet-control-search .search-input {\n\tdisplay:block;\n\tfloat:left;\n\tbackground: #fff;\n\tborder:1px solid #666;\n\tborder-radius:2px;\n\theight:22px;\n\tpadding:0 20px 0 2px;\n\tmargin:4px 0 4px 4px;\n}\n.leaflet-control-search.search-load .search-input {\n\tbackground: url("+a+") no-repeat center right #fff;\n}\n.leaflet-control-search.search-load .search-cancel {\n\tvisibility:hidden;\n}\n.leaflet-control-search .search-cancel {\n\tdisplay:block;\n\twidth:22px;\n\theight:22px;\n\tposition:absolute;\n\tright:28px;\n\tmargin:6px 0;\n\tbackground: url("+l+") no-repeat 0 -46px;\n\ttext-decoration:none;\n\tfilter: alpha(opacity=80);\n\topacity: 0.8;\t\t\n}\n.leaflet-control-search .search-cancel:hover {\n\tfilter: alpha(opacity=100);\n\topacity: 1;\n}\n.leaflet-control-search .search-cancel span {\n\tdisplay:none;/* comment for cancel button imageless */\n\tfont-size:18px;\n\tline-height:20px;\n\tcolor:#ccc;\n\tfont-weight:bold;\n}\n.leaflet-control-search .search-cancel:hover span {\n\tcolor:#aaa;\n}\n.leaflet-control-search .search-button {\n\tdisplay:block;\n\tfloat:left;\n\twidth:30px;\n\theight:30px;\t\n\tbackground: url("+l+") no-repeat 4px 4px #fff;\n\tborder-radius:4px;\n}\n.leaflet-control-search .search-button:hover {\n\tbackground: url("+l+") no-repeat 4px -20px #fafafa;\n}\n.leaflet-control-search .search-tooltip {\n\tposition:absolute;\n\ttop:100%;\n\tleft:0;\n\tfloat:left;\n\tlist-style: none;\n\tpadding-left: 0;\n\tmin-width:120px;\n\tmax-height:122px;\n\tbox-shadow: 1px 1px 6px rgba(0,0,0,0.4);\n\tbackground-color: rgba(0, 0, 0, 0.25);\n\tz-index:1010;\n\toverflow-y:auto;\n\toverflow-x:hidden;\n\tcursor: pointer;\n}\n.leaflet-control-search .search-tip {\n\tmargin:2px;\n\tpadding:2px 4px;\n\tdisplay:block;\n\tcolor:black;\n\tbackground: #eee;\n\tborder-radius:.25em;\n\ttext-decoration:none;\t\n\twhite-space:nowrap;\n\tvertical-align:center;\n}\n.leaflet-control-search .search-button:hover {\n\tbackground-color: #f4f4f4;\n}\n.leaflet-control-search .search-tip-select,\n.leaflet-control-search .search-tip:hover {\n\tbackground-color: #fff;\n}\n.leaflet-control-search .search-alert {\n\tcursor:pointer;\n\tclear:both;\n\tfont-size:.75em;\n\tmargin-bottom:5px;\n\tpadding:0 .25em;\n\tcolor:#e00;\n\tfont-weight:bold;\n\tborder-radius:.25em;\n}\n\n\n",""]),t.exports=e},3759:(t,e,i)=>{(e=i(1364)(!1)).push([t.id,".leaflet-sbs-range {\n    position: absolute;\n    top: 50%;\n    width: 100%;\n    z-index: 999;\n}\n.leaflet-sbs-divider {\n    position: absolute;\n    top: 0;\n    bottom: 0;\n    left: 50%;\n    margin-left: -2px;\n    width: 4px;\n    background-color: #fff;\n    pointer-events: none;\n    z-index: 999;\n}\n",""]),t.exports=e},8570:(t,e,i)=>{var n=i(1364),r=i(3615),o=i(7717);e=n(!1);var s=r(o);e.push([t.id,".leaflet-sbs-range {\n    -webkit-appearance: none;\n    display: inline-block!important;\n    vertical-align: middle;\n    height: 0;\n    padding: 0;\n    margin: 0;\n    border: 0;\n    background: rgba(0, 0, 0, 0.25);\n    min-width: 100px;\n    cursor: pointer;\n    pointer-events: none;\n    z-index: 999;\n}\n.leaflet-sbs-range::-ms-fill-upper {\n    background: transparent;\n}\n.leaflet-sbs-range::-ms-fill-lower {\n    background: rgba(255, 255, 255, 0.25);\n}\n/* Browser thingies */\n\n.leaflet-sbs-range::-moz-range-track {\n    opacity: 0;\n}\n.leaflet-sbs-range::-ms-track {\n    opacity: 0;\n}\n.leaflet-sbs-range::-ms-tooltip {\n    display: none;\n}\n/* For whatever reason, these need to be defined\n * on their own so dont group them */\n\n.leaflet-sbs-range::-webkit-slider-thumb {\n    -webkit-appearance: none;\n    margin: 0;\n    padding: 0;\n    background: #fff;\n    height: 40px;\n    width: 40px;\n    border-radius: 20px;\n    cursor: ew-resize;\n    pointer-events: auto;\n    border: 1px solid #ddd;\n    background-image: url("+s+");\n    background-position: 50% 50%;\n    background-repeat: no-repeat;\n    background-size: 40px 40px;\n}\n.leaflet-sbs-range::-ms-thumb {\n    margin: 0;\n    padding: 0;\n    background: #fff;\n    height: 40px;\n    width: 40px;\n    border-radius: 20px;\n    cursor: ew-resize;\n    pointer-events: auto;\n    border: 1px solid #ddd;\n    background-image: url("+s+");\n    background-position: 50% 50%;\n    background-repeat: no-repeat;\n    background-size: 40px 40px;\n}\n.leaflet-sbs-range::-moz-range-thumb {\n    padding: 0;\n    right: 0    ;\n    background: #fff;\n    height: 40px;\n    width: 40px;\n    border-radius: 20px;\n    cursor: ew-resize;\n    pointer-events: auto;\n    border: 1px solid #ddd;\n    background-image: url("+s+");\n    background-position: 50% 50%;\n    background-repeat: no-repeat;\n    background-size: 40px 40px;\n}\n.leaflet-sbs-range:disabled::-moz-range-thumb {\n    cursor: default;\n}\n.leaflet-sbs-range:disabled::-ms-thumb {\n    cursor: default;\n}\n.leaflet-sbs-range:disabled::-webkit-slider-thumb {\n    cursor: default;\n}\n.leaflet-sbs-range:disabled {\n    cursor: default;\n}\n.leaflet-sbs-range:focus {\n    outline: none!important;\n}\n.leaflet-sbs-range::-moz-focus-outer {\n    border: 0;\n}\n\n",""]),t.exports=e},2243:(t,e,i)=>{var n=i(1364),r=i(3615),o=i(6111),s=i(3419),a=i(2369),l=i(7669);e=n(!1);var h=r(o),c=r(s),u=r(a),d=r(l);e.push([t.id,"/*\nAuthor: L. Voogdt\nLicense: MIT\nVersion: 1.0\n*/\n\n/* Marker setup */\n.awesome-marker {\n  background: url("+h+") no-repeat 0 0;\n  width: 35px;\n  height: 46px;\n  position:absolute;\n  left:0;\n  top:0;\n  display: block;\n  text-align: center;\n}\n\n.awesome-marker-shadow {\n  background: url("+c+") no-repeat 0 0;\n  width: 36px;\n  height: 16px;\n}\n\n/* Retina displays */\n@media (min--moz-device-pixel-ratio: 1.5),(-o-min-device-pixel-ratio: 3/2),\n(-webkit-min-device-pixel-ratio: 1.5),(min-device-pixel-ratio: 1.5),(min-resolution: 1.5dppx) {\n .awesome-marker {\n  background-image: url("+u+");\n  background-size: 720px 92px;\n }\n .awesome-marker-shadow {\n  background-image: url("+d+");\n  background-size: 35px 16px;\n }\n}\n\n.awesome-marker i {\n  color: #333;\n  margin-top: 10px;\n  display: inline-block;\n  font-size: 14px;\n}\n\n.awesome-marker .icon-white {\n  color: #fff;\n}\n\n/* Colors */\n.awesome-marker-icon-red {\n  background-position: 0 0;\n}\n\n.awesome-marker-icon-darkred {\n  background-position: -180px 0;\n}\n\n.awesome-marker-icon-lightred {\n  background-position: -360px 0;\n}\n\n.awesome-marker-icon-orange {\n  background-position: -36px 0;\n}\n\n.awesome-marker-icon-beige {\n  background-position: -396px 0;\n}\n\n.awesome-marker-icon-green {\n  background-position: -72px 0;\n}\n\n.awesome-marker-icon-darkgreen {\n  background-position: -252px 0;\n}\n\n.awesome-marker-icon-lightgreen {\n  background-position: -432px 0;\n}\n\n.awesome-marker-icon-blue {\n  background-position: -108px 0;\n}\n\n.awesome-marker-icon-darkblue {\n  background-position: -216px 0;\n}\n\n.awesome-marker-icon-lightblue {\n  background-position: -468px 0;\n}\n\n.awesome-marker-icon-purple {\n  background-position: -144px 0;\n}\n\n.awesome-marker-icon-darkpurple {\n  background-position: -288px 0;\n}\n\n.awesome-marker-icon-pink {\n  background-position: -504px 0;\n}\n\n.awesome-marker-icon-cadetblue {\n  background-position: -324px 0;\n}\n\n.awesome-marker-icon-white {\n  background-position: -574px 0;\n}\n\n.awesome-marker-icon-gray {\n  background-position: -648px 0;\n}\n\n.awesome-marker-icon-lightgray {\n  background-position: -612px 0;\n}\n\n.awesome-marker-icon-black {\n  background-position: -682px 0;\n}\n\n.awesome-marker-square {\n  background-position-y: -46px;\n}\n",""]),t.exports=e},3277:(t,e,i)=>{(e=i(1364)(!1)).push([t.id,'.marker-cluster-small {\n\tbackground-color: rgba(181, 226, 140, 0.6);\n\t}\n.marker-cluster-small div {\n\tbackground-color: rgba(110, 204, 57, 0.6);\n\t}\n\n.marker-cluster-medium {\n\tbackground-color: rgba(241, 211, 87, 0.6);\n\t}\n.marker-cluster-medium div {\n\tbackground-color: rgba(240, 194, 12, 0.6);\n\t}\n\n.marker-cluster-large {\n\tbackground-color: rgba(253, 156, 115, 0.6);\n\t}\n.marker-cluster-large div {\n\tbackground-color: rgba(241, 128, 23, 0.6);\n\t}\n\n\t/* IE 6-8 fallback colors */\n.leaflet-oldie .marker-cluster-small {\n\tbackground-color: rgb(181, 226, 140);\n\t}\n.leaflet-oldie .marker-cluster-small div {\n\tbackground-color: rgb(110, 204, 57);\n\t}\n\n.leaflet-oldie .marker-cluster-medium {\n\tbackground-color: rgb(241, 211, 87);\n\t}\n.leaflet-oldie .marker-cluster-medium div {\n\tbackground-color: rgb(240, 194, 12);\n\t}\n\n.leaflet-oldie .marker-cluster-large {\n\tbackground-color: rgb(253, 156, 115);\n\t}\n.leaflet-oldie .marker-cluster-large div {\n\tbackground-color: rgb(241, 128, 23);\n}\n\n.marker-cluster {\n\tbackground-clip: padding-box;\n\tborder-radius: 20px;\n\t}\n.marker-cluster div {\n\twidth: 30px;\n\theight: 30px;\n\tmargin-left: 5px;\n\tmargin-top: 5px;\n\n\ttext-align: center;\n\tborder-radius: 15px;\n\tfont: 12px "Helvetica Neue", Arial, Helvetica, sans-serif;\n\t}\n.marker-cluster span {\n\tline-height: 30px;\n\t}',""]),t.exports=e},8968:(t,e,i)=>{(e=i(1364)(!1)).push([t.id,".leaflet-cluster-anim .leaflet-marker-icon, .leaflet-cluster-anim .leaflet-marker-shadow {\n\t-webkit-transition: -webkit-transform 0.3s ease-out, opacity 0.3s ease-in;\n\t-moz-transition: -moz-transform 0.3s ease-out, opacity 0.3s ease-in;\n\t-o-transition: -o-transform 0.3s ease-out, opacity 0.3s ease-in;\n\ttransition: transform 0.3s ease-out, opacity 0.3s ease-in;\n}\n\n.leaflet-cluster-spider-leg {\n\t/* stroke-dashoffset (duration and function) should match with leaflet-marker-icon transform in order to track it exactly */\n\t-webkit-transition: -webkit-stroke-dashoffset 0.3s ease-out, -webkit-stroke-opacity 0.3s ease-in;\n\t-moz-transition: -moz-stroke-dashoffset 0.3s ease-out, -moz-stroke-opacity 0.3s ease-in;\n\t-o-transition: -o-stroke-dashoffset 0.3s ease-out, -o-stroke-opacity 0.3s ease-in;\n\ttransition: stroke-dashoffset 0.3s ease-out, stroke-opacity 0.3s ease-in;\n}\n",""]),t.exports=e},1081:(t,e,i)=>{var n=i(1364),r=i(3615),o=i(4648),s=i(6577),a=i(7024);e=n(!1);var l=r(o),h=r(s),c=r(a);e.push([t.id,"/* required styles */\r\n\r\n.leaflet-pane,\r\n.leaflet-tile,\r\n.leaflet-marker-icon,\r\n.leaflet-marker-shadow,\r\n.leaflet-tile-container,\r\n.leaflet-pane > svg,\r\n.leaflet-pane > canvas,\r\n.leaflet-zoom-box,\r\n.leaflet-image-layer,\r\n.leaflet-layer {\r\n\tposition: absolute;\r\n\tleft: 0;\r\n\ttop: 0;\r\n\t}\r\n.leaflet-container {\r\n\toverflow: hidden;\r\n\t}\r\n.leaflet-tile,\r\n.leaflet-marker-icon,\r\n.leaflet-marker-shadow {\r\n\t-webkit-user-select: none;\r\n\t   -moz-user-select: none;\r\n\t        user-select: none;\r\n\t  -webkit-user-drag: none;\r\n\t}\r\n/* Prevents IE11 from highlighting tiles in blue */\r\n.leaflet-tile::selection {\r\n\tbackground: transparent;\r\n}\r\n/* Safari renders non-retina tile on retina better with this, but Chrome is worse */\r\n.leaflet-safari .leaflet-tile {\r\n\timage-rendering: -webkit-optimize-contrast;\r\n\t}\r\n/* hack that prevents hw layers \"stretching\" when loading new tiles */\r\n.leaflet-safari .leaflet-tile-container {\r\n\twidth: 1600px;\r\n\theight: 1600px;\r\n\t-webkit-transform-origin: 0 0;\r\n\t}\r\n.leaflet-marker-icon,\r\n.leaflet-marker-shadow {\r\n\tdisplay: block;\r\n\t}\r\n/* .leaflet-container svg: reset svg max-width decleration shipped in Joomla! (joomla.org) 3.x */\r\n/* .leaflet-container img: map is broken in FF if you have max-width: 100% on tiles */\r\n.leaflet-container .leaflet-overlay-pane svg {\r\n\tmax-width: none !important;\r\n\tmax-height: none !important;\r\n\t}\r\n.leaflet-container .leaflet-marker-pane img,\r\n.leaflet-container .leaflet-shadow-pane img,\r\n.leaflet-container .leaflet-tile-pane img,\r\n.leaflet-container img.leaflet-image-layer,\r\n.leaflet-container .leaflet-tile {\r\n\tmax-width: none !important;\r\n\tmax-height: none !important;\r\n\twidth: auto;\r\n\tpadding: 0;\r\n\t}\r\n\r\n.leaflet-container img.leaflet-tile {\r\n\t/* See: https://bugs.chromium.org/p/chromium/issues/detail?id=600120 */\r\n\tmix-blend-mode: plus-lighter;\r\n}\r\n\r\n.leaflet-container.leaflet-touch-zoom {\r\n\t-ms-touch-action: pan-x pan-y;\r\n\ttouch-action: pan-x pan-y;\r\n\t}\r\n.leaflet-container.leaflet-touch-drag {\r\n\t-ms-touch-action: pinch-zoom;\r\n\t/* Fallback for FF which doesn't support pinch-zoom */\r\n\ttouch-action: none;\r\n\ttouch-action: pinch-zoom;\r\n}\r\n.leaflet-container.leaflet-touch-drag.leaflet-touch-zoom {\r\n\t-ms-touch-action: none;\r\n\ttouch-action: none;\r\n}\r\n.leaflet-container {\r\n\t-webkit-tap-highlight-color: transparent;\r\n}\r\n.leaflet-container a {\r\n\t-webkit-tap-highlight-color: rgba(51, 181, 229, 0.4);\r\n}\r\n.leaflet-tile {\r\n\tfilter: inherit;\r\n\tvisibility: hidden;\r\n\t}\r\n.leaflet-tile-loaded {\r\n\tvisibility: inherit;\r\n\t}\r\n.leaflet-zoom-box {\r\n\twidth: 0;\r\n\theight: 0;\r\n\t-moz-box-sizing: border-box;\r\n\t     box-sizing: border-box;\r\n\tz-index: 800;\r\n\t}\r\n/* workaround for https://bugzilla.mozilla.org/show_bug.cgi?id=888319 */\r\n.leaflet-overlay-pane svg {\r\n\t-moz-user-select: none;\r\n\t}\r\n\r\n.leaflet-pane         { z-index: 400; }\r\n\r\n.leaflet-tile-pane    { z-index: 200; }\r\n.leaflet-overlay-pane { z-index: 400; }\r\n.leaflet-shadow-pane  { z-index: 500; }\r\n.leaflet-marker-pane  { z-index: 600; }\r\n.leaflet-tooltip-pane   { z-index: 650; }\r\n.leaflet-popup-pane   { z-index: 700; }\r\n\r\n.leaflet-map-pane canvas { z-index: 100; }\r\n.leaflet-map-pane svg    { z-index: 200; }\r\n\r\n.leaflet-vml-shape {\r\n\twidth: 1px;\r\n\theight: 1px;\r\n\t}\r\n.lvml {\r\n\tbehavior: url(#default#VML);\r\n\tdisplay: inline-block;\r\n\tposition: absolute;\r\n\t}\r\n\r\n\r\n/* control positioning */\r\n\r\n.leaflet-control {\r\n\tposition: relative;\r\n\tz-index: 800;\r\n\tpointer-events: visiblePainted; /* IE 9-10 doesn't have auto */\r\n\tpointer-events: auto;\r\n\t}\r\n.leaflet-top,\r\n.leaflet-bottom {\r\n\tposition: absolute;\r\n\tz-index: 1000;\r\n\tpointer-events: none;\r\n\t}\r\n.leaflet-top {\r\n\ttop: 0;\r\n\t}\r\n.leaflet-right {\r\n\tright: 0;\r\n\t}\r\n.leaflet-bottom {\r\n\tbottom: 0;\r\n\t}\r\n.leaflet-left {\r\n\tleft: 0;\r\n\t}\r\n.leaflet-control {\r\n\tfloat: left;\r\n\tclear: both;\r\n\t}\r\n.leaflet-right .leaflet-control {\r\n\tfloat: right;\r\n\t}\r\n.leaflet-top .leaflet-control {\r\n\tmargin-top: 10px;\r\n\t}\r\n.leaflet-bottom .leaflet-control {\r\n\tmargin-bottom: 10px;\r\n\t}\r\n.leaflet-left .leaflet-control {\r\n\tmargin-left: 10px;\r\n\t}\r\n.leaflet-right .leaflet-control {\r\n\tmargin-right: 10px;\r\n\t}\r\n\r\n\r\n/* zoom and fade animations */\r\n\r\n.leaflet-fade-anim .leaflet-popup {\r\n\topacity: 0;\r\n\t-webkit-transition: opacity 0.2s linear;\r\n\t   -moz-transition: opacity 0.2s linear;\r\n\t        transition: opacity 0.2s linear;\r\n\t}\r\n.leaflet-fade-anim .leaflet-map-pane .leaflet-popup {\r\n\topacity: 1;\r\n\t}\r\n.leaflet-zoom-animated {\r\n\t-webkit-transform-origin: 0 0;\r\n\t    -ms-transform-origin: 0 0;\r\n\t        transform-origin: 0 0;\r\n\t}\r\nsvg.leaflet-zoom-animated {\r\n\twill-change: transform;\r\n}\r\n\r\n.leaflet-zoom-anim .leaflet-zoom-animated {\r\n\t-webkit-transition: -webkit-transform 0.25s cubic-bezier(0,0,0.25,1);\r\n\t   -moz-transition:    -moz-transform 0.25s cubic-bezier(0,0,0.25,1);\r\n\t        transition:         transform 0.25s cubic-bezier(0,0,0.25,1);\r\n\t}\r\n.leaflet-zoom-anim .leaflet-tile,\r\n.leaflet-pan-anim .leaflet-tile {\r\n\t-webkit-transition: none;\r\n\t   -moz-transition: none;\r\n\t        transition: none;\r\n\t}\r\n\r\n.leaflet-zoom-anim .leaflet-zoom-hide {\r\n\tvisibility: hidden;\r\n\t}\r\n\r\n\r\n/* cursors */\r\n\r\n.leaflet-interactive {\r\n\tcursor: pointer;\r\n\t}\r\n.leaflet-grab {\r\n\tcursor: -webkit-grab;\r\n\tcursor:    -moz-grab;\r\n\tcursor:         grab;\r\n\t}\r\n.leaflet-crosshair,\r\n.leaflet-crosshair .leaflet-interactive {\r\n\tcursor: crosshair;\r\n\t}\r\n.leaflet-popup-pane,\r\n.leaflet-control {\r\n\tcursor: auto;\r\n\t}\r\n.leaflet-dragging .leaflet-grab,\r\n.leaflet-dragging .leaflet-grab .leaflet-interactive,\r\n.leaflet-dragging .leaflet-marker-draggable {\r\n\tcursor: move;\r\n\tcursor: -webkit-grabbing;\r\n\tcursor:    -moz-grabbing;\r\n\tcursor:         grabbing;\r\n\t}\r\n\r\n/* marker & overlays interactivity */\r\n.leaflet-marker-icon,\r\n.leaflet-marker-shadow,\r\n.leaflet-image-layer,\r\n.leaflet-pane > svg path,\r\n.leaflet-tile-container {\r\n\tpointer-events: none;\r\n\t}\r\n\r\n.leaflet-marker-icon.leaflet-interactive,\r\n.leaflet-image-layer.leaflet-interactive,\r\n.leaflet-pane > svg path.leaflet-interactive,\r\nsvg.leaflet-image-layer.leaflet-interactive path {\r\n\tpointer-events: visiblePainted; /* IE 9-10 doesn't have auto */\r\n\tpointer-events: auto;\r\n\t}\r\n\r\n/* visual tweaks */\r\n\r\n.leaflet-container {\r\n\tbackground: #ddd;\r\n\toutline-offset: 1px;\r\n\t}\r\n.leaflet-container a {\r\n\tcolor: #0078A8;\r\n\t}\r\n.leaflet-zoom-box {\r\n\tborder: 2px dotted #38f;\r\n\tbackground: rgba(255,255,255,0.5);\r\n\t}\r\n\r\n\r\n/* general typography */\r\n.leaflet-container {\r\n\tfont-family: \"Helvetica Neue\", Arial, Helvetica, sans-serif;\r\n\tfont-size: 12px;\r\n\tfont-size: 0.75rem;\r\n\tline-height: 1.5;\r\n\t}\r\n\r\n\r\n/* general toolbar styles */\r\n\r\n.leaflet-bar {\r\n\tbox-shadow: 0 1px 5px rgba(0,0,0,0.65);\r\n\tborder-radius: 4px;\r\n\t}\r\n.leaflet-bar a {\r\n\tbackground-color: #fff;\r\n\tborder-bottom: 1px solid #ccc;\r\n\twidth: 26px;\r\n\theight: 26px;\r\n\tline-height: 26px;\r\n\tdisplay: block;\r\n\ttext-align: center;\r\n\ttext-decoration: none;\r\n\tcolor: black;\r\n\t}\r\n.leaflet-bar a,\r\n.leaflet-control-layers-toggle {\r\n\tbackground-position: 50% 50%;\r\n\tbackground-repeat: no-repeat;\r\n\tdisplay: block;\r\n\t}\r\n.leaflet-bar a:hover,\r\n.leaflet-bar a:focus {\r\n\tbackground-color: #f4f4f4;\r\n\t}\r\n.leaflet-bar a:first-child {\r\n\tborder-top-left-radius: 4px;\r\n\tborder-top-right-radius: 4px;\r\n\t}\r\n.leaflet-bar a:last-child {\r\n\tborder-bottom-left-radius: 4px;\r\n\tborder-bottom-right-radius: 4px;\r\n\tborder-bottom: none;\r\n\t}\r\n.leaflet-bar a.leaflet-disabled {\r\n\tcursor: default;\r\n\tbackground-color: #f4f4f4;\r\n\tcolor: #bbb;\r\n\t}\r\n\r\n.leaflet-touch .leaflet-bar a {\r\n\twidth: 30px;\r\n\theight: 30px;\r\n\tline-height: 30px;\r\n\t}\r\n.leaflet-touch .leaflet-bar a:first-child {\r\n\tborder-top-left-radius: 2px;\r\n\tborder-top-right-radius: 2px;\r\n\t}\r\n.leaflet-touch .leaflet-bar a:last-child {\r\n\tborder-bottom-left-radius: 2px;\r\n\tborder-bottom-right-radius: 2px;\r\n\t}\r\n\r\n/* zoom control */\r\n\r\n.leaflet-control-zoom-in,\r\n.leaflet-control-zoom-out {\r\n\tfont: bold 18px 'Lucida Console', Monaco, monospace;\r\n\ttext-indent: 1px;\r\n\t}\r\n\r\n.leaflet-touch .leaflet-control-zoom-in, .leaflet-touch .leaflet-control-zoom-out  {\r\n\tfont-size: 22px;\r\n\t}\r\n\r\n\r\n/* layers control */\r\n\r\n.leaflet-control-layers {\r\n\tbox-shadow: 0 1px 5px rgba(0,0,0,0.4);\r\n\tbackground: #fff;\r\n\tborder-radius: 5px;\r\n\t}\r\n.leaflet-control-layers-toggle {\r\n\tbackground-image: url("+l+");\r\n\twidth: 36px;\r\n\theight: 36px;\r\n\t}\r\n.leaflet-retina .leaflet-control-layers-toggle {\r\n\tbackground-image: url("+h+");\r\n\tbackground-size: 26px 26px;\r\n\t}\r\n.leaflet-touch .leaflet-control-layers-toggle {\r\n\twidth: 44px;\r\n\theight: 44px;\r\n\t}\r\n.leaflet-control-layers .leaflet-control-layers-list,\r\n.leaflet-control-layers-expanded .leaflet-control-layers-toggle {\r\n\tdisplay: none;\r\n\t}\r\n.leaflet-control-layers-expanded .leaflet-control-layers-list {\r\n\tdisplay: block;\r\n\tposition: relative;\r\n\t}\r\n.leaflet-control-layers-expanded {\r\n\tpadding: 6px 10px 6px 6px;\r\n\tcolor: #333;\r\n\tbackground: #fff;\r\n\t}\r\n.leaflet-control-layers-scrollbar {\r\n\toverflow-y: scroll;\r\n\toverflow-x: hidden;\r\n\tpadding-right: 5px;\r\n\t}\r\n.leaflet-control-layers-selector {\r\n\tmargin-top: 2px;\r\n\tposition: relative;\r\n\ttop: 1px;\r\n\t}\r\n.leaflet-control-layers label {\r\n\tdisplay: block;\r\n\tfont-size: 13px;\r\n\tfont-size: 1.08333em;\r\n\t}\r\n.leaflet-control-layers-separator {\r\n\theight: 0;\r\n\tborder-top: 1px solid #ddd;\r\n\tmargin: 5px -10px 5px -6px;\r\n\t}\r\n\r\n/* Default icon URLs */\r\n.leaflet-default-icon-path { /* used only in path-guessing heuristic, see L.Icon.Default */\r\n\tbackground-image: url("+c+');\r\n\t}\r\n\r\n\r\n/* attribution and scale controls */\r\n\r\n.leaflet-container .leaflet-control-attribution {\r\n\tbackground: #fff;\r\n\tbackground: rgba(255, 255, 255, 0.8);\r\n\tmargin: 0;\r\n\t}\r\n.leaflet-control-attribution,\r\n.leaflet-control-scale-line {\r\n\tpadding: 0 5px;\r\n\tcolor: #333;\r\n\tline-height: 1.4;\r\n\t}\r\n.leaflet-control-attribution a {\r\n\ttext-decoration: none;\r\n\t}\r\n.leaflet-control-attribution a:hover,\r\n.leaflet-control-attribution a:focus {\r\n\ttext-decoration: underline;\r\n\t}\r\n.leaflet-attribution-flag {\r\n\tdisplay: inline !important;\r\n\tvertical-align: baseline !important;\r\n\twidth: 1em;\r\n\theight: 0.6669em;\r\n\t}\r\n.leaflet-left .leaflet-control-scale {\r\n\tmargin-left: 5px;\r\n\t}\r\n.leaflet-bottom .leaflet-control-scale {\r\n\tmargin-bottom: 5px;\r\n\t}\r\n.leaflet-control-scale-line {\r\n\tborder: 2px solid #777;\r\n\tborder-top: none;\r\n\tline-height: 1.1;\r\n\tpadding: 2px 5px 1px;\r\n\twhite-space: nowrap;\r\n\t-moz-box-sizing: border-box;\r\n\t     box-sizing: border-box;\r\n\tbackground: rgba(255, 255, 255, 0.8);\r\n\ttext-shadow: 1px 1px #fff;\r\n\t}\r\n.leaflet-control-scale-line:not(:first-child) {\r\n\tborder-top: 2px solid #777;\r\n\tborder-bottom: none;\r\n\tmargin-top: -2px;\r\n\t}\r\n.leaflet-control-scale-line:not(:first-child):not(:last-child) {\r\n\tborder-bottom: 2px solid #777;\r\n\t}\r\n\r\n.leaflet-touch .leaflet-control-attribution,\r\n.leaflet-touch .leaflet-control-layers,\r\n.leaflet-touch .leaflet-bar {\r\n\tbox-shadow: none;\r\n\t}\r\n.leaflet-touch .leaflet-control-layers,\r\n.leaflet-touch .leaflet-bar {\r\n\tborder: 2px solid rgba(0,0,0,0.2);\r\n\tbackground-clip: padding-box;\r\n\t}\r\n\r\n\r\n/* popup */\r\n\r\n.leaflet-popup {\r\n\tposition: absolute;\r\n\ttext-align: center;\r\n\tmargin-bottom: 20px;\r\n\t}\r\n.leaflet-popup-content-wrapper {\r\n\tpadding: 1px;\r\n\ttext-align: left;\r\n\tborder-radius: 12px;\r\n\t}\r\n.leaflet-popup-content {\r\n\tmargin: 13px 24px 13px 20px;\r\n\tline-height: 1.3;\r\n\tfont-size: 13px;\r\n\tfont-size: 1.08333em;\r\n\tmin-height: 1px;\r\n\t}\r\n.leaflet-popup-content p {\r\n\tmargin: 17px 0;\r\n\tmargin: 1.3em 0;\r\n\t}\r\n.leaflet-popup-tip-container {\r\n\twidth: 40px;\r\n\theight: 20px;\r\n\tposition: absolute;\r\n\tleft: 50%;\r\n\tmargin-top: -1px;\r\n\tmargin-left: -20px;\r\n\toverflow: hidden;\r\n\tpointer-events: none;\r\n\t}\r\n.leaflet-popup-tip {\r\n\twidth: 17px;\r\n\theight: 17px;\r\n\tpadding: 1px;\r\n\r\n\tmargin: -10px auto 0;\r\n\tpointer-events: auto;\r\n\r\n\t-webkit-transform: rotate(45deg);\r\n\t   -moz-transform: rotate(45deg);\r\n\t    -ms-transform: rotate(45deg);\r\n\t        transform: rotate(45deg);\r\n\t}\r\n.leaflet-popup-content-wrapper,\r\n.leaflet-popup-tip {\r\n\tbackground: white;\r\n\tcolor: #333;\r\n\tbox-shadow: 0 3px 14px rgba(0,0,0,0.4);\r\n\t}\r\n.leaflet-container a.leaflet-popup-close-button {\r\n\tposition: absolute;\r\n\ttop: 0;\r\n\tright: 0;\r\n\tborder: none;\r\n\ttext-align: center;\r\n\twidth: 24px;\r\n\theight: 24px;\r\n\tfont: 16px/24px Tahoma, Verdana, sans-serif;\r\n\tcolor: #757575;\r\n\ttext-decoration: none;\r\n\tbackground: transparent;\r\n\t}\r\n.leaflet-container a.leaflet-popup-close-button:hover,\r\n.leaflet-container a.leaflet-popup-close-button:focus {\r\n\tcolor: #585858;\r\n\t}\r\n.leaflet-popup-scrolled {\r\n\toverflow: auto;\r\n\t}\r\n\r\n.leaflet-oldie .leaflet-popup-content-wrapper {\r\n\t-ms-zoom: 1;\r\n\t}\r\n.leaflet-oldie .leaflet-popup-tip {\r\n\twidth: 24px;\r\n\tmargin: 0 auto;\r\n\r\n\t-ms-filter: "progid:DXImageTransform.Microsoft.Matrix(M11=0.70710678, M12=0.70710678, M21=-0.70710678, M22=0.70710678)";\r\n\tfilter: progid:DXImageTransform.Microsoft.Matrix(M11=0.70710678, M12=0.70710678, M21=-0.70710678, M22=0.70710678);\r\n\t}\r\n\r\n.leaflet-oldie .leaflet-control-zoom,\r\n.leaflet-oldie .leaflet-control-layers,\r\n.leaflet-oldie .leaflet-popup-content-wrapper,\r\n.leaflet-oldie .leaflet-popup-tip {\r\n\tborder: 1px solid #999;\r\n\t}\r\n\r\n\r\n/* div icon */\r\n\r\n.leaflet-div-icon {\r\n\tbackground: #fff;\r\n\tborder: 1px solid #666;\r\n\t}\r\n\r\n\r\n/* Tooltip */\r\n/* Base styles for the element that has a tooltip */\r\n.leaflet-tooltip {\r\n\tposition: absolute;\r\n\tpadding: 6px;\r\n\tbackground-color: #fff;\r\n\tborder: 1px solid #fff;\r\n\tborder-radius: 3px;\r\n\tcolor: #222;\r\n\twhite-space: nowrap;\r\n\t-webkit-user-select: none;\r\n\t-moz-user-select: none;\r\n\t-ms-user-select: none;\r\n\tuser-select: none;\r\n\tpointer-events: none;\r\n\tbox-shadow: 0 1px 3px rgba(0,0,0,0.4);\r\n\t}\r\n.leaflet-tooltip.leaflet-interactive {\r\n\tcursor: pointer;\r\n\tpointer-events: auto;\r\n\t}\r\n.leaflet-tooltip-top:before,\r\n.leaflet-tooltip-bottom:before,\r\n.leaflet-tooltip-left:before,\r\n.leaflet-tooltip-right:before {\r\n\tposition: absolute;\r\n\tpointer-events: none;\r\n\tborder: 6px solid transparent;\r\n\tbackground: transparent;\r\n\tcontent: "";\r\n\t}\r\n\r\n/* Directions */\r\n\r\n.leaflet-tooltip-bottom {\r\n\tmargin-top: 6px;\r\n}\r\n.leaflet-tooltip-top {\r\n\tmargin-top: -6px;\r\n}\r\n.leaflet-tooltip-bottom:before,\r\n.leaflet-tooltip-top:before {\r\n\tleft: 50%;\r\n\tmargin-left: -6px;\r\n\t}\r\n.leaflet-tooltip-top:before {\r\n\tbottom: 0;\r\n\tmargin-bottom: -12px;\r\n\tborder-top-color: #fff;\r\n\t}\r\n.leaflet-tooltip-bottom:before {\r\n\ttop: 0;\r\n\tmargin-top: -12px;\r\n\tmargin-left: -6px;\r\n\tborder-bottom-color: #fff;\r\n\t}\r\n.leaflet-tooltip-left {\r\n\tmargin-left: -6px;\r\n}\r\n.leaflet-tooltip-right {\r\n\tmargin-left: 6px;\r\n}\r\n.leaflet-tooltip-left:before,\r\n.leaflet-tooltip-right:before {\r\n\ttop: 50%;\r\n\tmargin-top: -6px;\r\n\t}\r\n.leaflet-tooltip-left:before {\r\n\tright: 0;\r\n\tmargin-right: -12px;\r\n\tborder-left-color: #fff;\r\n\t}\r\n.leaflet-tooltip-right:before {\r\n\tleft: 0;\r\n\tmargin-left: -12px;\r\n\tborder-right-color: #fff;\r\n\t}\r\n\r\n/* Printing */\r\n\r\n@media print {\r\n\t/* Prevent printers from removing background-images of controls. */\r\n\t.leaflet-control {\r\n\t\t-webkit-print-color-adjust: exact;\r\n\t\tprint-color-adjust: exact;\r\n\t\t}\r\n\t}\r\n',""]),t.exports=e},5815:(t,e,i)=>{(e=i(1364)(!1)).push([t.id,"@keyframes spinner-line-fade-more {\r\n  0%, 100% {\r\n    opacity: 0; /* minimum opacity */\r\n  }\r\n  1% {\r\n    opacity: 1;\r\n  }\r\n}\r\n\r\n@keyframes spinner-line-fade-quick {\r\n  0%, 39%, 100% {\r\n    opacity: 0.25; /* minimum opacity */\r\n  }\r\n  40% {\r\n    opacity: 1;\r\n  }\r\n}\r\n\r\n@keyframes spinner-line-fade-default {\r\n  0%, 100% {\r\n    opacity: 0.22; /* minimum opacity */\r\n  }\r\n  1% {\r\n    opacity: 1;\r\n  }\r\n}\r\n\r\n@keyframes spinner-line-shrink {\r\n  0%, 25%, 100% {\r\n    /* minimum scale and opacity */\r\n    transform: scale(0.5);\r\n    opacity: 0.25;\r\n  }\r\n  26% {\r\n    transform: scale(1);\r\n    opacity: 1;\r\n  }\r\n}\r\n",""]),t.exports=e},4260:(t,e,i)=>{var n,r;(()=>{var o=Object.create,s=Object.defineProperty,a=Object.getOwnPropertyDescriptor,l=Object.getOwnPropertyNames,h=Object.getPrototypeOf,c=Object.prototype.hasOwnProperty,u=(t,e)=>()=>(e||t((e={exports:{}}).exports,e),e.exports),d=(t,e,i)=>(i=null!=t?o(h(t)):{},((t,e,i,n)=>{if(e&&"object"==typeof e||"function"==typeof e)for(let i of l(e))!c.call(t,i)&&undefined!==i&&s(t,i,{get:()=>e[i],enumerable:!(n=a(e,i))||n.enumerable});return t})(!e&&t&&t.__esModule?i:s(i,"default",{value:t,enumerable:!0}),t)),p=u(((t,e)=>{e.exports=function(){this.__data__=[],this.size=0}})),f=u(((t,e)=>{e.exports=function(t,e){return t===e||t!=t&&e!=e}})),m=u(((t,e)=>{var i=f();e.exports=function(t,e){for(var n=t.length;n--;)if(i(t[n][0],e))return n;return-1}})),g=u(((t,e)=>{var i=m(),n=Array.prototype.splice;e.exports=function(t){var e=this.__data__,r=i(e,t);return!(r<0||(r==e.length-1?e.pop():n.call(e,r,1),--this.size,0))}})),_=u(((t,e)=>{var i=m();e.exports=function(t){var e=this.__data__,n=i(e,t);return n<0?void 0:e[n][1]}})),y=u(((t,e)=>{var i=m();e.exports=function(t){return i(this.__data__,t)>-1}})),v=u(((t,e)=>{var i=m();e.exports=function(t,e){var n=this.__data__,r=i(n,t);return r<0?(++this.size,n.push([t,e])):n[r][1]=e,this}})),b=u(((t,e)=>{var i=p(),n=g(),r=_(),o=y(),s=v();function a(t){var e=-1,i=null==t?0:t.length;for(this.clear();++e<i;){var n=t[e];this.set(n[0],n[1])}}a.prototype.clear=i,a.prototype.delete=n,a.prototype.get=r,a.prototype.has=o,a.prototype.set=s,e.exports=a})),x=u(((t,e)=>{var i=b();e.exports=function(){this.__data__=new i,this.size=0}})),w=u(((t,e)=>{e.exports=function(t){var e=this.__data__,i=e.delete(t);return this.size=e.size,i}})),M=u(((t,e)=>{e.exports=function(t){return this.__data__.get(t)}})),k=u(((t,e)=>{e.exports=function(t){return this.__data__.has(t)}})),C=u(((t,e)=>{var n="object"==typeof i.g&&i.g&&i.g.Object===Object&&i.g;e.exports=n})),A=u(((t,e)=>{var i=C(),n="object"==typeof self&&self&&self.Object===Object&&self,r=i||n||Function("return this")();e.exports=r})),P=u(((t,e)=>{var i=A().Symbol;e.exports=i})),S=u(((t,e)=>{var i=P(),n=Object.prototype,r=n.hasOwnProperty,o=n.toString,s=i?i.toStringTag:void 0;e.exports=function(t){var e=r.call(t,s),i=t[s];try{t[s]=void 0;var n=!0}catch{}var a=o.call(t);return n&&(e?t[s]=i:delete t[s]),a}})),E=u(((t,e)=>{var i=Object.prototype.toString;e.exports=function(t){return i.call(t)}})),I=u(((t,e)=>{var i=P(),n=S(),r=E(),o=i?i.toStringTag:void 0;e.exports=function(t){return null==t?void 0===t?"[object Undefined]":"[object Null]":o&&o in Object(t)?n(t):r(t)}})),T=u(((t,e)=>{e.exports=function(t){var e=typeof t;return null!=t&&("object"==e||"function"==e)}})),D=u(((t,e)=>{var i=I(),n=T();e.exports=function(t){if(!n(t))return!1;var e=i(t);return"[object Function]"==e||"[object GeneratorFunction]"==e||"[object AsyncFunction]"==e||"[object Proxy]"==e}})),z=u(((t,e)=>{var i=A()["__core-js_shared__"];e.exports=i})),B=u(((t,e)=>{var i,n=z(),r=(i=/[^.]+$/.exec(n&&n.keys&&n.keys.IE_PROTO||""))?"Symbol(src)_1."+i:"";e.exports=function(t){return!!r&&r in t}})),O=u(((t,e)=>{var i=Function.prototype.toString;e.exports=function(t){if(null!=t){try{return i.call(t)}catch{}try{return t+""}catch{}}return""}})),R=u(((t,e)=>{var i=D(),n=B(),r=T(),o=O(),s=/^\[object .+?Constructor\]$/,a=Function.prototype,l=Object.prototype,h=a.toString,c=l.hasOwnProperty,u=RegExp("^"+h.call(c).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");e.exports=function(t){return!(!r(t)||n(t))&&(i(t)?u:s).test(o(t))}})),j=u(((t,e)=>{e.exports=function(t,e){return t?.[e]}})),N=u(((t,e)=>{var i=R(),n=j();e.exports=function(t,e){var r=n(t,e);return i(r)?r:void 0}})),F=u(((t,e)=>{var i=N()(A(),"Map");e.exports=i})),G=u(((t,e)=>{var i=N()(Object,"create");e.exports=i})),U=u(((t,e)=>{var i=G();e.exports=function(){this.__data__=i?i(null):{},this.size=0}})),H=u(((t,e)=>{e.exports=function(t){var e=this.has(t)&&delete this.__data__[t];return this.size-=e?1:0,e}})),V=u(((t,e)=>{var i=G(),n=Object.prototype.hasOwnProperty;e.exports=function(t){var e=this.__data__;if(i){var r=e[t];return"__lodash_hash_undefined__"===r?void 0:r}return n.call(e,t)?e[t]:void 0}})),Z=u(((t,e)=>{var i=G(),n=Object.prototype.hasOwnProperty;e.exports=function(t){var e=this.__data__;return i?void 0!==e[t]:n.call(e,t)}})),q=u(((t,e)=>{var i=G();e.exports=function(t,e){var n=this.__data__;return this.size+=this.has(t)?0:1,n[t]=i&&void 0===e?"__lodash_hash_undefined__":e,this}})),W=u(((t,e)=>{var i=U(),n=H(),r=V(),o=Z(),s=q();function a(t){var e=-1,i=null==t?0:t.length;for(this.clear();++e<i;){var n=t[e];this.set(n[0],n[1])}}a.prototype.clear=i,a.prototype.delete=n,a.prototype.get=r,a.prototype.has=o,a.prototype.set=s,e.exports=a})),K=u(((t,e)=>{var i=W(),n=b(),r=F();e.exports=function(){this.size=0,this.__data__={hash:new i,map:new(r||n),string:new i}}})),Y=u(((t,e)=>{e.exports=function(t){var e=typeof t;return"string"==e||"number"==e||"symbol"==e||"boolean"==e?"__proto__"!==t:null===t}})),X=u(((t,e)=>{var i=Y();e.exports=function(t,e){var n=t.__data__;return i(e)?n["string"==typeof e?"string":"hash"]:n.map}})),J=u(((t,e)=>{var i=X();e.exports=function(t){var e=i(this,t).delete(t);return this.size-=e?1:0,e}})),Q=u(((t,e)=>{var i=X();e.exports=function(t){return i(this,t).get(t)}})),$=u(((t,e)=>{var i=X();e.exports=function(t){return i(this,t).has(t)}})),tt=u(((t,e)=>{var i=X();e.exports=function(t,e){var n=i(this,t),r=n.size;return n.set(t,e),this.size+=n.size==r?0:1,this}})),et=u(((t,e)=>{var i=K(),n=J(),r=Q(),o=$(),s=tt();function a(t){var e=-1,i=null==t?0:t.length;for(this.clear();++e<i;){var n=t[e];this.set(n[0],n[1])}}a.prototype.clear=i,a.prototype.delete=n,a.prototype.get=r,a.prototype.has=o,a.prototype.set=s,e.exports=a})),it=u(((t,e)=>{var i=b(),n=F(),r=et();e.exports=function(t,e){var o=this.__data__;if(o instanceof i){var s=o.__data__;if(!n||s.length<199)return s.push([t,e]),this.size=++o.size,this;o=this.__data__=new r(s)}return o.set(t,e),this.size=o.size,this}})),nt=u(((t,e)=>{var i=b(),n=x(),r=w(),o=M(),s=k(),a=it();function l(t){var e=this.__data__=new i(t);this.size=e.size}l.prototype.clear=n,l.prototype.delete=r,l.prototype.get=o,l.prototype.has=s,l.prototype.set=a,e.exports=l})),rt=u(((t,e)=>{var i=N(),n=function(){try{var t=i(Object,"defineProperty");return t({},"",{}),t}catch{}}();e.exports=n})),ot=u(((t,e)=>{var i=rt();e.exports=function(t,e,n){"__proto__"==e&&i?i(t,e,{configurable:!0,enumerable:!0,value:n,writable:!0}):t[e]=n}})),st=u(((t,e)=>{var i=ot(),n=f();e.exports=function(t,e,r){(void 0!==r&&!n(t[e],r)||void 0===r&&!(e in t))&&i(t,e,r)}})),at=u(((t,e)=>{e.exports=function(t){return function(e,i,n){for(var r=-1,o=Object(e),s=n(e),a=s.length;a--;){var l=s[t?a:++r];if(!1===i(o[l],l,o))break}return e}}})),lt=u(((t,e)=>{var i=at()();e.exports=i})),ht=u(((t,e)=>{var i=A(),n="object"==typeof t&&t&&!t.nodeType&&t,r=n&&"object"==typeof e&&e&&!e.nodeType&&e,o=r&&r.exports===n?i.Buffer:void 0,s=o?o.allocUnsafe:void 0;e.exports=function(t,e){if(e)return t.slice();var i=t.length,n=s?s(i):new t.constructor(i);return t.copy(n),n}})),ct=u(((t,e)=>{var i=A().Uint8Array;e.exports=i})),ut=u(((t,e)=>{var i=ct();e.exports=function(t){var e=new t.constructor(t.byteLength);return new i(e).set(new i(t)),e}})),dt=u(((t,e)=>{var i=ut();e.exports=function(t,e){var n=e?i(t.buffer):t.buffer;return new t.constructor(n,t.byteOffset,t.length)}})),pt=u(((t,e)=>{e.exports=function(t,e){var i=-1,n=t.length;for(e||(e=Array(n));++i<n;)e[i]=t[i];return e}})),ft=u(((t,e)=>{var i=T(),n=Object.create,r=function(){function t(){}return function(e){if(!i(e))return{};if(n)return n(e);t.prototype=e;var r=new t;return t.prototype=void 0,r}}();e.exports=r})),mt=u(((t,e)=>{e.exports=function(t,e){return function(i){return t(e(i))}}})),gt=u(((t,e)=>{var i=mt()(Object.getPrototypeOf,Object);e.exports=i})),_t=u(((t,e)=>{var i=Object.prototype;e.exports=function(t){var e=t&&t.constructor;return t===("function"==typeof e&&e.prototype||i)}})),yt=u(((t,e)=>{var i=ft(),n=gt(),r=_t();e.exports=function(t){return"function"!=typeof t.constructor||r(t)?{}:i(n(t))}})),vt=u(((t,e)=>{e.exports=function(t){return null!=t&&"object"==typeof t}})),bt=u(((t,e)=>{var i=I(),n=vt();e.exports=function(t){return n(t)&&"[object Arguments]"==i(t)}})),xt=u(((t,e)=>{var i=bt(),n=vt(),r=Object.prototype,o=r.hasOwnProperty,s=r.propertyIsEnumerable,a=i(function(){return arguments}())?i:function(t){return n(t)&&o.call(t,"callee")&&!s.call(t,"callee")};e.exports=a})),wt=u(((t,e)=>{var i=Array.isArray;e.exports=i})),Lt=u(((t,e)=>{e.exports=function(t){return"number"==typeof t&&t>-1&&t%1==0&&t<=9007199254740991}})),Mt=u(((t,e)=>{var i=D(),n=Lt();e.exports=function(t){return null!=t&&n(t.length)&&!i(t)}})),kt=u(((t,e)=>{var i=Mt(),n=vt();e.exports=function(t){return n(t)&&i(t)}})),Ct=u(((t,e)=>{e.exports=function(){return!1}})),At=u(((t,e)=>{var i=A(),n=Ct(),r="object"==typeof t&&t&&!t.nodeType&&t,o=r&&"object"==typeof e&&e&&!e.nodeType&&e,s=o&&o.exports===r?i.Buffer:void 0,a=(s?s.isBuffer:void 0)||n;e.exports=a})),Pt=u(((t,e)=>{var i=I(),n=gt(),r=vt(),o=Function.prototype,s=Object.prototype,a=o.toString,l=s.hasOwnProperty,h=a.call(Object);e.exports=function(t){if(!r(t)||"[object Object]"!=i(t))return!1;var e=n(t);if(null===e)return!0;var o=l.call(e,"constructor")&&e.constructor;return"function"==typeof o&&o instanceof o&&a.call(o)==h}})),St=u(((t,e)=>{var i=I(),n=Lt(),r=vt(),o={};o["[object Float32Array]"]=o["[object Float64Array]"]=o["[object Int8Array]"]=o["[object Int16Array]"]=o["[object Int32Array]"]=o["[object Uint8Array]"]=o["[object Uint8ClampedArray]"]=o["[object Uint16Array]"]=o["[object Uint32Array]"]=!0,o["[object Arguments]"]=o["[object Array]"]=o["[object ArrayBuffer]"]=o["[object Boolean]"]=o["[object DataView]"]=o["[object Date]"]=o["[object Error]"]=o["[object Function]"]=o["[object Map]"]=o["[object Number]"]=o["[object Object]"]=o["[object RegExp]"]=o["[object Set]"]=o["[object String]"]=o["[object WeakMap]"]=!1,e.exports=function(t){return r(t)&&n(t.length)&&!!o[i(t)]}})),Et=u(((t,e)=>{e.exports=function(t){return function(e){return t(e)}}})),It=u(((t,e)=>{var i=C(),n="object"==typeof t&&t&&!t.nodeType&&t,r=n&&"object"==typeof e&&e&&!e.nodeType&&e,o=r&&r.exports===n&&i.process,s=function(){try{return r&&r.require&&r.require("util").types||o&&o.binding&&o.binding("util")}catch{}}();e.exports=s})),Tt=u(((t,e)=>{var i=St(),n=Et(),r=It(),o=r&&r.isTypedArray,s=o?n(o):i;e.exports=s})),Dt=u(((t,e)=>{e.exports=function(t,e){if(("constructor"!==e||"function"!=typeof t[e])&&"__proto__"!=e)return t[e]}})),zt=u(((t,e)=>{var i=ot(),n=f(),r=Object.prototype.hasOwnProperty;e.exports=function(t,e,o){var s=t[e];(!r.call(t,e)||!n(s,o)||void 0===o&&!(e in t))&&i(t,e,o)}})),Bt=u(((t,e)=>{var i=zt(),n=ot();e.exports=function(t,e,r,o){var s=!r;r||(r={});for(var a=-1,l=e.length;++a<l;){var h=e[a],c=o?o(r[h],t[h],h,r,t):void 0;void 0===c&&(c=t[h]),s?n(r,h,c):i(r,h,c)}return r}})),Ot=u(((t,e)=>{e.exports=function(t,e){for(var i=-1,n=Array(t);++i<t;)n[i]=e(i);return n}})),Rt=u(((t,e)=>{var i=/^(?:0|[1-9]\d*)$/;e.exports=function(t,e){var n=typeof t;return!!(e=e??9007199254740991)&&("number"==n||"symbol"!=n&&i.test(t))&&t>-1&&t%1==0&&t<e}})),jt=u(((t,e)=>{var i=Ot(),n=xt(),r=wt(),o=At(),s=Rt(),a=Tt(),l=Object.prototype.hasOwnProperty;e.exports=function(t,e){var h=r(t),c=!h&&n(t),u=!h&&!c&&o(t),d=!h&&!c&&!u&&a(t),p=h||c||u||d,f=p?i(t.length,String):[],m=f.length;for(var g in t)(e||l.call(t,g))&&(!p||!("length"==g||u&&("offset"==g||"parent"==g)||d&&("buffer"==g||"byteLength"==g||"byteOffset"==g)||s(g,m)))&&f.push(g);return f}})),Nt=u(((t,e)=>{e.exports=function(t){var e=[];if(null!=t)for(var i in Object(t))e.push(i);return e}})),Ft=u(((t,e)=>{var i=T(),n=_t(),r=Nt(),o=Object.prototype.hasOwnProperty;e.exports=function(t){if(!i(t))return r(t);var e=n(t),s=[];for(var a in t)"constructor"==a&&(e||!o.call(t,a))||s.push(a);return s}})),Gt=u(((t,e)=>{var i=jt(),n=Ft(),r=Mt();e.exports=function(t){return r(t)?i(t,!0):n(t)}})),Ut=u(((t,e)=>{var i=Bt(),n=Gt();e.exports=function(t){return i(t,n(t))}})),Ht=u(((t,e)=>{var i=st(),n=ht(),r=dt(),o=pt(),s=yt(),a=xt(),l=wt(),h=kt(),c=At(),u=D(),d=T(),p=Pt(),f=Tt(),m=Dt(),g=Ut();e.exports=function(t,e,_,y,v,b,x){var w=m(t,_),L=m(e,_),M=x.get(L);if(M)i(t,_,M);else{var k=b?b(w,L,_+"",t,e,x):void 0,C=void 0===k;if(C){var A=l(L),P=!A&&c(L),S=!A&&!P&&f(L);k=L,A||P||S?l(w)?k=w:h(w)?k=o(w):P?(C=!1,k=n(L,!0)):S?(C=!1,k=r(L,!0)):k=[]:p(L)||a(L)?(k=w,a(w)?k=g(w):(!d(w)||u(w))&&(k=s(L))):C=!1}C&&(x.set(L,k),v(k,L,y,b,x),x.delete(L)),i(t,_,k)}}})),Vt=u(((t,e)=>{var i=nt(),n=st(),r=lt(),o=Ht(),s=T(),a=Gt(),l=Dt();e.exports=function t(e,h,c,u,d){e!==h&&r(h,(function(r,a){if(d||(d=new i),s(r))o(e,h,a,c,t,u,d);else{var p=u?u(l(e,a),r,a+"",e,h,d):void 0;void 0===p&&(p=r),n(e,a,p)}}),a)}})),Zt=u(((t,e)=>{e.exports=function(t){return t}})),qt=u(((t,e)=>{e.exports=function(t,e,i){switch(i.length){case 0:return t.call(e);case 1:return t.call(e,i[0]);case 2:return t.call(e,i[0],i[1]);case 3:return t.call(e,i[0],i[1],i[2])}return t.apply(e,i)}})),Wt=u(((t,e)=>{var i=qt(),n=Math.max;e.exports=function(t,e,r){return e=n(void 0===e?t.length-1:e,0),function(){for(var o=arguments,s=-1,a=n(o.length-e,0),l=Array(a);++s<a;)l[s]=o[e+s];s=-1;for(var h=Array(e+1);++s<e;)h[s]=o[s];return h[e]=r(l),i(t,this,h)}}})),Kt=u(((t,e)=>{e.exports=function(t){return function(){return t}}})),Yt=u(((t,e)=>{var i=Kt(),n=rt(),r=Zt(),o=n?function(t,e){return n(t,"toString",{configurable:!0,enumerable:!1,value:i(e),writable:!0})}:r;e.exports=o})),Xt=u(((t,e)=>{var i=Date.now;e.exports=function(t){var e=0,n=0;return function(){var r=i(),o=16-(r-n);if(n=r,o>0){if(++e>=800)return arguments[0]}else e=0;return t.apply(void 0,arguments)}}})),Jt=u(((t,e)=>{var i=Yt(),n=Xt()(i);e.exports=n})),Qt=u(((t,e)=>{var i=Zt(),n=Wt(),r=Jt();e.exports=function(t,e){return r(n(t,e,i),t+"")}})),$t=u(((t,e)=>{var i=f(),n=Mt(),r=Rt(),o=T();e.exports=function(t,e,s){if(!o(s))return!1;var a=typeof e;return!!("number"==a?n(s)&&r(e,s.length):"string"==a&&e in s)&&i(s[e],t)}})),te=u(((t,e)=>{var i=Qt(),n=$t();e.exports=function(t){return i((function(e,i){var r=-1,o=i.length,s=o>1?i[o-1]:void 0,a=o>2?i[2]:void 0;for(s=t.length>3&&"function"==typeof s?(o--,s):void 0,a&&n(i[0],i[1],a)&&(s=o<3?void 0:s,o=1),e=Object(e);++r<o;){var l=i[r];l&&t(e,l,r,s)}return e}))}})),ee=u(((t,e)=>{var i=Vt(),n=te()((function(t,e,n){i(t,e,n)}));e.exports=n})),ie=u(((t,e)=>{var i=I(),n=vt();e.exports=function(t){return"symbol"==typeof t||n(t)&&"[object Symbol]"==i(t)}})),ne=u(((t,e)=>{var i=wt(),n=ie(),r=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,o=/^\w*$/;e.exports=function(t,e){if(i(t))return!1;var s=typeof t;return!("number"!=s&&"symbol"!=s&&"boolean"!=s&&null!=t&&!n(t))||o.test(t)||!r.test(t)||null!=e&&t in Object(e)}})),re=u(((t,e)=>{var i=et();function n(t,e){if("function"!=typeof t||null!=e&&"function"!=typeof e)throw new TypeError("Expected a function");var r=function(){var i=arguments,n=e?e.apply(this,i):i[0],o=r.cache;if(o.has(n))return o.get(n);var s=t.apply(this,i);return r.cache=o.set(n,s)||o,s};return r.cache=new(n.Cache||i),r}n.Cache=i,e.exports=n})),oe=u(((t,e)=>{var i=re();e.exports=function(t){var e=i(t,(function(t){return 500===n.size&&n.clear(),t})),n=e.cache;return e}})),se=u(((t,e)=>{var i=oe(),n=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,r=/\\(\\)?/g,o=i((function(t){var e=[];return 46===t.charCodeAt(0)&&e.push(""),t.replace(n,(function(t,i,n,o){e.push(n?o.replace(r,"$1"):i||t)})),e}));e.exports=o})),ae=u(((t,e)=>{e.exports=function(t,e){for(var i=-1,n=null==t?0:t.length,r=Array(n);++i<n;)r[i]=e(t[i],i,t);return r}})),le=u(((t,e)=>{var i=P(),n=ae(),r=wt(),o=ie(),s=1/0,a=i?i.prototype:void 0,l=a?a.toString:void 0;e.exports=function t(e){if("string"==typeof e)return e;if(r(e))return n(e,t)+"";if(o(e))return l?l.call(e):"";var i=e+"";return"0"==i&&1/e==-s?"-0":i}})),he=u(((t,e)=>{var i=le();e.exports=function(t){return null==t?"":i(t)}})),ce=u(((t,e)=>{var i=wt(),n=ne(),r=se(),o=he();e.exports=function(t,e){return i(t)?t:n(t,e)?[t]:r(o(t))}})),ue=u(((t,e)=>{var i=ie(),n=1/0;e.exports=function(t){if("string"==typeof t||i(t))return t;var e=t+"";return"0"==e&&1/t==-n?"-0":e}})),de=u(((t,e)=>{var i=ce(),n=ue();e.exports=function(t,e){for(var r=0,o=(e=i(e,t)).length;null!=t&&r<o;)t=t[n(e[r++])];return r&&r==o?t:void 0}})),pe=u(((t,e)=>{var i=de();e.exports=function(t,e,n){var r=null==t?void 0:i(t,e);return void 0===r?n:r}})),fe=u(((t,e)=>{var i=Object.prototype.hasOwnProperty;e.exports=function(t,e){return null!=t&&i.call(t,e)}})),me=u(((t,e)=>{var i=ce(),n=xt(),r=wt(),o=Rt(),s=Lt(),a=ue();e.exports=function(t,e,l){for(var h=-1,c=(e=i(e,t)).length,u=!1;++h<c;){var d=a(e[h]);if(!(u=null!=t&&l(t,d)))break;t=t[d]}return u||++h!=c?u:!!(c=null==t?0:t.length)&&s(c)&&o(d,c)&&(r(t)||n(t))}})),ge=u(((t,e)=>{var i=fe(),n=me();e.exports=function(t,e){return null!=t&&n(t,e,i)}})),_e=u(((o,s)=>{var a;a=function(){"use strict";function t(t,n,r,o,s){!function t(i,n,r,o,s){for(;o>r;){if(o-r>600){var a=o-r+1,l=n-r+1,h=Math.log(a),c=.5*Math.exp(2*h/3),u=.5*Math.sqrt(h*c*(a-c)/a)*(l-a/2<0?-1:1);t(i,n,Math.max(r,Math.floor(n-l*c/a+u)),Math.min(o,Math.floor(n+(a-l)*c/a+u)),s)}var d=i[n],p=r,f=o;for(e(i,r,n),s(i[o],d)>0&&e(i,r,o);p<f;){for(e(i,p,f),p++,f--;s(i[p],d)<0;)p++;for(;s(i[f],d)>0;)f--}0===s(i[r],d)?e(i,r,f):e(i,++f,o),f<=n&&(r=f+1),n<=f&&(o=f-1)}}(t,n,r||0,o||t.length-1,s||i)}function e(t,e,i){var n=t[e];t[e]=t[i],t[i]=n}function i(t,e){return t<e?-1:t>e?1:0}var n=function(t){void 0===t&&(t=9),this._maxEntries=Math.max(4,t),this._minEntries=Math.max(2,Math.ceil(.4*this._maxEntries)),this.clear()};function r(t,e,i){if(!i)return e.indexOf(t);for(var n=0;n<e.length;n++)if(i(t,e[n]))return n;return-1}function o(t,e){s(t,0,t.children.length,e,t)}function s(t,e,i,n,r){r||(r=f(null)),r.minX=1/0,r.minY=1/0,r.maxX=-1/0,r.maxY=-1/0;for(var o=e;o<i;o++){var s=t.children[o];a(r,t.leaf?n(s):s)}return r}function a(t,e){return t.minX=Math.min(t.minX,e.minX),t.minY=Math.min(t.minY,e.minY),t.maxX=Math.max(t.maxX,e.maxX),t.maxY=Math.max(t.maxY,e.maxY),t}function l(t,e){return t.minX-e.minX}function h(t,e){return t.minY-e.minY}function c(t){return(t.maxX-t.minX)*(t.maxY-t.minY)}function u(t){return t.maxX-t.minX+(t.maxY-t.minY)}function d(t,e){return t.minX<=e.minX&&t.minY<=e.minY&&e.maxX<=t.maxX&&e.maxY<=t.maxY}function p(t,e){return e.minX<=t.maxX&&e.minY<=t.maxY&&e.maxX>=t.minX&&e.maxY>=t.minY}function f(t){return{children:t,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function m(e,i,n,r,o){for(var s=[i,n];s.length;)if(!((n=s.pop())-(i=s.pop())<=r)){var a=i+Math.ceil((n-i)/r/2)*r;t(e,a,i,n,o),s.push(i,a,a,n)}}return n.prototype.all=function(){return this._all(this.data,[])},n.prototype.search=function(t){var e=this.data,i=[];if(!p(t,e))return i;for(var n=this.toBBox,r=[];e;){for(var o=0;o<e.children.length;o++){var s=e.children[o],a=e.leaf?n(s):s;p(t,a)&&(e.leaf?i.push(s):d(t,a)?this._all(s,i):r.push(s))}e=r.pop()}return i},n.prototype.collides=function(t){var e=this.data;if(!p(t,e))return!1;for(var i=[];e;){for(var n=0;n<e.children.length;n++){var r=e.children[n],o=e.leaf?this.toBBox(r):r;if(p(t,o)){if(e.leaf||d(t,o))return!0;i.push(r)}}e=i.pop()}return!1},n.prototype.load=function(t){if(!t||!t.length)return this;if(t.length<this._minEntries){for(var e=0;e<t.length;e++)this.insert(t[e]);return this}var i=this._build(t.slice(),0,t.length-1,0);if(this.data.children.length)if(this.data.height===i.height)this._splitRoot(this.data,i);else{if(this.data.height<i.height){var n=this.data;this.data=i,i=n}this._insert(i,this.data.height-i.height-1,!0)}else this.data=i;return this},n.prototype.insert=function(t){return t&&this._insert(t,this.data.height-1),this},n.prototype.clear=function(){return this.data=f([]),this},n.prototype.remove=function(t,e){if(!t)return this;for(var i,n,o,s=this.data,a=this.toBBox(t),l=[],h=[];s||l.length;){if(s||(s=l.pop(),n=l[l.length-1],i=h.pop(),o=!0),s.leaf){var c=r(t,s.children,e);if(-1!==c)return s.children.splice(c,1),l.push(s),this._condense(l),this}o||s.leaf||!d(s,a)?n?(i++,s=n.children[i],o=!1):s=null:(l.push(s),h.push(i),i=0,n=s,s=s.children[0])}return this},n.prototype.toBBox=function(t){return t},n.prototype.compareMinX=function(t,e){return t.minX-e.minX},n.prototype.compareMinY=function(t,e){return t.minY-e.minY},n.prototype.toJSON=function(){return this.data},n.prototype.fromJSON=function(t){return this.data=t,this},n.prototype._all=function(t,e){for(var i=[];t;)t.leaf?e.push.apply(e,t.children):i.push.apply(i,t.children),t=i.pop();return e},n.prototype._build=function(t,e,i,n){var r,s=i-e+1,a=this._maxEntries;if(s<=a)return o(r=f(t.slice(e,i+1)),this.toBBox),r;n||(n=Math.ceil(Math.log(s)/Math.log(a)),a=Math.ceil(s/Math.pow(a,n-1))),(r=f([])).leaf=!1,r.height=n;var l=Math.ceil(s/a),h=l*Math.ceil(Math.sqrt(a));m(t,e,i,h,this.compareMinX);for(var c=e;c<=i;c+=h){var u=Math.min(c+h-1,i);m(t,c,u,l,this.compareMinY);for(var d=c;d<=u;d+=l){var p=Math.min(d+l-1,u);r.children.push(this._build(t,d,p,n-1))}}return o(r,this.toBBox),r},n.prototype._chooseSubtree=function(t,e,i,n){for(;n.push(e),!e.leaf&&n.length-1!==i;){for(var r=1/0,o=1/0,s=void 0,a=0;a<e.children.length;a++){var l=e.children[a],h=c(l),u=(d=t,p=l,(Math.max(p.maxX,d.maxX)-Math.min(p.minX,d.minX))*(Math.max(p.maxY,d.maxY)-Math.min(p.minY,d.minY))-h);u<o?(o=u,r=h<r?h:r,s=l):u===o&&h<r&&(r=h,s=l)}e=s||e.children[0]}var d,p;return e},n.prototype._insert=function(t,e,i){var n=i?t:this.toBBox(t),r=[],o=this._chooseSubtree(n,this.data,e,r);for(o.children.push(t),a(o,n);e>=0&&r[e].children.length>this._maxEntries;)this._split(r,e),e--;this._adjustParentBBoxes(n,r,e)},n.prototype._split=function(t,e){var i=t[e],n=i.children.length,r=this._minEntries;this._chooseSplitAxis(i,r,n);var s=this._chooseSplitIndex(i,r,n),a=f(i.children.splice(s,i.children.length-s));a.height=i.height,a.leaf=i.leaf,o(i,this.toBBox),o(a,this.toBBox),e?t[e-1].children.push(a):this._splitRoot(i,a)},n.prototype._splitRoot=function(t,e){this.data=f([t,e]),this.data.height=t.height+1,this.data.leaf=!1,o(this.data,this.toBBox)},n.prototype._chooseSplitIndex=function(t,e,i){for(var n,r,o,a,l,h,u,d=1/0,p=1/0,f=e;f<=i-e;f++){var m=s(t,0,f,this.toBBox),g=s(t,f,i,this.toBBox),_=(r=m,o=g,a=Math.max(r.minX,o.minX),l=Math.max(r.minY,o.minY),h=Math.min(r.maxX,o.maxX),u=Math.min(r.maxY,o.maxY),Math.max(0,h-a)*Math.max(0,u-l)),y=c(m)+c(g);_<d?(d=_,n=f,p=y<p?y:p):_===d&&y<p&&(p=y,n=f)}return n||i-e},n.prototype._chooseSplitAxis=function(t,e,i){var n=t.leaf?this.compareMinX:l,r=t.leaf?this.compareMinY:h;this._allDistMargin(t,e,i,n)<this._allDistMargin(t,e,i,r)&&t.children.sort(n)},n.prototype._allDistMargin=function(t,e,i,n){t.children.sort(n);for(var r=this.toBBox,o=s(t,0,e,r),l=s(t,i-e,i,r),h=u(o)+u(l),c=e;c<i-e;c++){var d=t.children[c];a(o,t.leaf?r(d):d),h+=u(o)}for(var p=i-e-1;p>=e;p--){var f=t.children[p];a(l,t.leaf?r(f):f),h+=u(l)}return h},n.prototype._adjustParentBBoxes=function(t,e,i){for(var n=i;n>=0;n--)a(e[n],t)},n.prototype._condense=function(t){for(var e=t.length-1,i=void 0;e>=0;e--)0===t[e].children.length?e>0?(i=t[e-1].children).splice(i.indexOf(t[e]),1):this.clear():o(t[e],this.toBBox)},n},"object"==typeof o&&typeof s<"u"?s.exports=a():void 0===(r="function"==typeof(n=a)?n.call(e,i,e,t):n)||(t.exports=r)})),ye=u((t=>{"use strict";function e(t,e,i){void 0===i&&(i={});var n={type:"Feature"};return(0===i.id||i.id)&&(n.id=i.id),i.bbox&&(n.bbox=i.bbox),n.properties=e||{},n.geometry=t,n}function i(t,i,n){if(void 0===n&&(n={}),!t)throw new Error("coordinates is required");if(!Array.isArray(t))throw new Error("coordinates must be an Array");if(t.length<2)throw new Error("coordinates must be at least 2 numbers long");if(!d(t[0])||!d(t[1]))throw new Error("coordinates must contain numbers");return e({type:"Point",coordinates:t},i,n)}function n(t,i,n){void 0===n&&(n={});for(var r=0,o=t;r<o.length;r++){var s=o[r];if(s.length<4)throw new Error("Each LinearRing of a Polygon must have 4 or more Positions.");for(var a=0;a<s[s.length-1].length;a++)if(s[s.length-1][a]!==s[0][a])throw new Error("First and last Position are not equivalent.")}return e({type:"Polygon",coordinates:t},i,n)}function r(t,i,n){if(void 0===n&&(n={}),t.length<2)throw new Error("coordinates must be an array of two or more positions");return e({type:"LineString",coordinates:t},i,n)}function o(t,e){void 0===e&&(e={});var i={type:"FeatureCollection"};return e.id&&(i.id=e.id),e.bbox&&(i.bbox=e.bbox),i.features=t,i}function s(t,i,n){return void 0===n&&(n={}),e({type:"MultiLineString",coordinates:t},i,n)}function a(t,i,n){return void 0===n&&(n={}),e({type:"MultiPoint",coordinates:t},i,n)}function l(t,i,n){return void 0===n&&(n={}),e({type:"MultiPolygon",coordinates:t},i,n)}function h(e,i){void 0===i&&(i="kilometers");var n=t.factors[i];if(!n)throw new Error(i+" units is invalid");return e*n}function c(e,i){void 0===i&&(i="kilometers");var n=t.factors[i];if(!n)throw new Error(i+" units is invalid");return e/n}function u(t){return t%(2*Math.PI)*180/Math.PI}function d(t){return!isNaN(t)&&null!==t&&!Array.isArray(t)}Object.defineProperty(t,"__esModule",{value:!0}),t.earthRadius=6371008.8,t.factors={centimeters:100*t.earthRadius,centimetres:100*t.earthRadius,degrees:t.earthRadius/111325,feet:3.28084*t.earthRadius,inches:39.37*t.earthRadius,kilometers:t.earthRadius/1e3,kilometres:t.earthRadius/1e3,meters:t.earthRadius,metres:t.earthRadius,miles:t.earthRadius/1609.344,millimeters:1e3*t.earthRadius,millimetres:1e3*t.earthRadius,nauticalmiles:t.earthRadius/1852,radians:1,yards:1.0936*t.earthRadius},t.unitsFactors={centimeters:100,centimetres:100,degrees:1/111325,feet:3.28084,inches:39.37,kilometers:.001,kilometres:.001,meters:1,metres:1,miles:1/1609.344,millimeters:1e3,millimetres:1e3,nauticalmiles:1/1852,radians:1/t.earthRadius,yards:1.0936133},t.areaFactors={acres:247105e-9,centimeters:1e4,centimetres:1e4,feet:10.763910417,hectares:1e-4,inches:1550.003100006,kilometers:1e-6,kilometres:1e-6,meters:1,metres:1,miles:386e-9,millimeters:1e6,millimetres:1e6,yards:1.195990046},t.feature=e,t.geometry=function(t,e,o){switch(void 0===o&&(o={}),t){case"Point":return i(e).geometry;case"LineString":return r(e).geometry;case"Polygon":return n(e).geometry;case"MultiPoint":return a(e).geometry;case"MultiLineString":return s(e).geometry;case"MultiPolygon":return l(e).geometry;default:throw new Error(t+" is invalid")}},t.point=i,t.points=function(t,e,n){return void 0===n&&(n={}),o(t.map((function(t){return i(t,e)})),n)},t.polygon=n,t.polygons=function(t,e,i){return void 0===i&&(i={}),o(t.map((function(t){return n(t,e)})),i)},t.lineString=r,t.lineStrings=function(t,e,i){return void 0===i&&(i={}),o(t.map((function(t){return r(t,e)})),i)},t.featureCollection=o,t.multiLineString=s,t.multiPoint=a,t.multiPolygon=l,t.geometryCollection=function(t,i,n){return void 0===n&&(n={}),e({type:"GeometryCollection",geometries:t},i,n)},t.round=function(t,e){if(void 0===e&&(e=0),e&&!(e>=0))throw new Error("precision must be a positive number");var i=Math.pow(10,e||0);return Math.round(t*i)/i},t.radiansToLength=h,t.lengthToRadians=c,t.lengthToDegrees=function(t,e){return u(c(t,e))},t.bearingToAzimuth=function(t){var e=t%360;return e<0&&(e+=360),e},t.radiansToDegrees=u,t.degreesToRadians=function(t){return t%360*Math.PI/180},t.convertLength=function(t,e,i){if(void 0===e&&(e="kilometers"),void 0===i&&(i="kilometers"),!(t>=0))throw new Error("length must be a positive number");return h(c(t,e),i)},t.convertArea=function(e,i,n){if(void 0===i&&(i="meters"),void 0===n&&(n="kilometers"),!(e>=0))throw new Error("area must be a positive number");var r=t.areaFactors[i];if(!r)throw new Error("invalid original units");var o=t.areaFactors[n];if(!o)throw new Error("invalid final units");return e/r*o},t.isNumber=d,t.isObject=function(t){return!!t&&t.constructor===Object},t.validateBBox=function(t){if(!t)throw new Error("bbox is required");if(!Array.isArray(t))throw new Error("bbox must be an Array");if(4!==t.length&&6!==t.length)throw new Error("bbox must be an Array of 4 or 6 numbers");t.forEach((function(t){if(!d(t))throw new Error("bbox must only contain numbers")}))},t.validateId=function(t){if(!t)throw new Error("id is required");if(-1===["string","number"].indexOf(typeof t))throw new Error("id must be a number or a string")}})),ve=u((t=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});var e=ye();function i(t,e,n){if(null!==t)for(var r,o,s,a,l,h,c,u,d=0,p=0,f=t.type,m="FeatureCollection"===f,g="Feature"===f,_=m?t.features.length:1,y=0;y<_;y++){l=(u=!!(c=m?t.features[y].geometry:g?t.geometry:t)&&"GeometryCollection"===c.type)?c.geometries.length:1;for(var v=0;v<l;v++){var b=0,x=0;if(null!==(a=u?c.geometries[v]:c)){h=a.coordinates;var w=a.type;switch(d=!n||"Polygon"!==w&&"MultiPolygon"!==w?0:1,w){case null:break;case"Point":if(!1===e(h,p,y,b,x))return!1;p++,b++;break;case"LineString":case"MultiPoint":for(r=0;r<h.length;r++){if(!1===e(h[r],p,y,b,x))return!1;p++,"MultiPoint"===w&&b++}"LineString"===w&&b++;break;case"Polygon":case"MultiLineString":for(r=0;r<h.length;r++){for(o=0;o<h[r].length-d;o++){if(!1===e(h[r][o],p,y,b,x))return!1;p++}"MultiLineString"===w&&b++,"Polygon"===w&&x++}"Polygon"===w&&b++;break;case"MultiPolygon":for(r=0;r<h.length;r++){for(x=0,o=0;o<h[r].length;o++){for(s=0;s<h[r][o].length-d;s++){if(!1===e(h[r][o][s],p,y,b,x))return!1;p++}x++}b++}break;case"GeometryCollection":for(r=0;r<a.geometries.length;r++)if(!1===i(a.geometries[r],e,n))return!1;break;default:throw new Error("Unknown Geometry Type")}}}}}function n(t,e){var i;switch(t.type){case"FeatureCollection":for(i=0;i<t.features.length&&!1!==e(t.features[i].properties,i);i++);break;case"Feature":e(t.properties,0)}}function r(t,e){if("Feature"===t.type)e(t,0);else if("FeatureCollection"===t.type)for(var i=0;i<t.features.length&&!1!==e(t.features[i],i);i++);}function o(t,e){var i,n,r,o,s,a,l,h,c,u,d=0,p="FeatureCollection"===t.type,f="Feature"===t.type,m=p?t.features.length:1;for(i=0;i<m;i++){for(a=p?t.features[i].geometry:f?t.geometry:t,h=p?t.features[i].properties:f?t.properties:{},c=p?t.features[i].bbox:f?t.bbox:void 0,u=p?t.features[i].id:f?t.id:void 0,s=(l=!!a&&"GeometryCollection"===a.type)?a.geometries.length:1,r=0;r<s;r++)if(null!==(o=l?a.geometries[r]:a))switch(o.type){case"Point":case"LineString":case"MultiPoint":case"Polygon":case"MultiLineString":case"MultiPolygon":if(!1===e(o,d,h,c,u))return!1;break;case"GeometryCollection":for(n=0;n<o.geometries.length;n++)if(!1===e(o.geometries[n],d,h,c,u))return!1;break;default:throw new Error("Unknown Geometry Type")}else if(!1===e(null,d,h,c,u))return!1;d++}}function s(t,i){o(t,(function(t,n,r,o,s){var a,l=null===t?null:t.type;switch(l){case null:case"Point":case"LineString":case"Polygon":return!1!==i(e.feature(t,r,{bbox:o,id:s}),n,0)&&void 0}switch(l){case"MultiPoint":a="Point";break;case"MultiLineString":a="LineString";break;case"MultiPolygon":a="Polygon"}for(var h=0;h<t.coordinates.length;h++){var c={type:a,coordinates:t.coordinates[h]};if(!1===i(e.feature(c,r),n,h))return!1}}))}function a(t,n){s(t,(function(t,r,o){var s=0;if(t.geometry){var a=t.geometry.type;if("Point"!==a&&"MultiPoint"!==a){var l,h=0,c=0,u=0;if(!1===i(t,(function(i,a,d,p,f){if(void 0===l||r>h||p>c||f>u)return l=i,h=r,c=p,u=f,void(s=0);var m=e.lineString([l,i],t.properties);if(!1===n(m,r,o,f,s))return!1;s++,l=i})))return!1}}}))}function l(t,i){if(!t)throw new Error("geojson is required");s(t,(function(t,n,r){if(null!==t.geometry){var o=t.geometry.type,s=t.geometry.coordinates;switch(o){case"LineString":if(!1===i(t,n,r,0,0))return!1;break;case"Polygon":for(var a=0;a<s.length;a++)if(!1===i(e.lineString(s[a],t.properties),n,r,a))return!1}}}))}t.coordAll=function(t){var e=[];return i(t,(function(t){e.push(t)})),e},t.coordEach=i,t.coordReduce=function(t,e,n,r){var o=n;return i(t,(function(t,i,r,s,a){o=0===i&&void 0===n?t:e(o,t,i,r,s,a)}),r),o},t.featureEach=r,t.featureReduce=function(t,e,i){var n=i;return r(t,(function(t,r){n=0===r&&void 0===i?t:e(n,t,r)})),n},t.findPoint=function(t,i){if(i=i||{},!e.isObject(i))throw new Error("options is invalid");var n,r=i.featureIndex||0,o=i.multiFeatureIndex||0,s=i.geometryIndex||0,a=i.coordIndex||0,l=i.properties;switch(t.type){case"FeatureCollection":r<0&&(r=t.features.length+r),l=l||t.features[r].properties,n=t.features[r].geometry;break;case"Feature":l=l||t.properties,n=t.geometry;break;case"Point":case"MultiPoint":return null;case"LineString":case"Polygon":case"MultiLineString":case"MultiPolygon":n=t;break;default:throw new Error("geojson is invalid")}if(null===n)return null;var h=n.coordinates;switch(n.type){case"Point":return e.point(h,l,i);case"MultiPoint":return o<0&&(o=h.length+o),e.point(h[o],l,i);case"LineString":return a<0&&(a=h.length+a),e.point(h[a],l,i);case"Polygon":return s<0&&(s=h.length+s),a<0&&(a=h[s].length+a),e.point(h[s][a],l,i);case"MultiLineString":return o<0&&(o=h.length+o),a<0&&(a=h[o].length+a),e.point(h[o][a],l,i);case"MultiPolygon":return o<0&&(o=h.length+o),s<0&&(s=h[o].length+s),a<0&&(a=h[o][s].length-a),e.point(h[o][s][a],l,i)}throw new Error("geojson is invalid")},t.findSegment=function(t,i){if(i=i||{},!e.isObject(i))throw new Error("options is invalid");var n,r=i.featureIndex||0,o=i.multiFeatureIndex||0,s=i.geometryIndex||0,a=i.segmentIndex||0,l=i.properties;switch(t.type){case"FeatureCollection":r<0&&(r=t.features.length+r),l=l||t.features[r].properties,n=t.features[r].geometry;break;case"Feature":l=l||t.properties,n=t.geometry;break;case"Point":case"MultiPoint":return null;case"LineString":case"Polygon":case"MultiLineString":case"MultiPolygon":n=t;break;default:throw new Error("geojson is invalid")}if(null===n)return null;var h=n.coordinates;switch(n.type){case"Point":case"MultiPoint":return null;case"LineString":return a<0&&(a=h.length+a-1),e.lineString([h[a],h[a+1]],l,i);case"Polygon":return s<0&&(s=h.length+s),a<0&&(a=h[s].length+a-1),e.lineString([h[s][a],h[s][a+1]],l,i);case"MultiLineString":return o<0&&(o=h.length+o),a<0&&(a=h[o].length+a-1),e.lineString([h[o][a],h[o][a+1]],l,i);case"MultiPolygon":return o<0&&(o=h.length+o),s<0&&(s=h[o].length+s),a<0&&(a=h[o][s].length-a-1),e.lineString([h[o][s][a],h[o][s][a+1]],l,i)}throw new Error("geojson is invalid")},t.flattenEach=s,t.flattenReduce=function(t,e,i){var n=i;return s(t,(function(t,r,o){n=0===r&&0===o&&void 0===i?t:e(n,t,r,o)})),n},t.geomEach=o,t.geomReduce=function(t,e,i){var n=i;return o(t,(function(t,r,o,s,a){n=0===r&&void 0===i?t:e(n,t,r,o,s,a)})),n},t.lineEach=l,t.lineReduce=function(t,e,i){var n=i;return l(t,(function(t,r,o,s){n=0===r&&void 0===i?t:e(n,t,r,o,s)})),n},t.propEach=n,t.propReduce=function(t,e,i){var r=i;return n(t,(function(t,n){r=0===n&&void 0===i?t:e(r,t,n)})),r},t.segmentEach=a,t.segmentReduce=function(t,e,i){var n=i,r=!1;return a(t,(function(t,o,s,a,l){n=!1===r&&void 0===i?t:e(n,t,o,s,a,l),r=!0})),n}})),be=u((t=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});var e=ve();function i(t){var i=[1/0,1/0,-1/0,-1/0];return e.coordEach(t,(function(t){i[0]>t[0]&&(i[0]=t[0]),i[1]>t[1]&&(i[1]=t[1]),i[2]<t[0]&&(i[2]=t[0]),i[3]<t[1]&&(i[3]=t[1])})),i}i.default=i,t.default=i})),xe=u(((t,e)=>{var i=_e(),n=ye(),r=ve(),o=be().default,s=r.featureEach,a=(r.coordEach,n.polygon,n.featureCollection);function l(t){var e=new i(t);return e.insert=function(t){if("Feature"!==t.type)throw new Error("invalid feature");return t.bbox=t.bbox?t.bbox:o(t),i.prototype.insert.call(this,t)},e.load=function(t){var e=[];return Array.isArray(t)?t.forEach((function(t){if("Feature"!==t.type)throw new Error("invalid features");t.bbox=t.bbox?t.bbox:o(t),e.push(t)})):s(t,(function(t){if("Feature"!==t.type)throw new Error("invalid features");t.bbox=t.bbox?t.bbox:o(t),e.push(t)})),i.prototype.load.call(this,e)},e.remove=function(t,e){if("Feature"!==t.type)throw new Error("invalid feature");return t.bbox=t.bbox?t.bbox:o(t),i.prototype.remove.call(this,t,e)},e.clear=function(){return i.prototype.clear.call(this)},e.search=function(t){var e=i.prototype.search.call(this,this.toBBox(t));return a(e)},e.collides=function(t){return i.prototype.collides.call(this,this.toBBox(t))},e.all=function(){var t=i.prototype.all.call(this);return a(t)},e.toJSON=function(){return i.prototype.toJSON.call(this)},e.fromJSON=function(t){return i.prototype.fromJSON.call(this,t)},e.toBBox=function(t){var e;if(t.bbox)e=t.bbox;else if(Array.isArray(t)&&4===t.length)e=t;else if(Array.isArray(t)&&6===t.length)e=[t[0],t[1],t[3],t[4]];else if("Feature"===t.type)e=o(t);else{if("FeatureCollection"!==t.type)throw new Error("invalid geojson");e=o(t)}return{minX:e[0],minY:e[1],maxX:e[2],maxY:e[3]}},e}e.exports=l,e.exports.default=l})),we=u(((o,s)=>{var a;a=function(){"use strict";function t(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}function e(t,e){for(var i=0;i<e.length;i++){var n=e[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n)}}function i(t,i,n){return i&&e(t.prototype,i),n&&e(t,n),t}var n=function(t,e){this.next=null,this.key=t,this.data=e,this.left=null,this.right=null};function r(t,e){return t>e?1:t<e?-1:0}function o(t,e,i){for(var r=new n(null,null),o=r,s=r;;){var a=i(t,e.key);if(a<0){if(null===e.left)break;if(i(t,e.left.key)<0){var l=e.left;if(e.left=l.right,l.right=e,null===(e=l).left)break}s.left=e,s=e,e=e.left}else{if(!(a>0))break;if(null===e.right)break;if(i(t,e.right.key)>0&&(l=e.right,e.right=l.left,l.left=e,null===(e=l).right))break;o.right=e,o=e,e=e.right}}return o.right=e.left,s.left=e.right,e.left=r.right,e.right=r.left,e}function s(t,e,i,r){var s=new n(t,e);if(null===i)return s.left=s.right=null,s;var a=r(t,(i=o(t,i,r)).key);return a<0?(s.left=i.left,s.right=i,i.left=null):a>=0&&(s.right=i.right,s.left=i,i.right=null),s}function a(t,e,i){var n=null,r=null;if(e){var s=i((e=o(t,e,i)).key,t);0===s?(n=e.left,r=e.right):s<0?(r=e.right,e.right=null,n=e):(n=e.left,e.left=null,r=e)}return{left:n,right:r}}function l(t,e,i,n,r){if(t){n(e+(i?"└── ":"├── ")+r(t)+"\n");var o=e+(i?"    ":"│   ");t.left&&l(t.left,o,!1,n,r),t.right&&l(t.right,o,!0,n,r)}}var h=function(){function t(t){void 0===t&&(t=r),this._root=null,this._size=0,this._comparator=t}return t.prototype.insert=function(t,e){return this._size++,this._root=s(t,e,this._root,this._comparator)},t.prototype.add=function(t,e){var i=new n(t,e);null===this._root&&(i.left=i.right=null,this._size++,this._root=i);var r=this._comparator,s=o(t,this._root,r),a=r(t,s.key);return 0===a?this._root=s:(a<0?(i.left=s.left,i.right=s,s.left=null):a>0&&(i.right=s.right,i.left=s,s.right=null),this._size++,this._root=i),this._root},t.prototype.remove=function(t){this._root=this._remove(t,this._root,this._comparator)},t.prototype._remove=function(t,e,i){var n;return null===e?null:0===i(t,(e=o(t,e,i)).key)?(null===e.left?n=e.right:(n=o(t,e.left,i)).right=e.right,this._size--,n):e},t.prototype.pop=function(){var t=this._root;if(t){for(;t.left;)t=t.left;return this._root=o(t.key,this._root,this._comparator),this._root=this._remove(t.key,this._root,this._comparator),{key:t.key,data:t.data}}return null},t.prototype.findStatic=function(t){for(var e=this._root,i=this._comparator;e;){var n=i(t,e.key);if(0===n)return e;e=n<0?e.left:e.right}return null},t.prototype.find=function(t){return this._root&&(this._root=o(t,this._root,this._comparator),0!==this._comparator(t,this._root.key))?null:this._root},t.prototype.contains=function(t){for(var e=this._root,i=this._comparator;e;){var n=i(t,e.key);if(0===n)return!0;e=n<0?e.left:e.right}return!1},t.prototype.forEach=function(t,e){for(var i=this._root,n=[],r=!1;!r;)null!==i?(n.push(i),i=i.left):0!==n.length?(i=n.pop(),t.call(e,i),i=i.right):r=!0;return this},t.prototype.range=function(t,e,i,n){for(var r=[],o=this._comparator,s=this._root;0!==r.length||s;)if(s)r.push(s),s=s.left;else{if(o((s=r.pop()).key,e)>0)break;if(o(s.key,t)>=0&&i.call(n,s))return this;s=s.right}return this},t.prototype.keys=function(){var t=[];return this.forEach((function(e){var i=e.key;return t.push(i)})),t},t.prototype.values=function(){var t=[];return this.forEach((function(e){var i=e.data;return t.push(i)})),t},t.prototype.min=function(){return this._root?this.minNode(this._root).key:null},t.prototype.max=function(){return this._root?this.maxNode(this._root).key:null},t.prototype.minNode=function(t){if(void 0===t&&(t=this._root),t)for(;t.left;)t=t.left;return t},t.prototype.maxNode=function(t){if(void 0===t&&(t=this._root),t)for(;t.right;)t=t.right;return t},t.prototype.at=function(t){for(var e=this._root,i=!1,n=0,r=[];!i;)if(e)r.push(e),e=e.left;else if(r.length>0){if(e=r.pop(),n===t)return e;n++,e=e.right}else i=!0;return null},t.prototype.next=function(t){var e=this._root,i=null;if(t.right){for(i=t.right;i.left;)i=i.left;return i}for(var n=this._comparator;e;){var r=n(t.key,e.key);if(0===r)break;r<0?(i=e,e=e.left):e=e.right}return i},t.prototype.prev=function(t){var e=this._root,i=null;if(null!==t.left){for(i=t.left;i.right;)i=i.right;return i}for(var n=this._comparator;e;){var r=n(t.key,e.key);if(0===r)break;r<0?e=e.left:(i=e,e=e.right)}return i},t.prototype.clear=function(){return this._root=null,this._size=0,this},t.prototype.toList=function(){return function(t){for(var e=t,i=[],r=!1,o=new n(null,null),s=o;!r;)e?(i.push(e),e=e.left):i.length>0?e=(e=s=s.next=i.pop()).right:r=!0;return s.next=null,o.next}(this._root)},t.prototype.load=function(t,e,i){void 0===e&&(e=[]),void 0===i&&(i=!1);var r=t.length,o=this._comparator;if(i&&d(t,e,0,r-1,o),null===this._root)this._root=c(t,e,0,r),this._size=r;else{var s=function(t,e,i){for(var r=new n(null,null),o=r,s=t,a=e;null!==s&&null!==a;)i(s.key,a.key)<0?(o.next=s,s=s.next):(o.next=a,a=a.next),o=o.next;return null!==s?o.next=s:null!==a&&(o.next=a),r.next}(this.toList(),function(t,e){for(var i=new n(null,null),r=i,o=0;o<t.length;o++)r=r.next=new n(t[o],e[o]);return r.next=null,i.next}(t,e),o);r=this._size+r,this._root=u({head:s},0,r)}return this},t.prototype.isEmpty=function(){return null===this._root},Object.defineProperty(t.prototype,"size",{get:function(){return this._size},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"root",{get:function(){return this._root},enumerable:!0,configurable:!0}),t.prototype.toString=function(t){void 0===t&&(t=function(t){return String(t.key)});var e=[];return l(this._root,"",!0,(function(t){return e.push(t)}),t),e.join("")},t.prototype.update=function(t,e,i){var n=this._comparator,r=a(t,this._root,n),l=r.left,h=r.right;n(t,e)<0?h=s(e,i,h,n):l=s(e,i,l,n),this._root=function(t,e,i){return null===e?t:(null===t||((e=o(t.key,e,i)).left=t),e)}(l,h,n)},t.prototype.split=function(t){return a(t,this._root,this._comparator)},t}();function c(t,e,i,r){var o=r-i;if(o>0){var s=i+Math.floor(o/2),a=t[s],l=e[s],h=new n(a,l);return h.left=c(t,e,i,s),h.right=c(t,e,s+1,r),h}return null}function u(t,e,i){var n=i-e;if(n>0){var r=e+Math.floor(n/2),o=u(t,e,r),s=t.head;return s.left=o,t.head=t.head.next,s.right=u(t,r+1,i),s}return null}function d(t,e,i,n,r){if(!(i>=n)){for(var o=t[i+n>>1],s=i-1,a=n+1;;){do{s++}while(r(t[s],o)<0);do{a--}while(r(t[a],o)>0);if(s>=a)break;var l=t[s];t[s]=t[a],t[a]=l,l=e[s],e[s]=e[a],e[a]=l}d(t,e,i,a,r),d(t,e,a+1,n,r)}}var p=function(t,e){return t.ll.x<=e.x&&e.x<=t.ur.x&&t.ll.y<=e.y&&e.y<=t.ur.y},f=function(t,e){if(e.ur.x<t.ll.x||t.ur.x<e.ll.x||e.ur.y<t.ll.y||t.ur.y<e.ll.y)return null;var i=t.ll.x<e.ll.x?e.ll.x:t.ll.x,n=t.ur.x<e.ur.x?t.ur.x:e.ur.x;return{ll:{x:i,y:t.ll.y<e.ll.y?e.ll.y:t.ll.y},ur:{x:n,y:t.ur.y<e.ur.y?t.ur.y:e.ur.y}}},m=Number.EPSILON;void 0===m&&(m=Math.pow(2,-52));var g=m*m,_=function(t,e){if(-m<t&&t<m&&-m<e&&e<m)return 0;var i=t-e;return i*i<g*t*e?0:t<e?-1:1},y=function(){function e(){t(this,e),this.reset()}return i(e,[{key:"reset",value:function(){this.xRounder=new v,this.yRounder=new v}},{key:"round",value:function(t,e){return{x:this.xRounder.round(t),y:this.yRounder.round(e)}}}]),e}(),v=function(){function e(){t(this,e),this.tree=new h,this.round(0)}return i(e,[{key:"round",value:function(t){var e=this.tree.add(t),i=this.tree.prev(e);if(null!==i&&0===_(e.key,i.key))return this.tree.remove(t),i.key;var n=this.tree.next(e);return null!==n&&0===_(e.key,n.key)?(this.tree.remove(t),n.key):t}}]),e}(),b=new y,x=function(t,e){return t.x*e.y-t.y*e.x},w=function(t,e){return t.x*e.x+t.y*e.y},L=function(t,e,i){var n={x:e.x-t.x,y:e.y-t.y},r={x:i.x-t.x,y:i.y-t.y},o=x(n,r);return _(o,0)},M=function(t){return Math.sqrt(w(t,t))},k=function(t,e,i){var n={x:e.x-t.x,y:e.y-t.y},r={x:i.x-t.x,y:i.y-t.y};return x(r,n)/M(r)/M(n)},C=function(t,e,i){var n={x:e.x-t.x,y:e.y-t.y},r={x:i.x-t.x,y:i.y-t.y};return w(r,n)/M(r)/M(n)},A=function(t,e,i){return 0===e.y?null:{x:t.x+e.x/e.y*(i-t.y),y:i}},P=function(t,e,i){return 0===e.x?null:{x:i,y:t.y+e.y/e.x*(i-t.x)}},S=function(){function e(i,n){t(this,e),void 0===i.events?i.events=[this]:i.events.push(this),this.point=i,this.isLeft=n}return i(e,null,[{key:"compare",value:function(t,i){var n=e.comparePoints(t.point,i.point);return 0!==n?n:(t.point!==i.point&&t.link(i),t.isLeft!==i.isLeft?t.isLeft?1:-1:I.compare(t.segment,i.segment))}},{key:"comparePoints",value:function(t,e){return t.x<e.x?-1:t.x>e.x?1:t.y<e.y?-1:t.y>e.y?1:0}}]),i(e,[{key:"link",value:function(t){if(t.point===this.point)throw new Error("Tried to link already linked events");for(var e=t.point.events,i=0,n=e.length;i<n;i++){var r=e[i];this.point.events.push(r),r.point=this.point}this.checkForConsuming()}},{key:"checkForConsuming",value:function(){for(var t=this.point.events.length,e=0;e<t;e++){var i=this.point.events[e];if(void 0===i.segment.consumedBy)for(var n=e+1;n<t;n++){var r=this.point.events[n];void 0===r.consumedBy&&i.otherSE.point.events===r.otherSE.point.events&&i.segment.consume(r.segment)}}}},{key:"getAvailableLinkedEvents",value:function(){for(var t=[],e=0,i=this.point.events.length;e<i;e++){var n=this.point.events[e];n!==this&&!n.segment.ringOut&&n.segment.isInResult()&&t.push(n)}return t}},{key:"getLeftmostComparator",value:function(t){var e=this,i=new Map,n=function(n){var r=n.otherSE;i.set(n,{sine:k(e.point,t.point,r.point),cosine:C(e.point,t.point,r.point)})};return function(t,e){i.has(t)||n(t),i.has(e)||n(e);var r=i.get(t),o=r.sine,s=r.cosine,a=i.get(e),l=a.sine,h=a.cosine;return o>=0&&l>=0?s<h?1:s>h?-1:0:o<0&&l<0?s<h?-1:s>h?1:0:l<o?-1:l>o?1:0}}}]),e}(),E=0,I=function(){function e(i,n,r,o){t(this,e),this.id=++E,this.leftSE=i,i.segment=this,i.otherSE=n,this.rightSE=n,n.segment=this,n.otherSE=i,this.rings=r,this.windings=o}return i(e,null,[{key:"compare",value:function(t,e){var i=t.leftSE.point.x,n=e.leftSE.point.x,r=t.rightSE.point.x,o=e.rightSE.point.x;if(o<i)return 1;if(r<n)return-1;var s=t.leftSE.point.y,a=e.leftSE.point.y,l=t.rightSE.point.y,h=e.rightSE.point.y;if(i<n){if(a<s&&a<l)return 1;if(a>s&&a>l)return-1;var c=t.comparePoint(e.leftSE.point);if(c<0)return 1;if(c>0)return-1;var u=e.comparePoint(t.rightSE.point);return 0!==u?u:-1}if(i>n){if(s<a&&s<h)return-1;if(s>a&&s>h)return 1;var d=e.comparePoint(t.leftSE.point);if(0!==d)return d;var p=t.comparePoint(e.rightSE.point);return p<0?1:p>0?-1:1}if(s<a)return-1;if(s>a)return 1;if(r<o){var f=e.comparePoint(t.rightSE.point);if(0!==f)return f}if(r>o){var m=t.comparePoint(e.rightSE.point);if(m<0)return 1;if(m>0)return-1}if(r!==o){var g=l-s,_=r-i,y=h-a,v=o-n;if(g>_&&y<v)return 1;if(g<_&&y>v)return-1}return r>o?1:r<o||l<h?-1:l>h?1:t.id<e.id?-1:t.id>e.id?1:0}}]),i(e,[{key:"replaceRightSE",value:function(t){this.rightSE=t,this.rightSE.segment=this,this.rightSE.otherSE=this.leftSE,this.leftSE.otherSE=this.rightSE}},{key:"bbox",value:function(){var t=this.leftSE.point.y,e=this.rightSE.point.y;return{ll:{x:this.leftSE.point.x,y:t<e?t:e},ur:{x:this.rightSE.point.x,y:t>e?t:e}}}},{key:"vector",value:function(){return{x:this.rightSE.point.x-this.leftSE.point.x,y:this.rightSE.point.y-this.leftSE.point.y}}},{key:"isAnEndpoint",value:function(t){return t.x===this.leftSE.point.x&&t.y===this.leftSE.point.y||t.x===this.rightSE.point.x&&t.y===this.rightSE.point.y}},{key:"comparePoint",value:function(t){if(this.isAnEndpoint(t))return 0;var e=this.leftSE.point,i=this.rightSE.point,n=this.vector();if(e.x===i.x)return t.x===e.x?0:t.x<e.x?1:-1;var r=(t.y-e.y)/n.y,o=e.x+r*n.x;if(t.x===o)return 0;var s=(t.x-e.x)/n.x,a=e.y+s*n.y;return t.y===a?0:t.y<a?-1:1}},{key:"getIntersection",value:function(t){var e=this.bbox(),i=t.bbox(),n=f(e,i);if(null===n)return null;var r=this.leftSE.point,o=this.rightSE.point,s=t.leftSE.point,a=t.rightSE.point,l=p(e,s)&&0===this.comparePoint(s),h=p(i,r)&&0===t.comparePoint(r),c=p(e,a)&&0===this.comparePoint(a),u=p(i,o)&&0===t.comparePoint(o);if(h&&l)return u&&!c?o:!u&&c?a:null;if(h)return c&&r.x===a.x&&r.y===a.y?null:r;if(l)return u&&o.x===s.x&&o.y===s.y?null:s;if(u&&c)return null;if(u)return o;if(c)return a;var d=function(t,e,i,n){if(0===e.x)return P(i,n,t.x);if(0===n.x)return P(t,e,i.x);if(0===e.y)return A(i,n,t.y);if(0===n.y)return A(t,e,i.y);var r=x(e,n);if(0==r)return null;var o={x:i.x-t.x,y:i.y-t.y},s=x(o,e)/r,a=x(o,n)/r;return{x:(t.x+a*e.x+(i.x+s*n.x))/2,y:(t.y+a*e.y+(i.y+s*n.y))/2}}(r,this.vector(),s,t.vector());return null!==d&&p(n,d)?b.round(d.x,d.y):null}},{key:"split",value:function(t){var i=[],n=void 0!==t.events,r=new S(t,!0),o=new S(t,!1),s=this.rightSE;this.replaceRightSE(o),i.push(o),i.push(r);var a=new e(r,s,this.rings.slice(),this.windings.slice());return S.comparePoints(a.leftSE.point,a.rightSE.point)>0&&a.swapEvents(),S.comparePoints(this.leftSE.point,this.rightSE.point)>0&&this.swapEvents(),n&&(r.checkForConsuming(),o.checkForConsuming()),i}},{key:"swapEvents",value:function(){var t=this.rightSE;this.rightSE=this.leftSE,this.leftSE=t,this.leftSE.isLeft=!0,this.rightSE.isLeft=!1;for(var e=0,i=this.windings.length;e<i;e++)this.windings[e]*=-1}},{key:"consume",value:function(t){for(var i=this,n=t;i.consumedBy;)i=i.consumedBy;for(;n.consumedBy;)n=n.consumedBy;var r=e.compare(i,n);if(0!==r){if(r>0){var o=i;i=n,n=o}if(i.prev===n){var s=i;i=n,n=s}for(var a=0,l=n.rings.length;a<l;a++){var h=n.rings[a],c=n.windings[a],u=i.rings.indexOf(h);-1===u?(i.rings.push(h),i.windings.push(c)):i.windings[u]+=c}n.rings=null,n.windings=null,n.consumedBy=i,n.leftSE.consumedBy=i.leftSE,n.rightSE.consumedBy=i.rightSE}}},{key:"prevInResult",value:function(){return void 0!==this._prevInResult||(this.prev?this.prev.isInResult()?this._prevInResult=this.prev:this._prevInResult=this.prev.prevInResult():this._prevInResult=null),this._prevInResult}},{key:"beforeState",value:function(){if(void 0!==this._beforeState)return this._beforeState;if(this.prev){var t=this.prev.consumedBy||this.prev;this._beforeState=t.afterState()}else this._beforeState={rings:[],windings:[],multiPolys:[]};return this._beforeState}},{key:"afterState",value:function(){if(void 0!==this._afterState)return this._afterState;var t=this.beforeState();this._afterState={rings:t.rings.slice(0),windings:t.windings.slice(0),multiPolys:[]};for(var e=this._afterState.rings,i=this._afterState.windings,n=this._afterState.multiPolys,r=0,o=this.rings.length;r<o;r++){var s=this.rings[r],a=this.windings[r],l=e.indexOf(s);-1===l?(e.push(s),i.push(a)):i[l]+=a}for(var h=[],c=[],u=0,d=e.length;u<d;u++)if(0!==i[u]){var p=e[u],f=p.poly;if(-1===c.indexOf(f))if(p.isExterior)h.push(f);else{-1===c.indexOf(f)&&c.push(f);var m=h.indexOf(p.poly);-1!==m&&h.splice(m,1)}}for(var g=0,_=h.length;g<_;g++){var y=h[g].multiPoly;-1===n.indexOf(y)&&n.push(y)}return this._afterState}},{key:"isInResult",value:function(){if(this.consumedBy)return!1;if(void 0!==this._isInResult)return this._isInResult;var t=this.beforeState().multiPolys,e=this.afterState().multiPolys;switch(G.type){case"union":var i=0===t.length,n=0===e.length;this._isInResult=i!==n;break;case"intersection":var r,o;t.length<e.length?(r=t.length,o=e.length):(r=e.length,o=t.length),this._isInResult=o===G.numMultiPolys&&r<o;break;case"xor":var s=Math.abs(t.length-e.length);this._isInResult=s%2==1;break;case"difference":var a=function(t){return 1===t.length&&t[0].isSubject};this._isInResult=a(t)!==a(e);break;default:throw new Error("Unrecognized operation type found ".concat(G.type))}return this._isInResult}}],[{key:"fromRing",value:function(t,i,n){var r,o,s,a=S.comparePoints(t,i);if(a<0)r=t,o=i,s=1;else{if(!(a>0))throw new Error("Tried to create degenerate segment at [".concat(t.x,", ").concat(t.y,"]"));r=i,o=t,s=-1}return new e(new S(r,!0),new S(o,!1),[n],[s])}}]),e}(),T=function(){function e(i,n,r){if(t(this,e),!Array.isArray(i)||0===i.length)throw new Error("Input geometry is not a valid Polygon or MultiPolygon");if(this.poly=n,this.isExterior=r,this.segments=[],"number"!=typeof i[0][0]||"number"!=typeof i[0][1])throw new Error("Input geometry is not a valid Polygon or MultiPolygon");var o=b.round(i[0][0],i[0][1]);this.bbox={ll:{x:o.x,y:o.y},ur:{x:o.x,y:o.y}};for(var s=o,a=1,l=i.length;a<l;a++){if("number"!=typeof i[a][0]||"number"!=typeof i[a][1])throw new Error("Input geometry is not a valid Polygon or MultiPolygon");var h=b.round(i[a][0],i[a][1]);h.x===s.x&&h.y===s.y||(this.segments.push(I.fromRing(s,h,this)),h.x<this.bbox.ll.x&&(this.bbox.ll.x=h.x),h.y<this.bbox.ll.y&&(this.bbox.ll.y=h.y),h.x>this.bbox.ur.x&&(this.bbox.ur.x=h.x),h.y>this.bbox.ur.y&&(this.bbox.ur.y=h.y),s=h)}(o.x!==s.x||o.y!==s.y)&&this.segments.push(I.fromRing(s,o,this))}return i(e,[{key:"getSweepEvents",value:function(){for(var t=[],e=0,i=this.segments.length;e<i;e++){var n=this.segments[e];t.push(n.leftSE),t.push(n.rightSE)}return t}}]),e}(),D=function(){function e(i,n){if(t(this,e),!Array.isArray(i))throw new Error("Input geometry is not a valid Polygon or MultiPolygon");this.exteriorRing=new T(i[0],this,!0),this.bbox={ll:{x:this.exteriorRing.bbox.ll.x,y:this.exteriorRing.bbox.ll.y},ur:{x:this.exteriorRing.bbox.ur.x,y:this.exteriorRing.bbox.ur.y}},this.interiorRings=[];for(var r=1,o=i.length;r<o;r++){var s=new T(i[r],this,!1);s.bbox.ll.x<this.bbox.ll.x&&(this.bbox.ll.x=s.bbox.ll.x),s.bbox.ll.y<this.bbox.ll.y&&(this.bbox.ll.y=s.bbox.ll.y),s.bbox.ur.x>this.bbox.ur.x&&(this.bbox.ur.x=s.bbox.ur.x),s.bbox.ur.y>this.bbox.ur.y&&(this.bbox.ur.y=s.bbox.ur.y),this.interiorRings.push(s)}this.multiPoly=n}return i(e,[{key:"getSweepEvents",value:function(){for(var t=this.exteriorRing.getSweepEvents(),e=0,i=this.interiorRings.length;e<i;e++)for(var n=this.interiorRings[e].getSweepEvents(),r=0,o=n.length;r<o;r++)t.push(n[r]);return t}}]),e}(),z=function(){function e(i,n){if(t(this,e),!Array.isArray(i))throw new Error("Input geometry is not a valid Polygon or MultiPolygon");try{"number"==typeof i[0][0][0]&&(i=[i])}catch{}this.polys=[],this.bbox={ll:{x:Number.POSITIVE_INFINITY,y:Number.POSITIVE_INFINITY},ur:{x:Number.NEGATIVE_INFINITY,y:Number.NEGATIVE_INFINITY}};for(var r=0,o=i.length;r<o;r++){var s=new D(i[r],this);s.bbox.ll.x<this.bbox.ll.x&&(this.bbox.ll.x=s.bbox.ll.x),s.bbox.ll.y<this.bbox.ll.y&&(this.bbox.ll.y=s.bbox.ll.y),s.bbox.ur.x>this.bbox.ur.x&&(this.bbox.ur.x=s.bbox.ur.x),s.bbox.ur.y>this.bbox.ur.y&&(this.bbox.ur.y=s.bbox.ur.y),this.polys.push(s)}this.isSubject=n}return i(e,[{key:"getSweepEvents",value:function(){for(var t=[],e=0,i=this.polys.length;e<i;e++)for(var n=this.polys[e].getSweepEvents(),r=0,o=n.length;r<o;r++)t.push(n[r]);return t}}]),e}(),B=function(){function e(i){t(this,e),this.events=i;for(var n=0,r=i.length;n<r;n++)i[n].segment.ringOut=this;this.poly=null}return i(e,null,[{key:"factory",value:function(t){for(var i=[],n=0,r=t.length;n<r;n++){var o=t[n];if(o.isInResult()&&!o.ringOut){for(var s=null,a=o.leftSE,l=o.rightSE,h=[a],c=a.point,u=[];s=a,a=l,h.push(a),a.point!==c;)for(;;){var d=a.getAvailableLinkedEvents();if(0===d.length){var p=h[0].point,f=h[h.length-1].point;throw new Error("Unable to complete output ring starting at [".concat(p.x,",")+" ".concat(p.y,"]. Last matching segment found ends at")+" [".concat(f.x,", ").concat(f.y,"]."))}if(1===d.length){l=d[0].otherSE;break}for(var m=null,g=0,_=u.length;g<_;g++)if(u[g].point===a.point){m=g;break}if(null===m){u.push({index:h.length,point:a.point});var y=a.getLeftmostComparator(s);l=d.sort(y)[0].otherSE;break}var v=u.splice(m)[0],b=h.splice(v.index);b.unshift(b[0].otherSE),i.push(new e(b.reverse()))}i.push(new e(h))}}return i}}]),i(e,[{key:"getGeom",value:function(){for(var t=this.events[0].point,e=[t],i=1,n=this.events.length-1;i<n;i++){var r=this.events[i].point,o=this.events[i+1].point;0!==L(r,t,o)&&(e.push(r),t=r)}if(1===e.length)return null;var s=e[0],a=e[1];0===L(s,t,a)&&e.shift(),e.push(e[0]);for(var l=this.isExteriorRing()?1:-1,h=this.isExteriorRing()?0:e.length-1,c=this.isExteriorRing()?e.length:-1,u=[],d=h;d!=c;d+=l)u.push([e[d].x,e[d].y]);return u}},{key:"isExteriorRing",value:function(){if(void 0===this._isExteriorRing){var t=this.enclosingRing();this._isExteriorRing=!t||!t.isExteriorRing()}return this._isExteriorRing}},{key:"enclosingRing",value:function(){return void 0===this._enclosingRing&&(this._enclosingRing=this._calcEnclosingRing()),this._enclosingRing}},{key:"_calcEnclosingRing",value:function(){for(var t=this.events[0],e=1,i=this.events.length;e<i;e++){var n=this.events[e];S.compare(t,n)>0&&(t=n)}for(var r=t.segment.prevInResult(),o=r?r.prevInResult():null;;){if(!r)return null;if(!o)return r.ringOut;if(o.ringOut!==r.ringOut)return o.ringOut.enclosingRing()!==r.ringOut?r.ringOut:r.ringOut.enclosingRing();r=o.prevInResult(),o=r?r.prevInResult():null}}}]),e}(),O=function(){function e(i){t(this,e),this.exteriorRing=i,i.poly=this,this.interiorRings=[]}return i(e,[{key:"addInterior",value:function(t){this.interiorRings.push(t),t.poly=this}},{key:"getGeom",value:function(){var t=[this.exteriorRing.getGeom()];if(null===t[0])return null;for(var e=0,i=this.interiorRings.length;e<i;e++){var n=this.interiorRings[e].getGeom();null!==n&&t.push(n)}return t}}]),e}(),R=function(){function e(i){t(this,e),this.rings=i,this.polys=this._composePolys(i)}return i(e,[{key:"getGeom",value:function(){for(var t=[],e=0,i=this.polys.length;e<i;e++){var n=this.polys[e].getGeom();null!==n&&t.push(n)}return t}},{key:"_composePolys",value:function(t){for(var e=[],i=0,n=t.length;i<n;i++){var r=t[i];if(!r.poly)if(r.isExteriorRing())e.push(new O(r));else{var o=r.enclosingRing();o.poly||e.push(new O(o)),o.poly.addInterior(r)}}return e}}]),e}(),j=function(){function e(i){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:I.compare;t(this,e),this.queue=i,this.tree=new h(n),this.segments=[]}return i(e,[{key:"process",value:function(t){var e=t.segment,i=[];if(t.consumedBy)return t.isLeft?this.queue.remove(t.otherSE):this.tree.remove(e),i;var n=t.isLeft?this.tree.insert(e):this.tree.find(e);if(!n)throw new Error("Unable to find segment #".concat(e.id," ")+"[".concat(e.leftSE.point.x,", ").concat(e.leftSE.point.y,"] -> ")+"[".concat(e.rightSE.point.x,", ").concat(e.rightSE.point.y,"] ")+"in SweepLine tree. Please submit a bug report.");for(var r=n,o=n,s=void 0,a=void 0;void 0===s;)null===(r=this.tree.prev(r))?s=null:void 0===r.key.consumedBy&&(s=r.key);for(;void 0===a;)null===(o=this.tree.next(o))?a=null:void 0===o.key.consumedBy&&(a=o.key);if(t.isLeft){var l=null;if(s){var h=s.getIntersection(e);if(null!==h&&(e.isAnEndpoint(h)||(l=h),!s.isAnEndpoint(h)))for(var c=this._splitSafely(s,h),u=0,d=c.length;u<d;u++)i.push(c[u])}var p=null;if(a){var f=a.getIntersection(e);if(null!==f&&(e.isAnEndpoint(f)||(p=f),!a.isAnEndpoint(f)))for(var m=this._splitSafely(a,f),g=0,_=m.length;g<_;g++)i.push(m[g])}if(null!==l||null!==p){var y;y=null===l?p:null===p||S.comparePoints(l,p)<=0?l:p,this.queue.remove(e.rightSE),i.push(e.rightSE);for(var v=e.split(y),b=0,x=v.length;b<x;b++)i.push(v[b])}i.length>0?(this.tree.remove(e),i.push(t)):(this.segments.push(e),e.prev=s)}else{if(s&&a){var w=s.getIntersection(a);if(null!==w){if(!s.isAnEndpoint(w))for(var L=this._splitSafely(s,w),M=0,k=L.length;M<k;M++)i.push(L[M]);if(!a.isAnEndpoint(w))for(var C=this._splitSafely(a,w),A=0,P=C.length;A<P;A++)i.push(C[A])}}this.tree.remove(e)}return i}},{key:"_splitSafely",value:function(t,e){this.tree.remove(t);var i=t.rightSE;this.queue.remove(i);var n=t.split(e);return n.push(i),void 0===t.consumedBy&&this.tree.insert(t),n}}]),e}(),N=typeof process<"u"&&process.env.POLYGON_CLIPPING_MAX_QUEUE_SIZE||1e6,F=typeof process<"u"&&process.env.POLYGON_CLIPPING_MAX_SWEEPLINE_SEGMENTS||1e6,G=new(function(){function e(){t(this,e)}return i(e,[{key:"run",value:function(t,e,i){G.type=t,b.reset();for(var n=[new z(e,!0)],r=0,o=i.length;r<o;r++)n.push(new z(i[r],!1));if(G.numMultiPolys=n.length,"difference"===G.type)for(var s=n[0],a=1;a<n.length;)null!==f(n[a].bbox,s.bbox)?a++:n.splice(a,1);if("intersection"===G.type)for(var l=0,c=n.length;l<c;l++)for(var u=n[l],d=l+1,p=n.length;d<p;d++)if(null===f(u.bbox,n[d].bbox))return[];for(var m=new h(S.compare),g=0,_=n.length;g<_;g++)for(var y=n[g].getSweepEvents(),v=0,x=y.length;v<x;v++)if(m.insert(y[v]),m.size>N)throw new Error("Infinite loop when putting segment endpoints in a priority queue (queue size too big). Please file a bug report.");for(var w=new j(m),L=m.size,M=m.pop();M;){var k=M.key;if(m.size===L){var C=k.segment;throw new Error("Unable to pop() ".concat(k.isLeft?"left":"right"," SweepEvent ")+"[".concat(k.point.x,", ").concat(k.point.y,"] from segment #").concat(C.id," ")+"[".concat(C.leftSE.point.x,", ").concat(C.leftSE.point.y,"] -> ")+"[".concat(C.rightSE.point.x,", ").concat(C.rightSE.point.y,"] from queue. ")+"Please file a bug report.")}if(m.size>N)throw new Error("Infinite loop when passing sweep line over endpoints (queue size too big). Please file a bug report.");if(w.segments.length>F)throw new Error("Infinite loop when passing sweep line over endpoints (too many sweep line segments). Please file a bug report.");for(var A=w.process(k),P=0,E=A.length;P<E;P++){var I=A[P];void 0===I.consumedBy&&m.insert(I)}L=m.size,M=m.pop()}b.reset();var T=B.factory(w.segments);return new R(T).getGeom()}}]),e}()),U={union:function(t){for(var e=arguments.length,i=new Array(e>1?e-1:0),n=1;n<e;n++)i[n-1]=arguments[n];return G.run("union",t,i)},intersection:function(t){for(var e=arguments.length,i=new Array(e>1?e-1:0),n=1;n<e;n++)i[n-1]=arguments[n];return G.run("intersection",t,i)},xor:function(t){for(var e=arguments.length,i=new Array(e>1?e-1:0),n=1;n<e;n++)i[n-1]=arguments[n];return G.run("xor",t,i)},difference:function(t){for(var e=arguments.length,i=new Array(e>1?e-1:0),n=1;n<e;n++)i[n-1]=arguments[n];return G.run("difference",t,i)}};return U},"object"==typeof o&&typeof s<"u"?s.exports=a():void 0===(r="function"==typeof(n=a)?n.call(e,i,e,t):n)||(t.exports=r)}));Array.prototype.findIndex=Array.prototype.findIndex||function(t){if(null===this)throw new TypeError("Array.prototype.findIndex called on null or undefined");if("function"!=typeof t)throw new TypeError("callback must be a function");for(var e=Object(this),i=e.length>>>0,n=arguments[1],r=0;r<i;r++)if(t.call(n,e[r],r,e))return r;return-1},Array.prototype.find=Array.prototype.find||function(t){if(null===this)throw new TypeError("Array.prototype.find called on null or undefined");if("function"!=typeof t)throw new TypeError("callback must be a function");for(var e=Object(this),i=e.length>>>0,n=arguments[1],r=0;r<i;r++){var o=e[r];if(t.call(n,o,r,e))return o}},"function"!=typeof Object.assign&&(Object.assign=function(t){"use strict";if(null==t)throw new TypeError("Cannot convert undefined or null to object");t=Object(t);for(var e=1;e<arguments.length;e++){var i=arguments[e];if(null!=i)for(var n in i)Object.prototype.hasOwnProperty.call(i,n)&&(t[n]=i[n])}return t}),[Element.prototype,CharacterData.prototype,DocumentType.prototype].forEach((function(t){t.hasOwnProperty("remove")||Object.defineProperty(t,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){this.parentNode.removeChild(this)}})})),Array.prototype.includes||Object.defineProperty(Array.prototype,"includes",{value:function(t,e){if(null==this)throw new TypeError('"this" is null or not defined');var i=Object(this),n=i.length>>>0;if(0===n)return!1;for(var r,o,s=0|e,a=Math.max(s>=0?s:n-Math.abs(s),0);a<n;){if((r=i[a])===(o=t)||"number"==typeof r&&"number"==typeof o&&isNaN(r)&&isNaN(o))return!0;a++}return!1}});var Le=d(ee()),Me={en:{tooltips:{placeMarker:"Click to place marker",firstVertex:"Click to place first vertex",continueLine:"Click to continue drawing",finishLine:"Click any existing marker to finish",finishPoly:"Click first marker to finish",finishRect:"Click to finish",startCircle:"Click to place circle center",finishCircle:"Click to finish circle",placeCircleMarker:"Click to place circle marker",placeText:"Click to place text"},actions:{finish:"Finish",cancel:"Cancel",removeLastVertex:"Remove Last Vertex"},buttonTitles:{drawMarkerButton:"Draw Marker",drawPolyButton:"Draw Polygons",drawLineButton:"Draw Polyline",drawCircleButton:"Draw Circle",drawRectButton:"Draw Rectangle",editButton:"Edit Layers",dragButton:"Drag Layers",cutButton:"Cut Layers",deleteButton:"Remove Layers",drawCircleMarkerButton:"Draw Circle Marker",snappingButton:"Snap dragged marker to other layers and vertices",pinningButton:"Pin shared vertices together",rotateButton:"Rotate Layers",drawTextButton:"Draw Text",scaleButton:"Scale Layers",autoTracingButton:"Auto trace Line"},measurements:{totalLength:"Length",segmentLength:"Segment length",area:"Area",radius:"Radius",perimeter:"Perimeter",height:"Height",width:"Width",coordinates:"Position",coordinatesMarker:"Position Marker"}},de:{tooltips:{placeMarker:"Platziere den Marker mit Klick",firstVertex:"Platziere den ersten Marker mit Klick",continueLine:"Klicke, um weiter zu zeichnen",finishLine:"Beende mit Klick auf existierenden Marker",finishPoly:"Beende mit Klick auf ersten Marker",finishRect:"Beende mit Klick",startCircle:"Platziere das Kreiszentrum mit Klick",finishCircle:"Beende den Kreis mit Klick",placeCircleMarker:"Platziere den Kreismarker mit Klick",placeText:"Platziere den Text mit Klick"},actions:{finish:"Beenden",cancel:"Abbrechen",removeLastVertex:"Letzten Vertex löschen"},buttonTitles:{drawMarkerButton:"Marker zeichnen",drawPolyButton:"Polygon zeichnen",drawLineButton:"Polyline zeichnen",drawCircleButton:"Kreis zeichnen",drawRectButton:"Rechteck zeichnen",editButton:"Layer editieren",dragButton:"Layer bewegen",cutButton:"Layer schneiden",deleteButton:"Layer löschen",drawCircleMarkerButton:"Kreismarker zeichnen",snappingButton:"Bewegter Layer an andere Layer oder Vertexe einhacken",pinningButton:"Vertexe an der gleichen Position verknüpfen",rotateButton:"Layer drehen",drawTextButton:"Text zeichnen",scaleButton:"Layer skalieren",autoTracingButton:"Linie automatisch nachzeichen"},measurements:{totalLength:"Länge",segmentLength:"Segment Länge",area:"Fläche",radius:"Radius",perimeter:"Umfang",height:"Höhe",width:"Breite",coordinates:"Position",coordinatesMarker:"Position Marker"}},it:{tooltips:{placeMarker:"Clicca per posizionare un Marker",firstVertex:"Clicca per posizionare il primo vertice",continueLine:"Clicca per continuare a disegnare",finishLine:"Clicca qualsiasi marker esistente per terminare",finishPoly:"Clicca il primo marker per terminare",finishRect:"Clicca per terminare",startCircle:"Clicca per posizionare il punto centrale del cerchio",finishCircle:"Clicca per terminare il cerchio",placeCircleMarker:"Clicca per posizionare un Marker del cherchio"},actions:{finish:"Termina",cancel:"Annulla",removeLastVertex:"Rimuovi l'ultimo vertice"},buttonTitles:{drawMarkerButton:"Disegna Marker",drawPolyButton:"Disegna Poligoni",drawLineButton:"Disegna Polilinea",drawCircleButton:"Disegna Cerchio",drawRectButton:"Disegna Rettangolo",editButton:"Modifica Livelli",dragButton:"Sposta Livelli",cutButton:"Ritaglia Livelli",deleteButton:"Elimina Livelli",drawCircleMarkerButton:"Disegna Marker del Cerchio",snappingButton:"Snap ha trascinato il pennarello su altri strati e vertici",pinningButton:"Pin condiviso vertici insieme",rotateButton:"Ruota livello"}},id:{tooltips:{placeMarker:"Klik untuk menempatkan marker",firstVertex:"Klik untuk menempatkan vertex pertama",continueLine:"Klik untuk meneruskan digitasi",finishLine:"Klik pada sembarang marker yang ada untuk mengakhiri",finishPoly:"Klik marker pertama untuk mengakhiri",finishRect:"Klik untuk mengakhiri",startCircle:"Klik untuk menempatkan titik pusat lingkaran",finishCircle:"Klik untuk mengakhiri lingkaran",placeCircleMarker:"Klik untuk menempatkan penanda lingkarann"},actions:{finish:"Selesai",cancel:"Batal",removeLastVertex:"Hilangkan Vertex Terakhir"},buttonTitles:{drawMarkerButton:"Digitasi Marker",drawPolyButton:"Digitasi Polygon",drawLineButton:"Digitasi Polyline",drawCircleButton:"Digitasi Lingkaran",drawRectButton:"Digitasi Segi Empat",editButton:"Edit Layer",dragButton:"Geser Layer",cutButton:"Potong Layer",deleteButton:"Hilangkan Layer",drawCircleMarkerButton:"Digitasi Penanda Lingkaran",snappingButton:"Jepretkan penanda yang ditarik ke lapisan dan simpul lain",pinningButton:"Sematkan simpul bersama bersama",rotateButton:"Putar lapisan"}},ro:{tooltips:{placeMarker:"Adaugă un punct",firstVertex:"Apasă aici pentru a adăuga primul Vertex",continueLine:"Apasă aici pentru a continua desenul",finishLine:"Apasă pe orice obiect pentru a finisa desenul",finishPoly:"Apasă pe primul obiect pentru a finisa",finishRect:"Apasă pentru a finisa",startCircle:"Apasă pentru a desena un cerc",finishCircle:"Apasă pentru a finisa un cerc",placeCircleMarker:"Adaugă un punct"},actions:{finish:"Termină",cancel:"Anulează",removeLastVertex:"Șterge ultimul Vertex"},buttonTitles:{drawMarkerButton:"Adaugă o bulină",drawPolyButton:"Desenează un poligon",drawLineButton:"Desenează o linie",drawCircleButton:"Desenează un cerc",drawRectButton:"Desenează un dreptunghi",editButton:"Editează straturile",dragButton:"Mută straturile",cutButton:"Taie straturile",deleteButton:"Șterge straturile",drawCircleMarkerButton:"Desenează marcatorul cercului",snappingButton:"Fixați marcatorul glisat pe alte straturi și vârfuri",pinningButton:"Fixați vârfurile partajate împreună",rotateButton:"Rotiți stratul"}},ru:{tooltips:{placeMarker:"Нажмите, чтобы нанести маркер",firstVertex:"Нажмите, чтобы нанести первый объект",continueLine:"Нажмите, чтобы продолжить рисование",finishLine:"Нажмите любой существующий маркер для завершения",finishPoly:"Выберите первую точку, чтобы закончить",finishRect:"Нажмите, чтобы закончить",startCircle:"Нажмите, чтобы добавить центр круга",finishCircle:"Нажмите, чтобы задать радиус",placeCircleMarker:"Нажмите, чтобы нанести круговой маркер"},actions:{finish:"Завершить",cancel:"Отменить",removeLastVertex:"Отменить последнее действие"},buttonTitles:{drawMarkerButton:"Добавить маркер",drawPolyButton:"Рисовать полигон",drawLineButton:"Рисовать кривую",drawCircleButton:"Рисовать круг",drawRectButton:"Рисовать прямоугольник",editButton:"Редактировать слой",dragButton:"Перенести слой",cutButton:"Вырезать слой",deleteButton:"Удалить слой",drawCircleMarkerButton:"Добавить круговой маркер",snappingButton:"Привязать перетаскиваемый маркер к другим слоям и вершинам",pinningButton:"Связать общие точки вместе",rotateButton:"Поворот слоя"}},es:{tooltips:{placeMarker:"Presiona para colocar un marcador",firstVertex:"Presiona para colocar el primer vértice",continueLine:"Presiona para continuar dibujando",finishLine:"Presiona cualquier marcador existente para finalizar",finishPoly:"Presiona el primer marcador para finalizar",finishRect:"Presiona para finalizar",startCircle:"Presiona para colocar el centro del círculo",finishCircle:"Presiona para finalizar el círculo",placeCircleMarker:"Presiona para colocar un marcador de círculo"},actions:{finish:"Finalizar",cancel:"Cancelar",removeLastVertex:"Eliminar último vértice"},buttonTitles:{drawMarkerButton:"Dibujar Marcador",drawPolyButton:"Dibujar Polígono",drawLineButton:"Dibujar Línea",drawCircleButton:"Dibujar Círculo",drawRectButton:"Dibujar Rectángulo",editButton:"Editar Capas",dragButton:"Arrastrar Capas",cutButton:"Cortar Capas",deleteButton:"Eliminar Capas",drawCircleMarkerButton:"Dibujar Marcador de Círculo",snappingButton:"El marcador de Snap arrastrado a otras capas y vértices",pinningButton:"Fijar juntos los vértices compartidos",rotateButton:"Rotar capa"}},nl:{tooltips:{placeMarker:"Klik om een marker te plaatsen",firstVertex:"Klik om het eerste punt te plaatsen",continueLine:"Klik om te blijven tekenen",finishLine:"Klik op een bestaand punt om te beëindigen",finishPoly:"Klik op het eerst punt om te beëindigen",finishRect:"Klik om te beëindigen",startCircle:"Klik om het middelpunt te plaatsen",finishCircle:"Klik om de cirkel te beëindigen",placeCircleMarker:"Klik om een marker te plaatsen"},actions:{finish:"Bewaar",cancel:"Annuleer",removeLastVertex:"Verwijder laatste punt"},buttonTitles:{drawMarkerButton:"Plaats Marker",drawPolyButton:"Teken een vlak",drawLineButton:"Teken een lijn",drawCircleButton:"Teken een cirkel",drawRectButton:"Teken een vierkant",editButton:"Bewerk",dragButton:"Verplaats",cutButton:"Knip",deleteButton:"Verwijder",drawCircleMarkerButton:"Plaats Marker",snappingButton:"Snap gesleepte marker naar andere lagen en hoekpunten",pinningButton:"Speld gedeelde hoekpunten samen",rotateButton:"Laag roteren"}},fr:{tooltips:{placeMarker:"Cliquez pour placer un marqueur",firstVertex:"Cliquez pour placer le premier sommet",continueLine:"Cliquez pour continuer à dessiner",finishLine:"Cliquez sur n'importe quel marqueur pour terminer",finishPoly:"Cliquez sur le premier marqueur pour terminer",finishRect:"Cliquez pour terminer",startCircle:"Cliquez pour placer le centre du cercle",finishCircle:"Cliquez pour finir le cercle",placeCircleMarker:"Cliquez pour placer le marqueur circulaire"},actions:{finish:"Terminer",cancel:"Annuler",removeLastVertex:"Retirer le dernier sommet"},buttonTitles:{drawMarkerButton:"Placer des marqueurs",drawPolyButton:"Dessiner des polygones",drawLineButton:"Dessiner des polylignes",drawCircleButton:"Dessiner un cercle",drawRectButton:"Dessiner un rectangle",editButton:"Éditer des calques",dragButton:"Déplacer des calques",cutButton:"Couper des calques",deleteButton:"Supprimer des calques",drawCircleMarkerButton:"Dessiner un marqueur circulaire",snappingButton:"Glisser le marqueur vers d'autres couches et sommets",pinningButton:"Épingler ensemble les sommets partagés",rotateButton:"Tourner des calques"}},pt_br:{tooltips:{placeMarker:"Clique para posicionar o marcador",firstVertex:"Clique para posicionar o primeiro vértice",continueLine:"Clique para continuar desenhando",finishLine:"Clique em qualquer marcador existente para finalizar",finishPoly:"Clique no primeiro ponto para fechar o polígono",finishRect:"Clique para finalizar",startCircle:"Clique para posicionar o centro do círculo",finishCircle:"Clique para fechar o círculo",placeCircleMarker:"Clique para posicionar o marcador circular"},actions:{finish:"Finalizar",cancel:"Cancelar",removeLastVertex:"Remover último vértice"},buttonTitles:{drawMarkerButton:"Desenhar um marcador",drawPolyButton:"Desenhar um polígono",drawLineButton:"Desenhar uma polilinha",drawCircleButton:"Desenhar um círculo",drawRectButton:"Desenhar um retângulo",editButton:"Editar camada(s)",dragButton:"Mover camada(s)",cutButton:"Recortar camada(s)",deleteButton:"Remover camada(s)",drawCircleMarkerButton:"Marcador de círculos de desenho",snappingButton:"Marcador arrastado para outras camadas e vértices",pinningButton:"Vértices compartilhados de pinos juntos"}},zh:{tooltips:{placeMarker:"单击放置标记",firstVertex:"单击放置首个顶点",continueLine:"单击继续绘制",finishLine:"单击任何存在的标记以完成",finishPoly:"单击第一个标记以完成",finishRect:"单击完成",startCircle:"单击放置圆心",finishCircle:"单击完成圆形",placeCircleMarker:"点击放置圆形标记"},actions:{finish:"完成",cancel:"取消",removeLastVertex:"移除最后的顶点"},buttonTitles:{drawMarkerButton:"绘制标记",drawPolyButton:"绘制多边形",drawLineButton:"绘制线段",drawCircleButton:"绘制圆形",drawRectButton:"绘制长方形",editButton:"编辑图层",dragButton:"拖拽图层",cutButton:"剪切图层",deleteButton:"删除图层",drawCircleMarkerButton:"画圆圈标记",snappingButton:"将拖动的标记捕捉到其他图层和顶点",pinningButton:"将共享顶点固定在一起",rotateButton:"旋转图层"}},zh_tw:{tooltips:{placeMarker:"單擊放置標記",firstVertex:"單擊放置第一個頂點",continueLine:"單擊繼續繪製",finishLine:"單擊任何存在的標記以完成",finishPoly:"單擊第一個標記以完成",finishRect:"單擊完成",startCircle:"單擊放置圓心",finishCircle:"單擊完成圓形",placeCircleMarker:"點擊放置圓形標記"},actions:{finish:"完成",cancel:"取消",removeLastVertex:"移除最後一個頂點"},buttonTitles:{drawMarkerButton:"放置標記",drawPolyButton:"繪製多邊形",drawLineButton:"繪製線段",drawCircleButton:"繪製圓形",drawRectButton:"繪製方形",editButton:"編輯圖形",dragButton:"移動圖形",cutButton:"裁切圖形",deleteButton:"刪除圖形",drawCircleMarkerButton:"畫圓圈標記",snappingButton:"將拖動的標記對齊到其他圖層和頂點",pinningButton:"將共享頂點固定在一起",rotateButton:"旋轉圖形"}},pl:{tooltips:{placeMarker:"Kliknij, aby umieścić znacznik",firstVertex:"Kliknij, aby umieścić pierwszy wierzchołek",continueLine:"Kliknij, aby kontynuować rysowanie",finishLine:"Kliknij dowolny istniejący znacznik, aby zakończyć",finishPoly:"Kliknij pierwszy znacznik, aby zakończyć",finishRect:"Kliknij, aby zakończyć",startCircle:"Kliknij, aby umieścić środek okręgu",finishCircle:"Kliknij, aby zakończyć okrąg",placeCircleMarker:"Kliknij, aby umieścić znacznik okręgu",placeText:"Kliknij, aby umieścić tekst"},actions:{finish:"Zakończ",cancel:"Anuluj",removeLastVertex:"Usuń ostatni wierzchołek"},buttonTitles:{drawMarkerButton:"Rysuj znacznik",drawPolyButton:"Rysuj wielokąt",drawLineButton:"Rysuj linię",drawCircleButton:"Rysuj okrąg",drawRectButton:"Rysuj prostokąt",editButton:"Edytuj warstwy",dragButton:"Przeciągnij warstwy",cutButton:"Wytnij warstwy",deleteButton:"Usuń warstwy",drawCircleMarkerButton:"Rysuj znacznik okrągły",snappingButton:"Przyciągnij przenoszony znacznik do innych warstw i wierzchołków",pinningButton:"Przypnij wspólne wierzchołki razem",rotateButton:"Obróć warstwy",drawTextButton:"Rysuj tekst",scaleButton:"Skaluj warstwy",autoTracingButton:"Automatyczne śledzenie linii"},measurements:{totalLength:"Długość",segmentLength:"Długość odcinka",area:"Obszar",radius:"Promień",perimeter:"Obwód",height:"Wysokość",width:"Szerokość",coordinates:"Pozycja",coordinatesMarker:"Znacznik pozycji"}},sv:{tooltips:{placeMarker:"Klicka för att placera markör",firstVertex:"Klicka för att placera första hörnet",continueLine:"Klicka för att fortsätta rita",finishLine:"Klicka på en existerande punkt för att slutföra",finishPoly:"Klicka på den första punkten för att slutföra",finishRect:"Klicka för att slutföra",startCircle:"Klicka för att placera cirkelns centrum",finishCircle:"Klicka för att slutföra cirkeln",placeCircleMarker:"Klicka för att placera cirkelmarkör"},actions:{finish:"Slutför",cancel:"Avbryt",removeLastVertex:"Ta bort sista hörnet"},buttonTitles:{drawMarkerButton:"Rita Markör",drawPolyButton:"Rita Polygoner",drawLineButton:"Rita Linje",drawCircleButton:"Rita Cirkel",drawRectButton:"Rita Rektangel",editButton:"Redigera Lager",dragButton:"Dra Lager",cutButton:"Klipp i Lager",deleteButton:"Ta bort Lager",drawCircleMarkerButton:"Rita Cirkelmarkör",snappingButton:"Snäpp dra markören till andra lager och hörn",pinningButton:"Fäst delade hörn tillsammans",rotateButton:"Rotera lagret"}},el:{tooltips:{placeMarker:"Κάντε κλικ για να τοποθετήσετε Δείκτη",firstVertex:"Κάντε κλικ για να τοποθετήσετε το πρώτο σημείο",continueLine:"Κάντε κλικ για να συνεχίσετε να σχεδιάζετε",finishLine:"Κάντε κλικ σε οποιονδήποτε υπάρχον σημείο για να ολοκληρωθεί",finishPoly:"Κάντε κλικ στο πρώτο σημείο για να τελειώσετε",finishRect:"Κάντε κλικ για να τελειώσετε",startCircle:"Κάντε κλικ για να τοποθετήσετε κέντρο Κύκλου",finishCircle:"Κάντε κλικ για να ολοκληρώσετε τον Κύκλο",placeCircleMarker:"Κάντε κλικ για να τοποθετήσετε Κυκλικό Δείκτη"},actions:{finish:"Τέλος",cancel:"Ακύρωση",removeLastVertex:"Κατάργηση τελευταίου σημείου"},buttonTitles:{drawMarkerButton:"Σχεδίαση Δείκτη",drawPolyButton:"Σχεδίαση Πολυγώνου",drawLineButton:"Σχεδίαση Γραμμής",drawCircleButton:"Σχεδίαση Κύκλου",drawRectButton:"Σχεδίαση Ορθογωνίου",editButton:"Επεξεργασία Επιπέδων",dragButton:"Μεταφορά Επιπέδων",cutButton:"Αποκοπή Επιπέδων",deleteButton:"Κατάργηση Επιπέδων",drawCircleMarkerButton:"Σχεδίαση Κυκλικού Δείκτη",snappingButton:"Προσκόλληση του Δείκτη μεταφοράς σε άλλα Επίπεδα και Κορυφές",pinningButton:"Περικοπή κοινών κορυφών μαζί",rotateButton:"Περιστρέψτε το στρώμα"}},hu:{tooltips:{placeMarker:"Kattintson a jelölő elhelyezéséhez",firstVertex:"Kattintson az első pont elhelyezéséhez",continueLine:"Kattintson a következő pont elhelyezéséhez",finishLine:"A befejezéshez kattintson egy meglévő pontra",finishPoly:"A befejezéshez kattintson az első pontra",finishRect:"Kattintson a befejezéshez",startCircle:"Kattintson a kör középpontjának elhelyezéséhez",finishCircle:"Kattintson a kör befejezéséhez",placeCircleMarker:"Kattintson a körjelölő elhelyezéséhez"},actions:{finish:"Befejezés",cancel:"Mégse",removeLastVertex:"Utolsó pont eltávolítása"},buttonTitles:{drawMarkerButton:"Jelölő rajzolása",drawPolyButton:"Poligon rajzolása",drawLineButton:"Vonal rajzolása",drawCircleButton:"Kör rajzolása",drawRectButton:"Négyzet rajzolása",editButton:"Elemek szerkesztése",dragButton:"Elemek mozgatása",cutButton:"Elemek vágása",deleteButton:"Elemek törlése",drawCircleMarkerButton:"Kör jelölő rajzolása",snappingButton:"Kapcsolja a jelöltőt másik elemhez vagy ponthoz",pinningButton:"Közös pontok összekötése",rotateButton:"Fólia elforgatása"}},da:{tooltips:{placeMarker:"Tryk for at placere en markør",firstVertex:"Tryk for at placere det første punkt",continueLine:"Tryk for at fortsætte linjen",finishLine:"Tryk på et eksisterende punkt for at afslutte",finishPoly:"Tryk på det første punkt for at afslutte",finishRect:"Tryk for at afslutte",startCircle:"Tryk for at placere cirklens center",finishCircle:"Tryk for at afslutte cirklen",placeCircleMarker:"Tryk for at placere en cirkelmarkør"},actions:{finish:"Afslut",cancel:"Afbryd",removeLastVertex:"Fjern sidste punkt"},buttonTitles:{drawMarkerButton:"Placer markør",drawPolyButton:"Tegn polygon",drawLineButton:"Tegn linje",drawCircleButton:"Tegn cirkel",drawRectButton:"Tegn firkant",editButton:"Rediger",dragButton:"Træk",cutButton:"Klip",deleteButton:"Fjern",drawCircleMarkerButton:"Tegn cirkelmarkør",snappingButton:"Fastgør trukket markør til andre elementer",pinningButton:"Sammenlæg delte elementer",rotateButton:"Roter laget"}},no:{tooltips:{placeMarker:"Klikk for å plassere punkt",firstVertex:"Klikk for å plassere første punkt",continueLine:"Klikk for å tegne videre",finishLine:"Klikk på et eksisterende punkt for å fullføre",finishPoly:"Klikk første punkt for å fullføre",finishRect:"Klikk for å fullføre",startCircle:"Klikk for å sette sirkel midtpunkt",finishCircle:"Klikk for å fullføre sirkel",placeCircleMarker:"Klikk for å plassere sirkel",placeText:"Klikk for å plassere tekst"},actions:{finish:"Fullfør",cancel:"Kanseller",removeLastVertex:"Fjern forrige punkt"},buttonTitles:{drawMarkerButton:"Tegn punkt",drawPolyButton:"Tegn flate",drawLineButton:"Tegn linje",drawCircleButton:"Tegn sirkel",drawRectButton:"Tegn rektangel",editButton:"Rediger objekter",dragButton:"Dra objekter",cutButton:"Kutt objekter",deleteButton:"Fjern objekter",drawCircleMarkerButton:"Tegn sirkel-punkt",snappingButton:"Fest dratt punkt til andre objekter og punkt",pinningButton:"Pin delte punkter sammen",rotateButton:"Rotér objekter",drawTextButton:"Tegn tekst",scaleButton:"Skalér objekter",autoTracingButton:"Automatisk sporing av linje"},measurements:{totalLength:"Lengde",segmentLength:"Segmentlengde",area:"Område",radius:"Radius",perimeter:"Omriss",height:"Høyde",width:"Bredde",coordinates:"Posisjon",coordinatesMarker:"Posisjonsmarkør"}},fa:{tooltips:{placeMarker:"کلیک برای جانمایی نشان",firstVertex:"کلیک برای رسم اولین رأس",continueLine:"کلیک برای ادامه رسم",finishLine:"کلیک روی هر نشان موجود برای پایان",finishPoly:"کلیک روی اولین نشان برای پایان",finishRect:"کلیک برای پایان",startCircle:"کلیک برای رسم مرکز دایره",finishCircle:"کلیک برای پایان رسم دایره",placeCircleMarker:"کلیک برای رسم نشان دایره",placeText:"کلیک برای نوشتن متن"},actions:{finish:"پایان",cancel:"لفو",removeLastVertex:"حذف آخرین رأس"},buttonTitles:{drawMarkerButton:"درج نشان",drawPolyButton:"رسم چندضلعی",drawLineButton:"رسم خط",drawCircleButton:"رسم دایره",drawRectButton:"رسم چهارضلعی",editButton:"ویرایش لایه‌ها",dragButton:"جابجایی لایه‌ها",cutButton:"برش لایه‌ها",deleteButton:"حذف لایه‌ها",drawCircleMarkerButton:"رسم نشان دایره",snappingButton:"نشانگر را به لایه‌ها و رئوس دیگر بکشید",pinningButton:"رئوس مشترک را با هم پین کنید",rotateButton:"چرخش لایه",drawTextButton:"رسم متن",scaleButton:"مقیاس‌گذاری",autoTracingButton:"ردیاب خودکار"},measurements:{totalLength:"طول",segmentLength:"طول بخش",area:"ناحیه",radius:"شعاع",perimeter:"محیط",height:"ارتفاع",width:"عرض",coordinates:"موقعیت",coordinatesMarker:"موقعیت نشان"}},ua:{tooltips:{placeMarker:"Натисніть, щоб нанести маркер",firstVertex:"Натисніть, щоб нанести першу вершину",continueLine:"Натисніть, щоб продовжити малювати",finishLine:"Натисніть будь-який існуючий маркер для завершення",finishPoly:"Виберіть перший маркер, щоб завершити",finishRect:"Натисніть, щоб завершити",startCircle:"Натисніть, щоб додати центр кола",finishCircle:"Натисніть, щоб завершити коло",placeCircleMarker:"Натисніть, щоб нанести круговий маркер"},actions:{finish:"Завершити",cancel:"Відмінити",removeLastVertex:"Видалити попередню вершину"},buttonTitles:{drawMarkerButton:"Малювати маркер",drawPolyButton:"Малювати полігон",drawLineButton:"Малювати криву",drawCircleButton:"Малювати коло",drawRectButton:"Малювати прямокутник",editButton:"Редагувати шари",dragButton:"Перенести шари",cutButton:"Вирізати шари",deleteButton:"Видалити шари",drawCircleMarkerButton:"Малювати круговий маркер",snappingButton:"Прив’язати перетягнутий маркер до інших шарів та вершин",pinningButton:"Зв'язати спільні вершини разом",rotateButton:"Повернути шар"}},tr:{tooltips:{placeMarker:"İşaretçi yerleştirmek için tıklayın",firstVertex:"İlk tepe noktasını yerleştirmek için tıklayın",continueLine:"Çizime devam etmek için tıklayın",finishLine:"Bitirmek için mevcut herhangi bir işaretçiyi tıklayın",finishPoly:"Bitirmek için ilk işaretçiyi tıklayın",finishRect:"Bitirmek için tıklayın",startCircle:"Daire merkezine yerleştirmek için tıklayın",finishCircle:"Daireyi bitirmek için tıklayın",placeCircleMarker:"Daire işaretçisi yerleştirmek için tıklayın"},actions:{finish:"Bitir",cancel:"İptal",removeLastVertex:"Son köşeyi kaldır"},buttonTitles:{drawMarkerButton:"Çizim İşaretçisi",drawPolyButton:"Çokgenler çiz",drawLineButton:"Çoklu çizgi çiz",drawCircleButton:"Çember çiz",drawRectButton:"Dikdörtgen çiz",editButton:"Katmanları düzenle",dragButton:"Katmanları sürükle",cutButton:"Katmanları kes",deleteButton:"Katmanları kaldır",drawCircleMarkerButton:"Daire işaretçisi çiz",snappingButton:"Sürüklenen işaretçiyi diğer katmanlara ve köşelere yapıştır",pinningButton:"Paylaşılan köşeleri birbirine sabitle",rotateButton:"Katmanı döndür"}},cz:{tooltips:{placeMarker:"Kliknutím vytvoříte značku",firstVertex:"Kliknutím vytvoříte první objekt",continueLine:"Kliknutím pokračujte v kreslení",finishLine:"Kliknutí na libovolnou existující značku pro dokončení",finishPoly:"Vyberte první bod pro dokončení",finishRect:"Klikněte pro dokončení",startCircle:"Kliknutím přidejte střed kruhu",finishCircle:"Нажмите, чтобы задать радиус",placeCircleMarker:"Kliknutím nastavte poloměr"},actions:{finish:"Dokončit",cancel:"Zrušit",removeLastVertex:"Zrušit poslední akci"},buttonTitles:{drawMarkerButton:"Přidat značku",drawPolyButton:"Nakreslit polygon",drawLineButton:"Nakreslit křivku",drawCircleButton:"Nakreslit kruh",drawRectButton:"Nakreslit obdélník",editButton:"Upravit vrstvu",dragButton:"Přeneste vrstvu",cutButton:"Vyjmout vrstvu",deleteButton:"Smazat vrstvu",drawCircleMarkerButton:"Přidat kruhovou značku",snappingButton:"Navázat tažnou značku k dalším vrstvám a vrcholům",pinningButton:"Spojit společné body dohromady",rotateButton:"Otočte vrstvu"}},ja:{tooltips:{placeMarker:"クリックしてマーカーを配置",firstVertex:"クリックして最初の頂点を配置",continueLine:"クリックして描画を続ける",finishLine:"任意のマーカーをクリックして終了",finishPoly:"最初のマーカーをクリックして終了",finishRect:"クリックして終了",startCircle:"クリックして円の中心を配置",finishCircle:"クリックして円の描画を終了",placeCircleMarker:"クリックして円マーカーを配置",placeText:"クリックしてテキストを配置"},actions:{finish:"終了",cancel:"キャンセル",removeLastVertex:"最後の頂点を削除"},buttonTitles:{drawMarkerButton:"マーカーを描画",drawPolyButton:"ポリゴンを描画",drawLineButton:"折れ線を描画",drawCircleButton:"円を描画",drawRectButton:"矩形を描画",editButton:"レイヤーを編集",dragButton:"レイヤーをドラッグ",cutButton:"レイヤーを切り取り",deleteButton:"レイヤーを削除",drawCircleMarkerButton:"円マーカーを描画",snappingButton:"ドラッグしたマーカーを他のレイヤーや頂点にスナップする",pinningButton:"共有する頂点を同時に動かす",rotateButton:"レイヤーを回転",drawTextButton:"テキストを描画"}},fi:{tooltips:{placeMarker:"Klikkaa asettaaksesi merkin",firstVertex:"Klikkaa asettaakseni ensimmäisen osuuden",continueLine:"Klikkaa jatkaaksesi piirtämistä",finishLine:"Klikkaa olemassa olevaa merkkiä lopettaaksesi",finishPoly:"Klikkaa ensimmäistä merkkiä lopettaaksesi",finishRect:"Klikkaa lopettaaksesi",startCircle:"Klikkaa asettaaksesi ympyrän keskipisteen",finishCircle:"Klikkaa lopettaaksesi ympyrän",placeCircleMarker:"Klikkaa asettaaksesi ympyrämerkin",placeText:"Klikkaa asettaaksesi tekstin"},actions:{finish:"Valmis",cancel:"Peruuta",removeLastVertex:"Poista viimeinen osuus"},buttonTitles:{drawMarkerButton:"Piirrä merkkejä",drawPolyButton:"Piirrä monikulmioita",drawLineButton:"Piirrä viivoja",drawCircleButton:"Piirrä ympyrä",drawRectButton:"Piirrä neliskulmioita",editButton:"Muokkaa",dragButton:"Siirrä",cutButton:"Leikkaa",deleteButton:"Poista",drawCircleMarkerButton:"Piirrä ympyrämerkki",snappingButton:"Kiinnitä siirrettävä merkki toisiin muotoihin",pinningButton:"Kiinnitä jaetut muodot yhteen",rotateButton:"Käännä",drawTextButton:"Piirrä tekstiä"}},ko:{tooltips:{placeMarker:"마커 위치를 클릭하세요",firstVertex:"첫번째 꼭지점 위치을 클릭하세요",continueLine:"계속 그리려면 클릭하세요",finishLine:"끝내려면 기존 마커를 클릭하세요",finishPoly:"끝내려면 처음 마커를 클릭하세요",finishRect:"끝내려면 클릭하세요",startCircle:"원의 중심이 될 위치를 클릭하세요",finishCircle:"원을 끝내려면 클릭하세요",placeCircleMarker:"원 마커 위치를 클릭하세요",placeText:"텍스트 위치를 클릭하세요"},actions:{finish:"끝내기",cancel:"취소",removeLastVertex:"마지막 꼭지점 제거"},buttonTitles:{drawMarkerButton:"마커 그리기",drawPolyButton:"다각형 그리기",drawLineButton:"다각선 그리기",drawCircleButton:"원 그리기",drawRectButton:"직사각형 그리기",editButton:"레이어 편집하기",dragButton:"레이어 끌기",cutButton:"레이어 자르기",deleteButton:"레이어 제거하기",drawCircleMarkerButton:"원 마커 그리기",snappingButton:"잡아끈 마커를 다른 레이어 및 꼭지점에 들러붙게 하기",pinningButton:"공유 꼭지점을 함께 찍기",rotateButton:"레이어 회전하기",drawTextButton:"텍스트 그리기"}},ky:{tooltips:{placeMarker:"Маркерди жайгаштыруу үчүн басыңыз",firstVertex:"Биринчи чокуну жайгаштырууну үчүн басыңыз",continueLine:"Сүрөт тартууну улантуу үчүн басыңыз",finishLine:"Аяктоо үчүн учурдагы маркерди басыңыз",finishPoly:"Бүтүрүү үчүн биринчи маркерди басыңыз",finishRect:"Бүтүрүү үчүн басыңыз",startCircle:"Айлананын борборун жайгаштырууну үчүн басыңыз",finishCircle:"Айлананы бүтүрүү үчүн басыңыз",placeCircleMarker:"Тегерек маркерди жайгаштыруу үчүн басыңыз",placeText:"Текстти жайгаштыруу үчүн басыңыз"},actions:{finish:"Аягы",cancel:"Жок кылуу",removeLastVertex:"Акыркы чокуну өчүрүү"},buttonTitles:{drawMarkerButton:"Маркерди чизуу",drawPolyButton:"Полигон чизуу",drawLineButton:"Полилиния чизуу",drawCircleButton:"Дайынды чизуу",drawRectButton:"Прямоугольник чизуу",editButton:"Слоопту түзөтүү",dragButton:"Слоопту карап сүйлөү",cutButton:"Слооптун башын кесүү",deleteButton:"Слооптун өчүрүү",drawCircleMarkerButton:"Дайынды маркерди чизуу",snappingButton:"Башка слооптордун жана вертекстердин арасына чекилдөө",pinningButton:"Бөлүшкөн вертекстерди бирге тутуштуруу",rotateButton:"Слооптун өзгөртүү",drawTextButton:"Текст чизуу",scaleButton:"Слооптун өлчөмүн өзгөртүү",autoTracingButton:"Автоматтык тизмеги чизуу"},measurements:{totalLength:"Узундук",segmentLength:"Сегмент узундугу",area:"Аймак",radius:"Радиус",perimeter:"Периметр",height:"Диаметр",width:"Кенчилик",coordinates:"Координаттар",coordinatesMarker:"Маркердин координаттары"}}},ke={_globalEditModeEnabled:!1,enableGlobalEditMode(t){let e={...t};this._globalEditModeEnabled=!0,this.Toolbar.toggleButton("editMode",this.globalEditModeEnabled()),L.PM.Utils.findLayers(this.map).forEach((t=>{this._isRelevantForEdit(t)&&t.pm.enable(e)})),this.throttledReInitEdit||(this.throttledReInitEdit=L.Util.throttle(this.handleLayerAdditionInGlobalEditMode,100,this)),this._addedLayersEdit={},this.map.on("layeradd",this._layerAddedEdit,this),this.map.on("layeradd",this.throttledReInitEdit,this),this._fireGlobalEditModeToggled(!0)},disableGlobalEditMode(){this._globalEditModeEnabled=!1,L.PM.Utils.findLayers(this.map).forEach((t=>{t.pm.disable()})),this.map.off("layeradd",this._layerAddedEdit,this),this.map.off("layeradd",this.throttledReInitEdit,this),this.Toolbar.toggleButton("editMode",this.globalEditModeEnabled()),this._fireGlobalEditModeToggled(!1)},globalEditEnabled(){return this.globalEditModeEnabled()},globalEditModeEnabled(){return this._globalEditModeEnabled},toggleGlobalEditMode(t=this.globalOptions){this.globalEditModeEnabled()?this.disableGlobalEditMode():this.enableGlobalEditMode(t)},handleLayerAdditionInGlobalEditMode(){let t=this._addedLayersEdit;if(this._addedLayersEdit={},this.globalEditModeEnabled())for(let e in t){let i=t[e];this._isRelevantForEdit(i)&&i.pm.enable({...this.globalOptions})}},_layerAddedEdit({layer:t}){this._addedLayersEdit[L.stamp(t)]=t},_isRelevantForEdit:t=>t.pm&&!(t instanceof L.LayerGroup)&&(!L.PM.optIn&&!t.options.pmIgnore||L.PM.optIn&&!1===t.options.pmIgnore)&&!t._pmTempLayer&&t.pm.options.allowEditing},Ce={_globalDragModeEnabled:!1,enableGlobalDragMode(){let t=L.PM.Utils.findLayers(this.map);this._globalDragModeEnabled=!0,this._addedLayersDrag={},t.forEach((t=>{this._isRelevantForDrag(t)&&t.pm.enableLayerDrag()})),this.throttledReInitDrag||(this.throttledReInitDrag=L.Util.throttle(this.reinitGlobalDragMode,100,this)),this.map.on("layeradd",this._layerAddedDrag,this),this.map.on("layeradd",this.throttledReInitDrag,this),this.Toolbar.toggleButton("dragMode",this.globalDragModeEnabled()),this._fireGlobalDragModeToggled(!0)},disableGlobalDragMode(){let t=L.PM.Utils.findLayers(this.map);this._globalDragModeEnabled=!1,t.forEach((t=>{t.pm.disableLayerDrag()})),this.map.off("layeradd",this._layerAddedDrag,this),this.map.off("layeradd",this.throttledReInitDrag,this),this.Toolbar.toggleButton("dragMode",this.globalDragModeEnabled()),this._fireGlobalDragModeToggled(!1)},globalDragModeEnabled(){return!!this._globalDragModeEnabled},toggleGlobalDragMode(){this.globalDragModeEnabled()?this.disableGlobalDragMode():this.enableGlobalDragMode()},reinitGlobalDragMode(){let t=this._addedLayersDrag;if(this._addedLayersDrag={},this.globalDragModeEnabled())for(let e in t){let i=t[e];this._isRelevantForDrag(i)&&i.pm.enableLayerDrag()}},_layerAddedDrag({layer:t}){this._addedLayersDrag[L.stamp(t)]=t},_isRelevantForDrag:t=>t.pm&&!(t instanceof L.LayerGroup)&&(!L.PM.optIn&&!t.options.pmIgnore||L.PM.optIn&&!1===t.options.pmIgnore)&&!t._pmTempLayer&&t.pm.options.draggable},Ae={_globalRemovalModeEnabled:!1,enableGlobalRemovalMode(){this._globalRemovalModeEnabled=!0,this.map.eachLayer((t=>{this._isRelevantForRemoval(t)&&(t.pm.enabled()&&t.pm.disable(),t.on("click",this.removeLayer,this))})),this.throttledReInitRemoval||(this.throttledReInitRemoval=L.Util.throttle(this.handleLayerAdditionInGlobalRemovalMode,100,this)),this._addedLayersRemoval={},this.map.on("layeradd",this._layerAddedRemoval,this),this.map.on("layeradd",this.throttledReInitRemoval,this),this.Toolbar.toggleButton("removalMode",this.globalRemovalModeEnabled()),this._fireGlobalRemovalModeToggled(!0)},disableGlobalRemovalMode(){this._globalRemovalModeEnabled=!1,this.map.eachLayer((t=>{t.off("click",this.removeLayer,this)})),this.map.off("layeradd",this._layerAddedRemoval,this),this.map.off("layeradd",this.throttledReInitRemoval,this),this.Toolbar.toggleButton("removalMode",this.globalRemovalModeEnabled()),this._fireGlobalRemovalModeToggled(!1)},globalRemovalEnabled(){return this.globalRemovalModeEnabled()},globalRemovalModeEnabled(){return!!this._globalRemovalModeEnabled},toggleGlobalRemovalMode(){this.globalRemovalModeEnabled()?this.disableGlobalRemovalMode():this.enableGlobalRemovalMode()},removeLayer(t){let e=t.target;this._isRelevantForRemoval(e)&&!e.pm.dragging()&&(e.removeFrom(this.map.pm._getContainingLayer()),e.remove(),e instanceof L.LayerGroup?(this._fireRemoveLayerGroup(e),this._fireRemoveLayerGroup(this.map,e)):(e.pm._fireRemove(e),e.pm._fireRemove(this.map,e)))},_isRelevantForRemoval:t=>t.pm&&!(t instanceof L.LayerGroup)&&(!L.PM.optIn&&!t.options.pmIgnore||L.PM.optIn&&!1===t.options.pmIgnore)&&!t._pmTempLayer&&t.pm.options.allowRemoval,handleLayerAdditionInGlobalRemovalMode(){let t=this._addedLayersRemoval;if(this._addedLayersRemoval={},this.globalRemovalModeEnabled())for(let e in t){let i=t[e];this._isRelevantForRemoval(i)&&(i.pm.enabled()&&i.pm.disable(),i.on("click",this.removeLayer,this))}},_layerAddedRemoval({layer:t}){this._addedLayersRemoval[L.stamp(t)]=t}},Pe={_globalRotateModeEnabled:!1,enableGlobalRotateMode(){this._globalRotateModeEnabled=!0,L.PM.Utils.findLayers(this.map).filter((t=>t instanceof L.Polyline)).forEach((t=>{this._isRelevantForRotate(t)&&t.pm.enableRotate()})),this.throttledReInitRotate||(this.throttledReInitRotate=L.Util.throttle(this.handleLayerAdditionInGlobalRotateMode,100,this)),this._addedLayersRotate={},this.map.on("layeradd",this._layerAddedRotate,this),this.map.on("layeradd",this.throttledReInitRotate,this),this.Toolbar.toggleButton("rotateMode",this.globalRotateModeEnabled()),this._fireGlobalRotateModeToggled()},disableGlobalRotateMode(){this._globalRotateModeEnabled=!1,L.PM.Utils.findLayers(this.map).filter((t=>t instanceof L.Polyline)).forEach((t=>{t.pm.disableRotate()})),this.map.off("layeradd",this._layerAddedRotate,this),this.map.off("layeradd",this.throttledReInitRotate,this),this.Toolbar.toggleButton("rotateMode",this.globalRotateModeEnabled()),this._fireGlobalRotateModeToggled()},globalRotateModeEnabled(){return!!this._globalRotateModeEnabled},toggleGlobalRotateMode(){this.globalRotateModeEnabled()?this.disableGlobalRotateMode():this.enableGlobalRotateMode()},_isRelevantForRotate:t=>t.pm&&t instanceof L.Polyline&&!(t instanceof L.LayerGroup)&&(!L.PM.optIn&&!t.options.pmIgnore||L.PM.optIn&&!1===t.options.pmIgnore)&&!t._pmTempLayer&&t.pm.options.allowRotation,handleLayerAdditionInGlobalRotateMode(){let t=this._addedLayersRotate;if(this._addedLayersRotate={},this.globalRotateModeEnabled())for(let e in t){let i=t[e];this._isRelevantForRemoval(i)&&i.pm.enableRotate()}},_layerAddedRotate({layer:t}){this._addedLayersRotate[L.stamp(t)]=t}},Se=d(ee()),Ee={_fireDrawStart(t="Draw",e={}){this.__fire(this._map,"pm:drawstart",{shape:this._shape,workingLayer:this._layer},t,e)},_fireDrawEnd(t="Draw",e={}){this.__fire(this._map,"pm:drawend",{shape:this._shape},t,e)},_fireCreate(t,e="Draw",i={}){this.__fire(this._map,"pm:create",{shape:this._shape,marker:t,layer:t},e,i)},_fireCenterPlaced(t="Draw",e={}){let i="Draw"===t?this._layer:void 0,n="Draw"!==t?this._layer:void 0;this.__fire(this._layer,"pm:centerplaced",{shape:this._shape,workingLayer:i,layer:n,latlng:this._layer.getLatLng()},t,e)},_fireCut(t,e,i,n="Draw",r={}){this.__fire(t,"pm:cut",{shape:this._shape,layer:e,originalLayer:i},n,r)},_fireEdit(t=this._layer,e="Edit",i={}){this.__fire(t,"pm:edit",{layer:this._layer,shape:this.getShape()},e,i)},_fireEnable(t="Edit",e={}){this.__fire(this._layer,"pm:enable",{layer:this._layer,shape:this.getShape()},t,e)},_fireDisable(t="Edit",e={}){this.__fire(this._layer,"pm:disable",{layer:this._layer,shape:this.getShape()},t,e)},_fireUpdate(t="Edit",e={}){this.__fire(this._layer,"pm:update",{layer:this._layer,shape:this.getShape()},t,e)},_fireMarkerDragStart(t,e=void 0,i="Edit",n={}){this.__fire(this._layer,"pm:markerdragstart",{layer:this._layer,markerEvent:t,shape:this.getShape(),indexPath:e},i,n)},_fireMarkerDrag(t,e=void 0,i="Edit",n={}){this.__fire(this._layer,"pm:markerdrag",{layer:this._layer,markerEvent:t,shape:this.getShape(),indexPath:e},i,n)},_fireMarkerDragEnd(t,e=void 0,i=void 0,n="Edit",r={}){this.__fire(this._layer,"pm:markerdragend",{layer:this._layer,markerEvent:t,shape:this.getShape(),indexPath:e,intersectionReset:i},n,r)},_fireDragStart(t="Edit",e={}){this.__fire(this._layer,"pm:dragstart",{layer:this._layer,shape:this.getShape()},t,e)},_fireDrag(t,e="Edit",i={}){this.__fire(this._layer,"pm:drag",{...t,shape:this.getShape()},e,i)},_fireDragEnd(t="Edit",e={}){this.__fire(this._layer,"pm:dragend",{layer:this._layer,shape:this.getShape()},t,e)},_fireDragEnable(t="Edit",e={}){this.__fire(this._layer,"pm:dragenable",{layer:this._layer,shape:this.getShape()},t,e)},_fireDragDisable(t="Edit",e={}){this.__fire(this._layer,"pm:dragdisable",{layer:this._layer,shape:this.getShape()},t,e)},_fireRemove(t,e=t,i="Edit",n={}){this.__fire(t,"pm:remove",{layer:e,shape:this.getShape()},i,n)},_fireVertexAdded(t,e,i,n="Edit",r={}){this.__fire(this._layer,"pm:vertexadded",{layer:this._layer,workingLayer:this._layer,marker:t,indexPath:e,latlng:i,shape:this.getShape()},n,r)},_fireVertexRemoved(t,e,i="Edit",n={}){this.__fire(this._layer,"pm:vertexremoved",{layer:this._layer,marker:t,indexPath:e,shape:this.getShape()},i,n)},_fireVertexClick(t,e,i="Edit",n={}){this.__fire(this._layer,"pm:vertexclick",{layer:this._layer,markerEvent:t,indexPath:e,shape:this.getShape()},i,n)},_fireIntersect(t,e=this._layer,i="Edit",n={}){this.__fire(e,"pm:intersect",{layer:this._layer,intersection:t,shape:this.getShape()},i,n)},_fireLayerReset(t,e,i="Edit",n={}){this.__fire(this._layer,"pm:layerreset",{layer:this._layer,markerEvent:t,indexPath:e,shape:this.getShape()},i,n)},_fireChange(t,e="Edit",i={}){this.__fire(this._layer,"pm:change",{layer:this._layer,latlngs:t,shape:this.getShape()},e,i)},_fireTextChange(t,e="Edit",i={}){this.__fire(this._layer,"pm:textchange",{layer:this._layer,text:t,shape:this.getShape()},e,i)},_fireTextFocus(t="Edit",e={}){this.__fire(this._layer,"pm:textfocus",{layer:this._layer,shape:this.getShape()},t,e)},_fireTextBlur(t="Edit",e={}){this.__fire(this._layer,"pm:textblur",{layer:this._layer,shape:this.getShape()},t,e)},_fireSnapDrag(t,e,i="Snapping",n={}){this.__fire(t,"pm:snapdrag",e,i,n)},_fireSnap(t,e,i="Snapping",n={}){this.__fire(t,"pm:snap",e,i,n)},_fireUnsnap(t,e,i="Snapping",n={}){this.__fire(t,"pm:unsnap",e,i,n)},_fireRotationEnable(t,e,i="Rotation",n={}){this.__fire(t,"pm:rotateenable",{layer:this._layer,helpLayer:this._rotatePoly,shape:this.getShape()},i,n)},_fireRotationDisable(t,e="Rotation",i={}){this.__fire(t,"pm:rotatedisable",{layer:this._layer,shape:this.getShape()},e,i)},_fireRotationStart(t,e,i="Rotation",n={}){this.__fire(t,"pm:rotatestart",{layer:this._rotationLayer,helpLayer:this._layer,startAngle:this._startAngle,originLatLngs:e},i,n)},_fireRotation(t,e,i,n=this._rotationLayer,r="Rotation",o={}){this.__fire(t,"pm:rotate",{layer:n,helpLayer:this._layer,startAngle:this._startAngle,angle:n.pm.getAngle(),angleDiff:e,oldLatLngs:i,newLatLngs:n.getLatLngs()},r,o)},_fireRotationEnd(t,e,i,n="Rotation",r={}){this.__fire(t,"pm:rotateend",{layer:this._rotationLayer,helpLayer:this._layer,startAngle:e,angle:this._rotationLayer.pm.getAngle(),originLatLngs:i,newLatLngs:this._rotationLayer.getLatLngs()},n,r)},_fireActionClick(t,e,i,n="Toolbar",r={}){this.__fire(this._map,"pm:actionclick",{text:t.text,action:t,btnName:e,button:i},n,r)},_fireButtonClick(t,e,i="Toolbar",n={}){this.__fire(this._map,"pm:buttonclick",{btnName:t,button:e},i,n)},_fireLangChange(t,e,i,n,r="Global",o={}){this.__fire(this.map,"pm:langchange",{oldLang:t,activeLang:e,fallback:i,translations:n},r,o)},_fireGlobalDragModeToggled(t,e="Global",i={}){this.__fire(this.map,"pm:globaldragmodetoggled",{enabled:t,map:this.map},e,i)},_fireGlobalEditModeToggled(t,e="Global",i={}){this.__fire(this.map,"pm:globaleditmodetoggled",{enabled:t,map:this.map},e,i)},_fireGlobalRemovalModeToggled(t,e="Global",i={}){this.__fire(this.map,"pm:globalremovalmodetoggled",{enabled:t,map:this.map},e,i)},_fireGlobalCutModeToggled(t="Global",e={}){this.__fire(this._map,"pm:globalcutmodetoggled",{enabled:!!this._enabled,map:this._map},t,e)},_fireGlobalDrawModeToggled(t="Global",e={}){this.__fire(this._map,"pm:globaldrawmodetoggled",{enabled:this._enabled,shape:this._shape,map:this._map},t,e)},_fireGlobalRotateModeToggled(t="Global",e={}){this.__fire(this.map,"pm:globalrotatemodetoggled",{enabled:this.globalRotateModeEnabled(),map:this.map},t,e)},_fireRemoveLayerGroup(t,e=t,i="Edit",n={}){this.__fire(t,"pm:remove",{layer:e,shape:void 0},i,n)},_fireKeyeventEvent(t,e,i,n="Global",r={}){this.__fire(this.map,"pm:keyevent",{event:t,eventType:e,focusOn:i},n,r)},__fire(t,e,i,n,r={}){i=(0,Se.default)(i,r,{source:n}),L.PM.Utils._fireEvent(t,e,i)}},Ie=()=>({_lastEvents:{keydown:void 0,keyup:void 0,current:void 0},_initKeyListener(t){this.map=t,L.DomEvent.on(document,"keydown keyup",this._onKeyListener,this),L.DomEvent.on(window,"blur",this._onBlur,this),t.once("unload",this._unbindKeyListenerEvents,this)},_unbindKeyListenerEvents(){L.DomEvent.off(document,"keydown keyup",this._onKeyListener,this),L.DomEvent.off(window,"blur",this._onBlur,this)},_onKeyListener(t){let e="document";this.map.getContainer().contains(t.target)&&(e="map");let i={event:t,eventType:t.type,focusOn:e};this._lastEvents[t.type]=i,this._lastEvents.current=i,this.map.pm._fireKeyeventEvent(t,t.type,e)},_onBlur(t){t.altKey=!1;let e={event:t,eventType:t.type,focusOn:"document"};this._lastEvents[t.type]=e,this._lastEvents.current=e},getLastKeyEvent(t="current"){return this._lastEvents[t]},isShiftKeyPressed(){return this._lastEvents.current?.event.shiftKey},isAltKeyPressed(){return this._lastEvents.current?.event.altKey},isCtrlKeyPressed(){return this._lastEvents.current?.event.ctrlKey},isMetaKeyPressed(){return this._lastEvents.current?.event.metaKey},getPressedKey(){return this._lastEvents.current?.event.key}}),Te=d(pe()),De=d(ge());function ze(t){let e=L.PM.activeLang;return(0,De.default)(Me,e)||(e="en"),(0,Te.default)(Me[e],t)}function Be(t){for(let e=0;e<t.length;e+=1){let i=t[e];if(Array.isArray(i)){if(Be(i))return!0}else if(null!=i&&""!==i)return!0}return!1}function Oe(t){return t.reduce(((t,e)=>{if(0!==e.length){let i=Array.isArray(e)?Oe(e):e;Array.isArray(i)?0!==i.length&&t.push(i):t.push(i)}return t}),[])}function Re(t,e,i){let n,r,o,s={a:L.CRS.Earth.R,b:6356752.3142,f:.0033528106647474805},{a,b:l,f:h}=s,c=t.lng,u=t.lat,d=i,p=Math.PI,f=e*p/180,m=Math.sin(f),g=Math.cos(f),_=(1-h)*Math.tan(u*p/180),y=1/Math.sqrt(1+_*_),v=_*y,b=Math.atan2(_,g),x=y*m,w=1-x*x,M=w*(a*a-l*l)/(l*l),k=1+M/16384*(4096+M*(M*(320-175*M)-768)),C=M/1024*(256+M*(M*(74-47*M)-128)),A=d/(l*k),P=2*Math.PI;for(;Math.abs(A-P)>1e-12;)n=Math.cos(2*b+A),r=Math.sin(A),o=Math.cos(A),P=A,A=d/(l*k)+C*r*(n+C/4*(o*(2*n*n-1)-C/6*n*(4*r*r-3)*(4*n*n-3)));let S=v*r-y*o*g,E=Math.atan2(v*o+y*r*g,(1-h)*Math.sqrt(x*x+S*S)),I=h/16*w*(4+h*(4-3*w)),T=c+180*(Math.atan2(r*m,y*o-v*r*g)-(1-I)*h*x*(A+I*r*(n+I*o*(2*n*n-1))))/p,D=180*E/p;return L.latLng(T,D)}function je(t,e,i,n,r=!0){let o,s,a,l=[];for(let h=0;h<i;h+=1){if(r)o=360*h/i+n,s=Re(t,o,e),a=L.latLng(s.lng,s.lat);else{let n=t.lat+Math.cos(2*h*Math.PI/i)*e,r=t.lng+Math.sin(2*h*Math.PI/i)*e;a=L.latLng(n,r)}l.push(a)}return l}function Ne(t,e,i){let n=t.latLngToContainerPoint(e),r=t.latLngToContainerPoint(i),o=180*Math.atan2(r.y-n.y,r.x-n.x)/Math.PI+90;return o+=o<0?360:0,o}function Fe(t,e,i,n){return function(t,e,i){e=(e+360)%360;let n=Math.PI/180,r=180/Math.PI,{R:o}=L.CRS.Earth,s=t.lng*n,a=t.lat*n,l=e*n,h=Math.sin(a),c=Math.cos(a),u=Math.cos(i/o),d=Math.sin(i/o),p=Math.asin(h*u+c*d*Math.cos(l)),f=s+Math.atan2(Math.sin(l)*d*c,u-h*Math.sin(p));return f*=r,f=f>180?f-360:f<-180?f+360:f,L.latLng([p*r,f])}(e,Ne(t,e,i),n)}function Ge(t,e=t.getLatLngs()){return t instanceof L.Polygon?L.polygon(e).getLatLngs():L.polyline(e).getLatLngs()}function Ue(t,e){if(e.options.crs?.projection?.MAX_LATITUDE){let i=e.options.crs?.projection?.MAX_LATITUDE;t.lat=Math.max(Math.min(i,t.lat),-i)}return t}function He(t){return t.options.renderer||t._map&&(t._map._getPaneRenderer(t.options.pane)||t._map.options.renderer||t._map._renderer)||t._renderer}var Ve=L.Class.extend({includes:[ke,Ce,Ae,Pe,Ee],initialize(t){this.map=t,this.Draw=new L.PM.Draw(t),this.Toolbar=new L.PM.Toolbar(t),this.Keyboard=Ie(),this.globalOptions={snappable:!0,layerGroup:void 0,snappingOrder:["Marker","CircleMarker","Circle","Line","Polygon","Rectangle"],panes:{vertexPane:"markerPane",layerPane:"overlayPane",markerPane:"markerPane"},draggable:!0},this.Keyboard._initKeyListener(t)},setLang(t="en",e,i="en"){let n=L.PM.activeLang;e&&(Me[t]=(0,Le.default)(Me[i],e)),L.PM.activeLang=t,this.map.pm.Toolbar.reinit(),this._fireLangChange(n,t,i,Me[t])},addControls(t){this.Toolbar.addControls(t)},removeControls(){this.Toolbar.removeControls()},toggleControls(){this.Toolbar.toggleControls()},controlsVisible(){return this.Toolbar.isVisible},enableDraw(t="Polygon",e){"Poly"===t&&(t="Polygon"),this.Draw.enable(t,e)},disableDraw(t="Polygon"){"Poly"===t&&(t="Polygon"),this.Draw.disable(t)},setPathOptions(t,e={}){let i=e.ignoreShapes||[],n=e.merge||!1;this.map.pm.Draw.shapes.forEach((e=>{-1===i.indexOf(e)&&this.map.pm.Draw[e].setPathOptions(t,n)}))},getGlobalOptions(){return this.globalOptions},setGlobalOptions(t){let e=(0,Le.default)(this.globalOptions,t);e.editable&&(e.resizeableCircleMarker=e.editable,delete e.editable);let i=!1;this.map.pm.Draw.CircleMarker.enabled()&&!!this.map.pm.Draw.CircleMarker.options.resizeableCircleMarker!=!!e.resizeableCircleMarker&&(this.map.pm.Draw.CircleMarker.disable(),i=!0);let n=!1;this.map.pm.Draw.Circle.enabled()&&!!this.map.pm.Draw.Circle.options.resizableCircle!=!!e.resizableCircle&&(this.map.pm.Draw.Circle.disable(),n=!0),this.map.pm.Draw.shapes.forEach((t=>{this.map.pm.Draw[t].setOptions(e)})),i&&this.map.pm.Draw.CircleMarker.enable(),n&&this.map.pm.Draw.Circle.enable(),L.PM.Utils.findLayers(this.map).forEach((t=>{t.pm.setOptions(e)})),this.map.fire("pm:globaloptionschanged"),this.globalOptions=e,this.applyGlobalOptions()},applyGlobalOptions(){L.PM.Utils.findLayers(this.map).forEach((t=>{t.pm.enabled()&&t.pm.applyOptions()}))},globalDrawModeEnabled(){return!!this.Draw.getActiveShape()},globalCutModeEnabled(){return!!this.Draw.Cut.enabled()},enableGlobalCutMode(t){return this.Draw.Cut.enable(t)},toggleGlobalCutMode(t){return this.Draw.Cut.toggle(t)},disableGlobalCutMode(){return this.Draw.Cut.disable()},getGeomanLayers(t=!1){let e=L.PM.Utils.findLayers(this.map);if(!t)return e;let i=L.featureGroup();return i._pmTempLayer=!0,e.forEach((t=>{i.addLayer(t)})),i},getGeomanDrawLayers(t=!1){let e=L.PM.Utils.findLayers(this.map).filter((t=>!0===t._drawnByGeoman));if(!t)return e;let i=L.featureGroup();return i._pmTempLayer=!0,e.forEach((t=>{i.addLayer(t)})),i},_getContainingLayer(){return this.globalOptions.layerGroup&&this.globalOptions.layerGroup instanceof L.LayerGroup?this.globalOptions.layerGroup:this.map},_isCRSSimple(){return this.map.options.crs===L.CRS.Simple},_touchEventCounter:0,_addTouchEvents(t){0===this._touchEventCounter&&(L.DomEvent.on(t,"touchmove",this._canvasTouchMove,this),L.DomEvent.on(t,"touchstart touchend touchcancel",this._canvasTouchClick,this)),this._touchEventCounter+=1},_removeTouchEvents(t){1===this._touchEventCounter&&(L.DomEvent.off(t,"touchmove",this._canvasTouchMove,this),L.DomEvent.off(t,"touchstart touchend touchcancel",this._canvasTouchClick,this)),this._touchEventCounter=this._touchEventCounter<=1?0:this._touchEventCounter-1},_canvasTouchMove(t){He(this.map)._onMouseMove(this._createMouseEvent("mousemove",t))},_canvasTouchClick(t){let e="";"touchstart"===t.type||"pointerdown"===t.type?e="mousedown":("touchend"===t.type||"pointerup"===t.type||"touchcancel"===t.type||"pointercancel"===t.type)&&(e="mouseup"),e&&He(this.map)._onClick(this._createMouseEvent(e,t))},_createMouseEvent(t,e){let i,n=e.touches[0]||e.changedTouches[0];try{i=new MouseEvent(t,{bubbles:e.bubbles,cancelable:e.cancelable,view:e.view,detail:n.detail,screenX:n.screenX,screenY:n.screenY,clientX:n.clientX,clientY:n.clientY,ctrlKey:e.ctrlKey,altKey:e.altKey,shiftKey:e.shiftKey,metaKey:e.metaKey,button:e.button,relatedTarget:e.relatedTarget})}catch{i=document.createEvent("MouseEvents"),i.initMouseEvent(t,e.bubbles,e.cancelable,e.view,n.detail,n.screenX,n.screenY,n.clientX,n.clientY,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,e.button,e.relatedTarget)}return i}}),Ze=L.Control.extend({includes:[Ee],options:{position:"topleft",disableByOtherButtons:!0},initialize(t){this._button=L.Util.extend({},this.options,t)},onAdd(t){return this._map=t,this._map.pm.Toolbar.options.oneBlock?this._container=this._map.pm.Toolbar._createContainer(this.options.position):"edit"===this._button.tool?this._container=this._map.pm.Toolbar.editContainer:"options"===this._button.tool?this._container=this._map.pm.Toolbar.optionsContainer:"custom"===this._button.tool?this._container=this._map.pm.Toolbar.customContainer:this._container=this._map.pm.Toolbar.drawContainer,this.buttonsDomNode=this._makeButton(this._button),this._container.appendChild(this.buttonsDomNode),this._container},onRemove(){return this.buttonsDomNode.remove(),this._container},getText(){return this._button.text},getIconUrl(){return this._button.iconUrl},destroy(){this._button={},this._update()},toggle(t){return this._button.toggleStatus="boolean"==typeof t?t:!this._button.toggleStatus,this._applyStyleClasses(),this._button.toggleStatus},toggled(){return this._button.toggleStatus},onCreate(){this.toggle(!1)},disable(){this.toggle(!1),this._button.disabled=!0,this._updateDisabled()},enable(){this._button.disabled=!1,this._updateDisabled()},_triggerClick(t){t&&t.preventDefault(),!this._button.disabled&&(this._button.onClick(t,{button:this,event:t}),this._clicked(t),this._button.afterClick(t,{button:this,event:t}))},_makeButton(t){let e=this.options.position.indexOf("right")>-1?"pos-right":"",i=L.DomUtil.create("div",`button-container  ${e}`,this._container);t.title&&i.setAttribute("title",t.title);let n=L.DomUtil.create("a","leaflet-buttons-control-button",i);n.setAttribute("role","button"),n.setAttribute("tabindex","0"),n.href="#";let r=L.DomUtil.create("div",`leaflet-pm-actions-container ${e}`,i),o=t.actions,s={cancel:{text:ze("actions.cancel"),onClick(){this._triggerClick()}},finishMode:{text:ze("actions.finish"),onClick(){this._triggerClick()}},removeLastVertex:{text:ze("actions.removeLastVertex"),onClick(){this._map.pm.Draw[t.jsClass]._removeLastVertex()}},finish:{text:ze("actions.finish"),onClick(e){this._map.pm.Draw[t.jsClass]._finishShape(e)}}};o.forEach((i=>{let n,o="string"==typeof i?i:i.name;if(s[o])n=s[o];else{if(!i.text)return;n=i}let a=L.DomUtil.create("a",`leaflet-pm-action ${e} action-${o}`,r);if(a.setAttribute("role","button"),a.setAttribute("tabindex","0"),a.href="#",a.innerHTML=n.text,L.DomEvent.disableClickPropagation(a),L.DomEvent.on(a,"click",L.DomEvent.stop),!t.disabled&&n.onClick){let e=e=>{e.preventDefault();let i="",{buttons:r}=this._map.pm.Toolbar;for(let e in r)if(r[e]._button===t){i=e;break}this._fireActionClick(n,i,t)};L.DomEvent.addListener(a,"click",e,this),L.DomEvent.addListener(a,"click",n.onClick,this)}})),t.toggleStatus&&L.DomUtil.addClass(i,"active");let a=L.DomUtil.create("div","control-icon",n);return t.iconUrl&&a.setAttribute("src",t.iconUrl),t.className&&L.DomUtil.addClass(a,t.className),L.DomEvent.disableClickPropagation(n),L.DomEvent.on(n,"click",L.DomEvent.stop),t.disabled||(L.DomEvent.addListener(n,"click",this._onBtnClick,this),L.DomEvent.addListener(n,"click",this._triggerClick,this)),t.disabled&&(L.DomUtil.addClass(n,"pm-disabled"),n.setAttribute("aria-disabled","true")),i},_applyStyleClasses(){this._container&&(this._button.toggleStatus&&!1!==this._button.cssToggle?(L.DomUtil.addClass(this.buttonsDomNode,"active"),L.DomUtil.addClass(this._container,"activeChild")):(L.DomUtil.removeClass(this.buttonsDomNode,"active"),L.DomUtil.removeClass(this._container,"activeChild")))},_onBtnClick(){if(this._button.disabled)return;this._button.disableOtherButtons&&this._map.pm.Toolbar.triggerClickOnToggledButtons(this);let t="",{buttons:e}=this._map.pm.Toolbar;for(let i in e)if(e[i]._button===this._button){t=i;break}this._fireButtonClick(t,this._button)},_clicked(){this._button.doToggle&&this.toggle()},_updateDisabled(){if(!this._container)return;let t="pm-disabled",e=this.buttonsDomNode.children[0];this._button.disabled?(L.DomUtil.addClass(e,t),e.setAttribute("aria-disabled","true")):(L.DomUtil.removeClass(e,t),e.setAttribute("aria-disabled","false"))}});L.Control.PMButton=Ze;var qe=L.Class.extend({options:{drawMarker:!0,drawRectangle:!0,drawPolyline:!0,drawPolygon:!0,drawCircle:!0,drawCircleMarker:!0,drawText:!0,editMode:!0,dragMode:!0,cutPolygon:!0,removalMode:!0,rotateMode:!0,snappingOption:!0,drawControls:!0,editControls:!0,optionsControls:!0,customControls:!0,oneBlock:!1,position:"topleft",positions:{draw:"",edit:"",options:"",custom:""}},customButtons:[],initialize(t){this.init(t)},reinit(){let t=this.isVisible;this.removeControls(),this._defineButtons(),t&&this.addControls()},init(t){this.map=t,this.buttons={},this.isVisible=!1,this.drawContainer=L.DomUtil.create("div","leaflet-pm-toolbar leaflet-pm-draw leaflet-bar leaflet-control"),this.editContainer=L.DomUtil.create("div","leaflet-pm-toolbar leaflet-pm-edit leaflet-bar leaflet-control"),this.optionsContainer=L.DomUtil.create("div","leaflet-pm-toolbar leaflet-pm-options leaflet-bar leaflet-control"),this.customContainer=L.DomUtil.create("div","leaflet-pm-toolbar leaflet-pm-custom leaflet-bar leaflet-control"),this._defineButtons()},_createContainer(t){let e=`${t}Container`;return this[e]||(this[e]=L.DomUtil.create("div",`leaflet-pm-toolbar leaflet-pm-${t} leaflet-bar leaflet-control`)),this[e]},getButtons(){return this.buttons},addControls(t=this.options){typeof t.editPolygon<"u"&&(t.editMode=t.editPolygon),typeof t.deleteLayer<"u"&&(t.removalMode=t.deleteLayer),L.Util.setOptions(this,t),this.applyIconStyle(),this.isVisible=!0,this._showHideButtons()},applyIconStyle(){let t=this.getButtons(),e={geomanIcons:{drawMarker:"control-icon leaflet-pm-icon-marker",drawPolyline:"control-icon leaflet-pm-icon-polyline",drawRectangle:"control-icon leaflet-pm-icon-rectangle",drawPolygon:"control-icon leaflet-pm-icon-polygon",drawCircle:"control-icon leaflet-pm-icon-circle",drawCircleMarker:"control-icon leaflet-pm-icon-circle-marker",editMode:"control-icon leaflet-pm-icon-edit",dragMode:"control-icon leaflet-pm-icon-drag",cutPolygon:"control-icon leaflet-pm-icon-cut",removalMode:"control-icon leaflet-pm-icon-delete",drawText:"control-icon leaflet-pm-icon-text"}};for(let i in t){let n=t[i];L.Util.setOptions(n,{className:e.geomanIcons[i]})}},removeControls(){let t=this.getButtons();for(let e in t)t[e].remove();this.isVisible=!1},toggleControls(t=this.options){this.isVisible?this.removeControls():this.addControls(t)},_addButton(t,e){return this.buttons[t]=e,this.options[t]=this.options[t]||!1,this.buttons[t]},triggerClickOnToggledButtons(t){for(let e in this.buttons){let i=this.buttons[e];i._button.disableByOtherButtons&&i!==t&&i.toggled()&&i._triggerClick()}},toggleButton(t,e,i=!0){return"editPolygon"===t&&(t="editMode"),"deleteLayer"===t&&(t="removalMode"),i&&this.triggerClickOnToggledButtons(this.buttons[t]),!!this.buttons[t]&&this.buttons[t].toggle(e)},_defineButtons(){let t={className:"control-icon leaflet-pm-icon-marker",title:ze("buttonTitles.drawMarkerButton"),jsClass:"Marker",onClick:()=>{},afterClick:(t,e)=>{this.map.pm.Draw[e.button._button.jsClass].toggle()},doToggle:!0,toggleStatus:!1,disableOtherButtons:!0,position:this.options.position,actions:["cancel"]},e={title:ze("buttonTitles.drawPolyButton"),className:"control-icon leaflet-pm-icon-polygon",jsClass:"Polygon",onClick:()=>{},afterClick:(t,e)=>{this.map.pm.Draw[e.button._button.jsClass].toggle()},doToggle:!0,toggleStatus:!1,disableOtherButtons:!0,position:this.options.position,actions:["finish","removeLastVertex","cancel"]},i={className:"control-icon leaflet-pm-icon-polyline",title:ze("buttonTitles.drawLineButton"),jsClass:"Line",onClick:()=>{},afterClick:(t,e)=>{this.map.pm.Draw[e.button._button.jsClass].toggle()},doToggle:!0,toggleStatus:!1,disableOtherButtons:!0,position:this.options.position,actions:["finish","removeLastVertex","cancel"]},n={title:ze("buttonTitles.drawCircleButton"),className:"control-icon leaflet-pm-icon-circle",jsClass:"Circle",onClick:()=>{},afterClick:(t,e)=>{this.map.pm.Draw[e.button._button.jsClass].toggle()},doToggle:!0,toggleStatus:!1,disableOtherButtons:!0,position:this.options.position,actions:["cancel"]},r={title:ze("buttonTitles.drawCircleMarkerButton"),className:"control-icon leaflet-pm-icon-circle-marker",jsClass:"CircleMarker",onClick:()=>{},afterClick:(t,e)=>{this.map.pm.Draw[e.button._button.jsClass].toggle()},doToggle:!0,toggleStatus:!1,disableOtherButtons:!0,position:this.options.position,actions:["cancel"]},o={title:ze("buttonTitles.drawRectButton"),className:"control-icon leaflet-pm-icon-rectangle",jsClass:"Rectangle",onClick:()=>{},afterClick:(t,e)=>{this.map.pm.Draw[e.button._button.jsClass].toggle()},doToggle:!0,toggleStatus:!1,disableOtherButtons:!0,position:this.options.position,actions:["cancel"]},s={title:ze("buttonTitles.editButton"),className:"control-icon leaflet-pm-icon-edit",onClick:()=>{},afterClick:()=>{this.map.pm.toggleGlobalEditMode()},doToggle:!0,toggleStatus:!1,disableOtherButtons:!0,position:this.options.position,tool:"edit",actions:["finishMode"]},a={title:ze("buttonTitles.dragButton"),className:"control-icon leaflet-pm-icon-drag",onClick:()=>{},afterClick:()=>{this.map.pm.toggleGlobalDragMode()},doToggle:!0,toggleStatus:!1,disableOtherButtons:!0,position:this.options.position,tool:"edit",actions:["finishMode"]},l={title:ze("buttonTitles.cutButton"),className:"control-icon leaflet-pm-icon-cut",jsClass:"Cut",onClick:()=>{},afterClick:(t,e)=>{this.map.pm.Draw[e.button._button.jsClass].toggle({snappable:!0,cursorMarker:!0,allowSelfIntersection:!1})},doToggle:!0,toggleStatus:!1,disableOtherButtons:!0,position:this.options.position,tool:"edit",actions:["finish","removeLastVertex","cancel"]},h={title:ze("buttonTitles.deleteButton"),className:"control-icon leaflet-pm-icon-delete",onClick:()=>{},afterClick:()=>{this.map.pm.toggleGlobalRemovalMode()},doToggle:!0,toggleStatus:!1,disableOtherButtons:!0,position:this.options.position,tool:"edit",actions:["finishMode"]},c={title:ze("buttonTitles.rotateButton"),className:"control-icon leaflet-pm-icon-rotate",onClick:()=>{},afterClick:()=>{this.map.pm.toggleGlobalRotateMode()},doToggle:!0,toggleStatus:!1,disableOtherButtons:!0,position:this.options.position,tool:"edit",actions:["finishMode"]},u={className:"control-icon leaflet-pm-icon-text",title:ze("buttonTitles.drawTextButton"),jsClass:"Text",onClick:()=>{},afterClick:(t,e)=>{this.map.pm.Draw[e.button._button.jsClass].toggle()},doToggle:!0,toggleStatus:!1,disableOtherButtons:!0,position:this.options.position,actions:["cancel"]};this._addButton("drawMarker",new L.Control.PMButton(t)),this._addButton("drawPolyline",new L.Control.PMButton(i)),this._addButton("drawRectangle",new L.Control.PMButton(o)),this._addButton("drawPolygon",new L.Control.PMButton(e)),this._addButton("drawCircle",new L.Control.PMButton(n)),this._addButton("drawCircleMarker",new L.Control.PMButton(r)),this._addButton("drawText",new L.Control.PMButton(u)),this._addButton("editMode",new L.Control.PMButton(s)),this._addButton("dragMode",new L.Control.PMButton(a)),this._addButton("cutPolygon",new L.Control.PMButton(l)),this._addButton("removalMode",new L.Control.PMButton(h)),this._addButton("rotateMode",new L.Control.PMButton(c))},_showHideButtons(){if(!this.isVisible)return;this.removeControls(),this.isVisible=!0;let t=this.getButtons(),e=[];!1===this.options.drawControls&&(e=e.concat(Object.keys(t).filter((e=>!t[e]._button.tool)))),!1===this.options.editControls&&(e=e.concat(Object.keys(t).filter((e=>"edit"===t[e]._button.tool)))),!1===this.options.optionsControls&&(e=e.concat(Object.keys(t).filter((e=>"options"===t[e]._button.tool)))),!1===this.options.customControls&&(e=e.concat(Object.keys(t).filter((e=>"custom"===t[e]._button.tool))));for(let i in t)if(this.options[i]&&-1===e.indexOf(i)){let e=t[i]._button.tool;e||(e="draw"),t[i].setPosition(this._getBtnPosition(e)),t[i].addTo(this.map)}},_getBtnPosition(t){return this.options.positions&&this.options.positions[t]?this.options.positions[t]:this.options.position},setBlockPosition(t,e){this.options.positions[t]=e,this._showHideButtons(),this.changeControlOrder()},getBlockPositions(){return this.options.positions},copyDrawControl(t,e){if(!e)throw new TypeError("Button has no name");"object"!=typeof e&&(e={name:e});let i=this._btnNameMapping(t);if(!e.name)throw new TypeError("Button has no name");if(this.buttons[e.name])throw new TypeError("Button with this name already exists");let n=this.map.pm.Draw.createNewDrawInstance(e.name,i);return e={...this.buttons[i]._button,...e},{drawInstance:n,control:this.createCustomControl(e)}},createCustomControl(t){if(!t.name)throw new TypeError("Button has no name");if(this.buttons[t.name])throw new TypeError("Button with this name already exists");t.onClick||(t.onClick=()=>{}),t.afterClick||(t.afterClick=()=>{}),!1!==t.toggle&&(t.toggle=!0),t.block&&(t.block=t.block.toLowerCase()),(!t.block||"draw"===t.block)&&(t.block=""),t.className?-1===t.className.indexOf("control-icon")&&(t.className=`control-icon ${t.className}`):t.className="control-icon";let e={tool:t.block,className:t.className,title:t.title||"",jsClass:t.name,onClick:t.onClick,afterClick:t.afterClick,doToggle:t.toggle,toggleStatus:!1,disableOtherButtons:t.disableOtherButtons??!0,disableByOtherButtons:t.disableByOtherButtons??!0,cssToggle:t.toggle,position:this.options.position,actions:t.actions||[],disabled:!!t.disabled};!1!==this.options[t.name]&&(this.options[t.name]=!0);let i=this._addButton(t.name,new L.Control.PMButton(e));return this.changeControlOrder(),i},changeControlOrder(t=[]){let e=this._shapeMapping(),i=[];t.forEach((t=>{e[t]?i.push(e[t]):i.push(t)}));let n=this.getButtons(),r={};i.forEach((t=>{n[t]&&(r[t]=n[t])})),Object.keys(n).filter((t=>!n[t]._button.tool)).forEach((t=>{-1===i.indexOf(t)&&(r[t]=n[t])})),Object.keys(n).filter((t=>"edit"===n[t]._button.tool)).forEach((t=>{-1===i.indexOf(t)&&(r[t]=n[t])})),Object.keys(n).filter((t=>"options"===n[t]._button.tool)).forEach((t=>{-1===i.indexOf(t)&&(r[t]=n[t])})),Object.keys(n).filter((t=>"custom"===n[t]._button.tool)).forEach((t=>{-1===i.indexOf(t)&&(r[t]=n[t])})),Object.keys(n).forEach((t=>{-1===i.indexOf(t)&&(r[t]=n[t])})),this.map.pm.Toolbar.buttons=r,this._showHideButtons()},getControlOrder(){let t=this.getButtons(),e=[];for(let i in t)e.push(i);return e},changeActionsOfControl(t,e){let i=this._btnNameMapping(t);if(!i)throw new TypeError("No name passed");if(!e)throw new TypeError("No actions passed");if(!this.buttons[i])throw new TypeError("Button with this name not exists");this.buttons[i]._button.actions=e,this.changeControlOrder()},setButtonDisabled(t,e){let i=this._btnNameMapping(t);e?this.buttons[i].disable():this.buttons[i].enable()},_shapeMapping:()=>({Marker:"drawMarker",Circle:"drawCircle",Polygon:"drawPolygon",Rectangle:"drawRectangle",Polyline:"drawPolyline",Line:"drawPolyline",CircleMarker:"drawCircleMarker",Edit:"editMode",Drag:"dragMode",Cut:"cutPolygon",Removal:"removalMode",Rotate:"rotateMode",Text:"drawText"}),_btnNameMapping(t){let e=this._shapeMapping();return e[t]?e[t]:t}}),We=d(ee()),Ke={_initSnappableMarkers(){this.options.snapDistance=this.options.snapDistance||30,this.options.snapSegment=void 0===this.options.snapSegment||this.options.snapSegment,this._assignEvents(this._markers),this._layer.off("pm:dragstart",this._unsnap,this),this._layer.on("pm:dragstart",this._unsnap,this)},_disableSnapping(){this._layer.off("pm:dragstart",this._unsnap,this)},_assignEvents(t){t.forEach((t=>{Array.isArray(t)?this._assignEvents(t):(t.off("drag",this._handleSnapping,this),t.on("drag",this._handleSnapping,this),t.off("dragend",this._cleanupSnapping,this),t.on("dragend",this._cleanupSnapping,this))}))},_cleanupSnapping(t){t&&(t.target._snapped=!1),delete this._snapList,this.throttledList&&(this._map.off("layeradd",this.throttledList,this),this.throttledList=void 0),this._map.off("layerremove",this._handleSnapLayerRemoval,this),this.debugIndicatorLines&&this.debugIndicatorLines.forEach((t=>{t.remove()}))},_handleThrottleSnapping(){this.throttledList&&this._createSnapList()},_handleSnapping(t){let e=t.target;if(e._snapped=!1,this.throttledList||(this.throttledList=L.Util.throttle(this._handleThrottleSnapping,100,this)),t?.originalEvent?.altKey||this._map?.pm?.Keyboard.isAltKeyPressed()||(void 0===this._snapList&&(this._createSnapList(),this._map.off("layeradd",this.throttledList,this),this._map.on("layeradd",this.throttledList,this)),this._snapList.length<=0))return!1;let i=this._calcClosestLayer(e.getLatLng(),this._snapList);if(0===Object.keys(i).length)return!1;let n,r=i.layer instanceof L.Marker||i.layer instanceof L.CircleMarker||!this.options.snapSegment;n=r?i.latlng:this._checkPrioritiySnapping(i);let o=this.options.snapDistance,s={marker:e,shape:this._shape,snapLatLng:n,segment:i.segment,layer:this._layer,workingLayer:this._layer,layerInteractedWith:i.layer,distance:i.distance};if(this._fireSnapDrag(s.marker,s),this._fireSnapDrag(this._layer,s),i.distance<o){e._orgLatLng=e.getLatLng(),e.setLatLng(n),e._snapped=!0,e._snapInfo=s;let t=()=>{this._snapLatLng=n,this._fireSnap(e,s),this._fireSnap(this._layer,s)},i=this._snapLatLng||{},r=n||{};(i.lat!==r.lat||i.lng!==r.lng)&&t()}else this._snapLatLng&&(this._unsnap(s),e._snapped=!1,e._snapInfo=void 0,this._fireUnsnap(s.marker,s),this._fireUnsnap(this._layer,s));return!0},_createSnapList(){let t=[],e=[],i=this._map;i.off("layerremove",this._handleSnapLayerRemoval,this),i.on("layerremove",this._handleSnapLayerRemoval,this),i.eachLayer((i=>{if((i instanceof L.Polyline||i instanceof L.Marker||i instanceof L.CircleMarker||i instanceof L.ImageOverlay)&&!0!==i.options.snapIgnore){if(void 0===i.options.snapIgnore&&(!L.PM.optIn&&!0===i.options.pmIgnore||L.PM.optIn&&!1!==i.options.pmIgnore))return;(i instanceof L.Circle||i instanceof L.CircleMarker)&&i.pm&&i.pm._hiddenPolyCircle?t.push(i.pm._hiddenPolyCircle):i instanceof L.ImageOverlay&&(i=L.rectangle(i.getBounds())),t.push(i);let n=L.polyline([],{color:"red",pmIgnore:!0});n._pmTempLayer=!0,e.push(n),(i instanceof L.Circle||i instanceof L.CircleMarker)&&e.push(n)}})),t=t.filter((t=>this._layer!==t)),t=t.filter((t=>t._latlng||t._latlngs&&Be(t._latlngs))),t=t.filter((t=>!t._pmTempLayer)),this._otherSnapLayers?(this._otherSnapLayers.forEach((()=>{let t=L.polyline([],{color:"red",pmIgnore:!0});t._pmTempLayer=!0,e.push(t)})),this._snapList=t.concat(this._otherSnapLayers)):this._snapList=t,this.debugIndicatorLines=e},_handleSnapLayerRemoval({layer:t}){if(!t._leaflet_id)return;let e=this._snapList.findIndex((e=>e._leaflet_id===t._leaflet_id));e>-1&&this._snapList.splice(e,1)},_calcClosestLayer(t,e){return this._calcClosestLayers(t,e,1)[0]},_calcClosestLayers(t,e,i=1){let n=[],r={};e.forEach(((e,o)=>{if(e._parentCopy&&e._parentCopy===this._layer)return;let s=this._calcLayerDistances(t,e);if(s.distance=Math.floor(s.distance),this.debugIndicatorLines){if(!this.debugIndicatorLines[o]){let t=L.polyline([],{color:"red",pmIgnore:!0});t._pmTempLayer=!0,this.debugIndicatorLines[o]=t}this.debugIndicatorLines[o].setLatLngs([t,s.latlng])}1===i&&(void 0===r.distance||s.distance-5<=r.distance)?(s.distance+5<r.distance&&(n=[]),r=s,r.layer=e,n.push(r)):1!==i&&(r={},r=s,r.layer=e,n.push(r))})),1!==i&&(n=n.sort(((t,e)=>t.distance-e.distance))),-1===i&&(i=n.length);let o=this._getClosestLayerByPriority(n,i);return L.Util.isArray(o)?o:[o]},_calcLayerDistances(t,e){let i=this._map,n=e instanceof L.Marker||e instanceof L.CircleMarker,r=e instanceof L.Polygon,o=t;if(n){let t=e.getLatLng();return{latlng:{...t},distance:this._getDistance(i,t,o)}}return this._calcLatLngDistances(o,e.getLatLngs(),i,r)},_calcLatLngDistances(t,e,i,n=!1){let r,o,s,a=e=>{e.forEach(((l,h)=>{if(Array.isArray(l))a(l);else if(this.options.snapSegment){let r,a=l;r=n?h+1===e.length?0:h+1:h+1===e.length?void 0:h+1;let c=e[r];if(c){let e=this._getDistanceToSegment(i,t,a,c);(void 0===o||e<o)&&(o=e,s=[a,c])}}else{let e=this._getDistance(i,t,l);(void 0===o||e<o)&&(o=e,r=l)}}))};return a(e),this.options.snapSegment?{latlng:{...this._getClosestPointOnSegment(i,t,s[0],s[1])},segment:s,distance:o}:{latlng:r,distance:o}},_getClosestLayerByPriority(t,e=1){t=t.sort(((t,e)=>t._leaflet_id-e._leaflet_id));let i=this._map.pm.globalOptions.snappingOrder||[],n=0,r={};return i.concat(["Marker","CircleMarker","Circle","Line","Polygon","Rectangle"]).forEach((t=>{r[t]||(n+=1,r[t]=n)})),t.sort(function(t,e,i="asc"){if(!e||0===Object.keys(e).length)return(t,e)=>t-e;let n,r=Object.keys(e),o=r.length-1,s={};for(;o>=0;)n=r[o],s[n.toLowerCase()]=e[n],o-=1;function a(t){return t instanceof L.Marker?"Marker":t instanceof L.Circle?"Circle":t instanceof L.CircleMarker?"CircleMarker":t instanceof L.Rectangle?"Rectangle":t instanceof L.Polygon?"Polygon":t instanceof L.Polyline?"Line":void 0}return(e,n)=>{let r,o;if("instanceofShape"===t){if(r=a(e.layer).toLowerCase(),o=a(n.layer).toLowerCase(),!r||!o)return 0}else{if(!e.hasOwnProperty(t)||!n.hasOwnProperty(t))return 0;r=e[t].toLowerCase(),o=n[t].toLowerCase()}let l=r in s?s[r]:Number.MAX_SAFE_INTEGER,h=o in s?s[o]:Number.MAX_SAFE_INTEGER,c=0;return l<h?c=-1:l>h&&(c=1),"desc"===i?-1*c:c}}("instanceofShape",r)),1===e?t[0]||{}:t.slice(0,e)},_checkPrioritiySnapping(t){let e,i=this._map,n=t.segment[0],r=t.segment[1],o=t.latlng,s=this._getDistance(i,n,o),a=this._getDistance(i,r,o),l=s<a?n:r,h=s<a?s:a;if(this.options.snapMiddle){let t=L.PM.Utils.calcMiddleLatLng(i,n,r),e=this._getDistance(i,t,o);e<s&&e<a&&(l=t,h=e)}return e=h<this.options.snapDistance?l:o,{...e}},_unsnap(){delete this._snapLatLng},_getClosestPointOnSegment(t,e,i,n){let r=t.getMaxZoom();r===1/0&&(r=t.getZoom());let o=t.project(e,r),s=t.project(i,r),a=t.project(n,r),l=L.LineUtil.closestPointOnSegment(o,s,a);return t.unproject(l,r)},_getDistanceToSegment(t,e,i,n){let r=t.latLngToLayerPoint(e),o=t.latLngToLayerPoint(i),s=t.latLngToLayerPoint(n);return L.LineUtil.pointToSegmentDistance(r,o,s)},_getDistance:(t,e,i)=>t.latLngToLayerPoint(e).distanceTo(t.latLngToLayerPoint(i))},Ye=L.Class.extend({includes:[Ke,Ee],options:{snappable:!0,snapDistance:20,snapMiddle:!1,allowSelfIntersection:!0,tooltips:!0,templineStyle:{},hintlineStyle:{color:"#3388ff",dashArray:"5,5"},pathOptions:null,cursorMarker:!0,finishOn:null,markerStyle:{draggable:!0,icon:L.icon()},hideMiddleMarkers:!1,minRadiusCircle:null,maxRadiusCircle:null,minRadiusCircleMarker:null,maxRadiusCircleMarker:null,resizeableCircleMarker:!1,resizableCircle:!0,markerEditable:!0,continueDrawing:!1,snapSegment:!0,requireSnapToFinish:!1,rectangleAngle:0},setOptions(t){L.Util.setOptions(this,t),this.setStyle(this.options)},setStyle(){},getOptions(){return this.options},initialize(t){let e=new L.Icon.Default;e.options.tooltipAnchor=[0,0],this.options.markerStyle.icon=e,this._map=t,this.shapes=["Marker","CircleMarker","Line","Polygon","Rectangle","Circle","Cut","Text"],this.shapes.forEach((t=>{this[t]=new L.PM.Draw[t](this._map)})),this.Marker.setOptions({continueDrawing:!0}),this.CircleMarker.setOptions({continueDrawing:!0})},setPathOptions(t,e=!1){this.options.pathOptions=e?(0,We.default)(this.options.pathOptions,t):t},getShapes(){return this.shapes},getShape(){return this._shape},enable(t,e){if(!t)throw new Error(`Error: Please pass a shape as a parameter. Possible shapes are: ${this.getShapes().join(",")}`);this.disable(),this[t].enable(e)},disable(){this.shapes.forEach((t=>{this[t].disable()}))},addControls(){this.shapes.forEach((t=>{this[t].addButton()}))},getActiveShape(){let t;return this.shapes.forEach((e=>{this[e]._enabled&&(t=e)})),t},_setGlobalDrawMode(){"Cut"===this._shape?this._fireGlobalCutModeToggled():this._fireGlobalDrawModeToggled();let t=L.PM.Utils.findLayers(this._map);this._enabled?t.forEach((t=>{L.PM.Utils.disablePopup(t)})):t.forEach((t=>{L.PM.Utils.enablePopup(t)}))},createNewDrawInstance(t,e){let i=this._getShapeFromBtnName(e);if(this[t])throw new TypeError("Draw Type already exists");if(!L.PM.Draw[i])throw new TypeError(`There is no class L.PM.Draw.${i}`);return this[t]=new L.PM.Draw[i](this._map),this[t].toolbarButtonName=t,this[t]._shape=t,this.shapes.push(t),this[e]&&this[t].setOptions(this[e].options),this[t].setOptions(this[t].options),this[t]},_getShapeFromBtnName(t){let e={drawMarker:"Marker",drawCircle:"Circle",drawPolygon:"Polygon",drawPolyline:"Line",drawRectangle:"Rectangle",drawCircleMarker:"CircleMarker",editMode:"Edit",dragMode:"Drag",cutPolygon:"Cut",removalMode:"Removal",rotateMode:"Rotate",drawText:"Text"};return e[t]?e[t]:this[t]?this[t]._shape:t},_finishLayer(t){t.pm&&(t.pm.setOptions(this.options),t.pm._shape=this._shape,t.pm._map=this._map),this._addDrawnLayerProp(t)},_addDrawnLayerProp(t){t._drawnByGeoman=!0},_setPane(t,e){"layerPane"===e?t.options.pane=this._map.pm.globalOptions.panes&&this._map.pm.globalOptions.panes.layerPane||"overlayPane":"vertexPane"===e?t.options.pane=this._map.pm.globalOptions.panes&&this._map.pm.globalOptions.panes.vertexPane||"markerPane":"markerPane"===e&&(t.options.pane=this._map.pm.globalOptions.panes&&this._map.pm.globalOptions.panes.markerPane||"markerPane")},_isFirstLayer(){return 0===(this._map||this._layer._map).pm.getGeomanLayers().length}});Ye.Marker=Ye.extend({initialize(t){this._map=t,this._shape="Marker",this.toolbarButtonName="drawMarker"},enable(t){L.Util.setOptions(this,t),this._enabled=!0,this._map.getContainer().classList.add("geoman-draw-cursor"),this._map.on("click",this._createMarker,this),this._map.pm.Toolbar.toggleButton(this.toolbarButtonName,!0),this._hintMarker=L.marker(this._map.getCenter(),this.options.markerStyle),this._setPane(this._hintMarker,"markerPane"),this._hintMarker._pmTempLayer=!0,this._hintMarker.addTo(this._map),this.options.tooltips&&this._hintMarker.bindTooltip(ze("tooltips.placeMarker"),{permanent:!0,offset:L.point(0,10),direction:"bottom",opacity:.8}).openTooltip(),this._layer=this._hintMarker,this._map.on("mousemove",this._syncHintMarker,this),this.options.markerEditable&&this._map.eachLayer((t=>{this.isRelevantMarker(t)&&t.pm.enable()})),this._fireDrawStart(),this._setGlobalDrawMode()},disable(){this._enabled&&(this._enabled=!1,this._map.getContainer().classList.remove("geoman-draw-cursor"),this._map.off("click",this._createMarker,this),this._hintMarker.remove(),this._map.off("mousemove",this._syncHintMarker,this),this._map.eachLayer((t=>{this.isRelevantMarker(t)&&t.pm.disable()})),this._map.pm.Toolbar.toggleButton(this.toolbarButtonName,!1),this.options.snappable&&this._cleanupSnapping(),this._fireDrawEnd(),this._setGlobalDrawMode())},enabled(){return this._enabled},toggle(t){this.enabled()?this.disable():this.enable(t)},isRelevantMarker:t=>t instanceof L.Marker&&t.pm&&!t._pmTempLayer&&!t.pm._initTextMarker,_syncHintMarker(t){if(this._hintMarker.setLatLng(t.latlng),this.options.snappable){let e=t;e.target=this._hintMarker,this._handleSnapping(e)}this._fireChange(this._hintMarker.getLatLng(),"Draw")},_createMarker(t){if(!t.latlng||this.options.requireSnapToFinish&&!this._hintMarker._snapped&&!this._isFirstLayer())return;this._hintMarker._snapped||this._hintMarker.setLatLng(t.latlng);let e=this._hintMarker.getLatLng(),i=new L.Marker(e,this.options.markerStyle);this._setPane(i,"markerPane"),this._finishLayer(i),i.pm||(i.options.draggable=!1),i.addTo(this._map.pm._getContainingLayer()),i.pm&&this.options.markerEditable?i.pm.enable():i.dragging&&i.dragging.disable(),this._fireCreate(i),this._cleanupSnapping(),this.options.continueDrawing||this.disable()},setStyle(){this.options.markerStyle?.icon&&this._hintMarker?.setIcon(this.options.markerStyle.icon)}});var Xe=6371008.8,Je={centimeters:100*Xe,centimetres:100*Xe,degrees:Xe/111325,feet:3.28084*Xe,inches:39.37*Xe,kilometers:Xe/1e3,kilometres:Xe/1e3,meters:Xe,metres:Xe,miles:Xe/1609.344,millimeters:1e3*Xe,millimetres:1e3*Xe,nauticalmiles:Xe/1852,radians:1,yards:1.0936*Xe};function Qe(t,e,i){void 0===i&&(i={});var n={type:"Feature"};return(0===i.id||i.id)&&(n.id=i.id),i.bbox&&(n.bbox=i.bbox),n.properties=e||{},n.geometry=t,n}function $e(t,e,i){if(void 0===i&&(i={}),!t)throw new Error("coordinates is required");if(!Array.isArray(t))throw new Error("coordinates must be an Array");if(t.length<2)throw new Error("coordinates must be at least 2 numbers long");if(!ri(t[0])||!ri(t[1]))throw new Error("coordinates must contain numbers");return Qe({type:"Point",coordinates:t},e,i)}function ti(t,e,i){if(void 0===i&&(i={}),t.length<2)throw new Error("coordinates must be an array of two or more positions");return Qe({type:"LineString",coordinates:t},e,i)}function ei(t,e){void 0===e&&(e={});var i={type:"FeatureCollection"};return e.id&&(i.id=e.id),e.bbox&&(i.bbox=e.bbox),i.features=t,i}function ii(t){return t%(2*Math.PI)*180/Math.PI}function ni(t){return t%360*Math.PI/180}function ri(t){return!isNaN(t)&&null!==t&&!Array.isArray(t)}function oi(t){var e,i,n={type:"FeatureCollection",features:[]};if("LineString"===(i="Feature"===t.type?t.geometry:t).type)e=[i.coordinates];else if("MultiLineString"===i.type)e=i.coordinates;else if("MultiPolygon"===i.type)e=[].concat.apply([],i.coordinates);else{if("Polygon"!==i.type)throw new Error("Input must be a LineString, MultiLineString, Polygon, or MultiPolygon Feature or Geometry");e=i.coordinates}return e.forEach((function(t){e.forEach((function(e){for(var i=0;i<t.length-1;i++)for(var r=i;r<e.length-1;r++)if(t!==e||1!==Math.abs(i-r)&&(0!==i||r!==t.length-2||t[i][0]!==t[t.length-1][0]||t[i][1]!==t[t.length-1][1])){var o=si(t[i][0],t[i][1],t[i+1][0],t[i+1][1],e[r][0],e[r][1],e[r+1][0],e[r+1][1]);o&&n.features.push($e([o[0],o[1]]))}}))})),n}function si(t,e,i,n,r,o,s,a){var l,h,c,u,d={x:null,y:null,onLine1:!1,onLine2:!1};return 0==(l=(a-o)*(i-t)-(s-r)*(n-e))?null!==d.x&&null!==d.y&&d:(u=(i-t)*(h=e-o)-(n-e)*(c=t-r),h=((s-r)*h-(a-o)*c)/l,c=u/l,d.x=t+h*(i-t),d.y=e+h*(n-e),h>=0&&h<=1&&(d.onLine1=!0),c>=0&&c<=1&&(d.onLine2=!0),!(!d.onLine1||!d.onLine2)&&[d.x,d.y])}function ai(t){if(!t)throw new Error("coord is required");if(!Array.isArray(t)){if("Feature"===t.type&&null!==t.geometry&&"Point"===t.geometry.type)return t.geometry.coordinates;if("Point"===t.type)return t.coordinates}if(Array.isArray(t)&&t.length>=2&&!Array.isArray(t[0])&&!Array.isArray(t[1]))return t;throw new Error("coord must be GeoJSON Point or an Array of numbers")}function li(t){if(Array.isArray(t))return t;if("Feature"===t.type){if(null!==t.geometry)return t.geometry.coordinates}else if(t.coordinates)return t.coordinates;throw new Error("coords must be GeoJSON Feature, Geometry Object or an Array")}function hi(t){return"Feature"===t.type?t.geometry:t}function ci(t,e){return"FeatureCollection"===t.type?"FeatureCollection":"GeometryCollection"===t.type?"GeometryCollection":"Feature"===t.type&&null!==t.geometry?t.geometry.type:t.type}function ui(t,e,i){if(null!==t)for(var n,r,o,s,a,l,h,c,u=0,d=0,p=t.type,f="FeatureCollection"===p,m="Feature"===p,g=f?t.features.length:1,_=0;_<g;_++){a=(c=!!(h=f?t.features[_].geometry:m?t.geometry:t)&&"GeometryCollection"===h.type)?h.geometries.length:1;for(var y=0;y<a;y++){var v=0,b=0;if(null!==(s=c?h.geometries[y]:h)){l=s.coordinates;var x=s.type;switch(u=!i||"Polygon"!==x&&"MultiPolygon"!==x?0:1,x){case null:break;case"Point":if(!1===e(l,d,_,v,b))return!1;d++,v++;break;case"LineString":case"MultiPoint":for(n=0;n<l.length;n++){if(!1===e(l[n],d,_,v,b))return!1;d++,"MultiPoint"===x&&v++}"LineString"===x&&v++;break;case"Polygon":case"MultiLineString":for(n=0;n<l.length;n++){for(r=0;r<l[n].length-u;r++){if(!1===e(l[n][r],d,_,v,b))return!1;d++}"MultiLineString"===x&&v++,"Polygon"===x&&b++}"Polygon"===x&&v++;break;case"MultiPolygon":for(n=0;n<l.length;n++){for(b=0,r=0;r<l[n].length;r++){for(o=0;o<l[n][r].length-u;o++){if(!1===e(l[n][r][o],d,_,v,b))return!1;d++}b++}v++}break;case"GeometryCollection":for(n=0;n<s.geometries.length;n++)if(!1===ui(s.geometries[n],e,i))return!1;break;default:throw new Error("Unknown Geometry Type")}}}}}function di(t,e){if("Feature"===t.type)e(t,0);else if("FeatureCollection"===t.type)for(var i=0;i<t.features.length&&!1!==e(t.features[i],i);i++);}function pi(t,e){!function(t,e){var i,n,r,o,s,a,l,h,c,u,d=0,p="FeatureCollection"===t.type,f="Feature"===t.type,m=p?t.features.length:1;for(i=0;i<m;i++){for(a=p?t.features[i].geometry:f?t.geometry:t,h=p?t.features[i].properties:f?t.properties:{},c=p?t.features[i].bbox:f?t.bbox:void 0,u=p?t.features[i].id:f?t.id:void 0,s=(l=!!a&&"GeometryCollection"===a.type)?a.geometries.length:1,r=0;r<s;r++)if(null!==(o=l?a.geometries[r]:a))switch(o.type){case"Point":case"LineString":case"MultiPoint":case"Polygon":case"MultiLineString":case"MultiPolygon":if(!1===e(o,d,h,c,u))return!1;break;case"GeometryCollection":for(n=0;n<o.geometries.length;n++)if(!1===e(o.geometries[n],d,h,c,u))return!1;break;default:throw new Error("Unknown Geometry Type")}else if(!1===e(null,d,h,c,u))return!1;d++}}(t,(function(t,i,n,r,o){var s,a=null===t?null:t.type;switch(a){case null:case"Point":case"LineString":case"Polygon":return!1!==e(Qe(t,n,{bbox:r,id:o}),i,0)&&void 0}switch(a){case"MultiPoint":s="Point";break;case"MultiLineString":s="LineString";break;case"MultiPolygon":s="Polygon"}for(var l=0;l<t.coordinates.length;l++){var h=t.coordinates[l];if(!1===e(Qe({type:s,coordinates:h},n),i,l))return!1}}))}Ye.Line=Ye.extend({initialize(t){this._map=t,this._shape="Line",this.toolbarButtonName="drawPolyline",this._doesSelfIntersect=!1},enable(t){L.Util.setOptions(this,t),this._enabled=!0,this._markers=[],this._layerGroup=new L.FeatureGroup,this._layerGroup._pmTempLayer=!0,this._layerGroup.addTo(this._map),this._layer=L.polyline([],{...this.options.templineStyle,pmIgnore:!1}),this._setPane(this._layer,"layerPane"),this._layer._pmTempLayer=!0,this._layerGroup.addLayer(this._layer),this._hintline=L.polyline([],this.options.hintlineStyle),this._setPane(this._hintline,"layerPane"),this._hintline._pmTempLayer=!0,this._layerGroup.addLayer(this._hintline),this._hintMarker=L.marker(this._map.getCenter(),{interactive:!1,zIndexOffset:100,icon:L.divIcon({className:"marker-icon cursor-marker"})}),this._setPane(this._hintMarker,"vertexPane"),this._hintMarker._pmTempLayer=!0,this._layerGroup.addLayer(this._hintMarker),this.options.cursorMarker&&L.DomUtil.addClass(this._hintMarker._icon,"visible"),this.options.tooltips&&this._hintMarker.bindTooltip(ze("tooltips.firstVertex"),{permanent:!0,offset:L.point(0,10),direction:"bottom",opacity:.8}).openTooltip(),this._map.getContainer().classList.add("geoman-draw-cursor"),this._map.on("click",this._createVertex,this),this.options.finishOn&&"snap"!==this.options.finishOn&&this._map.on(this.options.finishOn,this._finishShape,this),"dblclick"===this.options.finishOn&&(this.tempMapDoubleClickZoomState=this._map.doubleClickZoom._enabled,this.tempMapDoubleClickZoomState&&this._map.doubleClickZoom.disable()),this._map.on("mousemove",this._syncHintMarker,this),this._hintMarker.on("move",this._syncHintLine,this),this._map.pm.Toolbar.toggleButton(this.toolbarButtonName,!0),this._otherSnapLayers=[],this.isRed=!1,this._fireDrawStart(),this._setGlobalDrawMode()},disable(){this._enabled&&(this._enabled=!1,this._map.getContainer().classList.remove("geoman-draw-cursor"),this._map.off("click",this._createVertex,this),this._map.off("mousemove",this._syncHintMarker,this),this.options.finishOn&&"snap"!==this.options.finishOn&&this._map.off(this.options.finishOn,this._finishShape,this),this.tempMapDoubleClickZoomState&&this._map.doubleClickZoom.enable(),this._map.removeLayer(this._layerGroup),this._map.pm.Toolbar.toggleButton(this.toolbarButtonName,!1),this.options.snappable&&this._cleanupSnapping(),this._fireDrawEnd(),this._setGlobalDrawMode())},enabled(){return this._enabled},toggle(t){this.enabled()?this.disable():this.enable(t)},_syncHintLine(){let t=this._layer.getLatLngs();if(t.length>0){let e=t[t.length-1];this._hintline.setLatLngs([e,this._hintMarker.getLatLng()])}},_syncHintMarker(t){if(this._hintMarker.setLatLng(t.latlng),this.options.snappable){let e=t;e.target=this._hintMarker,this._handleSnapping(e)}this.options.allowSelfIntersection||this._handleSelfIntersection(!0,this._hintMarker.getLatLng());let e=this._layer._defaultShape().slice();e.push(this._hintMarker.getLatLng()),this._change(e)},hasSelfIntersection(){return oi(this._layer.toGeoJSON(15)).features.length>0},_handleSelfIntersection(t,e){let i=L.polyline(this._layer.getLatLngs());t&&(e||(e=this._hintMarker.getLatLng()),i.addLatLng(e));let n=oi(i.toGeoJSON(15));this._doesSelfIntersect=n.features.length>0,this._doesSelfIntersect?this.isRed||(this.isRed=!0,this._hintline.setStyle({color:"#f00000ff"}),this._fireIntersect(n,this._map,"Draw")):this._hintline.isEmpty()||(this.isRed=!1,this._hintline.setStyle(this.options.hintlineStyle))},_createVertex(t){if(!this.options.allowSelfIntersection&&(this._handleSelfIntersection(!0,t.latlng),this._doesSelfIntersect))return;this._hintMarker._snapped||this._hintMarker.setLatLng(t.latlng);let e=this._hintMarker.getLatLng(),i=this._layer.getLatLngs(),n=i[i.length-1];if(e.equals(i[0])||i.length>0&&e.equals(n))return void this._finishShape();this._layer._latlngInfo=this._layer._latlngInfo||[],this._layer._latlngInfo.push({latlng:e,snapInfo:this._hintMarker._snapInfo}),this._layer.addLatLng(e);let r=this._createMarker(e);this._setTooltipText(),this._setHintLineAfterNewVertex(e),this._fireVertexAdded(r,void 0,e,"Draw"),this._change(this._layer.getLatLngs()),"snap"===this.options.finishOn&&this._hintMarker._snapped&&this._finishShape(t)},_setHintLineAfterNewVertex(t){this._hintline.setLatLngs([t,t])},_removeLastVertex(){let t=this._markers;if(t.length<=1)return void this.disable();let e=this._layer.getLatLngs(),i=t[t.length-1],{indexPath:n}=L.PM.Utils.findDeepMarkerIndex(t,i);t.pop(),this._layerGroup.removeLayer(i);let r=t[t.length-1],o=e.indexOf(r.getLatLng());e=e.slice(0,o+1),this._layer.setLatLngs(e),this._layer._latlngInfo.pop(),this._syncHintLine(),this._setTooltipText(),this._fireVertexRemoved(i,n,"Draw"),this._change(this._layer.getLatLngs())},_finishShape(){if(!this.options.allowSelfIntersection&&(this._handleSelfIntersection(!1),this._doesSelfIntersect)||this.options.requireSnapToFinish&&!this._hintMarker._snapped&&!this._isFirstLayer())return;let t=this._layer.getLatLngs();if(t.length<=1)return;let e=L.polyline(t,this.options.pathOptions);this._setPane(e,"layerPane"),this._finishLayer(e),e.addTo(this._map.pm._getContainingLayer()),this._fireCreate(e),this.options.snappable&&this._cleanupSnapping(),this.disable(),this.options.continueDrawing&&this.enable()},_createMarker(t){let e=new L.Marker(t,{draggable:!1,icon:L.divIcon({className:"marker-icon"})});return this._setPane(e,"vertexPane"),e._pmTempLayer=!0,this._layerGroup.addLayer(e),this._markers.push(e),e.on("click",this._finishShape,this),e},_setTooltipText(){let{length:t}=this._layer.getLatLngs().flat(),e="";e=ze(t<=1?"tooltips.continueLine":"tooltips.finishLine"),this._hintMarker.setTooltipContent(e)},_change(t){this._fireChange(t,"Draw")},setStyle(){this._layer?.setStyle(this.options.templineStyle),this._hintline?.setStyle(this.options.hintlineStyle)}}),Ye.Polygon=Ye.Line.extend({initialize(t){this._map=t,this._shape="Polygon",this.toolbarButtonName="drawPolygon"},enable(t){L.PM.Draw.Line.prototype.enable.call(this,t),this._layer.pm._shape="Polygon"},_createMarker(t){let e=new L.Marker(t,{draggable:!1,icon:L.divIcon({className:"marker-icon"})});return this._setPane(e,"vertexPane"),e._pmTempLayer=!0,this._layerGroup.addLayer(e),this._markers.push(e),1===this._layer.getLatLngs().flat().length?(e.on("click",this._finishShape,this),this._tempSnapLayerIndex=this._otherSnapLayers.push(e)-1,this.options.snappable&&this._cleanupSnapping()):e.on("click",(()=>1)),e},_setTooltipText(){let{length:t}=this._layer.getLatLngs().flat(),e="";e=ze(t<=2?"tooltips.continueLine":"tooltips.finishPoly"),this._hintMarker.setTooltipContent(e)},_finishShape(){if(!this.options.allowSelfIntersection&&(this._handleSelfIntersection(!0,this._layer.getLatLngs()[0]),this._doesSelfIntersect)||this.options.requireSnapToFinish&&!this._hintMarker._snapped&&!this._isFirstLayer())return;let t=this._layer.getLatLngs();if(t.length<=2)return;let e=L.polygon(t,this.options.pathOptions);this._setPane(e,"layerPane"),this._finishLayer(e),e.addTo(this._map.pm._getContainingLayer()),this._fireCreate(e),this._cleanupSnapping(),this._otherSnapLayers.splice(this._tempSnapLayerIndex,1),delete this._tempSnapLayerIndex,this.disable(),this.options.continueDrawing&&this.enable()}}),Ye.Rectangle=Ye.extend({initialize(t){this._map=t,this._shape="Rectangle",this.toolbarButtonName="drawRectangle"},enable(t){if(L.Util.setOptions(this,t),this._enabled=!0,this._layerGroup=new L.FeatureGroup,this._layerGroup._pmTempLayer=!0,this._layerGroup.addTo(this._map),this._layer=L.rectangle([[0,0],[0,0]],this.options.pathOptions),this._setPane(this._layer,"layerPane"),this._layer._pmTempLayer=!0,this._startMarker=L.marker(this._map.getCenter(),{icon:L.divIcon({className:"marker-icon rect-start-marker"}),draggable:!1,zIndexOffset:-100,opacity:this.options.cursorMarker?1:0}),this._setPane(this._startMarker,"vertexPane"),this._startMarker._pmTempLayer=!0,this._layerGroup.addLayer(this._startMarker),this._hintMarker=L.marker(this._map.getCenter(),{zIndexOffset:150,icon:L.divIcon({className:"marker-icon cursor-marker"})}),this._setPane(this._hintMarker,"vertexPane"),this._hintMarker._pmTempLayer=!0,this._layerGroup.addLayer(this._hintMarker),this.options.cursorMarker&&L.DomUtil.addClass(this._hintMarker._icon,"visible"),this.options.tooltips&&this._hintMarker.bindTooltip(ze("tooltips.firstVertex"),{permanent:!0,offset:L.point(0,10),direction:"bottom",opacity:.8}).openTooltip(),this.options.cursorMarker){this._styleMarkers=[];for(let t=0;t<2;t+=1){let t=L.marker(this._map.getCenter(),{icon:L.divIcon({className:"marker-icon rect-style-marker"}),draggable:!1,zIndexOffset:100});this._setPane(t,"vertexPane"),t._pmTempLayer=!0,this._layerGroup.addLayer(t),this._styleMarkers.push(t)}}this._map.getContainer().classList.add("geoman-draw-cursor"),this._map.on("click",this._placeStartingMarkers,this),this._map.on("mousemove",this._syncHintMarker,this),this._map.pm.Toolbar.toggleButton(this.toolbarButtonName,!0),this._otherSnapLayers=[],this._fireDrawStart(),this._setGlobalDrawMode()},disable(){this._enabled&&(this._enabled=!1,this._map.getContainer().classList.remove("geoman-draw-cursor"),this._map.off("click",this._finishShape,this),this._map.off("click",this._placeStartingMarkers,this),this._map.off("mousemove",this._syncHintMarker,this),this._map.removeLayer(this._layerGroup),this._map.pm.Toolbar.toggleButton(this.toolbarButtonName,!1),this.options.snappable&&this._cleanupSnapping(),this._fireDrawEnd(),this._setGlobalDrawMode())},enabled(){return this._enabled},toggle(t){this.enabled()?this.disable():this.enable(t)},_placeStartingMarkers(t){this._hintMarker._snapped||this._hintMarker.setLatLng(t.latlng);let e=this._hintMarker.getLatLng();L.DomUtil.addClass(this._startMarker._icon,"visible"),this._startMarker.setLatLng(e),this.options.cursorMarker&&this._styleMarkers&&this._styleMarkers.forEach((t=>{L.DomUtil.addClass(t._icon,"visible"),t.setLatLng(e)})),this._map.off("click",this._placeStartingMarkers,this),this._map.on("click",this._finishShape,this),this._hintMarker.setTooltipContent(ze("tooltips.finishRect")),this._setRectangleOrigin()},_setRectangleOrigin(){let t=this._startMarker.getLatLng();t&&(this._layerGroup.addLayer(this._layer),this._layer.setLatLngs([t,t]),this._hintMarker.on("move",this._syncRectangleSize,this))},_syncHintMarker(t){if(this._hintMarker.setLatLng(t.latlng),this.options.snappable){let e=t;e.target=this._hintMarker,this._handleSnapping(e)}let e=this._layerGroup&&this._layerGroup.hasLayer(this._layer)?this._layer.getLatLngs():[this._hintMarker.getLatLng()];this._fireChange(e,"Draw")},_syncRectangleSize(){let t=Ue(this._startMarker.getLatLng(),this._map),e=Ue(this._hintMarker.getLatLng(),this._map),i=L.PM.Utils._getRotatedRectangle(t,e,this.options.rectangleAngle||0,this._map);if(this._layer.setLatLngs(i),this.options.cursorMarker&&this._styleMarkers){let n=[];i.forEach((i=>{!i.equals(t,1e-8)&&!i.equals(e,1e-8)&&n.push(i)})),n.forEach(((t,e)=>{try{this._styleMarkers[e].setLatLng(t)}catch{}}))}},_findCorners(){let t=this._layer.getLatLngs()[0];return L.PM.Utils._getRotatedRectangle(t[0],t[2],this.options.rectangleAngle||0,this._map)},_finishShape(t){this._hintMarker._snapped||this._hintMarker.setLatLng(t.latlng);let e=this._hintMarker.getLatLng(),i=this._startMarker.getLatLng();if(this.options.requireSnapToFinish&&!this._hintMarker._snapped&&!this._isFirstLayer())return;let n=L.rectangle([i,e],this.options.pathOptions);if(this.options.rectangleAngle){let t=L.PM.Utils._getRotatedRectangle(i,e,this.options.rectangleAngle||0,this._map);n.setLatLngs(t),n.pm&&n.pm._setAngle(this.options.rectangleAngle||0)}this._setPane(n,"layerPane"),this._finishLayer(n),n.addTo(this._map.pm._getContainingLayer()),this._fireCreate(n),this.disable(),this.options.continueDrawing&&this.enable()},setStyle(){this._layer?.setStyle(this.options.pathOptions)}}),Ye.CircleMarker=Ye.extend({initialize(t){this._map=t,this._shape="CircleMarker",this.toolbarButtonName="drawCircleMarker",this._layerIsDragging=!1,this._BaseCircleClass=L.CircleMarker,this._minRadiusOption="minRadiusCircleMarker",this._maxRadiusOption="maxRadiusCircleMarker",this._editableOption="resizeableCircleMarker",this._defaultRadius=10},enable(t){if(L.Util.setOptions(this,t),this.options.editable&&(this.options.resizeableCircleMarker=this.options.editable,delete this.options.editable),this._enabled=!0,this._map.pm.Toolbar.toggleButton(this.toolbarButtonName,!0),this._map.getContainer().classList.add("geoman-draw-cursor"),this.options[this._editableOption]){let t={};L.extend(t,this.options.templineStyle),t.radius=0,this._layerGroup=new L.FeatureGroup,this._layerGroup._pmTempLayer=!0,this._layerGroup.addTo(this._map),this._layer=new this._BaseCircleClass(this._map.getCenter(),t),this._setPane(this._layer,"layerPane"),this._layer._pmTempLayer=!0,this._centerMarker=L.marker(this._map.getCenter(),{icon:L.divIcon({className:"marker-icon"}),draggable:!1,zIndexOffset:100}),this._setPane(this._centerMarker,"vertexPane"),this._centerMarker._pmTempLayer=!0,this._hintMarker=L.marker(this._map.getCenter(),{zIndexOffset:110,icon:L.divIcon({className:"marker-icon cursor-marker"})}),this._setPane(this._hintMarker,"vertexPane"),this._hintMarker._pmTempLayer=!0,this._layerGroup.addLayer(this._hintMarker),this.options.cursorMarker&&L.DomUtil.addClass(this._hintMarker._icon,"visible"),this.options.tooltips&&this._hintMarker.bindTooltip(ze("tooltips.startCircle"),{permanent:!0,offset:L.point(0,10),direction:"bottom",opacity:.8}).openTooltip(),this._hintline=L.polyline([],this.options.hintlineStyle),this._setPane(this._hintline,"layerPane"),this._hintline._pmTempLayer=!0,this._layerGroup.addLayer(this._hintline),this._map.on("click",this._placeCenterMarker,this)}else this._map.on("click",this._createMarker,this),this._hintMarker=new this._BaseCircleClass(this._map.getCenter(),{radius:this._defaultRadius,...this.options.templineStyle}),this._setPane(this._hintMarker,"layerPane"),this._hintMarker._pmTempLayer=!0,this._hintMarker.addTo(this._map),this._layer=this._hintMarker,this.options.tooltips&&this._hintMarker.bindTooltip(ze("tooltips.placeCircleMarker"),{permanent:!0,offset:L.point(0,10),direction:"bottom",opacity:.8}).openTooltip();this._map.on("mousemove",this._syncHintMarker,this),this._extendingEnable(),this._otherSnapLayers=[],this._fireDrawStart(),this._setGlobalDrawMode()},_extendingEnable(){!this.options[this._editableOption]&&this.options.markerEditable&&this._map.eachLayer((t=>{this.isRelevantMarker(t)&&t.pm.enable()})),this._layer.bringToBack()},disable(){this._enabled&&(this._enabled=!1,this._map.getContainer().classList.remove("geoman-draw-cursor"),this.options[this._editableOption]?(this._map.off("click",this._finishShape,this),this._map.off("click",this._placeCenterMarker,this),this._map.removeLayer(this._layerGroup)):(this._map.off("click",this._createMarker,this),this._extendingDisable(),this._hintMarker.remove()),this._map.off("mousemove",this._syncHintMarker,this),this._map.pm.Toolbar.toggleButton(this.toolbarButtonName,!1),this.options.snappable&&this._cleanupSnapping(),this._fireDrawEnd(),this._setGlobalDrawMode())},_extendingDisable(){this._map.eachLayer((t=>{this.isRelevantMarker(t)&&t.pm.disable()}))},enabled(){return this._enabled},toggle(t){this.enabled()?this.disable():this.enable(t)},_placeCenterMarker(t){this._layerGroup.addLayer(this._layer),this._layerGroup.addLayer(this._centerMarker),this._hintMarker._snapped||this._hintMarker.setLatLng(t.latlng);let e=this._hintMarker.getLatLng();this._layerGroup.addLayer(this._layer),this._centerMarker.setLatLng(e),this._map.off("click",this._placeCenterMarker,this),this._map.on("click",this._finishShape,this),this._placeCircleCenter()},_placeCircleCenter(){let t=this._centerMarker.getLatLng();t&&(this._layer.setLatLng(t),this._hintMarker.on("move",this._syncHintLine,this),this._hintMarker.on("move",this._syncCircleRadius,this),this._hintMarker.setTooltipContent(ze("tooltips.finishCircle")),this._fireCenterPlaced(),this._fireChange(this._layer.getLatLng(),"Draw"))},_syncHintLine(){let t=this._centerMarker.getLatLng(),e=this._getNewDestinationOfHintMarker();this._hintline.setLatLngs([t,e])},_syncCircleRadius(){let t=this._centerMarker.getLatLng(),e=this._hintMarker.getLatLng(),i=this._distanceCalculation(t,e);this.options[this._minRadiusOption]&&i<this.options[this._minRadiusOption]?this._layer.setRadius(this.options[this._minRadiusOption]):this.options[this._maxRadiusOption]&&i>this.options[this._maxRadiusOption]?this._layer.setRadius(this.options[this._maxRadiusOption]):this._layer.setRadius(i)},_syncHintMarker(t){if(this._hintMarker.setLatLng(t.latlng),this._hintMarker.setLatLng(this._getNewDestinationOfHintMarker()),this.options.snappable){let e=t;e.target=this._hintMarker,this._handleSnapping(e)}this._handleHintMarkerSnapping();let e=this._layerGroup&&this._layerGroup.hasLayer(this._centerMarker)?this._centerMarker.getLatLng():this._hintMarker.getLatLng();this._fireChange(e,"Draw")},isRelevantMarker:t=>t instanceof L.CircleMarker&&!(t instanceof L.Circle)&&t.pm&&!t._pmTempLayer,_createMarker(t){if(this.options.requireSnapToFinish&&!this._hintMarker._snapped&&!this._isFirstLayer()||!t.latlng||this._layerIsDragging)return;this._hintMarker._snapped||this._hintMarker.setLatLng(t.latlng);let e=this._hintMarker.getLatLng(),i=new this._BaseCircleClass(e,{radius:this._defaultRadius,...this.options.pathOptions});this._setPane(i,"layerPane"),this._finishLayer(i),i.addTo(this._map.pm._getContainingLayer()),this._extendingCreateMarker(i),this._fireCreate(i),this._cleanupSnapping(),this.options.continueDrawing||this.disable()},_extendingCreateMarker(t){t.pm&&this.options.markerEditable&&t.pm.enable()},_finishShape(t){if(this.options.requireSnapToFinish&&!this._hintMarker._snapped&&!this._isFirstLayer())return;this._hintMarker._snapped||this._hintMarker.setLatLng(t.latlng);let e=this._centerMarker.getLatLng(),i=this._defaultRadius;if(this.options[this._editableOption]){let t=this._hintMarker.getLatLng();i=this._distanceCalculation(e,t),this.options[this._minRadiusOption]&&i<this.options[this._minRadiusOption]?i=this.options[this._minRadiusOption]:this.options[this._maxRadiusOption]&&i>this.options[this._maxRadiusOption]&&(i=this.options[this._maxRadiusOption])}let n={...this.options.pathOptions,radius:i},r=new this._BaseCircleClass(e,n);this._setPane(r,"layerPane"),this._finishLayer(r),r.addTo(this._map.pm._getContainingLayer()),r.pm&&r.pm._updateHiddenPolyCircle(),this._fireCreate(r),this.disable(),this.options.continueDrawing&&this.enable()},_getNewDestinationOfHintMarker(){let t=this._hintMarker.getLatLng();if(this.options[this._editableOption]){if(!this._layerGroup.hasLayer(this._centerMarker))return t;let e=this._centerMarker.getLatLng(),i=this._distanceCalculation(e,t);this.options[this._minRadiusOption]&&i<this.options[this._minRadiusOption]?t=Fe(this._map,e,t,this._getMinDistanceInMeter()):this.options[this._maxRadiusOption]&&i>this.options[this._maxRadiusOption]&&(t=Fe(this._map,e,t,this._getMaxDistanceInMeter()))}return t},_getMinDistanceInMeter(){return L.PM.Utils.pxRadiusToMeterRadius(this.options[this._minRadiusOption],this._map,this._centerMarker.getLatLng())},_getMaxDistanceInMeter(){return L.PM.Utils.pxRadiusToMeterRadius(this.options[this._maxRadiusOption],this._map,this._centerMarker.getLatLng())},_handleHintMarkerSnapping(){if(this.options[this._editableOption]){if(this._hintMarker._snapped){let t=this._centerMarker.getLatLng(),e=this._hintMarker.getLatLng(),i=this._distanceCalculation(t,e);this._layerGroup.hasLayer(this._centerMarker)&&(this.options[this._minRadiusOption]&&i<this.options[this._minRadiusOption]||this.options[this._maxRadiusOption]&&i>this.options[this._maxRadiusOption])&&this._hintMarker.setLatLng(this._hintMarker._orgLatLng)}this._hintMarker.setLatLng(this._getNewDestinationOfHintMarker())}},setStyle(){let t={};L.extend(t,this.options.templineStyle),this.options[this._editableOption]&&(t.radius=0),this._layer?.setStyle(t),this._hintline?.setStyle(this.options.hintlineStyle)},_distanceCalculation(t,e){return this._map.project(t).distanceTo(this._map.project(e))}}),Ye.Circle=Ye.CircleMarker.extend({initialize(t){this._map=t,this._shape="Circle",this.toolbarButtonName="drawCircle",this._BaseCircleClass=L.Circle,this._minRadiusOption="minRadiusCircle",this._maxRadiusOption="maxRadiusCircle",this._editableOption="resizableCircle",this._defaultRadius=100},_extendingEnable(){},_extendingDisable(){},_extendingCreateMarker(){},isRelevantMarker(){},_getMinDistanceInMeter(){return this.options[this._minRadiusOption]},_getMaxDistanceInMeter(){return this.options[this._maxRadiusOption]},_distanceCalculation(t,e){return this._map.distance(t,e)}});var fi=function(t){if(!t)throw new Error("geojson is required");var e=[];return pi(t,(function(t){!function(t,e){var i=[],n=t.geometry;if(null!==n){switch(n.type){case"Polygon":i=li(n);break;case"LineString":i=[li(n)]}i.forEach((function(i){var n=function(t,e){var i=[];return t.reduce((function(t,n){var r=ti([t,n],e);return r.bbox=function(t,e){var i=t[0],n=t[1],r=e[0],o=e[1];return[i<r?i:r,n<o?n:o,i>r?i:r,n>o?n:o]}(t,n),i.push(r),n})),i}(i,t.properties);n.forEach((function(t){t.id=e.length,e.push(t)}))}))}}(t,e)})),ei(e)},mi=d(xe(),1);function gi(t,e){var i=li(t),n=li(e);if(2!==i.length)throw new Error("<intersects> line1 must only contain 2 coordinates");if(2!==n.length)throw new Error("<intersects> line2 must only contain 2 coordinates");var r=i[0][0],o=i[0][1],s=i[1][0],a=i[1][1],l=n[0][0],h=n[0][1],c=n[1][0],u=n[1][1],d=(u-h)*(s-r)-(c-l)*(a-o);if(0===d)return null;var p=((c-l)*(o-h)-(u-h)*(r-l))/d,f=((s-r)*(o-h)-(a-o)*(r-l))/d;return p>=0&&p<=1&&f>=0&&f<=1?$e([r+p*(s-r),o+p*(a-o)]):null}var _i=function(t,e){var i={},n=[];if("LineString"===t.type&&(t=Qe(t)),"LineString"===e.type&&(e=Qe(e)),"Feature"===t.type&&"Feature"===e.type&&null!==t.geometry&&null!==e.geometry&&"LineString"===t.geometry.type&&"LineString"===e.geometry.type&&2===t.geometry.coordinates.length&&2===e.geometry.coordinates.length){var r=gi(t,e);return r&&n.push(r),ei(n)}var o=(0,mi.default)();return o.load(fi(e)),di(fi(t),(function(t){di(o.search(t),(function(e){var r=gi(t,e);if(r){var o=li(r).join(",");i[o]||(i[o]=!0,n.push(r))}}))})),ei(n)},yi=d(xe(),1),vi=function(t,e,i){void 0===i&&(i={});var n=ai(t),r=ai(e),o=ni(r[1]-n[1]),s=ni(r[0]-n[0]),a=ni(n[1]),l=ni(r[1]),h=Math.pow(Math.sin(o/2),2)+Math.pow(Math.sin(s/2),2)*Math.cos(a)*Math.cos(l);return function(t,e){void 0===e&&(e="kilometers");var i=Je[e];if(!i)throw new Error(e+" units is invalid");return t*i}(2*Math.atan2(Math.sqrt(h),Math.sqrt(1-h)),i.units)};function bi(t){var e=[1/0,1/0,-1/0,-1/0];return ui(t,(function(t){e[0]>t[0]&&(e[0]=t[0]),e[1]>t[1]&&(e[1]=t[1]),e[2]<t[0]&&(e[2]=t[0]),e[3]<t[1]&&(e[3]=t[1])})),e}bi.default=bi;var xi=bi;function wi(t,e,i){if(void 0===i&&(i={}),!0===i.final)return function(t,e){var i=wi(e,t);return i=(i+180)%360}(t,e);var n=ai(t),r=ai(e),o=ni(n[0]),s=ni(r[0]),a=ni(n[1]),l=ni(r[1]),h=Math.sin(s-o)*Math.cos(l),c=Math.cos(a)*Math.sin(l)-Math.sin(a)*Math.cos(l)*Math.cos(s-o);return ii(Math.atan2(h,c))}function Li(t,e,i,n){void 0===n&&(n={});var r=ai(t),o=ni(r[0]),s=ni(r[1]),a=ni(i),l=function(t,e){void 0===e&&(e="kilometers");var i=Je[e];if(!i)throw new Error(e+" units is invalid");return t/i}(e,n.units),h=Math.asin(Math.sin(s)*Math.cos(l)+Math.cos(s)*Math.sin(l)*Math.cos(a));return $e([ii(o+Math.atan2(Math.sin(a)*Math.sin(l)*Math.cos(s),Math.cos(l)-Math.sin(s)*Math.sin(h))),ii(h)],n.properties)}var Mi=function(t,e,i){void 0===i&&(i={});var n=$e([1/0,1/0],{dist:1/0}),r=0;return pi(t,(function(t){for(var o=li(t),s=0;s<o.length-1;s++){var a=$e(o[s]);a.properties.dist=vi(e,a,i);var l=$e(o[s+1]);l.properties.dist=vi(e,l,i);var h=vi(a,l,i),c=Math.max(a.properties.dist,l.properties.dist),u=wi(a,l),d=Li(e,c,u+90,i),p=Li(e,c,u-90,i),f=_i(ti([d.geometry.coordinates,p.geometry.coordinates]),ti([a.geometry.coordinates,l.geometry.coordinates])),m=null;f.features.length>0&&((m=f.features[0]).properties.dist=vi(e,m,i),m.properties.location=r+vi(a,m,i)),a.properties.dist<n.properties.dist&&((n=a).properties.index=s,n.properties.location=r),l.properties.dist<n.properties.dist&&((n=l).properties.index=s+1,n.properties.location=r+h),m&&m.properties.dist<n.properties.dist&&((n=m).properties.index=s),r+=h}})),n};function ki(t,e){var i=[],n=(0,yi.default)();return pi(e,(function(e){if(i.forEach((function(t,e){t.id=e})),i.length){var r=n.search(e);if(r.features.length){var o=Ai(e,r);i=i.filter((function(t){return t.id!==o.id})),n.remove(o),di(Ci(o,e),(function(t){i.push(t),n.insert(t)}))}}else(i=Ci(t,e).features).forEach((function(t){t.bbox||(t.bbox=function(t){var e=t[0],i=t[1],n=t[2],r=t[3];if(vi(t.slice(0,2),[n,i])>=vi(t.slice(0,2),[e,r])){var o=(i+r)/2;return[e,o-(n-e)/2,n,o+(n-e)/2]}var s=(e+n)/2;return[s-(r-i)/2,i,s+(r-i)/2,r]}(xi(t)))})),n.load(ei(i))})),ei(i)}function Ci(t,e){var i=[],n=li(t)[0],r=li(t)[t.geometry.coordinates.length-1];if(Pi(n,ai(e))||Pi(r,ai(e)))return ei([t]);var o=(0,yi.default)(),s=fi(t);o.load(s);var a=o.search(e);if(!a.features.length)return ei([t]);var l=Ai(e,a),h=function(t,e,i){var n=i;return di(t,(function(t,r){n=0===r&&void 0===i?t:e(n,t,r)})),n}(s,(function(t,n,r){var o=li(n)[1],s=ai(e);return r===l.id?(t.push(s),i.push(ti(t)),Pi(s,o)?[s]:[s,o]):(t.push(o),t)}),[n]);return h.length>1&&i.push(ti(h)),ei(i)}function Ai(t,e){if(!e.features.length)throw new Error("lines must contain features");if(1===e.features.length)return e.features[0];var i,n=1/0;return di(e,(function(e){var r=Mi(e,t).properties.dist;r<n&&(i=e,n=r)})),i}function Pi(t,e){return t[0]===e[0]&&t[1]===e[1]}var Si=function(t,e){if(!t)throw new Error("line is required");if(!e)throw new Error("splitter is required");var i=ci(t),n=ci(e);if("LineString"!==i)throw new Error("line must be LineString");if("FeatureCollection"===n)throw new Error("splitter cannot be a FeatureCollection");if("GeometryCollection"===n)throw new Error("splitter cannot be a GeometryCollection");var r=function(t,e){void 0===e&&(e={});var i=e.precision,n=e.coordinates,r=e.mutate;if(i=null==i||isNaN(i)?6:i,n=null==n||isNaN(n)?3:n,!t)throw new Error("<geojson> is required");if("number"!=typeof i)throw new Error("<precision> must be a number");if("number"!=typeof n)throw new Error("<coordinates> must be a number");(!1===r||void 0===r)&&(t=JSON.parse(JSON.stringify(t)));var o=Math.pow(10,i);return ui(t,(function(t){!function(t,e,i){t.length>i&&t.splice(i,t.length);for(var n=0;n<t.length;n++)t[n]=Math.round(t[n]*e)/e}(t,o,n)})),t}(e,{precision:7});switch(n){case"Point":return Ci(t,r);case"MultiPoint":return ki(t,r);case"LineString":case"MultiLineString":case"Polygon":case"MultiPolygon":return ki(t,_i(t,r))}};function Ei(t,e,i){if(void 0===i&&(i={}),!t)throw new Error("point is required");if(!e)throw new Error("polygon is required");var n=ai(t),r=hi(e),o=r.type,s=e.bbox,a=r.coordinates;if(s&&!1===function(t,e){return e[0]<=t[0]&&e[1]<=t[1]&&e[2]>=t[0]&&e[3]>=t[1]}(n,s))return!1;"Polygon"===o&&(a=[a]);for(var l=!1,h=0;h<a.length&&!l;h++)if(Ii(n,a[h][0],i.ignoreBoundary)){for(var c=!1,u=1;u<a[h].length&&!c;)Ii(n,a[h][u],!i.ignoreBoundary)&&(c=!0),u++;c||(l=!0)}return l}function Ii(t,e,i){var n=!1;e[0][0]===e[e.length-1][0]&&e[0][1]===e[e.length-1][1]&&(e=e.slice(0,e.length-1));for(var r=0,o=e.length-1;r<e.length;o=r++){var s=e[r][0],a=e[r][1],l=e[o][0],h=e[o][1];if(t[1]*(s-l)+a*(l-t[0])+h*(t[0]-s)==0&&(s-t[0])*(l-t[0])<=0&&(a-t[1])*(h-t[1])<=0)return!i;a>t[1]!=h>t[1]&&t[0]<(l-s)*(t[1]-a)/(h-a)+s&&(n=!n)}return n}function Ti(t,e,i,n,r){var o=i[0],s=i[1],a=t[0],l=t[1],h=e[0],c=e[1],u=h-a,d=c-l,p=(i[0]-a)*d-(i[1]-l)*u;if(null!==r){if(Math.abs(p)>r)return!1}else if(0!==p)return!1;return n?"start"===n?Math.abs(u)>=Math.abs(d)?u>0?a<o&&o<=h:h<=o&&o<a:d>0?l<s&&s<=c:c<=s&&s<l:"end"===n?Math.abs(u)>=Math.abs(d)?u>0?a<=o&&o<h:h<o&&o<=a:d>0?l<=s&&s<c:c<s&&s<=l:"both"===n&&(Math.abs(u)>=Math.abs(d)?u>0?a<o&&o<h:h<o&&o<a:d>0?l<s&&s<c:c<s&&s<l):Math.abs(u)>=Math.abs(d)?u>0?a<=o&&o<=h:h<=o&&o<=a:d>0?l<=s&&s<=c:c<=s&&s<=l}var Di=function(t,e,i){void 0===i&&(i={});for(var n=ai(t),r=li(e),o=0;o<r.length-1;o++){var s=!1;if(i.ignoreEndVertices&&(0===o&&(s="start"),o===r.length-2&&(s="end"),0===o&&o+1===r.length-1&&(s="both")),Ti(r[o],r[o+1],n,s,typeof i.epsilon>"u"?null:i.epsilon))return!0}return!1};function zi(t,e){return!(t[0]>e[0]||t[2]<e[2]||t[1]>e[1]||t[3]<e[3])}function Bi(t,e){return t[0]===e[0]&&t[1]===e[1]}function Oi(t,e){return[(t[0]+e[0])/2,(t[1]+e[1])/2]}var Ri=d(pe()),ji=d(we());function Ni(t){let e={type:"Feature"};return e.geometry=t,e}function Fi(t){return"Feature"===t.type?t.geometry:t}function Gi(t){return t&&t.geometry&&t.geometry.coordinates?t.geometry.coordinates:t}function Ui(t){return Ni({type:"Polygon",coordinates:t})}function Hi(t){return Ni({type:"MultiPolygon",coordinates:t})}function Vi(t){return Array.isArray(t)?1+Vi(t[0]):-1}function Zi(t){t instanceof L.Polyline&&(t=t.toGeoJSON(15));let e=Gi(t),i=Vi(e),n=[];return i>1?e.forEach((t=>{n.push(function(t){return Ni({type:"LineString",coordinates:t})}(t))})):n.push(t),n}Ye.Cut=Ye.Polygon.extend({initialize(t){this._map=t,this._shape="Cut",this.toolbarButtonName="cutPolygon"},_finishShape(){if(this._editedLayers=[],!this.options.allowSelfIntersection&&(this._handleSelfIntersection(!0,this._layer.getLatLngs()[0]),this._doesSelfIntersect)||this.options.requireSnapToFinish&&!this._hintMarker._snapped&&!this._isFirstLayer())return;let t=this._layer.getLatLngs();if(t.length<=2)return;let e=L.polygon(t,this.options.pathOptions);e._latlngInfos=this._layer._latlngInfo,this.cut(e),this._cleanupSnapping(),this._otherSnapLayers.splice(this._tempSnapLayerIndex,1),delete this._tempSnapLayerIndex,this._editedLayers.forEach((({layer:t,originalLayer:e})=>{this._fireCut(e,t,e),this._fireCut(this._map,t,e),e.pm._fireEdit()})),this._editedLayers=[],this.disable(),this.options.continueDrawing&&this.enable()},cut(t){let e=this._map._layers,i=t._latlngInfos||[];Object.keys(e).map((t=>e[t])).filter((t=>t.pm)).filter((t=>!t._pmTempLayer)).filter((t=>!L.PM.optIn&&!t.options.pmIgnore||L.PM.optIn&&!1===t.options.pmIgnore)).filter((t=>t instanceof L.Polyline)).filter((e=>e!==t)).filter((t=>t.pm.options.allowCutting)).filter((t=>!(this.options.layersToCut&&L.Util.isArray(this.options.layersToCut)&&this.options.layersToCut.length>0)||this.options.layersToCut.indexOf(t)>-1)).filter((t=>!this._layerGroup.hasLayer(t))).filter((e=>{try{let i=!!_i(t.toGeoJSON(15),e.toGeoJSON(15)).features.length>0;return i||e instanceof L.Polyline&&!(e instanceof L.Polygon)?i:!!function(t,e){let i=Fi(t),n=Fi(e),r=ji.default.intersection(i.coordinates,n.coordinates);return 0===r.length?null:1===r.length?Ui(r[0]):Hi(r)}(t.toGeoJSON(15),e.toGeoJSON(15))}catch{return e instanceof L.Polygon&&console.error("You can't cut polygons with self-intersections"),!1}})).forEach((e=>{let n;if(e instanceof L.Polygon){n=L.polygon(e.getLatLngs());let t=n.getLatLngs();i.forEach((e=>{if(e&&e.snapInfo){let{latlng:i}=e,r=this._calcClosestLayer(i,[n]);if(r&&r.segment&&r.distance<this.options.snapDistance){let{segment:e}=r;if(e&&2===e.length){let{indexPath:n,parentPath:r,newIndex:o}=L.PM.Utils._getIndexFromSegment(t,e);(n.length>1?(0,Ri.default)(t,r):t).splice(o,0,i)}}}}))}else n=e;let r=this._cutLayer(t,n),o=L.geoJSON(r,e.options);1===o.getLayers().length&&([o]=o.getLayers()),this._setPane(o,"layerPane");let s=o.addTo(this._map.pm._getContainingLayer());if(s.pm.enable(e.pm.options),s.pm.disable(),e._pmTempLayer=!0,t._pmTempLayer=!0,e.remove(),e.removeFrom(this._map.pm._getContainingLayer()),t.remove(),t.removeFrom(this._map.pm._getContainingLayer()),s.getLayers&&0===s.getLayers().length&&this._map.pm.removeLayer({target:s}),s instanceof L.LayerGroup?(s.eachLayer((t=>{this._addDrawnLayerProp(t)})),this._addDrawnLayerProp(s)):this._addDrawnLayerProp(s),this.options.layersToCut&&L.Util.isArray(this.options.layersToCut)&&this.options.layersToCut.length>0){let t=this.options.layersToCut.indexOf(e);t>-1&&this.options.layersToCut.splice(t,1)}this._editedLayers.push({layer:s,originalLayer:e})}))},_cutLayer(t,e){let i,n=L.geoJSON();if(e instanceof L.Polygon)i=function(t,e){let i=Fi(t),n=Fi(e),r=ji.default.difference(i.coordinates,n.coordinates);return 0===r.length?null:1===r.length?Ui(r[0]):Hi(r)}(e.toGeoJSON(15),t.toGeoJSON(15));else{let r=Zi(e);r.forEach((e=>{let i,r=Si(e,t.toGeoJSON(15));i=r&&r.features.length>0?L.geoJSON(r):L.geoJSON(e),i.getLayers().forEach((e=>{(function(t,e){var i=hi(t),n=hi(e),r=i.type,o=n.type,s=i.coordinates,a=n.coordinates;switch(r){case"Point":if("Point"===o)return Bi(s,a);throw new Error("feature2 "+o+" geometry not supported");case"MultiPoint":switch(o){case"Point":return function(t,e){var i,n=!1;for(i=0;i<t.coordinates.length;i++)if(Bi(t.coordinates[i],e.coordinates)){n=!0;break}return n}(i,n);case"MultiPoint":return function(t,e){for(var i=0,n=e.coordinates;i<n.length;i++){for(var r=n[i],o=!1,s=0,a=t.coordinates;s<a.length;s++)if(Bi(r,a[s])){o=!0;break}if(!o)return!1}return!0}(i,n);default:throw new Error("feature2 "+o+" geometry not supported")}case"LineString":switch(o){case"Point":return Di(n,i,{ignoreEndVertices:!0});case"LineString":return function(t,e){for(var i=!1,n=0,r=e.coordinates;n<r.length;n++){var o=r[n];if(Di({type:"Point",coordinates:o},t,{ignoreEndVertices:!0})&&(i=!0),!Di({type:"Point",coordinates:o},t,{ignoreEndVertices:!1}))return!1}return i}(i,n);case"MultiPoint":return function(t,e){for(var i=!1,n=0,r=e.coordinates;n<r.length;n++){var o=r[n];if(Di(o,t,{ignoreEndVertices:!0})&&(i=!0),!Di(o,t))return!1}return!!i}(i,n);default:throw new Error("feature2 "+o+" geometry not supported")}case"Polygon":switch(o){case"Point":return Ei(n,i,{ignoreBoundary:!0});case"LineString":return function(t,e){var i=!1,n=0;if(!zi(xi(t),xi(e)))return!1;for(;n<e.coordinates.length-1;n++)if(Ei({type:"Point",coordinates:Oi(e.coordinates[n],e.coordinates[n+1])},t,{ignoreBoundary:!0})){i=!0;break}return i}(i,n);case"Polygon":return function(t,e){if("Feature"===t.type&&null===t.geometry||"Feature"===e.type&&null===e.geometry)return!1;if(!zi(xi(t),xi(e)))return!1;for(var i=0,n=hi(e).coordinates;i<n.length;i++)for(var r=0,o=n[i];r<o.length;r++)if(!Ei(o[r],t))return!1;return!0}(i,n);case"MultiPoint":return function(t,e){for(var i=0,n=e.coordinates;i<n.length;i++)if(!Ei(n[i],t,{ignoreBoundary:!0}))return!1;return!0}(i,n);default:throw new Error("feature2 "+o+" geometry not supported")}default:throw new Error("feature1 "+r+" geometry not supported")}})(t.toGeoJSON(15),e.toGeoJSON(15))||e.addTo(n)}))})),i=r.length>1?function(t){let e=[];return t.eachLayer((t=>{e.push(Gi(t.toGeoJSON(15)))})),function(t){return Ni({type:"MultiLineString",coordinates:t})}(e)}(n):n.toGeoJSON(15)}return i},_change:L.Util.falseFn}),Ye.Text=Ye.extend({initialize(t){this._map=t,this._shape="Text",this.toolbarButtonName="drawText"},enable(t){L.Util.setOptions(this,t),this._enabled=!0,this._map.on("click",this._createMarker,this),this._map.pm.Toolbar.toggleButton(this.toolbarButtonName,!0),this._hintMarker=L.marker(this._map.getCenter(),{interactive:!1,zIndexOffset:100,icon:L.divIcon({className:"marker-icon cursor-marker"})}),this._setPane(this._hintMarker,"vertexPane"),this._hintMarker._pmTempLayer=!0,this._hintMarker.addTo(this._map),this.options.cursorMarker&&L.DomUtil.addClass(this._hintMarker._icon,"visible"),this.options.tooltips&&this._hintMarker.bindTooltip(ze("tooltips.placeText"),{permanent:!0,offset:L.point(0,10),direction:"bottom",opacity:.8}).openTooltip(),this._layer=this._hintMarker,this._map.on("mousemove",this._syncHintMarker,this),this._map.getContainer().classList.add("geoman-draw-cursor"),this._fireDrawStart(),this._setGlobalDrawMode()},disable(){this._enabled&&(this._enabled=!1,this._map.off("click",this._createMarker,this),this._hintMarker?.remove(),this._map.getContainer().classList.remove("geoman-draw-cursor"),this._map.off("mousemove",this._syncHintMarker,this),this._map.pm.Toolbar.toggleButton(this.toolbarButtonName,!1),this.options.snappable&&this._cleanupSnapping(),this._fireDrawEnd(),this._setGlobalDrawMode())},enabled(){return this._enabled},toggle(t){this.enabled()?this.disable():this.enable(t)},_syncHintMarker(t){if(this._hintMarker.setLatLng(t.latlng),this.options.snappable){let e=t;e.target=this._hintMarker,this._handleSnapping(e)}},_createMarker(t){if(!t.latlng||this.options.requireSnapToFinish&&!this._hintMarker._snapped&&!this._isFirstLayer())return;this._hintMarker._snapped||this._hintMarker.setLatLng(t.latlng);let e=this._hintMarker.getLatLng();if(this.textArea=this._createTextArea(),this.options.textOptions?.className){let t=this.options.textOptions.className.split(" ");this.textArea.classList.add(...t)}let i=this._createTextIcon(this.textArea),n=new L.Marker(e,{textMarker:!0,_textMarkerOverPM:!0,icon:i});if(this._setPane(n,"markerPane"),this._finishLayer(n),n.pm||(n.options.draggable=!1),n.addTo(this._map.pm._getContainingLayer()),n.pm){n.pm.textArea=this.textArea,L.setOptions(n.pm,{removeIfEmpty:this.options.textOptions?.removeIfEmpty??!0});let t=this.options.textOptions?.focusAfterDraw??!0;n.pm._createTextMarker(t),this.options.textOptions?.text&&n.pm.setText(this.options.textOptions.text)}this._fireCreate(n),this._cleanupSnapping(),this.disable(),this.options.continueDrawing&&this.enable()},_createTextArea(){let t=document.createElement("textarea");return t.readOnly=!0,t.classList.add("pm-textarea","pm-disabled"),t},_createTextIcon:t=>L.divIcon({className:"pm-text-marker",html:t})});var qi={enableLayerDrag(){if(!this.options.draggable||!this._layer._map)return;this.disable(),this._layerDragEnabled=!0,this._map||(this._map=this._layer._map),(this._layer instanceof L.Marker||this._layer instanceof L.ImageOverlay)&&L.DomEvent.on(this._getDOMElem(),"dragstart",this._stopDOMImageDrag),this._layer.dragging&&this._layer.dragging.disable(),this._tempDragCoord=null,He(this._layer)instanceof L.Canvas?(this._layer.on("mouseout",this.removeDraggingClass,this),this._layer.on("mouseover",this.addDraggingClass,this)):this.addDraggingClass(),this._originalMapDragState=this._layer._map.dragging._enabled,this._safeToCacheDragState=!0;let t=this._getDOMElem();t&&(He(this._layer)instanceof L.Canvas?(this._layer.on("touchstart mousedown",this._dragMixinOnMouseDown,this),this._map.pm._addTouchEvents(t)):L.DomEvent.on(t,"touchstart mousedown",this._simulateMouseDownEvent,this)),this._fireDragEnable()},disableLayerDrag(){this._layerDragEnabled=!1,He(this._layer)instanceof L.Canvas?(this._layer.off("mouseout",this.removeDraggingClass,this),this._layer.off("mouseover",this.addDraggingClass,this)):this.removeDraggingClass(),this._originalMapDragState&&this._dragging&&this._map.dragging.enable(),this._safeToCacheDragState=!1,this._layer.dragging&&this._layer.dragging.disable();let t=this._getDOMElem();t&&(He(this._layer)instanceof L.Canvas?(this._layer.off("touchstart mousedown",this._dragMixinOnMouseDown,this),this._map.pm._removeTouchEvents(t)):L.DomEvent.off(t,"touchstart mousedown",this._simulateMouseDownEvent,this)),this._layerDragged&&this._fireUpdate(),this._layerDragged=!1,this._fireDragDisable()},dragging(){return this._dragging},layerDragEnabled(){return!!this._layerDragEnabled},_simulateMouseDownEvent(t){let e=t.touches?t.touches[0]:t,i={originalEvent:e,target:this._layer};return i.containerPoint=this._map.mouseEventToContainerPoint(e),i.latlng=this._map.containerPointToLatLng(i.containerPoint),this._dragMixinOnMouseDown(i),!1},_simulateMouseMoveEvent(t){let e=t.touches?t.touches[0]:t,i={originalEvent:e,target:this._layer};return i.containerPoint=this._map.mouseEventToContainerPoint(e),i.latlng=this._map.containerPointToLatLng(i.containerPoint),this._dragMixinOnMouseMove(i),!1},_simulateMouseUpEvent(t){let e={originalEvent:t.touches?t.touches[0]:t,target:this._layer};return-1===t.type.indexOf("touch")&&(e.containerPoint=this._map.mouseEventToContainerPoint(t),e.latlng=this._map.containerPointToLatLng(e.containerPoint)),this._dragMixinOnMouseUp(e),!1},_dragMixinOnMouseDown(t){if(t.originalEvent.button>0)return;this._overwriteEventIfItComesFromMarker(t);let e=t._fromLayerSync,i=this._syncLayers("_dragMixinOnMouseDown",t);if(this._layer instanceof L.Marker&&(!this.options.snappable||e||i?this._disableSnapping():this._initSnappableMarkers()),this._layer instanceof L.CircleMarker){let t="resizeableCircleMarker";this._layer instanceof L.Circle&&(t="resizableCircle"),!this.options.snappable||e||i?this._layer.pm.options[t]?this._layer.pm._disableSnapping():this._layer.pm._disableSnappingDrag():this._layer.pm.options[t]||this._initSnappableMarkersDrag()}this._safeToCacheDragState&&(this._originalMapDragState=this._layer._map.dragging._enabled,this._safeToCacheDragState=!1),this._tempDragCoord=t.latlng,L.DomEvent.on(this._map.getContainer(),"touchend mouseup",this._simulateMouseUpEvent,this),L.DomEvent.on(this._map.getContainer(),"touchmove mousemove",this._simulateMouseMoveEvent,this)},_dragMixinOnMouseMove(t){this._overwriteEventIfItComesFromMarker(t);let e=this._getDOMElem();this._syncLayers("_dragMixinOnMouseMove",t),this._dragging||(this._dragging=!0,L.DomUtil.addClass(e,"leaflet-pm-dragging"),this._layer instanceof L.Marker||this._layer.bringToFront(),this._originalMapDragState&&this._map.dragging.disable(),this._fireDragStart()),this._tempDragCoord||(this._tempDragCoord=t.latlng),this._onLayerDrag(t),this._layer instanceof L.CircleMarker&&this._layer.pm._updateHiddenPolyCircle()},_dragMixinOnMouseUp(t){let e=this._getDOMElem();return this._syncLayers("_dragMixinOnMouseUp",t),this._originalMapDragState&&this._map.dragging.enable(),this._safeToCacheDragState=!0,L.DomEvent.off(this._map.getContainer(),"touchmove mousemove",this._simulateMouseMoveEvent,this),L.DomEvent.off(this._map.getContainer(),"touchend mouseup",this._simulateMouseUpEvent,this),!!this._dragging&&(this._layer instanceof L.CircleMarker&&this._layer.pm._updateHiddenPolyCircle(),this._layerDragged=!0,window.setTimeout((()=>{this._dragging=!1,e&&L.DomUtil.removeClass(e,"leaflet-pm-dragging"),this._fireDragEnd(),this._fireEdit(),this._layerEdited=!0}),10),!0)},_onLayerDrag(t){let{latlng:e}=t,i=e.lat-this._tempDragCoord.lat,n=e.lng-this._tempDragCoord.lng,r=t=>t.map((t=>{if(Array.isArray(t))return r(t);let e={lat:t.lat+i,lng:t.lng+n};return(t.alt||0===t.alt)&&(e.alt=t.alt),e}));if(this._layer instanceof L.Circle&&this._layer.options.resizableCircle||this._layer instanceof L.CircleMarker&&this._layer.options.resizeableCircleMarker){let t=r([this._layer.getLatLng()]);this._layer.setLatLng(t[0]),this._fireChange(this._layer.getLatLng(),"Edit")}else if(this._layer instanceof L.CircleMarker||this._layer instanceof L.Marker){let t=this._layer.getLatLng();this._layer._snapped&&(t=this._layer._orgLatLng);let e=r([t]);this._layer.setLatLng(e[0]),this._fireChange(this._layer.getLatLng(),"Edit")}else if(this._layer instanceof L.ImageOverlay){let t=r([this._layer.getBounds().getNorthWest(),this._layer.getBounds().getSouthEast()]);this._layer.setBounds(t),this._fireChange(this._layer.getBounds(),"Edit")}else{let t=r(this._layer.getLatLngs());this._layer.setLatLngs(t),this._fireChange(this._layer.getLatLngs(),"Edit")}this._tempDragCoord=e,t.layer=this._layer,this._fireDrag(t)},addDraggingClass(){let t=this._getDOMElem();t&&L.DomUtil.addClass(t,"leaflet-pm-draggable")},removeDraggingClass(){let t=this._getDOMElem();t&&L.DomUtil.removeClass(t,"leaflet-pm-draggable")},_getDOMElem(){let t=null;return this._layer._path?t=this._layer._path:this._layer._renderer&&this._layer._renderer._container?t=this._layer._renderer._container:this._layer._image?t=this._layer._image:this._layer._icon&&(t=this._layer._icon),t},_overwriteEventIfItComesFromMarker(t){t.target.getLatLng&&(!t.target._radius||t.target._radius<=10)&&(t.containerPoint=this._map.mouseEventToContainerPoint(t.originalEvent),t.latlng=this._map.containerPointToLatLng(t.containerPoint))},_syncLayers(t,e){if(this.enabled())return!1;if(!e._fromLayerSync&&this._layer===e.target&&this.options.syncLayersOnDrag){e._fromLayerSync=!0;let i=[];if(L.Util.isArray(this.options.syncLayersOnDrag))i=this.options.syncLayersOnDrag,this.options.syncLayersOnDrag.forEach((t=>{t instanceof L.LayerGroup&&(i=i.concat(t.pm.getLayers(!0)))}));else if(!0===this.options.syncLayersOnDrag&&this._parentLayerGroup)for(let t in this._parentLayerGroup){let e=this._parentLayerGroup[t];e.pm&&(i=e.pm.getLayers(!0))}return L.Util.isArray(i)&&i.length>0&&(i=i.filter((t=>!!t.pm)).filter((t=>!!t.pm.options.draggable)),i.forEach((i=>{i!==this._layer&&i.pm[t]&&(i._snapped=!1,i.pm[t](e))}))),i.length>0}return!1},_stopDOMImageDrag:t=>(t.preventDefault(),!1)},Wi=d(pe());function Ki(t,e,i){let n=i.getMaxZoom();if(n===1/0&&(n=i.getZoom()),L.Util.isArray(t)){let n=[];return t.forEach((t=>{n.push(Ki(t,e,i))})),n}return t instanceof L.LatLng?function(t,e,i,n){return i.unproject(e.transform(i.project(t,n)),n)}(t,e,i,n):null}function Yi(t,e){e instanceof L.Layer&&(e=e.getLatLng());let i=t.getMaxZoom();return i===1/0&&(i=t.getZoom()),t.project(e,i)}function Xi(t,e){let i=t.getMaxZoom();return i===1/0&&(i=t.getZoom()),t.unproject(e,i)}var Ji={_onRotateStart(t){this._preventRenderingMarkers(!0),this._rotationOriginLatLng=this._getRotationCenter().clone(),this._rotationOriginPoint=Yi(this._map,this._rotationOriginLatLng),this._rotationStartPoint=Yi(this._map,t.target.getLatLng()),this._initialRotateLatLng=Ge(this._layer),this._startAngle=this.getAngle();let e=Ge(this._rotationLayer,this._rotationLayer.pm._rotateOrgLatLng);this._fireRotationStart(this._rotationLayer,e),this._fireRotationStart(this._map,e)},_onRotate(t){let e=Yi(this._map,t.target.getLatLng()),i=this._rotationStartPoint,n=this._rotationOriginPoint,r=Math.atan2(e.y-n.y,e.x-n.x)-Math.atan2(i.y-n.y,i.x-n.x);this._layer.setLatLngs(this._rotateLayer(r,this._initialRotateLatLng,this._rotationOriginLatLng,L.PM.Matrix.init(),this._map));let o=this;!function t(e,i=[],n=-1){if(n>-1&&i.push(n),L.Util.isArray(e[0]))e.forEach(((e,n)=>t(e,i.slice(),n)));else{let t=(0,Wi.default)(o._markers,i);e.forEach(((e,i)=>{t[i].setLatLng(e)}))}}(this._layer.getLatLngs());let s=Ge(this._rotationLayer);this._rotationLayer.setLatLngs(this._rotateLayer(r,this._rotationLayer.pm._rotateOrgLatLng,this._rotationOriginLatLng,L.PM.Matrix.init(),this._map));let a=180*r/Math.PI;a=a<0?a+360:a;let l=a+this._startAngle;this._setAngle(l),this._rotationLayer.pm._setAngle(l),this._fireRotation(this._rotationLayer,a,s),this._fireRotation(this._map,a,s),this._rotationLayer.pm._fireChange(this._rotationLayer.getLatLngs(),"Rotation")},_onRotateEnd(){let t=this._startAngle;delete this._rotationOriginLatLng,delete this._rotationOriginPoint,delete this._rotationStartPoint,delete this._initialRotateLatLng,delete this._startAngle;let e=Ge(this._rotationLayer,this._rotationLayer.pm._rotateOrgLatLng);this._rotationLayer.pm._rotateOrgLatLng=Ge(this._rotationLayer),this._fireRotationEnd(this._rotationLayer,t,e),this._fireRotationEnd(this._map,t,e),this._rotationLayer.pm._fireEdit(this._rotationLayer,"Rotation"),this._preventRenderingMarkers(!1),this._layerRotated=!0},_rotateLayer(t,e,i,n,r){let o=Yi(r,i);return this._matrix=n.clone().rotate(t,o).flip(),Ki(e,this._matrix,r)},_setAngle(t){t=t<0?t+360:t,this._angle=t%360},_getRotationCenter(){if(this._rotationCenter)return this._rotationCenter;let t=L.polygon(this._layer.getLatLngs(),{stroke:!1,fill:!1,pmIgnore:!0}).addTo(this._layer._map),e=t.getCenter();return t.removeFrom(this._layer._map),e},enableRotate(){this.options.allowRotation?(this.rotateEnabled()&&this.disableRotate(),this._layer instanceof L.Rectangle&&void 0===this._angle&&this.setInitAngle(Ne(this._layer._map,this._layer.getLatLngs()[0][0],this._layer.getLatLngs()[0][1])||0),this._rotatePoly=L.polygon(this._layer.getLatLngs(),{fill:!1,stroke:!1,pmIgnore:!1,snapIgnore:!0}),this._rotatePoly._pmTempLayer=!0,this._rotatePoly.addTo(this._layer._map),this._rotatePoly.pm._setAngle(this.getAngle()),this._rotatePoly.pm.setRotationCenter(this.getRotationCenter()),this._rotatePoly.pm.setOptions(this._layer._map.pm.getGlobalOptions()),this._rotatePoly.pm.setOptions({rotate:!0,snappable:!1,hideMiddleMarkers:!0}),this._rotatePoly.pm._rotationLayer=this._layer,this._rotatePoly.pm.enable(),this._rotateOrgLatLng=Ge(this._layer),this._rotateEnabled=!0,this._layer.on("remove",this.disableRotate,this),this._fireRotationEnable(this._layer),this._fireRotationEnable(this._layer._map)):this.disableRotate()},disableRotate(){this.rotateEnabled()&&(this._rotatePoly.pm._layerRotated&&this._fireUpdate(),this._rotatePoly.pm._layerRotated=!1,this._rotatePoly.pm.disable(),this._rotatePoly.remove(),this._rotatePoly.pm.setOptions({rotate:!1}),this._rotatePoly=void 0,this._rotateOrgLatLng=void 0,this._layer.off("remove",this.disableRotate,this),this._rotateEnabled=!1,this._fireRotationDisable(this._layer),this._fireRotationDisable(this._layer._map))},rotateEnabled(){return!!this._rotateEnabled},rotateLayer(t){let e=this.getAngle(),i=this._layer.getLatLngs(),n=t*(Math.PI/180);this._layer.setLatLngs(this._rotateLayer(n,this._layer.getLatLngs(),this._getRotationCenter(),L.PM.Matrix.init(),this._layer._map)),this._rotateOrgLatLng=L.polygon(this._layer.getLatLngs()).getLatLngs(),this._setAngle(this.getAngle()+t),this.rotateEnabled()&&this._rotatePoly&&this._rotatePoly.pm.enabled()&&(this._rotatePoly.setLatLngs(this._rotateLayer(n,this._rotatePoly.getLatLngs(),this._getRotationCenter(),L.PM.Matrix.init(),this._rotatePoly._map)),this._rotatePoly.pm._initMarkers());let r=this.getAngle()-e;r=r<0?r+360:r,this._startAngle=e,this._fireRotation(this._layer,r,i,this._layer),this._fireRotation(this._map||this._layer._map,r,i,this._layer),delete this._startAngle,this._fireChange(this._layer.getLatLngs(),"Rotation")},rotateLayerToAngle(t){let e=t-this.getAngle();this.rotateLayer(e)},getAngle(){return this._angle||0},setInitAngle(t){this._setAngle(t)},getRotationCenter(){return this._getRotationCenter()},setRotationCenter(t){this._rotationCenter=t,this._rotatePoly&&this._rotatePoly.pm.setRotationCenter(t)}},Qi=L.Class.extend({includes:[qi,Ke,Ji,Ee],options:{snappable:!0,snapDistance:20,allowSelfIntersection:!0,allowSelfIntersectionEdit:!1,preventMarkerRemoval:!1,removeLayerBelowMinVertexCount:!0,limitMarkersToCount:-1,hideMiddleMarkers:!1,snapSegment:!0,syncLayersOnDrag:!1,draggable:!0,allowEditing:!0,allowRemoval:!0,allowCutting:!0,allowRotation:!0,addVertexOn:"click",removeVertexOn:"contextmenu",removeVertexValidation:void 0,addVertexValidation:void 0,moveVertexValidation:void 0,resizeableCircleMarker:!1,resizableCircle:!0},setOptions(t){L.Util.setOptions(this,t)},getOptions(){return this.options},applyOptions(){},isPolygon(){return this._layer instanceof L.Polygon},getShape(){return this._shape},_setPane(t,e){"layerPane"===e?t.options.pane=this._map.pm.globalOptions.panes&&this._map.pm.globalOptions.panes.layerPane||"overlayPane":"vertexPane"===e?t.options.pane=this._map.pm.globalOptions.panes&&this._map.pm.globalOptions.panes.vertexPane||"markerPane":"markerPane"===e&&(t.options.pane=this._map.pm.globalOptions.panes&&this._map.pm.globalOptions.panes.markerPane||"markerPane")},remove(){(this._map||this._layer._map).pm.removeLayer({target:this._layer})},_vertexValidation(t,e){let i=e.target,n={layer:this._layer,marker:i,event:e},r="";return"move"===t?r="moveVertexValidation":"add"===t?r="addVertexValidation":"remove"===t&&(r="removeVertexValidation"),this.options[r]&&"function"==typeof this.options[r]&&!this.options[r](n)?("move"===t&&(i._cancelDragEventChain=i.getLatLng()),!1):(i._cancelDragEventChain=null,!0)},_vertexValidationDrag:t=>!t._cancelDragEventChain||(t._latlng=t._cancelDragEventChain,t.update(),!1),_vertexValidationDragEnd:t=>!t._cancelDragEventChain||(t._cancelDragEventChain=null,!1)});Qi.LayerGroup=L.Class.extend({initialize(t){this._layerGroup=t,this._layers=this.getLayers(),this._getMap(),this._layers.forEach((t=>this._initLayer(t))),this._layerGroup.on("layeradd",L.Util.throttle((t=>{if(t.layer._pmTempLayer)return;this._layers=this.getLayers();let e=this._layers.filter((t=>!t.pm._parentLayerGroup||!(this._layerGroup._leaflet_id in t.pm._parentLayerGroup)));e.forEach((t=>{this._initLayer(t)})),e.length>0&&this._getMap()&&this._getMap().pm.globalEditModeEnabled()&&this.enabled()&&this.enable(this.getOptions())}),100,this),this),this._layerGroup.on("layerremove",(t=>{this._removeLayerFromGroup(t.target)}),this),this._layerGroup.on("layerremove",L.Util.throttle((t=>{t.target._pmTempLayer||(this._layers=this.getLayers())}),100,this),this)},enable(t,e=[]){0===e.length&&(this._layers=this.getLayers()),this._options=t,this._layers.forEach((i=>{i instanceof L.LayerGroup?-1===e.indexOf(i._leaflet_id)&&(e.push(i._leaflet_id),i.pm.enable(t,e)):i.pm.enable(t)}))},disable(t=[]){0===t.length&&(this._layers=this.getLayers()),this._layers.forEach((e=>{e instanceof L.LayerGroup?-1===t.indexOf(e._leaflet_id)&&(t.push(e._leaflet_id),e.pm.disable(t)):e.pm.disable()}))},enabled(t=[]){return 0===t.length&&(this._layers=this.getLayers()),!!this._layers.find((e=>e instanceof L.LayerGroup?-1===t.indexOf(e._leaflet_id)&&(t.push(e._leaflet_id),e.pm.enabled(t)):e.pm.enabled()))},toggleEdit(t,e=[]){0===e.length&&(this._layers=this.getLayers()),this._options=t,this._layers.forEach((i=>{i instanceof L.LayerGroup?-1===e.indexOf(i._leaflet_id)&&(e.push(i._leaflet_id),i.pm.toggleEdit(t,e)):i.pm.toggleEdit(t)}))},_initLayer(t){let e=L.Util.stamp(this._layerGroup);t.pm._parentLayerGroup||(t.pm._parentLayerGroup={}),t.pm._parentLayerGroup[e]=this._layerGroup},_removeLayerFromGroup(t){if(t.pm&&t.pm._layerGroup){let e=L.Util.stamp(this._layerGroup);delete t.pm._layerGroup[e]}},dragging(){return this._layers=this.getLayers(),!!this._layers&&!!this._layers.find((t=>t.pm.dragging()))},getOptions(){return this.options},_getMap(){return this._map||this._layers.find((t=>!!t._map))?._map||null},getLayers(t=!1,e=!0,i=!0,n=[]){let r=[];return t?this._layerGroup.getLayers().forEach((t=>{r.push(t),t instanceof L.LayerGroup&&-1===n.indexOf(t._leaflet_id)&&(n.push(t._leaflet_id),r=r.concat(t.pm.getLayers(!0,!0,!0,n)))})):r=this._layerGroup.getLayers(),i&&(r=r.filter((t=>!(t instanceof L.LayerGroup)))),e&&(r=r.filter((t=>!!t.pm)),r=r.filter((t=>!t._pmTempLayer)),r=r.filter((t=>!L.PM.optIn&&!t.options.pmIgnore||L.PM.optIn&&!1===t.options.pmIgnore))),r},setOptions(t,e=[]){0===e.length&&(this._layers=this.getLayers()),this.options=t,this._layers.forEach((i=>{i.pm&&(i instanceof L.LayerGroup?-1===e.indexOf(i._leaflet_id)&&(e.push(i._leaflet_id),i.pm.setOptions(t,e)):i.pm.setOptions(t))}))}}),Qi.Marker=Qi.extend({_shape:"Marker",initialize(t){this._layer=t,this._enabled=!1,this._layer.on("dragend",this._onDragEnd,this)},enable(t={draggable:!0}){L.Util.setOptions(this,t),this.options.allowEditing&&this._layer._map?(this._map=this._layer._map,this.enabled()&&this.disable(),this.applyOptions(),this._layer.on("remove",this.disable,this),this._enabled=!0,this._fireEnable()):this.disable()},disable(){this.enabled()&&(this.disableLayerDrag(),this._layer.off("remove",this.disable,this),this._layer.off("contextmenu",this._removeMarker,this),this._layerEdited&&this._fireUpdate(),this._layerEdited=!1,this._fireDisable(),this._enabled=!1)},enabled(){return this._enabled},toggleEdit(t){this.enabled()?this.disable():this.enable(t)},applyOptions(){this.options.snappable?this._initSnappableMarkers():this._disableSnapping(),this.options.draggable?this.enableLayerDrag():this.disableLayerDrag(),this.options.preventMarkerRemoval||this._layer.on("contextmenu",this._removeMarker,this)},_removeMarker(t){let e=t.target;e.remove(),this._fireRemove(e),this._fireRemove(this._map,e)},_onDragEnd(){this._fireEdit(),this._layerEdited=!0},_initSnappableMarkers(){let t=this._layer;this.options.snapDistance=this.options.snapDistance||30,this.options.snapSegment=void 0===this.options.snapSegment||this.options.snapSegment,t.off("pm:drag",this._handleSnapping,this),t.on("pm:drag",this._handleSnapping,this),t.off("pm:dragend",this._cleanupSnapping,this),t.on("pm:dragend",this._cleanupSnapping,this),t.off("pm:dragstart",this._unsnap,this),t.on("pm:dragstart",this._unsnap,this)},_disableSnapping(){let t=this._layer;t.off("pm:drag",this._handleSnapping,this),t.off("pm:dragend",this._cleanupSnapping,this),t.off("pm:dragstart",this._unsnap,this)}});var $i=d(pe()),tn={filterMarkerGroup(){this.markerCache=[],this.createCache(),this._layer.on("pm:edit",this.createCache,this),this.applyLimitFilters({}),this.throttledApplyLimitFilters||(this.throttledApplyLimitFilters=L.Util.throttle(this.applyLimitFilters,100,this)),this._layer.on("pm:disable",this._removeMarkerLimitEvents,this),this.options.limitMarkersToCount>-1&&(this._layer.on("pm:vertexremoved",this._initMarkers,this),this._map.on("mousemove",this.throttledApplyLimitFilters,this))},_removeMarkerLimitEvents(){this._map.off("mousemove",this.throttledApplyLimitFilters,this),this._layer.off("pm:edit",this.createCache,this),this._layer.off("pm:disable",this._removeMarkerLimitEvents,this),this._layer.off("pm:vertexremoved",this._initMarkers,this)},createCache(){let t=[...this._markerGroup.getLayers(),...this.markerCache];this.markerCache=t.filter(((t,e,i)=>i.indexOf(t)===e))},renderLimits(t){this.markerCache.forEach((e=>{t.includes(e)?this._markerGroup.addLayer(e):this._markerGroup.removeLayer(e)}))},applyLimitFilters({latlng:t={lat:0,lng:0}}){if(this._preventRenderMarkers)return;let e=[...this._filterClosestMarkers(t)];this.renderLimits(e)},_filterClosestMarkers(t){let e=[...this.markerCache],i=this.options.limitMarkersToCount;return-1===i?e:(e.sort(((e,i)=>e._latlng.distanceTo(t)-i._latlng.distanceTo(t))),e.filter(((t,e)=>!(i>-1)||e<i)))},_preventRenderMarkers:!1,_preventRenderingMarkers(t){this._preventRenderMarkers=!!t}};Qi.Line=Qi.extend({includes:[tn],_shape:"Line",initialize(t){this._layer=t,this._enabled=!1},enable(t){if(L.Util.setOptions(this,t),this._map=this._layer._map,this._map){if(!this.options.allowEditing)return void this.disable();this.enabled()&&this.disable(),this._enabled=!0,this._initMarkers(),this.applyOptions(),this._layer.on("remove",this.disable,this),this.options.allowSelfIntersection||this._layer.on("pm:vertexremoved",this._handleSelfIntersectionOnVertexRemoval,this),this.options.allowSelfIntersection?this.cachedColor=void 0:("#f00000ff"!==this._layer.options.color?(this.cachedColor=this._layer.options.color,this.isRed=!1):this.isRed=!0,this._handleLayerStyle()),this._fireEnable()}},disable(){if(!this.enabled()||this._dragging)return;this._enabled=!1,this._markerGroup.clearLayers(),this._markerGroup.removeFrom(this._map),this._layer.off("remove",this.disable,this),this.options.allowSelfIntersection||this._layer.off("pm:vertexremoved",this._handleSelfIntersectionOnVertexRemoval,this);let t=this._layer._path?this._layer._path:this._layer._renderer._container;L.DomUtil.removeClass(t,"leaflet-pm-draggable"),this._layerEdited&&this._fireUpdate(),this._layerEdited=!1,this._fireDisable()},enabled(){return this._enabled},toggleEdit(t){return this.enabled()?this.disable():this.enable(t),this.enabled()},applyOptions(){this.options.snappable?this._initSnappableMarkers():this._disableSnapping()},_initMarkers(){let t=this._map,e=this._layer.getLatLngs();this._markerGroup&&this._markerGroup.clearLayers(),this._markerGroup=new L.FeatureGroup,this._markerGroup._pmTempLayer=!0;let i=t=>{if(Array.isArray(t[0]))return t.map(i,this);let e=t.map(this._createMarker,this);return!0!==this.options.hideMiddleMarkers&&t.map(((i,n)=>{let r=this.isPolygon()?(n+1)%t.length:n+1;return this._createMiddleMarker(e[n],e[r])})),e};this._markers=i(e),this.filterMarkerGroup(),t.addLayer(this._markerGroup)},_createMarker(t){let e=new L.Marker(t,{draggable:!0,icon:L.divIcon({className:"marker-icon"})});return this._setPane(e,"vertexPane"),e._pmTempLayer=!0,this.options.rotate?(e.on("dragstart",this._onRotateStart,this),e.on("drag",this._onRotate,this),e.on("dragend",this._onRotateEnd,this)):(e.on("click",this._onVertexClick,this),e.on("dragstart",this._onMarkerDragStart,this),e.on("move",this._onMarkerDrag,this),e.on("dragend",this._onMarkerDragEnd,this),this.options.preventMarkerRemoval||e.on(this.options.removeVertexOn,this._removeMarker,this)),this._markerGroup.addLayer(e),e},_createMiddleMarker(t,e){if(!t||!e)return!1;let i=L.PM.Utils.calcMiddleLatLng(this._map,t.getLatLng(),e.getLatLng()),n=this._createMarker(i),r=L.divIcon({className:"marker-icon marker-icon-middle"});return n.setIcon(r),n.leftM=t,n.rightM=e,t._middleMarkerNext=n,e._middleMarkerPrev=n,n.on(this.options.addVertexOn,this._onMiddleMarkerClick,this),n.on("movestart",this._onMiddleMarkerMoveStart,this),n},_onMiddleMarkerClick(t){let e=t.target;if(!this._vertexValidation("add",t))return;let i=L.divIcon({className:"marker-icon"});e.setIcon(i),this._addMarker(e,e.leftM,e.rightM)},_onMiddleMarkerMoveStart(t){let e=t.target;e.on("moveend",this._onMiddleMarkerMoveEnd,this),this._vertexValidation("add",t)?(e._dragging=!0,this._addMarker(e,e.leftM,e.rightM)):e.on("move",this._onMiddleMarkerMovePrevent,this)},_onMiddleMarkerMovePrevent(t){let e=t.target;this._vertexValidationDrag(e)},_onMiddleMarkerMoveEnd(t){let e=t.target;if(e.off("move",this._onMiddleMarkerMovePrevent,this),e.off("moveend",this._onMiddleMarkerMoveEnd,this),!this._vertexValidationDragEnd(e))return;let i=L.divIcon({className:"marker-icon"});e.setIcon(i),setTimeout((()=>{delete e._dragging}),100)},_addMarker(t,e,i){t.off("movestart",this._onMiddleMarkerMoveStart,this),t.off(this.options.addVertexOn,this._onMiddleMarkerClick,this);let n=t.getLatLng(),r=this._layer._latlngs;delete t.leftM,delete t.rightM;let{indexPath:o,index:s,parentPath:a}=L.PM.Utils.findDeepMarkerIndex(this._markers,e),l=o.length>1?(0,$i.default)(r,a):r,h=o.length>1?(0,$i.default)(this._markers,a):this._markers;l.splice(s+1,0,n),h.splice(s+1,0,t),this._layer.setLatLngs(r),!0!==this.options.hideMiddleMarkers&&(this._createMiddleMarker(e,t),this._createMiddleMarker(t,i)),this._fireEdit(),this._layerEdited=!0,this._fireChange(this._layer.getLatLngs(),"Edit"),this._fireVertexAdded(t,L.PM.Utils.findDeepMarkerIndex(this._markers,t).indexPath,n),this.options.snappable&&this._initSnappableMarkers()},hasSelfIntersection(){return oi(this._layer.toGeoJSON(15)).features.length>0},_handleSelfIntersectionOnVertexRemoval(){this._handleLayerStyle(!0)&&(this._layer.setLatLngs(this._coordsBeforeEdit),this._coordsBeforeEdit=null,this._initMarkers())},_handleLayerStyle(t){let e,i,n=this._layer;if(this.options.allowSelfIntersection?e=!1:(i=oi(this._layer.toGeoJSON(15)),e=i.features.length>0),e){if(!this.options.allowSelfIntersection&&this.options.allowSelfIntersectionEdit&&this._updateDisabledMarkerStyle(this._markers,!0),this.isRed)return e;t?this._flashLayer():(n.setStyle({color:"#f00000ff"}),this.isRed=!0),this._fireIntersect(i)}else n.setStyle({color:this.cachedColor}),this.isRed=!1,!this.options.allowSelfIntersection&&this.options.allowSelfIntersectionEdit&&this._updateDisabledMarkerStyle(this._markers,!1);return e},_flashLayer(){this.cachedColor||(this.cachedColor=this._layer.options.color),this._layer.setStyle({color:"#f00000ff"}),this.isRed=!0,window.setTimeout((()=>{this._layer.setStyle({color:this.cachedColor}),this.isRed=!1}),200)},_updateDisabledMarkerStyle(t,e){t.forEach((t=>{Array.isArray(t)?this._updateDisabledMarkerStyle(t,e):t._icon&&(e&&!this._checkMarkerAllowedToDrag(t)?L.DomUtil.addClass(t._icon,"vertexmarker-disabled"):L.DomUtil.removeClass(t._icon,"vertexmarker-disabled"))}))},_removeMarker(t){let e=t.target;if(!this._vertexValidation("remove",t))return;this.options.allowSelfIntersection||(this._coordsBeforeEdit=Ge(this._layer,this._layer.getLatLngs()));let i=this._layer.getLatLngs(),{indexPath:n,index:r,parentPath:o}=L.PM.Utils.findDeepMarkerIndex(this._markers,e);if(!n)return;let s=n.length>1?(0,$i.default)(i,o):i,a=n.length>1?(0,$i.default)(this._markers,o):this._markers;if(!this.options.removeLayerBelowMinVertexCount&&(s.length<=2||this.isPolygon()&&s.length<=3))return void this._flashLayer();s.splice(r,1),this._layer.setLatLngs(i),this.isPolygon()&&s.length<=2&&s.splice(0,s.length);let l=!1;if(s.length<=1&&(s.splice(0,s.length),o.length>1&&n.length>1&&(i=Oe(i)),this._layer.setLatLngs(i),this._initMarkers(),l=!0),Be(i)||this._layer.remove(),i=Oe(i),this._layer.setLatLngs(i),this._markers=Oe(this._markers),!l&&(a=n.length>1?(0,$i.default)(this._markers,o):this._markers,e._middleMarkerPrev&&this._markerGroup.removeLayer(e._middleMarkerPrev),e._middleMarkerNext&&this._markerGroup.removeLayer(e._middleMarkerNext),this._markerGroup.removeLayer(e),a)){let t,e;if(this.isPolygon()?(t=(r+1)%a.length,e=(r+(a.length-1))%a.length):(e=r-1<0?void 0:r-1,t=r+1>=a.length?void 0:r+1),t!==e){let i=a[e],n=a[t];!0!==this.options.hideMiddleMarkers&&this._createMiddleMarker(i,n)}a.splice(r,1)}this._fireEdit(),this._layerEdited=!0,this._fireVertexRemoved(e,n),this._fireChange(this._layer.getLatLngs(),"Edit")},updatePolygonCoordsFromMarkerDrag(t){let e=this._layer.getLatLngs(),i=t.getLatLng(),{indexPath:n,index:r,parentPath:o}=L.PM.Utils.findDeepMarkerIndex(this._markers,t);(n.length>1?(0,$i.default)(e,o):e).splice(r,1,i),this._layer.setLatLngs(e)},_getNeighborMarkers(t){let{indexPath:e,index:i,parentPath:n}=L.PM.Utils.findDeepMarkerIndex(this._markers,t),r=e.length>1?(0,$i.default)(this._markers,n):this._markers,o=(i+1)%r.length;return{prevMarker:r[(i+(r.length-1))%r.length],nextMarker:r[o]}},_checkMarkerAllowedToDrag(t){let{prevMarker:e,nextMarker:i}=this._getNeighborMarkers(t),n=L.polyline([e.getLatLng(),t.getLatLng()]),r=L.polyline([t.getLatLng(),i.getLatLng()]),o=_i(this._layer.toGeoJSON(15),n.toGeoJSON(15)).features.length,s=_i(this._layer.toGeoJSON(15),r.toGeoJSON(15)).features.length;return t.getLatLng()===this._markers[0][0].getLatLng()?s+=1:t.getLatLng()===this._markers[0][this._markers[0].length-1].getLatLng()&&(o+=1),!(o<=2&&s<=2)},_onMarkerDragStart(t){let e=t.target;if(this.cachedColor||(this.cachedColor=this._layer.options.color),!this._vertexValidation("move",t))return;let{indexPath:i}=L.PM.Utils.findDeepMarkerIndex(this._markers,e);this._fireMarkerDragStart(t,i),this.options.allowSelfIntersection||(this._coordsBeforeEdit=Ge(this._layer,this._layer.getLatLngs())),!this.options.allowSelfIntersection&&this.options.allowSelfIntersectionEdit&&this.hasSelfIntersection()?this._markerAllowedToDrag=this._checkMarkerAllowedToDrag(e):this._markerAllowedToDrag=null},_onMarkerDrag(t){let e=t.target;if(!this._vertexValidationDrag(e))return;let{indexPath:i,index:n,parentPath:r}=L.PM.Utils.findDeepMarkerIndex(this._markers,e);if(!i)return;if(!this.options.allowSelfIntersection&&this.options.allowSelfIntersectionEdit&&this.hasSelfIntersection()&&!1===this._markerAllowedToDrag)return this._layer.setLatLngs(this._coordsBeforeEdit),this._initMarkers(),void this._handleLayerStyle();this.updatePolygonCoordsFromMarkerDrag(e);let o=i.length>1?(0,$i.default)(this._markers,r):this._markers,s=(n+1)%o.length,a=(n+(o.length-1))%o.length,l=e.getLatLng(),h=o[a].getLatLng(),c=o[s].getLatLng();if(e._middleMarkerNext){let t=L.PM.Utils.calcMiddleLatLng(this._map,l,c);e._middleMarkerNext.setLatLng(t)}if(e._middleMarkerPrev){let t=L.PM.Utils.calcMiddleLatLng(this._map,l,h);e._middleMarkerPrev.setLatLng(t)}this.options.allowSelfIntersection||this._handleLayerStyle(),this._fireMarkerDrag(t,i),this._fireChange(this._layer.getLatLngs(),"Edit")},_onMarkerDragEnd(t){let e=t.target;if(!this._vertexValidationDragEnd(e))return;let{indexPath:i}=L.PM.Utils.findDeepMarkerIndex(this._markers,e),n=this.hasSelfIntersection();n&&this.options.allowSelfIntersectionEdit&&this._markerAllowedToDrag&&(n=!1);let r=!this.options.allowSelfIntersection&&n;if(this._fireMarkerDragEnd(t,i,r),r)return this._layer.setLatLngs(this._coordsBeforeEdit),this._coordsBeforeEdit=null,this._initMarkers(),this.options.snappable&&this._initSnappableMarkers(),this._handleLayerStyle(),void this._fireLayerReset(t,i);!this.options.allowSelfIntersection&&this.options.allowSelfIntersectionEdit&&this._handleLayerStyle(),this._fireEdit(),this._layerEdited=!0,this._fireChange(this._layer.getLatLngs(),"Edit")},_onVertexClick(t){let e=t.target;if(e._dragging)return;let{indexPath:i}=L.PM.Utils.findDeepMarkerIndex(this._markers,e);this._fireVertexClick(t,i)}}),Qi.Polygon=Qi.Line.extend({_shape:"Polygon",_checkMarkerAllowedToDrag(t){let{prevMarker:e,nextMarker:i}=this._getNeighborMarkers(t),n=L.polyline([e.getLatLng(),t.getLatLng()]),r=L.polyline([t.getLatLng(),i.getLatLng()]),o=_i(this._layer.toGeoJSON(15),n.toGeoJSON(15)).features.length,s=_i(this._layer.toGeoJSON(15),r.toGeoJSON(15)).features.length;return!(o<=2&&s<=2)}}),Qi.Rectangle=Qi.Polygon.extend({_shape:"Rectangle",_initMarkers(){let t=this._map,e=this._findCorners();this._markerGroup&&this._markerGroup.clearLayers(),this._markerGroup=new L.FeatureGroup,this._markerGroup._pmTempLayer=!0,t.addLayer(this._markerGroup),this._markers=[],this._markers[0]=e.map(this._createMarker,this),[this._cornerMarkers]=this._markers,this._layer.getLatLngs()[0].forEach(((t,e)=>{let i=this._cornerMarkers.find((t=>t._index===e));i&&i.setLatLng(t)}))},applyOptions(){this.options.snappable?this._initSnappableMarkers():this._disableSnapping(),this._addMarkerEvents()},_createMarker(t,e){let i=new L.Marker(t,{draggable:!0,icon:L.divIcon({className:"marker-icon"})});return this._setPane(i,"vertexPane"),i._origLatLng=t,i._index=e,i._pmTempLayer=!0,i.on("click",this._onVertexClick,this),this._markerGroup.addLayer(i),i},_addMarkerEvents(){this._markers[0].forEach((t=>{t.on("dragstart",this._onMarkerDragStart,this),t.on("drag",this._onMarkerDrag,this),t.on("dragend",this._onMarkerDragEnd,this),this.options.preventMarkerRemoval||t.on("contextmenu",this._removeMarker,this)}))},_removeMarker:()=>null,_onMarkerDragStart(t){if(!this._vertexValidation("move",t))return;let e=t.target,i=this._cornerMarkers;e._oppositeCornerLatLng=i.find((t=>t._index===(e._index+2)%4)).getLatLng(),e._snapped=!1,this._fireMarkerDragStart(t)},_onMarkerDrag(t){let e=t.target;this._vertexValidationDrag(e)&&void 0!==e._index&&(this._adjustRectangleForMarkerMove(e),this._fireMarkerDrag(t),this._fireChange(this._layer.getLatLngs(),"Edit"))},_onMarkerDragEnd(t){let e=t.target;this._vertexValidationDragEnd(e)&&(this._cornerMarkers.forEach((t=>{delete t._oppositeCornerLatLng})),this._fireMarkerDragEnd(t),this._fireEdit(),this._layerEdited=!0,this._fireChange(this._layer.getLatLngs(),"Edit"))},_adjustRectangleForMarkerMove(t){L.extend(t._origLatLng,t._latlng);let e=L.PM.Utils._getRotatedRectangle(t.getLatLng(),t._oppositeCornerLatLng,this.getAngle(),this._map);this._layer.setLatLngs(e),this._adjustAllMarkers(),this._layer.redraw()},_adjustAllMarkers(){let t=this._layer.getLatLngs()[0];t&&4!==t.length&&t.length>0?(t.forEach(((t,e)=>{this._cornerMarkers[e].setLatLng(t)})),this._cornerMarkers.slice(t.length).forEach((e=>{e.setLatLng(t[0])}))):t&&t.length?this._cornerMarkers.forEach((e=>{e.setLatLng(t[e._index])})):console.error("The layer has no LatLngs")},_findCorners(){void 0===this._angle&&this.setInitAngle(Ne(this._map,this._layer.getLatLngs()[0][0],this._layer.getLatLngs()[0][1])||0);let t=this._layer.getLatLngs()[0];return L.PM.Utils._getRotatedRectangle(t[0],t[2],this.getAngle(),this._map||this)}}),Qi.CircleMarker=Qi.extend({_shape:"CircleMarker",initialize(t){this._layer=t,this._enabled=!1,this._minRadiusOption="minRadiusCircleMarker",this._maxRadiusOption="maxRadiusCircleMarker",this._editableOption="resizeableCircleMarker",this._updateHiddenPolyCircle()},enable(t={draggable:!0,snappable:!0}){L.Util.setOptions(this,t),this.options.editable&&(this.options.resizeableCircleMarker=this.options.editable,delete this.options.editable),this.options.allowEditing&&this._layer._map?(this._map=this._layer._map,this.enabled()&&this.disable(),this.applyOptions(),this._layer.on("remove",this.disable,this),this._enabled=!0,this._extendingEnable(),this._updateHiddenPolyCircle(),this._fireEnable()):this.disable()},_extendingEnable(){this._layer.on("pm:dragstart",this._onDragStart,this),this._layer.on("pm:drag",this._onMarkerDrag,this),this._layer.on("pm:dragend",this._onMarkerDragEnd,this)},disable(){this.dragging()||(this._map||(this._map=this._layer._map),this._map&&this.enabled()&&(this.layerDragEnabled()&&this.disableLayerDrag(),this.options[this._editableOption]?(this._helperLayers&&this._helperLayers.clearLayers(),this._map.off("move",this._syncMarkers,this),this._outerMarker.off("drag",this._handleOuterMarkerSnapping,this)):this._map.off("move",this._updateHiddenPolyCircle,this),this._extendingDisable(),this._layer.off("remove",this.disable,this),this._layerEdited&&this._fireUpdate(),this._layerEdited=!1,this._fireDisable(),this._enabled=!1))},_extendingDisable(){this._layer.off("contextmenu",this._removeMarker,this)},enabled(){return this._enabled},toggleEdit(t){this.enabled()?this.disable():this.enable(t)},applyOptions(){this.options[this._editableOption]?(this._initMarkers(),this._map.on("move",this._syncMarkers,this),this.options.snappable?(this._initSnappableMarkers(),this._outerMarker.on("drag",this._handleOuterMarkerSnapping,this),this._outerMarker.on("move",this._syncHintLine,this),this._outerMarker.on("move",this._syncCircleRadius,this),this._centerMarker.on("move",this._moveCircle,this)):this._disableSnapping()):(this.options.draggable&&this.enableLayerDrag(),this._map.on("move",this._updateHiddenPolyCircle,this),this.options.snappable?this._initSnappableMarkersDrag():this._disableSnappingDrag()),this._extendingApplyOptions()},_extendingApplyOptions(){this.options.preventMarkerRemoval||this._layer.on("contextmenu",this._removeMarker,this)},_initMarkers(){let t=this._map;this._helperLayers&&this._helperLayers.clearLayers(),this._helperLayers=new L.FeatureGroup,this._helperLayers._pmTempLayer=!0,this._helperLayers.addTo(t);let e=this._layer.getLatLng(),i=this._layer._radius,n=this._getLatLngOnCircle(e,i);this._centerMarker=this._createCenterMarker(e),this._outerMarker=this._createOuterMarker(n),this._markers=[this._centerMarker,this._outerMarker],this._createHintLine(this._centerMarker,this._outerMarker)},_getLatLngOnCircle(t,e){let i=this._map.project(t),n=L.point(i.x+e,i.y);return this._map.unproject(n)},_createHintLine(t,e){let i=t.getLatLng(),n=e.getLatLng();this._hintline=L.polyline([i,n],this.options.hintlineStyle),this._setPane(this._hintline,"layerPane"),this._hintline._pmTempLayer=!0,this._helperLayers.addLayer(this._hintline)},_createCenterMarker(t){let e=this._createMarker(t);return this.options.draggable?L.DomUtil.addClass(e._icon,"leaflet-pm-draggable"):e.dragging.disable(),e},_createOuterMarker(t){let e=this._createMarker(t);return e.on("drag",this._resizeCircle,this),e},_createMarker(t){let e=new L.Marker(t,{draggable:!0,icon:L.divIcon({className:"marker-icon"})});return this._setPane(e,"vertexPane"),e._origLatLng=t,e._pmTempLayer=!0,e.on("dragstart",this._onMarkerDragStart,this),e.on("drag",this._onMarkerDrag,this),e.on("dragend",this._onMarkerDragEnd,this),e.on("click",this._onVertexClick,this),this._helperLayers.addLayer(e),e},_moveCircle(t){if(t.target._cancelDragEventChain)return;let e=this._centerMarker.getLatLng();this._layer.setLatLng(e);let i=this._layer._radius,n=this._getLatLngOnCircle(e,i);this._outerMarker._latlng=n,this._outerMarker.update(),this._syncHintLine(),this._updateHiddenPolyCircle(),this._fireCenterPlaced("Edit"),this._fireChange(this._layer.getLatLng(),"Edit")},_syncMarkers(){let t=this._layer.getLatLng(),e=this._layer._radius,i=this._getLatLngOnCircle(t,e);this._outerMarker.setLatLng(i),this._centerMarker.setLatLng(t),this._syncHintLine(),this._updateHiddenPolyCircle()},_resizeCircle(){this._outerMarker.setLatLng(this._getNewDestinationOfOuterMarker()),this._syncHintLine(),this._syncCircleRadius()},_syncCircleRadius(){let t=this._centerMarker.getLatLng(),e=this._outerMarker.getLatLng(),i=this._distanceCalculation(t,e);this.options[this._minRadiusOption]&&i<this.options[this._minRadiusOption]?this._layer.setRadius(this.options[this._minRadiusOption]):this.options[this._maxRadiusOption]&&i>this.options[this._maxRadiusOption]?this._layer.setRadius(this.options[this._maxRadiusOption]):this._layer.setRadius(i),this._updateHiddenPolyCircle(),this._fireChange(this._layer.getLatLng(),"Edit")},_syncHintLine(){let t=this._centerMarker.getLatLng(),e=this._outerMarker.getLatLng();this._hintline.setLatLngs([t,e])},_removeMarker(){this.options[this._editableOption]&&this.disable(),this._layer.remove(),this._fireRemove(this._layer),this._fireRemove(this._map,this._layer)},_onDragStart(){this._map.pm.Draw.CircleMarker._layerIsDragging=!0},_onMarkerDragStart(t){this._vertexValidation("move",t)&&this._fireMarkerDragStart(t)},_onMarkerDrag(t){let e=t.target;e instanceof L.Marker&&!this._vertexValidationDrag(e)||this._fireMarkerDrag(t)},_onMarkerDragEnd(t){this._extedingMarkerDragEnd();let e=t.target;this._vertexValidationDragEnd(e)&&(this.options[this._editableOption]&&(this._fireEdit(),this._layerEdited=!0),this._fireMarkerDragEnd(t))},_extedingMarkerDragEnd(){this._map.pm.Draw.CircleMarker._layerIsDragging=!1},_initSnappableMarkersDrag(){let t=this._layer;this.options.snapDistance=this.options.snapDistance||30,this.options.snapSegment=void 0===this.options.snapSegment||this.options.snapSegment,t.off("pm:drag",this._handleSnapping,this),t.on("pm:drag",this._handleSnapping,this),t.off("pm:dragend",this._cleanupSnapping,this),t.on("pm:dragend",this._cleanupSnapping,this),t.off("pm:dragstart",this._unsnap,this),t.on("pm:dragstart",this._unsnap,this)},_disableSnappingDrag(){let t=this._layer;t.off("pm:drag",this._handleSnapping,this),t.off("pm:dragend",this._cleanupSnapping,this),t.off("pm:dragstart",this._unsnap,this)},_updateHiddenPolyCircle(){let t=this._layer._map||this._map;if(t){let e=L.PM.Utils.pxRadiusToMeterRadius(this._layer.getRadius(),t,this._layer.getLatLng()),i=L.circle(this._layer.getLatLng(),this._layer.options);i.setRadius(e);let n=t&&t.pm._isCRSSimple();this._hiddenPolyCircle?this._hiddenPolyCircle.setLatLngs(L.PM.Utils.circleToPolygon(i,200,!n).getLatLngs()):this._hiddenPolyCircle=L.PM.Utils.circleToPolygon(i,200,!n),this._hiddenPolyCircle._parentCopy||(this._hiddenPolyCircle._parentCopy=this._layer)}},_getNewDestinationOfOuterMarker(){let t=this._centerMarker.getLatLng(),e=this._outerMarker.getLatLng(),i=this._distanceCalculation(t,e);return this.options[this._minRadiusOption]&&i<this.options[this._minRadiusOption]?e=Fe(this._map,t,e,this._getMinDistanceInMeter(t)):this.options[this._maxRadiusOption]&&i>this.options[this._maxRadiusOption]&&(e=Fe(this._map,t,e,this._getMaxDistanceInMeter(t))),e},_handleOuterMarkerSnapping(){if(this._outerMarker._snapped){let t=this._centerMarker.getLatLng(),e=this._outerMarker.getLatLng(),i=this._distanceCalculation(t,e);(this.options[this._minRadiusOption]&&i<this.options[this._minRadiusOption]||this.options[this._maxRadiusOption]&&i>this.options[this._maxRadiusOption])&&this._outerMarker.setLatLng(this._outerMarker._orgLatLng)}this._outerMarker.setLatLng(this._getNewDestinationOfOuterMarker())},_distanceCalculation(t,e){return this._map.project(t).distanceTo(this._map.project(e))},_getMinDistanceInMeter(t){return L.PM.Utils.pxRadiusToMeterRadius(this.options[this._minRadiusOption],this._map,t)},_getMaxDistanceInMeter(t){return L.PM.Utils.pxRadiusToMeterRadius(this.options[this._maxRadiusOption],this._map,t)},_onVertexClick(t){t.target._dragging||this._fireVertexClick(t,void 0)}}),Qi.Circle=Qi.CircleMarker.extend({_shape:"Circle",initialize(t){this._layer=t,this._enabled=!1,this._minRadiusOption="minRadiusCircle",this._maxRadiusOption="maxRadiusCircle",this._editableOption="resizableCircle",this._updateHiddenPolyCircle()},enable(t){L.PM.Edit.CircleMarker.prototype.enable.call(this,t||{})},_extendingEnable(){},_extendingDisable(){this._layer.off("remove",this.disable,this);let t=this._layer._path?this._layer._path:this._layer._renderer._container;L.DomUtil.removeClass(t,"leaflet-pm-draggable")},_extendingApplyOptions(){},_syncMarkers(){},_removeMarker(){},_onDragStart(){},_extedingMarkerDragEnd(){},_updateHiddenPolyCircle(){let t=this._map&&this._map.pm._isCRSSimple();this._hiddenPolyCircle?this._hiddenPolyCircle.setLatLngs(L.PM.Utils.circleToPolygon(this._layer,200,!t).getLatLngs()):this._hiddenPolyCircle=L.PM.Utils.circleToPolygon(this._layer,200,!t),this._hiddenPolyCircle._parentCopy||(this._hiddenPolyCircle._parentCopy=this._layer)},_distanceCalculation(t,e){return this._map.distance(t,e)},_getMinDistanceInMeter(){return this.options[this._minRadiusOption]},_getMaxDistanceInMeter(){return this.options[this._maxRadiusOption]},_onVertexClick(t){t.target._dragging||this._fireVertexClick(t,void 0)}}),Qi.ImageOverlay=Qi.extend({_shape:"ImageOverlay",initialize(t){this._layer=t,this._enabled=!1},toggleEdit(t){this.enabled()?this.disable():this.enable(t)},enabled(){return this._enabled},enable(t={draggable:!0,snappable:!0}){if(L.Util.setOptions(this,t),this._map=this._layer._map,this._map){if(!this.options.allowEditing)return void this.disable();this.enabled()||this.disable(),this.enableLayerDrag(),this._layer.on("remove",this.disable,this),this._enabled=!0,this._otherSnapLayers=this._findCorners(),this._fireEnable()}},disable(){this._dragging||(this._map||(this._map=this._layer._map),this.disableLayerDrag(),this._layer.off("remove",this.disable,this),this.enabled()||(this._layerEdited&&this._fireUpdate(),this._layerEdited=!1,this._fireDisable()),this._enabled=!1)},_findCorners(){let t=this._layer.getBounds();return[t.getNorthWest(),t.getNorthEast(),t.getSouthEast(),t.getSouthWest()]}}),Qi.Text=Qi.extend({_shape:"Text",initialize(t){this._layer=t,this._enabled=!1},enable(t){if(L.Util.setOptions(this,t),this.textArea){if(!this.options.allowEditing||!this._layer._map)return void this.disable();this._map=this._layer._map,this.enabled()&&this.disable(),this.applyOptions(),this._safeToCacheDragState=!0,this._focusChange(),this.textArea.readOnly=!1,this.textArea.classList.remove("pm-disabled"),this._layer.on("remove",this.disable,this),L.DomEvent.on(this.textArea,"input",this._autoResize,this),L.DomEvent.on(this.textArea,"focus",this._focusChange,this),L.DomEvent.on(this.textArea,"blur",this._focusChange,this),this._layer.on("dblclick",L.DomEvent.stop),L.DomEvent.off(this.textArea,"mousedown",this._preventTextSelection),this._enabled=!0,this._fireEnable()}},disable(){if(!this.enabled())return;this._layer.off("remove",this.disable,this),L.DomEvent.off(this.textArea,"input",this._autoResize,this),L.DomEvent.off(this.textArea,"focus",this._focusChange,this),L.DomEvent.off(this.textArea,"blur",this._focusChange,this),L.DomEvent.off(document,"click",this._documentClick,this),this._focusChange(),this.textArea.readOnly=!0,this.textArea.classList.add("pm-disabled");let t=document.activeElement;this.textArea.focus(),this.textArea.selectionStart=0,this.textArea.selectionEnd=0,L.DomEvent.on(this.textArea,"mousedown",this._preventTextSelection),t.focus(),this._disableOnBlurActive=!1,this._layerEdited&&this._fireUpdate(),this._layerEdited=!1,this._fireDisable(),this._enabled=!1},enabled(){return this._enabled},toggleEdit(t){this.enabled()?this.disable():this.enable(t)},applyOptions(){this.options.snappable?this._initSnappableMarkers():this._disableSnapping()},_initSnappableMarkers(){let t=this._layer;this.options.snapDistance=this.options.snapDistance||30,this.options.snapSegment=void 0===this.options.snapSegment||this.options.snapSegment,t.off("pm:drag",this._handleSnapping,this),t.on("pm:drag",this._handleSnapping,this),t.off("pm:dragend",this._cleanupSnapping,this),t.on("pm:dragend",this._cleanupSnapping,this),t.off("pm:dragstart",this._unsnap,this),t.on("pm:dragstart",this._unsnap,this)},_disableSnapping(){let t=this._layer;t.off("pm:drag",this._handleSnapping,this),t.off("pm:dragend",this._cleanupSnapping,this),t.off("pm:dragstart",this._unsnap,this)},_autoResize(){this.textArea.style.height="1px",this.textArea.style.width="1px";let t=this.textArea.scrollHeight>21?this.textArea.scrollHeight:21,e=this.textArea.scrollWidth>16?this.textArea.scrollWidth:16;this.textArea.style.height=`${t}px`,this.textArea.style.width=`${e}px`,this._layer.options.text=this.getText(),this._fireTextChange(this.getText())},_disableOnBlur(){this._disableOnBlurActive=!0,setTimeout((()=>{this.enabled()&&L.DomEvent.on(document,"click",this._documentClick,this)}),100)},_documentClick(t){t.target!==this.textArea&&(this.disable(),!this.getText()&&this.options.removeIfEmpty&&this.remove())},_focusChange(t={}){let e=this._hasFocus;this._hasFocus="focus"===t.type,!e!=!this._hasFocus&&(this._hasFocus?(this._applyFocus(),this._focusText=this.getText(),this._fireTextFocus()):(this._removeFocus(),this._fireTextBlur(),this._focusText!==this.getText()&&(this._fireEdit(),this._layerEdited=!0)))},_applyFocus(){this.textArea.classList.add("pm-hasfocus"),this._map.dragging&&(this._safeToCacheDragState&&(this._originalMapDragState=this._map.dragging._enabled,this._safeToCacheDragState=!1),this._map.dragging.disable())},_removeFocus(){this._map.dragging&&(this._originalMapDragState&&this._map.dragging.enable(),this._safeToCacheDragState=!0),this.textArea.classList.remove("pm-hasfocus")},focus(){if(!this.enabled())throw new TypeError("Layer is not enabled");this.textArea.focus()},blur(){if(!this.enabled())throw new TypeError("Layer is not enabled");this.textArea.blur(),this._disableOnBlurActive&&this.disable()},hasFocus(){return this._hasFocus},getElement(){return this.textArea},setText(t){this.textArea.value=t,this._autoResize()},getText(){return this.textArea.value},_initTextMarker(){if(this.textArea=L.PM.Draw.Text.prototype._createTextArea.call(this),this.options.className){let t=this.options.className.split(" ");this.textArea.classList.add(...t)}let t=L.PM.Draw.Text.prototype._createTextIcon.call(this,this.textArea);this._layer.setIcon(t),this._layer.once("add",this._createTextMarker,this)},_createTextMarker(t=!1){this._layer.off("add",this._createTextMarker,this),this._layer.getElement().tabIndex=-1,this.textArea.wrap="off",this.textArea.style.overflow="hidden",this.textArea.style.height=L.DomUtil.getStyle(this.textArea,"font-size"),this.textArea.style.width="1px",this._layer.options.text&&this.setText(this._layer.options.text),this._autoResize(),!0===t&&(this.enable(),this.focus(),this._disableOnBlur())},_preventTextSelection(t){t.preventDefault()}});var en=function(t,e,i,n,r,o){this._matrix=[t,e,i,n,r,o]};en.init=()=>new L.PM.Matrix(1,0,0,1,0,0),en.prototype={transform(t){return this._transform(t.clone())},_transform(t){let e=this._matrix,{x:i,y:n}=t;return t.x=e[0]*i+e[1]*n+e[4],t.y=e[2]*i+e[3]*n+e[5],t},untransform(t){let e=this._matrix;return new L.Point((t.x/e[0]-e[4])/e[0],(t.y/e[2]-e[5])/e[2])},clone(){let t=this._matrix;return new L.PM.Matrix(t[0],t[1],t[2],t[3],t[4],t[5])},translate(t){if(void 0===t)return new L.Point(this._matrix[4],this._matrix[5]);let e,i;return"number"==typeof t?(e=t,i=t):(e=t.x,i=t.y),this._add(1,0,0,1,e,i)},scale(t,e){if(void 0===t)return new L.Point(this._matrix[0],this._matrix[3]);let i,n;return e=e||L.point(0,0),"number"==typeof t?(i=t,n=t):(i=t.x,n=t.y),this._add(i,0,0,n,e.x,e.y)._add(1,0,0,1,-e.x,-e.y)},rotate(t,e){let i=Math.cos(t),n=Math.sin(t);return e=e||new L.Point(0,0),this._add(i,n,-n,i,e.x,e.y)._add(1,0,0,1,-e.x,-e.y)},flip(){return this._matrix[1]*=-1,this._matrix[2]*=-1,this},_add(t,e,i,n,r,o){let s,a=[[],[],[]],l=this._matrix,h=[[l[0],l[2],l[4]],[l[1],l[3],l[5]],[0,0,1]],c=[[t,i,r],[e,n,o],[0,0,1]];t&&t instanceof L.PM.Matrix&&(l=t._matrix,c=[[l[0],l[2],l[4]],[l[1],l[3],l[5]],[0,0,1]]);for(let t=0;t<3;t+=1)for(let e=0;e<3;e+=1){s=0;for(let i=0;i<3;i+=1)s+=h[t][i]*c[i][e];a[t][e]=s}return this._matrix=[a[0][0],a[1][0],a[0][1],a[1][1],a[0][2],a[1][2]],this}};var nn=en,rn={calcMiddleLatLng(t,e,i){let n=t.project(e),r=t.project(i);return t.unproject(n._add(r)._divideBy(2))},findLayers(t){let e=[];return t.eachLayer((t=>{(t instanceof L.Polyline||t instanceof L.Marker||t instanceof L.Circle||t instanceof L.CircleMarker||t instanceof L.ImageOverlay)&&e.push(t)})),e=e.filter((t=>!!t.pm)),e=e.filter((t=>!t._pmTempLayer)),e=e.filter((t=>!L.PM.optIn&&!t.options.pmIgnore||L.PM.optIn&&!1===t.options.pmIgnore)),e},circleToPolygon(t,e=60,i=!0){let n=je(t.getLatLng(),t.getRadius(),e,0,i),r=[];for(let t=0;t<n.length;t+=1){let e=[n[t].lat,n[t].lng];r.push(e)}return L.polygon(r,t.options)},disablePopup(t){t.getPopup()&&(t._tempPopupCopy=t.getPopup(),t.unbindPopup())},enablePopup(t){t._tempPopupCopy&&(t.bindPopup(t._tempPopupCopy),delete t._tempPopupCopy)},_fireEvent(t,e,i,n=!1){t.fire(e,i,n);let{groups:r}=this.getAllParentGroups(t);r.forEach((t=>{t.fire(e,i,n)}))},getAllParentGroups(t){let e=[],i=[],n=t=>{for(let r in t._eventParents)if(-1===e.indexOf(r)){e.push(r);let o=t._eventParents[r];i.push(o),n(o)}};return!t._pmLastGroupFetch||!t._pmLastGroupFetch.time||(new Date).getTime()-t._pmLastGroupFetch.time>1e3?(n(t),t._pmLastGroupFetch={time:(new Date).getTime(),groups:i,groupIds:e},{groupIds:e,groups:i}):{groups:t._pmLastGroupFetch.groups,groupIds:t._pmLastGroupFetch.groupIds}},createGeodesicPolygon:je,getTranslation:ze,findDeepCoordIndex(t,e,i=!0){let n,r=t=>(o,s)=>{let a=t.concat(s);if(i){if(o.lat&&o.lat===e.lat&&o.lng===e.lng)return n=a,!0}else if(o.lat&&L.latLng(o).equals(e))return n=a,!0;return Array.isArray(o)&&o.some(r(a))};t.some(r([]));let o={};return n&&(o={indexPath:n,index:n[n.length-1],parentPath:n.slice(0,n.length-1)}),o},findDeepMarkerIndex(t,e){let i,n=t=>(r,o)=>{let s=t.concat(o);return r._leaflet_id===e._leaflet_id?(i=s,!0):Array.isArray(r)&&r.some(n(s))};t.some(n([]));let r={};return i&&(r={indexPath:i,index:i[i.length-1],parentPath:i.slice(0,i.length-1)}),r},_getIndexFromSegment(t,e){if(e&&2===e.length){let i=this.findDeepCoordIndex(t,e[0]),n=this.findDeepCoordIndex(t,e[1]),r=Math.max(i.index,n.index);return(0===i.index||0===n.index)&&1!==r&&(r+=1),{indexA:i,indexB:n,newIndex:r,indexPath:i.indexPath,parentPath:i.parentPath}}return null},_getRotatedRectangle(t,e,i,n){let r=Yi(n,t),o=Yi(n,e),s=i*Math.PI/180,a=Math.cos(s),l=Math.sin(s),h=(o.x-r.x)*a+(o.y-r.y)*l,c=(o.y-r.y)*a-(o.x-r.x)*l,u=h*a+r.x,d=h*l+r.y,p=-c*l+r.x,f=c*a+r.y;return[Xi(n,r),Xi(n,{x:u,y:d}),Xi(n,o),Xi(n,{x:p,y:f})]},pxRadiusToMeterRadius(t,e,i){let n=e.project(i),r=L.point(n.x+t,n.y);return e.distance(e.unproject(r),i)}};L.PM=L.PM||{version:"2.16.0",Map:Ve,Toolbar:qe,Draw:Ye,Edit:Qi,Utils:rn,Matrix:nn,activeLang:"en",optIn:!1,initialize(t){this.addInitHooks(t)},setOptIn(t){this.optIn=!!t},addInitHooks(){L.Map.addInitHook((function(){this.pm=void 0,L.PM.optIn?!1===this.options.pmIgnore&&(this.pm=new L.PM.Map(this)):this.options.pmIgnore||(this.pm=new L.PM.Map(this)),this.pm&&this.pm.setGlobalOptions({})})),L.LayerGroup.addInitHook((function(){this.pm=void 0,L.PM.optIn?!1===this.options.pmIgnore&&(this.pm=new L.PM.Edit.LayerGroup(this)):this.options.pmIgnore||(this.pm=new L.PM.Edit.LayerGroup(this))})),L.Marker.addInitHook((function(){this.pm=void 0,L.PM.optIn?!1===this.options.pmIgnore&&(this.options.textMarker?(this.pm=new L.PM.Edit.Text(this),this.options._textMarkerOverPM||this.pm._initTextMarker(),delete this.options._textMarkerOverPM):this.pm=new L.PM.Edit.Marker(this)):this.options.pmIgnore||(this.options.textMarker?(this.pm=new L.PM.Edit.Text(this),this.options._textMarkerOverPM||this.pm._initTextMarker(),delete this.options._textMarkerOverPM):this.pm=new L.PM.Edit.Marker(this))})),L.CircleMarker.addInitHook((function(){this.pm=void 0,L.PM.optIn?!1===this.options.pmIgnore&&(this.pm=new L.PM.Edit.CircleMarker(this)):this.options.pmIgnore||(this.pm=new L.PM.Edit.CircleMarker(this))})),L.Polyline.addInitHook((function(){this.pm=void 0,L.PM.optIn?!1===this.options.pmIgnore&&(this.pm=new L.PM.Edit.Line(this)):this.options.pmIgnore||(this.pm=new L.PM.Edit.Line(this))})),L.Polygon.addInitHook((function(){this.pm=void 0,L.PM.optIn?!1===this.options.pmIgnore&&(this.pm=new L.PM.Edit.Polygon(this)):this.options.pmIgnore||(this.pm=new L.PM.Edit.Polygon(this))})),L.Rectangle.addInitHook((function(){this.pm=void 0,L.PM.optIn?!1===this.options.pmIgnore&&(this.pm=new L.PM.Edit.Rectangle(this)):this.options.pmIgnore||(this.pm=new L.PM.Edit.Rectangle(this))})),L.Circle.addInitHook((function(){this.pm=void 0,L.PM.optIn?!1===this.options.pmIgnore&&(this.pm=new L.PM.Edit.Circle(this)):this.options.pmIgnore||(this.pm=new L.PM.Edit.Circle(this))})),L.ImageOverlay.addInitHook((function(){this.pm=void 0,L.PM.optIn?!1===this.options.pmIgnore&&(this.pm=new L.PM.Edit.ImageOverlay(this)):this.options.pmIgnore||(this.pm=new L.PM.Edit.ImageOverlay(this))}))},reInitLayer(t){t instanceof L.LayerGroup&&t.eachLayer((t=>{this.reInitLayer(t)})),t.pm||L.PM.optIn&&!1!==t.options.pmIgnore||t.options.pmIgnore||(t instanceof L.Map?t.pm=new L.PM.Map(t):t instanceof L.Marker?t.options.textMarker?(t.pm=new L.PM.Edit.Text(t),t.pm._initTextMarker(),t.pm._createTextMarker(!1)):t.pm=new L.PM.Edit.Marker(t):t instanceof L.Circle?t.pm=new L.PM.Edit.Circle(t):t instanceof L.CircleMarker?t.pm=new L.PM.Edit.CircleMarker(t):t instanceof L.Rectangle?t.pm=new L.PM.Edit.Rectangle(t):t instanceof L.Polygon?t.pm=new L.PM.Edit.Polygon(t):t instanceof L.Polyline?t.pm=new L.PM.Edit.Line(t):t instanceof L.LayerGroup?t.pm=new L.PM.Edit.LayerGroup(t):t instanceof L.ImageOverlay&&(t.pm=new L.PM.Edit.ImageOverlay(t)))}},"1.7.1"===L.version&&L.Canvas.include({_onClick(t){let e,i,n=this._map.mouseEventToLayerPoint(t);for(let r=this._drawFirst;r;r=r.next)e=r.layer,e.options.interactive&&e._containsPoint(n)&&("click"!==t.type&&"preclick"!==t.type||!this._map._draggableMoved(e))&&(i=e);i&&(L.DomEvent.fakeStop(t),this._fireEvent([i],t))}}),L.PM.initialize()})()},217:function(t,e){!function(t){"use strict";t.JSONExt=void 0,function(t){function e(t){return null===t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t}function i(t){return Array.isArray(t)}function n(t,r){if(t===r)return!0;if(e(t)||e(r))return!1;let o=i(t),s=i(r);return o===s&&(o&&s?function(t,e){if(t===e)return!0;if(t.length!==e.length)return!1;for(let i=0,r=t.length;i<r;++i)if(!n(t[i],e[i]))return!1;return!0}(t,r):function(t,e){if(t===e)return!0;for(let i in t)if(void 0!==t[i]&&!(i in e))return!1;for(let i in e)if(void 0!==e[i]&&!(i in t))return!1;for(let i in t){let r=t[i],o=e[i];if(void 0!==r||void 0!==o){if(void 0===r||void 0===o)return!1;if(!n(r,o))return!1}}return!0}(t,r))}function r(t){return e(t)?t:i(t)?function(t){let e=new Array(t.length);for(let i=0,n=t.length;i<n;++i)e[i]=r(t[i]);return e}(t):function(t){let e={};for(let i in t){let n=t[i];void 0!==n&&(e[i]=r(n))}return e}(t)}t.emptyObject=Object.freeze({}),t.emptyArray=Object.freeze([]),t.isPrimitive=e,t.isArray=i,t.isObject=function(t){return!e(t)&&!i(t)},t.deepEqual=n,t.deepCopy=r}(t.JSONExt||(t.JSONExt={}));function e(t){let e=0;for(let i=0,n=t.length;i<n;++i)i%4==0&&(e=4294967295*Math.random()>>>0),t[i]=255&e,e>>>=8}t.Random=void 0,(t.Random||(t.Random={})).getRandomValues=(()=>{const t="undefined"!=typeof window&&(window.crypto||window.msCrypto)||null;return t&&"function"==typeof t.getRandomValues?function(e){return t.getRandomValues(e)}:e})(),t.UUID=void 0,(t.UUID||(t.UUID={})).uuid4=function(t){const e=new Uint8Array(16),i=new Array(256);for(let t=0;t<16;++t)i[t]="0"+t.toString(16);for(let t=16;t<256;++t)i[t]=t.toString(16);return function(){return t(e),e[6]=64|15&e[6],e[8]=128|63&e[8],i[e[0]]+i[e[1]]+i[e[2]]+i[e[3]]+"-"+i[e[4]]+i[e[5]]+"-"+i[e[6]]+i[e[7]]+"-"+i[e[8]]+i[e[9]]+"-"+i[e[10]]+i[e[11]]+i[e[12]]+i[e[13]]+i[e[14]]+i[e[15]]}}(t.Random.getRandomValues),t.MimeData=class{constructor(){this._types=[],this._values=[]}types(){return this._types.slice()}hasData(t){return-1!==this._types.indexOf(t)}getData(t){let e=this._types.indexOf(t);return-1!==e?this._values[e]:void 0}setData(t,e){this.clearData(t),this._types.push(t),this._values.push(e)}clearData(t){let e=this._types.indexOf(t);-1!==e&&(this._types.splice(e,1),this._values.splice(e,1))}clear(){this._types.length=0,this._values.length=0}},t.PromiseDelegate=class{constructor(){this.promise=new Promise(((t,e)=>{this._resolve=t,this._reject=e}))}resolve(t){(0,this._resolve)(t)}reject(t){(0,this._reject)(t)}},t.Token=class{constructor(t,e){this.name=t,this.description=null!=e?e:"",this._tokenStructuralPropertyT=null}}}(e)},1364:t=>{"use strict";t.exports=function(t){var e=[];return e.toString=function(){return this.map((function(e){var i=function(t,e){var i,n,r,o=t[1]||"",s=t[3];if(!s)return o;if(e&&"function"==typeof btoa){var a=(i=s,n=btoa(unescape(encodeURIComponent(JSON.stringify(i)))),r="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(n),"/*# ".concat(r," */")),l=s.sources.map((function(t){return"/*# sourceURL=".concat(s.sourceRoot||"").concat(t," */")}));return[o].concat(l).concat([a]).join("\n")}return[o].join("\n")}(e,t);return e[2]?"@media ".concat(e[2]," {").concat(i,"}"):i})).join("")},e.i=function(t,i,n){"string"==typeof t&&(t=[[null,t,""]]);var r={};if(n)for(var o=0;o<this.length;o++){var s=this[o][0];null!=s&&(r[s]=!0)}for(var a=0;a<t.length;a++){var l=[].concat(t[a]);n&&r[l[0]]||(i&&(l[2]?l[2]="".concat(i," and ").concat(l[2]):l[2]=i),e.push(l))}},e}},3615:t=>{"use strict";t.exports=function(t,e){return e||(e={}),"string"!=typeof(t=t&&t.__esModule?t.default:t)?t:(/^['"].*['"]$/.test(t)&&(t=t.slice(1,-1)),e.hash&&(t+=e.hash),/["'() \t\n]/.test(t)||e.needQuotes?'"'.concat(t.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):t)}},9894:(t,e,i)=>{var n;window,t.exports=(n=i(4067),function(t){var e={};function i(n){if(e[n])return e[n].exports;var r=e[n]={i:n,l:!1,exports:{}};return t[n].call(r.exports,r,r.exports,i),r.l=!0,r.exports}return i.m=t,i.c=e,i.d=function(t,e,n){i.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:n})},i.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},i.t=function(t,e){if(1&e&&(t=i(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var n=Object.create(null);if(i.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var r in t)i.d(n,r,function(e){return t[e]}.bind(null,r));return n},i.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return i.d(e,"a",e),e},i.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},i.p="",i(i.s=59)}([function(t,e){t.exports="object"==typeof window&&window&&window.Math==Math?window:"object"==typeof self&&self&&self.Math==Math?self:Function("return this")()},function(t,e){t.exports=n},function(t,e,i){var n=i(4);t.exports=function(t){if(!n(t))throw TypeError(String(t)+" is not an object");return t}},function(t,e,i){var n=i(0),r=i(11).f,o=i(16),s=i(33),a=i(30),l=i(52),h=i(69);t.exports=function(t,e){var i,c,u,d,p,f=t.target,m=t.global,g=t.stat;if(i=m?n:g?n[f]||a(f,{}):(n[f]||{}).prototype)for(c in e){if(d=e[c],u=t.noTargetGet?(p=r(i,c))&&p.value:i[c],!h(m?c:f+(g?".":"#")+c,t.forced)&&void 0!==u){if(typeof d==typeof u)continue;l(d,u)}(t.sham||u&&u.sham)&&o(d,"sham",!0),s(i,c,d,t)}}},function(t,e){t.exports=function(t){return"object"==typeof t?null!==t:"function"==typeof t}},function(t,e){t.exports=function(t){try{return!!t()}catch(t){return!0}}},function(t,e,i){var n=i(20),r=i(7),o=i(55),s=i(8).f;t.exports=function(t){var e=n.Symbol||(n.Symbol={});r(e,t)||s(e,t,{value:o.f(t)})}},function(t,e){var i={}.hasOwnProperty;t.exports=function(t,e){return i.call(t,e)}},function(t,e,i){var n=i(9),r=i(46),o=i(2),s=i(13),a=Object.defineProperty;e.f=n?a:function(t,e,i){if(o(t),e=s(e,!0),o(i),r)try{return a(t,e,i)}catch(t){}if("get"in i||"set"in i)throw TypeError("Accessors not supported");return"value"in i&&(t[e]=i.value),t}},function(t,e,i){t.exports=!i(5)((function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a}))},function(t,e,i){var n=i(15)("wks"),r=i(31),o=i(0).Symbol,s=i(49);t.exports=function(t){return n[t]||(n[t]=s&&o[t]||(s?o:r)("Symbol."+t))}},function(t,e,i){var n=i(9),r=i(32),o=i(14),s=i(17),a=i(13),l=i(7),h=i(46),c=Object.getOwnPropertyDescriptor;e.f=n?c:function(t,e){if(t=s(t),e=a(e,!0),h)try{return c(t,e)}catch(t){}if(l(t,e))return o(!r.f.call(t,e),t[e])}},function(t,e,i){t.exports=i(21)},function(t,e,i){var n=i(4);t.exports=function(t,e){if(!n(t))return t;var i,r;if(e&&"function"==typeof(i=t.toString)&&!n(r=i.call(t)))return r;if("function"==typeof(i=t.valueOf)&&!n(r=i.call(t)))return r;if(!e&&"function"==typeof(i=t.toString)&&!n(r=i.call(t)))return r;throw TypeError("Can't convert object to primitive value")}},function(t,e){t.exports=function(t,e){return{enumerable:!(1&t),configurable:!(2&t),writable:!(4&t),value:e}}},function(t,e,i){var n=i(0),r=i(30),o=n["__core-js_shared__"]||r("__core-js_shared__",{});(t.exports=function(t,e){return o[t]||(o[t]=void 0!==e?e:{})})("versions",[]).push({version:"3.0.1",mode:i(48)?"pure":"global",copyright:"© 2019 Denis Pushkarev (zloirock.ru)"})},function(t,e,i){var n=i(8),r=i(14);t.exports=i(9)?function(t,e,i){return n.f(t,e,r(1,i))}:function(t,e,i){return t[e]=i,t}},function(t,e,i){var n=i(65),r=i(43);t.exports=function(t){return n(r(t))}},function(t,e,i){var n=i(15)("keys"),r=i(31);t.exports=function(t){return n[t]||(n[t]=r(t))}},function(t,e){t.exports={}},function(t,e,i){t.exports=i(0)},function(t,e,i){var n=function(){return this||"object"==typeof self&&self}()||Function("return this")(),r=n.regeneratorRuntime&&Object.getOwnPropertyNames(n).indexOf("regeneratorRuntime")>=0,o=r&&n.regeneratorRuntime;if(n.regeneratorRuntime=void 0,t.exports=i(22),r)n.regeneratorRuntime=o;else try{delete n.regeneratorRuntime}catch(t){n.regeneratorRuntime=void 0}},function(t,e){!function(e){"use strict";var i,n=Object.prototype,r=n.hasOwnProperty,o="function"==typeof Symbol?Symbol:{},s=o.iterator||"@@iterator",a=o.asyncIterator||"@@asyncIterator",l=o.toStringTag||"@@toStringTag",h="object"==typeof t,c=e.regeneratorRuntime;if(c)h&&(t.exports=c);else{(c=e.regeneratorRuntime=h?t.exports:{}).wrap=b;var u="suspendedStart",d="suspendedYield",p="executing",f="completed",m={},g={};g[s]=function(){return this};var _=Object.getPrototypeOf,y=_&&_(_(I([])));y&&y!==n&&r.call(y,s)&&(g=y);var v=M.prototype=w.prototype=Object.create(g);L.prototype=v.constructor=M,M.constructor=L,M[l]=L.displayName="GeneratorFunction",c.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===L||"GeneratorFunction"===(e.displayName||e.name))},c.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,M):(t.__proto__=M,l in t||(t[l]="GeneratorFunction")),t.prototype=Object.create(v),t},c.awrap=function(t){return{__await:t}},k(C.prototype),C.prototype[a]=function(){return this},c.AsyncIterator=C,c.async=function(t,e,i,n){var r=new C(b(t,e,i,n));return c.isGeneratorFunction(e)?r:r.next().then((function(t){return t.done?t.value:r.next()}))},k(v),v[l]="Generator",v[s]=function(){return this},v.toString=function(){return"[object Generator]"},c.keys=function(t){var e=[];for(var i in t)e.push(i);return e.reverse(),function i(){for(;e.length;){var n=e.pop();if(n in t)return i.value=n,i.done=!1,i}return i.done=!0,i}},c.values=I,E.prototype={constructor:E,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=i,this.done=!1,this.delegate=null,this.method="next",this.arg=i,this.tryEntries.forEach(S),!t)for(var e in this)"t"===e.charAt(0)&&r.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=i)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function n(n,r){return a.type="throw",a.arg=t,e.next=n,r&&(e.method="next",e.arg=i),!!r}for(var o=this.tryEntries.length-1;o>=0;--o){var s=this.tryEntries[o],a=s.completion;if("root"===s.tryLoc)return n("end");if(s.tryLoc<=this.prev){var l=r.call(s,"catchLoc"),h=r.call(s,"finallyLoc");if(l&&h){if(this.prev<s.catchLoc)return n(s.catchLoc,!0);if(this.prev<s.finallyLoc)return n(s.finallyLoc)}else if(l){if(this.prev<s.catchLoc)return n(s.catchLoc,!0)}else{if(!h)throw new Error("try statement without catch or finally");if(this.prev<s.finallyLoc)return n(s.finallyLoc)}}}},abrupt:function(t,e){for(var i=this.tryEntries.length-1;i>=0;--i){var n=this.tryEntries[i];if(n.tryLoc<=this.prev&&r.call(n,"finallyLoc")&&this.prev<n.finallyLoc){var o=n;break}}o&&("break"===t||"continue"===t)&&o.tryLoc<=e&&e<=o.finallyLoc&&(o=null);var s=o?o.completion:{};return s.type=t,s.arg=e,o?(this.method="next",this.next=o.finallyLoc,m):this.complete(s)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),m},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var i=this.tryEntries[e];if(i.finallyLoc===t)return this.complete(i.completion,i.afterLoc),S(i),m}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var i=this.tryEntries[e];if(i.tryLoc===t){var n=i.completion;if("throw"===n.type){var r=n.arg;S(i)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:I(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=i),m}}}function b(t,e,i,n){var r=e&&e.prototype instanceof w?e:w,o=Object.create(r.prototype),s=new E(n||[]);return o._invoke=function(t,e,i){var n=u;return function(r,o){if(n===p)throw new Error("Generator is already running");if(n===f){if("throw"===r)throw o;return T()}for(i.method=r,i.arg=o;;){var s=i.delegate;if(s){var a=A(s,i);if(a){if(a===m)continue;return a}}if("next"===i.method)i.sent=i._sent=i.arg;else if("throw"===i.method){if(n===u)throw n=f,i.arg;i.dispatchException(i.arg)}else"return"===i.method&&i.abrupt("return",i.arg);n=p;var l=x(t,e,i);if("normal"===l.type){if(n=i.done?f:d,l.arg===m)continue;return{value:l.arg,done:i.done}}"throw"===l.type&&(n=f,i.method="throw",i.arg=l.arg)}}}(t,i,s),o}function x(t,e,i){try{return{type:"normal",arg:t.call(e,i)}}catch(t){return{type:"throw",arg:t}}}function w(){}function L(){}function M(){}function k(t){["next","throw","return"].forEach((function(e){t[e]=function(t){return this._invoke(e,t)}}))}function C(t){var e;this._invoke=function(i,n){function o(){return new Promise((function(e,o){!function e(i,n,o,s){var a=x(t[i],t,n);if("throw"!==a.type){var l=a.arg,h=l.value;return h&&"object"==typeof h&&r.call(h,"__await")?Promise.resolve(h.__await).then((function(t){e("next",t,o,s)}),(function(t){e("throw",t,o,s)})):Promise.resolve(h).then((function(t){l.value=t,o(l)}),(function(t){return e("throw",t,o,s)}))}s(a.arg)}(i,n,e,o)}))}return e=e?e.then(o,o):o()}}function A(t,e){var n=t.iterator[e.method];if(n===i){if(e.delegate=null,"throw"===e.method){if(t.iterator.return&&(e.method="return",e.arg=i,A(t,e),"throw"===e.method))return m;e.method="throw",e.arg=new TypeError("The iterator does not provide a 'throw' method")}return m}var r=x(n,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,m;var o=r.arg;return o?o.done?(e[t.resultName]=o.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=i),e.delegate=null,m):o:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,m)}function P(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function S(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function E(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(P,this),this.reset(!0)}function I(t){if(t){var e=t[s];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var n=-1,o=function e(){for(;++n<t.length;)if(r.call(t,n))return e.value=t[n],e.done=!1,e;return e.value=i,e.done=!0,e};return o.next=o}}return{next:T}}function T(){return{value:i,done:!0}}}(function(){return this||"object"==typeof self&&self}()||Function("return this")())},function(t,e,i){var n=i(24);"string"==typeof n&&(n=[[t.i,n,""]]);i(26)(n,{hmr:!0,transform:void 0,insertInto:void 0}),n.locals&&(t.exports=n.locals)},function(t,e,i){(t.exports=i(25)(!1)).push([t.i,"@-webkit-keyframes leaflet-ant-path-animation {\n  from {\n    stroke-dashoffset: 100%; }\n  to {\n    stroke-dashoffset: 0%; } }\n\n@-moz-keyframes leaflet-ant-path-animation {\n  from {\n    stroke-dashoffset: 100%; }\n  to {\n    stroke-dashoffset: 0%; } }\n\n@-ms-keyframes leaflet-ant-path-animation {\n  from {\n    stroke-dashoffset: 100%; }\n  to {\n    stroke-dashoffset: 0%; } }\n\n@-o-keyframes leaflet-ant-path-animation {\n  from {\n    stroke-dashoffset: 100%; }\n  to {\n    stroke-dashoffset: 0%; } }\n\n@keyframes leaflet-ant-path-animation {\n  from {\n    stroke-dashoffset: 100%; }\n  to {\n    stroke-dashoffset: 0%; } }\n\npath.leaflet-ant-path {\n  fill: none;\n  -webkit-animation: linear infinite leaflet-ant-path-animation;\n  -moz-animation: linear infinite leaflet-ant-path-animation;\n  -ms-animation: linear infinite leaflet-ant-path-animation;\n  -o-animation: linear infinite leaflet-ant-path-animation;\n  animation: linear infinite leaflet-ant-path-animation; }\n  path.leaflet-ant-path__hardware-acceleration {\n    -webkit-transform: translateZ(0);\n    -moz-transform: translateZ(0);\n    -ms-transform: translateZ(0);\n    -o-transform: translateZ(0);\n    transform: translateZ(0); }\n  path.leaflet-ant-path__reverse {\n    -webkit-animation-direction: reverse;\n    -moz-animation-direction: reverse;\n    -ms-animation-direction: reverse;\n    -o-animation-direction: reverse;\n    animation-direction: reverse; }\n",""])},function(t,e,i){"use strict";t.exports=function(t){var e=[];return e.toString=function(){return this.map((function(e){var i=function(t,e){var i,n=t[1]||"",r=t[3];if(!r)return n;if(e&&"function"==typeof btoa){var o=(i=r,"/*# sourceMappingURL=data:application/json;charset=utf-8;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(i))))+" */"),s=r.sources.map((function(t){return"/*# sourceURL="+r.sourceRoot+t+" */"}));return[n].concat(s).concat([o]).join("\n")}return[n].join("\n")}(e,t);return e[2]?"@media "+e[2]+"{"+i+"}":i})).join("")},e.i=function(t,i){"string"==typeof t&&(t=[[null,t,""]]);for(var n={},r=0;r<this.length;r++){var o=this[r][0];null!=o&&(n[o]=!0)}for(r=0;r<t.length;r++){var s=t[r];null!=s[0]&&n[s[0]]||(i&&!s[2]?s[2]=i:i&&(s[2]="("+s[2]+") and ("+i+")"),e.push(s))}},e}},function(t,e,i){var n,r,o={},s=(n=function(){return window&&document&&document.all&&!window.atob},function(){return void 0===r&&(r=n.apply(this,arguments)),r}),a=function(t){var e={};return function(t,i){if("function"==typeof t)return t();if(void 0===e[t]){var n=function(t,e){return e?e.querySelector(t):document.querySelector(t)}.call(this,t,i);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(t){n=null}e[t]=n}return e[t]}}(),l=null,h=0,c=[],u=i(27);function d(t,e){for(var i=0;i<t.length;i++){var n=t[i],r=o[n.id];if(r){r.refs++;for(var s=0;s<r.parts.length;s++)r.parts[s](n.parts[s]);for(;s<n.parts.length;s++)r.parts.push(y(n.parts[s],e))}else{var a=[];for(s=0;s<n.parts.length;s++)a.push(y(n.parts[s],e));o[n.id]={id:n.id,refs:1,parts:a}}}}function p(t,e){for(var i=[],n={},r=0;r<t.length;r++){var o=t[r],s=e.base?o[0]+e.base:o[0],a={css:o[1],media:o[2],sourceMap:o[3]};n[s]?n[s].parts.push(a):i.push(n[s]={id:s,parts:[a]})}return i}function f(t,e){var i=a(t.insertInto);if(!i)throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");var n=c[c.length-1];if("top"===t.insertAt)n?n.nextSibling?i.insertBefore(e,n.nextSibling):i.appendChild(e):i.insertBefore(e,i.firstChild),c.push(e);else if("bottom"===t.insertAt)i.appendChild(e);else{if("object"!=typeof t.insertAt||!t.insertAt.before)throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");var r=a(t.insertAt.before,i);i.insertBefore(e,r)}}function m(t){if(null===t.parentNode)return!1;t.parentNode.removeChild(t);var e=c.indexOf(t);e>=0&&c.splice(e,1)}function g(t){var e=document.createElement("style");if(void 0===t.attrs.type&&(t.attrs.type="text/css"),void 0===t.attrs.nonce){var n=i.nc;n&&(t.attrs.nonce=n)}return _(e,t.attrs),f(t,e),e}function _(t,e){Object.keys(e).forEach((function(i){t.setAttribute(i,e[i])}))}function y(t,e){var i,n,r,o;if(e.transform&&t.css){if(!(o="function"==typeof e.transform?e.transform(t.css):e.transform.default(t.css)))return function(){};t.css=o}if(e.singleton){var s=h++;i=l||(l=g(e)),n=x.bind(null,i,s,!1),r=x.bind(null,i,s,!0)}else t.sourceMap&&"function"==typeof URL&&"function"==typeof URL.createObjectURL&&"function"==typeof URL.revokeObjectURL&&"function"==typeof Blob&&"function"==typeof btoa?(i=function(t){var e=document.createElement("link");return void 0===t.attrs.type&&(t.attrs.type="text/css"),t.attrs.rel="stylesheet",_(e,t.attrs),f(t,e),e}(e),n=function(t,e,i){var n=i.css,r=i.sourceMap,o=void 0===e.convertToAbsoluteUrls&&r;(e.convertToAbsoluteUrls||o)&&(n=u(n)),r&&(n+="\n/*# sourceMappingURL=data:application/json;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(r))))+" */");var s=new Blob([n],{type:"text/css"}),a=t.href;t.href=URL.createObjectURL(s),a&&URL.revokeObjectURL(a)}.bind(null,i,e),r=function(){m(i),i.href&&URL.revokeObjectURL(i.href)}):(i=g(e),n=function(t,e){var i=e.css,n=e.media;if(n&&t.setAttribute("media",n),t.styleSheet)t.styleSheet.cssText=i;else{for(;t.firstChild;)t.removeChild(t.firstChild);t.appendChild(document.createTextNode(i))}}.bind(null,i),r=function(){m(i)});return n(t),function(e){if(e){if(e.css===t.css&&e.media===t.media&&e.sourceMap===t.sourceMap)return;n(t=e)}else r()}}t.exports=function(t,e){if("undefined"!=typeof DEBUG&&DEBUG&&"object"!=typeof document)throw new Error("The style-loader cannot be used in a non-browser environment");(e=e||{}).attrs="object"==typeof e.attrs?e.attrs:{},e.singleton||"boolean"==typeof e.singleton||(e.singleton=s()),e.insertInto||(e.insertInto="head"),e.insertAt||(e.insertAt="bottom");var i=p(t,e);return d(i,e),function(t){for(var n=[],r=0;r<i.length;r++){var s=i[r];(a=o[s.id]).refs--,n.push(a)}for(t&&d(p(t,e),e),r=0;r<n.length;r++){var a;if(0===(a=n[r]).refs){for(var l=0;l<a.parts.length;l++)a.parts[l]();delete o[a.id]}}}};var v,b=(v=[],function(t,e){return v[t]=e,v.filter(Boolean).join("\n")});function x(t,e,i,n){var r=i?"":n.css;if(t.styleSheet)t.styleSheet.cssText=b(e,r);else{var o=document.createTextNode(r),s=t.childNodes;s[e]&&t.removeChild(s[e]),s.length?t.insertBefore(o,s[e]):t.appendChild(o)}}},function(t,e){t.exports=function(t){var e="undefined"!=typeof window&&window.location;if(!e)throw new Error("fixUrls requires window.location");if(!t||"string"!=typeof t)return t;var i=e.protocol+"//"+e.host,n=i+e.pathname.replace(/\/[^\/]*$/,"/");return t.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi,(function(t,e){var r,o=e.trim().replace(/^"(.*)"$/,(function(t,e){return e})).replace(/^'(.*)'$/,(function(t,e){return e}));return/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/|\s*$)/i.test(o)?t:(r=0===o.indexOf("//")?o:0===o.indexOf("/")?i+o:n+o.replace(/^\.\//,""),"url("+JSON.stringify(r)+")")}))}},function(t,e,i){var n=i(29);t.exports=Array.isArray||function(t){return"Array"==n(t)}},function(t,e){var i={}.toString;t.exports=function(t){return i.call(t).slice(8,-1)}},function(t,e,i){var n=i(0),r=i(16);t.exports=function(t,e){try{r(n,t,e)}catch(i){n[t]=e}return e}},function(t,e){var i=0,n=Math.random();t.exports=function(t){return"Symbol(".concat(void 0===t?"":t,")_",(++i+n).toString(36))}},function(t,e,i){"use strict";var n={}.propertyIsEnumerable,r=Object.getOwnPropertyDescriptor,o=r&&!n.call({1:2},1);e.f=o?function(t){var e=r(this,t);return!!e&&e.enumerable}:n},function(t,e,i){var n=i(0),r=i(16),o=i(7),s=i(30),a=i(50),l=i(51),h=l.get,c=l.enforce,u=String(a).split("toString");i(15)("inspectSource",(function(t){return a.call(t)})),(t.exports=function(t,e,i,a){var l=!!a&&!!a.unsafe,h=!!a&&!!a.enumerable,d=!!a&&!!a.noTargetGet;"function"==typeof i&&("string"!=typeof e||o(i,"name")||r(i,"name",e),c(i).source=u.join("string"==typeof e?e:"")),t!==n?(l?!d&&t[e]&&(h=!0):delete t[e],h?t[e]=i:r(t,e,i)):h?t[e]=i:s(e,i)})(Function.prototype,"toString",(function(){return"function"==typeof this&&h(this).source||a.call(this)}))},function(t,e,i){var n=i(54),r=i(35).concat("length","prototype");e.f=Object.getOwnPropertyNames||function(t){return n(t,r)}},function(t,e){t.exports=["constructor","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","valueOf"]},function(t,e){e.f=Object.getOwnPropertySymbols},function(t,e,i){var n=i(8).f,r=i(7),o=i(10)("toStringTag");t.exports=function(t,e,i){t&&!r(t=i?t:t.prototype,o)&&n(t,o,{configurable:!0,value:e})}},function(t,e,i){var n=i(54),r=i(35);t.exports=Object.keys||function(t){return n(t,r)}},function(t,e){t.exports=function(t){if("function"!=typeof t)throw TypeError(String(t)+" is not a function");return t}},function(t,e,i){var n=i(7),r=i(42),o=i(18)("IE_PROTO"),s=i(57),a=Object.prototype;t.exports=s?Object.getPrototypeOf:function(t){return t=r(t),n(t,o)?t[o]:"function"==typeof t.constructor&&t instanceof t.constructor?t.constructor.prototype:t instanceof Object?a:null}},function(t,e,i){"use strict";i.r(e);var n=i(1),r=i(12),o=i.n(r);function s(t){return(s="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function a(t){for(var e=1;e<arguments.length;e++){var i=null!=arguments[e]?arguments[e]:{},n=Object.keys(i);"function"==typeof Object.getOwnPropertySymbols&&(n=n.concat(Object.getOwnPropertySymbols(i).filter((function(t){return Object.getOwnPropertyDescriptor(i,t).enumerable})))),n.forEach((function(e){d(t,e,i[e])}))}return t}function l(t,e){for(var i=0;i<e.length;i++){var n=e[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n)}}function h(t){return(h=Object.setPrototypeOf?Object.getPrototypeOf:function(t){return t.__proto__||Object.getPrototypeOf(t)})(t)}function c(t,e){return(c=Object.setPrototypeOf||function(t,e){return t.__proto__=e,t})(t,e)}function u(t){if(void 0===t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return t}function d(t,e,i){return e in t?Object.defineProperty(t,e,{value:i,enumerable:!0,configurable:!0,writable:!0}):t[e]=i,t}var p={main:Symbol("main"),pulse:Symbol("pulse")},f=p.main,m=p.pulse,g=Symbol.species,_=Symbol.toStringTag,y=Symbol.iterator,v=function(t){function e(t){var i,r,o=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}(this,e),this,i=!(r=h(e).call(this))||"object"!==s(r)&&"function"!=typeof r?u(this):r,d(u(u(i)),f,null),d(u(u(i)),m,null),d(u(u(i)),"_map",null),d(u(u(i)),"_path",null),d(u(u(i)),"_animatedPathId",null),d(u(u(i)),"_animatedPathClass","leaflet-ant-path"),d(u(u(i)),"_reversePathClass","".concat(i._animatedPathClass,"__reverse")),d(u(u(i)),"_hardwareAccClass","hardware-acceleration"),d(u(u(i)),"_defaultOptions",{use:n.polyline,paused:!1,reverse:!1,hardwareAcceleration:!1,renderer:Object(n.svg)({pane:"overlayPane"}),delay:400,dashArray:[10,20],weight:5,opacity:.5,color:"#0000FF",pulseColor:"#FFFFFF"}),n.Util.setOptions(u(u(i)),a({},i._defaultOptions,o)),i._path=t,i._animatedPathId="ant-path-".concat((new Date).getTime()),i._mount(),i}var i,r,v;return function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function");t.prototype=Object.create(e&&e.prototype,{constructor:{value:t,writable:!0,configurable:!0}}),e&&c(t,e)}(e,n.FeatureGroup),i=e,v=[{key:g,get:function(){return this}}],(r=[{key:"map",value:function(t){return new(0,this.constructor[Symbol.species])(this._path.map(t),a({},this.options))}},{key:y,value:o.a.mark((function t(){return o.a.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.delegateYield(this._path,"t0",1);case 1:case"end":return t.stop()}}),t,this)}))},{key:"_processOptions",value:function(){var t=this.options,e=this._animatedPathClass,i=this._reversePathClass,n=this._hardwareAccClass,r=this._animatedPathId,o=t.reverse,s=t.hardwareAcceleration,l=a({},t),h=a({},t);return h.color=h.pulseColor||t.pulseColor,h.className=[e,r,o?i:"",s?"".concat(e,"__").concat(n):""].join(" "),delete l.dashArray,Array.isArray(h.dashArray)&&(h.dashArray=String(h.dashArray)),{pathOpts:l,pulseOpts:h}}},{key:"_mount",value:function(){var t=this._processOptions(),e=t.pathOpts,i=t.pulseOpts,n=this.options.use;this.addLayer(this[p.main]=n(this._path,e)),this.addLayer(this[p.pulse]=n(this._path,i))}},{key:"_calculateAnimationSpeed",value:function(){var t=this.options,e=this._map,i=this._animatedPathId;if(!t.paused&&e){var n=e.getZoom(),r=document.getElementsByClassName(i),o=1+t.delay/3/n+"s",s=["-webkit-","-moz-","-ms-","-o-",""].map((function(t){return"".concat(t,"animation-duration: ").concat(o)})).join(";");Array.from(r,(function(t){t.style.cssText=s,t.setAttribute("data-animated","true")}))}}},{key:"_pureReverse",value:function(){var t=this[p.pulse].getElement();t&&(this.options.reverse?t.classList.remove(this._reversePathClass):t.classList.add(this._reversePathClass))}},{key:"onAdd",value:function(t){return this._map=t,this._map.on("zoomend",this._calculateAnimationSpeed,this),this._mount(),this._calculateAnimationSpeed(),this}},{key:"onRemove",value:function(t){return this._map&&(this._map.off("zoomend",this._calculateAnimationSpeed,this),this._map=null),t&&t.removeLayer(this[p.main]).removeLayer(this[p.pulse]),this}},{key:"pause",value:function(){if(!this.options.paused){var t=this[p.pulse].getElement();return this.options.paused=!0,t&&(t.removeAttribute("style"),t.setAttribute("data-animated","true")),!0}return!1}},{key:"resume",value:function(){var t=this.options;return!!t.paused&&(t.paused=!1,this._calculateAnimationSpeed(),!0)}},{key:"bringToFront",value:function(){return this[p.main].bringToFront(),this[p.pulse].bringToFront(),this}},{key:"bringToBack",value:function(){return this[p.pulse].bringToBack(),this[p.main].bringToBack(),this}},{key:"removeFrom",value:function(t){return t&&t.hasLayer(this)&&t.removeLayer(this),this}},{key:"setStyle",value:function(t){var e=a({},this.options,t),i=e.paused,n=e.delay,r=e.reverse;i?this.pause():this.resume(),n!==this.options.delay&&(this.options.delay=n||this._defaultOptions.delay,this._calculateAnimationSpeed()),void 0!==r&&r!==this.options.reverse&&this._pureReverse(),this.options=a({},this.options,t);var o=this._processOptions(),s=o.pathOpts,l=o.pulseOpts;return this[p.main].setStyle(s),this[p.pulse].setStyle(l),this}},{key:"reverse",value:function(){return this._pureReverse(),this.options.reverse=!this.options.reverse,this}},{key:"redraw",value:function(){return this[p.main].redraw(),this[p.pulse].redraw(),this}},{key:"addLatLng",value:function(){for(var t,e,i=arguments.length,n=new Array(i),r=0;r<i;r++)n[r]=arguments[r];return this._path=[].concat(function(t){return function(t){if(Array.isArray(t)){for(var e=0,i=new Array(t.length);e<t.length;e++)i[e]=t[e];return i}}(t)||function(t){if(Symbol.iterator in Object(t)||"[object Arguments]"===Object.prototype.toString.call(t))return Array.from(t)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}(this._path),[n]),(t=this[p.main]).addLatLng.apply(t,n),(e=this[p.pulse]).addLatLng.apply(e,n),this}},{key:"setLatLngs",value:function(){for(var t,e,i=arguments.length,n=new Array(i),r=0;r<i;r++)n[r]=arguments[r];return this._path=n,(t=this[p.main]).setLatLngs.apply(t,n),(e=this[p.pulse]).setLatLngs.apply(e,n),this}},{key:"getLatLngs",value:function(){return this[p.main].getLatLngs()}},{key:"spliceLatLngs",value:function(){var t,e,i=(t=this[p.main]).spliceLatLngs.apply(t,arguments);return(e=this[p.pulse]).spliceLatLngs.apply(e,arguments),i}},{key:"getBounds",value:function(){return this[p.main].getBounds()}},{key:"toGeoJSON",value:function(){return this[p.main].toGeoJSON()}},{key:_,get:function(){return"L.Polyline.AntPath"}}])&&l(i.prototype,r),v&&l(i,v),e}(),b=function(t,e){return Reflect.construct(v,[t,e])};i(23),i.d(e,"AntPath",(function(){return x})),i.d(e,"antPath",(function(){return w})),n.Polyline.AntPath=v,n.polyline.antPath=b;var x=v,w=b;e.default={AntPath:x,antPath:w}},function(t,e,i){var n=i(43);t.exports=function(t){return Object(n(t))}},function(t,e){t.exports=function(t){if(null==t)throw TypeError("Can't call method on "+t);return t}},function(t,e,i){var n=i(45),r=Math.min;t.exports=function(t){return t>0?r(n(t),9007199254740991):0}},function(t,e){var i=Math.ceil,n=Math.floor;t.exports=function(t){return isNaN(t=+t)?0:(t>0?n:i)(t)}},function(t,e,i){t.exports=!i(9)&&!i(5)((function(){return 7!=Object.defineProperty(i(47)("div"),"a",{get:function(){return 7}}).a}))},function(t,e,i){var n=i(4),r=i(0).document,o=n(r)&&n(r.createElement);t.exports=function(t){return o?r.createElement(t):{}}},function(t,e){t.exports=!1},function(t,e,i){t.exports=!i(5)((function(){return!String(Symbol())}))},function(t,e,i){t.exports=i(15)("native-function-to-string",Function.toString)},function(t,e,i){var n,r,o,s=i(66),a=i(4),l=i(16),h=i(7),c=i(18),u=i(19),d=i(0).WeakMap;if(s){var p=new d,f=p.get,m=p.has,g=p.set;n=function(t,e){return g.call(p,t,e),e},r=function(t){return f.call(p,t)||{}},o=function(t){return m.call(p,t)}}else{var _=c("state");u[_]=!0,n=function(t,e){return l(t,_,e),e},r=function(t){return h(t,_)?t[_]:{}},o=function(t){return h(t,_)}}t.exports={set:n,get:r,has:o,enforce:function(t){return o(t)?r(t):n(t,{})},getterFor:function(t){return function(e){var i;if(!a(e)||(i=r(e)).type!==t)throw TypeError("Incompatible receiver, "+t+" required");return i}}}},function(t,e,i){var n=i(7),r=i(53),o=i(11),s=i(8);t.exports=function(t,e){for(var i=r(e),a=s.f,l=o.f,h=0;h<i.length;h++){var c=i[h];n(t,c)||a(t,c,l(e,c))}}},function(t,e,i){var n=i(34),r=i(36),o=i(2),s=i(0).Reflect;t.exports=s&&s.ownKeys||function(t){var e=n.f(o(t)),i=r.f;return i?e.concat(i(t)):e}},function(t,e,i){var n=i(7),r=i(17),o=i(67)(!1),s=i(19);t.exports=function(t,e){var i,a=r(t),l=0,h=[];for(i in a)!n(s,i)&&n(a,i)&&h.push(i);for(;e.length>l;)n(a,i=e[l++])&&(~o(h,i)||h.push(i));return h}},function(t,e,i){e.f=i(10)},function(t,e,i){var n=i(2),r=i(75),o=i(35),s=i(76),a=i(47),l=i(18)("IE_PROTO"),h=function(){},c=function(){var t,e=a("iframe"),i=o.length;for(e.style.display="none",s.appendChild(e),e.src=String("javascript:"),(t=e.contentWindow.document).open(),t.write("<script>document.F=Object<\/script>"),t.close(),c=t.F;i--;)delete c.prototype[o[i]];return c()};t.exports=Object.create||function(t,e){var i;return null!==t?(h.prototype=n(t),i=new h,h.prototype=null,i[l]=t):i=c(),void 0===e?i:r(i,e)},i(19)[l]=!0},function(t,e,i){t.exports=!i(5)((function(){function t(){}return t.prototype.constructor=null,Object.getPrototypeOf(new t)!==t.prototype}))},function(t,e,i){var n=i(4),r=i(2);t.exports=function(t,e){if(r(t),!n(e)&&null!==e)throw TypeError("Can't set "+String(e)+" as a prototype")}},function(t,e,i){i(60),i(93),t.exports=i(41)},function(t,e,i){i(61),i(70),i(73),i(78),i(79),i(80),i(81),i(82),i(83),i(84),i(85),i(86),i(87),i(88),i(89),i(90),i(91),i(92),t.exports=i(20).Symbol},function(t,e,i){"use strict";var n=i(28),r=i(4),o=i(42),s=i(44),a=i(62),l=i(63),h=i(10)("isConcatSpreadable"),c=!i(5)((function(){var t=[];return t[h]=!1,t.concat()[0]!==t})),u=i(64)("concat"),d=function(t){if(!r(t))return!1;var e=t[h];return void 0!==e?!!e:n(t)},p=!c||!u;i(3)({target:"Array",proto:!0,forced:p},{concat:function(t){var e,i,n,r,h,c=o(this),u=l(c,0),p=0;for(e=-1,n=arguments.length;e<n;e++)if(d(h=-1===e?c:arguments[e])){if(p+(r=s(h.length))>9007199254740991)throw TypeError("Maximum allowed index exceeded");for(i=0;i<r;i++,p++)i in h&&a(u,p,h[i])}else{if(p>=9007199254740991)throw TypeError("Maximum allowed index exceeded");a(u,p++,h)}return u.length=p,u}})},function(t,e,i){"use strict";var n=i(13),r=i(8),o=i(14);t.exports=function(t,e,i){var s=n(e);s in t?r.f(t,s,o(0,i)):t[s]=i}},function(t,e,i){var n=i(4),r=i(28),o=i(10)("species");t.exports=function(t,e){var i;return r(t)&&("function"!=typeof(i=t.constructor)||i!==Array&&!r(i.prototype)?n(i)&&null===(i=i[o])&&(i=void 0):i=void 0),new(void 0===i?Array:i)(0===e?0:e)}},function(t,e,i){var n=i(5),r=i(10)("species");t.exports=function(t){return!n((function(){var e=[];return(e.constructor={})[r]=function(){return{foo:1}},1!==e[t](Boolean).foo}))}},function(t,e,i){var n=i(5),r=i(29),o="".split;t.exports=n((function(){return!Object("z").propertyIsEnumerable(0)}))?function(t){return"String"==r(t)?o.call(t,""):Object(t)}:Object},function(t,e,i){var n=i(50),r=i(0).WeakMap;t.exports="function"==typeof r&&/native code/.test(n.call(r))},function(t,e,i){var n=i(17),r=i(44),o=i(68);t.exports=function(t){return function(e,i,s){var a,l=n(e),h=r(l.length),c=o(s,h);if(t&&i!=i){for(;h>c;)if((a=l[c++])!=a)return!0}else for(;h>c;c++)if((t||c in l)&&l[c]===i)return t||c||0;return!t&&-1}}},function(t,e,i){var n=i(45),r=Math.max,o=Math.min;t.exports=function(t,e){var i=n(t);return i<0?r(i+e,0):o(i,e)}},function(t,e,i){var n=i(5),r=/#|\.prototype\./,o=function(t,e){var i=a[s(t)];return i==h||i!=l&&("function"==typeof e?n(e):!!e)},s=o.normalize=function(t){return String(t).replace(r,".").toLowerCase()},a=o.data={},l=o.NATIVE="N",h=o.POLYFILL="P";t.exports=o},function(t,e,i){var n=i(71),r=Object.prototype;n!==r.toString&&i(33)(r,"toString",n,{unsafe:!0})},function(t,e,i){"use strict";var n=i(72),r={};r[i(10)("toStringTag")]="z",t.exports="[object z]"!==String(r)?function(){return"[object "+n(this)+"]"}:r.toString},function(t,e,i){var n=i(29),r=i(10)("toStringTag"),o="Arguments"==n(function(){return arguments}());t.exports=function(t){var e,i,s;return void 0===t?"Undefined":null===t?"Null":"string"==typeof(i=function(t,e){try{return t[e]}catch(t){}}(e=Object(t),r))?i:o?n(e):"Object"==(s=n(e))&&"function"==typeof e.callee?"Arguments":s}},function(t,e,i){"use strict";var n=i(0),r=i(7),o=i(9),s=i(48),a=i(3),l=i(33),h=i(19),c=i(5),u=i(15),d=i(37),p=i(31),f=i(10),m=i(55),g=i(6),_=i(74),y=i(28),v=i(2),b=i(4),x=i(17),w=i(13),L=i(14),M=i(56),k=i(77),C=i(11),A=i(8),P=i(32),S=i(16),E=i(38),I=i(18)("hidden"),T=i(51),D=T.set,z=T.getterFor("Symbol"),B=C.f,O=A.f,R=k.f,j=n.Symbol,N=n.JSON,F=N&&N.stringify,G=f("toPrimitive"),U=P.f,H=u("symbol-registry"),V=u("symbols"),Z=u("op-symbols"),q=u("wks"),W=Object.prototype,K=n.QObject,Y=i(49),X=!K||!K.prototype||!K.prototype.findChild,J=o&&c((function(){return 7!=M(O({},"a",{get:function(){return O(this,"a",{value:7}).a}})).a}))?function(t,e,i){var n=B(W,e);n&&delete W[e],O(t,e,i),n&&t!==W&&O(W,e,n)}:O,Q=function(t,e){var i=V[t]=M(j.prototype);return D(i,{type:"Symbol",tag:t,description:e}),o||(i.description=e),i},$=Y&&"symbol"==typeof j.iterator?function(t){return"symbol"==typeof t}:function(t){return Object(t)instanceof j},tt=function(t,e,i){return t===W&&tt(Z,e,i),v(t),e=w(e,!0),v(i),r(V,e)?(i.enumerable?(r(t,I)&&t[I][e]&&(t[I][e]=!1),i=M(i,{enumerable:L(0,!1)})):(r(t,I)||O(t,I,L(1,{})),t[I][e]=!0),J(t,e,i)):O(t,e,i)},et=function(t,e){v(t);for(var i,n=_(e=x(e)),r=0,o=n.length;o>r;)tt(t,i=n[r++],e[i]);return t},it=function(t){var e=U.call(this,t=w(t,!0));return!(this===W&&r(V,t)&&!r(Z,t))&&(!(e||!r(this,t)||!r(V,t)||r(this,I)&&this[I][t])||e)},nt=function(t,e){if(t=x(t),e=w(e,!0),t!==W||!r(V,e)||r(Z,e)){var i=B(t,e);return!i||!r(V,e)||r(t,I)&&t[I][e]||(i.enumerable=!0),i}},rt=function(t){for(var e,i=R(x(t)),n=[],o=0;i.length>o;)r(V,e=i[o++])||r(h,e)||n.push(e);return n},ot=function(t){for(var e,i=t===W,n=R(i?Z:x(t)),o=[],s=0;n.length>s;)!r(V,e=n[s++])||i&&!r(W,e)||o.push(V[e]);return o};Y||(l((j=function(){if(this instanceof j)throw TypeError("Symbol is not a constructor");var t=void 0===arguments[0]?void 0:String(arguments[0]),e=p(t),i=function(t){this===W&&i.call(Z,t),r(this,I)&&r(this[I],e)&&(this[I][e]=!1),J(this,e,L(1,t))};return o&&X&&J(W,e,{configurable:!0,set:i}),Q(e,t)}).prototype,"toString",(function(){return z(this).tag})),P.f=it,A.f=tt,C.f=nt,i(34).f=k.f=rt,i(36).f=ot,o&&(O(j.prototype,"description",{configurable:!0,get:function(){return z(this).description}}),s||l(W,"propertyIsEnumerable",it,{unsafe:!0})),m.f=function(t){return Q(f(t),t)}),a({global:!0,wrap:!0,forced:!Y,sham:!Y},{Symbol:j});for(var st=E(q),at=0;st.length>at;)g(st[at++]);a({target:"Symbol",stat:!0,forced:!Y},{for:function(t){return r(H,t+="")?H[t]:H[t]=j(t)},keyFor:function(t){if(!$(t))throw TypeError(t+" is not a symbol");for(var e in H)if(H[e]===t)return e},useSetter:function(){X=!0},useSimple:function(){X=!1}}),a({target:"Object",stat:!0,forced:!Y,sham:!o},{create:function(t,e){return void 0===e?M(t):et(M(t),e)},defineProperty:tt,defineProperties:et,getOwnPropertyDescriptor:nt}),a({target:"Object",stat:!0,forced:!Y},{getOwnPropertyNames:rt,getOwnPropertySymbols:ot}),N&&a({target:"JSON",stat:!0,forced:!Y||c((function(){var t=j();return"[null]"!=F([t])||"{}"!=F({a:t})||"{}"!=F(Object(t))}))},{stringify:function(t){for(var e,i,n=[t],r=1;arguments.length>r;)n.push(arguments[r++]);if(i=e=n[1],(b(e)||void 0!==t)&&!$(t))return y(e)||(e=function(t,e){if("function"==typeof i&&(e=i.call(this,t,e)),!$(e))return e}),n[1]=e,F.apply(N,n)}}),j.prototype[G]||S(j.prototype,G,j.prototype.valueOf),d(j,"Symbol"),h[I]=!0},function(t,e,i){var n=i(38),r=i(36),o=i(32);t.exports=function(t){var e=n(t),i=r.f;if(i)for(var s,a=i(t),l=o.f,h=0;a.length>h;)l.call(t,s=a[h++])&&e.push(s);return e}},function(t,e,i){var n=i(9),r=i(8),o=i(2),s=i(38);t.exports=n?Object.defineProperties:function(t,e){o(t);for(var i,n=s(e),a=n.length,l=0;a>l;)r.f(t,i=n[l++],e[i]);return t}},function(t,e,i){var n=i(0).document;t.exports=n&&n.documentElement},function(t,e,i){var n=i(17),r=i(34).f,o={}.toString,s="object"==typeof window&&window&&Object.getOwnPropertyNames?Object.getOwnPropertyNames(window):[];t.exports.f=function(t){return s&&"[object Window]"==o.call(t)?function(t){try{return r(t)}catch(t){return s.slice()}}(t):r(n(t))}},function(t,e,i){i(6)("asyncIterator")},function(t,e,i){"use strict";var n=i(9),r=i(7),o=i(4),s=i(8).f,a=i(52),l=i(0).Symbol;if(n&&"function"==typeof l&&(!("description"in l.prototype)||void 0!==l().description)){var h={},c=function(){var t=arguments.length<1||void 0===arguments[0]?void 0:String(arguments[0]),e=this instanceof c?new l(t):void 0===t?l():l(t);return""===t&&(h[e]=!0),e};a(c,l);var u=c.prototype=l.prototype;u.constructor=c;var d=u.toString,p="Symbol(test)"==String(l("test")),f=/^Symbol\((.*)\)[^)]+$/;s(u,"description",{configurable:!0,get:function(){var t=o(this)?this.valueOf():this,e=d.call(t);if(r(h,t))return"";var i=p?e.slice(7,-1):e.replace(f,"$1");return""===i?void 0:i}}),i(3)({global:!0,forced:!0},{Symbol:c})}},function(t,e,i){i(6)("hasInstance")},function(t,e,i){i(6)("isConcatSpreadable")},function(t,e,i){i(6)("iterator")},function(t,e,i){i(6)("match")},function(t,e,i){i(6)("replace")},function(t,e,i){i(6)("search")},function(t,e,i){i(6)("species")},function(t,e,i){i(6)("split")},function(t,e,i){i(6)("toPrimitive")},function(t,e,i){i(6)("toStringTag")},function(t,e,i){i(6)("unscopables")},function(t,e,i){i(37)(Math,"Math",!0)},function(t,e,i){i(37)(i(0).JSON,"JSON",!0)},function(t,e,i){i(94),i(95),i(97),i(98),i(99),i(100),i(101),i(102),i(103),i(104),i(105),i(108),i(109),t.exports=i(20).Reflect},function(t,e,i){var n=i(39),r=i(2),o=(i(0).Reflect||{}).apply,s=Function.apply,a=!i(5)((function(){o((function(){}))}));i(3)({target:"Reflect",stat:!0,forced:a},{apply:function(t,e,i){return n(t),r(i),o?o(t,e,i):s.call(t,e,i)}})},function(t,e,i){var n=i(56),r=i(39),o=i(2),s=i(4),a=i(5),l=i(96),h=(i(0).Reflect||{}).construct,c=a((function(){function t(){}return!(h((function(){}),[],t)instanceof t)})),u=!a((function(){h((function(){}))})),d=c||u;i(3)({target:"Reflect",stat:!0,forced:d,sham:d},{construct:function(t,e){r(t),o(e);var i=arguments.length<3?t:r(arguments[2]);if(u&&!c)return h(t,e,i);if(t==i){switch(e.length){case 0:return new t;case 1:return new t(e[0]);case 2:return new t(e[0],e[1]);case 3:return new t(e[0],e[1],e[2]);case 4:return new t(e[0],e[1],e[2],e[3])}var a=[null];return a.push.apply(a,e),new(l.apply(t,a))}var d=i.prototype,p=n(s(d)?d:Object.prototype),f=Function.apply.call(t,p,e);return s(f)?f:p}})},function(t,e,i){"use strict";var n=i(39),r=i(4),o=[].slice,s={};t.exports=Function.bind||function(t){var e=n(this),i=o.call(arguments,1),a=function(){var n=i.concat(o.call(arguments));return this instanceof a?function(t,e,i){if(!(e in s)){for(var n=[],r=0;r<e;r++)n[r]="a["+r+"]";s[e]=Function("C,a","return new C("+n.join(",")+")")}return s[e](t,i)}(e,n.length,n):e.apply(t,n)};return r(e.prototype)&&(a.prototype=e.prototype),a}},function(t,e,i){var n=i(8),r=i(2),o=i(13),s=i(9),a=i(5)((function(){Reflect.defineProperty(n.f({},1,{value:1}),1,{value:2})}));i(3)({target:"Reflect",stat:!0,forced:a,sham:!s},{defineProperty:function(t,e,i){r(t),e=o(e,!0),r(i);try{return n.f(t,e,i),!0}catch(t){return!1}}})},function(t,e,i){var n=i(11).f,r=i(2);i(3)({target:"Reflect",stat:!0},{deleteProperty:function(t,e){var i=n(r(t),e);return!(i&&!i.configurable)&&delete t[e]}})},function(t,e,i){var n=i(11),r=i(40),o=i(7),s=i(4),a=i(2);i(3)({target:"Reflect",stat:!0},{get:function t(e,i){var l,h,c=arguments.length<3?e:arguments[2];return a(e)===c?e[i]:(l=n.f(e,i))?o(l,"value")?l.value:void 0===l.get?void 0:l.get.call(c):s(h=r(e))?t(h,i,c):void 0}})},function(t,e,i){var n=i(11),r=i(2),o=i(9);i(3)({target:"Reflect",stat:!0,sham:!o},{getOwnPropertyDescriptor:function(t,e){return n.f(r(t),e)}})},function(t,e,i){var n=i(40),r=i(2),o=i(57);i(3)({target:"Reflect",stat:!0,sham:!o},{getPrototypeOf:function(t){return n(r(t))}})},function(t,e,i){i(3)({target:"Reflect",stat:!0},{has:function(t,e){return e in t}})},function(t,e,i){var n=i(2),r=Object.isExtensible;i(3)({target:"Reflect",stat:!0},{isExtensible:function(t){return n(t),!r||r(t)}})},function(t,e,i){i(3)({target:"Reflect",stat:!0},{ownKeys:i(53)})},function(t,e,i){var n=i(106),r=i(2),o=i(107);i(3)({target:"Reflect",stat:!0,sham:!o},{preventExtensions:function(t){r(t);try{var e=n("Object","preventExtensions");return e&&e(t),!0}catch(t){return!1}}})},function(t,e,i){var n=i(20),r=i(0),o=function(t){return"function"==typeof t?t:void 0};t.exports=function(t,e){return arguments.length<2?o(n[t])||o(r[t]):n[t]&&n[t][e]||r[t]&&r[t][e]}},function(t,e,i){t.exports=!i(5)((function(){return Object.isExtensible(Object.preventExtensions({}))}))},function(t,e,i){var n=i(8),r=i(11),o=i(40),s=i(7),a=i(14),l=i(2),h=i(4);i(3)({target:"Reflect",stat:!0},{set:function t(e,i,c){var u,d,p=arguments.length<4?e:arguments[3],f=r.f(l(e),i);if(!f){if(h(d=o(e)))return t(d,i,c,p);f=a(0)}if(s(f,"value")){if(!1===f.writable||!h(p))return!1;if(u=r.f(p,i)){if(u.get||u.set||!1===u.writable)return!1;u.value=c,n.f(p,i,u)}else n.f(p,i,a(0,c));return!0}return void 0!==f.set&&(f.set.call(p,c),!0)}})},function(t,e,i){var n=i(110),r=i(58);n&&i(3)({target:"Reflect",stat:!0},{setPrototypeOf:function(t,e){r(t,e);try{return n(t,e),!0}catch(t){return!1}}})},function(t,e,i){var n=i(58);t.exports=Object.setPrototypeOf||("__proto__"in{}?function(){var t,e=!1,i={};try{(t=Object.getOwnPropertyDescriptor(Object.prototype,"__proto__").set).call(i,[]),e=i instanceof Array}catch(t){}return function(i,r){return n(i,r),e?t.call(i,r):i.__proto__=r,i}}():void 0)}]))},8487:()=>{var t,e;t=window,e=document,L.drawVersion="1.0.4",L.Draw={},L.drawLocal={draw:{toolbar:{actions:{title:"Cancel drawing",text:"Cancel"},finish:{title:"Finish drawing",text:"Finish"},undo:{title:"Delete last point drawn",text:"Delete last point"},buttons:{polyline:"Draw a polyline",polygon:"Draw a polygon",rectangle:"Draw a rectangle",circle:"Draw a circle",marker:"Draw a marker",circlemarker:"Draw a circlemarker"}},handlers:{circle:{tooltip:{start:"Click and drag to draw circle."},radius:"Radius"},circlemarker:{tooltip:{start:"Click map to place circle marker."}},marker:{tooltip:{start:"Click map to place marker."}},polygon:{tooltip:{start:"Click to start drawing shape.",cont:"Click to continue drawing shape.",end:"Click first point to close this shape."}},polyline:{error:"<strong>Error:</strong> shape edges cannot cross!",tooltip:{start:"Click to start drawing line.",cont:"Click to continue drawing line.",end:"Click last point to finish line."}},rectangle:{tooltip:{start:"Click and drag to draw rectangle."}},simpleshape:{tooltip:{end:"Release mouse to finish drawing."}}}},edit:{toolbar:{actions:{save:{title:"Save changes",text:"Save"},cancel:{title:"Cancel editing, discards all changes",text:"Cancel"},clearAll:{title:"Clear all layers",text:"Clear All"}},buttons:{edit:"Edit layers",editDisabled:"No layers to edit",remove:"Delete layers",removeDisabled:"No layers to delete"}},handlers:{edit:{tooltip:{text:"Drag handles or markers to edit features.",subtext:"Click cancel to undo changes."}},remove:{tooltip:{text:"Click on a feature to remove."}}}}},L.Draw.Event={},L.Draw.Event.CREATED="draw:created",L.Draw.Event.EDITED="draw:edited",L.Draw.Event.DELETED="draw:deleted",L.Draw.Event.DRAWSTART="draw:drawstart",L.Draw.Event.DRAWSTOP="draw:drawstop",L.Draw.Event.DRAWVERTEX="draw:drawvertex",L.Draw.Event.EDITSTART="draw:editstart",L.Draw.Event.EDITMOVE="draw:editmove",L.Draw.Event.EDITRESIZE="draw:editresize",L.Draw.Event.EDITVERTEX="draw:editvertex",L.Draw.Event.EDITSTOP="draw:editstop",L.Draw.Event.DELETESTART="draw:deletestart",L.Draw.Event.DELETESTOP="draw:deletestop",L.Draw.Event.TOOLBAROPENED="draw:toolbaropened",L.Draw.Event.TOOLBARCLOSED="draw:toolbarclosed",L.Draw.Event.MARKERCONTEXT="draw:markercontext",L.Draw=L.Draw||{},L.Draw.Feature=L.Handler.extend({initialize:function(t,e){this._map=t,this._container=t._container,this._overlayPane=t._panes.overlayPane,this._popupPane=t._panes.popupPane,e&&e.shapeOptions&&(e.shapeOptions=L.Util.extend({},this.options.shapeOptions,e.shapeOptions)),L.setOptions(this,e);var i=L.version.split(".");1===parseInt(i[0],10)&&parseInt(i[1],10)>=2?L.Draw.Feature.include(L.Evented.prototype):L.Draw.Feature.include(L.Mixin.Events)},enable:function(){this._enabled||(L.Handler.prototype.enable.call(this),this.fire("enabled",{handler:this.type}),this._map.fire(L.Draw.Event.DRAWSTART,{layerType:this.type}))},disable:function(){this._enabled&&(L.Handler.prototype.disable.call(this),this._map.fire(L.Draw.Event.DRAWSTOP,{layerType:this.type}),this.fire("disabled",{handler:this.type}))},addHooks:function(){var t=this._map;t&&(L.DomUtil.disableTextSelection(),t.getContainer().focus(),this._tooltip=new L.Draw.Tooltip(this._map),L.DomEvent.on(this._container,"keyup",this._cancelDrawing,this))},removeHooks:function(){this._map&&(L.DomUtil.enableTextSelection(),this._tooltip.dispose(),this._tooltip=null,L.DomEvent.off(this._container,"keyup",this._cancelDrawing,this))},setOptions:function(t){L.setOptions(this,t)},_fireCreatedEvent:function(t){this._map.fire(L.Draw.Event.CREATED,{layer:t,layerType:this.type})},_cancelDrawing:function(t){27===t.keyCode&&(this._map.fire("draw:canceled",{layerType:this.type}),this.disable())}}),L.Draw.Polyline=L.Draw.Feature.extend({statics:{TYPE:"polyline"},Poly:L.Polyline,options:{allowIntersection:!0,repeatMode:!1,drawError:{color:"#b00b00",timeout:2500},icon:new L.DivIcon({iconSize:new L.Point(8,8),className:"leaflet-div-icon leaflet-editing-icon"}),touchIcon:new L.DivIcon({iconSize:new L.Point(20,20),className:"leaflet-div-icon leaflet-editing-icon leaflet-touch-icon"}),guidelineDistance:20,maxGuideLineLength:4e3,shapeOptions:{stroke:!0,color:"#3388ff",weight:4,opacity:.5,fill:!1,clickable:!0},metric:!0,feet:!0,nautic:!1,showLength:!0,zIndexOffset:2e3,factor:1,maxPoints:0},initialize:function(t,e){L.Browser.touch&&(this.options.icon=this.options.touchIcon),this.options.drawError.message=L.drawLocal.draw.handlers.polyline.error,e&&e.drawError&&(e.drawError=L.Util.extend({},this.options.drawError,e.drawError)),this.type=L.Draw.Polyline.TYPE,L.Draw.Feature.prototype.initialize.call(this,t,e)},addHooks:function(){L.Draw.Feature.prototype.addHooks.call(this),this._map&&(this._markers=[],this._markerGroup=new L.LayerGroup,this._map.addLayer(this._markerGroup),this._poly=new L.Polyline([],this.options.shapeOptions),this._tooltip.updateContent(this._getTooltipText()),this._mouseMarker||(this._mouseMarker=L.marker(this._map.getCenter(),{icon:L.divIcon({className:"leaflet-mouse-marker",iconAnchor:[20,20],iconSize:[40,40]}),opacity:0,zIndexOffset:this.options.zIndexOffset})),this._mouseMarker.on("mouseout",this._onMouseOut,this).on("mousemove",this._onMouseMove,this).on("mousedown",this._onMouseDown,this).on("mouseup",this._onMouseUp,this).addTo(this._map),this._map.on("mouseup",this._onMouseUp,this).on("mousemove",this._onMouseMove,this).on("zoomlevelschange",this._onZoomEnd,this).on("touchstart",this._onTouch,this).on("zoomend",this._onZoomEnd,this))},removeHooks:function(){L.Draw.Feature.prototype.removeHooks.call(this),this._clearHideErrorTimeout(),this._cleanUpShape(),this._map.removeLayer(this._markerGroup),delete this._markerGroup,delete this._markers,this._map.removeLayer(this._poly),delete this._poly,this._mouseMarker.off("mousedown",this._onMouseDown,this).off("mouseout",this._onMouseOut,this).off("mouseup",this._onMouseUp,this).off("mousemove",this._onMouseMove,this),this._map.removeLayer(this._mouseMarker),delete this._mouseMarker,this._clearGuides(),this._map.off("mouseup",this._onMouseUp,this).off("mousemove",this._onMouseMove,this).off("zoomlevelschange",this._onZoomEnd,this).off("zoomend",this._onZoomEnd,this).off("touchstart",this._onTouch,this).off("click",this._onTouch,this)},deleteLastVertex:function(){if(!(this._markers.length<=1)){var t=this._markers.pop(),e=this._poly,i=e.getLatLngs(),n=i.splice(-1,1)[0];this._poly.setLatLngs(i),this._markerGroup.removeLayer(t),e.getLatLngs().length<2&&this._map.removeLayer(e),this._vertexChanged(n,!1)}},addVertex:function(t){this._markers.length>=2&&!this.options.allowIntersection&&this._poly.newLatLngIntersects(t)?this._showErrorTooltip():(this._errorShown&&this._hideErrorTooltip(),this._markers.push(this._createMarker(t)),this._poly.addLatLng(t),2===this._poly.getLatLngs().length&&this._map.addLayer(this._poly),this._vertexChanged(t,!0))},completeShape:function(){this._markers.length<=1||!this._shapeIsValid()||(this._fireCreatedEvent(),this.disable(),this.options.repeatMode&&this.enable())},_finishShape:function(){var t=this._poly._defaultShape?this._poly._defaultShape():this._poly.getLatLngs(),e=this._poly.newLatLngIntersects(t[t.length-1]);!this.options.allowIntersection&&e||!this._shapeIsValid()?this._showErrorTooltip():(this._fireCreatedEvent(),this.disable(),this.options.repeatMode&&this.enable())},_shapeIsValid:function(){return!0},_onZoomEnd:function(){null!==this._markers&&this._updateGuide()},_onMouseMove:function(t){var e=this._map.mouseEventToLayerPoint(t.originalEvent),i=this._map.layerPointToLatLng(e);this._currentLatLng=i,this._updateTooltip(i),this._updateGuide(e),this._mouseMarker.setLatLng(i),L.DomEvent.preventDefault(t.originalEvent)},_vertexChanged:function(t,e){this._map.fire(L.Draw.Event.DRAWVERTEX,{layers:this._markerGroup}),this._updateFinishHandler(),this._updateRunningMeasure(t,e),this._clearGuides(),this._updateTooltip()},_onMouseDown:function(t){if(!this._clickHandled&&!this._touchHandled&&!this._disableMarkers){this._onMouseMove(t),this._clickHandled=!0,this._disableNewMarkers();var e=t.originalEvent,i=e.clientX,n=e.clientY;this._startPoint.call(this,i,n)}},_startPoint:function(t,e){this._mouseDownOrigin=L.point(t,e)},_onMouseUp:function(t){var e=t.originalEvent,i=e.clientX,n=e.clientY;this._endPoint.call(this,i,n,t),this._clickHandled=null},_endPoint:function(e,i,n){if(this._mouseDownOrigin){var r=L.point(e,i).distanceTo(this._mouseDownOrigin),o=this._calculateFinishDistance(n.latlng);this.options.maxPoints>1&&this.options.maxPoints==this._markers.length+1?(this.addVertex(n.latlng),this._finishShape()):o<10&&L.Browser.touch?this._finishShape():Math.abs(r)<9*(t.devicePixelRatio||1)&&this.addVertex(n.latlng),this._enableNewMarkers()}this._mouseDownOrigin=null},_onTouch:function(t){var e,i,n=t.originalEvent;!n.touches||!n.touches[0]||this._clickHandled||this._touchHandled||this._disableMarkers||(e=n.touches[0].clientX,i=n.touches[0].clientY,this._disableNewMarkers(),this._touchHandled=!0,this._startPoint.call(this,e,i),this._endPoint.call(this,e,i,t),this._touchHandled=null),this._clickHandled=null},_onMouseOut:function(){this._tooltip&&this._tooltip._onMouseOut.call(this._tooltip)},_calculateFinishDistance:function(t){var e;if(this._markers.length>0){var i;if(this.type===L.Draw.Polyline.TYPE)i=this._markers[this._markers.length-1];else{if(this.type!==L.Draw.Polygon.TYPE)return 1/0;i=this._markers[0]}var n=this._map.latLngToContainerPoint(i.getLatLng()),r=new L.Marker(t,{icon:this.options.icon,zIndexOffset:2*this.options.zIndexOffset}),o=this._map.latLngToContainerPoint(r.getLatLng());e=n.distanceTo(o)}else e=1/0;return e},_updateFinishHandler:function(){var t=this._markers.length;t>1&&this._markers[t-1].on("click",this._finishShape,this),t>2&&this._markers[t-2].off("click",this._finishShape,this)},_createMarker:function(t){var e=new L.Marker(t,{icon:this.options.icon,zIndexOffset:2*this.options.zIndexOffset});return this._markerGroup.addLayer(e),e},_updateGuide:function(t){var e=this._markers?this._markers.length:0;e>0&&(t=t||this._map.latLngToLayerPoint(this._currentLatLng),this._clearGuides(),this._drawGuide(this._map.latLngToLayerPoint(this._markers[e-1].getLatLng()),t))},_updateTooltip:function(t){var e=this._getTooltipText();t&&this._tooltip.updatePosition(t),this._errorShown||this._tooltip.updateContent(e)},_drawGuide:function(t,e){var i,n,r,o=Math.floor(Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2))),s=this.options.guidelineDistance,a=this.options.maxGuideLineLength,l=o>a?o-a:s;for(this._guidesContainer||(this._guidesContainer=L.DomUtil.create("div","leaflet-draw-guides",this._overlayPane));l<o;l+=this.options.guidelineDistance)i=l/o,n={x:Math.floor(t.x*(1-i)+i*e.x),y:Math.floor(t.y*(1-i)+i*e.y)},(r=L.DomUtil.create("div","leaflet-draw-guide-dash",this._guidesContainer)).style.backgroundColor=this._errorShown?this.options.drawError.color:this.options.shapeOptions.color,L.DomUtil.setPosition(r,n)},_updateGuideColor:function(t){if(this._guidesContainer)for(var e=0,i=this._guidesContainer.childNodes.length;e<i;e++)this._guidesContainer.childNodes[e].style.backgroundColor=t},_clearGuides:function(){if(this._guidesContainer)for(;this._guidesContainer.firstChild;)this._guidesContainer.removeChild(this._guidesContainer.firstChild)},_getTooltipText:function(){var t,e,i=this.options.showLength;return 0===this._markers.length?t={text:L.drawLocal.draw.handlers.polyline.tooltip.start}:(e=i?this._getMeasurementString():"",t=1===this._markers.length?{text:L.drawLocal.draw.handlers.polyline.tooltip.cont,subtext:e}:{text:L.drawLocal.draw.handlers.polyline.tooltip.end,subtext:e}),t},_updateRunningMeasure:function(t,e){var i,n,r=this._markers.length;1===this._markers.length?this._measurementRunningTotal=0:(i=r-(e?2:1),n=L.GeometryUtil.isVersion07x()?t.distanceTo(this._markers[i].getLatLng())*(this.options.factor||1):this._map.distance(t,this._markers[i].getLatLng())*(this.options.factor||1),this._measurementRunningTotal+=n*(e?1:-1))},_getMeasurementString:function(){var t,e=this._currentLatLng,i=this._markers[this._markers.length-1].getLatLng();return t=L.GeometryUtil.isVersion07x()?i&&e&&e.distanceTo?this._measurementRunningTotal+e.distanceTo(i)*(this.options.factor||1):this._measurementRunningTotal||0:i&&e?this._measurementRunningTotal+this._map.distance(e,i)*(this.options.factor||1):this._measurementRunningTotal||0,L.GeometryUtil.readableDistance(t,this.options.metric,this.options.feet,this.options.nautic,this.options.precision)},_showErrorTooltip:function(){this._errorShown=!0,this._tooltip.showAsError().updateContent({text:this.options.drawError.message}),this._updateGuideColor(this.options.drawError.color),this._poly.setStyle({color:this.options.drawError.color}),this._clearHideErrorTimeout(),this._hideErrorTimeout=setTimeout(L.Util.bind(this._hideErrorTooltip,this),this.options.drawError.timeout)},_hideErrorTooltip:function(){this._errorShown=!1,this._clearHideErrorTimeout(),this._tooltip.removeError().updateContent(this._getTooltipText()),this._updateGuideColor(this.options.shapeOptions.color),this._poly.setStyle({color:this.options.shapeOptions.color})},_clearHideErrorTimeout:function(){this._hideErrorTimeout&&(clearTimeout(this._hideErrorTimeout),this._hideErrorTimeout=null)},_disableNewMarkers:function(){this._disableMarkers=!0},_enableNewMarkers:function(){setTimeout(function(){this._disableMarkers=!1}.bind(this),50)},_cleanUpShape:function(){this._markers.length>1&&this._markers[this._markers.length-1].off("click",this._finishShape,this)},_fireCreatedEvent:function(){var t=new this.Poly(this._poly.getLatLngs(),this.options.shapeOptions);L.Draw.Feature.prototype._fireCreatedEvent.call(this,t)}}),L.Draw.Polygon=L.Draw.Polyline.extend({statics:{TYPE:"polygon"},Poly:L.Polygon,options:{showArea:!1,showLength:!1,shapeOptions:{stroke:!0,color:"#3388ff",weight:4,opacity:.5,fill:!0,fillColor:null,fillOpacity:.2,clickable:!0},metric:!0,feet:!0,nautic:!1,precision:{}},initialize:function(t,e){L.Draw.Polyline.prototype.initialize.call(this,t,e),this.type=L.Draw.Polygon.TYPE},_updateFinishHandler:function(){var t=this._markers.length;1===t&&this._markers[0].on("click",this._finishShape,this),t>2&&(this._markers[t-1].on("dblclick",this._finishShape,this),t>3&&this._markers[t-2].off("dblclick",this._finishShape,this))},_getTooltipText:function(){var t,e;return 0===this._markers.length?t=L.drawLocal.draw.handlers.polygon.tooltip.start:this._markers.length<3?(t=L.drawLocal.draw.handlers.polygon.tooltip.cont,e=this._getMeasurementString()):(t=L.drawLocal.draw.handlers.polygon.tooltip.end,e=this._getMeasurementString()),{text:t,subtext:e}},_getMeasurementString:function(){var t=this._area,e="";return t||this.options.showLength?(this.options.showLength&&(e=L.Draw.Polyline.prototype._getMeasurementString.call(this)),t&&(e+="<br>"+L.GeometryUtil.readableArea(t,this.options.metric,this.options.precision)),e):null},_shapeIsValid:function(){return this._markers.length>=3},_vertexChanged:function(t,e){var i;!this.options.allowIntersection&&this.options.showArea&&(i=this._poly.getLatLngs(),this._area=L.GeometryUtil.geodesicArea(i)),L.Draw.Polyline.prototype._vertexChanged.call(this,t,e)},_cleanUpShape:function(){var t=this._markers.length;t>0&&(this._markers[0].off("click",this._finishShape,this),t>2&&this._markers[t-1].off("dblclick",this._finishShape,this))}}),L.SimpleShape={},L.Draw.SimpleShape=L.Draw.Feature.extend({options:{repeatMode:!1},initialize:function(t,e){this._endLabelText=L.drawLocal.draw.handlers.simpleshape.tooltip.end,L.Draw.Feature.prototype.initialize.call(this,t,e)},addHooks:function(){L.Draw.Feature.prototype.addHooks.call(this),this._map&&(this._mapDraggable=this._map.dragging.enabled(),this._mapDraggable&&this._map.dragging.disable(),this._container.style.cursor="crosshair",this._tooltip.updateContent({text:this._initialLabelText}),this._map.on("mousedown",this._onMouseDown,this).on("mousemove",this._onMouseMove,this).on("touchstart",this._onMouseDown,this).on("touchmove",this._onMouseMove,this),e.addEventListener("touchstart",L.DomEvent.preventDefault,{passive:!1}))},removeHooks:function(){L.Draw.Feature.prototype.removeHooks.call(this),this._map&&(this._mapDraggable&&this._map.dragging.enable(),this._container.style.cursor="",this._map.off("mousedown",this._onMouseDown,this).off("mousemove",this._onMouseMove,this).off("touchstart",this._onMouseDown,this).off("touchmove",this._onMouseMove,this),L.DomEvent.off(e,"mouseup",this._onMouseUp,this),L.DomEvent.off(e,"touchend",this._onMouseUp,this),e.removeEventListener("touchstart",L.DomEvent.preventDefault),this._shape&&(this._map.removeLayer(this._shape),delete this._shape)),this._isDrawing=!1},_getTooltipText:function(){return{text:this._endLabelText}},_onMouseDown:function(t){this._isDrawing=!0,this._startLatLng=t.latlng,L.DomEvent.on(e,"mouseup",this._onMouseUp,this).on(e,"touchend",this._onMouseUp,this).preventDefault(t.originalEvent)},_onMouseMove:function(t){var e=t.latlng;this._tooltip.updatePosition(e),this._isDrawing&&(this._tooltip.updateContent(this._getTooltipText()),this._drawShape(e))},_onMouseUp:function(){this._shape&&this._fireCreatedEvent(),this.disable(),this.options.repeatMode&&this.enable()}}),L.Draw.Rectangle=L.Draw.SimpleShape.extend({statics:{TYPE:"rectangle"},options:{shapeOptions:{stroke:!0,color:"#3388ff",weight:4,opacity:.5,fill:!0,fillColor:null,fillOpacity:.2,clickable:!0},showArea:!0,metric:!0},initialize:function(t,e){this.type=L.Draw.Rectangle.TYPE,this._initialLabelText=L.drawLocal.draw.handlers.rectangle.tooltip.start,L.Draw.SimpleShape.prototype.initialize.call(this,t,e)},disable:function(){this._enabled&&(this._isCurrentlyTwoClickDrawing=!1,L.Draw.SimpleShape.prototype.disable.call(this))},_onMouseUp:function(t){this._shape||this._isCurrentlyTwoClickDrawing?this._isCurrentlyTwoClickDrawing&&!function(t,e){for(;(t=t.parentElement)&&!t.classList.contains("leaflet-pane"););return t}(t.target)||L.Draw.SimpleShape.prototype._onMouseUp.call(this):this._isCurrentlyTwoClickDrawing=!0},_drawShape:function(t){this._shape?this._shape.setBounds(new L.LatLngBounds(this._startLatLng,t)):(this._shape=new L.Rectangle(new L.LatLngBounds(this._startLatLng,t),this.options.shapeOptions),this._map.addLayer(this._shape))},_fireCreatedEvent:function(){var t=new L.Rectangle(this._shape.getBounds(),this.options.shapeOptions);L.Draw.SimpleShape.prototype._fireCreatedEvent.call(this,t)},_getTooltipText:function(){var t,e,i,n=L.Draw.SimpleShape.prototype._getTooltipText.call(this),r=this._shape,o=this.options.showArea;return r&&(t=this._shape._defaultShape?this._shape._defaultShape():this._shape.getLatLngs(),e=L.GeometryUtil.geodesicArea(t),i=o?L.GeometryUtil.readableArea(e,this.options.metric):""),{text:n.text,subtext:i}}}),L.Draw.Marker=L.Draw.Feature.extend({statics:{TYPE:"marker"},options:{icon:new L.Icon.Default,repeatMode:!1,zIndexOffset:2e3},initialize:function(t,e){this.type=L.Draw.Marker.TYPE,this._initialLabelText=L.drawLocal.draw.handlers.marker.tooltip.start,L.Draw.Feature.prototype.initialize.call(this,t,e)},addHooks:function(){L.Draw.Feature.prototype.addHooks.call(this),this._map&&(this._tooltip.updateContent({text:this._initialLabelText}),this._mouseMarker||(this._mouseMarker=L.marker(this._map.getCenter(),{icon:L.divIcon({className:"leaflet-mouse-marker",iconAnchor:[20,20],iconSize:[40,40]}),opacity:0,zIndexOffset:this.options.zIndexOffset})),this._mouseMarker.on("click",this._onClick,this).addTo(this._map),this._map.on("mousemove",this._onMouseMove,this),this._map.on("click",this._onTouch,this))},removeHooks:function(){L.Draw.Feature.prototype.removeHooks.call(this),this._map&&(this._map.off("click",this._onClick,this).off("click",this._onTouch,this),this._marker&&(this._marker.off("click",this._onClick,this),this._map.removeLayer(this._marker),delete this._marker),this._mouseMarker.off("click",this._onClick,this),this._map.removeLayer(this._mouseMarker),delete this._mouseMarker,this._map.off("mousemove",this._onMouseMove,this))},_onMouseMove:function(t){var e=t.latlng;this._tooltip.updatePosition(e),this._mouseMarker.setLatLng(e),this._marker?(e=this._mouseMarker.getLatLng(),this._marker.setLatLng(e)):(this._marker=this._createMarker(e),this._marker.on("click",this._onClick,this),this._map.on("click",this._onClick,this).addLayer(this._marker))},_createMarker:function(t){return new L.Marker(t,{icon:this.options.icon,zIndexOffset:this.options.zIndexOffset})},_onClick:function(){this._fireCreatedEvent(),this.disable(),this.options.repeatMode&&this.enable()},_onTouch:function(t){this._onMouseMove(t),this._onClick()},_fireCreatedEvent:function(){var t=new L.Marker.Touch(this._marker.getLatLng(),{icon:this.options.icon});L.Draw.Feature.prototype._fireCreatedEvent.call(this,t)}}),L.Draw.CircleMarker=L.Draw.Marker.extend({statics:{TYPE:"circlemarker"},options:{stroke:!0,color:"#3388ff",weight:4,opacity:.5,fill:!0,fillColor:null,fillOpacity:.2,clickable:!0,zIndexOffset:2e3},initialize:function(t,e){this.type=L.Draw.CircleMarker.TYPE,this._initialLabelText=L.drawLocal.draw.handlers.circlemarker.tooltip.start,L.Draw.Feature.prototype.initialize.call(this,t,e)},_fireCreatedEvent:function(){var t=new L.CircleMarker(this._marker.getLatLng(),this.options);L.Draw.Feature.prototype._fireCreatedEvent.call(this,t)},_createMarker:function(t){return new L.CircleMarker(t,this.options)}}),L.Draw.Circle=L.Draw.SimpleShape.extend({statics:{TYPE:"circle"},options:{shapeOptions:{stroke:!0,color:"#3388ff",weight:4,opacity:.5,fill:!0,fillColor:null,fillOpacity:.2,clickable:!0},showRadius:!0,metric:!0,feet:!0,nautic:!1},initialize:function(t,e){this.type=L.Draw.Circle.TYPE,this._initialLabelText=L.drawLocal.draw.handlers.circle.tooltip.start,L.Draw.SimpleShape.prototype.initialize.call(this,t,e)},_drawShape:function(t){if(L.GeometryUtil.isVersion07x())var e=this._startLatLng.distanceTo(t);else e=this._map.distance(this._startLatLng,t);this._shape?this._shape.setRadius(e):(this._shape=new L.Circle(this._startLatLng,e,this.options.shapeOptions),this._map.addLayer(this._shape))},_fireCreatedEvent:function(){var t=new L.Circle(this._startLatLng,this._shape.getRadius(),this.options.shapeOptions);L.Draw.SimpleShape.prototype._fireCreatedEvent.call(this,t)},_onMouseMove:function(t){var e,i=t.latlng,n=this.options.showRadius,r=this.options.metric;if(this._tooltip.updatePosition(i),this._isDrawing){this._drawShape(i),e=this._shape.getRadius().toFixed(1);var o="";n&&(o=L.drawLocal.draw.handlers.circle.radius+": "+L.GeometryUtil.readableDistance(e,r,this.options.feet,this.options.nautic)),this._tooltip.updateContent({text:this._endLabelText,subtext:o})}}}),L.Edit=L.Edit||{},L.Edit.Marker=L.Handler.extend({initialize:function(t,e){this._marker=t,L.setOptions(this,e)},addHooks:function(){var t=this._marker;t.dragging.enable(),t.on("dragend",this._onDragEnd,t),this._toggleMarkerHighlight()},removeHooks:function(){var t=this._marker;t.dragging.disable(),t.off("dragend",this._onDragEnd,t),this._toggleMarkerHighlight()},_onDragEnd:function(t){var e=t.target;e.edited=!0,this._map.fire(L.Draw.Event.EDITMOVE,{layer:e})},_toggleMarkerHighlight:function(){var t=this._marker._icon;t&&(t.style.display="none",L.DomUtil.hasClass(t,"leaflet-edit-marker-selected")?(L.DomUtil.removeClass(t,"leaflet-edit-marker-selected"),this._offsetMarker(t,-4)):(L.DomUtil.addClass(t,"leaflet-edit-marker-selected"),this._offsetMarker(t,4)),t.style.display="")},_offsetMarker:function(t,e){var i=parseInt(t.style.marginTop,10)-e,n=parseInt(t.style.marginLeft,10)-e;t.style.marginTop=i+"px",t.style.marginLeft=n+"px"}}),L.Marker.addInitHook((function(){L.Edit.Marker&&(this.editing=new L.Edit.Marker(this),this.options.editable&&this.editing.enable())})),L.Edit=L.Edit||{},L.Edit.Poly=L.Handler.extend({initialize:function(t){this.latlngs=[t._latlngs],t._holes&&(this.latlngs=this.latlngs.concat(t._holes)),this._poly=t,this._poly.on("revert-edited",this._updateLatLngs,this)},_defaultShape:function(){return L.Polyline._flat?L.Polyline._flat(this._poly._latlngs)?this._poly._latlngs:this._poly._latlngs[0]:this._poly._latlngs},_eachVertexHandler:function(t){for(var e=0;e<this._verticesHandlers.length;e++)t(this._verticesHandlers[e])},addHooks:function(){this._initHandlers(),this._eachVertexHandler((function(t){t.addHooks()}))},removeHooks:function(){this._eachVertexHandler((function(t){t.removeHooks()}))},updateMarkers:function(){this._eachVertexHandler((function(t){t.updateMarkers()}))},_initHandlers:function(){this._verticesHandlers=[];for(var t=0;t<this.latlngs.length;t++)this._verticesHandlers.push(new L.Edit.PolyVerticesEdit(this._poly,this.latlngs[t],this._poly.options.poly))},_updateLatLngs:function(t){this.latlngs=[t.layer._latlngs],t.layer._holes&&(this.latlngs=this.latlngs.concat(t.layer._holes))}}),L.Edit.PolyVerticesEdit=L.Handler.extend({options:{icon:new L.DivIcon({iconSize:new L.Point(8,8),className:"leaflet-div-icon leaflet-editing-icon"}),touchIcon:new L.DivIcon({iconSize:new L.Point(20,20),className:"leaflet-div-icon leaflet-editing-icon leaflet-touch-icon"}),drawError:{color:"#b00b00",timeout:1e3}},initialize:function(t,e,i){L.Browser.touch&&(this.options.icon=this.options.touchIcon),this._poly=t,i&&i.drawError&&(i.drawError=L.Util.extend({},this.options.drawError,i.drawError)),this._latlngs=e,L.setOptions(this,i)},_defaultShape:function(){return L.Polyline._flat?L.Polyline._flat(this._latlngs)?this._latlngs:this._latlngs[0]:this._latlngs},addHooks:function(){var t=this._poly,e=t._path;t instanceof L.Polygon||(t.options.fill=!1,t.options.editing&&(t.options.editing.fill=!1)),e&&t.options.editing&&t.options.editing.className&&(t.options.original.className&&t.options.original.className.split(" ").forEach((function(t){L.DomUtil.removeClass(e,t)})),t.options.editing.className.split(" ").forEach((function(t){L.DomUtil.addClass(e,t)}))),t.setStyle(t.options.editing),this._poly._map&&(this._map=this._poly._map,this._markerGroup||this._initMarkers(),this._poly._map.addLayer(this._markerGroup))},removeHooks:function(){var t=this._poly,e=t._path;e&&t.options.editing&&t.options.editing.className&&(t.options.editing.className.split(" ").forEach((function(t){L.DomUtil.removeClass(e,t)})),t.options.original.className&&t.options.original.className.split(" ").forEach((function(t){L.DomUtil.addClass(e,t)}))),t.setStyle(t.options.original),t._map&&(t._map.removeLayer(this._markerGroup),delete this._markerGroup,delete this._markers)},updateMarkers:function(){this._markerGroup.clearLayers(),this._initMarkers()},_initMarkers:function(){this._markerGroup||(this._markerGroup=new L.LayerGroup),this._markers=[];var t,e,i,n,r,o,s=this._defaultShape();for(t=0,i=s.length;t<i;t++)(n=this._createMarker(s[t],t)).on("click",this._onMarkerClick,this),n.on("contextmenu",this._onContextMenu,this),this._markers.push(n);for(t=0,e=i-1;t<i;e=t++)(0!==t||L.Polygon&&this._poly instanceof L.Polygon)&&(r=this._markers[e],o=this._markers[t],this._createMiddleMarker(r,o),this._updatePrevNext(r,o))},_createMarker:function(t,e){var i=new L.Marker.Touch(t,{draggable:!0,icon:this.options.icon});return i._origLatLng=t,i._index=e,i.on("dragstart",this._onMarkerDragStart,this).on("drag",this._onMarkerDrag,this).on("dragend",this._fireEdit,this).on("touchmove",this._onTouchMove,this).on("touchend",this._fireEdit,this).on("MSPointerMove",this._onTouchMove,this).on("MSPointerUp",this._fireEdit,this),this._markerGroup.addLayer(i),i},_onMarkerDragStart:function(){this._poly.fire("editstart")},_spliceLatLngs:function(){var t=this._defaultShape(),e=[].splice.apply(t,arguments);return this._poly._convertLatLngs(t,!0),this._poly.redraw(),e},_removeMarker:function(t){var e=t._index;this._markerGroup.removeLayer(t),this._markers.splice(e,1),this._spliceLatLngs(e,1),this._updateIndexes(e,-1),t.off("dragstart",this._onMarkerDragStart,this).off("drag",this._onMarkerDrag,this).off("dragend",this._fireEdit,this).off("touchmove",this._onMarkerDrag,this).off("touchend",this._fireEdit,this).off("click",this._onMarkerClick,this).off("MSPointerMove",this._onTouchMove,this).off("MSPointerUp",this._fireEdit,this)},_fireEdit:function(){this._poly.edited=!0,this._poly.fire("edit"),this._poly._map.fire(L.Draw.Event.EDITVERTEX,{layers:this._markerGroup,poly:this._poly})},_onMarkerDrag:function(t){var e=t.target,i=this._poly,n=L.LatLngUtil.cloneLatLng(e._origLatLng);if(L.extend(e._origLatLng,e._latlng),i.options.poly){var r=i._map._editTooltip;if(!i.options.poly.allowIntersection&&i.intersects()){L.extend(e._origLatLng,n),e.setLatLng(n);var o=i.options.color;i.setStyle({color:this.options.drawError.color}),r&&r.updateContent({text:L.drawLocal.draw.handlers.polyline.error}),setTimeout((function(){i.setStyle({color:o}),r&&r.updateContent({text:L.drawLocal.edit.handlers.edit.tooltip.text,subtext:L.drawLocal.edit.handlers.edit.tooltip.subtext})}),1e3)}}e._middleLeft&&e._middleLeft.setLatLng(this._getMiddleLatLng(e._prev,e)),e._middleRight&&e._middleRight.setLatLng(this._getMiddleLatLng(e,e._next)),this._poly._bounds._southWest=L.latLng(1/0,1/0),this._poly._bounds._northEast=L.latLng(-1/0,-1/0);var s=this._poly.getLatLngs();this._poly._convertLatLngs(s,!0),this._poly.redraw(),this._poly.fire("editdrag")},_onMarkerClick:function(t){var e=L.Polygon&&this._poly instanceof L.Polygon?4:3,i=t.target;this._defaultShape().length<e||(this._removeMarker(i),this._updatePrevNext(i._prev,i._next),i._middleLeft&&this._markerGroup.removeLayer(i._middleLeft),i._middleRight&&this._markerGroup.removeLayer(i._middleRight),i._prev&&i._next?this._createMiddleMarker(i._prev,i._next):i._prev?i._next||(i._prev._middleRight=null):i._next._middleLeft=null,this._fireEdit())},_onContextMenu:function(t){var e=t.target;this._poly,this._poly._map.fire(L.Draw.Event.MARKERCONTEXT,{marker:e,layers:this._markerGroup,poly:this._poly}),L.DomEvent.stopPropagation},_onTouchMove:function(t){var e=this._map.mouseEventToLayerPoint(t.originalEvent.touches[0]),i=this._map.layerPointToLatLng(e),n=t.target;L.extend(n._origLatLng,i),n._middleLeft&&n._middleLeft.setLatLng(this._getMiddleLatLng(n._prev,n)),n._middleRight&&n._middleRight.setLatLng(this._getMiddleLatLng(n,n._next)),this._poly.redraw(),this.updateMarkers()},_updateIndexes:function(t,e){this._markerGroup.eachLayer((function(i){i._index>t&&(i._index+=e)}))},_createMiddleMarker:function(t,e){var i,n,r,o=this._getMiddleLatLng(t,e),s=this._createMarker(o);s.setOpacity(.6),t._middleRight=e._middleLeft=s,n=function(){s.off("touchmove",n,this);var r=e._index;s._index=r,s.off("click",i,this).on("click",this._onMarkerClick,this),o.lat=s.getLatLng().lat,o.lng=s.getLatLng().lng,this._spliceLatLngs(r,0,o),this._markers.splice(r,0,s),s.setOpacity(1),this._updateIndexes(r,1),e._index++,this._updatePrevNext(t,s),this._updatePrevNext(s,e),this._poly.fire("editstart")},r=function(){s.off("dragstart",n,this),s.off("dragend",r,this),s.off("touchmove",n,this),this._createMiddleMarker(t,s),this._createMiddleMarker(s,e)},i=function(){n.call(this),r.call(this),this._fireEdit()},s.on("click",i,this).on("dragstart",n,this).on("dragend",r,this).on("touchmove",n,this),this._markerGroup.addLayer(s)},_updatePrevNext:function(t,e){t&&(t._next=e),e&&(e._prev=t)},_getMiddleLatLng:function(t,e){var i=this._poly._map,n=i.project(t.getLatLng()),r=i.project(e.getLatLng());return i.unproject(n._add(r)._divideBy(2))}}),L.Polyline.addInitHook((function(){this.editing||(L.Edit.Poly&&(this.editing=new L.Edit.Poly(this),this.options.editable&&this.editing.enable()),this.on("add",(function(){this.editing&&this.editing.enabled()&&this.editing.addHooks()})),this.on("remove",(function(){this.editing&&this.editing.enabled()&&this.editing.removeHooks()})))})),L.Edit=L.Edit||{},L.Edit.SimpleShape=L.Handler.extend({options:{moveIcon:new L.DivIcon({iconSize:new L.Point(8,8),className:"leaflet-div-icon leaflet-editing-icon leaflet-edit-move"}),resizeIcon:new L.DivIcon({iconSize:new L.Point(8,8),className:"leaflet-div-icon leaflet-editing-icon leaflet-edit-resize"}),touchMoveIcon:new L.DivIcon({iconSize:new L.Point(20,20),className:"leaflet-div-icon leaflet-editing-icon leaflet-edit-move leaflet-touch-icon"}),touchResizeIcon:new L.DivIcon({iconSize:new L.Point(20,20),className:"leaflet-div-icon leaflet-editing-icon leaflet-edit-resize leaflet-touch-icon"})},initialize:function(t,e){L.Browser.touch&&(this.options.moveIcon=this.options.touchMoveIcon,this.options.resizeIcon=this.options.touchResizeIcon),this._shape=t,L.Util.setOptions(this,e)},addHooks:function(){var t=this._shape;this._shape._map&&(this._map=this._shape._map,t.setStyle(t.options.editing),t._map&&(this._map=t._map,this._markerGroup||this._initMarkers(),this._map.addLayer(this._markerGroup)))},removeHooks:function(){var t=this._shape;if(t.setStyle(t.options.original),t._map){this._unbindMarker(this._moveMarker);for(var e=0,i=this._resizeMarkers.length;e<i;e++)this._unbindMarker(this._resizeMarkers[e]);this._resizeMarkers=null,this._map.removeLayer(this._markerGroup),delete this._markerGroup}this._map=null},updateMarkers:function(){this._markerGroup.clearLayers(),this._initMarkers()},_initMarkers:function(){this._markerGroup||(this._markerGroup=new L.LayerGroup),this._createMoveMarker(),this._createResizeMarker()},_createMoveMarker:function(){},_createResizeMarker:function(){},_createMarker:function(t,e){var i=new L.Marker.Touch(t,{draggable:!0,icon:e,zIndexOffset:10});return this._bindMarker(i),this._markerGroup.addLayer(i),i},_bindMarker:function(t){t.on("dragstart",this._onMarkerDragStart,this).on("drag",this._onMarkerDrag,this).on("dragend",this._onMarkerDragEnd,this).on("touchstart",this._onTouchStart,this).on("touchmove",this._onTouchMove,this).on("MSPointerMove",this._onTouchMove,this).on("touchend",this._onTouchEnd,this).on("MSPointerUp",this._onTouchEnd,this)},_unbindMarker:function(t){t.off("dragstart",this._onMarkerDragStart,this).off("drag",this._onMarkerDrag,this).off("dragend",this._onMarkerDragEnd,this).off("touchstart",this._onTouchStart,this).off("touchmove",this._onTouchMove,this).off("MSPointerMove",this._onTouchMove,this).off("touchend",this._onTouchEnd,this).off("MSPointerUp",this._onTouchEnd,this)},_onMarkerDragStart:function(t){t.target.setOpacity(0),this._shape.fire("editstart")},_fireEdit:function(){this._shape.edited=!0,this._shape.fire("edit")},_onMarkerDrag:function(t){var e=t.target,i=e.getLatLng();e===this._moveMarker?this._move(i):this._resize(i),this._shape.redraw(),this._shape.fire("editdrag")},_onMarkerDragEnd:function(t){t.target.setOpacity(1),this._fireEdit()},_onTouchStart:function(t){if(L.Edit.SimpleShape.prototype._onMarkerDragStart.call(this,t),"function"==typeof this._getCorners){var e=this._getCorners(),i=t.target,n=i._cornerIndex;i.setOpacity(0),this._oppositeCorner=e[(n+2)%4],this._toggleCornerMarkers(0,n)}this._shape.fire("editstart")},_onTouchMove:function(t){var e=this._map.mouseEventToLayerPoint(t.originalEvent.touches[0]),i=this._map.layerPointToLatLng(e);return t.target===this._moveMarker?this._move(i):this._resize(i),this._shape.redraw(),!1},_onTouchEnd:function(t){t.target.setOpacity(1),this.updateMarkers(),this._fireEdit()},_move:function(){},_resize:function(){}}),L.Edit=L.Edit||{},L.Edit.Rectangle=L.Edit.SimpleShape.extend({_createMoveMarker:function(){var t=this._shape.getBounds().getCenter();this._moveMarker=this._createMarker(t,this.options.moveIcon)},_createResizeMarker:function(){var t=this._getCorners();this._resizeMarkers=[];for(var e=0,i=t.length;e<i;e++)this._resizeMarkers.push(this._createMarker(t[e],this.options.resizeIcon)),this._resizeMarkers[e]._cornerIndex=e},_onMarkerDragStart:function(t){L.Edit.SimpleShape.prototype._onMarkerDragStart.call(this,t);var e=this._getCorners(),i=t.target._cornerIndex;this._oppositeCorner=e[(i+2)%4],this._toggleCornerMarkers(0,i)},_onMarkerDragEnd:function(t){var e,i=t.target;i===this._moveMarker&&(e=this._shape.getBounds().getCenter(),i.setLatLng(e)),this._toggleCornerMarkers(1),this._repositionCornerMarkers(),L.Edit.SimpleShape.prototype._onMarkerDragEnd.call(this,t)},_move:function(t){for(var e,i=this._shape._defaultShape?this._shape._defaultShape():this._shape.getLatLngs(),n=this._shape.getBounds().getCenter(),r=[],o=0,s=i.length;o<s;o++)e=[i[o].lat-n.lat,i[o].lng-n.lng],r.push([t.lat+e[0],t.lng+e[1]]);this._shape.setLatLngs(r),this._repositionCornerMarkers(),this._map.fire(L.Draw.Event.EDITMOVE,{layer:this._shape})},_resize:function(t){var e;this._shape.setBounds(L.latLngBounds(t,this._oppositeCorner)),e=this._shape.getBounds(),this._moveMarker.setLatLng(e.getCenter()),this._map.fire(L.Draw.Event.EDITRESIZE,{layer:this._shape})},_getCorners:function(){var t=this._shape.getBounds();return[t.getNorthWest(),t.getNorthEast(),t.getSouthEast(),t.getSouthWest()]},_toggleCornerMarkers:function(t){for(var e=0,i=this._resizeMarkers.length;e<i;e++)this._resizeMarkers[e].setOpacity(t)},_repositionCornerMarkers:function(){for(var t=this._getCorners(),e=0,i=this._resizeMarkers.length;e<i;e++)this._resizeMarkers[e].setLatLng(t[e])}}),L.Rectangle.addInitHook((function(){L.Edit.Rectangle&&(this.editing=new L.Edit.Rectangle(this),this.options.editable&&this.editing.enable())})),L.Edit=L.Edit||{},L.Edit.CircleMarker=L.Edit.SimpleShape.extend({_createMoveMarker:function(){var t=this._shape.getLatLng();this._moveMarker=this._createMarker(t,this.options.moveIcon)},_createResizeMarker:function(){this._resizeMarkers=[]},_move:function(t){if(this._resizeMarkers.length){var e=this._getResizeMarkerPoint(t);this._resizeMarkers[0].setLatLng(e)}this._shape.setLatLng(t),this._map.fire(L.Draw.Event.EDITMOVE,{layer:this._shape})}}),L.CircleMarker.addInitHook((function(){L.Edit.CircleMarker&&(this.editing=new L.Edit.CircleMarker(this),this.options.editable&&this.editing.enable()),this.on("add",(function(){this.editing&&this.editing.enabled()&&this.editing.addHooks()})),this.on("remove",(function(){this.editing&&this.editing.enabled()&&this.editing.removeHooks()}))})),L.Edit=L.Edit||{},L.Edit.Circle=L.Edit.CircleMarker.extend({_createResizeMarker:function(){var t=this._shape.getLatLng(),e=this._getResizeMarkerPoint(t);this._resizeMarkers=[],this._resizeMarkers.push(this._createMarker(e,this.options.resizeIcon))},_getResizeMarkerPoint:function(t){var e=this._shape._radius*Math.cos(Math.PI/4),i=this._map.project(t);return this._map.unproject([i.x+e,i.y-e])},_resize:function(t){var e=this._moveMarker.getLatLng();L.GeometryUtil.isVersion07x()?radius=e.distanceTo(t):radius=this._map.distance(e,t),this._shape.setRadius(radius),this._map.editTooltip&&this._map._editTooltip.updateContent({text:L.drawLocal.edit.handlers.edit.tooltip.subtext+"<br />"+L.drawLocal.edit.handlers.edit.tooltip.text,subtext:L.drawLocal.draw.handlers.circle.radius+": "+L.GeometryUtil.readableDistance(radius,!0,this.options.feet,this.options.nautic)}),this._shape.setRadius(radius),this._map.fire(L.Draw.Event.EDITRESIZE,{layer:this._shape})}}),L.Circle.addInitHook((function(){L.Edit.Circle&&(this.editing=new L.Edit.Circle(this),this.options.editable&&this.editing.enable())})),L.Map.mergeOptions({touchExtend:!0}),L.Map.TouchExtend=L.Handler.extend({initialize:function(t){this._map=t,this._container=t._container,this._pane=t._panes.overlayPane},addHooks:function(){L.DomEvent.on(this._container,"touchstart",this._onTouchStart,this),L.DomEvent.on(this._container,"touchend",this._onTouchEnd,this),L.DomEvent.on(this._container,"touchmove",this._onTouchMove,this),this._detectIE()?(L.DomEvent.on(this._container,"MSPointerDown",this._onTouchStart,this),L.DomEvent.on(this._container,"MSPointerUp",this._onTouchEnd,this),L.DomEvent.on(this._container,"MSPointerMove",this._onTouchMove,this),L.DomEvent.on(this._container,"MSPointerCancel",this._onTouchCancel,this)):(L.DomEvent.on(this._container,"touchcancel",this._onTouchCancel,this),L.DomEvent.on(this._container,"touchleave",this._onTouchLeave,this))},removeHooks:function(){L.DomEvent.off(this._container,"touchstart",this._onTouchStart,this),L.DomEvent.off(this._container,"touchend",this._onTouchEnd,this),L.DomEvent.off(this._container,"touchmove",this._onTouchMove,this),this._detectIE()?(L.DomEvent.off(this._container,"MSPointerDown",this._onTouchStart,this),L.DomEvent.off(this._container,"MSPointerUp",this._onTouchEnd,this),L.DomEvent.off(this._container,"MSPointerMove",this._onTouchMove,this),L.DomEvent.off(this._container,"MSPointerCancel",this._onTouchCancel,this)):(L.DomEvent.off(this._container,"touchcancel",this._onTouchCancel,this),L.DomEvent.off(this._container,"touchleave",this._onTouchLeave,this))},_touchEvent:function(t,e){var i={};if(void 0!==t.touches){if(!t.touches.length)return;i=t.touches[0]}else{if("touch"!==t.pointerType)return;if(i=t,!this._filterClick(t))return}var n=this._map.mouseEventToContainerPoint(i),r=this._map.mouseEventToLayerPoint(i),o=this._map.layerPointToLatLng(r);this._map.fire(e,{latlng:o,layerPoint:r,containerPoint:n,pageX:i.pageX,pageY:i.pageY,originalEvent:t})},_filterClick:function(t){var e=t.timeStamp||t.originalEvent.timeStamp,i=L.DomEvent._lastClick&&e-L.DomEvent._lastClick;return i&&i>100&&i<500||t.target._simulatedClick&&!t._simulated?(L.DomEvent.stop(t),!1):(L.DomEvent._lastClick=e,!0)},_onTouchStart:function(t){this._map._loaded&&this._touchEvent(t,"touchstart")},_onTouchEnd:function(t){this._map._loaded&&this._touchEvent(t,"touchend")},_onTouchCancel:function(t){if(this._map._loaded){var e="touchcancel";this._detectIE()&&(e="pointercancel"),this._touchEvent(t,e)}},_onTouchLeave:function(t){this._map._loaded&&this._touchEvent(t,"touchleave")},_onTouchMove:function(t){this._map._loaded&&this._touchEvent(t,"touchmove")},_detectIE:function(){var e=t.navigator.userAgent,i=e.indexOf("MSIE ");if(i>0)return parseInt(e.substring(i+5,e.indexOf(".",i)),10);if(e.indexOf("Trident/")>0){var n=e.indexOf("rv:");return parseInt(e.substring(n+3,e.indexOf(".",n)),10)}var r=e.indexOf("Edge/");return r>0&&parseInt(e.substring(r+5,e.indexOf(".",r)),10)}}),L.Map.addInitHook("addHandler","touchExtend",L.Map.TouchExtend),L.Marker.Touch=L.Marker.extend({_initInteraction:function(){return this.addInteractiveTarget?L.Marker.prototype._initInteraction.apply(this):this._initInteractionLegacy()},_initInteractionLegacy:function(){if(this.options.clickable){var t=this._icon,e=["dblclick","mousedown","mouseover","mouseout","contextmenu","touchstart","touchend","touchmove"];this._detectIE?e.concat(["MSPointerDown","MSPointerUp","MSPointerMove","MSPointerCancel"]):e.concat(["touchcancel"]),L.DomUtil.addClass(t,"leaflet-clickable"),L.DomEvent.on(t,"click",this._onMouseClick,this),L.DomEvent.on(t,"keypress",this._onKeyPress,this);for(var i=0;i<e.length;i++)L.DomEvent.on(t,e[i],this._fireMouseEvent,this);L.Handler.MarkerDrag&&(this.dragging=new L.Handler.MarkerDrag(this),this.options.draggable&&this.dragging.enable())}},_detectIE:function(){var e=t.navigator.userAgent,i=e.indexOf("MSIE ");if(i>0)return parseInt(e.substring(i+5,e.indexOf(".",i)),10);if(e.indexOf("Trident/")>0){var n=e.indexOf("rv:");return parseInt(e.substring(n+3,e.indexOf(".",n)),10)}var r=e.indexOf("Edge/");return r>0&&parseInt(e.substring(r+5,e.indexOf(".",r)),10)}}),L.LatLngUtil={cloneLatLngs:function(t){for(var e=[],i=0,n=t.length;i<n;i++)Array.isArray(t[i])?e.push(L.LatLngUtil.cloneLatLngs(t[i])):e.push(this.cloneLatLng(t[i]));return e},cloneLatLng:function(t){return L.latLng(t.lat,t.lng)}},function(){var t={km:2,ha:2,m:0,mi:2,ac:2,yd:0,ft:0,nm:2};L.GeometryUtil=L.extend(L.GeometryUtil||{},{geodesicArea:function(t){var e,i,n=t.length,r=0,o=Math.PI/180;if(n>2){for(var s=0;s<n;s++)e=t[s],r+=((i=t[(s+1)%n]).lng-e.lng)*o*(2+Math.sin(e.lat*o)+Math.sin(i.lat*o));r=6378137*r*6378137/2}return Math.abs(r)},formattedNumber:function(t,e){var i=parseFloat(t).toFixed(e),n=L.drawLocal.format&&L.drawLocal.format.numeric,r=n&&n.delimiters,o=r&&r.thousands,s=r&&r.decimal;if(o||s){var a=i.split(".");i=o?a[0].replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+o):a[0],s=s||".",a.length>1&&(i=i+s+a[1])}return i},readableArea:function(e,i,n){var r,o;return n=L.Util.extend({},t,n),i?(o=["ha","m"],type=typeof i,"string"===type?o=[i]:"boolean"!==type&&(o=i),r=e>=1e6&&-1!==o.indexOf("km")?L.GeometryUtil.formattedNumber(1e-6*e,n.km)+" km²":e>=1e4&&-1!==o.indexOf("ha")?L.GeometryUtil.formattedNumber(1e-4*e,n.ha)+" ha":L.GeometryUtil.formattedNumber(e,n.m)+" m²"):r=(e/=.836127)>=3097600?L.GeometryUtil.formattedNumber(e/3097600,n.mi)+" mi²":e>=4840?L.GeometryUtil.formattedNumber(e/4840,n.ac)+" acres":L.GeometryUtil.formattedNumber(e,n.yd)+" yd²",r},readableDistance:function(e,i,n,r,o){var s;switch(o=L.Util.extend({},t,o),i?"string"==typeof i?i:"metric":n?"feet":r?"nauticalMile":"yards"){case"metric":s=e>1e3?L.GeometryUtil.formattedNumber(e/1e3,o.km)+" km":L.GeometryUtil.formattedNumber(e,o.m)+" m";break;case"feet":e*=3.28083,s=L.GeometryUtil.formattedNumber(e,o.ft)+" ft";break;case"nauticalMile":e*=.53996,s=L.GeometryUtil.formattedNumber(e/1e3,o.nm)+" nm";break;default:s=(e*=1.09361)>1760?L.GeometryUtil.formattedNumber(e/1760,o.mi)+" miles":L.GeometryUtil.formattedNumber(e,o.yd)+" yd"}return s},isVersion07x:function(){var t=L.version.split(".");return 0===parseInt(t[0],10)&&7===parseInt(t[1],10)}})}(),L.Util.extend(L.LineUtil,{segmentsIntersect:function(t,e,i,n){return this._checkCounterclockwise(t,i,n)!==this._checkCounterclockwise(e,i,n)&&this._checkCounterclockwise(t,e,i)!==this._checkCounterclockwise(t,e,n)},_checkCounterclockwise:function(t,e,i){return(i.y-t.y)*(e.x-t.x)>(e.y-t.y)*(i.x-t.x)}}),L.Polyline.include({intersects:function(){var t,e,i,n=this._getProjectedPoints(),r=n?n.length:0;if(this._tooFewPointsForIntersection())return!1;for(t=r-1;t>=3;t--)if(e=n[t-1],i=n[t],this._lineSegmentsIntersectsRange(e,i,t-2))return!0;return!1},newLatLngIntersects:function(t,e){return!!this._map&&this.newPointIntersects(this._map.latLngToLayerPoint(t),e)},newPointIntersects:function(t,e){var i=this._getProjectedPoints(),n=i?i.length:0,r=i?i[n-1]:null,o=n-2;return!this._tooFewPointsForIntersection(1)&&this._lineSegmentsIntersectsRange(r,t,o,e?1:0)},_tooFewPointsForIntersection:function(t){var e=this._getProjectedPoints(),i=e?e.length:0;return!e||(i+=t||0)<=3},_lineSegmentsIntersectsRange:function(t,e,i,n){var r,o,s=this._getProjectedPoints();n=n||0;for(var a=i;a>n;a--)if(r=s[a-1],o=s[a],L.LineUtil.segmentsIntersect(t,e,r,o))return!0;return!1},_getProjectedPoints:function(){if(!this._defaultShape)return this._originalPoints;for(var t=[],e=this._defaultShape(),i=0;i<e.length;i++)t.push(this._map.latLngToLayerPoint(e[i]));return t}}),L.Polygon.include({intersects:function(){var t,e,i,n,r=this._getProjectedPoints();return!this._tooFewPointsForIntersection()&&(!!L.Polyline.prototype.intersects.call(this)||(t=r.length,e=r[0],i=r[t-1],n=t-2,this._lineSegmentsIntersectsRange(i,e,n,1)))}}),L.Control.Draw=L.Control.extend({options:{position:"topleft",draw:{},edit:!1},initialize:function(t){if(L.version<"0.7")throw new Error("Leaflet.draw 0.2.3+ requires Leaflet 0.7.0+. Download latest from https://github.com/Leaflet/Leaflet/");var e;L.Control.prototype.initialize.call(this,t),this._toolbars={},L.DrawToolbar&&this.options.draw&&(e=new L.DrawToolbar(this.options.draw),this._toolbars[L.DrawToolbar.TYPE]=e,this._toolbars[L.DrawToolbar.TYPE].on("enable",this._toolbarEnabled,this)),L.EditToolbar&&this.options.edit&&(e=new L.EditToolbar(this.options.edit),this._toolbars[L.EditToolbar.TYPE]=e,this._toolbars[L.EditToolbar.TYPE].on("enable",this._toolbarEnabled,this)),L.toolbar=this},onAdd:function(t){var e,i=L.DomUtil.create("div","leaflet-draw"),n=!1;for(var r in this._toolbars)this._toolbars.hasOwnProperty(r)&&(e=this._toolbars[r].addToolbar(t))&&(n||(L.DomUtil.hasClass(e,"leaflet-draw-toolbar-top")||L.DomUtil.addClass(e.childNodes[0],"leaflet-draw-toolbar-top"),n=!0),i.appendChild(e));return i},onRemove:function(){for(var t in this._toolbars)this._toolbars.hasOwnProperty(t)&&this._toolbars[t].removeToolbar()},setDrawingOptions:function(t){for(var e in this._toolbars)this._toolbars[e]instanceof L.DrawToolbar&&this._toolbars[e].setOptions(t)},_toolbarEnabled:function(t){var e=t.target;for(var i in this._toolbars)this._toolbars[i]!==e&&this._toolbars[i].disable()}}),L.Map.mergeOptions({drawControlTooltips:!0,drawControl:!1}),L.Map.addInitHook((function(){this.options.drawControl&&(this.drawControl=new L.Control.Draw,this.addControl(this.drawControl))})),L.Toolbar=L.Class.extend({initialize:function(t){L.setOptions(this,t),this._modes={},this._actionButtons=[],this._activeMode=null;var e=L.version.split(".");1===parseInt(e[0],10)&&parseInt(e[1],10)>=2?L.Toolbar.include(L.Evented.prototype):L.Toolbar.include(L.Mixin.Events)},enabled:function(){return null!==this._activeMode},disable:function(){this.enabled()&&this._activeMode.handler.disable()},addToolbar:function(t){var e,i=L.DomUtil.create("div","leaflet-draw-section"),n=0,r=this._toolbarClass||"",o=this.getModeHandlers(t);for(this._toolbarContainer=L.DomUtil.create("div","leaflet-draw-toolbar leaflet-bar"),this._map=t,e=0;e<o.length;e++)o[e].enabled&&this._initModeHandler(o[e].handler,this._toolbarContainer,n++,r,o[e].title);if(n)return this._lastButtonIndex=--n,this._actionsContainer=L.DomUtil.create("ul","leaflet-draw-actions"),i.appendChild(this._toolbarContainer),i.appendChild(this._actionsContainer),i},removeToolbar:function(){for(var t in this._modes)this._modes.hasOwnProperty(t)&&(this._disposeButton(this._modes[t].button,this._modes[t].handler.enable,this._modes[t].handler),this._modes[t].handler.disable(),this._modes[t].handler.off("enabled",this._handlerActivated,this).off("disabled",this._handlerDeactivated,this));this._modes={};for(var e=0,i=this._actionButtons.length;e<i;e++)this._disposeButton(this._actionButtons[e].button,this._actionButtons[e].callback,this);this._actionButtons=[],this._actionsContainer=null},_initModeHandler:function(t,e,i,n,r){var o=t.type;this._modes[o]={},this._modes[o].handler=t,this._modes[o].button=this._createButton({type:o,title:r,className:n+"-"+o,container:e,callback:this._modes[o].handler.enable,context:this._modes[o].handler}),this._modes[o].buttonIndex=i,this._modes[o].handler.on("enabled",this._handlerActivated,this).on("disabled",this._handlerDeactivated,this)},_detectIOS:function(){return/iPad|iPhone|iPod/.test(navigator.userAgent)&&!t.MSStream},_createButton:function(t){var e=L.DomUtil.create("a",t.className||"",t.container),i=L.DomUtil.create("span","sr-only",t.container);e.href="#",e.appendChild(i),t.title&&(e.title=t.title,i.innerHTML=t.title),t.text&&(e.innerHTML=t.text,i.innerHTML=t.text);var n=this._detectIOS()?"touchstart":"click";return L.DomEvent.on(e,"click",L.DomEvent.stopPropagation).on(e,"mousedown",L.DomEvent.stopPropagation).on(e,"dblclick",L.DomEvent.stopPropagation).on(e,"touchstart",L.DomEvent.stopPropagation).on(e,"click",L.DomEvent.preventDefault).on(e,n,t.callback,t.context),e},_disposeButton:function(t,e){var i=this._detectIOS()?"touchstart":"click";L.DomEvent.off(t,"click",L.DomEvent.stopPropagation).off(t,"mousedown",L.DomEvent.stopPropagation).off(t,"dblclick",L.DomEvent.stopPropagation).off(t,"touchstart",L.DomEvent.stopPropagation).off(t,"click",L.DomEvent.preventDefault).off(t,i,e)},_handlerActivated:function(t){this.disable(),this._activeMode=this._modes[t.handler],L.DomUtil.addClass(this._activeMode.button,"leaflet-draw-toolbar-button-enabled"),this._showActionsToolbar(),this.fire("enable")},_handlerDeactivated:function(){this._hideActionsToolbar(),L.DomUtil.removeClass(this._activeMode.button,"leaflet-draw-toolbar-button-enabled"),this._activeMode=null,this.fire("disable")},_createActions:function(t){var e,i,n,r,o=this._actionsContainer,s=this.getActions(t),a=s.length;for(i=0,n=this._actionButtons.length;i<n;i++)this._disposeButton(this._actionButtons[i].button,this._actionButtons[i].callback);for(this._actionButtons=[];o.firstChild;)o.removeChild(o.firstChild);for(var l=0;l<a;l++)"enabled"in s[l]&&!s[l].enabled||(e=L.DomUtil.create("li","",o),r=this._createButton({title:s[l].title,text:s[l].text,container:e,callback:s[l].callback,context:s[l].context}),this._actionButtons.push({button:r,callback:s[l].callback}))},_showActionsToolbar:function(){var t=this._activeMode.buttonIndex,e=this._lastButtonIndex,i=this._activeMode.button.offsetTop-1;this._createActions(this._activeMode.handler),this._actionsContainer.style.top=i+"px",0===t&&(L.DomUtil.addClass(this._toolbarContainer,"leaflet-draw-toolbar-notop"),L.DomUtil.addClass(this._actionsContainer,"leaflet-draw-actions-top")),t===e&&(L.DomUtil.addClass(this._toolbarContainer,"leaflet-draw-toolbar-nobottom"),L.DomUtil.addClass(this._actionsContainer,"leaflet-draw-actions-bottom")),this._actionsContainer.style.display="block",this._map.fire(L.Draw.Event.TOOLBAROPENED)},_hideActionsToolbar:function(){this._actionsContainer.style.display="none",L.DomUtil.removeClass(this._toolbarContainer,"leaflet-draw-toolbar-notop"),L.DomUtil.removeClass(this._toolbarContainer,"leaflet-draw-toolbar-nobottom"),L.DomUtil.removeClass(this._actionsContainer,"leaflet-draw-actions-top"),L.DomUtil.removeClass(this._actionsContainer,"leaflet-draw-actions-bottom"),this._map.fire(L.Draw.Event.TOOLBARCLOSED)}}),L.Draw=L.Draw||{},L.Draw.Tooltip=L.Class.extend({initialize:function(t){this._map=t,this._popupPane=t._panes.popupPane,this._visible=!1,this._container=t.options.drawControlTooltips?L.DomUtil.create("div","leaflet-draw-tooltip",this._popupPane):null,this._singleLineLabel=!1,this._map.on("mouseout",this._onMouseOut,this)},dispose:function(){this._map.off("mouseout",this._onMouseOut,this),this._container&&(this._popupPane.removeChild(this._container),this._container=null)},updateContent:function(t){return this._container?(t.subtext=t.subtext||"",0!==t.subtext.length||this._singleLineLabel?t.subtext.length>0&&this._singleLineLabel&&(L.DomUtil.removeClass(this._container,"leaflet-draw-tooltip-single"),this._singleLineLabel=!1):(L.DomUtil.addClass(this._container,"leaflet-draw-tooltip-single"),this._singleLineLabel=!0),this._container.innerHTML=(t.subtext.length>0?'<span class="leaflet-draw-tooltip-subtext">'+t.subtext+"</span><br />":"")+"<span>"+t.text+"</span>",t.text||t.subtext?(this._visible=!0,this._container.style.visibility="inherit"):(this._visible=!1,this._container.style.visibility="hidden"),this):this},updatePosition:function(t){var e=this._map.latLngToLayerPoint(t),i=this._container;return this._container&&(this._visible&&(i.style.visibility="inherit"),L.DomUtil.setPosition(i,e)),this},showAsError:function(){return this._container&&L.DomUtil.addClass(this._container,"leaflet-error-draw-tooltip"),this},removeError:function(){return this._container&&L.DomUtil.removeClass(this._container,"leaflet-error-draw-tooltip"),this},_onMouseOut:function(){this._container&&(this._container.style.visibility="hidden")}}),L.DrawToolbar=L.Toolbar.extend({statics:{TYPE:"draw"},options:{polyline:{},polygon:{},rectangle:{},circle:{},marker:{},circlemarker:{}},initialize:function(t){for(var e in this.options)this.options.hasOwnProperty(e)&&t[e]&&(t[e]=L.extend({},this.options[e],t[e]));this._toolbarClass="leaflet-draw-draw",L.Toolbar.prototype.initialize.call(this,t)},getModeHandlers:function(t){return[{enabled:this.options.polyline,handler:new L.Draw.Polyline(t,this.options.polyline),title:L.drawLocal.draw.toolbar.buttons.polyline},{enabled:this.options.polygon,handler:new L.Draw.Polygon(t,this.options.polygon),title:L.drawLocal.draw.toolbar.buttons.polygon},{enabled:this.options.rectangle,handler:new L.Draw.Rectangle(t,this.options.rectangle),title:L.drawLocal.draw.toolbar.buttons.rectangle},{enabled:this.options.circle,handler:new L.Draw.Circle(t,this.options.circle),title:L.drawLocal.draw.toolbar.buttons.circle},{enabled:this.options.marker,handler:new L.Draw.Marker(t,this.options.marker),title:L.drawLocal.draw.toolbar.buttons.marker},{enabled:this.options.circlemarker,handler:new L.Draw.CircleMarker(t,this.options.circlemarker),title:L.drawLocal.draw.toolbar.buttons.circlemarker}]},getActions:function(t){return[{enabled:t.completeShape,title:L.drawLocal.draw.toolbar.finish.title,text:L.drawLocal.draw.toolbar.finish.text,callback:t.completeShape,context:t},{enabled:t.deleteLastVertex,title:L.drawLocal.draw.toolbar.undo.title,text:L.drawLocal.draw.toolbar.undo.text,callback:t.deleteLastVertex,context:t},{title:L.drawLocal.draw.toolbar.actions.title,text:L.drawLocal.draw.toolbar.actions.text,callback:this.disable,context:this}]},setOptions:function(t){for(var e in L.setOptions(this,t),this._modes)this._modes.hasOwnProperty(e)&&t.hasOwnProperty(e)&&this._modes[e].handler.setOptions(t[e])}}),L.EditToolbar=L.Toolbar.extend({statics:{TYPE:"edit"},options:{edit:{selectedPathOptions:{dashArray:"10, 10",fill:!0,fillColor:"#fe57a1",fillOpacity:.1,maintainColor:!1}},remove:{},poly:null,featureGroup:null},initialize:function(t){t.edit&&(void 0===t.edit.selectedPathOptions&&(t.edit.selectedPathOptions=this.options.edit.selectedPathOptions),t.edit.selectedPathOptions=L.extend({},this.options.edit.selectedPathOptions,t.edit.selectedPathOptions)),t.remove&&(t.remove=L.extend({},this.options.remove,t.remove)),t.poly&&(t.poly=L.extend({},this.options.poly,t.poly)),this._toolbarClass="leaflet-draw-edit",L.Toolbar.prototype.initialize.call(this,t),this._selectedFeatureCount=0},getModeHandlers:function(t){var e=this.options.featureGroup;return[{enabled:this.options.edit,handler:new L.EditToolbar.Edit(t,{featureGroup:e,selectedPathOptions:this.options.edit.selectedPathOptions,poly:this.options.poly}),title:L.drawLocal.edit.toolbar.buttons.edit},{enabled:this.options.remove,handler:new L.EditToolbar.Delete(t,{featureGroup:e}),title:L.drawLocal.edit.toolbar.buttons.remove}]},getActions:function(t){var e=[{title:L.drawLocal.edit.toolbar.actions.save.title,text:L.drawLocal.edit.toolbar.actions.save.text,callback:this._save,context:this},{title:L.drawLocal.edit.toolbar.actions.cancel.title,text:L.drawLocal.edit.toolbar.actions.cancel.text,callback:this.disable,context:this}];return t.removeAllLayers&&e.push({title:L.drawLocal.edit.toolbar.actions.clearAll.title,text:L.drawLocal.edit.toolbar.actions.clearAll.text,callback:this._clearAllLayers,context:this}),e},addToolbar:function(t){var e=L.Toolbar.prototype.addToolbar.call(this,t);return this._checkDisabled(),this.options.featureGroup.on("layeradd layerremove",this._checkDisabled,this),e},removeToolbar:function(){this.options.featureGroup.off("layeradd layerremove",this._checkDisabled,this),L.Toolbar.prototype.removeToolbar.call(this)},disable:function(){this.enabled()&&(this._activeMode.handler.revertLayers(),L.Toolbar.prototype.disable.call(this))},_save:function(){this._activeMode.handler.save(),this._activeMode&&this._activeMode.handler.disable()},_clearAllLayers:function(){this._activeMode.handler.removeAllLayers(),this._activeMode&&this._activeMode.handler.disable()},_checkDisabled:function(){var t,e=0!==this.options.featureGroup.getLayers().length;this.options.edit&&(t=this._modes[L.EditToolbar.Edit.TYPE].button,e?L.DomUtil.removeClass(t,"leaflet-disabled"):L.DomUtil.addClass(t,"leaflet-disabled"),t.setAttribute("title",e?L.drawLocal.edit.toolbar.buttons.edit:L.drawLocal.edit.toolbar.buttons.editDisabled)),this.options.remove&&(t=this._modes[L.EditToolbar.Delete.TYPE].button,e?L.DomUtil.removeClass(t,"leaflet-disabled"):L.DomUtil.addClass(t,"leaflet-disabled"),t.setAttribute("title",e?L.drawLocal.edit.toolbar.buttons.remove:L.drawLocal.edit.toolbar.buttons.removeDisabled))}}),L.EditToolbar.Edit=L.Handler.extend({statics:{TYPE:"edit"},initialize:function(t,e){if(L.Handler.prototype.initialize.call(this,t),L.setOptions(this,e),this._featureGroup=e.featureGroup,!(this._featureGroup instanceof L.FeatureGroup))throw new Error("options.featureGroup must be a L.FeatureGroup");this._uneditedLayerProps={},this.type=L.EditToolbar.Edit.TYPE;var i=L.version.split(".");1===parseInt(i[0],10)&&parseInt(i[1],10)>=2?L.EditToolbar.Edit.include(L.Evented.prototype):L.EditToolbar.Edit.include(L.Mixin.Events)},enable:function(){!this._enabled&&this._hasAvailableLayers()&&(this.fire("enabled",{handler:this.type}),this._map.fire(L.Draw.Event.EDITSTART,{handler:this.type}),L.Handler.prototype.enable.call(this),this._featureGroup.on("layeradd",this._enableLayerEdit,this).on("layerremove",this._disableLayerEdit,this))},disable:function(){this._enabled&&(this._featureGroup.off("layeradd",this._enableLayerEdit,this).off("layerremove",this._disableLayerEdit,this),L.Handler.prototype.disable.call(this),this._map.fire(L.Draw.Event.EDITSTOP,{handler:this.type}),this.fire("disabled",{handler:this.type}))},addHooks:function(){var t=this._map;t&&(t.getContainer().focus(),this._featureGroup.eachLayer(this._enableLayerEdit,this),this._tooltip=new L.Draw.Tooltip(this._map),this._tooltip.updateContent({text:L.drawLocal.edit.handlers.edit.tooltip.text,subtext:L.drawLocal.edit.handlers.edit.tooltip.subtext}),t._editTooltip=this._tooltip,this._updateTooltip(),this._map.on("mousemove",this._onMouseMove,this).on("touchmove",this._onMouseMove,this).on("MSPointerMove",this._onMouseMove,this).on(L.Draw.Event.EDITVERTEX,this._updateTooltip,this))},removeHooks:function(){this._map&&(this._featureGroup.eachLayer(this._disableLayerEdit,this),this._uneditedLayerProps={},this._tooltip.dispose(),this._tooltip=null,this._map.off("mousemove",this._onMouseMove,this).off("touchmove",this._onMouseMove,this).off("MSPointerMove",this._onMouseMove,this).off(L.Draw.Event.EDITVERTEX,this._updateTooltip,this))},revertLayers:function(){this._featureGroup.eachLayer((function(t){this._revertLayer(t)}),this)},save:function(){var t=new L.LayerGroup;this._featureGroup.eachLayer((function(e){e.edited&&(t.addLayer(e),e.edited=!1)})),this._map.fire(L.Draw.Event.EDITED,{layers:t})},_backupLayer:function(t){var e=L.Util.stamp(t);this._uneditedLayerProps[e]||(t instanceof L.Polyline||t instanceof L.Polygon||t instanceof L.Rectangle?this._uneditedLayerProps[e]={latlngs:L.LatLngUtil.cloneLatLngs(t.getLatLngs())}:t instanceof L.Circle?this._uneditedLayerProps[e]={latlng:L.LatLngUtil.cloneLatLng(t.getLatLng()),radius:t.getRadius()}:(t instanceof L.Marker||t instanceof L.CircleMarker)&&(this._uneditedLayerProps[e]={latlng:L.LatLngUtil.cloneLatLng(t.getLatLng())}))},_getTooltipText:function(){return{text:L.drawLocal.edit.handlers.edit.tooltip.text,subtext:L.drawLocal.edit.handlers.edit.tooltip.subtext}},_updateTooltip:function(){this._tooltip.updateContent(this._getTooltipText())},_revertLayer:function(t){var e=L.Util.stamp(t);t.edited=!1,this._uneditedLayerProps.hasOwnProperty(e)&&(t instanceof L.Polyline||t instanceof L.Polygon||t instanceof L.Rectangle?t.setLatLngs(this._uneditedLayerProps[e].latlngs):t instanceof L.Circle?(t.setLatLng(this._uneditedLayerProps[e].latlng),t.setRadius(this._uneditedLayerProps[e].radius)):(t instanceof L.Marker||t instanceof L.CircleMarker)&&t.setLatLng(this._uneditedLayerProps[e].latlng),t.fire("revert-edited",{layer:t}))},_enableLayerEdit:function(t){var e,i,n=t.layer||t.target||t;this._backupLayer(n),this.options.poly&&(i=L.Util.extend({},this.options.poly),n.options.poly=i),this.options.selectedPathOptions&&((e=L.Util.extend({},this.options.selectedPathOptions)).maintainColor&&(e.color=n.options.color,e.fillColor=n.options.fillColor),n.options.original=L.extend({},n.options),n.options.editing=e),n instanceof L.Marker?(n.editing&&n.editing.enable(),n.dragging.enable(),n.on("dragend",this._onMarkerDragEnd).on("touchmove",this._onTouchMove,this).on("MSPointerMove",this._onTouchMove,this).on("touchend",this._onMarkerDragEnd,this).on("MSPointerUp",this._onMarkerDragEnd,this)):n.editing.enable()},_disableLayerEdit:function(t){var e=t.layer||t.target||t;e.edited=!1,e.editing&&e.editing.disable(),delete e.options.editing,delete e.options.original,this._selectedPathOptions&&(e instanceof L.Marker?this._toggleMarkerHighlight(e):(e.setStyle(e.options.previousOptions),delete e.options.previousOptions)),e instanceof L.Marker?(e.dragging.disable(),e.off("dragend",this._onMarkerDragEnd,this).off("touchmove",this._onTouchMove,this).off("MSPointerMove",this._onTouchMove,this).off("touchend",this._onMarkerDragEnd,this).off("MSPointerUp",this._onMarkerDragEnd,this)):e.editing.disable()},_onMouseMove:function(t){this._tooltip.updatePosition(t.latlng)},_onMarkerDragEnd:function(t){var e=t.target;e.edited=!0,this._map.fire(L.Draw.Event.EDITMOVE,{layer:e})},_onTouchMove:function(t){var e=t.originalEvent.changedTouches[0],i=this._map.mouseEventToLayerPoint(e),n=this._map.layerPointToLatLng(i);t.target.setLatLng(n)},_hasAvailableLayers:function(){return 0!==this._featureGroup.getLayers().length}}),L.EditToolbar.Delete=L.Handler.extend({statics:{TYPE:"remove"},initialize:function(t,e){if(L.Handler.prototype.initialize.call(this,t),L.Util.setOptions(this,e),this._deletableLayers=this.options.featureGroup,!(this._deletableLayers instanceof L.FeatureGroup))throw new Error("options.featureGroup must be a L.FeatureGroup");this.type=L.EditToolbar.Delete.TYPE;var i=L.version.split(".");1===parseInt(i[0],10)&&parseInt(i[1],10)>=2?L.EditToolbar.Delete.include(L.Evented.prototype):L.EditToolbar.Delete.include(L.Mixin.Events)},enable:function(){!this._enabled&&this._hasAvailableLayers()&&(this.fire("enabled",{handler:this.type}),this._map.fire(L.Draw.Event.DELETESTART,{handler:this.type}),L.Handler.prototype.enable.call(this),this._deletableLayers.on("layeradd",this._enableLayerDelete,this).on("layerremove",this._disableLayerDelete,this))},disable:function(){this._enabled&&(this._deletableLayers.off("layeradd",this._enableLayerDelete,this).off("layerremove",this._disableLayerDelete,this),L.Handler.prototype.disable.call(this),this._map.fire(L.Draw.Event.DELETESTOP,{handler:this.type}),this.fire("disabled",{handler:this.type}))},addHooks:function(){var t=this._map;t&&(t.getContainer().focus(),this._deletableLayers.eachLayer(this._enableLayerDelete,this),this._deletedLayers=new L.LayerGroup,this._tooltip=new L.Draw.Tooltip(this._map),this._tooltip.updateContent({text:L.drawLocal.edit.handlers.remove.tooltip.text}),this._map.on("mousemove",this._onMouseMove,this))},removeHooks:function(){this._map&&(this._deletableLayers.eachLayer(this._disableLayerDelete,this),this._deletedLayers=null,this._tooltip.dispose(),this._tooltip=null,this._map.off("mousemove",this._onMouseMove,this))},revertLayers:function(){this._deletedLayers.eachLayer((function(t){this._deletableLayers.addLayer(t),t.fire("revert-deleted",{layer:t})}),this)},save:function(){this._map.fire(L.Draw.Event.DELETED,{layers:this._deletedLayers})},removeAllLayers:function(){this._deletableLayers.eachLayer((function(t){this._removeLayer({layer:t})}),this),this.save()},_enableLayerDelete:function(t){(t.layer||t.target||t).on("click",this._removeLayer,this)},_disableLayerDelete:function(t){var e=t.layer||t.target||t;e.off("click",this._removeLayer,this),this._deletedLayers.removeLayer(e)},_removeLayer:function(t){var e=t.layer||t.target||t;this._deletableLayers.removeLayer(e),this._deletedLayers.addLayer(e),e.fire("deleted")},_onMouseMove:function(t){this._tooltip.updatePosition(t.latlng)},_hasAvailableLayers:function(){return 0!==this._deletableLayers.getLayers().length}})},4495:()=>{L.Control.Fullscreen=L.Control.extend({options:{position:"topleft",title:{false:"View Fullscreen",true:"Exit Fullscreen"}},onAdd:function(t){var e=L.DomUtil.create("div","leaflet-control-fullscreen leaflet-bar leaflet-control");return this.link=L.DomUtil.create("a","leaflet-control-fullscreen-button leaflet-bar-part",e),this.link.href="#",this._map=t,this._map.on("fullscreenchange",this._toggleTitle,this),this._toggleTitle(),L.DomEvent.on(this.link,"click",this._click,this),e},_click:function(t){L.DomEvent.stopPropagation(t),L.DomEvent.preventDefault(t),this._map.toggleFullscreen(this.options)},_toggleTitle:function(){this.link.title=this.options.title[this._map.isFullscreen()]}}),L.Map.include({isFullscreen:function(){return this._isFullscreen||!1},toggleFullscreen:function(t){var e=this.getContainer();this.isFullscreen()?t&&t.pseudoFullscreen?this._disablePseudoFullscreen(e):document.exitFullscreen?document.exitFullscreen():document.mozCancelFullScreen?document.mozCancelFullScreen():document.webkitCancelFullScreen?document.webkitCancelFullScreen():document.msExitFullscreen?document.msExitFullscreen():this._disablePseudoFullscreen(e):t&&t.pseudoFullscreen?this._enablePseudoFullscreen(e):e.requestFullscreen?e.requestFullscreen():e.mozRequestFullScreen?e.mozRequestFullScreen():e.webkitRequestFullscreen?e.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT):e.msRequestFullscreen?e.msRequestFullscreen():this._enablePseudoFullscreen(e)},_enablePseudoFullscreen:function(t){L.DomUtil.addClass(t,"leaflet-pseudo-fullscreen"),this._setFullscreen(!0),this.fire("fullscreenchange")},_disablePseudoFullscreen:function(t){L.DomUtil.removeClass(t,"leaflet-pseudo-fullscreen"),this._setFullscreen(!1),this.fire("fullscreenchange")},_setFullscreen:function(t){this._isFullscreen=t;var e=this.getContainer();t?L.DomUtil.addClass(e,"leaflet-fullscreen-on"):L.DomUtil.removeClass(e,"leaflet-fullscreen-on"),this.invalidateSize()},_onFullscreenChange:function(t){var e=document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement;e!==this.getContainer()||this._isFullscreen?e!==this.getContainer()&&this._isFullscreen&&(this._setFullscreen(!1),this.fire("fullscreenchange")):(this._setFullscreen(!0),this.fire("fullscreenchange"))}}),L.Map.mergeOptions({fullscreenControl:!1}),L.Map.addInitHook((function(){var t;if(this.options.fullscreenControl&&(this.fullscreenControl=new L.Control.Fullscreen(this.options.fullscreenControl),this.addControl(this.fullscreenControl)),"onfullscreenchange"in document?t="fullscreenchange":"onmozfullscreenchange"in document?t="mozfullscreenchange":"onwebkitfullscreenchange"in document?t="webkitfullscreenchange":"onmsfullscreenchange"in document&&(t="MSFullscreenChange"),t){var e=L.bind(this._onFullscreenChange,this);this.whenReady((function(){L.DomEvent.on(document,t,e)})),this.on("unload",(function(){L.DomEvent.off(document,t,e)}))}})),L.control.fullscreen=function(t){return new L.Control.Fullscreen(t)}},2986:()=>{!function(t){function e(n){if(i[n])return i[n].exports;var r=i[n]={i:n,l:!1,exports:{}};return t[n].call(r.exports,r,r.exports,e),r.l=!0,r.exports}var i={};e.m=t,e.c=i,e.d=function(t,i,n){e.o(t,i)||Object.defineProperty(t,i,{configurable:!1,enumerable:!0,get:n})},e.n=function(t){var i=t&&t.__esModule?function(){return t.default}:function(){return t};return e.d(i,"a",i),i},e.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},e.p="/dist/",e(e.s=28)}([function(t,e,i){var n=i(4),r=i(38),o=i(39),s=n?n.toStringTag:void 0;t.exports=function(t){return null==t?void 0===t?"[object Undefined]":"[object Null]":s&&s in Object(t)?r(t):o(t)}},function(t,e){t.exports=function(t){return null!=t&&"object"==typeof t}},function(t,e){t.exports=function(t){var e=typeof t;return null!=t&&("object"==e||"function"==e)}},function(t,e,i){"use strict";function n(t,e,i){if(!h(i=i||{}))throw new Error("options is invalid");var n=i.bbox,r=i.id;if(void 0===t)throw new Error("geometry is required");if(e&&e.constructor!==Object)throw new Error("properties must be an Object");n&&function(t){if(!t)throw new Error("bbox is required");if(!Array.isArray(t))throw new Error("bbox must be an Array");if(4!==t.length&&6!==t.length)throw new Error("bbox must be an Array of 4 or 6 numbers");t.forEach((function(t){if(!l(t))throw new Error("bbox must only contain numbers")}))}(n),r&&function(t){if(!t)throw new Error("id is required");if(-1===["string","number"].indexOf(typeof t))throw new Error("id must be a number or a string")}(r);var o={type:"Feature"};return r&&(o.id=r),n&&(o.bbox=n),o.properties=e||{},o.geometry=t,o}function r(t,e,i){if(!t)throw new Error("coordinates is required");if(!Array.isArray(t))throw new Error("coordinates must be an Array");if(t.length<2)throw new Error("coordinates must be at least 2 numbers long");if(!l(t[0])||!l(t[1]))throw new Error("coordinates must contain numbers");return n({type:"Point",coordinates:t},e,i)}function o(t,e,i){if(!t)throw new Error("coordinates is required");if(t.length<2)throw new Error("coordinates must be an array of two or more positions");if(!l(t[0][1])||!l(t[0][1]))throw new Error("coordinates must contain numbers");return n({type:"LineString",coordinates:t},e,i)}function s(t,e){if(null==t)throw new Error("radians is required");if(e&&"string"!=typeof e)throw new Error("units must be a string");var i=c[e||"kilometers"];if(!i)throw new Error(e+" units is invalid");return t*i}function a(t){if(null==t)throw new Error("degrees is required");return t%360*Math.PI/180}function l(t){return!isNaN(t)&&null!==t&&!Array.isArray(t)}function h(t){return!!t&&t.constructor===Object}i.d(e,"b",(function(){return n})),i.d(e,"f",(function(){return r})),i.d(e,"e",(function(){return o})),i.d(e,"g",(function(){return s})),i.d(e,"a",(function(){return a})),i.d(e,"c",(function(){return l})),i.d(e,"d",(function(){return h}));var c={meters:6371008.8,metres:6371008.8,millimeters:6371008800,millimetres:6371008800,centimeters:637100880,centimetres:637100880,kilometers:6371.0088,kilometres:6371.0088,miles:3958.761333810546,nauticalmiles:6371008.8/1852,inches:6371008.8*39.37,yards:6371008.8/1.0936,feet:20902260.511392,radians:1,degrees:6371008.8/111325}},function(t,e,i){var n=i(5).Symbol;t.exports=n},function(t,e,i){var n=i(11),r="object"==typeof self&&self&&self.Object===Object&&self,o=n||r||Function("return this")();t.exports=o},function(t,e){t.exports=function(t,e){return t===e||t!=t&&e!=e}},function(t,e,i){var n=i(10),r=i(16);t.exports=function(t){return null!=t&&r(t.length)&&!n(t)}},function(t,e,i){var n=i(9);t.exports=function(t,e,i){"__proto__"==e&&n?n(t,e,{configurable:!0,enumerable:!0,value:i,writable:!0}):t[e]=i}},function(t,e,i){var n=i(35),r=function(){try{var t=n(Object,"defineProperty");return t({},"",{}),t}catch(t){}}();t.exports=r},function(t,e,i){var n=i(0),r=i(2);t.exports=function(t){if(!r(t))return!1;var e=n(t);return"[object Function]"==e||"[object GeneratorFunction]"==e||"[object AsyncFunction]"==e||"[object Proxy]"==e}},function(t,e,i){(function(e){var i="object"==typeof e&&e&&e.Object===Object&&e;t.exports=i}).call(e,i(37))},function(t,e,i){var n=i(13),r=i(45),o=i(46);t.exports=function(t,e){return o(r(t,e,n),t+"")}},function(t,e){t.exports=function(t){return t}},function(t,e){t.exports=function(t,e,i){switch(i.length){case 0:return t.call(e);case 1:return t.call(e,i[0]);case 2:return t.call(e,i[0],i[1]);case 3:return t.call(e,i[0],i[1],i[2])}return t.apply(e,i)}},function(t,e,i){var n=i(6),r=i(7),o=i(17),s=i(2);t.exports=function(t,e,i){if(!s(i))return!1;var a=typeof e;return!!("number"==a?r(i)&&o(e,i.length):"string"==a&&e in i)&&n(i[e],t)}},function(t,e){t.exports=function(t){return"number"==typeof t&&t>-1&&t%1==0&&t<=9007199254740991}},function(t,e){var i=/^(?:0|[1-9]\d*)$/;t.exports=function(t,e){var n=typeof t;return!!(e=null==e?9007199254740991:e)&&("number"==n||"symbol"!=n&&i.test(t))&&t>-1&&t%1==0&&t<e}},function(t,e,i){var n=i(51),r=i(52),o=i(19),s=i(54),a=i(17),l=i(56),h=Object.prototype.hasOwnProperty;t.exports=function(t,e){var i=o(t),c=!i&&r(t),u=!i&&!c&&s(t),d=!i&&!c&&!u&&l(t),p=i||c||u||d,f=p?n(t.length,String):[],m=f.length;for(var g in t)!e&&!h.call(t,g)||p&&("length"==g||u&&("offset"==g||"parent"==g)||d&&("buffer"==g||"byteLength"==g||"byteOffset"==g)||a(g,m))||f.push(g);return f}},function(t,e){var i=Array.isArray;t.exports=i},function(t,e){t.exports=function(t){return t.webpackPolyfill||(t.deprecate=function(){},t.paths=[],t.children||(t.children=[]),Object.defineProperty(t,"loaded",{enumerable:!0,get:function(){return t.l}}),Object.defineProperty(t,"id",{enumerable:!0,get:function(){return t.i}}),t.webpackPolyfill=1),t}},function(t,e){var i=Object.prototype;t.exports=function(t){var e=t&&t.constructor;return t===("function"==typeof e&&e.prototype||i)}},function(t,e,i){var n=i(0),r=i(1),o=i(63);t.exports=function(t){if(!r(t))return!1;var e=n(t);return"[object Error]"==e||"[object DOMException]"==e||"string"==typeof t.message&&"string"==typeof t.name&&!o(t)}},function(t,e){t.exports=function(t,e){return function(i){return t(e(i))}}},function(t,e){t.exports=function(t,e){for(var i=-1,n=null==t?0:t.length,r=Array(n);++i<n;)r[i]=e(t[i],i,t);return r}},function(t,e){t.exports=/<%=([\s\S]+?)%>/g},function(t,e,i){var n=i(75);t.exports=function(t){return null==t?"":n(t)}},function(t,e,i){"use strict";function n(t,e,i){if(null!==t)for(var r,o,s,a,l,h,c,u,d=0,p=0,f=t.type,m="FeatureCollection"===f,g="Feature"===f,_=m?t.features.length:1,y=0;y<_;y++){l=(u=!!(c=m?t.features[y].geometry:g?t.geometry:t)&&"GeometryCollection"===c.type)?c.geometries.length:1;for(var v=0;v<l;v++){var b=0,x=0;if(null!==(a=u?c.geometries[v]:c)){h=a.coordinates;var w=a.type;switch(d=!i||"Polygon"!==w&&"MultiPolygon"!==w?0:1,w){case null:break;case"Point":if(!1===e(h,p,y,b,x))return!1;p++,b++;break;case"LineString":case"MultiPoint":for(r=0;r<h.length;r++){if(!1===e(h[r],p,y,b,x))return!1;p++,"MultiPoint"===w&&b++}"LineString"===w&&b++;break;case"Polygon":case"MultiLineString":for(r=0;r<h.length;r++){for(o=0;o<h[r].length-d;o++){if(!1===e(h[r][o],p,y,b,x))return!1;p++}"MultiLineString"===w&&b++,"Polygon"===w&&x++}"Polygon"===w&&b++;break;case"MultiPolygon":for(r=0;r<h.length;r++){for("MultiPolygon"===w&&(x=0),o=0;o<h[r].length;o++){for(s=0;s<h[r][o].length-d;s++){if(!1===e(h[r][o][s],p,y,b,x))return!1;p++}x++}b++}break;case"GeometryCollection":for(r=0;r<a.geometries.length;r++)if(!1===n(a.geometries[r],e,i))return!1;break;default:throw new Error("Unknown Geometry Type")}}}}}function r(t,e){var i,n,r,o,s,a,l,h,c,u,d=0,p="FeatureCollection"===t.type,f="Feature"===t.type,m=p?t.features.length:1;for(i=0;i<m;i++){for(a=p?t.features[i].geometry:f?t.geometry:t,h=p?t.features[i].properties:f?t.properties:{},c=p?t.features[i].bbox:f?t.bbox:void 0,u=p?t.features[i].id:f?t.id:void 0,s=(l=!!a&&"GeometryCollection"===a.type)?a.geometries.length:1,r=0;r<s;r++)if(null!==(o=l?a.geometries[r]:a))switch(o.type){case"Point":case"LineString":case"MultiPoint":case"Polygon":case"MultiLineString":case"MultiPolygon":if(!1===e(o,d,h,c,u))return!1;break;case"GeometryCollection":for(n=0;n<o.geometries.length;n++)if(!1===e(o.geometries[n],d,h,c,u))return!1;break;default:throw new Error("Unknown Geometry Type")}else if(!1===e(null,d,h,c,u))return!1;d++}}function o(t,e,i){var n=i;return r(t,(function(t,r,o,s,a){n=0===r&&void 0===i?t:e(n,t,r,o,s,a)})),n}function s(t,e){!function(t,e){r(t,(function(t,i,n,r,o){var s,a=null===t?null:t.type;switch(a){case null:case"Point":case"LineString":case"Polygon":return!1!==e(Object(l.b)(t,n,{bbox:r,id:o}),i,0)&&void 0}switch(a){case"MultiPoint":s="Point";break;case"MultiLineString":s="LineString";break;case"MultiPolygon":s="Polygon"}for(var h=0;h<t.coordinates.length;h++){var c={type:s,coordinates:t.coordinates[h]};if(!1===e(Object(l.b)(c,n),i,h))return!1}}))}(t,(function(t,i,r){var o=0;if(t.geometry){var s,a=t.geometry.type;if("Point"!==a&&"MultiPoint"!==a)return!1!==n(t,(function(n,a,h,c,u){if(void 0!==s){var d=Object(l.e)([s,n],t.properties);if(!1===e(d,i,r,u,o))return!1;o++,s=n}else s=n}))&&void 0}}))}function a(t,e,i){var n=i,r=!1;return s(t,(function(t,o,s,a,l){n=!1===r&&void 0===i?t:e(n,t,o,s,a,l),r=!0})),n}i.d(e,"a",(function(){return o})),i.d(e,"b",(function(){return a}));var l=i(3)},function(t,e,i){t.exports=i(29)},function(t,e,i){"use strict";function n(t){return t&&t.__esModule?t:{default:t}}i(30);var r=n(i(31)),o=n(i(79)),s=n(i(80)),a=i(85),l=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e.default=t,e}(a),h=n(i(86)),c=i(87),u=i(88),d={imports:{numberFormat:c.numberFormat},interpolate:/{{([\s\S]+?)}}/g},p=(0,r.default)(u.controlTemplate,d),f=(0,r.default)(u.resultsTemplate,d),m=(0,r.default)(u.pointPopupTemplate,d),g=(0,r.default)(u.linePopupTemplate,d),_=(0,r.default)(u.areaPopupTemplate,d);L.Control.Measure=L.Control.extend({_className:"leaflet-control-measure",options:{units:{},position:"topright",primaryLengthUnit:"feet",secondaryLengthUnit:"miles",primaryAreaUnit:"acres",activeColor:"#ABE67E",completedColor:"#C8F2BE",captureZIndex:1e4,popupOptions:{className:"leaflet-measure-resultpopup",autoPanPadding:[10,10]}},initialize:function(t){L.setOptions(this,t);var e=this.options,i=e.activeColor,n=e.completedColor;this._symbols=new h.default({activeColor:i,completedColor:n}),this.options.units=L.extend({},o.default,this.options.units)},onAdd:function(t){return this._map=t,this._latlngs=[],this._initLayout(),t.on("click",this._collapse,this),this._layer=L.layerGroup().addTo(t),this._container},onRemove:function(t){t.off("click",this._collapse,this),t.removeLayer(this._layer)},_initLayout:function(){var t=this._className,e=this._container=L.DomUtil.create("div",t+" leaflet-bar");e.innerHTML=p({model:{className:t}}),e.setAttribute("aria-haspopup",!0),L.DomEvent.disableClickPropagation(e),L.DomEvent.disableScrollPropagation(e);var i=this.$toggle=(0,a.selectOne)(".js-toggle",e);this.$interaction=(0,a.selectOne)(".js-interaction",e);var n=(0,a.selectOne)(".js-start",e),r=(0,a.selectOne)(".js-cancel",e),o=(0,a.selectOne)(".js-finish",e);this.$startPrompt=(0,a.selectOne)(".js-startprompt",e),this.$measuringPrompt=(0,a.selectOne)(".js-measuringprompt",e),this.$startHelp=(0,a.selectOne)(".js-starthelp",e),this.$results=(0,a.selectOne)(".js-results",e),this.$measureTasks=(0,a.selectOne)(".js-measuretasks",e),this._collapse(),this._updateMeasureNotStarted(),L.Browser.android||(L.DomEvent.on(e,"mouseenter",this._expand,this),L.DomEvent.on(e,"mouseleave",this._collapse,this)),L.DomEvent.on(i,"click",L.DomEvent.stop),L.Browser.touch?L.DomEvent.on(i,"click",this._expand,this):L.DomEvent.on(i,"focus",this._expand,this),L.DomEvent.on(n,"click",L.DomEvent.stop),L.DomEvent.on(n,"click",this._startMeasure,this),L.DomEvent.on(r,"click",L.DomEvent.stop),L.DomEvent.on(r,"click",this._finishMeasure,this),L.DomEvent.on(o,"click",L.DomEvent.stop),L.DomEvent.on(o,"click",this._handleMeasureDoubleClick,this)},_expand:function(){l.hide(this.$toggle),l.show(this.$interaction)},_collapse:function(){this._locked||(l.hide(this.$interaction),l.show(this.$toggle))},_updateMeasureNotStarted:function(){l.hide(this.$startHelp),l.hide(this.$results),l.hide(this.$measureTasks),l.hide(this.$measuringPrompt),l.show(this.$startPrompt)},_updateMeasureStartedNoPoints:function(){l.hide(this.$results),l.show(this.$startHelp),l.show(this.$measureTasks),l.hide(this.$startPrompt),l.show(this.$measuringPrompt)},_updateMeasureStartedWithPoints:function(){l.hide(this.$startHelp),l.show(this.$results),l.show(this.$measureTasks),l.hide(this.$startPrompt),l.show(this.$measuringPrompt)},_startMeasure:function(){this._locked=!0,this._measureVertexes=L.featureGroup().addTo(this._layer),this._captureMarker=L.marker(this._map.getCenter(),{clickable:!0,zIndexOffset:this.options.captureZIndex,opacity:0}).addTo(this._layer),this._setCaptureMarkerIcon(),this._captureMarker.on("mouseout",this._handleMapMouseOut,this).on("dblclick",this._handleMeasureDoubleClick,this).on("click",this._handleMeasureClick,this),this._map.on("mousemove",this._handleMeasureMove,this).on("mouseout",this._handleMapMouseOut,this).on("move",this._centerCaptureMarker,this).on("resize",this._setCaptureMarkerIcon,this),L.DomEvent.on(this._container,"mouseenter",this._handleMapMouseOut,this),this._updateMeasureStartedNoPoints(),this._map.fire("measurestart",null,!1)},_finishMeasure:function(){var t=L.extend({},this._resultsModel,{points:this._latlngs});this._locked=!1,L.DomEvent.off(this._container,"mouseover",this._handleMapMouseOut,this),this._clearMeasure(),this._captureMarker.off("mouseout",this._handleMapMouseOut,this).off("dblclick",this._handleMeasureDoubleClick,this).off("click",this._handleMeasureClick,this),this._map.off("mousemove",this._handleMeasureMove,this).off("mouseout",this._handleMapMouseOut,this).off("move",this._centerCaptureMarker,this).off("resize",this._setCaptureMarkerIcon,this),this._layer.removeLayer(this._measureVertexes).removeLayer(this._captureMarker),this._measureVertexes=null,this._updateMeasureNotStarted(),this._collapse(),this._map.fire("measurefinish",t,!1)},_clearMeasure:function(){this._latlngs=[],this._resultsModel=null,this._measureVertexes.clearLayers(),this._measureDrag&&this._layer.removeLayer(this._measureDrag),this._measureArea&&this._layer.removeLayer(this._measureArea),this._measureBoundary&&this._layer.removeLayer(this._measureBoundary),this._measureDrag=null,this._measureArea=null,this._measureBoundary=null},_centerCaptureMarker:function(){this._captureMarker.setLatLng(this._map.getCenter())},_setCaptureMarkerIcon:function(){this._captureMarker.setIcon(L.divIcon({iconSize:this._map.getSize().multiplyBy(2)}))},_getMeasurementDisplayStrings:function(t){function e(t,e,r,o,s){if(e&&n[e]){var a=i(t,n[e],o,s);return r&&n[r]&&(a=a+" ("+i(t,n[r],o,s)+")"),a}return i(t,null,o,s)}function i(t,e,i,n){var r=L.extend({factor:1,decimals:0},e);return[(0,c.numberFormat)(t*r.factor,r.decimals,i||".",n||","),{acres:"Acres",feet:"Feet",kilometers:"Kilometers",hectares:"Hectares",meters:"Meters",miles:"Miles",sqfeet:"Sq Feet",sqmeters:"Sq Meters",sqmiles:"Sq Miles"}[r.display]||r.display].join(" ")}var n=this.options.units;return{lengthDisplay:e(t.length,this.options.primaryLengthUnit,this.options.secondaryLengthUnit,this.options.decPoint,this.options.thousandsSep),areaDisplay:e(t.area,this.options.primaryAreaUnit,this.options.secondaryAreaUnit,this.options.decPoint,this.options.thousandsSep)}},_updateResults:function(){var t=(0,s.default)(this._latlngs),e=this._resultsModel=L.extend({},t,this._getMeasurementDisplayStrings(t),{pointCount:this._latlngs.length});this.$results.innerHTML=f({model:e})},_handleMeasureMove:function(t){this._measureDrag?this._measureDrag.setLatLng(t.latlng):this._measureDrag=L.circleMarker(t.latlng,this._symbols.getSymbol("measureDrag")).addTo(this._layer),this._measureDrag.bringToFront()},_handleMeasureDoubleClick:function(){var t=this._latlngs,e=void 0,i=void 0;if(this._finishMeasure(),t.length){t.length>2&&t.push(t[0]);var n=(0,s.default)(t);1===t.length?(e=L.circleMarker(t[0],this._symbols.getSymbol("resultPoint")),i=m({model:n})):2===t.length?(e=L.polyline(t,this._symbols.getSymbol("resultLine")),i=g({model:L.extend({},n,this._getMeasurementDisplayStrings(n))})):(e=L.polygon(t,this._symbols.getSymbol("resultArea")),i=_({model:L.extend({},n,this._getMeasurementDisplayStrings(n))}));var r=L.DomUtil.create("div","");r.innerHTML=i;var o=(0,a.selectOne)(".js-zoomto",r);o&&(L.DomEvent.on(o,"click",L.DomEvent.stop),L.DomEvent.on(o,"click",(function(){e.getBounds?this._map.fitBounds(e.getBounds(),{padding:[20,20],maxZoom:17}):e.getLatLng&&this._map.panTo(e.getLatLng())}),this));var l=(0,a.selectOne)(".js-deletemarkup",r);l&&(L.DomEvent.on(l,"click",L.DomEvent.stop),L.DomEvent.on(l,"click",(function(){this._layer.removeLayer(e)}),this)),e.addTo(this._layer),e.bindPopup(r,this.options.popupOptions),e.getBounds?e.openPopup(e.getBounds().getCenter()):e.getLatLng&&e.openPopup(e.getLatLng())}},_handleMeasureClick:function(t){var e=this._map.mouseEventToLatLng(t.originalEvent),i=this._latlngs[this._latlngs.length-1],n=this._symbols.getSymbol("measureVertex");i&&e.equals(i)||(this._latlngs.push(e),this._addMeasureArea(this._latlngs),this._addMeasureBoundary(this._latlngs),this._measureVertexes.eachLayer((function(t){t.setStyle(n),t._path&&t._path.setAttribute("class",n.className)})),this._addNewVertex(e),this._measureBoundary&&this._measureBoundary.bringToFront(),this._measureVertexes.bringToFront()),this._updateResults(),this._updateMeasureStartedWithPoints()},_handleMapMouseOut:function(){this._measureDrag&&(this._layer.removeLayer(this._measureDrag),this._measureDrag=null)},_addNewVertex:function(t){L.circleMarker(t,this._symbols.getSymbol("measureVertexActive")).addTo(this._measureVertexes)},_addMeasureArea:function(t){t.length<3?this._measureArea&&(this._layer.removeLayer(this._measureArea),this._measureArea=null):this._measureArea?this._measureArea.setLatLngs(t):this._measureArea=L.polygon(t,this._symbols.getSymbol("measureArea")).addTo(this._layer)},_addMeasureBoundary:function(t){t.length<2?this._measureBoundary&&(this._layer.removeLayer(this._measureBoundary),this._measureBoundary=null):this._measureBoundary?this._measureBoundary.setLatLngs(t):this._measureBoundary=L.polyline(t,this._symbols.getSymbol("measureBoundary")).addTo(this._layer)}}),L.Map.mergeOptions({measureControl:!1}),L.Map.addInitHook((function(){this.options.measureControl&&(this.measureControl=(new L.Control.Measure).addTo(this))})),L.control.measure=function(t){return new L.Control.Measure(t)}},function(t,e){},function(t,e,i){var n=i(32),r=i(62),o=i(65),s=i(66),a=i(67),l=i(22),h=i(15),c=i(68),u=i(25),d=i(71),p=i(26),f=/\b__p \+= '';/g,m=/\b(__p \+=) '' \+/g,g=/(__e\(.*?\)|\b__t\)) \+\n'';/g,_=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g,y=/($^)/,v=/['\n\r\u2028\u2029\\]/g;t.exports=function(t,e,i){var b=d.imports._.templateSettings||d;i&&h(t,e,i)&&(e=void 0),t=p(t),e=n({},e,b,s);var x,w,L=n({},e.imports,b.imports,s),M=c(L),k=o(L,M),C=0,A=e.interpolate||y,P="__p += '",S=RegExp((e.escape||y).source+"|"+A.source+"|"+(A===u?_:y).source+"|"+(e.evaluate||y).source+"|$","g"),E="sourceURL"in e?"//# sourceURL="+e.sourceURL+"\n":"";t.replace(S,(function(e,i,n,r,o,s){return n||(n=r),P+=t.slice(C,s).replace(v,a),i&&(x=!0,P+="' +\n__e("+i+") +\n'"),o&&(w=!0,P+="';\n"+o+";\n__p += '"),n&&(P+="' +\n((__t = ("+n+")) == null ? '' : __t) +\n'"),C=s+e.length,e})),P+="';\n";var I=e.variable;I||(P="with (obj) {\n"+P+"\n}\n"),P=(w?P.replace(f,""):P).replace(m,"$1").replace(g,"$1;"),P="function("+(I||"obj")+") {\n"+(I?"":"obj || (obj = {});\n")+"var __t, __p = ''"+(x?", __e = _.escape":"")+(w?", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n":";\n")+P+"return __p\n}";var T=r((function(){return Function(M,E+"return "+P).apply(void 0,k)}));if(T.source=P,l(T))throw T;return T}},function(t,e,i){var n=i(33),r=i(44),o=i(50),s=r((function(t,e,i,r){n(e,o(e),t,r)}));t.exports=s},function(t,e,i){var n=i(34),r=i(8);t.exports=function(t,e,i,o){var s=!i;i||(i={});for(var a=-1,l=e.length;++a<l;){var h=e[a],c=o?o(i[h],t[h],h,i,t):void 0;void 0===c&&(c=t[h]),s?r(i,h,c):n(i,h,c)}return i}},function(t,e,i){var n=i(8),r=i(6),o=Object.prototype.hasOwnProperty;t.exports=function(t,e,i){var s=t[e];o.call(t,e)&&r(s,i)&&(void 0!==i||e in t)||n(t,e,i)}},function(t,e,i){var n=i(36),r=i(43);t.exports=function(t,e){var i=r(t,e);return n(i)?i:void 0}},function(t,e,i){var n=i(10),r=i(40),o=i(2),s=i(42),a=/^\[object .+?Constructor\]$/,l=Function.prototype,h=Object.prototype,c=l.toString,u=h.hasOwnProperty,d=RegExp("^"+c.call(u).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");t.exports=function(t){return!(!o(t)||r(t))&&(n(t)?d:a).test(s(t))}},function(t,e){var i;i=function(){return this}();try{i=i||Function("return this")()||(0,eval)("this")}catch(t){"object"==typeof window&&(i=window)}t.exports=i},function(t,e,i){var n=i(4),r=Object.prototype,o=r.hasOwnProperty,s=r.toString,a=n?n.toStringTag:void 0;t.exports=function(t){var e=o.call(t,a),i=t[a];try{t[a]=void 0;var n=!0}catch(t){}var r=s.call(t);return n&&(e?t[a]=i:delete t[a]),r}},function(t,e){var i=Object.prototype.toString;t.exports=function(t){return i.call(t)}},function(t,e,i){var n=i(41),r=function(){var t=/[^.]+$/.exec(n&&n.keys&&n.keys.IE_PROTO||"");return t?"Symbol(src)_1."+t:""}();t.exports=function(t){return!!r&&r in t}},function(t,e,i){var n=i(5)["__core-js_shared__"];t.exports=n},function(t,e){var i=Function.prototype.toString;t.exports=function(t){if(null!=t){try{return i.call(t)}catch(t){}try{return t+""}catch(t){}}return""}},function(t,e){t.exports=function(t,e){return null==t?void 0:t[e]}},function(t,e,i){var n=i(12),r=i(15);t.exports=function(t){return n((function(e,i){var n=-1,o=i.length,s=o>1?i[o-1]:void 0,a=o>2?i[2]:void 0;for(s=t.length>3&&"function"==typeof s?(o--,s):void 0,a&&r(i[0],i[1],a)&&(s=o<3?void 0:s,o=1),e=Object(e);++n<o;){var l=i[n];l&&t(e,l,n,s)}return e}))}},function(t,e,i){var n=i(14),r=Math.max;t.exports=function(t,e,i){return e=r(void 0===e?t.length-1:e,0),function(){for(var o=arguments,s=-1,a=r(o.length-e,0),l=Array(a);++s<a;)l[s]=o[e+s];s=-1;for(var h=Array(e+1);++s<e;)h[s]=o[s];return h[e]=i(l),n(t,this,h)}}},function(t,e,i){var n=i(47),r=i(49)(n);t.exports=r},function(t,e,i){var n=i(48),r=i(9),o=i(13),s=r?function(t,e){return r(t,"toString",{configurable:!0,enumerable:!1,value:n(e),writable:!0})}:o;t.exports=s},function(t,e){t.exports=function(t){return function(){return t}}},function(t,e){var i=Date.now;t.exports=function(t){var e=0,n=0;return function(){var r=i(),o=16-(r-n);if(n=r,o>0){if(++e>=800)return arguments[0]}else e=0;return t.apply(void 0,arguments)}}},function(t,e,i){var n=i(18),r=i(60),o=i(7);t.exports=function(t){return o(t)?n(t,!0):r(t)}},function(t,e){t.exports=function(t,e){for(var i=-1,n=Array(t);++i<t;)n[i]=e(i);return n}},function(t,e,i){var n=i(53),r=i(1),o=Object.prototype,s=o.hasOwnProperty,a=o.propertyIsEnumerable,l=n(function(){return arguments}())?n:function(t){return r(t)&&s.call(t,"callee")&&!a.call(t,"callee")};t.exports=l},function(t,e,i){var n=i(0),r=i(1);t.exports=function(t){return r(t)&&"[object Arguments]"==n(t)}},function(t,e,i){(function(t){var n=i(5),r=i(55),o="object"==typeof e&&e&&!e.nodeType&&e,s=o&&"object"==typeof t&&t&&!t.nodeType&&t,a=s&&s.exports===o?n.Buffer:void 0,l=(a?a.isBuffer:void 0)||r;t.exports=l}).call(e,i(20)(t))},function(t,e){t.exports=function(){return!1}},function(t,e,i){var n=i(57),r=i(58),o=i(59),s=o&&o.isTypedArray,a=s?r(s):n;t.exports=a},function(t,e,i){var n=i(0),r=i(16),o=i(1),s={};s["[object Float32Array]"]=s["[object Float64Array]"]=s["[object Int8Array]"]=s["[object Int16Array]"]=s["[object Int32Array]"]=s["[object Uint8Array]"]=s["[object Uint8ClampedArray]"]=s["[object Uint16Array]"]=s["[object Uint32Array]"]=!0,s["[object Arguments]"]=s["[object Array]"]=s["[object ArrayBuffer]"]=s["[object Boolean]"]=s["[object DataView]"]=s["[object Date]"]=s["[object Error]"]=s["[object Function]"]=s["[object Map]"]=s["[object Number]"]=s["[object Object]"]=s["[object RegExp]"]=s["[object Set]"]=s["[object String]"]=s["[object WeakMap]"]=!1,t.exports=function(t){return o(t)&&r(t.length)&&!!s[n(t)]}},function(t,e){t.exports=function(t){return function(e){return t(e)}}},function(t,e,i){(function(t){var n=i(11),r="object"==typeof e&&e&&!e.nodeType&&e,o=r&&"object"==typeof t&&t&&!t.nodeType&&t,s=o&&o.exports===r&&n.process,a=function(){try{return s&&s.binding&&s.binding("util")}catch(t){}}();t.exports=a}).call(e,i(20)(t))},function(t,e,i){var n=i(2),r=i(21),o=i(61),s=Object.prototype.hasOwnProperty;t.exports=function(t){if(!n(t))return o(t);var e=r(t),i=[];for(var a in t)("constructor"!=a||!e&&s.call(t,a))&&i.push(a);return i}},function(t,e){t.exports=function(t){var e=[];if(null!=t)for(var i in Object(t))e.push(i);return e}},function(t,e,i){var n=i(14),r=i(12),o=i(22),s=r((function(t,e){try{return n(t,void 0,e)}catch(t){return o(t)?t:new Error(t)}}));t.exports=s},function(t,e,i){var n=i(0),r=i(64),o=i(1),s=Function.prototype,a=Object.prototype,l=s.toString,h=a.hasOwnProperty,c=l.call(Object);t.exports=function(t){if(!o(t)||"[object Object]"!=n(t))return!1;var e=r(t);if(null===e)return!0;var i=h.call(e,"constructor")&&e.constructor;return"function"==typeof i&&i instanceof i&&l.call(i)==c}},function(t,e,i){var n=i(23)(Object.getPrototypeOf,Object);t.exports=n},function(t,e,i){var n=i(24);t.exports=function(t,e){return n(e,(function(e){return t[e]}))}},function(t,e,i){var n=i(6),r=Object.prototype,o=r.hasOwnProperty;t.exports=function(t,e,i,s){return void 0===t||n(t,r[i])&&!o.call(s,i)?e:t}},function(t,e){var i={"\\":"\\","'":"'","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"};t.exports=function(t){return"\\"+i[t]}},function(t,e,i){var n=i(18),r=i(69),o=i(7);t.exports=function(t){return o(t)?n(t):r(t)}},function(t,e,i){var n=i(21),r=i(70),o=Object.prototype.hasOwnProperty;t.exports=function(t){if(!n(t))return r(t);var e=[];for(var i in Object(t))o.call(t,i)&&"constructor"!=i&&e.push(i);return e}},function(t,e,i){var n=i(23)(Object.keys,Object);t.exports=n},function(t,e,i){var n=i(72),r={escape:i(77),evaluate:i(78),interpolate:i(25),variable:"",imports:{_:{escape:n}}};t.exports=r},function(t,e,i){var n=i(73),r=i(26),o=/[&<>"']/g,s=RegExp(o.source);t.exports=function(t){return(t=r(t))&&s.test(t)?t.replace(o,n):t}},function(t,e,i){var n=i(74)({"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"});t.exports=n},function(t,e){t.exports=function(t){return function(e){return null==t?void 0:t[e]}}},function(t,e,i){var n=i(4),r=i(24),o=i(19),s=i(76),a=1/0,l=n?n.prototype:void 0,h=l?l.toString:void 0;t.exports=function t(e){if("string"==typeof e)return e;if(o(e))return r(e,t)+"";if(s(e))return h?h.call(e):"";var i=e+"";return"0"==i&&1/e==-a?"-0":i}},function(t,e,i){var n=i(0),r=i(1);t.exports=function(t){return"symbol"==typeof t||r(t)&&"[object Symbol]"==n(t)}},function(t,e){t.exports=/<%-([\s\S]+?)%>/g},function(t,e){t.exports=/<%([\s\S]+?)%>/g},function(t,e,i){"use strict";Object.defineProperty(e,"__esModule",{value:!0}),e.default={acres:{factor:24711e-8,display:"acres",decimals:2},feet:{factor:3.2808,display:"feet",decimals:0},kilometers:{factor:.001,display:"kilometers",decimals:2},hectares:{factor:1e-4,display:"hectares",decimals:2},meters:{factor:1,display:"meters",decimals:0},miles:{factor:3.2808/5280,display:"miles",decimals:2},sqfeet:{factor:10.7639,display:"sqfeet",decimals:0},sqmeters:{factor:1,display:"sqmeters",decimals:0},sqmiles:{factor:3.86102e-7,display:"sqmiles",decimals:2}}},function(t,e,i){"use strict";function n(t){return t&&t.__esModule?t:{default:t}}function r(t){return t<10?"0"+t.toString():t.toString()}function o(t,e,i){var n=Math.abs(t),o=Math.floor(n),s=Math.floor(60*(n-o)),a=Math.round(3600*(n-o-s/60)*100)/100,l=n===t?e:i;return r(o)+"&deg; "+r(s)+"' "+r(a)+'" '+l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(t){var e=t[t.length-1],i=t.map((function(t){return[t.lat,t.lng]})),n=L.polyline(i),r=L.polygon(i),l=1e3*(0,s.default)(n.toGeoJSON(),{units:"kilometers"}),h=(0,a.default)(r.toGeoJSON());return{lastCoord:{dd:{x:e.lng,y:e.lat},dms:{x:o(e.lng,"E","W"),y:o(e.lat,"N","S")}},length:l,area:h}};var s=n(i(81)),a=n(i(84))},function(t,e,i){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var n=i(82),r=i(27),o=i(3);e.default=function(t,e){if(e=e||{},!Object(o.d)(e))throw new Error("options is invalid");if(!t)throw new Error("geojson is required");return Object(r.b)(t,(function(t,i){var r=i.geometry.coordinates;return t+Object(n.a)(r[0],r[1],e)}),0)}},function(t,e,i){"use strict";var n=i(83),r=i(3);e.a=function(t,e,i){if(i=i||{},!Object(r.d)(i))throw new Error("options is invalid");var o=i.units,s=Object(n.a)(t),a=Object(n.a)(e),l=Object(r.a)(a[1]-s[1]),h=Object(r.a)(a[0]-s[0]),c=Object(r.a)(s[1]),u=Object(r.a)(a[1]),d=Math.pow(Math.sin(l/2),2)+Math.pow(Math.sin(h/2),2)*Math.cos(c)*Math.cos(u);return Object(r.g)(2*Math.atan2(Math.sqrt(d),Math.sqrt(1-d)),o)}},function(t,e,i){"use strict";function n(t){if(!t)throw new Error("coord is required");if("Feature"===t.type&&null!==t.geometry&&"Point"===t.geometry.type)return t.geometry.coordinates;if("Point"===t.type)return t.coordinates;if(Array.isArray(t)&&t.length>=2&&void 0===t[0].length&&void 0===t[1].length)return t;throw new Error("coord must be GeoJSON Point or an Array of numbers")}i.d(e,"a",(function(){return n})),i(3)},function(t,e,i){"use strict";function n(t){var e,i=0;switch(t.type){case"Polygon":return r(t.coordinates);case"MultiPolygon":for(e=0;e<t.coordinates.length;e++)i+=r(t.coordinates[e]);return i;case"Point":case"MultiPoint":case"LineString":case"MultiLineString":return 0;case"GeometryCollection":for(e=0;e<t.geometries.length;e++)i+=n(t.geometries[e]);return i}}function r(t){var e=0;if(t&&t.length>0){e+=Math.abs(o(t[0]));for(var i=1;i<t.length;i++)e-=Math.abs(o(t[i]))}return e}function o(t){var e,i,n,r,o,a,h=0,c=t.length;if(c>2){for(a=0;a<c;a++)a===c-2?(n=c-2,r=c-1,o=0):a===c-1?(n=c-1,r=0,o=1):(n=a,r=a+1,o=a+2),e=t[n],i=t[r],h+=(s(t[o][0])-s(e[0]))*Math.sin(s(i[1]));h=h*l*l/2}return h}function s(t){return t*Math.PI/180}Object.defineProperty(e,"__esModule",{value:!0});var a=i(27),l=6378137;e.default=function(t){return Object(a.a)(t,(function(t,e){return t+n(e)}),0)}},function(t,e,i){"use strict";Object.defineProperty(e,"__esModule",{value:!0}),e.selectOne=function(t,e){return e||(e=document),e.querySelector(t)},e.selectAll=function(t,e){return e||(e=document),Array.prototype.slice.call(e.querySelectorAll(t))},e.hide=function(t){if(t)return t.setAttribute("style","display:none;"),t},e.show=function(t){if(t)return t.removeAttribute("style"),t}},function(t,e,i){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var n=function(){function t(t,e){for(var i=0;i<e.length;i++){var n=e[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n)}}return function(e,i,n){return i&&t(e.prototype,i),n&&t(e,n),e}}(),r={activeColor:"#ABE67E",completedColor:"#C8F2BE"},o=function(){function t(e){(function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")})(this,t),this._options=L.extend({},r,this._options,e)}return n(t,[{key:"getSymbol",value:function(t){return{measureDrag:{clickable:!1,radius:4,color:this._options.activeColor,weight:2,opacity:.7,fillColor:this._options.activeColor,fillOpacity:.5,className:"layer-measuredrag"},measureArea:{clickable:!1,stroke:!1,fillColor:this._options.activeColor,fillOpacity:.2,className:"layer-measurearea"},measureBoundary:{clickable:!1,color:this._options.activeColor,weight:2,opacity:.9,fill:!1,className:"layer-measureboundary"},measureVertex:{clickable:!1,radius:4,color:this._options.activeColor,weight:2,opacity:1,fillColor:this._options.activeColor,fillOpacity:.7,className:"layer-measurevertex"},measureVertexActive:{clickable:!1,radius:4,color:this._options.activeColor,weight:2,opacity:1,fillColor:this._options.activeColor,fillOpacity:1,className:"layer-measurevertex active"},resultArea:{clickable:!0,color:this._options.completedColor,weight:2,opacity:.9,fillColor:this._options.completedColor,fillOpacity:.2,className:"layer-measure-resultarea"},resultLine:{clickable:!0,color:this._options.completedColor,weight:3,opacity:.9,fill:!1,className:"layer-measure-resultline"},resultPoint:{clickable:!0,radius:4,color:this._options.completedColor,weight:2,opacity:1,fillColor:this._options.completedColor,fillOpacity:.7,className:"layer-measure-resultpoint"}}[t]}}]),t}();e.default=o},function(t,e,i){"use strict";Object.defineProperty(e,"__esModule",{value:!0}),e.numberFormat=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:2,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:".",n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:",",r=t<0?"-":"",o=Math.abs(+t||0),s=parseInt(o.toFixed(e),10)+"",a=s.length>3?s.length%3:0;return[r,a?s.substr(0,a)+n:"",s.substr(a).replace(/(\d{3})(?=\d)/g,"$1"+n),e?""+i+Math.abs(o-s).toFixed(e).slice(2):""].join("")}},function(t,e,i){"use strict";function n(t){return t&&t.__esModule?t:{default:t}}Object.defineProperty(e,"__esModule",{value:!0});var r=i(89);Object.defineProperty(e,"controlTemplate",{enumerable:!0,get:function(){return n(r).default}});var o=i(90);Object.defineProperty(e,"resultsTemplate",{enumerable:!0,get:function(){return n(o).default}});var s=i(91);Object.defineProperty(e,"pointPopupTemplate",{enumerable:!0,get:function(){return n(s).default}});var a=i(92);Object.defineProperty(e,"linePopupTemplate",{enumerable:!0,get:function(){return n(a).default}});var l=i(93);Object.defineProperty(e,"areaPopupTemplate",{enumerable:!0,get:function(){return n(l).default}})},function(t,e,i){t.exports='<a class="{{ model.className }}-toggle js-toggle" href=# title="Measure distances and areas">Measure</a> <div class="{{ model.className }}-interaction js-interaction"> <div class="js-startprompt startprompt"> <h3>Measure distances and areas</h3> <ul class=tasks> <a href=# class="js-start start">Create a new measurement</a> </ul> </div> <div class=js-measuringprompt> <h3>Measure distances and areas</h3> <p class=js-starthelp>Start creating a measurement by adding points to the map</p> <div class="js-results results"></div> <ul class="js-measuretasks tasks"> <li><a href=# class="js-cancel cancel">Cancel</a></li> <li><a href=# class="js-finish finish">Finish measurement</a></li> </ul> </div> </div> '},function(t,e,i){t.exports='<div class=group> <p class="lastpoint heading">Last point</p> <p>{{ model.lastCoord.dms.y }} <span class=coorddivider>/</span> {{ model.lastCoord.dms.x }}</p> <p>{{ numberFormat(model.lastCoord.dd.y, 6) }} <span class=coorddivider>/</span> {{ numberFormat(model.lastCoord.dd.x, 6) }}</p> </div> <% if (model.pointCount > 1) { %> <div class=group> <p><span class=heading>Path distance</span> {{ model.lengthDisplay }}</p> </div> <% } %> <% if (model.pointCount > 2) { %> <div class=group> <p><span class=heading>Area</span> {{ model.areaDisplay }}</p> </div> <% } %> '},function(t,e,i){t.exports='<h3>Point location</h3> <p>{{ model.lastCoord.dms.y }} <span class=coorddivider>/</span> {{ model.lastCoord.dms.x }}</p> <p>{{ numberFormat(model.lastCoord.dd.y, 6) }} <span class=coorddivider>/</span> {{ numberFormat(model.lastCoord.dd.x, 6) }}</p> <ul class=tasks> <li><a href=# class="js-zoomto zoomto">Center on this location</a></li> <li><a href=# class="js-deletemarkup deletemarkup">Delete</a></li> </ul> '},function(t,e,i){t.exports='<h3>Linear measurement</h3> <p>{{ model.lengthDisplay }}</p> <ul class=tasks> <li><a href=# class="js-zoomto zoomto">Center on this line</a></li> <li><a href=# class="js-deletemarkup deletemarkup">Delete</a></li> </ul> '},function(t,e,i){t.exports='<h3>Area measurement</h3> <p>{{ model.areaDisplay }}</p> <p>{{ model.lengthDisplay }} Perimeter</p> <ul class=tasks> <li><a href=# class="js-zoomto zoomto">Center on this area</a></li> <li><a href=# class="js-deletemarkup deletemarkup">Delete</a></li> </ul> '}])},4554:()=>{var t,e,i;t=L.Marker.prototype._initIcon,e=L.Marker.prototype._setPos,i="msTransform"===L.DomUtil.TRANSFORM,L.Marker.addInitHook((function(){var t=this.options.icon&&this.options.icon.options&&this.options.icon.options.iconAnchor;t&&(t=t[0]+"px "+t[1]+"px"),this.options.rotationOrigin=this.options.rotationOrigin||t||"center bottom",this.options.rotationAngle=this.options.rotationAngle||0,this.on("drag",(function(t){t.target._applyRotation()}))})),L.Marker.include({_initIcon:function(){t.call(this)},_setPos:function(t){e.call(this,t),this._applyRotation()},_applyRotation:function(){this.options.rotationAngle&&(this._icon.style[L.DomUtil.TRANSFORM+"Origin"]=this.options.rotationOrigin,i?this._icon.style[L.DomUtil.TRANSFORM]="rotate("+this.options.rotationAngle+"deg)":this._icon.style[L.DomUtil.TRANSFORM]+=" rotateZ("+this.options.rotationAngle+"deg)")},setRotationAngle:function(t){return this.options.rotationAngle=t,this.update(),this},setRotationOrigin:function(t){return this.options.rotationOrigin=t,this.update(),this}})},2874:(t,e,n)=>{var r,o,s;o=[n(4067)],void 0===(s="function"==typeof(r=function(t){return t.Control.Search=t.Control.extend({includes:"1"===t.version[0]?t.Evented.prototype:t.Mixin.Events,options:{url:"",layer:null,sourceData:null,jsonpParam:null,propertyLoc:"loc",propertyName:"title",formatData:null,filterData:null,moveToLocation:null,buildTip:null,container:"",zoom:null,minLength:1,initial:!0,casesensitive:!1,autoType:!0,delayType:400,tooltipLimit:-1,tipAutoSubmit:!0,firstTipSubmit:!1,autoResize:!0,collapsed:!0,autoCollapse:!1,autoCollapseTime:1200,textErr:"Location not found",textCancel:"Cancel",textPlaceholder:"Search...",hideMarkerOnCollapse:!1,position:"topleft",marker:{icon:!1,animate:!0,circle:{radius:10,weight:3,color:"#e03",stroke:!0,fill:!1}}},_getPath:function(t,e){var i=e.split("."),n=i.pop(),r=i.length,o=i[0],s=1;if(r>0)for(;(t=t[o])&&s<r;)o=i[s++];if(t)return t[n]},_isObject:function(t){return"[object Object]"===Object.prototype.toString.call(t)},initialize:function(e){t.Util.setOptions(this,e||{}),this._inputMinSize=this.options.textPlaceholder?this.options.textPlaceholder.length:10,this._layer=this.options.layer||new t.LayerGroup,this._filterData=this.options.filterData||this._defaultFilterData,this._formatData=this.options.formatData||this._defaultFormatData,this._moveToLocation=this.options.moveToLocation||this._defaultMoveToLocation,this._autoTypeTmp=this.options.autoType,this._countertips=0,this._recordsCache={},this._curReq=null},onAdd:function(e){return this._map=e,this._container=t.DomUtil.create("div","leaflet-control-search"),this._input=this._createInput(this.options.textPlaceholder,"search-input"),this._tooltip=this._createTooltip("search-tooltip"),this._cancel=this._createCancel(this.options.textCancel,"search-cancel"),this._button=this._createButton(this.options.textPlaceholder,"search-button"),this._alert=this._createAlert("search-alert"),!1===this.options.collapsed&&this.expand(this.options.collapsed),this.options.marker&&(this.options.marker instanceof t.Marker||this.options.marker instanceof t.CircleMarker?this._markerSearch=this.options.marker:this._isObject(this.options.marker)&&(this._markerSearch=new t.Control.Search.Marker([0,0],this.options.marker)),this._markerSearch._isMarkerSearch=!0),this.setLayer(this._layer),e.on({resize:this._handleAutoresize},this),this._container},addTo:function(e){return this.options.container?(this._container=this.onAdd(e),this._wrapper=t.DomUtil.get(this.options.container),this._wrapper.style.position="relative",this._wrapper.appendChild(this._container)):t.Control.prototype.addTo.call(this,e),this},onRemove:function(t){this._recordsCache={},t.off({resize:this._handleAutoresize},this)},setLayer:function(t){return this._layer=t,this._layer.addTo(this._map),this},showAlert:function(t){var e=this;return t=t||this.options.textErr,this._alert.style.display="block",this._alert.innerHTML=t,clearTimeout(this.timerAlert),this.timerAlert=setTimeout((function(){e.hideAlert()}),this.options.autoCollapseTime),this},hideAlert:function(){return this._alert.style.display="none",this},cancel:function(){return this._input.value="",this._handleKeypress({keyCode:8}),this._input.size=this._inputMinSize,this._input.focus(),this._cancel.style.display="none",this._hideTooltip(),this.fire("search:cancel"),this},expand:function(e){return e="boolean"!=typeof e||e,this._input.style.display="block",t.DomUtil.addClass(this._container,"search-exp"),!1!==e&&(this._input.focus(),this._map.on("dragstart click",this.collapse,this)),this.fire("search:expanded"),this},collapse:function(){return this._hideTooltip(),this.cancel(),this._alert.style.display="none",this._input.blur(),this.options.collapsed&&(this._input.style.display="none",this._cancel.style.display="none",t.DomUtil.removeClass(this._container,"search-exp"),this.options.hideMarkerOnCollapse&&this._map.removeLayer(this._markerSearch),this._map.off("dragstart click",this.collapse,this)),this.fire("search:collapsed"),this},collapseDelayed:function(){var t=this;return this.options.autoCollapse?(clearTimeout(this.timerCollapse),this.timerCollapse=setTimeout((function(){t.collapse()}),this.options.autoCollapseTime),this):this},collapseDelayedStop:function(){return clearTimeout(this.timerCollapse),this},_createAlert:function(e){var i=t.DomUtil.create("div",e,this._container);return i.style.display="none",t.DomEvent.on(i,"click",t.DomEvent.stop,this).on(i,"click",this.hideAlert,this),i},_createInput:function(e,i){var n=this,r=t.DomUtil.create("label",i,this._container),o=t.DomUtil.create("input",i,this._container);return o.type="text",o.size=this._inputMinSize,o.value="",o.autocomplete="off",o.autocorrect="off",o.autocapitalize="off",o.placeholder=e,o.style.display="none",o.role="search",o.id=o.role+o.type+o.size,r.htmlFor=o.id,r.style.display="none",r.value=e,t.DomEvent.disableClickPropagation(o).on(o,"keyup",this._handleKeypress,this).on(o,"paste",(function(t){setTimeout((function(t){n._handleKeypress(t)}),10,t)}),this).on(o,"blur",this.collapseDelayed,this).on(o,"focus",this.collapseDelayedStop,this),o},_createCancel:function(e,i){var n=t.DomUtil.create("a",i,this._container);return n.href="#",n.title=e,n.style.display="none",n.innerHTML="<span>&otimes;</span>",t.DomEvent.on(n,"click",t.DomEvent.stop,this).on(n,"click",this.cancel,this),n},_createButton:function(e,i){var n=t.DomUtil.create("a",i,this._container);return n.href="#",n.title=e,t.DomEvent.on(n,"click",t.DomEvent.stop,this).on(n,"click",this._handleSubmit,this).on(n,"focus",this.collapseDelayedStop,this).on(n,"blur",this.collapseDelayed,this),n},_createTooltip:function(e){var i=this,n=t.DomUtil.create("ul",e,this._container);return n.style.display="none",t.DomEvent.disableClickPropagation(n).on(n,"blur",this.collapseDelayed,this).on(n,"mousewheel",(function(e){i.collapseDelayedStop(),t.DomEvent.stopPropagation(e)}),this).on(n,"mouseover",(function(t){i.collapseDelayedStop()}),this),n},_createTip:function(e,i){var n;if(this.options.buildTip){if("string"==typeof(n=this.options.buildTip.call(this,e,i))){var r=t.DomUtil.create("div");r.innerHTML=n,n=r.firstChild}}else(n=t.DomUtil.create("li","")).innerHTML=e;return t.DomUtil.addClass(n,"search-tip"),n._text=e,this.options.tipAutoSubmit&&t.DomEvent.disableClickPropagation(n).on(n,"click",t.DomEvent.stop,this).on(n,"click",(function(t){this._input.value=e,this._handleAutoresize(),this._input.focus(),this._hideTooltip(),this._handleSubmit()}),this),n},_getUrl:function(t){return"function"==typeof this.options.url?this.options.url(t):this.options.url},_defaultFilterData:function(t,e){var i,n,r,o={};if(""===(t=t.replace(/[.*+?^${}()|[\]\\]/g,"")))return[];for(var s in i=this.options.initial?"^":"",n=this.options.casesensitive?void 0:"i",r=new RegExp(i+t,n),e)r.test(s)&&(o[s]=e[s]);return o},showTooltip:function(t){if(this._countertips=0,this._tooltip.innerHTML="",this._tooltip.currentSelection=-1,this.options.tooltipLimit)for(var e in t){if(this._countertips===this.options.tooltipLimit)break;this._countertips++,this._tooltip.appendChild(this._createTip(e,t[e]))}return this._countertips>0?(this._tooltip.style.display="block",this._autoTypeTmp&&this._autoType(),this._autoTypeTmp=this.options.autoType):this._hideTooltip(),this._tooltip.scrollTop=0,this._countertips},_hideTooltip:function(){return this._tooltip.style.display="none",this._tooltip.innerHTML="",0},_defaultFormatData:function(e){var i,n=this,r=this.options.propertyName,o=this.options.propertyLoc,s={};if(t.Util.isArray(o))for(i in e)s[n._getPath(e[i],r)]=t.latLng(e[i][o[0]],e[i][o[1]]);else for(i in e)s[n._getPath(e[i],r)]=t.latLng(n._getPath(e[i],o));return s},_recordsFromJsonp:function(e,i){t.Control.Search.callJsonp=i;var n=t.DomUtil.create("script","leaflet-search-jsonp",document.getElementsByTagName("body")[0]),r=t.Util.template(this._getUrl(e)+"&"+this.options.jsonpParam+"=L.Control.Search.callJsonp",{s:e});return n.type="text/javascript",n.src=r,{abort:function(){n.parentNode.removeChild(n)}}},_recordsFromAjax:function(e,i){void 0===window.XMLHttpRequest&&(window.XMLHttpRequest=function(){try{return new ActiveXObject("Microsoft.XMLHTTP.6.0")}catch(t){try{return new ActiveXObject("Microsoft.XMLHTTP.3.0")}catch(t){throw new Error("XMLHttpRequest is not supported")}}});var n=t.Browser.ie&&!window.atob&&document.querySelector?new XDomainRequest:new XMLHttpRequest,r=t.Util.template(this._getUrl(e),{s:e});return n.open("GET",r),n.onload=function(){i(JSON.parse(n.responseText))},n.onreadystatechange=function(){4===n.readyState&&200===n.status&&this.onload()},n.send(),n},_searchInLayer:function(e,i,n){var r,o=this;e instanceof t.Control.Search.Marker||(e instanceof t.Marker||e instanceof t.CircleMarker?o._getPath(e.options,n)?((r=e.getLatLng()).layer=e,i[o._getPath(e.options,n)]=r):o._getPath(e.feature.properties,n)?((r=e.getLatLng()).layer=e,i[o._getPath(e.feature.properties,n)]=r):console.warn("propertyName '"+n+"' not found in marker"):e instanceof t.Path||e instanceof t.Polyline||e instanceof t.Polygon?o._getPath(e.options,n)?((r=e.getBounds().getCenter()).layer=e,i[o._getPath(e.options,n)]=r):o._getPath(e.feature.properties,n)?((r=e.getBounds().getCenter()).layer=e,i[o._getPath(e.feature.properties,n)]=r):console.warn("propertyName '"+n+"' not found in shape"):e.hasOwnProperty("feature")?e.feature.properties.hasOwnProperty(n)?e.getLatLng&&"function"==typeof e.getLatLng?((r=e.getLatLng()).layer=e,i[e.feature.properties[n]]=r):e.getBounds&&"function"==typeof e.getBounds?((r=e.getBounds().getCenter()).layer=e,i[e.feature.properties[n]]=r):console.warn("Unknown type of Layer"):console.warn("propertyName '"+n+"' not found in feature"):e instanceof t.LayerGroup&&e.eachLayer((function(t){o._searchInLayer(t,i,n)})))},_recordsFromLayer:function(){var t=this,e={},i=this.options.propertyName;return this._layer.eachLayer((function(n){t._searchInLayer(n,e,i)})),e},_autoType:function(){var t=this._input.value.length,e=this._tooltip.firstChild?this._tooltip.firstChild._text:"",i=e.length;if(0===e.indexOf(this._input.value))if(this._input.value=e,this._handleAutoresize(),this._input.createTextRange){var n=this._input.createTextRange();n.collapse(!0),n.moveStart("character",t),n.moveEnd("character",i),n.select()}else this._input.setSelectionRange?this._input.setSelectionRange(t,i):this._input.selectionStart&&(this._input.selectionStart=t,this._input.selectionEnd=i)},_hideAutoType:function(){var t;if((t=this._input.selection)&&t.empty)t.empty();else if(this._input.createTextRange){(t=this._input.createTextRange()).collapse(!0);var e=this._input.value.length;t.moveStart("character",e),t.moveEnd("character",e),t.select()}else this._input.getSelection&&this._input.getSelection().removeAllRanges(),this._input.selectionStart=this._input.selectionEnd},_handleKeypress:function(t){var e=this;switch(t.keyCode){case 27:this.collapse();break;case 13:(1==this._countertips||this.options.firstTipSubmit&&this._countertips>0)&&-1==this._tooltip.currentSelection&&this._handleArrowSelect(1),this._handleSubmit();break;case 38:this._handleArrowSelect(-1);break;case 40:this._handleArrowSelect(1);break;case 8:case 45:case 46:this._autoTypeTmp=!1;break;case 37:case 39:case 16:case 17:case 35:case 36:break;default:this._input.value.length?this._cancel.style.display="block":this._cancel.style.display="none",this._input.value.length>=this.options.minLength?(clearTimeout(this.timerKeypress),this.timerKeypress=setTimeout((function(){e._fillRecordsCache()}),this.options.delayType)):this._hideTooltip()}this._handleAutoresize()},searchText:function(e){var i=e.charCodeAt(e.length);this._input.value=e,this._input.style.display="block",t.DomUtil.addClass(this._container,"search-exp"),this._autoTypeTmp=!1,this._handleKeypress({keyCode:i})},_fillRecordsCache:function(){var e,i=this,n=this._input.value;this._curReq&&this._curReq.abort&&this._curReq.abort(),t.DomUtil.addClass(this._container,"search-load"),this.options.layer?(this._recordsCache=this._recordsFromLayer(),e=this._filterData(this._input.value,this._recordsCache),this.showTooltip(e),t.DomUtil.removeClass(this._container,"search-load")):(this.options.sourceData?this._retrieveData=this.options.sourceData:this.options.url&&(this._retrieveData=this.options.jsonpParam?this._recordsFromJsonp:this._recordsFromAjax),this._curReq=this._retrieveData.call(this,n,(function(n){i._recordsCache=i._formatData.call(i,n),e=i.options.sourceData?i._filterData(i._input.value,i._recordsCache):i._recordsCache,i.showTooltip(e),t.DomUtil.removeClass(i._container,"search-load")})))},_handleAutoresize:function(){var t;this._input.style.maxWidth!==this._map._container.offsetWidth&&(t=this._map._container.clientWidth,t-=83,this._input.style.maxWidth=t.toString()+"px"),this.options.autoResize&&this._container.offsetWidth+20<this._map._container.offsetWidth&&(this._input.size=this._input.value.length<this._inputMinSize?this._inputMinSize:this._input.value.length)},_handleArrowSelect:function(e){var n=this._tooltip.hasChildNodes()?this._tooltip.childNodes:[];for(i=0;i<n.length;i++)t.DomUtil.removeClass(n[i],"search-tip-select");if(1==e&&this._tooltip.currentSelection>=n.length-1)t.DomUtil.addClass(n[this._tooltip.currentSelection],"search-tip-select");else if(-1==e&&this._tooltip.currentSelection<=0)this._tooltip.currentSelection=-1;else if("none"!=this._tooltip.style.display){this._tooltip.currentSelection+=e,t.DomUtil.addClass(n[this._tooltip.currentSelection],"search-tip-select"),this._input.value=n[this._tooltip.currentSelection]._text;var r=n[this._tooltip.currentSelection].offsetTop;r+n[this._tooltip.currentSelection].clientHeight>=this._tooltip.scrollTop+this._tooltip.clientHeight?this._tooltip.scrollTop=r-this._tooltip.clientHeight+n[this._tooltip.currentSelection].clientHeight:r<=this._tooltip.scrollTop&&(this._tooltip.scrollTop=r)}},_handleSubmit:function(){if(this._hideAutoType(),this.hideAlert(),this._hideTooltip(),"none"==this._input.style.display)this.expand();else if(""===this._input.value)this.collapse();else{var t=this._getLocation(this._input.value);!1===t?this.showAlert():(this.showLocation(t,this._input.value),this.fire("search:locationfound",{latlng:t,text:this._input.value,layer:t.layer?t.layer:null}))}},_getLocation:function(t){return!!this._recordsCache.hasOwnProperty(t)&&this._recordsCache[t]},_defaultMoveToLocation:function(t,e,i){this.options.zoom?this._map.setView(t,this.options.zoom):this._map.panTo(t)},showLocation:function(t,e){var i=this;return i._map.once("moveend zoomend",(function(e){i._markerSearch&&i._markerSearch.addTo(i._map).setLatLng(t)})),i._moveToLocation(t,e,i._map),i.options.autoCollapse&&i.collapse(),i}}),t.Control.Search.Marker=t.Marker.extend({includes:"1"===t.version[0]?t.Evented.prototype:t.Mixin.Events,options:{icon:new t.Icon.Default,animate:!0,circle:{radius:10,weight:3,color:"#e03",stroke:!0,fill:!1}},initialize:function(e,i){t.setOptions(this,i),!0===i.icon&&(i.icon=new t.Icon.Default),t.Marker.prototype.initialize.call(this,e,i),t.Control.Search.prototype._isObject(this.options.circle)&&(this._circleLoc=new t.CircleMarker(e,this.options.circle))},onAdd:function(e){t.Marker.prototype.onAdd.call(this,e),this._circleLoc&&(e.addLayer(this._circleLoc),this.options.animate&&this.animate())},onRemove:function(e){t.Marker.prototype.onRemove.call(this,e),this._circleLoc&&e.removeLayer(this._circleLoc)},setLatLng:function(e){return t.Marker.prototype.setLatLng.call(this,e),this._circleLoc&&this._circleLoc.setLatLng(e),this},_initIcon:function(){this.options.icon&&t.Marker.prototype._initIcon.call(this)},_removeIcon:function(){this.options.icon&&t.Marker.prototype._removeIcon.call(this)},animate:function(){if(this._circleLoc){var t=this._circleLoc,e=parseInt(t._radius/5),i=this.options.circle.radius,n=2*t._radius,r=0;t._timerAnimLoc=setInterval((function(){n-=e+=r+=.5,t.setRadius(n),n<i&&(clearInterval(t._timerAnimLoc),t.setRadius(i))}),200)}return this}}),t.Map.addInitHook((function(){this.options.searchControl&&(this.searchControl=t.control.search(this.options.searchControl),this.addControl(this.searchControl))})),t.control.search=function(e){return new t.Control.Search(e)},t.Control.Search})?r.apply(e,o):r)||(t.exports=s)},4504:(t,e,i)=>{var n,r,o=i(4067);function s(t,e,i,n){e.split(" ").forEach((function(e){o.DomEvent.on(t,e,i,n)}))}function a(t,e,i,n){e.split(" ").forEach((function(e){o.DomEvent.off(t,e,i,n)}))}function l(t){return"oninput"in t?"input":"change"}function h(){n=this._map.dragging.enabled(),r=this._map.tap&&this._map.tap.enabled(),this._map.dragging.disable(),this._map.tap&&this._map.tap.disable()}function c(t){this._refocusOnMap(t),n&&this._map.dragging.enable(),r&&this._map.tap.enable()}function u(t){return"undefined"===t?[]:Array.isArray(t)?t:[t]}i(5786),i(7609),o.Control.SplitMap=o.Control.extend({options:{thumbSize:42,padding:0},initialize:function(t,e,i){this._leftLayers=u(t),this._rightLayers=u(e),this._updateClip(),o.setOptions(this,i)},getPosition:function(){var t=this._range.value,e=(.5-t)*(2*this.options.padding+this.options.thumbSize);return this._map.getSize().x*t+e},setPosition:function(){},includes:"1"===o.version.split(".")[0]?o.Evented.prototype:o.Mixin.Events,addTo:function(t){this.remove(),this._map=t;var e=this._container=o.DomUtil.create("div","leaflet-sbs",t._controlContainer);this._divider=o.DomUtil.create("div","leaflet-sbs-divider",e);var i=this._range=o.DomUtil.create("input","leaflet-sbs-range",e);return i.type="range",i.min=0,i.max=1,i.step="any",i.value=.5,i.style.paddingLeft=i.style.paddingRight=this.options.padding+"px",this._addEvents(),this._updateClip(),this},remove:function(){return this._map?(this._leftLayers.forEach((t=>{t.getContainer?t.getContainer().style.clip="":t.getPane().style.clip=""})),this._rightLayers.forEach((t=>{t.getContainer?t.getContainer().style.clip="":t.getPane().style.clip=""})),this._removeEvents(),o.DomUtil.remove(this._container),this._map=null,this):this},_updateClip:function(){if(!this._map)return this;var t=this._map,e=t.containerPointToLayerPoint([0,0]),i=t.containerPointToLayerPoint(t.getSize()),n=e.x+this.getPosition(),r=this.getPosition();this._divider.style.left=r+"px",this.fire("dividermove",{x:r});var o="rect("+[e.y,n,i.y,e.x].join("px,")+"px)",s="rect("+[e.y,i.x,i.y,n].join("px,")+"px)";this._leftLayers.forEach((t=>{t.getContainer?t.getContainer().style.clip=o:t.getPane().style.clip=o})),this._rightLayers.forEach((t=>{t.getContainer?t.getContainer().style.clip=s:t.getPane().style.clip=s}))},_addEvents:function(){var t=this._range,e=this._map;e&&t&&(e.on("move",this._updateClip,this),e.on("layeradd layerremove",this._updateLayers,this),s(t,l(t),this._updateClip,this),s(t,"ontouchstart"in window?"touchstart":"mousedown",h,this),s(t,"ontouchend"in window?"touchend":"mouseup",c,this))},_removeEvents:function(){var t=this._range,e=this._map;t&&(a(t,l(t),this._updateClip,this),a(t,"ontouchstart"in window?"touchstart":"mousedown",h,this),a(t,"ontouchend"in window?"touchend":"mouseup",c,this)),e&&(e.off("layeradd layerremove",this._updateLayers,this),e.off("move",this._updateClip,this))}}),o.control.splitMap=function(t,e,i){return new o.Control.SplitMap(t,e,i)},t.exports=o.Control.SplitMap},3330:()=>{function t(){return!0}L.Canvas.include({_resetTransformPath:function(t){this._containerCopy&&(delete this._containerCopy,t._containsPoint_&&(t._containsPoint=t._containsPoint_,delete t._containsPoint_,this._requestRedraw(t)))},transformPath:function(e,i){var n,r=this._containerCopy,o=this._ctx,s=L.Browser.retina?2:1,a=this._bounds,l=a.getSize(),h=a.min;r||(n=(r=this._containerCopy=document.createElement("canvas")).getContext("2d"),r.width=s*l.x,r.height=s*l.y,this._removePath(e),this._redraw(),n.translate(s*a.min.x,s*a.min.y),n.drawImage(this._container,0,0),this._initPath(e),e._containsPoint_=e._containsPoint,e._containsPoint=t),o.save(),o.clearRect(h.x,h.y,l.x*s,l.y*s),o.setTransform(1,0,0,1,0,0),o.restore(),o.save(),o.drawImage(this._containerCopy,0,0,l.x,l.y),o.transform.apply(o,i),this._drawing=!0,e._updatePath(),this._drawing=!1,o.restore()}})},9803:()=>{L.Matrix=function(t,e,i,n,r,o){this._matrix=[t,e,i,n,r,o]},L.Matrix.prototype={transform:function(t){return this._transform(t.clone())},_transform:function(t){var e=this._matrix,i=t.x,n=t.y;return t.x=e[0]*i+e[1]*n+e[4],t.y=e[2]*i+e[3]*n+e[5],t},untransform:function(t){var e=this._matrix;return new L.Point((t.x/e[0]-e[4])/e[0],(t.y/e[2]-e[5])/e[2])},clone:function(){var t=this._matrix;return new L.Matrix(t[0],t[1],t[2],t[3],t[4],t[5])},translate:function(t){return void 0===t?new L.Point(this._matrix[4],this._matrix[5]):("number"==typeof t?e=i=t:(e=t.x,i=t.y),this._add(1,0,0,1,e,i));var e,i},scale:function(t,e){return void 0===t?new L.Point(this._matrix[0],this._matrix[3]):(e=e||L.point(0,0),"number"==typeof t?i=n=t:(i=t.x,n=t.y),this._add(i,0,0,n,e.x,e.y)._add(1,0,0,1,-e.x,-e.y));var i,n},rotate:function(t,e){var i=Math.cos(t),n=Math.sin(t);return e=e||new L.Point(0,0),this._add(i,n,-n,i,e.x,e.y)._add(1,0,0,1,-e.x,-e.y)},flip:function(){return this._matrix[1]*=-1,this._matrix[2]*=-1,this},_add:function(t,e,i,n,r,o){var s,a=[[],[],[]],l=this._matrix,h=[[l[0],l[2],l[4]],[l[1],l[3],l[5]],[0,0,1]],c=[[t,i,r],[e,n,o],[0,0,1]];t&&t instanceof L.Matrix&&(c=[[(l=t._matrix)[0],l[2],l[4]],[l[1],l[3],l[5]],[0,0,1]]);for(var u=0;u<3;u++)for(var d=0;d<3;d++){s=0;for(var p=0;p<3;p++)s+=h[u][p]*c[p][d];a[u][d]=s}return this._matrix=[a[0][0],a[1][0],a[0][1],a[1][1],a[0][2],a[1][2]],this}},L.matrix=function(t,e,i,n,r,o){return new L.Matrix(t,e,i,n,r,o)}},3629:(t,e,i)=>{i(6410),i(1639),i(3330),L.Path.include({_transform:function(t){return this._renderer&&(t?this._renderer.transformPath(this,t):(this._renderer._resetTransformPath(this),this._update())),this},_onMouseClick:function(t){this.dragging&&this.dragging.moved()||this._map.dragging&&this._map.dragging.moved()||this._fireMouseEvent(t)}});var n={mousedown:"mouseup",touchstart:"touchend",pointerdown:"touchend",MSPointerDown:"touchend"},r={mousedown:"mousemove",touchstart:"touchmove",pointerdown:"touchmove",MSPointerDown:"touchmove"};L.Handler.PathDrag=L.Handler.extend({statics:{DRAGGING_CLS:"leaflet-path-draggable"},initialize:function(t){this._path=t,this._matrix=null,this._startPoint=null,this._dragStartPoint=null,this._mapDraggingWasEnabled=!1},addHooks:function(){this._path.on("mousedown",this._onDragStart,this),this._path.options.className=this._path.options.className?this._path.options.className+" "+L.Handler.PathDrag.DRAGGING_CLS:L.Handler.PathDrag.DRAGGING_CLS,this._path._path&&L.DomUtil.addClass(this._path._path,L.Handler.PathDrag.DRAGGING_CLS)},removeHooks:function(){this._path.off("mousedown",this._onDragStart,this),this._path.options.className=this._path.options.className.replace(new RegExp("\\s+"+L.Handler.PathDrag.DRAGGING_CLS),""),this._path._path&&L.DomUtil.removeClass(this._path._path,L.Handler.PathDrag.DRAGGING_CLS)},moved:function(){return this._path._dragMoved},_onDragStart:function(t){var e=t.originalEvent._simulated?"touchstart":t.originalEvent.type;this._mapDraggingWasEnabled=!1,this._startPoint=t.containerPoint.clone(),this._dragStartPoint=t.containerPoint.clone(),this._matrix=[1,0,0,1,0,0],L.DomEvent.stop(t.originalEvent),L.DomUtil.addClass(this._path._renderer._container,"leaflet-interactive"),L.DomEvent.on(document,r[e],this._onDrag,this).on(document,n[e],this._onDragEnd,this),this._path._map.dragging.enabled()&&(this._path._map.dragging.disable(),this._mapDraggingWasEnabled=!0),this._path._dragMoved=!1,this._path._popup&&this._path._popup._close(),this._replaceCoordGetters(t)},_onDrag:function(t){L.DomEvent.stop(t);var e=t.touches&&t.touches.length>=1?t.touches[0]:t,i=this._path._map.mouseEventToContainerPoint(e);if("touchmove"!==t.type||this._path._dragMoved||!(this._dragStartPoint.distanceTo(i)<=this._path._map.options.tapTolerance)){var n=i.x,r=i.y,o=n-this._startPoint.x,s=r-this._startPoint.y;(o||s)&&(this._path._dragMoved||(this._path._dragMoved=!0,this._path.fire("dragstart",t),this._path.bringToFront()),this._matrix[4]+=o,this._matrix[5]+=s,this._startPoint.x=n,this._startPoint.y=r,this._path.fire("predrag",t),this._path._transform(this._matrix),this._path.fire("drag",t))}},_onDragEnd:function(t){var e,i,n,r,o=this._path._map.mouseEventToContainerPoint(t),s=this.moved();if(s&&(this._transformPoints(this._matrix),this._path._updatePath(),this._path._project(),this._path._transform(null),L.DomEvent.stop(t)),L.DomEvent.off(document,"mousemove touchmove",this._onDrag,this),L.DomEvent.off(document,"mouseup touchend",this._onDragEnd,this),this._restoreCoordGetters(),s){this._path.fire("dragend",{distance:(e=this._dragStartPoint,i=o,n=e.x-i.x,r=e.y-i.y,Math.sqrt(n*n+r*r))});var a=this._path._containsPoint;this._path._containsPoint=L.Util.falseFn,L.Util.requestAnimFrame((function(){L.DomEvent.skipped({type:"click"}),this._path._containsPoint=a}),this)}this._matrix=null,this._startPoint=null,this._dragStartPoint=null,this._path._dragMoved=!1,this._mapDraggingWasEnabled&&(s&&L.DomEvent.fakeStop({type:"click"}),this._path._map.dragging.enable())},_transformPoints:function(t,e){var i,n,r,o=this._path,s=L.point(t[4],t[5]),a=o._map.options.crs,l=a.transformation,h=a.scale(o._map.getZoom()),c=a.projection,u=l.untransform(s,h).subtract(l.untransform(L.point(0,0),h)),d=!e;if(o._bounds=new L.LatLngBounds,o._point)e=c.unproject(c.project(o._latlng)._add(u)),d&&(o._latlng=e,o._point._add(s));else if(o._rings||o._parts){var p=o._rings||o._parts,f=o._latlngs;for(e=e||f,L.Util.isArray(f[0])||(f=[f],e=[e]),i=0,n=f.length;i<n;i++){e[i]=e[i]||[];for(var m=0,g=f[i].length;m<g;m++)r=f[i][m],e[i][m]=c.unproject(c.project(r)._add(u)),d&&(o._bounds.extend(f[i][m]),p[i][m]&&p[i][m]._add(s))}}return e},_replaceCoordGetters:function(){this._path.getLatLng?(this._path.getLatLng_=this._path.getLatLng,this._path.getLatLng=L.Util.bind((function(){return this.dragging._transformPoints(this.dragging._matrix,{})}),this._path)):this._path.getLatLngs&&(this._path.getLatLngs_=this._path.getLatLngs,this._path.getLatLngs=L.Util.bind((function(){return this.dragging._transformPoints(this.dragging._matrix,[])}),this._path))},_restoreCoordGetters:function(){this._path.getLatLng_?(this._path.getLatLng=this._path.getLatLng_,delete this._path.getLatLng_):this._path.getLatLngs_&&(this._path.getLatLngs=this._path.getLatLngs_,delete this._path.getLatLngs_)}}),L.Handler.PathDrag.makeDraggable=function(t){return t.dragging=new L.Handler.PathDrag(t),t},L.Path.prototype.makeDraggable=function(){return L.Handler.PathDrag.makeDraggable(this)},L.Path.addInitHook((function(){this.options.draggable?(this.options.interactive=!0,this.dragging||L.Handler.PathDrag.makeDraggable(this),this.dragging.enable()):this.dragging&&this.dragging.disable()})),t.exports=L.Path.Drag},891:()=>{L.PathTransform.Handle=L.CircleMarker.extend({options:{className:"leaflet-path-transform-handler"},onAdd:function(t){L.CircleMarker.prototype.onAdd.call(this,t),this._path&&this.options.setCursor&&(this._path.style.cursor=L.PathTransform.Handle.CursorsByType[this.options.index])}}),L.PathTransform.Handle.CursorsByType=["nesw-resize","nwse-resize","nesw-resize","nwse-resize"],L.PathTransform.RotateHandle=L.PathTransform.Handle.extend({options:{className:"leaflet-path-transform-handler transform-handler--rotate"},onAdd:function(t){L.CircleMarker.prototype.onAdd.call(this,t),this._path&&this.options.setCursor&&(this._path.style.cursor="all-scroll")}}),L.Handler.PathTransform=L.Handler.extend({options:{rotation:!0,scaling:!0,uniformScaling:!0,maxZoom:22,handlerOptions:{radius:5,fillColor:"#ffffff",color:"#202020",fillOpacity:1,weight:2,opacity:.7,setCursor:!0},boundsOptions:{weight:1,opacity:1,dashArray:[3,3],fill:!1,noClip:!0},rotateHandleOptions:{weight:1,opacity:1,setCursor:!0},handleLength:20,edgesCount:4,handleClass:L.PathTransform.Handle,rotateHandleClass:L.PathTransform.RotateHandle},initialize:function(t){this._path=t,this._map=null,this._activeMarker=null,this._originMarker=null,this._rotationMarker=null,this._rotationOrigin=null,this._scaleOrigin=null,this._angle=0,this._scale=L.point(1,1),this._initialDist=0,this._initialDistX=0,this._initialDistY=0,this._rotationStart=null,this._rotationOriginPt=null,this._matrix=new L.Matrix(1,0,0,1,0,0),this._projectedMatrix=new L.Matrix(1,0,0,1,0,0),this._handlersGroup=null,this._rect=null,this._handlers=[],this._handleLine=null},enable:function(t){this._path._map&&(this._map=this._path._map,t&&this.setOptions(t),L.Handler.prototype.enable.call(this))},addHooks:function(){this._createHandlers(),this._path.on("dragstart",this._onDragStart,this).on("dragend",this._onDragEnd,this)},removeHooks:function(){this._hideHandlers(),this._path.off("dragstart",this._onDragStart,this).off("dragend",this._onDragEnd,this),this._handlersGroup=null,this._rect=null,this._handlers=[]},setOptions:function(t){var e=this._enabled;return e&&this.disable(),this.options=L.PathTransform.merge({},L.Handler.PathTransform.prototype.options,t),e&&this.enable(),this},rotate:function(t,e){return this.transform(t,null,e)},scale:function(t,e){return"number"==typeof t&&(t=L.point(t,t)),this.transform(0,t,null,e)},transform:function(t,e,i,n){var r=this._path.getCenter();return i=i||r,n=n||r,this._map=this._path._map,this._transformPoints(this._path,t,e,i,n),this._transformPoints(this._rect,t,e,i,n),this._transformPoints(this._handleLine,t,e,i,n),this._updateHandlers(),this},_update:function(){for(var t=this._matrix,e=0,i=this._handlers.length;e<i;e++){var n=this._handlers[e];n!==this._originMarker&&(n._point=t.transform(n._initialPoint),n._updatePath())}t=t.clone().flip(),this._applyTransform(t),this._path.fire("transform",{layer:this._path})},_applyTransform:function(t){this._path._transform(t._matrix),this._rect._transform(t._matrix),this.options.rotation&&this._handleLine._transform(t._matrix)},_apply:function(){var t=this._map,e=this._matrix.clone(),i=this._angle,n=this._scale.clone();this._transformGeometries();for(var r=0,o=this._handlers.length;r<o;r++){var s=this._handlers[r];s._latlng=t.layerPointToLatLng(s._point),delete s._initialPoint,s.redraw()}this._matrix=L.matrix(1,0,0,1,0,0),this._scale=L.point(1,1),this._angle=0,this._updateHandlers(),t.dragging.enable(),this._path.fire("transformed",{matrix:e,scale:n,rotation:i,layer:this._path})},reset:function(){this._rectShape=null,this._enabled&&(this._rect&&this._handlersGroup.removeLayer(this._rect),this._rect=this._getBoundingPolygon().addTo(this._handlersGroup),this._updateHandlers())},_updateHandlers:function(){var t=this._handlersGroup;this._rectShape=this._rect.toGeoJSON(),this._handleLine&&this._handlersGroup.removeLayer(this._handleLine),this._rotationMarker&&this._handlersGroup.removeLayer(this._rotationMarker),this._handleLine=this._rotationMarker=null;for(var e=this._handlers.length-1;e>=0;e--)t.removeLayer(this._handlers[e]);this._createHandlers()},_transformGeometries:function(){this._path._transform(null),this._rect._transform(null),this._transformPoints(this._path),this._transformPoints(this._rect),this.options.rotation&&(this._handleLine._transform(null),this._transformPoints(this._handleLine,this._angle,null,this._origin))},_getProjectedMatrix:function(t,e,i,n){var r,o=this._map,s=o.getMaxZoom()||this.options.maxZoom,a=L.matrix(1,0,0,1,0,0);return t=t||this._angle||0,1===(e=e||this._scale||L.point(1,1)).x&&1===e.y||(n=n||this._scaleOrigin,r=o.project(n,s),a=a._add(L.matrix(1,0,0,1,r.x,r.y))._add(L.matrix(e.x,0,0,e.y,0,0))._add(L.matrix(1,0,0,1,-r.x,-r.y))),t&&(i=i||this._rotationOrigin,r=o.project(i,s),a=a.rotate(t,r).flip()),a},_transformPoint:function(t,e,i,n){return i.unproject(e.transform(i.project(t,n)),n)},_transformPoints:function(t,e,i,n,r){var o,s,a=t._map,l=a.getMaxZoom()||this.options.maxZoom,h=this._projectedMatrix=this._getProjectedMatrix(e,i,n,r);if(t._point)t._latlng=this._transformPoint(t._latlng,h,a,l);else if(t._rings||t._parts){var c=t._latlngs;for(t._bounds=new L.LatLngBounds,L.Util.isArray(c[0])||(c=[c]),o=0,s=c.length;o<s;o++)for(var u=0,d=c[o].length;u<d;u++)c[o][u]=this._transformPoint(c[o][u],h,a,l),t._bounds.extend(c[o][u])}t._reset()},_createHandlers:function(){var t=this._map;if(this._handlersGroup=this._handlersGroup||(new L.LayerGroup).addTo(t),this._rect=this._rect||this._getBoundingPolygon().addTo(this._handlersGroup),this.options.scaling){this._handlers=[];for(var e=0;e<this.options.edgesCount;e++)this._handlers.push(this._createHandler(this._rect._latlngs[0][e],2*e,e).addTo(this._handlersGroup))}this.options.rotation&&this._createRotationHandlers()},_createRotationHandlers:function(){var t=this._map,e=this._rect._latlngs[0],i=new L.LatLng((e[0].lat+e[3].lat)/2,(e[0].lng+e[3].lng)/2),n=new L.LatLng((e[1].lat+e[2].lat)/2,(e[1].lng+e[2].lng)/2),r=t.layerPointToLatLng(L.PathTransform.pointOnLine(t.latLngToLayerPoint(i),t.latLngToLayerPoint(n),this.options.handleLength));this._handleLine=new L.Polyline([n,r],this.options.rotateHandleOptions).addTo(this._handlersGroup);var o=this.options.rotateHandleClass;this._rotationMarker=new o(r,this.options.handlerOptions).addTo(this._handlersGroup).on("mousedown",this._onRotateStart,this),this._rotationOrigin=new L.LatLng((n.lat+i.lat)/2,(n.lng+i.lng)/2),this._handlers.push(this._rotationMarker)},_getRotationOrigin:function(){var t=this._rect._latlngs[0],e=t[0],i=t[2];return new L.LatLng((e.lat+i.lat)/2,(e.lng+i.lng)/2)},_onRotateStart:function(t){var e=this._map;e.dragging.disable(),this._originMarker=null,this._rotationOriginPt=e.latLngToLayerPoint(this._getRotationOrigin()),this._rotationStart=t.layerPoint,this._initialMatrix=this._matrix.clone(),this._angle=0,this._path._map.on("mousemove",this._onRotate,this).on("mouseup",this._onRotateEnd,this),this._cachePoints(),this._path.fire("transformstart",{layer:this._path}).fire("rotatestart",{layer:this._path,rotation:0})},_onRotate:function(t){var e=t.layerPoint,i=this._rotationStart,n=this._rotationOriginPt;this._angle=Math.atan2(e.y-n.y,e.x-n.x)-Math.atan2(i.y-n.y,i.x-n.x),this._matrix=this._initialMatrix.clone().rotate(this._angle,n).flip(),this._update(),this._path.fire("rotate",{layer:this._path,rotation:this._angle})},_onRotateEnd:function(t){this._path._map.off("mousemove",this._onRotate,this).off("mouseup",this._onRotateEnd,this);var e=this._angle;this._apply(),this._path.fire("rotateend",{layer:this._path,rotation:e})},_onScaleStart:function(t){var e=t.target;this._map.dragging.disable(),this._activeMarker=e,this._originMarker=this._handlers[(e.options.index+2)%4],this._scaleOrigin=this._originMarker.getLatLng(),this._initialMatrix=this._matrix.clone(),this._cachePoints(),this._map.on("mousemove",this._onScale,this).on("mouseup",this._onScaleEnd,this),this._initialDist=this._originMarker._point.distanceTo(this._activeMarker._point),this._initialDistX=this._originMarker._point.x-this._activeMarker._point.x,this._initialDistY=this._originMarker._point.y-this._activeMarker._point.y,this._path.fire("transformstart",{layer:this._path}).fire("scalestart",{layer:this._path,scale:L.point(1,1)}),this._handleLine&&this._map.removeLayer(this._handleLine),this._rotationMarker&&this._map.removeLayer(this._rotationMarker)},_onScale:function(t){var e,i,n=this._originMarker._point;this.options.uniformScaling?i=e=n.distanceTo(t.layerPoint)/this._initialDist:(e=(n.x-t.layerPoint.x)/this._initialDistX,i=(n.y-t.layerPoint.y)/this._initialDistY),this._scale=new L.Point(e,i),this._matrix=this._initialMatrix.clone().scale(this._scale,n),this._update(),this._path.fire("scale",{layer:this._path,scale:this._scale.clone()})},_onScaleEnd:function(t){this._map.off("mousemove",this._onScale,this).off("mouseup",this._onScaleEnd,this),this._handleLine&&this._map.addLayer(this._handleLine),this._rotationMarker&&this._map.addLayer(this._rotationMarker),this._apply(),this._path.fire("scaleend",{layer:this._path,scale:this._scale.clone()})},_cachePoints:function(){this._handlersGroup.eachLayer((function(t){t.bringToFront()}));for(var t=0,e=this._handlers.length;t<e;t++){var i=this._handlers[t];i._initialPoint=i._point.clone()}},_getBoundingPolygon:function(){return this._rectShape?L.GeoJSON.geometryToLayer(this._rectShape,this.options.boundsOptions):new L.Rectangle(this._path.getBounds(),this.options.boundsOptions)},_createHandler:function(t,e,i){var n=new(0,this.options.handleClass)(t,L.Util.extend({},this.options.handlerOptions,{className:"leaflet-drag-transform-marker drag-marker--"+i+" drag-marker--"+e,index:i,type:e}));return n.on("mousedown",this._onScaleStart,this),n},_hideHandlers:function(){this._map.removeLayer(this._handlersGroup)},_onDragStart:function(){this._hideHandlers()},_onDragEnd:function(t){var e=this._rect,i=(t.layer?t.layer:this._path).dragging._matrix.slice();e.dragging||(e.dragging=new L.Handler.PathDrag(e)),e.dragging.enable(),this._map.addLayer(e),e.dragging._transformPoints(i),e._updatePath(),e._project(),e.dragging.disable(),this._map.addLayer(this._handlersGroup),this._updateHandlers(),this._path.fire("transformed",{scale:L.point(1,1),rotation:0,matrix:L.matrix.apply(void 0,i),translate:L.point(i[4],i[5]),layer:this._path})}}),L.Path.addInitHook((function(){this.options.transform&&(this.transform=new L.Handler.PathTransform(this,this.options.transform))}))},1639:()=>{L.SVG.include(L.Browser.vml?{_resetTransformPath:function(t){t._skew&&(t._skew.on=!1,t._path.removeChild(t._skew),t._skew=null)},transformPath:function(t,e){var i=t._skew;i||(i=L.SVG.create("skew"),t._path.appendChild(i),i.style.behavior="url(#default#VML)",t._skew=i);var n=e[0].toFixed(8)+" "+e[1].toFixed(8)+" "+e[2].toFixed(8)+" "+e[3].toFixed(8)+" 0 0",r=Math.floor(e[4]).toFixed()+", "+Math.floor(e[5]).toFixed(),o=this._path.style,s=parseFloat(o.left),a=parseFloat(o.top),l=parseFloat(o.width),h=parseFloat(o.height);isNaN(s)&&(s=0),isNaN(a)&&(a=0),!isNaN(l)&&l||(l=1),!isNaN(h)&&h||(h=1);var c=(-s/l-.5).toFixed(8)+" "+(-a/h-.5).toFixed(8);i.on="f",i.matrix=n,i.origin=c,i.offset=r,i.on=!0}}:{})},6410:()=>{L.SVG.include({_resetTransformPath:function(t){t._path.setAttributeNS(null,"transform","")},transformPath:function(t,e){t._path.setAttributeNS(null,"transform","matrix("+e.join(" ")+")")}})},3458:()=>{L.PathTransform={},L.PathTransform.pointOnLine=function(t,e,i){var n=1+i/t.distanceTo(e);return new L.Point(t.x+(e.x-t.x)*n,t.y+(e.y-t.y)*n)},L.PathTransform.merge=function(){var t,e,i=1,n=arguments[i];function r(t){return"[object Object]"===Object.prototype.toString.call(t)}for(var o=arguments[0];n;)for(t in n=arguments[i++])n.hasOwnProperty(t)&&(r(e=n[t])&&r(o[t])?o[t]=L.Util.merge(o[t],e):o[t]=e);return o}},3416:(t,e,i)=>{i(4067),i(3629),i(3458),i(9803),i(891)},5854:()=>{"use strict";L.DomUtil.setTransform||(L.DomUtil.setTransform=function(t,e,i){var n=e||new L.Point(0,0);t.style[L.DomUtil.TRANSFORM]=(L.Browser.ie3d?"translate("+n.x+"px,"+n.y+"px)":"translate3d("+n.x+"px,"+n.y+"px,0)")+(i?" scale("+i+")":"")}),L.CanvasLayer=(L.Layer?L.Layer:L.Class).extend({initialize:function(t){this._map=null,this._canvas=null,this._frame=null,this._delegate=null,L.setOptions(this,t)},delegate:function(t){return this._delegate=t,this},needRedraw:function(){return this._frame||(this._frame=L.Util.requestAnimFrame(this.drawLayer,this)),this},_onLayerDidResize:function(t){this._canvas.width=t.newSize.x,this._canvas.height=t.newSize.y},_onLayerDidMove:function(){var t=this._map.containerPointToLayerPoint([0,0]);L.DomUtil.setPosition(this._canvas,t),this.drawLayer()},getEvents:function(){var t={resize:this._onLayerDidResize,moveend:this._onLayerDidMove};return this._map.options.zoomAnimation&&L.Browser.any3d&&(t.zoomanim=this._animateZoom),t},onAdd:function(t){console.log("canvas onAdd",this),this._map=t,this._canvas=L.DomUtil.create("canvas","leaflet-layer"),this.tiles={};var e=this._map.getSize();this._canvas.width=e.x,this._canvas.height=e.y;var i=this._map.options.zoomAnimation&&L.Browser.any3d;L.DomUtil.addClass(this._canvas,"leaflet-zoom-"+(i?"animated":"hide")),this.options.pane.appendChild(this._canvas),t.on(this.getEvents(),this);var n=this._delegate||this;n.onLayerDidMount&&n.onLayerDidMount(),this.needRedraw();var r=this;setTimeout((function(){r._onLayerDidMove()}),0)},onRemove:function(t){var e=this._delegate||this;e.onLayerWillUnmount&&e.onLayerWillUnmount(),this.options.pane.removeChild(this._canvas),t.off(this.getEvents(),this),this._canvas=null},addTo:function(t){return t.addLayer(this),this},drawLayer:function(){var t=this._map.getSize(),e=this._map.getBounds(),i=this._map.getZoom(),n=this._map.options.crs.project(this._map.getCenter()),r=this._map.options.crs.project(this._map.containerPointToLatLng(this._map.getSize())),o=this._delegate||this;o.onDrawLayer&&o.onDrawLayer({layer:this,canvas:this._canvas,bounds:e,size:t,zoom:i,center:n,corner:r}),this._frame=null},_setTransform:function(t,e,i){var n=e||new L.Point(0,0);t.style[L.DomUtil.TRANSFORM]=(L.Browser.ie3d?"translate("+n.x+"px,"+n.y+"px)":"translate3d("+n.x+"px,"+n.y+"px,0)")+(i?" scale("+i+")":"")},_animateZoom:function(t){var e=this._map.getZoomScale(t.zoom),i=L.Layer?this._map._latLngToNewLayerPoint(this._map.getBounds().getNorthWest(),t.zoom,t.center):this._map._getCenterOffset(t.center)._multiplyBy(-e).subtract(this._map._getMapPanePos());L.DomUtil.setTransform(this._canvas,i,e)}}),L.canvasLayer=function(t){return new L.CanvasLayer(t)},L.Control.Velocity=L.Control.extend({options:{position:"bottomleft",emptyString:"Unavailable",angleConvention:"bearingCCW",showCardinal:!1,speedUnit:"m/s",directionString:"Direction",speedString:"Speed",onAdd:null,onRemove:null},onAdd:function(t){return this._container=L.DomUtil.create("div","leaflet-control-velocity"),L.DomEvent.disableClickPropagation(this._container),t.on("mousemove",this._onMouseMove,this),this._container.innerHTML=this.options.emptyString,this.options.leafletVelocity.options.onAdd&&this.options.leafletVelocity.options.onAdd(),this._container},onRemove:function(t){t.off("mousemove",this._onMouseMove,this),this.options.leafletVelocity.options.onRemove&&this.options.leafletVelocity.options.onRemove()},vectorToSpeed:function(t,e,i){var n=Math.sqrt(Math.pow(t,2)+Math.pow(e,2));return"k/h"===i?this.meterSec2kilometerHour(n):"kt"===i?this.meterSec2Knots(n):n},vectorToDegrees:function(t,e,i){i.endsWith("CCW")&&(e=e>0?e=-e:Math.abs(e));var n=Math.sqrt(Math.pow(t,2)+Math.pow(e,2)),r=180*Math.atan2(t/n,e/n)/Math.PI+180;return"bearingCW"!==i&&"meteoCCW"!==i||(r+=180)>=360&&(r-=360),r},degreesToCardinalDirection:function(t){var e="";return t>=0&&t<11.25||t>=348.75?e="N":t>=11.25&&t<33.75?e="NNW":t>=33.75&&t<56.25?e="NW":t>=56.25&&t<78.75?e="WNW":t>=78.25&&t<101.25?e="W":t>=101.25&&t<123.75?e="WSW":t>=123.75&&t<146.25?e="SW":t>=146.25&&t<168.75?e="SSW":t>=168.75&&t<191.25?e="S":t>=191.25&&t<213.75?e="SSE":t>=213.75&&t<236.25?e="SE":t>=236.25&&t<258.75?e="ESE":t>=258.75&&t<281.25?e="E":t>=281.25&&t<303.75?e="ENE":t>=303.75&&t<326.25?e="NE":t>=326.25&&t<348.75&&(e="NNE"),e},meterSec2Knots:function(t){return t/.514},meterSec2kilometerHour:function(t){return 3.6*t},_onMouseMove:function(t){var e=this,i=this.options.leafletVelocity._map.containerPointToLatLng(L.point(t.containerPoint.x,t.containerPoint.y)),n=this.options.leafletVelocity._windy.interpolatePoint(i.lng,i.lat),r="";if(n&&!isNaN(n[0])&&!isNaN(n[1])&&n[2]){var o=e.vectorToDegrees(n[0],n[1],this.options.angleConvention),s=this.options.showCardinal?" (".concat(e.degreesToCardinalDirection(o),") "):"";r="<strong> ".concat(this.options.velocityType," ").concat(this.options.directionString,": </strong> ").concat(o.toFixed(2),"°").concat(s,", <strong> ").concat(this.options.velocityType," ").concat(this.options.speedString,": </strong> ").concat(e.vectorToSpeed(n[0],n[1],this.options.speedUnit).toFixed(2)," ").concat(this.options.speedUnit)}else r=this.options.emptyString;e._container.innerHTML=r}}),L.Map.mergeOptions({positionControl:!1}),L.Map.addInitHook((function(){this.options.positionControl&&(this.positionControl=new L.Control.MousePosition,this.addControl(this.positionControl))})),L.control.velocity=function(t){return new L.Control.Velocity(t)},L.VelocityLayer=(L.Layer?L.Layer:L.Class).extend({options:{displayValues:!0,displayOptions:{velocityType:"Velocity",position:"bottomleft",emptyString:"No velocity data"},maxVelocity:10,colorScale:null,data:null},_map:null,_canvasLayer:null,_windy:null,_context:null,_timer:0,_mouseControl:null,initialize:function(t){L.setOptions(this,t)},onAdd:function(t){this._paneName=this.options.paneName||"overlayPane";var e=t._panes.overlayPane;t.getPane&&((e=t.getPane(this._paneName))||(e=t.createPane(this._paneName))),this._canvasLayer=L.canvasLayer({pane:e}).delegate(this),this._canvasLayer.addTo(t),this._map=t},onRemove:function(t){this._destroyWind()},setData:function(t){this.options.data=t,this._windy&&(this._windy.setData(t),this._clearAndRestart()),this.fire("load")},setOpacity:function(t){console.log("this._canvasLayer",this._canvasLayer),this._canvasLayer.setOpacity(t)},setOptions:function(t){this.options=Object.assign(this.options,t),t.hasOwnProperty("displayOptions")&&(this.options.displayOptions=Object.assign(this.options.displayOptions,t.displayOptions),this._initMouseHandler(!0)),t.hasOwnProperty("data")&&(this.options.data=t.data),this._windy&&(this._windy.setOptions(t),t.hasOwnProperty("data")&&this._windy.setData(t.data),this._clearAndRestart()),this.fire("load")},onDrawLayer:function(t,e){var i=this;this._windy?this.options.data&&(this._timer&&clearTimeout(i._timer),this._timer=setTimeout((function(){i._startWindy()}),750)):this._initWindy(this)},_startWindy:function(){var t=this._map.getBounds(),e=this._map.getSize();this._windy.start([[0,0],[e.x,e.y]],e.x,e.y,[[t._southWest.lng,t._southWest.lat],[t._northEast.lng,t._northEast.lat]])},_initWindy:function(e){var i=Object.assign({canvas:e._canvasLayer._canvas,map:this._map},e.options);this._windy=new t(i),this._context=this._canvasLayer._canvas.getContext("2d"),this._canvasLayer._canvas.classList.add("velocity-overlay"),this.onDrawLayer(),this._map.on("dragstart",e._windy.stop),this._map.on("dragend",e._clearAndRestart),this._map.on("zoomstart",e._windy.stop),this._map.on("zoomend",e._clearAndRestart),this._map.on("resize",e._clearWind),this._initMouseHandler(!1)},_initMouseHandler:function(t){if(t&&(this._map.removeControl(this._mouseControl),this._mouseControl=!1),!this._mouseControl&&this.options.displayValues){var e=this.options.displayOptions||{};e.leafletVelocity=this,this._mouseControl=L.control.velocity(e).addTo(this._map)}},_clearAndRestart:function(){this._context&&this._context.clearRect(0,0,3e3,3e3),this._windy&&this._startWindy()},_clearWind:function(){this._windy&&this._windy.stop(),this._context&&this._context.clearRect(0,0,3e3,3e3)},_destroyWind:function(){this._timer&&clearTimeout(this._timer),this._windy&&this._windy.stop(),this._context&&this._context.clearRect(0,0,3e3,3e3),this._mouseControl&&this._map.removeControl(this._mouseControl),this._mouseControl=null,this._windy=null,this._map.removeLayer(this._canvasLayer)}}),L.velocityLayer=function(t){return new L.VelocityLayer(t)};var t=function(t){var e,i,n,r,o,s,a,l,h,c,u=t.minVelocity||0,d=t.maxVelocity||10,p=(t.velocityScale||.005)*(Math.pow(window.devicePixelRatio,1/3)||1),f=t.particleAge||90,m=t.lineWidth||1,g=t.particleMultiplier||1/300,_=Math.pow(window.devicePixelRatio,1/3)||1.6,y=t.frameRate||15,v=1e3/y,b=.97,x=t.colorScale||["rgb(36,104, 180)","rgb(60,157, 194)","rgb(128,205,193 )","rgb(151,218,168 )","rgb(198,231,181)","rgb(238,247,217)","rgb(255,238,159)","rgb(252,217,125)","rgb(255,182,100)","rgb(252,150,75)","rgb(250,112,52)","rgb(245,64,32)","rgb(237,45,28)","rgb(220,24,32)","rgb(180,0,35)"],w=[NaN,NaN,null],M=t.data,k=function(t,e,i,n,r,o){var s=1-t,a=1-e,l=s*a,h=t*a,c=s*e,u=t*e,d=i[0]*l+n[0]*h+r[0]*c+o[0]*u,p=i[1]*l+n[1]*h+r[1]*c+o[1]*u;return[d,p,Math.sqrt(d*d+p*p)]},C=function(t,n){if(!i)return null;var l,h=P(t-r,360)/s,c=(o-n)/a,u=Math.floor(h),d=u+1,p=Math.floor(c),f=p+1;if(l=i[p]){var m=l[u],g=l[d];if(A(m)&&A(g)&&(l=i[f])){var _=l[u],y=l[d];if(A(_)&&A(y))return e.interpolate(h-u,c-p,m,g,_,y)}}return null},A=function(t){return null!=t},P=function(t,e){return t-e*Math.floor(t/e)},S=function(t,e,i,n,r,o,s){var a=s[0]*o,l=s[1]*o,h=E(t,e,i,n,r);return s[0]=h[0]*a+h[2]*l,s[1]=h[1]*a+h[3]*l,s},E=function(t,e,i,n,r){var o=2*Math.PI,s=e<0?5:-5,a=i<0?5:-5,l=z(i,e+s),h=z(i+a,e),c=Math.cos(i/360*o);return[(l[0]-n)/s/c,(l[1]-r)/s/c,(h[0]-n)/a,(h[1]-r)/a]},I=function(t,e,i){function n(e,i){var n=t[Math.round(e)];return n&&n[Math.round(i)]||w}n.release=function(){t=[]},n.randomize=function(t){var i,r,o=0;do{i=Math.round(Math.floor(Math.random()*e.width)+e.x),r=Math.round(Math.floor(Math.random()*e.height)+e.y)}while(null===n(i,r)[2]&&o++<30);return t.x=i,t.y=r,t},i(e,n)},T=function(t){return t/180*Math.PI},D=function(e,i,n){var r=t.map.containerPointToLatLng(L.point(e,i));return[r.lng,r.lat]},z=function(e,i,n){var r=t.map.latLngToContainerPoint(L.latLng(e,i));return[r.x,r.y]},B=function(){O.field&&O.field.release(),c&&cancelAnimationFrame(c)},O={params:t,start:function(y,w,L,A){var P={south:T(A[0][1]),north:T(A[1][1]),east:T(A[1][0]),west:T(A[0][0]),width:w,height:L};B(),function(M,A){var E=!0;M.length<2&&(E=!1),E||console.log("Windy Error: data must have at least two components (u,v)");var T=(e=function(t){var e=null,i=null;return t.forEach((function(t){switch(t.header.parameterCategory+","+t.header.parameterNumber){case"1,2":case"2,2":e=t;break;case"1,3":case"2,3":i=t}})),function(t,e){var i=t.data,n=e.data;return{header:t.header,data:function(t){return[i[t],n[t]]},interpolate:k}}(e,i)}(M)).header;if(T.hasOwnProperty("gridDefinitionTemplate")&&0!=T.gridDefinitionTemplate&&(E=!1),E||console.log("Windy Error: Only data with Latitude_Longitude coordinates is supported"),E=!0,r=T.lo1,o=T.la1,s=T.dx,a=T.dy,l=T.nx,h=T.ny,T.hasOwnProperty("scanMode")){var z=T.scanMode.toString(2),B=(z=("0"+z).slice(-8)).split("").map(Number).map(Boolean);B[0]&&(s=-s),B[1]&&(a=-a),B[2]&&(E=!1),B[3]&&(E=!1),B[4]&&(E=!1),B[5]&&(E=!1),B[6]&&(E=!1),B[7]&&(E=!1),E||console.log("Windy Error: Data with scanMode: "+T.scanMode+" is not supported.")}(n=new Date(T.refTime)).setHours(n.getHours()+T.forecastTime),i=[];for(var R=0,j=Math.floor(l*s)>=360,N=0;N<h;N++){for(var F=[],G=0;G<l;G++,R++)F[G]=e.data(R);j&&F.push(F[0]),i[N]=F}!function(e){!function(t,e,i,n){var r={},o=(i.south-i.north)*(i.west-i.east),s=p*Math.pow(o,.4),a=[],l=e.x;function h(i){for(var n=[],o=e.y;o<=e.yMax;o+=2){var l=D(i,o);if(l){var h=l[0],c=l[1];if(isFinite(h)){var u=t.interpolate(h,c);u&&(u=S(r,h,c,i,o,s,u),n[o+1]=n[o]=u)}}}a[i+1]=a[i]=n}!function t(){for(var i=Date.now();l<e.width;)if(h(l),l+=2,Date.now()-i>1e3)return void setTimeout(t,25);I(a,e,n)}()}(e,function(t,e,i){var n=t[0],r=t[1],o=Math.round(n[0]),s=Math.max(Math.floor(n[1],0),0);return Math.min(Math.ceil(r[0],e),e-1),{x:o,y:s,xMax:e,yMax:Math.min(Math.ceil(r[1],i),i-1),width:e,height:i}}(y,w,L),P,(function(e,i){O.field=i,function(e,i){var n,r,o=(n=u,r=d,x.indexFor=function(t){return Math.max(0,Math.min(x.length-1,Math.round((t-n)/(r-n)*(x.length-1))))},x),s=o.map((function(){return[]})),a=Math.round(e.width*e.height*g);/android|blackberry|iemobile|ipad|iphone|ipod|opera mini|webos/i.test(navigator.userAgent)&&(a*=_);for(var l="rgba(0, 0, 0, ".concat(b,")"),h=[],p=0;p<a;p++)h.push(i.randomize({age:Math.floor(Math.random()*f)+0}));var y=t.canvas.getContext("2d");y.lineWidth=m,y.fillStyle=l,y.globalAlpha=.6;var w=Date.now();!function t(){c=requestAnimationFrame(t);var n=Date.now(),r=n-w;r>v&&(w=n-r%v,s.forEach((function(t){t.length=0})),h.forEach((function(t){t.age>f&&(i.randomize(t).age=0);var e=t.x,n=t.y,r=i(e,n),a=r[2];if(null===a)t.age=f;else{var l=e+r[0],h=n+r[1];null!==i(l,h)[2]?(t.xt=l,t.yt=h,s[o.indexFor(a)].push(t)):(t.x=l,t.y=h)}t.age+=1})),y.globalCompositeOperation="destination-in",y.fillRect(e.x,e.y,e.width,e.height),y.globalCompositeOperation="lighter",y.globalAlpha=0===b?0:.9*b,s.forEach((function(t,e){t.length>0&&(y.beginPath(),y.strokeStyle=o[e],t.forEach((function(t){y.moveTo(t.x,t.y),y.lineTo(t.xt,t.yt),t.x=t.xt,t.y=t.yt})),y.stroke())})))}()}(e,i)}))}({date:n,interpolate:C})}(M)},stop:B,createField:I,interpolatePoint:C,setData:function(t){M=t},setOptions:function(t){t.hasOwnProperty("minVelocity")&&(u=t.minVelocity),t.hasOwnProperty("maxVelocity")&&(d=t.maxVelocity),t.hasOwnProperty("velocityScale")&&(p=(t.velocityScale||.005)*(Math.pow(window.devicePixelRatio,1/3)||1)),t.hasOwnProperty("particleAge")&&(f=t.particleAge),t.hasOwnProperty("lineWidth")&&(m=t.lineWidth),t.hasOwnProperty("particleMultiplier")&&(g=t.particleMultiplier),t.hasOwnProperty("opacity")&&(b=+t.opacity),t.hasOwnProperty("frameRate")&&(y=t.frameRate),v=1e3/y}};return O};window.cancelAnimationFrame||(window.cancelAnimationFrame=function(t){clearTimeout(t)})},9266:function(){!function(t,e,i){"use strict";L.AwesomeMarkers={},L.AwesomeMarkers.version="2.0.1",L.AwesomeMarkers.Icon=L.Icon.extend({options:{iconSize:[35,45],iconAnchor:[17,42],popupAnchor:[1,-32],shadowAnchor:[10,12],shadowSize:[36,16],className:"awesome-marker",prefix:"glyphicon",spinClass:"fa-spin",extraClasses:"",icon:"home",markerColor:"blue",iconColor:"white"},initialize:function(t){t=L.Util.setOptions(this,t)},createIcon:function(){var t=e.createElement("div"),i=this.options;return i.icon&&(t.innerHTML=this._createInner()),i.bgPos&&(t.style.backgroundPosition=-i.bgPos.x+"px "+-i.bgPos.y+"px"),this._setIconStyles(t,"icon-"+i.markerColor),t},_createInner:function(){var t,e="",i="",n="",r=this.options;return t=r.icon.slice(0,r.prefix.length+1)===r.prefix+"-"?r.icon:r.prefix+"-"+r.icon,r.spin&&"string"==typeof r.spinClass&&(e=r.spinClass),r.iconColor&&("white"===r.iconColor||"black"===r.iconColor?i="icon-"+r.iconColor:n="style='color: "+r.iconColor+"' "),"<i "+n+"class='"+r.extraClasses+" "+r.prefix+" "+t+" "+e+" "+i+"'></i>"},_setIconStyles:function(t,e){var i,n=this.options,r=L.point(n["shadow"===e?"shadowSize":"iconSize"]);!(i="shadow"===e?L.point(n.shadowAnchor||n.iconAnchor):L.point(n.iconAnchor))&&r&&(i=r.divideBy(2,!0)),t.className="awesome-marker-"+e+" "+n.className,i&&(t.style.marginLeft=-i.x+"px",t.style.marginTop=-i.y+"px"),r&&(t.style.width=r.x+"px",t.style.height=r.y+"px")},createShadow:function(){var t=e.createElement("div");return this._setIconStyles(t,"shadow"),t}}),L.AwesomeMarkers.icon=function(t){return new L.AwesomeMarkers.Icon(t)}}(0,document)},5151:function(t,e){!function(t){"use strict";var e=L.MarkerClusterGroup=L.FeatureGroup.extend({options:{maxClusterRadius:80,iconCreateFunction:null,clusterPane:L.Marker.prototype.options.pane,spiderfyOnEveryZoom:!1,spiderfyOnMaxZoom:!0,showCoverageOnHover:!0,zoomToBoundsOnClick:!0,singleMarkerMode:!1,disableClusteringAtZoom:null,removeOutsideVisibleBounds:!0,animate:!0,animateAddingMarkers:!1,spiderfyShapePositions:null,spiderfyDistanceMultiplier:1,spiderLegPolylineOptions:{weight:1.5,color:"#222",opacity:.5},chunkedLoading:!1,chunkInterval:200,chunkDelay:50,chunkProgress:null,polygonOptions:{}},initialize:function(t){L.Util.setOptions(this,t),this.options.iconCreateFunction||(this.options.iconCreateFunction=this._defaultIconCreateFunction),this._featureGroup=L.featureGroup(),this._featureGroup.addEventParent(this),this._nonPointGroup=L.featureGroup(),this._nonPointGroup.addEventParent(this),this._inZoomAnimation=0,this._needsClustering=[],this._needsRemoving=[],this._currentShownBounds=null,this._queue=[],this._childMarkerEventHandlers={dragstart:this._childMarkerDragStart,move:this._childMarkerMoved,dragend:this._childMarkerDragEnd};var e=L.DomUtil.TRANSITION&&this.options.animate;L.extend(this,e?this._withAnimation:this._noAnimation),this._markerCluster=e?L.MarkerCluster:L.MarkerClusterNonAnimated},addLayer:function(t){if(t instanceof L.LayerGroup)return this.addLayers([t]);if(!t.getLatLng)return this._nonPointGroup.addLayer(t),this.fire("layeradd",{layer:t}),this;if(!this._map)return this._needsClustering.push(t),this.fire("layeradd",{layer:t}),this;if(this.hasLayer(t))return this;this._unspiderfy&&this._unspiderfy(),this._addLayer(t,this._maxZoom),this.fire("layeradd",{layer:t}),this._topClusterLevel._recalculateBounds(),this._refreshClustersIcons();var e=t,i=this._zoom;if(t.__parent)for(;e.__parent._zoom>=i;)e=e.__parent;return this._currentShownBounds.contains(e.getLatLng())&&(this.options.animateAddingMarkers?this._animationAddLayer(t,e):this._animationAddLayerNonAnimated(t,e)),this},removeLayer:function(t){return t instanceof L.LayerGroup?this.removeLayers([t]):t.getLatLng?this._map?t.__parent?(this._unspiderfy&&(this._unspiderfy(),this._unspiderfyLayer(t)),this._removeLayer(t,!0),this.fire("layerremove",{layer:t}),this._topClusterLevel._recalculateBounds(),this._refreshClustersIcons(),t.off(this._childMarkerEventHandlers,this),this._featureGroup.hasLayer(t)&&(this._featureGroup.removeLayer(t),t.clusterShow&&t.clusterShow()),this):this:(!this._arraySplice(this._needsClustering,t)&&this.hasLayer(t)&&this._needsRemoving.push({layer:t,latlng:t._latlng}),this.fire("layerremove",{layer:t}),this):(this._nonPointGroup.removeLayer(t),this.fire("layerremove",{layer:t}),this)},addLayers:function(t,e){if(!L.Util.isArray(t))return this.addLayer(t);var i,n=this._featureGroup,r=this._nonPointGroup,o=this.options.chunkedLoading,s=this.options.chunkInterval,a=this.options.chunkProgress,l=t.length,h=0,c=!0;if(this._map){var u=(new Date).getTime(),d=L.bind((function(){var p=(new Date).getTime();for(this._map&&this._unspiderfy&&this._unspiderfy();h<l&&!(o&&h%200==0&&(new Date).getTime()-p>s);h++)if((i=t[h])instanceof L.LayerGroup)c&&(t=t.slice(),c=!1),this._extractNonGroupLayers(i,t),l=t.length;else if(i.getLatLng){if(!this.hasLayer(i)&&(this._addLayer(i,this._maxZoom),e||this.fire("layeradd",{layer:i}),i.__parent&&2===i.__parent.getChildCount())){var f=i.__parent.getAllChildMarkers(),m=f[0]===i?f[1]:f[0];n.removeLayer(m)}}else r.addLayer(i),e||this.fire("layeradd",{layer:i});a&&a(h,l,(new Date).getTime()-u),h===l?(this._topClusterLevel._recalculateBounds(),this._refreshClustersIcons(),this._topClusterLevel._recursivelyAddChildrenToMap(null,this._zoom,this._currentShownBounds)):setTimeout(d,this.options.chunkDelay)}),this);d()}else for(var p=this._needsClustering;h<l;h++)(i=t[h])instanceof L.LayerGroup?(c&&(t=t.slice(),c=!1),this._extractNonGroupLayers(i,t),l=t.length):i.getLatLng?this.hasLayer(i)||p.push(i):r.addLayer(i);return this},removeLayers:function(t){var e,i,n=t.length,r=this._featureGroup,o=this._nonPointGroup,s=!0;if(!this._map){for(e=0;e<n;e++)(i=t[e])instanceof L.LayerGroup?(s&&(t=t.slice(),s=!1),this._extractNonGroupLayers(i,t),n=t.length):(this._arraySplice(this._needsClustering,i),o.removeLayer(i),this.hasLayer(i)&&this._needsRemoving.push({layer:i,latlng:i._latlng}),this.fire("layerremove",{layer:i}));return this}if(this._unspiderfy){this._unspiderfy();var a=t.slice(),l=n;for(e=0;e<l;e++)(i=a[e])instanceof L.LayerGroup?(this._extractNonGroupLayers(i,a),l=a.length):this._unspiderfyLayer(i)}for(e=0;e<n;e++)(i=t[e])instanceof L.LayerGroup?(s&&(t=t.slice(),s=!1),this._extractNonGroupLayers(i,t),n=t.length):i.__parent?(this._removeLayer(i,!0,!0),this.fire("layerremove",{layer:i}),r.hasLayer(i)&&(r.removeLayer(i),i.clusterShow&&i.clusterShow())):(o.removeLayer(i),this.fire("layerremove",{layer:i}));return this._topClusterLevel._recalculateBounds(),this._refreshClustersIcons(),this._topClusterLevel._recursivelyAddChildrenToMap(null,this._zoom,this._currentShownBounds),this},clearLayers:function(){return this._map||(this._needsClustering=[],this._needsRemoving=[],delete this._gridClusters,delete this._gridUnclustered),this._noanimationUnspiderfy&&this._noanimationUnspiderfy(),this._featureGroup.clearLayers(),this._nonPointGroup.clearLayers(),this.eachLayer((function(t){t.off(this._childMarkerEventHandlers,this),delete t.__parent}),this),this._map&&this._generateInitialClusters(),this},getBounds:function(){var t=new L.LatLngBounds;this._topClusterLevel&&t.extend(this._topClusterLevel._bounds);for(var e=this._needsClustering.length-1;e>=0;e--)t.extend(this._needsClustering[e].getLatLng());return t.extend(this._nonPointGroup.getBounds()),t},eachLayer:function(t,e){var i,n,r,o=this._needsClustering.slice(),s=this._needsRemoving;for(this._topClusterLevel&&this._topClusterLevel.getAllChildMarkers(o),n=o.length-1;n>=0;n--){for(i=!0,r=s.length-1;r>=0;r--)if(s[r].layer===o[n]){i=!1;break}i&&t.call(e,o[n])}this._nonPointGroup.eachLayer(t,e)},getLayers:function(){var t=[];return this.eachLayer((function(e){t.push(e)})),t},getLayer:function(t){var e=null;return t=parseInt(t,10),this.eachLayer((function(i){L.stamp(i)===t&&(e=i)})),e},hasLayer:function(t){if(!t)return!1;var e,i=this._needsClustering;for(e=i.length-1;e>=0;e--)if(i[e]===t)return!0;for(e=(i=this._needsRemoving).length-1;e>=0;e--)if(i[e].layer===t)return!1;return!(!t.__parent||t.__parent._group!==this)||this._nonPointGroup.hasLayer(t)},zoomToShowLayer:function(t,e){var i=this._map;"function"!=typeof e&&(e=function(){});var n=function(){!i.hasLayer(t)&&!i.hasLayer(t.__parent)||this._inZoomAnimation||(this._map.off("moveend",n,this),this.off("animationend",n,this),i.hasLayer(t)?e():t.__parent._icon&&(this.once("spiderfied",e,this),t.__parent.spiderfy()))};t._icon&&this._map.getBounds().contains(t.getLatLng())?e():t.__parent._zoom<Math.round(this._map._zoom)?(this._map.on("moveend",n,this),this._map.panTo(t.getLatLng())):(this._map.on("moveend",n,this),this.on("animationend",n,this),t.__parent.zoomToBounds())},onAdd:function(t){var e,i,n;if(this._map=t,!isFinite(this._map.getMaxZoom()))throw"Map has no maxZoom specified";for(this._featureGroup.addTo(t),this._nonPointGroup.addTo(t),this._gridClusters||this._generateInitialClusters(),this._maxLat=t.options.crs.projection.MAX_LATITUDE,e=0,i=this._needsRemoving.length;e<i;e++)(n=this._needsRemoving[e]).newlatlng=n.layer._latlng,n.layer._latlng=n.latlng;for(e=0,i=this._needsRemoving.length;e<i;e++)n=this._needsRemoving[e],this._removeLayer(n.layer,!0),n.layer._latlng=n.newlatlng;this._needsRemoving=[],this._zoom=Math.round(this._map._zoom),this._currentShownBounds=this._getExpandedVisibleBounds(),this._map.on("zoomend",this._zoomEnd,this),this._map.on("moveend",this._moveEnd,this),this._spiderfierOnAdd&&this._spiderfierOnAdd(),this._bindEvents(),i=this._needsClustering,this._needsClustering=[],this.addLayers(i,!0)},onRemove:function(t){t.off("zoomend",this._zoomEnd,this),t.off("moveend",this._moveEnd,this),this._unbindEvents(),this._map._mapPane.className=this._map._mapPane.className.replace(" leaflet-cluster-anim",""),this._spiderfierOnRemove&&this._spiderfierOnRemove(),delete this._maxLat,this._hideCoverage(),this._featureGroup.remove(),this._nonPointGroup.remove(),this._featureGroup.clearLayers(),this._map=null},getVisibleParent:function(t){for(var e=t;e&&!e._icon;)e=e.__parent;return e||null},_arraySplice:function(t,e){for(var i=t.length-1;i>=0;i--)if(t[i]===e)return t.splice(i,1),!0},_removeFromGridUnclustered:function(t,e){for(var i=this._map,n=this._gridUnclustered,r=Math.floor(this._map.getMinZoom());e>=r&&n[e].removeObject(t,i.project(t.getLatLng(),e));e--);},_childMarkerDragStart:function(t){t.target.__dragStart=t.target._latlng},_childMarkerMoved:function(t){if(!this._ignoreMove&&!t.target.__dragStart){var e=t.target._popup&&t.target._popup.isOpen();this._moveChild(t.target,t.oldLatLng,t.latlng),e&&t.target.openPopup()}},_moveChild:function(t,e,i){t._latlng=e,this.removeLayer(t),t._latlng=i,this.addLayer(t)},_childMarkerDragEnd:function(t){var e=t.target.__dragStart;delete t.target.__dragStart,e&&this._moveChild(t.target,e,t.target._latlng)},_removeLayer:function(t,e,i){var n=this._gridClusters,r=this._gridUnclustered,o=this._featureGroup,s=this._map,a=Math.floor(this._map.getMinZoom());e&&this._removeFromGridUnclustered(t,this._maxZoom);var l,h=t.__parent,c=h._markers;for(this._arraySplice(c,t);h&&(h._childCount--,h._boundsNeedUpdate=!0,!(h._zoom<a));)e&&h._childCount<=1?(l=h._markers[0]===t?h._markers[1]:h._markers[0],n[h._zoom].removeObject(h,s.project(h._cLatLng,h._zoom)),r[h._zoom].addObject(l,s.project(l.getLatLng(),h._zoom)),this._arraySplice(h.__parent._childClusters,h),h.__parent._markers.push(l),l.__parent=h.__parent,h._icon&&(o.removeLayer(h),i||o.addLayer(l))):h._iconNeedsUpdate=!0,h=h.__parent;delete t.__parent},_isOrIsParent:function(t,e){for(;e;){if(t===e)return!0;e=e.parentNode}return!1},fire:function(t,e,i){if(e&&e.layer instanceof L.MarkerCluster){if(e.originalEvent&&this._isOrIsParent(e.layer._icon,e.originalEvent.relatedTarget))return;t="cluster"+t}L.FeatureGroup.prototype.fire.call(this,t,e,i)},listens:function(t,e){return L.FeatureGroup.prototype.listens.call(this,t,e)||L.FeatureGroup.prototype.listens.call(this,"cluster"+t,e)},_defaultIconCreateFunction:function(t){var e=t.getChildCount(),i=" marker-cluster-";return i+=e<10?"small":e<100?"medium":"large",new L.DivIcon({html:"<div><span>"+e+"</span></div>",className:"marker-cluster"+i,iconSize:new L.Point(40,40)})},_bindEvents:function(){var t=this._map,e=this.options.spiderfyOnMaxZoom,i=this.options.showCoverageOnHover,n=this.options.zoomToBoundsOnClick,r=this.options.spiderfyOnEveryZoom;(e||n||r)&&this.on("clusterclick clusterkeypress",this._zoomOrSpiderfy,this),i&&(this.on("clustermouseover",this._showCoverage,this),this.on("clustermouseout",this._hideCoverage,this),t.on("zoomend",this._hideCoverage,this))},_zoomOrSpiderfy:function(t){var e=t.layer,i=e;if("clusterkeypress"!==t.type||!t.originalEvent||13===t.originalEvent.keyCode){for(;1===i._childClusters.length;)i=i._childClusters[0];i._zoom===this._maxZoom&&i._childCount===e._childCount&&this.options.spiderfyOnMaxZoom?e.spiderfy():this.options.zoomToBoundsOnClick&&e.zoomToBounds(),this.options.spiderfyOnEveryZoom&&e.spiderfy(),t.originalEvent&&13===t.originalEvent.keyCode&&this._map._container.focus()}},_showCoverage:function(t){var e=this._map;this._inZoomAnimation||(this._shownPolygon&&e.removeLayer(this._shownPolygon),t.layer.getChildCount()>2&&t.layer!==this._spiderfied&&(this._shownPolygon=new L.Polygon(t.layer.getConvexHull(),this.options.polygonOptions),e.addLayer(this._shownPolygon)))},_hideCoverage:function(){this._shownPolygon&&(this._map.removeLayer(this._shownPolygon),this._shownPolygon=null)},_unbindEvents:function(){var t=this.options.spiderfyOnMaxZoom,e=this.options.showCoverageOnHover,i=this.options.zoomToBoundsOnClick,n=this.options.spiderfyOnEveryZoom,r=this._map;(t||i||n)&&this.off("clusterclick clusterkeypress",this._zoomOrSpiderfy,this),e&&(this.off("clustermouseover",this._showCoverage,this),this.off("clustermouseout",this._hideCoverage,this),r.off("zoomend",this._hideCoverage,this))},_zoomEnd:function(){this._map&&(this._mergeSplitClusters(),this._zoom=Math.round(this._map._zoom),this._currentShownBounds=this._getExpandedVisibleBounds())},_moveEnd:function(){if(!this._inZoomAnimation){var t=this._getExpandedVisibleBounds();this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,Math.floor(this._map.getMinZoom()),this._zoom,t),this._topClusterLevel._recursivelyAddChildrenToMap(null,Math.round(this._map._zoom),t),this._currentShownBounds=t}},_generateInitialClusters:function(){var t=Math.ceil(this._map.getMaxZoom()),e=Math.floor(this._map.getMinZoom()),i=this.options.maxClusterRadius,n=i;"function"!=typeof i&&(n=function(){return i}),null!==this.options.disableClusteringAtZoom&&(t=this.options.disableClusteringAtZoom-1),this._maxZoom=t,this._gridClusters={},this._gridUnclustered={};for(var r=t;r>=e;r--)this._gridClusters[r]=new L.DistanceGrid(n(r)),this._gridUnclustered[r]=new L.DistanceGrid(n(r));this._topClusterLevel=new this._markerCluster(this,e-1)},_addLayer:function(t,e){var i,n,r=this._gridClusters,o=this._gridUnclustered,s=Math.floor(this._map.getMinZoom());for(this.options.singleMarkerMode&&this._overrideMarkerIcon(t),t.on(this._childMarkerEventHandlers,this);e>=s;e--){i=this._map.project(t.getLatLng(),e);var a=r[e].getNearObject(i);if(a)return a._addChild(t),void(t.__parent=a);if(a=o[e].getNearObject(i)){var l=a.__parent;l&&this._removeLayer(a,!1);var h=new this._markerCluster(this,e,a,t);r[e].addObject(h,this._map.project(h._cLatLng,e)),a.__parent=h,t.__parent=h;var c=h;for(n=e-1;n>l._zoom;n--)c=new this._markerCluster(this,n,c),r[n].addObject(c,this._map.project(a.getLatLng(),n));return l._addChild(c),void this._removeFromGridUnclustered(a,e)}o[e].addObject(t,i)}this._topClusterLevel._addChild(t),t.__parent=this._topClusterLevel},_refreshClustersIcons:function(){this._featureGroup.eachLayer((function(t){t instanceof L.MarkerCluster&&t._iconNeedsUpdate&&t._updateIcon()}))},_enqueue:function(t){this._queue.push(t),this._queueTimeout||(this._queueTimeout=setTimeout(L.bind(this._processQueue,this),300))},_processQueue:function(){for(var t=0;t<this._queue.length;t++)this._queue[t].call(this);this._queue.length=0,clearTimeout(this._queueTimeout),this._queueTimeout=null},_mergeSplitClusters:function(){var t=Math.round(this._map._zoom);this._processQueue(),this._zoom<t&&this._currentShownBounds.intersects(this._getExpandedVisibleBounds())?(this._animationStart(),this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,Math.floor(this._map.getMinZoom()),this._zoom,this._getExpandedVisibleBounds()),this._animationZoomIn(this._zoom,t)):this._zoom>t?(this._animationStart(),this._animationZoomOut(this._zoom,t)):this._moveEnd()},_getExpandedVisibleBounds:function(){return this.options.removeOutsideVisibleBounds?L.Browser.mobile?this._checkBoundsMaxLat(this._map.getBounds()):this._checkBoundsMaxLat(this._map.getBounds().pad(1)):this._mapBoundsInfinite},_checkBoundsMaxLat:function(t){var e=this._maxLat;return void 0!==e&&(t.getNorth()>=e&&(t._northEast.lat=1/0),t.getSouth()<=-e&&(t._southWest.lat=-1/0)),t},_animationAddLayerNonAnimated:function(t,e){if(e===t)this._featureGroup.addLayer(t);else if(2===e._childCount){e._addToMap();var i=e.getAllChildMarkers();this._featureGroup.removeLayer(i[0]),this._featureGroup.removeLayer(i[1])}else e._updateIcon()},_extractNonGroupLayers:function(t,e){var i,n=t.getLayers(),r=0;for(e=e||[];r<n.length;r++)(i=n[r])instanceof L.LayerGroup?this._extractNonGroupLayers(i,e):e.push(i);return e},_overrideMarkerIcon:function(t){return t.options.icon=this.options.iconCreateFunction({getChildCount:function(){return 1},getAllChildMarkers:function(){return[t]}})}});L.MarkerClusterGroup.include({_mapBoundsInfinite:new L.LatLngBounds(new L.LatLng(-1/0,-1/0),new L.LatLng(1/0,1/0))}),L.MarkerClusterGroup.include({_noAnimation:{_animationStart:function(){},_animationZoomIn:function(t,e){this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,Math.floor(this._map.getMinZoom()),t),this._topClusterLevel._recursivelyAddChildrenToMap(null,e,this._getExpandedVisibleBounds()),this.fire("animationend")},_animationZoomOut:function(t,e){this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,Math.floor(this._map.getMinZoom()),t),this._topClusterLevel._recursivelyAddChildrenToMap(null,e,this._getExpandedVisibleBounds()),this.fire("animationend")},_animationAddLayer:function(t,e){this._animationAddLayerNonAnimated(t,e)}},_withAnimation:{_animationStart:function(){this._map._mapPane.className+=" leaflet-cluster-anim",this._inZoomAnimation++},_animationZoomIn:function(t,e){var i,n=this._getExpandedVisibleBounds(),r=this._featureGroup,o=Math.floor(this._map.getMinZoom());this._ignoreMove=!0,this._topClusterLevel._recursively(n,t,o,(function(o){var s,a=o._latlng,l=o._markers;for(n.contains(a)||(a=null),o._isSingleParent()&&t+1===e?(r.removeLayer(o),o._recursivelyAddChildrenToMap(null,e,n)):(o.clusterHide(),o._recursivelyAddChildrenToMap(a,e,n)),i=l.length-1;i>=0;i--)s=l[i],n.contains(s._latlng)||r.removeLayer(s)})),this._forceLayout(),this._topClusterLevel._recursivelyBecomeVisible(n,e),r.eachLayer((function(t){t instanceof L.MarkerCluster||!t._icon||t.clusterShow()})),this._topClusterLevel._recursively(n,t,e,(function(t){t._recursivelyRestoreChildPositions(e)})),this._ignoreMove=!1,this._enqueue((function(){this._topClusterLevel._recursively(n,t,o,(function(t){r.removeLayer(t),t.clusterShow()})),this._animationEnd()}))},_animationZoomOut:function(t,e){this._animationZoomOutSingle(this._topClusterLevel,t-1,e),this._topClusterLevel._recursivelyAddChildrenToMap(null,e,this._getExpandedVisibleBounds()),this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,Math.floor(this._map.getMinZoom()),t,this._getExpandedVisibleBounds())},_animationAddLayer:function(t,e){var i=this,n=this._featureGroup;n.addLayer(t),e!==t&&(e._childCount>2?(e._updateIcon(),this._forceLayout(),this._animationStart(),t._setPos(this._map.latLngToLayerPoint(e.getLatLng())),t.clusterHide(),this._enqueue((function(){n.removeLayer(t),t.clusterShow(),i._animationEnd()}))):(this._forceLayout(),i._animationStart(),i._animationZoomOutSingle(e,this._map.getMaxZoom(),this._zoom)))}},_animationZoomOutSingle:function(t,e,i){var n=this._getExpandedVisibleBounds(),r=Math.floor(this._map.getMinZoom());t._recursivelyAnimateChildrenInAndAddSelfToMap(n,r,e+1,i);var o=this;this._forceLayout(),t._recursivelyBecomeVisible(n,i),this._enqueue((function(){if(1===t._childCount){var s=t._markers[0];this._ignoreMove=!0,s.setLatLng(s.getLatLng()),this._ignoreMove=!1,s.clusterShow&&s.clusterShow()}else t._recursively(n,i,r,(function(t){t._recursivelyRemoveChildrenFromMap(n,r,e+1)}));o._animationEnd()}))},_animationEnd:function(){this._map&&(this._map._mapPane.className=this._map._mapPane.className.replace(" leaflet-cluster-anim","")),this._inZoomAnimation--,this.fire("animationend")},_forceLayout:function(){L.Util.falseFn(document.body.offsetWidth)}}),L.markerClusterGroup=function(t){return new L.MarkerClusterGroup(t)};var i=L.MarkerCluster=L.Marker.extend({options:L.Icon.prototype.options,initialize:function(t,e,i,n){L.Marker.prototype.initialize.call(this,i?i._cLatLng||i.getLatLng():new L.LatLng(0,0),{icon:this,pane:t.options.clusterPane}),this._group=t,this._zoom=e,this._markers=[],this._childClusters=[],this._childCount=0,this._iconNeedsUpdate=!0,this._boundsNeedUpdate=!0,this._bounds=new L.LatLngBounds,i&&this._addChild(i),n&&this._addChild(n)},getAllChildMarkers:function(t,e){t=t||[];for(var i=this._childClusters.length-1;i>=0;i--)this._childClusters[i].getAllChildMarkers(t,e);for(var n=this._markers.length-1;n>=0;n--)e&&this._markers[n].__dragStart||t.push(this._markers[n]);return t},getChildCount:function(){return this._childCount},zoomToBounds:function(t){for(var e,i=this._childClusters.slice(),n=this._group._map,r=n.getBoundsZoom(this._bounds),o=this._zoom+1,s=n.getZoom();i.length>0&&r>o;){o++;var a=[];for(e=0;e<i.length;e++)a=a.concat(i[e]._childClusters);i=a}r>o?this._group._map.setView(this._latlng,o):r<=s?this._group._map.setView(this._latlng,s+1):this._group._map.fitBounds(this._bounds,t)},getBounds:function(){var t=new L.LatLngBounds;return t.extend(this._bounds),t},_updateIcon:function(){this._iconNeedsUpdate=!0,this._icon&&this.setIcon(this)},createIcon:function(){return this._iconNeedsUpdate&&(this._iconObj=this._group.options.iconCreateFunction(this),this._iconNeedsUpdate=!1),this._iconObj.createIcon()},createShadow:function(){return this._iconObj.createShadow()},_addChild:function(t,e){this._iconNeedsUpdate=!0,this._boundsNeedUpdate=!0,this._setClusterCenter(t),t instanceof L.MarkerCluster?(e||(this._childClusters.push(t),t.__parent=this),this._childCount+=t._childCount):(e||this._markers.push(t),this._childCount++),this.__parent&&this.__parent._addChild(t,!0)},_setClusterCenter:function(t){this._cLatLng||(this._cLatLng=t._cLatLng||t._latlng)},_resetBounds:function(){var t=this._bounds;t._southWest&&(t._southWest.lat=1/0,t._southWest.lng=1/0),t._northEast&&(t._northEast.lat=-1/0,t._northEast.lng=-1/0)},_recalculateBounds:function(){var t,e,i,n,r=this._markers,o=this._childClusters,s=0,a=0,l=this._childCount;if(0!==l){for(this._resetBounds(),t=0;t<r.length;t++)i=r[t]._latlng,this._bounds.extend(i),s+=i.lat,a+=i.lng;for(t=0;t<o.length;t++)(e=o[t])._boundsNeedUpdate&&e._recalculateBounds(),this._bounds.extend(e._bounds),i=e._wLatLng,n=e._childCount,s+=i.lat*n,a+=i.lng*n;this._latlng=this._wLatLng=new L.LatLng(s/l,a/l),this._boundsNeedUpdate=!1}},_addToMap:function(t){t&&(this._backupLatlng=this._latlng,this.setLatLng(t)),this._group._featureGroup.addLayer(this)},_recursivelyAnimateChildrenIn:function(t,e,i){this._recursively(t,this._group._map.getMinZoom(),i-1,(function(t){var i,n,r=t._markers;for(i=r.length-1;i>=0;i--)(n=r[i])._icon&&(n._setPos(e),n.clusterHide())}),(function(t){var i,n,r=t._childClusters;for(i=r.length-1;i>=0;i--)(n=r[i])._icon&&(n._setPos(e),n.clusterHide())}))},_recursivelyAnimateChildrenInAndAddSelfToMap:function(t,e,i,n){this._recursively(t,n,e,(function(r){r._recursivelyAnimateChildrenIn(t,r._group._map.latLngToLayerPoint(r.getLatLng()).round(),i),r._isSingleParent()&&i-1===n?(r.clusterShow(),r._recursivelyRemoveChildrenFromMap(t,e,i)):r.clusterHide(),r._addToMap()}))},_recursivelyBecomeVisible:function(t,e){this._recursively(t,this._group._map.getMinZoom(),e,null,(function(t){t.clusterShow()}))},_recursivelyAddChildrenToMap:function(t,e,i){this._recursively(i,this._group._map.getMinZoom()-1,e,(function(n){if(e!==n._zoom)for(var r=n._markers.length-1;r>=0;r--){var o=n._markers[r];i.contains(o._latlng)&&(t&&(o._backupLatlng=o.getLatLng(),o.setLatLng(t),o.clusterHide&&o.clusterHide()),n._group._featureGroup.addLayer(o))}}),(function(e){e._addToMap(t)}))},_recursivelyRestoreChildPositions:function(t){for(var e=this._markers.length-1;e>=0;e--){var i=this._markers[e];i._backupLatlng&&(i.setLatLng(i._backupLatlng),delete i._backupLatlng)}if(t-1===this._zoom)for(var n=this._childClusters.length-1;n>=0;n--)this._childClusters[n]._restorePosition();else for(var r=this._childClusters.length-1;r>=0;r--)this._childClusters[r]._recursivelyRestoreChildPositions(t)},_restorePosition:function(){this._backupLatlng&&(this.setLatLng(this._backupLatlng),delete this._backupLatlng)},_recursivelyRemoveChildrenFromMap:function(t,e,i,n){var r,o;this._recursively(t,e-1,i-1,(function(t){for(o=t._markers.length-1;o>=0;o--)r=t._markers[o],n&&n.contains(r._latlng)||(t._group._featureGroup.removeLayer(r),r.clusterShow&&r.clusterShow())}),(function(t){for(o=t._childClusters.length-1;o>=0;o--)r=t._childClusters[o],n&&n.contains(r._latlng)||(t._group._featureGroup.removeLayer(r),r.clusterShow&&r.clusterShow())}))},_recursively:function(t,e,i,n,r){var o,s,a=this._childClusters,l=this._zoom;if(e<=l&&(n&&n(this),r&&l===i&&r(this)),l<e||l<i)for(o=a.length-1;o>=0;o--)(s=a[o])._boundsNeedUpdate&&s._recalculateBounds(),t.intersects(s._bounds)&&s._recursively(t,e,i,n,r)},_isSingleParent:function(){return this._childClusters.length>0&&this._childClusters[0]._childCount===this._childCount}});L.Marker.include({clusterHide:function(){var t=this.options.opacity;return this.setOpacity(0),this.options.opacity=t,this},clusterShow:function(){return this.setOpacity(this.options.opacity)}}),L.DistanceGrid=function(t){this._cellSize=t,this._sqCellSize=t*t,this._grid={},this._objectPoint={}},L.DistanceGrid.prototype={addObject:function(t,e){var i=this._getCoord(e.x),n=this._getCoord(e.y),r=this._grid,o=r[n]=r[n]||{},s=o[i]=o[i]||[],a=L.Util.stamp(t);this._objectPoint[a]=e,s.push(t)},updateObject:function(t,e){this.removeObject(t),this.addObject(t,e)},removeObject:function(t,e){var i,n,r=this._getCoord(e.x),o=this._getCoord(e.y),s=this._grid,a=s[o]=s[o]||{},l=a[r]=a[r]||[];for(delete this._objectPoint[L.Util.stamp(t)],i=0,n=l.length;i<n;i++)if(l[i]===t)return l.splice(i,1),1===n&&delete a[r],!0},eachObject:function(t,e){var i,n,r,o,s,a,l=this._grid;for(i in l)for(n in s=l[i])for(r=0,o=(a=s[n]).length;r<o;r++)t.call(e,a[r])&&(r--,o--)},getNearObject:function(t){var e,i,n,r,o,s,a,l,h=this._getCoord(t.x),c=this._getCoord(t.y),u=this._objectPoint,d=this._sqCellSize,p=null;for(e=c-1;e<=c+1;e++)if(r=this._grid[e])for(i=h-1;i<=h+1;i++)if(o=r[i])for(n=0,s=o.length;n<s;n++)a=o[n],((l=this._sqDist(u[L.Util.stamp(a)],t))<d||l<=d&&null===p)&&(d=l,p=a);return p},_getCoord:function(t){var e=Math.floor(t/this._cellSize);return isFinite(e)?e:t},_sqDist:function(t,e){var i=e.x-t.x,n=e.y-t.y;return i*i+n*n}},L.QuickHull={getDistant:function(t,e){var i=e[1].lat-e[0].lat;return(e[0].lng-e[1].lng)*(t.lat-e[0].lat)+i*(t.lng-e[0].lng)},findMostDistantPointFromBaseLine:function(t,e){var i,n,r,o=0,s=null,a=[];for(i=e.length-1;i>=0;i--)n=e[i],(r=this.getDistant(n,t))>0&&(a.push(n),r>o&&(o=r,s=n));return{maxPoint:s,newPoints:a}},buildConvexHull:function(t,e){var i=[],n=this.findMostDistantPointFromBaseLine(t,e);return n.maxPoint?i=(i=i.concat(this.buildConvexHull([t[0],n.maxPoint],n.newPoints))).concat(this.buildConvexHull([n.maxPoint,t[1]],n.newPoints)):[t[0]]},getConvexHull:function(t){var e,i=!1,n=!1,r=!1,o=!1,s=null,a=null,l=null,h=null,c=null,u=null;for(e=t.length-1;e>=0;e--){var d=t[e];(!1===i||d.lat>i)&&(s=d,i=d.lat),(!1===n||d.lat<n)&&(a=d,n=d.lat),(!1===r||d.lng>r)&&(l=d,r=d.lng),(!1===o||d.lng<o)&&(h=d,o=d.lng)}return n!==i?(u=a,c=s):(u=h,c=l),[].concat(this.buildConvexHull([u,c],t),this.buildConvexHull([c,u],t))}},L.MarkerCluster.include({getConvexHull:function(){var t,e,i=this.getAllChildMarkers(),n=[];for(e=i.length-1;e>=0;e--)t=i[e].getLatLng(),n.push(t);return L.QuickHull.getConvexHull(n)}}),L.MarkerCluster.include({_2PI:2*Math.PI,_circleFootSeparation:25,_circleStartAngle:0,_spiralFootSeparation:28,_spiralLengthStart:11,_spiralLengthFactor:5,_circleSpiralSwitchover:9,spiderfy:function(){if(this._group._spiderfied!==this&&!this._group._inZoomAnimation){var t,e=this.getAllChildMarkers(null,!0),i=this._group._map.latLngToLayerPoint(this._latlng);this._group._unspiderfy(),this._group._spiderfied=this,this._group.options.spiderfyShapePositions?t=this._group.options.spiderfyShapePositions(e.length,i):e.length>=this._circleSpiralSwitchover?t=this._generatePointsSpiral(e.length,i):(i.y+=10,t=this._generatePointsCircle(e.length,i)),this._animationSpiderfy(e,t)}},unspiderfy:function(t){this._group._inZoomAnimation||(this._animationUnspiderfy(t),this._group._spiderfied=null)},_generatePointsCircle:function(t,e){var i,n,r=this._group.options.spiderfyDistanceMultiplier*this._circleFootSeparation*(2+t)/this._2PI,o=this._2PI/t,s=[];for(r=Math.max(r,35),s.length=t,i=0;i<t;i++)n=this._circleStartAngle+i*o,s[i]=new L.Point(e.x+r*Math.cos(n),e.y+r*Math.sin(n))._round();return s},_generatePointsSpiral:function(t,e){var i,n=this._group.options.spiderfyDistanceMultiplier,r=n*this._spiralLengthStart,o=n*this._spiralFootSeparation,s=n*this._spiralLengthFactor*this._2PI,a=0,l=[];for(l.length=t,i=t;i>=0;i--)i<t&&(l[i]=new L.Point(e.x+r*Math.cos(a),e.y+r*Math.sin(a))._round()),r+=s/(a+=o/r+5e-4*i);return l},_noanimationUnspiderfy:function(){var t,e,i=this._group,n=i._map,r=i._featureGroup,o=this.getAllChildMarkers(null,!0);for(i._ignoreMove=!0,this.setOpacity(1),e=o.length-1;e>=0;e--)t=o[e],r.removeLayer(t),t._preSpiderfyLatlng&&(t.setLatLng(t._preSpiderfyLatlng),delete t._preSpiderfyLatlng),t.setZIndexOffset&&t.setZIndexOffset(0),t._spiderLeg&&(n.removeLayer(t._spiderLeg),delete t._spiderLeg);i.fire("unspiderfied",{cluster:this,markers:o}),i._ignoreMove=!1,i._spiderfied=null}}),L.MarkerClusterNonAnimated=L.MarkerCluster.extend({_animationSpiderfy:function(t,e){var i,n,r,o,s=this._group,a=s._map,l=s._featureGroup,h=this._group.options.spiderLegPolylineOptions;for(s._ignoreMove=!0,i=0;i<t.length;i++)o=a.layerPointToLatLng(e[i]),n=t[i],r=new L.Polyline([this._latlng,o],h),a.addLayer(r),n._spiderLeg=r,n._preSpiderfyLatlng=n._latlng,n.setLatLng(o),n.setZIndexOffset&&n.setZIndexOffset(1e6),l.addLayer(n);this.setOpacity(.3),s._ignoreMove=!1,s.fire("spiderfied",{cluster:this,markers:t})},_animationUnspiderfy:function(){this._noanimationUnspiderfy()}}),L.MarkerCluster.include({_animationSpiderfy:function(t,e){var i,n,r,o,s,a,l=this,h=this._group,c=h._map,u=h._featureGroup,d=this._latlng,p=c.latLngToLayerPoint(d),f=L.Path.SVG,m=L.extend({},this._group.options.spiderLegPolylineOptions),g=m.opacity;for(void 0===g&&(g=L.MarkerClusterGroup.prototype.options.spiderLegPolylineOptions.opacity),f?(m.opacity=0,m.className=(m.className||"")+" leaflet-cluster-spider-leg"):m.opacity=g,h._ignoreMove=!0,i=0;i<t.length;i++)n=t[i],a=c.layerPointToLatLng(e[i]),r=new L.Polyline([d,a],m),c.addLayer(r),n._spiderLeg=r,f&&(s=(o=r._path).getTotalLength()+.1,o.style.strokeDasharray=s,o.style.strokeDashoffset=s),n.setZIndexOffset&&n.setZIndexOffset(1e6),n.clusterHide&&n.clusterHide(),u.addLayer(n),n._setPos&&n._setPos(p);for(h._forceLayout(),h._animationStart(),i=t.length-1;i>=0;i--)a=c.layerPointToLatLng(e[i]),(n=t[i])._preSpiderfyLatlng=n._latlng,n.setLatLng(a),n.clusterShow&&n.clusterShow(),f&&((o=(r=n._spiderLeg)._path).style.strokeDashoffset=0,r.setStyle({opacity:g}));this.setOpacity(.3),h._ignoreMove=!1,setTimeout((function(){h._animationEnd(),h.fire("spiderfied",{cluster:l,markers:t})}),200)},_animationUnspiderfy:function(t){var e,i,n,r,o,s,a=this,l=this._group,h=l._map,c=l._featureGroup,u=t?h._latLngToNewLayerPoint(this._latlng,t.zoom,t.center):h.latLngToLayerPoint(this._latlng),d=this.getAllChildMarkers(null,!0),p=L.Path.SVG;for(l._ignoreMove=!0,l._animationStart(),this.setOpacity(1),i=d.length-1;i>=0;i--)(e=d[i])._preSpiderfyLatlng&&(e.closePopup(),e.setLatLng(e._preSpiderfyLatlng),delete e._preSpiderfyLatlng,s=!0,e._setPos&&(e._setPos(u),s=!1),e.clusterHide&&(e.clusterHide(),s=!1),s&&c.removeLayer(e),p&&(o=(r=(n=e._spiderLeg)._path).getTotalLength()+.1,r.style.strokeDashoffset=o,n.setStyle({opacity:0})));l._ignoreMove=!1,setTimeout((function(){var t=0;for(i=d.length-1;i>=0;i--)(e=d[i])._spiderLeg&&t++;for(i=d.length-1;i>=0;i--)(e=d[i])._spiderLeg&&(e.clusterShow&&e.clusterShow(),e.setZIndexOffset&&e.setZIndexOffset(0),t>1&&c.removeLayer(e),h.removeLayer(e._spiderLeg),delete e._spiderLeg);l._animationEnd(),l.fire("unspiderfied",{cluster:a,markers:d})}),200)}}),L.MarkerClusterGroup.include({_spiderfied:null,unspiderfy:function(){this._unspiderfy.apply(this,arguments)},_spiderfierOnAdd:function(){this._map.on("click",this._unspiderfyWrapper,this),this._map.options.zoomAnimation&&this._map.on("zoomstart",this._unspiderfyZoomStart,this),this._map.on("zoomend",this._noanimationUnspiderfy,this),L.Browser.touch||this._map.getRenderer(this)},_spiderfierOnRemove:function(){this._map.off("click",this._unspiderfyWrapper,this),this._map.off("zoomstart",this._unspiderfyZoomStart,this),this._map.off("zoomanim",this._unspiderfyZoomAnim,this),this._map.off("zoomend",this._noanimationUnspiderfy,this),this._noanimationUnspiderfy()},_unspiderfyZoomStart:function(){this._map&&this._map.on("zoomanim",this._unspiderfyZoomAnim,this)},_unspiderfyZoomAnim:function(t){L.DomUtil.hasClass(this._map._mapPane,"leaflet-touching")||(this._map.off("zoomanim",this._unspiderfyZoomAnim,this),this._unspiderfy(t))},_unspiderfyWrapper:function(){this._unspiderfy()},_unspiderfy:function(t){this._spiderfied&&this._spiderfied.unspiderfy(t)},_noanimationUnspiderfy:function(){this._spiderfied&&this._spiderfied._noanimationUnspiderfy()},_unspiderfyLayer:function(t){t._spiderLeg&&(this._featureGroup.removeLayer(t),t.clusterShow&&t.clusterShow(),t.setZIndexOffset&&t.setZIndexOffset(0),this._map.removeLayer(t._spiderLeg),delete t._spiderLeg)}}),L.MarkerClusterGroup.include({refreshClusters:function(t){return t?t instanceof L.MarkerClusterGroup?t=t._topClusterLevel.getAllChildMarkers():t instanceof L.LayerGroup?t=t._layers:t instanceof L.MarkerCluster?t=t.getAllChildMarkers():t instanceof L.Marker&&(t=[t]):t=this._topClusterLevel.getAllChildMarkers(),this._flagParentsIconsNeedUpdate(t),this._refreshClustersIcons(),this.options.singleMarkerMode&&this._refreshSingleMarkerModeMarkers(t),this},_flagParentsIconsNeedUpdate:function(t){var e,i;for(e in t)for(i=t[e].__parent;i;)i._iconNeedsUpdate=!0,i=i.__parent},_refreshSingleMarkerModeMarkers:function(t){var e,i;for(e in t)i=t[e],this.hasLayer(i)&&i.setIcon(this._overrideMarkerIcon(i))}}),L.Marker.include({refreshIconOptions:function(t,e){var i=this.options.icon;return L.setOptions(i,t),this.setIcon(i),e&&this.__parent&&this.__parent._group.refreshClusters(this),this}}),t.MarkerClusterGroup=e,t.MarkerCluster=i,Object.defineProperty(t,"__esModule",{value:!0})}(e)},1626:()=>{"use strict";function t(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length}function e(e){return e.type===t.Bytes?e.readVarint()+e.pos:e.pos+1}function i(t,e,i){return i?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function n(t,e,i){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.ceil(Math.log(e)/(7*Math.LN2));i.realloc(n);for(var r=i.pos-1;r>=t;r--)i.buf[r+n]=i.buf[r]}function r(t,e){for(var i=0;i<t.length;i++)e.writeVarint(t[i])}function o(t,e){for(var i=0;i<t.length;i++)e.writeSVarint(t[i])}function s(t,e){for(var i=0;i<t.length;i++)e.writeFloat(t[i])}function a(t,e){for(var i=0;i<t.length;i++)e.writeDouble(t[i])}function l(t,e){for(var i=0;i<t.length;i++)e.writeBoolean(t[i])}function h(t,e){for(var i=0;i<t.length;i++)e.writeFixed32(t[i])}function c(t,e){for(var i=0;i<t.length;i++)e.writeSFixed32(t[i])}function u(t,e){for(var i=0;i<t.length;i++)e.writeFixed64(t[i])}function d(t,e){for(var i=0;i<t.length;i++)e.writeSFixed64(t[i])}function p(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function f(t,e,i){t[i]=e,t[i+1]=e>>>8,t[i+2]=e>>>16,t[i+3]=e>>>24}function m(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}function g(t,e){this.x=t,this.y=e}function _(t,e,i,n,r){this.properties={},this.extent=i,this.type=0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=r,t.readFields(y,this,e)}function y(t,e,i){1==t?e.id=i.readVarint():2==t?function(t,e){for(var i=t.readVarint()+t.pos;t.pos<i;){var n=e._keys[t.readVarint()],r=e._values[t.readVarint()];e.properties[n]=r}}(i,e):3==t?e.type=i.readVarint():4==t&&(e._geometry=i.pos)}function v(t){for(var e,i,n=0,r=0,o=t.length,s=o-1;r<o;s=r++)e=t[r],n+=((i=t[s]).x-e.x)*(e.y+i.y);return n}function b(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(x,this,e),this.length=this._features.length}function x(t,e,i){15===t?e.version=i.readVarint():1===t?e.name=i.readString():5===t?e.extent=i.readVarint():2===t?e._features.push(i.pos):3===t?e._keys.push(i.readString()):4===t&&e._values.push(function(t){for(var e=null,i=t.readVarint()+t.pos;t.pos<i;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null}return e}(i))}function w(t,e,i){if(3===t){var n=new z(i,i.readVarint()+i.pos);n.length&&(e[n.name]=n)}}!function(t){function e(t){if("string"!=typeof t&&(t=String(t)),/[^a-z0-9\-#$%&'*+.\^_`|~]/i.test(t))throw new TypeError("Invalid character in header field name");return t.toLowerCase()}function i(t){return"string"!=typeof t&&(t=String(t)),t}function n(t){var e={next:function(){var e=t.shift();return{done:void 0===e,value:e}}};return f.iterable&&(e[Symbol.iterator]=function(){return e}),e}function r(t){this.map={},t instanceof r?t.forEach((function(t,e){this.append(e,t)}),this):Array.isArray(t)?t.forEach((function(t){this.append(t[0],t[1])}),this):t&&Object.getOwnPropertyNames(t).forEach((function(e){this.append(e,t[e])}),this)}function o(t){if(t.bodyUsed)return Promise.reject(new TypeError("Already read"));t.bodyUsed=!0}function s(t){return new Promise((function(e,i){t.onload=function(){e(t.result)},t.onerror=function(){i(t.error)}}))}function a(t){var e=new FileReader,i=s(e);return e.readAsArrayBuffer(t),i}function l(t){if(t.slice)return t.slice(0);var e=new Uint8Array(t.byteLength);return e.set(new Uint8Array(t)),e.buffer}function h(){return this.bodyUsed=!1,this._initBody=function(t){if(this._bodyInit=t,t)if("string"==typeof t)this._bodyText=t;else if(f.blob&&Blob.prototype.isPrototypeOf(t))this._bodyBlob=t;else if(f.formData&&FormData.prototype.isPrototypeOf(t))this._bodyFormData=t;else if(f.searchParams&&URLSearchParams.prototype.isPrototypeOf(t))this._bodyText=t.toString();else if(f.arrayBuffer&&f.blob&&g(t))this._bodyArrayBuffer=l(t.buffer),this._bodyInit=new Blob([this._bodyArrayBuffer]);else{if(!f.arrayBuffer||!ArrayBuffer.prototype.isPrototypeOf(t)&&!_(t))throw new Error("unsupported BodyInit type");this._bodyArrayBuffer=l(t)}else this._bodyText="";this.headers.get("content-type")||("string"==typeof t?this.headers.set("content-type","text/plain;charset=UTF-8"):this._bodyBlob&&this._bodyBlob.type?this.headers.set("content-type",this._bodyBlob.type):f.searchParams&&URLSearchParams.prototype.isPrototypeOf(t)&&this.headers.set("content-type","application/x-www-form-urlencoded;charset=UTF-8"))},f.blob&&(this.blob=function(){var t=o(this);if(t)return t;if(this._bodyBlob)return Promise.resolve(this._bodyBlob);if(this._bodyArrayBuffer)return Promise.resolve(new Blob([this._bodyArrayBuffer]));if(this._bodyFormData)throw new Error("could not read FormData body as blob");return Promise.resolve(new Blob([this._bodyText]))},this.arrayBuffer=function(){return this._bodyArrayBuffer?o(this)||Promise.resolve(this._bodyArrayBuffer):this.blob().then(a)}),this.text=function(){var t=o(this);if(t)return t;if(this._bodyBlob)return function(t){var e=new FileReader,i=s(e);return e.readAsText(t),i}(this._bodyBlob);if(this._bodyArrayBuffer)return Promise.resolve(function(t){for(var e=new Uint8Array(t),i=new Array(e.length),n=0;n<e.length;n++)i[n]=String.fromCharCode(e[n]);return i.join("")}(this._bodyArrayBuffer));if(this._bodyFormData)throw new Error("could not read FormData body as text");return Promise.resolve(this._bodyText)},f.formData&&(this.formData=function(){return this.text().then(u)}),this.json=function(){return this.text().then(JSON.parse)},this}function c(t,e){var i=(e=e||{}).body;if(t instanceof c){if(t.bodyUsed)throw new TypeError("Already read");this.url=t.url,this.credentials=t.credentials,e.headers||(this.headers=new r(t.headers)),this.method=t.method,this.mode=t.mode,i||null==t._bodyInit||(i=t._bodyInit,t.bodyUsed=!0)}else this.url=String(t);if(this.credentials=e.credentials||this.credentials||"omit",!e.headers&&this.headers||(this.headers=new r(e.headers)),this.method=function(t){var e=t.toUpperCase();return y.indexOf(e)>-1?e:t}(e.method||this.method||"GET"),this.mode=e.mode||this.mode||null,this.referrer=null,("GET"===this.method||"HEAD"===this.method)&&i)throw new TypeError("Body not allowed for GET or HEAD requests");this._initBody(i)}function u(t){var e=new FormData;return t.trim().split("&").forEach((function(t){if(t){var i=t.split("="),n=i.shift().replace(/\+/g," "),r=i.join("=").replace(/\+/g," ");e.append(decodeURIComponent(n),decodeURIComponent(r))}})),e}function d(t){var e=new r;return t.split(/\r?\n/).forEach((function(t){var i=t.split(":"),n=i.shift().trim();if(n){var r=i.join(":").trim();e.append(n,r)}})),e}function p(t,e){e||(e={}),this.type="default",this.status="status"in e?e.status:200,this.ok=this.status>=200&&this.status<300,this.statusText="statusText"in e?e.statusText:"OK",this.headers=new r(e.headers),this.url=e.url||"",this._initBody(t)}if(!t.fetch){var f={searchParams:"URLSearchParams"in t,iterable:"Symbol"in t&&"iterator"in Symbol,blob:"FileReader"in t&&"Blob"in t&&function(){try{return new Blob,!0}catch(t){return!1}}(),formData:"FormData"in t,arrayBuffer:"ArrayBuffer"in t};if(f.arrayBuffer)var m=["[object Int8Array]","[object Uint8Array]","[object Uint8ClampedArray]","[object Int16Array]","[object Uint16Array]","[object Int32Array]","[object Uint32Array]","[object Float32Array]","[object Float64Array]"],g=function(t){return t&&DataView.prototype.isPrototypeOf(t)},_=ArrayBuffer.isView||function(t){return t&&m.indexOf(Object.prototype.toString.call(t))>-1};r.prototype.append=function(t,n){t=e(t),n=i(n);var r=this.map[t];this.map[t]=r?r+","+n:n},r.prototype.delete=function(t){delete this.map[e(t)]},r.prototype.get=function(t){return t=e(t),this.has(t)?this.map[t]:null},r.prototype.has=function(t){return this.map.hasOwnProperty(e(t))},r.prototype.set=function(t,n){this.map[e(t)]=i(n)},r.prototype.forEach=function(t,e){var i=this;for(var n in this.map)i.map.hasOwnProperty(n)&&t.call(e,i.map[n],n,i)},r.prototype.keys=function(){var t=[];return this.forEach((function(e,i){t.push(i)})),n(t)},r.prototype.values=function(){var t=[];return this.forEach((function(e){t.push(e)})),n(t)},r.prototype.entries=function(){var t=[];return this.forEach((function(e,i){t.push([i,e])})),n(t)},f.iterable&&(r.prototype[Symbol.iterator]=r.prototype.entries);var y=["DELETE","GET","HEAD","OPTIONS","POST","PUT"];c.prototype.clone=function(){return new c(this,{body:this._bodyInit})},h.call(c.prototype),h.call(p.prototype),p.prototype.clone=function(){return new p(this._bodyInit,{status:this.status,statusText:this.statusText,headers:new r(this.headers),url:this.url})},p.error=function(){var t=new p(null,{status:0,statusText:""});return t.type="error",t};var v=[301,302,303,307,308];p.redirect=function(t,e){if(-1===v.indexOf(e))throw new RangeError("Invalid status code");return new p(null,{status:e,headers:{location:t}})},t.Headers=r,t.Request=c,t.Response=p,t.fetch=function(t,e){return new Promise((function(i,n){var r=new c(t,e),o=new XMLHttpRequest;o.onload=function(){var t={status:o.status,statusText:o.statusText,headers:d(o.getAllResponseHeaders()||"")};t.url="responseURL"in o?o.responseURL:t.headers.get("X-Request-URL");var e="response"in o?o.response:o.responseText;i(new p(e,t))},o.onerror=function(){n(new TypeError("Network request failed"))},o.ontimeout=function(){n(new TypeError("Network request failed"))},o.open(r.method,r.url,!0),"include"===r.credentials&&(o.withCredentials=!0),"responseType"in o&&f.blob&&(o.responseType="blob"),r.headers.forEach((function(t,e){o.setRequestHeader(e,t)})),o.send(void 0===r._bodyInit?null:r._bodyInit)}))},t.fetch.polyfill=!0}}("undefined"!=typeof self?self:void 0);var M=t,k=function(t,e,i,n,r){var o,s,a=8*r-n-1,l=(1<<a)-1,h=l>>1,c=-7,u=i?r-1:0,d=i?-1:1,p=t[e+u];for(u+=d,o=p&(1<<-c)-1,p>>=-c,c+=a;c>0;o=256*o+t[e+u],u+=d,c-=8);for(s=o&(1<<-c)-1,o>>=-c,c+=n;c>0;s=256*s+t[e+u],u+=d,c-=8);if(0===o)o=1-h;else{if(o===l)return s?NaN:1/0*(p?-1:1);s+=Math.pow(2,n),o-=h}return(p?-1:1)*s*Math.pow(2,o-n)},C=function(t,e,i,n,r,o){var s,a,l,h=8*o-r-1,c=(1<<h)-1,u=c>>1,d=23===r?Math.pow(2,-24)-Math.pow(2,-77):0,p=n?0:o-1,f=n?1:-1,m=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(a=isNaN(e)?1:0,s=c):(s=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-s))<1&&(s--,l*=2),(e+=s+u>=1?d/l:d*Math.pow(2,1-u))*l>=2&&(s++,l/=2),s+u>=c?(a=0,s=c):s+u>=1?(a=(e*l-1)*Math.pow(2,r),s+=u):(a=e*Math.pow(2,u-1)*Math.pow(2,r),s=0));r>=8;t[i+p]=255&a,p+=f,a/=256,r-=8);for(s=s<<r|a,h+=r;h>0;t[i+p]=255&s,p+=f,s/=256,h-=8);t[i+p-f]|=128*m};t.Varint=0,t.Fixed64=1,t.Bytes=2,t.Fixed32=5;var A=4294967296,P=1/A;t.prototype={destroy:function(){this.buf=null},readFields:function(t,e,i){var n=this;for(i=i||this.length;this.pos<i;){var r=n.readVarint(),o=r>>3,s=n.pos;n.type=7&r,t(o,e,n),n.pos===s&&n.skip(r)}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=p(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=m(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=p(this.buf,this.pos)+p(this.buf,this.pos+4)*A;return this.pos+=8,t},readSFixed64:function(){var t=p(this.buf,this.pos)+m(this.buf,this.pos+4)*A;return this.pos+=8,t},readFloat:function(){var t=k(this.buf,this.pos,!0,23,4);return this.pos+=4,t},readDouble:function(){var t=k(this.buf,this.pos,!0,52,8);return this.pos+=8,t},readVarint:function(t){var e,n,r=this.buf;return e=127&(n=r[this.pos++]),n<128?e:(e|=(127&(n=r[this.pos++]))<<7,n<128?e:(e|=(127&(n=r[this.pos++]))<<14,n<128?e:(e|=(127&(n=r[this.pos++]))<<21,n<128?e:function(t,e,n){var r,o,s=n.buf;if(r=(112&(o=s[n.pos++]))>>4,o<128)return i(t,r,e);if(r|=(127&(o=s[n.pos++]))<<3,o<128)return i(t,r,e);if(r|=(127&(o=s[n.pos++]))<<10,o<128)return i(t,r,e);if(r|=(127&(o=s[n.pos++]))<<17,o<128)return i(t,r,e);if(r|=(127&(o=s[n.pos++]))<<24,o<128)return i(t,r,e);if(r|=(1&(o=s[n.pos++]))<<31,o<128)return i(t,r,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(n=r[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=function(t,e,i){for(var n="",r=e;r<i;){var o,s,a,l=t[r],h=null,c=l>239?4:l>223?3:l>191?2:1;if(r+c>i)break;1===c?l<128&&(h=l):2===c?128==(192&(o=t[r+1]))&&(h=(31&l)<<6|63&o)<=127&&(h=null):3===c?(o=t[r+1],s=t[r+2],128==(192&o)&&128==(192&s)&&((h=(15&l)<<12|(63&o)<<6|63&s)<=2047||h>=55296&&h<=57343)&&(h=null)):4===c&&(o=t[r+1],s=t[r+2],a=t[r+3],128==(192&o)&&128==(192&s)&&128==(192&a)&&((h=(15&l)<<18|(63&o)<<12|(63&s)<<6|63&a)<=65535||h>=1114112)&&(h=null)),null===h?(h=65533,c=1):h>65535&&(h-=65536,n+=String.fromCharCode(h>>>10&1023|55296),h=56320|1023&h),n+=String.fromCharCode(h),r+=c}return n}(this.buf,this.pos,t);return this.pos=t,e},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,i){var n=e(this);for(t=t||[];this.pos<n;)t.push(this.readVarint(i));return t},readPackedSVarint:function(t){var i=e(this);for(t=t||[];this.pos<i;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){var i=e(this);for(t=t||[];this.pos<i;)t.push(this.readBoolean());return t},readPackedFloat:function(t){var i=e(this);for(t=t||[];this.pos<i;)t.push(this.readFloat());return t},readPackedDouble:function(t){var i=e(this);for(t=t||[];this.pos<i;)t.push(this.readDouble());return t},readPackedFixed32:function(t){var i=e(this);for(t=t||[];this.pos<i;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){var i=e(this);for(t=t||[];this.pos<i;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){var i=e(this);for(t=t||[];this.pos<i;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){var i=e(this);for(t=t||[];this.pos<i;)t.push(this.readSFixed64());return t},skip:function(e){var i=7&e;if(i===t.Varint)for(;this.buf[this.pos++]>127;);else if(i===t.Bytes)this.pos=this.readVarint()+this.pos;else if(i===t.Fixed32)this.pos+=4;else{if(i!==t.Fixed64)throw new Error("Unimplemented type: "+i);this.pos+=8}},writeTag:function(t,e){this.writeVarint(t<<3|e)},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var i=new Uint8Array(e);i.set(this.buf),this.buf=i,this.length=e}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),f(this.buf,t,this.pos),this.pos+=4},writeSFixed32:function(t){this.realloc(4),f(this.buf,t,this.pos),this.pos+=4},writeFixed64:function(t){this.realloc(8),f(this.buf,-1&t,this.pos),f(this.buf,Math.floor(t*P),this.pos+4),this.pos+=8},writeSFixed64:function(t){this.realloc(8),f(this.buf,-1&t,this.pos),f(this.buf,Math.floor(t*P),this.pos+4),this.pos+=8},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var i,n;if(t>=0?(i=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(i=~(-t%4294967296))?i=i+1|0:(i=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,i){i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos]=127&t}(i,0,e),function(t,e){var i=(7&t)<<4;e.buf[e.pos++]|=i|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))))}(n,e)}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))))},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t)},writeBoolean:function(t){this.writeVarint(Boolean(t))},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,i){for(var n,r,o=0;o<e.length;o++){if((n=e.charCodeAt(o))>55295&&n<57344){if(!r){n>56319||o+1===e.length?(t[i++]=239,t[i++]=191,t[i++]=189):r=n;continue}if(n<56320){t[i++]=239,t[i++]=191,t[i++]=189,r=n;continue}n=r-55296<<10|n-56320|65536,r=null}else r&&(t[i++]=239,t[i++]=191,t[i++]=189,r=null);n<128?t[i++]=n:(n<2048?t[i++]=n>>6|192:(n<65536?t[i++]=n>>12|224:(t[i++]=n>>18|240,t[i++]=n>>12&63|128),t[i++]=n>>6&63|128),t[i++]=63&n|128)}return i}(this.buf,t,this.pos);var i=this.pos-e;i>=128&&n(e,i,this),this.pos=e-1,this.writeVarint(i),this.pos+=i},writeFloat:function(t){this.realloc(4),C(this.buf,t,this.pos,!0,23,4),this.pos+=4},writeDouble:function(t){this.realloc(8),C(this.buf,t,this.pos,!0,52,8),this.pos+=8},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var i=0;i<e;i++)this.buf[this.pos++]=t[i]},writeRawMessage:function(t,e){this.pos++;var i=this.pos;t(e,this);var r=this.pos-i;r>=128&&n(i,r,this),this.pos=i-1,this.writeVarint(r),this.pos+=r},writeMessage:function(e,i,n){this.writeTag(e,t.Bytes),this.writeRawMessage(i,n)},writePackedVarint:function(t,e){this.writeMessage(t,r,e)},writePackedSVarint:function(t,e){this.writeMessage(t,o,e)},writePackedBoolean:function(t,e){this.writeMessage(t,l,e)},writePackedFloat:function(t,e){this.writeMessage(t,s,e)},writePackedDouble:function(t,e){this.writeMessage(t,a,e)},writePackedFixed32:function(t,e){this.writeMessage(t,h,e)},writePackedSFixed32:function(t,e){this.writeMessage(t,c,e)},writePackedFixed64:function(t,e){this.writeMessage(t,u,e)},writePackedSFixed64:function(t,e){this.writeMessage(t,d,e)},writeBytesField:function(e,i){this.writeTag(e,t.Bytes),this.writeBytes(i)},writeFixed32Field:function(e,i){this.writeTag(e,t.Fixed32),this.writeFixed32(i)},writeSFixed32Field:function(e,i){this.writeTag(e,t.Fixed32),this.writeSFixed32(i)},writeFixed64Field:function(e,i){this.writeTag(e,t.Fixed64),this.writeFixed64(i)},writeSFixed64Field:function(e,i){this.writeTag(e,t.Fixed64),this.writeSFixed64(i)},writeVarintField:function(e,i){this.writeTag(e,t.Varint),this.writeVarint(i)},writeSVarintField:function(e,i){this.writeTag(e,t.Varint),this.writeSVarint(i)},writeStringField:function(e,i){this.writeTag(e,t.Bytes),this.writeString(i)},writeFloatField:function(e,i){this.writeTag(e,t.Fixed32),this.writeFloat(i)},writeDoubleField:function(e,i){this.writeTag(e,t.Fixed64),this.writeDouble(i)},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e))}};var S=g;g.prototype={clone:function(){return new g(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,i=t.y-this.y;return e*e+i*i},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[0]*this.x+t[1]*this.y,i=t[2]*this.x+t[3]*this.y;return this.x=e,this.y=i,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),i=Math.sin(t),n=e*this.x-i*this.y,r=i*this.x+e*this.y;return this.x=n,this.y=r,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},g.convert=function(t){return t instanceof g?t:Array.isArray(t)?new g(t[0],t[1]):t};var E=S,I=_;_.types=["Unknown","Point","LineString","Polygon"],_.prototype.loadGeometry=function(){var t=this._pbf;t.pos=this._geometry;for(var e,i=t.readVarint()+t.pos,n=1,r=0,o=0,s=0,a=[];t.pos<i;){if(!r){var l=t.readVarint();n=7&l,r=l>>3}if(r--,1===n||2===n)o+=t.readSVarint(),s+=t.readSVarint(),1===n&&(e&&a.push(e),e=[]),e.push(new E(o,s));else{if(7!==n)throw new Error("unknown command "+n);e&&e.push(e[0].clone())}}return e&&a.push(e),a},_.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,i=1,n=0,r=0,o=0,s=1/0,a=-1/0,l=1/0,h=-1/0;t.pos<e;){if(!n){var c=t.readVarint();i=7&c,n=c>>3}if(n--,1===i||2===i)(r+=t.readSVarint())<s&&(s=r),r>a&&(a=r),(o+=t.readSVarint())<l&&(l=o),o>h&&(h=o);else if(7!==i)throw new Error("unknown command "+i)}return[s,l,a,h]},_.prototype.toGeoJSON=function(t,e,i){function n(t){for(var e=0;e<t.length;e++){var i=t[e],n=180-360*(i.y+l)/s;t[e]=[360*(i.x+a)/s-180,360/Math.PI*Math.atan(Math.exp(n*Math.PI/180))-90]}}var r,o,s=this.extent*Math.pow(2,i),a=this.extent*t,l=this.extent*e,h=this.loadGeometry(),c=_.types[this.type];switch(this.type){case 1:var u=[];for(r=0;r<h.length;r++)u[r]=h[r][0];n(h=u);break;case 2:for(r=0;r<h.length;r++)n(h[r]);break;case 3:for(h=function(t){var e=t.length;if(e<=1)return[t];for(var i,n,r=[],o=0;o<e;o++){var s=v(t[o]);0!==s&&(void 0===n&&(n=s<0),n===s<0?(i&&r.push(i),i=[t[o]]):i.push(t[o]))}return i&&r.push(i),r}(h),r=0;r<h.length;r++)for(o=0;o<h[r].length;o++)n(h[r][o])}1===h.length?h=h[0]:c="Multi"+c;var d={type:"Feature",geometry:{type:c,coordinates:h},properties:this.properties};return"id"in this&&(d.id=this.id),d};var T=I,D=b;b.prototype.feature=function(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];var e=this._pbf.readVarint()+this._pbf.pos;return new T(this._pbf,e,this.extent,this._keys,this._values)};var z=D,B=function(t,e){this.layers=t.readFields(w,{},e)};L.SVG.Tile=L.SVG.extend({initialize:function(t,e,i){L.SVG.prototype.initialize.call(this,i),this._tileCoord=t,this._size=e,this._initContainer(),this._container.setAttribute("width",this._size.x),this._container.setAttribute("height",this._size.y),this._container.setAttribute("viewBox",[0,0,this._size.x,this._size.y].join(" ")),this._layers={}},getCoord:function(){return this._tileCoord},getContainer:function(){return this._container},onAdd:L.Util.falseFn,addTo:function(t){if(this._map=t,this.options.interactive)for(var e in this._layers){var i=this._layers[e];i._path.style.pointerEvents="auto",this._map._targets[L.stamp(i._path)]=i}},removeFrom:function(t){if(this.options.interactive)for(var e in this._layers){var i=this._layers[e];delete this._map._targets[L.stamp(i._path)]}delete this._map},_initContainer:function(){L.SVG.prototype._initContainer.call(this),L.SVG.create("rect")},_addPath:function(t){this._rootGroup.appendChild(t._path),this._layers[L.stamp(t)]=t},_updateIcon:function(t){var e=t._path=L.SVG.create("image"),i=t.options.icon.options,n=L.point(i.iconSize),r=i.iconAnchor||n&&n.divideBy(2,!0),o=t._point.subtract(r);e.setAttribute("x",o.x),e.setAttribute("y",o.y),e.setAttribute("width",n.x+"px"),e.setAttribute("height",n.y+"px"),e.setAttribute("href",i.iconUrl)}}),L.svg.tile=function(t,e,i){return new L.SVG.Tile(t,e,i)};var O=L.Class.extend({render:function(t,e){this._renderer=t,this.options=e,t._initPath(this),t._updateStyle(this)},updateStyle:function(t,e){this.options=e,t._updateStyle(this)},_getPixelBounds:function(){for(var t=this._parts,e=L.bounds([]),i=0;i<t.length;i++)for(var n=t[i],r=0;r<n.length;r++)e.extend(n[r]);var o=this._clickTolerance(),s=new L.Point(o,o);return e.min._subtract(s),e.max._add(s),e},_clickTolerance:L.Path.prototype._clickTolerance}),R={_makeFeatureParts:function(t,e){var i,n=t.geometry;this._parts=[];for(var r=0;r<n.length;r++){for(var o=n[r],s=[],a=0;a<o.length;a++)i=o[a],s.push(L.point(i).scaleBy(e));this._parts.push(s)}},makeInteractive:function(){this._pxBounds=this._getPixelBounds()}},j=L.CircleMarker.extend({includes:O.prototype,statics:{iconCache:{}},initialize:function(t,e){this.properties=t.properties,this._makeFeatureParts(t,e)},render:function(t,e){O.prototype.render.call(this,t,e),this._radius=e.radius||L.CircleMarker.prototype.options.radius,this._updatePath()},_makeFeatureParts:function(t,e){var i=t.geometry[0];"object"==typeof i[0]&&"x"in i[0]?(this._point=L.point(i[0]).scaleBy(e),this._empty=L.Util.falseFn):(this._point=L.point(i).scaleBy(e),this._empty=L.Util.falseFn)},makeInteractive:function(){this._updateBounds()},updateStyle:function(t,e){return this._radius=e.radius||this._radius,this._updateBounds(),O.prototype.updateStyle.call(this,t,e)},_updateBounds:function(){var t=this.options.icon;if(t){var e=L.point(t.options.iconSize),i=t.options.iconAnchor||e&&e.divideBy(2,!0),n=this._point.subtract(i);this._pxBounds=new L.Bounds(n,n.add(t.options.iconSize))}else L.CircleMarker.prototype._updateBounds.call(this)},_updatePath:function(){this.options.icon?this._renderer._updateIcon(this):L.CircleMarker.prototype._updatePath.call(this)},_getImage:function(){if(this.options.icon){var t=this.options.icon.options.iconUrl,e=j.iconCache[t];if(!e){var i=this.options.icon;e=j.iconCache[t]=i.createIcon()}return e}return null},_containsPoint:function(t){return this.options.icon?this._pxBounds.contains(t):L.CircleMarker.prototype._containsPoint.call(this,t)}}),N=L.Polyline.extend({includes:[O.prototype,R],initialize:function(t,e){this.properties=t.properties,this._makeFeatureParts(t,e)},render:function(t,e){e.fill=!1,O.prototype.render.call(this,t,e),this._updatePath()},updateStyle:function(t,e){e.fill=!1,O.prototype.updateStyle.call(this,t,e)}}),F=L.Polygon.extend({includes:[O.prototype,R],initialize:function(t,e){this.properties=t.properties,this._makeFeatureParts(t,e)},render:function(t,e){O.prototype.render.call(this,t,e),this._updatePath()}});L.VectorGrid=L.GridLayer.extend({options:{rendererFactory:L.svg.tile,vectorTileLayerStyles:{},interactive:!1},initialize:function(t){L.setOptions(this,t),L.GridLayer.prototype.initialize.apply(this,arguments),this.options.getFeatureId&&(this._vectorTiles={},this._overriddenStyles={},this.on("tileunload",(function(t){var e=this._tileCoordsToKey(t.coords),i=this._vectorTiles[e];i&&this._map&&i.removeFrom(this._map),delete this._vectorTiles[e]}),this)),this._dataLayerNames={}},createTile:function(t,e){var i=this.options.getFeatureId,n=this.getTileSize(),r=this.options.rendererFactory(t,n,this.options),o=this._getVectorTilePromise(t);return i&&(this._vectorTiles[this._tileCoordsToKey(t)]=r,r._features={}),o.then(function(n){for(var o in n.layers){this._dataLayerNames[o]=!0;for(var s=n.layers[o],a=this.getTileSize().divideBy(s.extent),l=this.options.vectorTileLayerStyles[o]||L.Path.prototype.options,h=0;h<s.features.length;h++){var c,u=s.features[h],d=l;if(i){c=this.options.getFeatureId(u);var p=this._overriddenStyles[c];p&&(d=p[o]?p[o]:p)}if(d instanceof Function&&(d=d(u.properties,t.z)),d instanceof Array||(d=[d]),d.length){for(var f=this._createLayer(u,a),m=0;m<d.length;m++){var g=L.extend({},L.Path.prototype.options,d[m]);f.render(r,g),r._addPath(f)}this.options.interactive&&f.makeInteractive(),i&&(r._features[c]={layerName:o,feature:f})}}}null!=this._map&&r.addTo(this._map),L.Util.requestAnimFrame(e.bind(t,null,null))}.bind(this)),r.getContainer()},setFeatureStyle:function(t,e){for(var i in this._overriddenStyles[t]=e,this._vectorTiles){var n=this._vectorTiles[i],r=n._features[t];if(r){var o=r.feature,s=e;e[r.layerName]&&(s=e[r.layerName]),this._updateStyles(o,n,s)}}return this},resetFeatureStyle:function(t){for(var e in delete this._overriddenStyles[t],this._vectorTiles){var i=this._vectorTiles[e],n=i._features[t];if(n){var r=n.feature,o=this.options.vectorTileLayerStyles[n.layerName]||L.Path.prototype.options;this._updateStyles(r,i,o)}}return this},getDataLayerNames:function(){return Object.keys(this._dataLayerNames)},_updateStyles:function(t,e,i){(i=i instanceof Function?i(t.properties,e.getCoord().z):i)instanceof Array||(i=[i]);for(var n=0;n<i.length;n++){var r=L.extend({},L.Path.prototype.options,i[n]);t.updateStyle(e,r)}},_createLayer:function(t,e,i){var n;switch(t.type){case 1:n=new j(t,e);break;case 2:n=new N(t,e);break;case 3:n=new F(t,e)}return this.options.interactive&&n.addEventParent(this),n}}),L.vectorGrid=function(t){return new L.VectorGrid(t)},L.VectorGrid.Protobuf=L.VectorGrid.extend({options:{subdomains:"abc",fetchOptions:{}},initialize:function(t,e){this._url=t,L.VectorGrid.prototype.initialize.call(this,e)},setUrl:function(t,e){return this._url=t,e||this.redraw(),this},_getSubdomain:L.TileLayer.prototype._getSubdomain,_getVectorTilePromise:function(t){var e={s:this._getSubdomain(t),x:t.x,y:t.y,z:t.z};if(this._map&&!this._map.options.crs.infinite){var i=this._globalTileRange.max.y-t.y;this.options.tms&&(e.y=i),e["-y"]=i}var n=L.Util.template(this._url,L.extend(e,this.options));return fetch(n,this.options.fetchOptions).then((function(t){return t.ok?t.blob().then((function(t){var e=new FileReader;return new Promise((function(i){e.addEventListener("loadend",(function(){var t=new M(e.result);return i(new B(t))})),e.readAsArrayBuffer(t)}))})):{layers:[]}})).then((function(t){for(var e in t.layers){for(var i=[],n=0;n<t.layers[e].length;n++){var r=t.layers[e].feature(n);r.geometry=r.loadGeometry(),i.push(r)}t.layers[e].features=i}return t}))}}),L.vectorGrid.protobuf=function(t,e){return new L.VectorGrid.Protobuf(t,e)};var G=function(t,e,i){try{return window.URL.createObjectURL(new Blob([Uint8Array.from(t.split("").map((function(t){return t.charCodeAt(0)})))],{type:e}))}catch(i){return"data:"+e+","+t}}('"use strict";function simplify$1(e,t){var r,n,o,i,a=t*t,s=e.length,l=0,u=s-1,c=[];for(e[l][2]=1,e[u][2]=1;u;){for(n=0,r=l+1;r<u;r++)(o=getSqSegDist(e[r],e[l],e[u]))>n&&(i=r,n=o);n>a?(e[i][2]=n,c.push(l),c.push(i),l=i):(u=c.pop(),l=c.pop())}}function getSqSegDist(e,t,r){var n=t[0],o=t[1],i=r[0],a=r[1],s=e[0],l=e[1],u=i-n,c=a-o;if(0!==u||0!==c){var f=((s-n)*u+(l-o)*c)/(u*u+c*c);f>1?(n=i,o=a):f>0&&(n+=u*f,o+=c*f)}return u=s-n,c=l-o,u*u+c*c}function convert$1(e,t){var r=[];if("FeatureCollection"===e.type)for(var n=0;n<e.features.length;n++)convertFeature(r,e.features[n],t);else"Feature"===e.type?convertFeature(r,e,t):convertFeature(r,{geometry:e},t);return r}function convertFeature(e,t,r){if(null!==t.geometry){var n,o,i,a,s=t.geometry,l=s.type,u=s.coordinates,c=t.properties;if("Point"===l)e.push(create(c,1,[projectPoint(u)]));else if("MultiPoint"===l)e.push(create(c,1,project(u)));else if("LineString"===l)e.push(create(c,2,[project(u,r)]));else if("MultiLineString"===l||"Polygon"===l){for(i=[],n=0;n<u.length;n++)a=project(u[n],r),"Polygon"===l&&(a.outer=0===n),i.push(a);e.push(create(c,"Polygon"===l?3:2,i))}else if("MultiPolygon"===l){for(i=[],n=0;n<u.length;n++)for(o=0;o<u[n].length;o++)a=project(u[n][o],r),a.outer=0===o,i.push(a);e.push(create(c,3,i))}else{if("GeometryCollection"!==l)throw new Error("Input data is not a valid GeoJSON object.");for(n=0;n<s.geometries.length;n++)convertFeature(e,{geometry:s.geometries[n],properties:c},r)}}}function create(e,t,r){var n={geometry:r,type:t,tags:e||null,min:[2,1],max:[-1,0]};return calcBBox(n),n}function project(e,t){for(var r=[],n=0;n<e.length;n++)r.push(projectPoint(e[n]));return t&&(simplify(r,t),calcSize(r)),r}function projectPoint(e){var t=Math.sin(e[1]*Math.PI/180),r=e[0]/360+.5,n=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return n=n<0?0:n>1?1:n,[r,n,0]}function calcSize(e){for(var t,r,n=0,o=0,i=0;i<e.length-1;i++)t=r||e[i],r=e[i+1],n+=t[0]*r[1]-r[0]*t[1],o+=Math.abs(r[0]-t[0])+Math.abs(r[1]-t[1]);e.area=Math.abs(n/2),e.dist=o}function calcBBox(e){var t=e.geometry,r=e.min,n=e.max;if(1===e.type)calcRingBBox(r,n,t);else for(var o=0;o<t.length;o++)calcRingBBox(r,n,t[o]);return e}function calcRingBBox(e,t,r){for(var n,o=0;o<r.length;o++)n=r[o],e[0]=Math.min(n[0],e[0]),t[0]=Math.max(n[0],t[0]),e[1]=Math.min(n[1],e[1]),t[1]=Math.max(n[1],t[1])}function transformTile(e,t){if(e.transformed)return e;var r,n,o,i=e.z2,a=e.x,s=e.y;for(r=0;r<e.features.length;r++){var l=e.features[r],u=l.geometry;if(1===l.type)for(n=0;n<u.length;n++)u[n]=transformPoint(u[n],t,i,a,s);else for(n=0;n<u.length;n++){var c=u[n];for(o=0;o<c.length;o++)c[o]=transformPoint(c[o],t,i,a,s)}}return e.transformed=!0,e}function transformPoint(e,t,r,n,o){return[Math.round(t*(e[0]*r-n)),Math.round(t*(e[1]*r-o))]}function clip$1(e,t,r,n,o,i,a,s){if(r/=t,n/=t,a>=r&&s<=n)return e;if(a>n||s<r)return null;for(var l=[],u=0;u<e.length;u++){var c,f,p=e[u],h=p.geometry,m=p.type;if(c=p.min[o],f=p.max[o],c>=r&&f<=n)l.push(p);else if(!(c>n||f<r)){var g=1===m?clipPoints(h,r,n,o):clipGeometry(h,r,n,o,i,3===m);g.length&&l.push({geometry:g,type:m,tags:e[u].tags||null,min:p.min,max:p.max})}}return l.length?l:null}function clipPoints(e,t,r,n){for(var o=[],i=0;i<e.length;i++){var a=e[i],s=a[n];s>=t&&s<=r&&o.push(a)}return o}function clipGeometry(e,t,r,n,o,i){for(var a=[],s=0;s<e.length;s++){var l,u,c,f=0,p=0,h=null,m=e[s],g=m.area,d=m.dist,v=m.outer,y=m.length,x=[];for(u=0;u<y-1;u++)l=h||m[u],h=m[u+1],f=p||l[n],p=h[n],f<t?p>r?(x.push(o(l,h,t),o(l,h,r)),i||(x=newSlice(a,x,g,d,v))):p>=t&&x.push(o(l,h,t)):f>r?p<t?(x.push(o(l,h,r),o(l,h,t)),i||(x=newSlice(a,x,g,d,v))):p<=r&&x.push(o(l,h,r)):(x.push(l),p<t?(x.push(o(l,h,t)),i||(x=newSlice(a,x,g,d,v))):p>r&&(x.push(o(l,h,r)),i||(x=newSlice(a,x,g,d,v))));l=m[y-1],f=l[n],f>=t&&f<=r&&x.push(l),c=x[x.length-1],i&&c&&(x[0][0]!==c[0]||x[0][1]!==c[1])&&x.push(x[0]),newSlice(a,x,g,d,v)}return a}function newSlice(e,t,r,n,o){return t.length&&(t.area=r,t.dist=n,void 0!==o&&(t.outer=o),e.push(t)),[]}function wrap$1(e,t,r){var n=e,o=clip$2(e,1,-1-t,t,0,r,-1,2),i=clip$2(e,1,1-t,2+t,0,r,-1,2);return(o||i)&&(n=clip$2(e,1,-t,1+t,0,r,-1,2),o&&(n=shiftFeatureCoords(o,1).concat(n)),i&&(n=n.concat(shiftFeatureCoords(i,-1)))),n}function shiftFeatureCoords(e,t){for(var r=[],n=0;n<e.length;n++){var o,i=e[n],a=i.type;if(1===a)o=shiftCoords(i.geometry,t);else{o=[];for(var s=0;s<i.geometry.length;s++)o.push(shiftCoords(i.geometry[s],t))}r.push({geometry:o,type:a,tags:i.tags,min:[i.min[0]+t,i.min[1]],max:[i.max[0]+t,i.max[1]]})}return r}function shiftCoords(e,t){var r=[];r.area=e.area,r.dist=e.dist;for(var n=0;n<e.length;n++)r.push([e[n][0]+t,e[n][1],e[n][2]]);return r}function createTile$1(e,t,r,n,o,i){for(var a={features:[],numPoints:0,numSimplified:0,numFeatures:0,source:null,x:r,y:n,z2:t,transformed:!1,min:[2,1],max:[-1,0]},s=0;s<e.length;s++){a.numFeatures++,addFeature(a,e[s],o,i);var l=e[s].min,u=e[s].max;l[0]<a.min[0]&&(a.min[0]=l[0]),l[1]<a.min[1]&&(a.min[1]=l[1]),u[0]>a.max[0]&&(a.max[0]=u[0]),u[1]>a.max[1]&&(a.max[1]=u[1])}return a}function addFeature(e,t,r,n){var o,i,a,s,l=t.geometry,u=t.type,c=[],f=r*r;if(1===u)for(o=0;o<l.length;o++)c.push(l[o]),e.numPoints++,e.numSimplified++;else for(o=0;o<l.length;o++)if(a=l[o],n||!(2===u&&a.dist<r||3===u&&a.area<f)){var p=[];for(i=0;i<a.length;i++)s=a[i],(n||s[2]>f)&&(p.push(s),e.numSimplified++),e.numPoints++;3===u&&rewind(p,a.outer),c.push(p)}else e.numPoints+=a.length;c.length&&e.features.push({geometry:c,type:u,tags:t.tags||null})}function rewind(e,t){signedArea(e)<0===t&&e.reverse()}function signedArea(e){for(var t,r,n=0,o=0,i=e.length,a=i-1;o<i;a=o++)t=e[o],r=e[a],n+=(r[0]-t[0])*(t[1]+r[1]);return n}function geojsonvt(e,t){return new GeoJSONVT(e,t)}function GeoJSONVT(e,t){t=this.options=extend(Object.create(this.options),t);var r=t.debug;r&&console.time("preprocess data");var n=1<<t.maxZoom,o=convert(e,t.tolerance/(n*t.extent));this.tiles={},this.tileCoords=[],r&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),o=wrap(o,t.buffer/t.extent,intersectX),o.length&&this.splitTile(o,0,0,0),r&&(o.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)))}function toID(e,t,r){return 32*((1<<e)*r+t)+e}function intersectX(e,t,r){return[r,(r-e[0])*(t[1]-e[1])/(t[0]-e[0])+e[1],1]}function intersectY(e,t,r){return[(r-e[1])*(t[0]-e[0])/(t[1]-e[1])+e[0],r,1]}function extend(e,t){for(var r in t)e[r]=t[r];return e}function isClippedSquare(e,t,r){var n=e.source;if(1!==n.length)return!1;var o=n[0];if(3!==o.type||o.geometry.length>1)return!1;var i=o.geometry[0].length;if(5!==i)return!1;for(var a=0;a<i;a++){var s=transform.point(o.geometry[0][a],t,e.z2,e.x,e.y);if(s[0]!==-r&&s[0]!==t+r||s[1]!==-r&&s[1]!==t+r)return!1}return!0}function feature$1(e,t){var r=t.id,n=t.bbox,o=null==t.properties?{}:t.properties,i=object(e,t);return null==r&&null==n?{type:"Feature",properties:o,geometry:i}:null==n?{type:"Feature",id:r,properties:o,geometry:i}:{type:"Feature",id:r,bbox:n,properties:o,geometry:i}}function object(e,t){function r(e,t){t.length&&t.pop();for(var r=u[e<0?~e:e],n=0,o=r.length;n<o;++n)t.push(l(r[n].slice(),n));e<0&&reverse(t,o)}function n(e){return l(e.slice())}function o(e){for(var t=[],n=0,o=e.length;n<o;++n)r(e[n],t);return t.length<2&&t.push(t[0].slice()),t}function i(e){for(var t=o(e);t.length<4;)t.push(t[0].slice());return t}function a(e){return e.map(i)}function s(e){var t,r=e.type;switch(r){case"GeometryCollection":return{type:r,geometries:e.geometries.map(s)};case"Point":t=n(e.coordinates);break;case"MultiPoint":t=e.coordinates.map(n);break;case"LineString":t=o(e.arcs);break;case"MultiLineString":t=e.arcs.map(o);break;case"Polygon":t=a(e.arcs);break;case"MultiPolygon":t=e.arcs.map(a);break;default:return null}return{type:r,coordinates:t}}var l=transform$3(e),u=e.arcs;return s(t)}function extractArcs(e,t,r){function n(e){var t=e<0?~e:e;(c[t]||(c[t]=[])).push({i:e,g:l})}function o(e){e.forEach(n)}function i(e){e.forEach(o)}function a(e){e.forEach(i)}function s(e){switch(l=e,e.type){case"GeometryCollection":e.geometries.forEach(s);break;case"LineString":o(e.arcs);break;case"MultiLineString":case"Polygon":i(e.arcs);break;case"MultiPolygon":a(e.arcs)}}var l,u=[],c=[];return s(t),c.forEach(null==r?function(e){u.push(e[0].i)}:function(e){r(e[0].g,e[e.length-1].g)&&u.push(e[0].i)}),u}function planarRingArea(e){for(var t,r=-1,n=e.length,o=e[n-1],i=0;++r<n;)t=o,o=e[r],i+=t[0]*o[1]-t[1]*o[0];return Math.abs(i)}var simplify_1=simplify$1,convert_1=convert$1,simplify=simplify_1,tile=transformTile,point=transformPoint,transform$1={tile:tile,point:point},clip_1=clip$1,clip$2=clip_1,wrap_1=wrap$1,tile$1=createTile$1,index=geojsonvt,convert=convert_1,transform=transform$1,clip=clip_1,wrap=wrap_1,createTile=tile$1;GeoJSONVT.prototype.options={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,solidChildren:!1,tolerance:3,extent:4096,buffer:64,debug:0},GeoJSONVT.prototype.splitTile=function(e,t,r,n,o,i,a){for(var s=this,l=[e,t,r,n],u=this.options,c=u.debug,f=null;l.length;){n=l.pop(),r=l.pop(),t=l.pop(),e=l.pop();var p=1<<t,h=toID(t,r,n),m=s.tiles[h],g=t===u.maxZoom?0:u.tolerance/(p*u.extent);if(!m&&(c>1&&console.time("creation"),m=s.tiles[h]=createTile(e,p,r,n,g,t===u.maxZoom),s.tileCoords.push({z:t,x:r,y:n}),c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,r,n,m.numFeatures,m.numPoints,m.numSimplified),console.timeEnd("creation"));var d="z"+t;s.stats[d]=(s.stats[d]||0)+1,s.total++}if(m.source=e,o){if(t===u.maxZoom||t===o)continue;var v=1<<o-t;if(r!==Math.floor(i/v)||n!==Math.floor(a/v))continue}else if(t===u.indexMaxZoom||m.numPoints<=u.indexMaxPoints)continue;if(u.solidChildren||!isClippedSquare(m,u.extent,u.buffer)){m.source=null,c>1&&console.time("clipping");var y,x,b,M,P,S,w=.5*u.buffer/u.extent,$=.5-w,C=.5+w,F=1+w;y=x=b=M=null,P=clip(e,p,r-w,r+C,0,intersectX,m.min[0],m.max[0]),S=clip(e,p,r+$,r+F,0,intersectX,m.min[0],m.max[0]),P&&(y=clip(P,p,n-w,n+C,1,intersectY,m.min[1],m.max[1]),x=clip(P,p,n+$,n+F,1,intersectY,m.min[1],m.max[1])),S&&(b=clip(S,p,n-w,n+C,1,intersectY,m.min[1],m.max[1]),M=clip(S,p,n+$,n+F,1,intersectY,m.min[1],m.max[1])),c>1&&console.timeEnd("clipping"),y&&l.push(y,t+1,2*r,2*n),x&&l.push(x,t+1,2*r,2*n+1),b&&l.push(b,t+1,2*r+1,2*n),M&&l.push(M,t+1,2*r+1,2*n+1)}else o&&(f=t)}return f},GeoJSONVT.prototype.getTile=function(e,t,r){var n=this,o=this.options,i=o.extent,a=o.debug,s=1<<e;t=(t%s+s)%s;var l=toID(e,t,r);if(this.tiles[l])return transform.tile(this.tiles[l],i);a>1&&console.log("drilling down to z%d-%d-%d",e,t,r);for(var u,c=e,f=t,p=r;!u&&c>0;)c--,f=Math.floor(f/2),p=Math.floor(p/2),u=n.tiles[toID(c,f,p)];if(!u||!u.source)return null;if(a>1&&console.log("found parent tile z%d-%d-%d",c,f,p),isClippedSquare(u,i,o.buffer))return transform.tile(u,i);a>1&&console.time("drilling down");var h=this.splitTile(u.source,c,f,p,e,t,r);if(a>1&&console.timeEnd("drilling down"),null!==h){var m=1<<e-h;l=toID(h,Math.floor(t/m),Math.floor(r/m))}return this.tiles[l]?transform.tile(this.tiles[l],i):null};var identity=function(e){return e},transform$3=function(e){if(null==(t=e.transform))return identity;var t,r,n,o=t.scale[0],i=t.scale[1],a=t.translate[0],s=t.translate[1];return function(e,t){return t||(r=n=0),e[0]=(r+=e[0])*o+a,e[1]=(n+=e[1])*i+s,e}},bbox=function(e){function t(e){s[0]=e[0],s[1]=e[1],a(s),s[0]<l&&(l=s[0]),s[0]>c&&(c=s[0]),s[1]<u&&(u=s[1]),s[1]>f&&(f=s[1])}function r(e){switch(e.type){case"GeometryCollection":e.geometries.forEach(r);break;case"Point":t(e.coordinates);break;case"MultiPoint":e.coordinates.forEach(t)}}var n=e.bbox;if(!n){var o,i,a=transform$3(e),s=new Array(2),l=1/0,u=l,c=-l,f=-l;e.arcs.forEach(function(e){for(var t=-1,r=e.length;++t<r;)o=e[t],s[0]=o[0],s[1]=o[1],a(s,t),s[0]<l&&(l=s[0]),s[0]>c&&(c=s[0]),s[1]<u&&(u=s[1]),s[1]>f&&(f=s[1])});for(i in e.objects)r(e.objects[i]);n=e.bbox=[l,u,c,f]}return n},reverse=function(e,t){for(var r,n=e.length,o=n-t;o<--n;)r=e[o],e[o++]=e[n],e[n]=r},feature=function(e,t){return"GeometryCollection"===t.type?{type:"FeatureCollection",features:t.geometries.map(function(t){return feature$1(e,t)})}:feature$1(e,t)},stitch=function(e,t){function r(t){var r,n=e.arcs[t<0?~t:t],o=n[0];return e.transform?(r=[0,0],n.forEach(function(e){r[0]+=e[0],r[1]+=e[1]})):r=n[n.length-1],t<0?[r,o]:[o,r]}function n(e,t){for(var r in e){var n=e[r];delete t[n.start],delete n.start,delete n.end,n.forEach(function(e){o[e<0?~e:e]=1}),s.push(n)}}var o={},i={},a={},s=[],l=-1;return t.forEach(function(r,n){var o,i=e.arcs[r<0?~r:r];i.length<3&&!i[1][0]&&!i[1][1]&&(o=t[++l],t[l]=r,t[n]=o)}),t.forEach(function(e){var t,n,o=r(e),s=o[0],l=o[1];if(t=a[s])if(delete a[t.end],t.push(e),t.end=l,n=i[l]){delete i[n.start];var u=n===t?t:t.concat(n);i[u.start=t.start]=a[u.end=n.end]=u}else i[t.start]=a[t.end]=t;else if(t=i[l])if(delete i[t.start],t.unshift(e),t.start=s,n=a[s]){delete a[n.end];var c=n===t?t:n.concat(t);i[c.start=n.start]=a[c.end=t.end]=c}else i[t.start]=a[t.end]=t;else t=[e],i[t.start=s]=a[t.end=l]=t}),n(a,i),n(i,a),t.forEach(function(e){o[e<0?~e:e]||s.push([e])}),s},bisect=function(e,t){for(var r=0,n=e.length;r<n;){var o=r+n>>>1;e[o]<t?r=o+1:n=o}return r},slicers={},options;onmessage=function(e){if("slice"===e.data[0]){var t=e.data[1];if(options=e.data[2],t.type&&"Topology"===t.type)for(var r in t.objects)slicers[r]=index(feature(t,t.objects[r]),options);else slicers[options.vectorTileLayerName]=index(t,options)}else if("get"===e.data[0]){var n=e.data[1],o={};for(var r in slicers){var i=slicers[r].getTile(n.z,n.x,n.y);if(i){var a={features:[],extent:options.extent,name:options.vectorTileLayerName,length:i.features.length};for(var s in i.features){var l={geometry:i.features[s].geometry,properties:i.features[s].tags,type:i.features[s].type};a.features.push(l)}o[r]=a}}postMessage({layers:o,coords:n})}};\n',"text/plain; charset=us-ascii");L.VectorGrid.Slicer=L.VectorGrid.extend({options:{vectorTileLayerName:"sliced",extent:4096,maxZoom:14},initialize:function(t,e){for(var i in L.VectorGrid.prototype.initialize.call(this,e),e={},this.options)"rendererFactory"!==i&&"vectorTileLayerStyles"!==i&&"function"!=typeof this.options[i]&&(e[i]=this.options[i]);this._worker=new Worker(G),this._worker.postMessage(["slice",t,e])},_getVectorTilePromise:function(t){var e=this,i=new Promise((function(i){e._worker.addEventListener("message",(function n(r){r.data.coords&&r.data.coords.x===t.x&&r.data.coords.y===t.y&&r.data.coords.z===t.z&&(i(r.data),e._worker.removeEventListener("message",n))}))}));return this._worker.postMessage(["get",t]),i}}),L.vectorGrid.slicer=function(t,e){return new L.VectorGrid.Slicer(t,e)},L.Canvas.Tile=L.Canvas.extend({initialize:function(t,e,i){L.Canvas.prototype.initialize.call(this,i),this._tileCoord=t,this._size=e,this._initContainer(),this._container.setAttribute("width",this._size.x),this._container.setAttribute("height",this._size.y),this._layers={},this._drawnLayers={},this._drawing=!0,i.interactive&&(this._container.style.pointerEvents="auto")},getCoord:function(){return this._tileCoord},getContainer:function(){return this._container},getOffset:function(){return this._tileCoord.scaleBy(this._size).subtract(this._map.getPixelOrigin())},onAdd:L.Util.falseFn,addTo:function(t){this._map=t},removeFrom:function(t){delete this._map},_onClick:function(t){var e,i,n=this._map.mouseEventToLayerPoint(t).subtract(this.getOffset());for(var r in this._layers)(e=this._layers[r]).options.interactive&&e._containsPoint(n)&&!this._map._draggableMoved(e)&&(i=e);i&&(L.DomEvent.fakeStop(t),this._fireEvent([i],t))},_onMouseMove:function(t){if(this._map&&!this._map.dragging.moving()&&!this._map._animatingZoom){var e=this._map.mouseEventToLayerPoint(t).subtract(this.getOffset());this._handleMouseHover(t,e)}},_updateIcon:function(t){if(this._drawing){var e=t.options.icon.options,i=L.point(e.iconSize),n=e.iconAnchor||i&&i.divideBy(2,!0),r=t._point.subtract(n),o=this._ctx,s=t._getImage();s.complete?o.drawImage(s,r.x,r.y,i.x,i.y):L.DomEvent.on(s,"load",(function(){o.drawImage(s,r.x,r.y,i.x,i.y)})),this._drawnLayers[t._leaflet_id]=t}}}),L.canvas.tile=function(t,e,i){return new L.Canvas.Tile(t,e,i)}},4067:function(t,e){!function(t){"use strict";function e(t){var e,i,n,r;for(i=1,n=arguments.length;i<n;i++)for(e in r=arguments[i])t[e]=r[e];return t}var i=Object.create||function(){function t(){}return function(e){return t.prototype=e,new t}}();function n(t,e){var i=Array.prototype.slice;if(t.bind)return t.bind.apply(t,i.call(arguments,1));var n=i.call(arguments,2);return function(){return t.apply(e,n.length?n.concat(i.call(arguments)):arguments)}}var r=0;function o(t){return"_leaflet_id"in t||(t._leaflet_id=++r),t._leaflet_id}function s(t,e,i){var n,r,o,s;return s=function(){n=!1,r&&(o.apply(i,r),r=!1)},o=function(){n?r=arguments:(t.apply(i,arguments),setTimeout(s,e),n=!0)},o}function a(t,e,i){var n=e[1],r=e[0],o=n-r;return t===n&&i?t:((t-r)%o+o)%o+r}function l(){return!1}function h(t,e){if(!1===e)return t;var i=Math.pow(10,void 0===e?6:e);return Math.round(t*i)/i}function c(t){return t.trim?t.trim():t.replace(/^\s+|\s+$/g,"")}function u(t){return c(t).split(/\s+/)}function d(t,e){for(var n in Object.prototype.hasOwnProperty.call(t,"options")||(t.options=t.options?i(t.options):{}),e)t.options[n]=e[n];return t.options}function p(t,e,i){var n=[];for(var r in t)n.push(encodeURIComponent(i?r.toUpperCase():r)+"="+encodeURIComponent(t[r]));return(e&&-1!==e.indexOf("?")?"&":"?")+n.join("&")}var f=/\{ *([\w_ -]+) *\}/g;function m(t,e){return t.replace(f,(function(t,i){var n=e[i];if(void 0===n)throw new Error("No value provided for variable "+t);return"function"==typeof n&&(n=n(e)),n}))}var g=Array.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)};function _(t,e){for(var i=0;i<t.length;i++)if(t[i]===e)return i;return-1}var y="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=";function v(t){return window["webkit"+t]||window["moz"+t]||window["ms"+t]}var b=0;function x(t){var e=+new Date,i=Math.max(0,16-(e-b));return b=e+i,window.setTimeout(t,i)}var w=window.requestAnimationFrame||v("RequestAnimationFrame")||x,M=window.cancelAnimationFrame||v("CancelAnimationFrame")||v("CancelRequestAnimationFrame")||function(t){window.clearTimeout(t)};function k(t,e,i){if(!i||w!==x)return w.call(window,n(t,e));t.call(e)}function C(t){t&&M.call(window,t)}var A={__proto__:null,extend:e,create:i,bind:n,get lastId(){return r},stamp:o,throttle:s,wrapNum:a,falseFn:l,formatNum:h,trim:c,splitWords:u,setOptions:d,getParamString:p,template:m,isArray:g,indexOf:_,emptyImageUrl:y,requestFn:w,cancelFn:M,requestAnimFrame:k,cancelAnimFrame:C};function P(){}P.extend=function(t){var n=function(){d(this),this.initialize&&this.initialize.apply(this,arguments),this.callInitHooks()},r=n.__super__=this.prototype,o=i(r);for(var s in o.constructor=n,n.prototype=o,this)Object.prototype.hasOwnProperty.call(this,s)&&"prototype"!==s&&"__super__"!==s&&(n[s]=this[s]);return t.statics&&e(n,t.statics),t.includes&&(function(t){if("undefined"!=typeof L&&L&&L.Mixin){t=g(t)?t:[t];for(var e=0;e<t.length;e++)t[e]===L.Mixin.Events&&console.warn("Deprecated include of L.Mixin.Events: this property will be removed in future releases, please inherit from L.Evented instead.",(new Error).stack)}}(t.includes),e.apply(null,[o].concat(t.includes))),e(o,t),delete o.statics,delete o.includes,o.options&&(o.options=r.options?i(r.options):{},e(o.options,t.options)),o._initHooks=[],o.callInitHooks=function(){if(!this._initHooksCalled){r.callInitHooks&&r.callInitHooks.call(this),this._initHooksCalled=!0;for(var t=0,e=o._initHooks.length;t<e;t++)o._initHooks[t].call(this)}},n},P.include=function(t){var i=this.prototype.options;return e(this.prototype,t),t.options&&(this.prototype.options=i,this.mergeOptions(t.options)),this},P.mergeOptions=function(t){return e(this.prototype.options,t),this},P.addInitHook=function(t){var e=Array.prototype.slice.call(arguments,1),i="function"==typeof t?t:function(){this[t].apply(this,e)};return this.prototype._initHooks=this.prototype._initHooks||[],this.prototype._initHooks.push(i),this};var S={on:function(t,e,i){if("object"==typeof t)for(var n in t)this._on(n,t[n],e);else for(var r=0,o=(t=u(t)).length;r<o;r++)this._on(t[r],e,i);return this},off:function(t,e,i){if(arguments.length)if("object"==typeof t)for(var n in t)this._off(n,t[n],e);else{t=u(t);for(var r=1===arguments.length,o=0,s=t.length;o<s;o++)r?this._off(t[o]):this._off(t[o],e,i)}else delete this._events;return this},_on:function(t,e,i,n){if("function"==typeof e){if(!1===this._listens(t,e,i)){i===this&&(i=void 0);var r={fn:e,ctx:i};n&&(r.once=!0),this._events=this._events||{},this._events[t]=this._events[t]||[],this._events[t].push(r)}}else console.warn("wrong listener type: "+typeof e)},_off:function(t,e,i){var n,r,o;if(this._events&&(n=this._events[t]))if(1!==arguments.length)if("function"==typeof e){var s=this._listens(t,e,i);if(!1!==s){var a=n[s];this._firingCount&&(a.fn=l,this._events[t]=n=n.slice()),n.splice(s,1)}}else console.warn("wrong listener type: "+typeof e);else{if(this._firingCount)for(r=0,o=n.length;r<o;r++)n[r].fn=l;delete this._events[t]}},fire:function(t,i,n){if(!this.listens(t,n))return this;var r=e({},i,{type:t,target:this,sourceTarget:i&&i.sourceTarget||this});if(this._events){var o=this._events[t];if(o){this._firingCount=this._firingCount+1||1;for(var s=0,a=o.length;s<a;s++){var l=o[s],h=l.fn;l.once&&this.off(t,h,l.ctx),h.call(l.ctx||this,r)}this._firingCount--}}return n&&this._propagateEvent(r),this},listens:function(t,e,i,n){"string"!=typeof t&&console.warn('"string" type argument expected');var r=e;"function"!=typeof e&&(n=!!e,r=void 0,i=void 0);var o=this._events&&this._events[t];if(o&&o.length&&!1!==this._listens(t,r,i))return!0;if(n)for(var s in this._eventParents)if(this._eventParents[s].listens(t,e,i,n))return!0;return!1},_listens:function(t,e,i){if(!this._events)return!1;var n=this._events[t]||[];if(!e)return!!n.length;i===this&&(i=void 0);for(var r=0,o=n.length;r<o;r++)if(n[r].fn===e&&n[r].ctx===i)return r;return!1},once:function(t,e,i){if("object"==typeof t)for(var n in t)this._on(n,t[n],e,!0);else for(var r=0,o=(t=u(t)).length;r<o;r++)this._on(t[r],e,i,!0);return this},addEventParent:function(t){return this._eventParents=this._eventParents||{},this._eventParents[o(t)]=t,this},removeEventParent:function(t){return this._eventParents&&delete this._eventParents[o(t)],this},_propagateEvent:function(t){for(var i in this._eventParents)this._eventParents[i].fire(t.type,e({layer:t.target,propagatedFrom:t.target},t),!0)}};S.addEventListener=S.on,S.removeEventListener=S.clearAllEventListeners=S.off,S.addOneTimeEventListener=S.once,S.fireEvent=S.fire,S.hasEventListeners=S.listens;var E=P.extend(S);function I(t,e,i){this.x=i?Math.round(t):t,this.y=i?Math.round(e):e}var T=Math.trunc||function(t){return t>0?Math.floor(t):Math.ceil(t)};function D(t,e,i){return t instanceof I?t:g(t)?new I(t[0],t[1]):null==t?t:"object"==typeof t&&"x"in t&&"y"in t?new I(t.x,t.y):new I(t,e,i)}function z(t,e){if(t)for(var i=e?[t,e]:t,n=0,r=i.length;n<r;n++)this.extend(i[n])}function B(t,e){return!t||t instanceof z?t:new z(t,e)}function O(t,e){if(t)for(var i=e?[t,e]:t,n=0,r=i.length;n<r;n++)this.extend(i[n])}function R(t,e){return t instanceof O?t:new O(t,e)}function j(t,e,i){if(isNaN(t)||isNaN(e))throw new Error("Invalid LatLng object: ("+t+", "+e+")");this.lat=+t,this.lng=+e,void 0!==i&&(this.alt=+i)}function N(t,e,i){return t instanceof j?t:g(t)&&"object"!=typeof t[0]?3===t.length?new j(t[0],t[1],t[2]):2===t.length?new j(t[0],t[1]):null:null==t?t:"object"==typeof t&&"lat"in t?new j(t.lat,"lng"in t?t.lng:t.lon,t.alt):void 0===e?null:new j(t,e,i)}I.prototype={clone:function(){return new I(this.x,this.y)},add:function(t){return this.clone()._add(D(t))},_add:function(t){return this.x+=t.x,this.y+=t.y,this},subtract:function(t){return this.clone()._subtract(D(t))},_subtract:function(t){return this.x-=t.x,this.y-=t.y,this},divideBy:function(t){return this.clone()._divideBy(t)},_divideBy:function(t){return this.x/=t,this.y/=t,this},multiplyBy:function(t){return this.clone()._multiplyBy(t)},_multiplyBy:function(t){return this.x*=t,this.y*=t,this},scaleBy:function(t){return new I(this.x*t.x,this.y*t.y)},unscaleBy:function(t){return new I(this.x/t.x,this.y/t.y)},round:function(){return this.clone()._round()},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},floor:function(){return this.clone()._floor()},_floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this},ceil:function(){return this.clone()._ceil()},_ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this},trunc:function(){return this.clone()._trunc()},_trunc:function(){return this.x=T(this.x),this.y=T(this.y),this},distanceTo:function(t){var e=(t=D(t)).x-this.x,i=t.y-this.y;return Math.sqrt(e*e+i*i)},equals:function(t){return(t=D(t)).x===this.x&&t.y===this.y},contains:function(t){return t=D(t),Math.abs(t.x)<=Math.abs(this.x)&&Math.abs(t.y)<=Math.abs(this.y)},toString:function(){return"Point("+h(this.x)+", "+h(this.y)+")"}},z.prototype={extend:function(t){var e,i;if(!t)return this;if(t instanceof I||"number"==typeof t[0]||"x"in t)e=i=D(t);else if(e=(t=B(t)).min,i=t.max,!e||!i)return this;return this.min||this.max?(this.min.x=Math.min(e.x,this.min.x),this.max.x=Math.max(i.x,this.max.x),this.min.y=Math.min(e.y,this.min.y),this.max.y=Math.max(i.y,this.max.y)):(this.min=e.clone(),this.max=i.clone()),this},getCenter:function(t){return D((this.min.x+this.max.x)/2,(this.min.y+this.max.y)/2,t)},getBottomLeft:function(){return D(this.min.x,this.max.y)},getTopRight:function(){return D(this.max.x,this.min.y)},getTopLeft:function(){return this.min},getBottomRight:function(){return this.max},getSize:function(){return this.max.subtract(this.min)},contains:function(t){var e,i;return(t="number"==typeof t[0]||t instanceof I?D(t):B(t))instanceof z?(e=t.min,i=t.max):e=i=t,e.x>=this.min.x&&i.x<=this.max.x&&e.y>=this.min.y&&i.y<=this.max.y},intersects:function(t){t=B(t);var e=this.min,i=this.max,n=t.min,r=t.max,o=r.x>=e.x&&n.x<=i.x,s=r.y>=e.y&&n.y<=i.y;return o&&s},overlaps:function(t){t=B(t);var e=this.min,i=this.max,n=t.min,r=t.max,o=r.x>e.x&&n.x<i.x,s=r.y>e.y&&n.y<i.y;return o&&s},isValid:function(){return!(!this.min||!this.max)},pad:function(t){var e=this.min,i=this.max,n=Math.abs(e.x-i.x)*t,r=Math.abs(e.y-i.y)*t;return B(D(e.x-n,e.y-r),D(i.x+n,i.y+r))},equals:function(t){return!!t&&(t=B(t),this.min.equals(t.getTopLeft())&&this.max.equals(t.getBottomRight()))}},O.prototype={extend:function(t){var e,i,n=this._southWest,r=this._northEast;if(t instanceof j)e=t,i=t;else{if(!(t instanceof O))return t?this.extend(N(t)||R(t)):this;if(e=t._southWest,i=t._northEast,!e||!i)return this}return n||r?(n.lat=Math.min(e.lat,n.lat),n.lng=Math.min(e.lng,n.lng),r.lat=Math.max(i.lat,r.lat),r.lng=Math.max(i.lng,r.lng)):(this._southWest=new j(e.lat,e.lng),this._northEast=new j(i.lat,i.lng)),this},pad:function(t){var e=this._southWest,i=this._northEast,n=Math.abs(e.lat-i.lat)*t,r=Math.abs(e.lng-i.lng)*t;return new O(new j(e.lat-n,e.lng-r),new j(i.lat+n,i.lng+r))},getCenter:function(){return new j((this._southWest.lat+this._northEast.lat)/2,(this._southWest.lng+this._northEast.lng)/2)},getSouthWest:function(){return this._southWest},getNorthEast:function(){return this._northEast},getNorthWest:function(){return new j(this.getNorth(),this.getWest())},getSouthEast:function(){return new j(this.getSouth(),this.getEast())},getWest:function(){return this._southWest.lng},getSouth:function(){return this._southWest.lat},getEast:function(){return this._northEast.lng},getNorth:function(){return this._northEast.lat},contains:function(t){t="number"==typeof t[0]||t instanceof j||"lat"in t?N(t):R(t);var e,i,n=this._southWest,r=this._northEast;return t instanceof O?(e=t.getSouthWest(),i=t.getNorthEast()):e=i=t,e.lat>=n.lat&&i.lat<=r.lat&&e.lng>=n.lng&&i.lng<=r.lng},intersects:function(t){t=R(t);var e=this._southWest,i=this._northEast,n=t.getSouthWest(),r=t.getNorthEast(),o=r.lat>=e.lat&&n.lat<=i.lat,s=r.lng>=e.lng&&n.lng<=i.lng;return o&&s},overlaps:function(t){t=R(t);var e=this._southWest,i=this._northEast,n=t.getSouthWest(),r=t.getNorthEast(),o=r.lat>e.lat&&n.lat<i.lat,s=r.lng>e.lng&&n.lng<i.lng;return o&&s},toBBoxString:function(){return[this.getWest(),this.getSouth(),this.getEast(),this.getNorth()].join(",")},equals:function(t,e){return!!t&&(t=R(t),this._southWest.equals(t.getSouthWest(),e)&&this._northEast.equals(t.getNorthEast(),e))},isValid:function(){return!(!this._southWest||!this._northEast)}},j.prototype={equals:function(t,e){return!!t&&(t=N(t),Math.max(Math.abs(this.lat-t.lat),Math.abs(this.lng-t.lng))<=(void 0===e?1e-9:e))},toString:function(t){return"LatLng("+h(this.lat,t)+", "+h(this.lng,t)+")"},distanceTo:function(t){return U.distance(this,N(t))},wrap:function(){return U.wrapLatLng(this)},toBounds:function(t){var e=180*t/40075017,i=e/Math.cos(Math.PI/180*this.lat);return R([this.lat-e,this.lng-i],[this.lat+e,this.lng+i])},clone:function(){return new j(this.lat,this.lng,this.alt)}};var F,G={latLngToPoint:function(t,e){var i=this.projection.project(t),n=this.scale(e);return this.transformation._transform(i,n)},pointToLatLng:function(t,e){var i=this.scale(e),n=this.transformation.untransform(t,i);return this.projection.unproject(n)},project:function(t){return this.projection.project(t)},unproject:function(t){return this.projection.unproject(t)},scale:function(t){return 256*Math.pow(2,t)},zoom:function(t){return Math.log(t/256)/Math.LN2},getProjectedBounds:function(t){if(this.infinite)return null;var e=this.projection.bounds,i=this.scale(t);return new z(this.transformation.transform(e.min,i),this.transformation.transform(e.max,i))},infinite:!1,wrapLatLng:function(t){var e=this.wrapLng?a(t.lng,this.wrapLng,!0):t.lng;return new j(this.wrapLat?a(t.lat,this.wrapLat,!0):t.lat,e,t.alt)},wrapLatLngBounds:function(t){var e=t.getCenter(),i=this.wrapLatLng(e),n=e.lat-i.lat,r=e.lng-i.lng;if(0===n&&0===r)return t;var o=t.getSouthWest(),s=t.getNorthEast();return new O(new j(o.lat-n,o.lng-r),new j(s.lat-n,s.lng-r))}},U=e({},G,{wrapLng:[-180,180],R:6371e3,distance:function(t,e){var i=Math.PI/180,n=t.lat*i,r=e.lat*i,o=Math.sin((e.lat-t.lat)*i/2),s=Math.sin((e.lng-t.lng)*i/2),a=o*o+Math.cos(n)*Math.cos(r)*s*s,l=2*Math.atan2(Math.sqrt(a),Math.sqrt(1-a));return this.R*l}}),H=6378137,V={R:H,MAX_LATITUDE:85.0511287798,project:function(t){var e=Math.PI/180,i=this.MAX_LATITUDE,n=Math.max(Math.min(i,t.lat),-i),r=Math.sin(n*e);return new I(this.R*t.lng*e,this.R*Math.log((1+r)/(1-r))/2)},unproject:function(t){var e=180/Math.PI;return new j((2*Math.atan(Math.exp(t.y/this.R))-Math.PI/2)*e,t.x*e/this.R)},bounds:(F=H*Math.PI,new z([-F,-F],[F,F]))};function Z(t,e,i,n){if(g(t))return this._a=t[0],this._b=t[1],this._c=t[2],void(this._d=t[3]);this._a=t,this._b=e,this._c=i,this._d=n}function q(t,e,i,n){return new Z(t,e,i,n)}Z.prototype={transform:function(t,e){return this._transform(t.clone(),e)},_transform:function(t,e){return e=e||1,t.x=e*(this._a*t.x+this._b),t.y=e*(this._c*t.y+this._d),t},untransform:function(t,e){return e=e||1,new I((t.x/e-this._b)/this._a,(t.y/e-this._d)/this._c)}};var W=e({},U,{code:"EPSG:3857",projection:V,transformation:function(){var t=.5/(Math.PI*V.R);return q(t,.5,-t,.5)}()}),K=e({},W,{code:"EPSG:900913"});function Y(t){return document.createElementNS("http://www.w3.org/2000/svg",t)}function X(t,e){var i,n,r,o,s,a,l="";for(i=0,r=t.length;i<r;i++){for(n=0,o=(s=t[i]).length;n<o;n++)l+=(n?"L":"M")+(a=s[n]).x+" "+a.y;l+=e?zt.svg?"z":"x":""}return l||"M0 0"}var J,Q=document.documentElement.style,$="ActiveXObject"in window,tt=$&&!document.addEventListener,et="msLaunchUri"in navigator&&!("documentMode"in document),it=Dt("webkit"),nt=Dt("android"),rt=Dt("android 2")||Dt("android 3"),ot=parseInt(/WebKit\/([0-9]+)|$/.exec(navigator.userAgent)[1],10),st=nt&&Dt("Google")&&ot<537&&!("AudioNode"in window),at=!!window.opera,lt=!et&&Dt("chrome"),ht=Dt("gecko")&&!it&&!at&&!$,ct=!lt&&Dt("safari"),ut=Dt("phantom"),dt="OTransition"in Q,pt=0===navigator.platform.indexOf("Win"),ft=$&&"transition"in Q,mt="WebKitCSSMatrix"in window&&"m11"in new window.WebKitCSSMatrix&&!rt,gt="MozPerspective"in Q,_t=!window.L_DISABLE_3D&&(ft||mt||gt)&&!dt&&!ut,yt="undefined"!=typeof orientation||Dt("mobile"),vt=yt&&it,bt=yt&&mt,xt=!window.PointerEvent&&window.MSPointerEvent,wt=!(!window.PointerEvent&&!xt),Lt="ontouchstart"in window||!!window.TouchEvent,Mt=!window.L_NO_TOUCH&&(Lt||wt),kt=yt&&at,Ct=yt&&ht,At=(window.devicePixelRatio||window.screen.deviceXDPI/window.screen.logicalXDPI)>1,Pt=function(){var t=!1;try{var e=Object.defineProperty({},"passive",{get:function(){t=!0}});window.addEventListener("testPassiveEventSupport",l,e),window.removeEventListener("testPassiveEventSupport",l,e)}catch(t){}return t}(),St=!!document.createElement("canvas").getContext,Et=!(!document.createElementNS||!Y("svg").createSVGRect),It=!!Et&&((J=document.createElement("div")).innerHTML="<svg/>","http://www.w3.org/2000/svg"===(J.firstChild&&J.firstChild.namespaceURI)),Tt=!Et&&function(){try{var t=document.createElement("div");t.innerHTML='<v:shape adj="1"/>';var e=t.firstChild;return e.style.behavior="url(#default#VML)",e&&"object"==typeof e.adj}catch(t){return!1}}();function Dt(t){return navigator.userAgent.toLowerCase().indexOf(t)>=0}var zt={ie:$,ielt9:tt,edge:et,webkit:it,android:nt,android23:rt,androidStock:st,opera:at,chrome:lt,gecko:ht,safari:ct,phantom:ut,opera12:dt,win:pt,ie3d:ft,webkit3d:mt,gecko3d:gt,any3d:_t,mobile:yt,mobileWebkit:vt,mobileWebkit3d:bt,msPointer:xt,pointer:wt,touch:Mt,touchNative:Lt,mobileOpera:kt,mobileGecko:Ct,retina:At,passiveEvents:Pt,canvas:St,svg:Et,vml:Tt,inlineSvg:It,mac:0===navigator.platform.indexOf("Mac"),linux:0===navigator.platform.indexOf("Linux")},Bt=zt.msPointer?"MSPointerDown":"pointerdown",Ot=zt.msPointer?"MSPointerMove":"pointermove",Rt=zt.msPointer?"MSPointerUp":"pointerup",jt=zt.msPointer?"MSPointerCancel":"pointercancel",Nt={touchstart:Bt,touchmove:Ot,touchend:Rt,touchcancel:jt},Ft={touchstart:function(t,e){e.MSPOINTER_TYPE_TOUCH&&e.pointerType===e.MSPOINTER_TYPE_TOUCH&&je(e),Wt(t,e)},touchmove:Wt,touchend:Wt,touchcancel:Wt},Gt={},Ut=!1;function Ht(t,e,i){return"touchstart"===e&&(Ut||(document.addEventListener(Bt,Vt,!0),document.addEventListener(Ot,Zt,!0),document.addEventListener(Rt,qt,!0),document.addEventListener(jt,qt,!0),Ut=!0)),Ft[e]?(i=Ft[e].bind(this,i),t.addEventListener(Nt[e],i,!1),i):(console.warn("wrong event specified:",e),l)}function Vt(t){Gt[t.pointerId]=t}function Zt(t){Gt[t.pointerId]&&(Gt[t.pointerId]=t)}function qt(t){delete Gt[t.pointerId]}function Wt(t,e){if(e.pointerType!==(e.MSPOINTER_TYPE_MOUSE||"mouse")){for(var i in e.touches=[],Gt)e.touches.push(Gt[i]);e.changedTouches=[e],t(e)}}var Kt=200;var Yt,Xt,Jt,Qt,$t,te=ge(["transform","webkitTransform","OTransform","MozTransform","msTransform"]),ee=ge(["webkitTransition","transition","OTransition","MozTransition","msTransition"]),ie="webkitTransition"===ee||"OTransition"===ee?ee+"End":"transitionend";function ne(t){return"string"==typeof t?document.getElementById(t):t}function re(t,e){var i=t.style[e]||t.currentStyle&&t.currentStyle[e];if((!i||"auto"===i)&&document.defaultView){var n=document.defaultView.getComputedStyle(t,null);i=n?n[e]:null}return"auto"===i?null:i}function oe(t,e,i){var n=document.createElement(t);return n.className=e||"",i&&i.appendChild(n),n}function se(t){var e=t.parentNode;e&&e.removeChild(t)}function ae(t){for(;t.firstChild;)t.removeChild(t.firstChild)}function le(t){var e=t.parentNode;e&&e.lastChild!==t&&e.appendChild(t)}function he(t){var e=t.parentNode;e&&e.firstChild!==t&&e.insertBefore(t,e.firstChild)}function ce(t,e){if(void 0!==t.classList)return t.classList.contains(e);var i=fe(t);return i.length>0&&new RegExp("(^|\\s)"+e+"(\\s|$)").test(i)}function ue(t,e){if(void 0!==t.classList)for(var i=u(e),n=0,r=i.length;n<r;n++)t.classList.add(i[n]);else if(!ce(t,e)){var o=fe(t);pe(t,(o?o+" ":"")+e)}}function de(t,e){void 0!==t.classList?t.classList.remove(e):pe(t,c((" "+fe(t)+" ").replace(" "+e+" "," ")))}function pe(t,e){void 0===t.className.baseVal?t.className=e:t.className.baseVal=e}function fe(t){return t.correspondingElement&&(t=t.correspondingElement),void 0===t.className.baseVal?t.className:t.className.baseVal}function me(t,e){"opacity"in t.style?t.style.opacity=e:"filter"in t.style&&function(t,e){var i=!1,n="DXImageTransform.Microsoft.Alpha";try{i=t.filters.item(n)}catch(t){if(1===e)return}e=Math.round(100*e),i?(i.Enabled=100!==e,i.Opacity=e):t.style.filter+=" progid:"+n+"(opacity="+e+")"}(t,e)}function ge(t){for(var e=document.documentElement.style,i=0;i<t.length;i++)if(t[i]in e)return t[i];return!1}function _e(t,e,i){var n=e||new I(0,0);t.style[te]=(zt.ie3d?"translate("+n.x+"px,"+n.y+"px)":"translate3d("+n.x+"px,"+n.y+"px,0)")+(i?" scale("+i+")":"")}function ye(t,e){t._leaflet_pos=e,zt.any3d?_e(t,e):(t.style.left=e.x+"px",t.style.top=e.y+"px")}function ve(t){return t._leaflet_pos||new I(0,0)}if("onselectstart"in document)Yt=function(){Pe(window,"selectstart",je)},Xt=function(){Ee(window,"selectstart",je)};else{var be=ge(["userSelect","WebkitUserSelect","OUserSelect","MozUserSelect","msUserSelect"]);Yt=function(){if(be){var t=document.documentElement.style;Jt=t[be],t[be]="none"}},Xt=function(){be&&(document.documentElement.style[be]=Jt,Jt=void 0)}}function xe(){Pe(window,"dragstart",je)}function we(){Ee(window,"dragstart",je)}function Le(t){for(;-1===t.tabIndex;)t=t.parentNode;t.style&&(Me(),Qt=t,$t=t.style.outlineStyle,t.style.outlineStyle="none",Pe(window,"keydown",Me))}function Me(){Qt&&(Qt.style.outlineStyle=$t,Qt=void 0,$t=void 0,Ee(window,"keydown",Me))}function ke(t){do{t=t.parentNode}while(!(t.offsetWidth&&t.offsetHeight||t===document.body));return t}function Ce(t){var e=t.getBoundingClientRect();return{x:e.width/t.offsetWidth||1,y:e.height/t.offsetHeight||1,boundingClientRect:e}}var Ae={__proto__:null,TRANSFORM:te,TRANSITION:ee,TRANSITION_END:ie,get:ne,getStyle:re,create:oe,remove:se,empty:ae,toFront:le,toBack:he,hasClass:ce,addClass:ue,removeClass:de,setClass:pe,getClass:fe,setOpacity:me,testProp:ge,setTransform:_e,setPosition:ye,getPosition:ve,get disableTextSelection(){return Yt},get enableTextSelection(){return Xt},disableImageDrag:xe,enableImageDrag:we,preventOutline:Le,restoreOutline:Me,getSizedParentNode:ke,getScale:Ce};function Pe(t,e,i,n){if(e&&"object"==typeof e)for(var r in e)De(t,r,e[r],i);else for(var o=0,s=(e=u(e)).length;o<s;o++)De(t,e[o],i,n);return this}var Se="_leaflet_events";function Ee(t,e,i,n){if(1===arguments.length)Ie(t),delete t[Se];else if(e&&"object"==typeof e)for(var r in e)ze(t,r,e[r],i);else if(e=u(e),2===arguments.length)Ie(t,(function(t){return-1!==_(e,t)}));else for(var o=0,s=e.length;o<s;o++)ze(t,e[o],i,n);return this}function Ie(t,e){for(var i in t[Se]){var n=i.split(/\d/)[0];e&&!e(n)||ze(t,n,null,null,i)}}var Te={mouseenter:"mouseover",mouseleave:"mouseout",wheel:!("onwheel"in window)&&"mousewheel"};function De(t,e,i,n){var r=e+o(i)+(n?"_"+o(n):"");if(t[Se]&&t[Se][r])return this;var s=function(e){return i.call(n||t,e||window.event)},a=s;!zt.touchNative&&zt.pointer&&0===e.indexOf("touch")?s=Ht(t,e,s):zt.touch&&"dblclick"===e?s=function(t,e){t.addEventListener("dblclick",e);var i,n=0;function r(t){if(1===t.detail){if("mouse"!==t.pointerType&&(!t.sourceCapabilities||t.sourceCapabilities.firesTouchEvents)){var r=Fe(t);if(!r.some((function(t){return t instanceof HTMLLabelElement&&t.attributes.for}))||r.some((function(t){return t instanceof HTMLInputElement||t instanceof HTMLSelectElement}))){var o=Date.now();o-n<=Kt?2==++i&&e(function(t){var e,i,n={};for(i in t)e=t[i],n[i]=e&&e.bind?e.bind(t):e;return t=n,n.type="dblclick",n.detail=2,n.isTrusted=!1,n._simulated=!0,n}(t)):i=1,n=o}}}else i=t.detail}return t.addEventListener("click",r),{dblclick:e,simDblclick:r}}(t,s):"addEventListener"in t?"touchstart"===e||"touchmove"===e||"wheel"===e||"mousewheel"===e?t.addEventListener(Te[e]||e,s,!!zt.passiveEvents&&{passive:!1}):"mouseenter"===e||"mouseleave"===e?(s=function(e){e=e||window.event,Ve(t,e)&&a(e)},t.addEventListener(Te[e],s,!1)):t.addEventListener(e,a,!1):t.attachEvent("on"+e,s),t[Se]=t[Se]||{},t[Se][r]=s}function ze(t,e,i,n,r){r=r||e+o(i)+(n?"_"+o(n):"");var s=t[Se]&&t[Se][r];if(!s)return this;!zt.touchNative&&zt.pointer&&0===e.indexOf("touch")?function(t,e,i){Nt[e]?t.removeEventListener(Nt[e],i,!1):console.warn("wrong event specified:",e)}(t,e,s):zt.touch&&"dblclick"===e?function(t,e){t.removeEventListener("dblclick",e.dblclick),t.removeEventListener("click",e.simDblclick)}(t,s):"removeEventListener"in t?t.removeEventListener(Te[e]||e,s,!1):t.detachEvent("on"+e,s),t[Se][r]=null}function Be(t){return t.stopPropagation?t.stopPropagation():t.originalEvent?t.originalEvent._stopped=!0:t.cancelBubble=!0,this}function Oe(t){return De(t,"wheel",Be),this}function Re(t){return Pe(t,"mousedown touchstart dblclick contextmenu",Be),t._leaflet_disable_click=!0,this}function je(t){return t.preventDefault?t.preventDefault():t.returnValue=!1,this}function Ne(t){return je(t),Be(t),this}function Fe(t){if(t.composedPath)return t.composedPath();for(var e=[],i=t.target;i;)e.push(i),i=i.parentNode;return e}function Ge(t,e){if(!e)return new I(t.clientX,t.clientY);var i=Ce(e),n=i.boundingClientRect;return new I((t.clientX-n.left)/i.x-e.clientLeft,(t.clientY-n.top)/i.y-e.clientTop)}var Ue=zt.linux&&zt.chrome?window.devicePixelRatio:zt.mac?3*window.devicePixelRatio:window.devicePixelRatio>0?2*window.devicePixelRatio:1;function He(t){return zt.edge?t.wheelDeltaY/2:t.deltaY&&0===t.deltaMode?-t.deltaY/Ue:t.deltaY&&1===t.deltaMode?20*-t.deltaY:t.deltaY&&2===t.deltaMode?60*-t.deltaY:t.deltaX||t.deltaZ?0:t.wheelDelta?(t.wheelDeltaY||t.wheelDelta)/2:t.detail&&Math.abs(t.detail)<32765?20*-t.detail:t.detail?t.detail/-32765*60:0}function Ve(t,e){var i=e.relatedTarget;if(!i)return!0;try{for(;i&&i!==t;)i=i.parentNode}catch(t){return!1}return i!==t}var Ze={__proto__:null,on:Pe,off:Ee,stopPropagation:Be,disableScrollPropagation:Oe,disableClickPropagation:Re,preventDefault:je,stop:Ne,getPropagationPath:Fe,getMousePosition:Ge,getWheelDelta:He,isExternalTarget:Ve,addListener:Pe,removeListener:Ee},qe=E.extend({run:function(t,e,i,n){this.stop(),this._el=t,this._inProgress=!0,this._duration=i||.25,this._easeOutPower=1/Math.max(n||.5,.2),this._startPos=ve(t),this._offset=e.subtract(this._startPos),this._startTime=+new Date,this.fire("start"),this._animate()},stop:function(){this._inProgress&&(this._step(!0),this._complete())},_animate:function(){this._animId=k(this._animate,this),this._step()},_step:function(t){var e=+new Date-this._startTime,i=1e3*this._duration;e<i?this._runFrame(this._easeOut(e/i),t):(this._runFrame(1),this._complete())},_runFrame:function(t,e){var i=this._startPos.add(this._offset.multiplyBy(t));e&&i._round(),ye(this._el,i),this.fire("step")},_complete:function(){C(this._animId),this._inProgress=!1,this.fire("end")},_easeOut:function(t){return 1-Math.pow(1-t,this._easeOutPower)}}),We=E.extend({options:{crs:W,center:void 0,zoom:void 0,minZoom:void 0,maxZoom:void 0,layers:[],maxBounds:void 0,renderer:void 0,zoomAnimation:!0,zoomAnimationThreshold:4,fadeAnimation:!0,markerZoomAnimation:!0,transform3DLimit:8388608,zoomSnap:1,zoomDelta:1,trackResize:!0},initialize:function(t,e){e=d(this,e),this._handlers=[],this._layers={},this._zoomBoundLayers={},this._sizeChanged=!0,this._initContainer(t),this._initLayout(),this._onResize=n(this._onResize,this),this._initEvents(),e.maxBounds&&this.setMaxBounds(e.maxBounds),void 0!==e.zoom&&(this._zoom=this._limitZoom(e.zoom)),e.center&&void 0!==e.zoom&&this.setView(N(e.center),e.zoom,{reset:!0}),this.callInitHooks(),this._zoomAnimated=ee&&zt.any3d&&!zt.mobileOpera&&this.options.zoomAnimation,this._zoomAnimated&&(this._createAnimProxy(),Pe(this._proxy,ie,this._catchTransitionEnd,this)),this._addLayers(this.options.layers)},setView:function(t,i,n){return i=void 0===i?this._zoom:this._limitZoom(i),t=this._limitCenter(N(t),i,this.options.maxBounds),n=n||{},this._stop(),this._loaded&&!n.reset&&!0!==n&&(void 0!==n.animate&&(n.zoom=e({animate:n.animate},n.zoom),n.pan=e({animate:n.animate,duration:n.duration},n.pan)),this._zoom!==i?this._tryAnimatedZoom&&this._tryAnimatedZoom(t,i,n.zoom):this._tryAnimatedPan(t,n.pan))?(clearTimeout(this._sizeTimer),this):(this._resetView(t,i,n.pan&&n.pan.noMoveStart),this)},setZoom:function(t,e){return this._loaded?this.setView(this.getCenter(),t,{zoom:e}):(this._zoom=t,this)},zoomIn:function(t,e){return t=t||(zt.any3d?this.options.zoomDelta:1),this.setZoom(this._zoom+t,e)},zoomOut:function(t,e){return t=t||(zt.any3d?this.options.zoomDelta:1),this.setZoom(this._zoom-t,e)},setZoomAround:function(t,e,i){var n=this.getZoomScale(e),r=this.getSize().divideBy(2),o=(t instanceof I?t:this.latLngToContainerPoint(t)).subtract(r).multiplyBy(1-1/n),s=this.containerPointToLatLng(r.add(o));return this.setView(s,e,{zoom:i})},_getBoundsCenterZoom:function(t,e){e=e||{},t=t.getBounds?t.getBounds():R(t);var i=D(e.paddingTopLeft||e.padding||[0,0]),n=D(e.paddingBottomRight||e.padding||[0,0]),r=this.getBoundsZoom(t,!1,i.add(n));if((r="number"==typeof e.maxZoom?Math.min(e.maxZoom,r):r)===1/0)return{center:t.getCenter(),zoom:r};var o=n.subtract(i).divideBy(2),s=this.project(t.getSouthWest(),r),a=this.project(t.getNorthEast(),r);return{center:this.unproject(s.add(a).divideBy(2).add(o),r),zoom:r}},fitBounds:function(t,e){if(!(t=R(t)).isValid())throw new Error("Bounds are not valid.");var i=this._getBoundsCenterZoom(t,e);return this.setView(i.center,i.zoom,e)},fitWorld:function(t){return this.fitBounds([[-90,-180],[90,180]],t)},panTo:function(t,e){return this.setView(t,this._zoom,{pan:e})},panBy:function(t,e){if(e=e||{},!(t=D(t).round()).x&&!t.y)return this.fire("moveend");if(!0!==e.animate&&!this.getSize().contains(t))return this._resetView(this.unproject(this.project(this.getCenter()).add(t)),this.getZoom()),this;if(this._panAnim||(this._panAnim=new qe,this._panAnim.on({step:this._onPanTransitionStep,end:this._onPanTransitionEnd},this)),e.noMoveStart||this.fire("movestart"),!1!==e.animate){ue(this._mapPane,"leaflet-pan-anim");var i=this._getMapPanePos().subtract(t).round();this._panAnim.run(this._mapPane,i,e.duration||.25,e.easeLinearity)}else this._rawPanBy(t),this.fire("move").fire("moveend");return this},flyTo:function(t,e,i){if(!1===(i=i||{}).animate||!zt.any3d)return this.setView(t,e,i);this._stop();var n=this.project(this.getCenter()),r=this.project(t),o=this.getSize(),s=this._zoom;t=N(t),e=void 0===e?s:e;var a=Math.max(o.x,o.y),l=a*this.getZoomScale(s,e),h=r.distanceTo(n)||1,c=1.42,u=c*c;function d(t){var e=(l*l-a*a+(t?-1:1)*u*u*h*h)/(2*(t?l:a)*u*h),i=Math.sqrt(e*e+1)-e;return i<1e-9?-18:Math.log(i)}function p(t){return(Math.exp(t)-Math.exp(-t))/2}function f(t){return(Math.exp(t)+Math.exp(-t))/2}var m=d(0);function g(t){return a*(f(m)*(p(e=m+c*t)/f(e))-p(m))/u;var e}var _=Date.now(),y=(d(1)-m)/c,v=i.duration?1e3*i.duration:1e3*y*.8;return this._moveStart(!0,i.noMoveStart),function i(){var o=(Date.now()-_)/v,l=function(t){return 1-Math.pow(1-t,1.5)}(o)*y;o<=1?(this._flyToFrame=k(i,this),this._move(this.unproject(n.add(r.subtract(n).multiplyBy(g(l)/h)),s),this.getScaleZoom(a/function(t){return a*(f(m)/f(m+c*t))}(l),s),{flyTo:!0})):this._move(t,e)._moveEnd(!0)}.call(this),this},flyToBounds:function(t,e){var i=this._getBoundsCenterZoom(t,e);return this.flyTo(i.center,i.zoom,e)},setMaxBounds:function(t){return t=R(t),this.listens("moveend",this._panInsideMaxBounds)&&this.off("moveend",this._panInsideMaxBounds),t.isValid()?(this.options.maxBounds=t,this._loaded&&this._panInsideMaxBounds(),this.on("moveend",this._panInsideMaxBounds)):(this.options.maxBounds=null,this)},setMinZoom:function(t){var e=this.options.minZoom;return this.options.minZoom=t,this._loaded&&e!==t&&(this.fire("zoomlevelschange"),this.getZoom()<this.options.minZoom)?this.setZoom(t):this},setMaxZoom:function(t){var e=this.options.maxZoom;return this.options.maxZoom=t,this._loaded&&e!==t&&(this.fire("zoomlevelschange"),this.getZoom()>this.options.maxZoom)?this.setZoom(t):this},panInsideBounds:function(t,e){this._enforcingBounds=!0;var i=this.getCenter(),n=this._limitCenter(i,this._zoom,R(t));return i.equals(n)||this.panTo(n,e),this._enforcingBounds=!1,this},panInside:function(t,e){var i=D((e=e||{}).paddingTopLeft||e.padding||[0,0]),n=D(e.paddingBottomRight||e.padding||[0,0]),r=this.project(this.getCenter()),o=this.project(t),s=this.getPixelBounds(),a=B([s.min.add(i),s.max.subtract(n)]),l=a.getSize();if(!a.contains(o)){this._enforcingBounds=!0;var h=o.subtract(a.getCenter()),c=a.extend(o).getSize().subtract(l);r.x+=h.x<0?-c.x:c.x,r.y+=h.y<0?-c.y:c.y,this.panTo(this.unproject(r),e),this._enforcingBounds=!1}return this},invalidateSize:function(t){if(!this._loaded)return this;t=e({animate:!1,pan:!0},!0===t?{animate:!0}:t);var i=this.getSize();this._sizeChanged=!0,this._lastCenter=null;var r=this.getSize(),o=i.divideBy(2).round(),s=r.divideBy(2).round(),a=o.subtract(s);return a.x||a.y?(t.animate&&t.pan?this.panBy(a):(t.pan&&this._rawPanBy(a),this.fire("move"),t.debounceMoveend?(clearTimeout(this._sizeTimer),this._sizeTimer=setTimeout(n(this.fire,this,"moveend"),200)):this.fire("moveend")),this.fire("resize",{oldSize:i,newSize:r})):this},stop:function(){return this.setZoom(this._limitZoom(this._zoom)),this.options.zoomSnap||this.fire("viewreset"),this._stop()},locate:function(t){if(t=this._locateOptions=e({timeout:1e4,watch:!1},t),!("geolocation"in navigator))return this._handleGeolocationError({code:0,message:"Geolocation not supported."}),this;var i=n(this._handleGeolocationResponse,this),r=n(this._handleGeolocationError,this);return t.watch?this._locationWatchId=navigator.geolocation.watchPosition(i,r,t):navigator.geolocation.getCurrentPosition(i,r,t),this},stopLocate:function(){return navigator.geolocation&&navigator.geolocation.clearWatch&&navigator.geolocation.clearWatch(this._locationWatchId),this._locateOptions&&(this._locateOptions.setView=!1),this},_handleGeolocationError:function(t){if(this._container._leaflet_id){var e=t.code,i=t.message||(1===e?"permission denied":2===e?"position unavailable":"timeout");this._locateOptions.setView&&!this._loaded&&this.fitWorld(),this.fire("locationerror",{code:e,message:"Geolocation error: "+i+"."})}},_handleGeolocationResponse:function(t){if(this._container._leaflet_id){var e=new j(t.coords.latitude,t.coords.longitude),i=e.toBounds(2*t.coords.accuracy),n=this._locateOptions;if(n.setView){var r=this.getBoundsZoom(i);this.setView(e,n.maxZoom?Math.min(r,n.maxZoom):r)}var o={latlng:e,bounds:i,timestamp:t.timestamp};for(var s in t.coords)"number"==typeof t.coords[s]&&(o[s]=t.coords[s]);this.fire("locationfound",o)}},addHandler:function(t,e){if(!e)return this;var i=this[t]=new e(this);return this._handlers.push(i),this.options[t]&&i.enable(),this},remove:function(){if(this._initEvents(!0),this.options.maxBounds&&this.off("moveend",this._panInsideMaxBounds),this._containerId!==this._container._leaflet_id)throw new Error("Map container is being reused by another instance");try{delete this._container._leaflet_id,delete this._containerId}catch(t){this._container._leaflet_id=void 0,this._containerId=void 0}var t;for(t in void 0!==this._locationWatchId&&this.stopLocate(),this._stop(),se(this._mapPane),this._clearControlPos&&this._clearControlPos(),this._resizeRequest&&(C(this._resizeRequest),this._resizeRequest=null),this._clearHandlers(),this._loaded&&this.fire("unload"),this._layers)this._layers[t].remove();for(t in this._panes)se(this._panes[t]);return this._layers=[],this._panes=[],delete this._mapPane,delete this._renderer,this},createPane:function(t,e){var i=oe("div","leaflet-pane"+(t?" leaflet-"+t.replace("Pane","")+"-pane":""),e||this._mapPane);return t&&(this._panes[t]=i),i},getCenter:function(){return this._checkIfLoaded(),this._lastCenter&&!this._moved()?this._lastCenter.clone():this.layerPointToLatLng(this._getCenterLayerPoint())},getZoom:function(){return this._zoom},getBounds:function(){var t=this.getPixelBounds();return new O(this.unproject(t.getBottomLeft()),this.unproject(t.getTopRight()))},getMinZoom:function(){return void 0===this.options.minZoom?this._layersMinZoom||0:this.options.minZoom},getMaxZoom:function(){return void 0===this.options.maxZoom?void 0===this._layersMaxZoom?1/0:this._layersMaxZoom:this.options.maxZoom},getBoundsZoom:function(t,e,i){t=R(t),i=D(i||[0,0]);var n=this.getZoom()||0,r=this.getMinZoom(),o=this.getMaxZoom(),s=t.getNorthWest(),a=t.getSouthEast(),l=this.getSize().subtract(i),h=B(this.project(a,n),this.project(s,n)).getSize(),c=zt.any3d?this.options.zoomSnap:1,u=l.x/h.x,d=l.y/h.y,p=e?Math.max(u,d):Math.min(u,d);return n=this.getScaleZoom(p,n),c&&(n=Math.round(n/(c/100))*(c/100),n=e?Math.ceil(n/c)*c:Math.floor(n/c)*c),Math.max(r,Math.min(o,n))},getSize:function(){return this._size&&!this._sizeChanged||(this._size=new I(this._container.clientWidth||0,this._container.clientHeight||0),this._sizeChanged=!1),this._size.clone()},getPixelBounds:function(t,e){var i=this._getTopLeftPoint(t,e);return new z(i,i.add(this.getSize()))},getPixelOrigin:function(){return this._checkIfLoaded(),this._pixelOrigin},getPixelWorldBounds:function(t){return this.options.crs.getProjectedBounds(void 0===t?this.getZoom():t)},getPane:function(t){return"string"==typeof t?this._panes[t]:t},getPanes:function(){return this._panes},getContainer:function(){return this._container},getZoomScale:function(t,e){var i=this.options.crs;return e=void 0===e?this._zoom:e,i.scale(t)/i.scale(e)},getScaleZoom:function(t,e){var i=this.options.crs;e=void 0===e?this._zoom:e;var n=i.zoom(t*i.scale(e));return isNaN(n)?1/0:n},project:function(t,e){return e=void 0===e?this._zoom:e,this.options.crs.latLngToPoint(N(t),e)},unproject:function(t,e){return e=void 0===e?this._zoom:e,this.options.crs.pointToLatLng(D(t),e)},layerPointToLatLng:function(t){var e=D(t).add(this.getPixelOrigin());return this.unproject(e)},latLngToLayerPoint:function(t){return this.project(N(t))._round()._subtract(this.getPixelOrigin())},wrapLatLng:function(t){return this.options.crs.wrapLatLng(N(t))},wrapLatLngBounds:function(t){return this.options.crs.wrapLatLngBounds(R(t))},distance:function(t,e){return this.options.crs.distance(N(t),N(e))},containerPointToLayerPoint:function(t){return D(t).subtract(this._getMapPanePos())},layerPointToContainerPoint:function(t){return D(t).add(this._getMapPanePos())},containerPointToLatLng:function(t){var e=this.containerPointToLayerPoint(D(t));return this.layerPointToLatLng(e)},latLngToContainerPoint:function(t){return this.layerPointToContainerPoint(this.latLngToLayerPoint(N(t)))},mouseEventToContainerPoint:function(t){return Ge(t,this._container)},mouseEventToLayerPoint:function(t){return this.containerPointToLayerPoint(this.mouseEventToContainerPoint(t))},mouseEventToLatLng:function(t){return this.layerPointToLatLng(this.mouseEventToLayerPoint(t))},_initContainer:function(t){var e=this._container=ne(t);if(!e)throw new Error("Map container not found.");if(e._leaflet_id)throw new Error("Map container is already initialized.");Pe(e,"scroll",this._onScroll,this),this._containerId=o(e)},_initLayout:function(){var t=this._container;this._fadeAnimated=this.options.fadeAnimation&&zt.any3d,ue(t,"leaflet-container"+(zt.touch?" leaflet-touch":"")+(zt.retina?" leaflet-retina":"")+(zt.ielt9?" leaflet-oldie":"")+(zt.safari?" leaflet-safari":"")+(this._fadeAnimated?" leaflet-fade-anim":""));var e=re(t,"position");"absolute"!==e&&"relative"!==e&&"fixed"!==e&&"sticky"!==e&&(t.style.position="relative"),this._initPanes(),this._initControlPos&&this._initControlPos()},_initPanes:function(){var t=this._panes={};this._paneRenderers={},this._mapPane=this.createPane("mapPane",this._container),ye(this._mapPane,new I(0,0)),this.createPane("tilePane"),this.createPane("overlayPane"),this.createPane("shadowPane"),this.createPane("markerPane"),this.createPane("tooltipPane"),this.createPane("popupPane"),this.options.markerZoomAnimation||(ue(t.markerPane,"leaflet-zoom-hide"),ue(t.shadowPane,"leaflet-zoom-hide"))},_resetView:function(t,e,i){ye(this._mapPane,new I(0,0));var n=!this._loaded;this._loaded=!0,e=this._limitZoom(e),this.fire("viewprereset");var r=this._zoom!==e;this._moveStart(r,i)._move(t,e)._moveEnd(r),this.fire("viewreset"),n&&this.fire("load")},_moveStart:function(t,e){return t&&this.fire("zoomstart"),e||this.fire("movestart"),this},_move:function(t,e,i,n){void 0===e&&(e=this._zoom);var r=this._zoom!==e;return this._zoom=e,this._lastCenter=t,this._pixelOrigin=this._getNewPixelOrigin(t),n?i&&i.pinch&&this.fire("zoom",i):((r||i&&i.pinch)&&this.fire("zoom",i),this.fire("move",i)),this},_moveEnd:function(t){return t&&this.fire("zoomend"),this.fire("moveend")},_stop:function(){return C(this._flyToFrame),this._panAnim&&this._panAnim.stop(),this},_rawPanBy:function(t){ye(this._mapPane,this._getMapPanePos().subtract(t))},_getZoomSpan:function(){return this.getMaxZoom()-this.getMinZoom()},_panInsideMaxBounds:function(){this._enforcingBounds||this.panInsideBounds(this.options.maxBounds)},_checkIfLoaded:function(){if(!this._loaded)throw new Error("Set map center and zoom first.")},_initEvents:function(t){this._targets={},this._targets[o(this._container)]=this;var e=t?Ee:Pe;e(this._container,"click dblclick mousedown mouseup mouseover mouseout mousemove contextmenu keypress keydown keyup",this._handleDOMEvent,this),this.options.trackResize&&e(window,"resize",this._onResize,this),zt.any3d&&this.options.transform3DLimit&&(t?this.off:this.on).call(this,"moveend",this._onMoveEnd)},_onResize:function(){C(this._resizeRequest),this._resizeRequest=k((function(){this.invalidateSize({debounceMoveend:!0})}),this)},_onScroll:function(){this._container.scrollTop=0,this._container.scrollLeft=0},_onMoveEnd:function(){var t=this._getMapPanePos();Math.max(Math.abs(t.x),Math.abs(t.y))>=this.options.transform3DLimit&&this._resetView(this.getCenter(),this.getZoom())},_findEventTargets:function(t,e){for(var i,n=[],r="mouseout"===e||"mouseover"===e,s=t.target||t.srcElement,a=!1;s;){if((i=this._targets[o(s)])&&("click"===e||"preclick"===e)&&this._draggableMoved(i)){a=!0;break}if(i&&i.listens(e,!0)){if(r&&!Ve(s,t))break;if(n.push(i),r)break}if(s===this._container)break;s=s.parentNode}return n.length||a||r||!this.listens(e,!0)||(n=[this]),n},_isClickDisabled:function(t){for(;t&&t!==this._container;){if(t._leaflet_disable_click)return!0;t=t.parentNode}},_handleDOMEvent:function(t){var e=t.target||t.srcElement;if(!(!this._loaded||e._leaflet_disable_events||"click"===t.type&&this._isClickDisabled(e))){var i=t.type;"mousedown"===i&&Le(e),this._fireDOMEvent(t,i)}},_mouseEvents:["click","dblclick","mouseover","mouseout","contextmenu"],_fireDOMEvent:function(t,i,n){if("click"===t.type){var r=e({},t);r.type="preclick",this._fireDOMEvent(r,r.type,n)}var o=this._findEventTargets(t,i);if(n){for(var s=[],a=0;a<n.length;a++)n[a].listens(i,!0)&&s.push(n[a]);o=s.concat(o)}if(o.length){"contextmenu"===i&&je(t);var l=o[0],h={originalEvent:t};if("keypress"!==t.type&&"keydown"!==t.type&&"keyup"!==t.type){var c=l.getLatLng&&(!l._radius||l._radius<=10);h.containerPoint=c?this.latLngToContainerPoint(l.getLatLng()):this.mouseEventToContainerPoint(t),h.layerPoint=this.containerPointToLayerPoint(h.containerPoint),h.latlng=c?l.getLatLng():this.layerPointToLatLng(h.layerPoint)}for(a=0;a<o.length;a++)if(o[a].fire(i,h,!0),h.originalEvent._stopped||!1===o[a].options.bubblingMouseEvents&&-1!==_(this._mouseEvents,i))return}},_draggableMoved:function(t){return(t=t.dragging&&t.dragging.enabled()?t:this).dragging&&t.dragging.moved()||this.boxZoom&&this.boxZoom.moved()},_clearHandlers:function(){for(var t=0,e=this._handlers.length;t<e;t++)this._handlers[t].disable()},whenReady:function(t,e){return this._loaded?t.call(e||this,{target:this}):this.on("load",t,e),this},_getMapPanePos:function(){return ve(this._mapPane)||new I(0,0)},_moved:function(){var t=this._getMapPanePos();return t&&!t.equals([0,0])},_getTopLeftPoint:function(t,e){return(t&&void 0!==e?this._getNewPixelOrigin(t,e):this.getPixelOrigin()).subtract(this._getMapPanePos())},_getNewPixelOrigin:function(t,e){var i=this.getSize()._divideBy(2);return this.project(t,e)._subtract(i)._add(this._getMapPanePos())._round()},_latLngToNewLayerPoint:function(t,e,i){var n=this._getNewPixelOrigin(i,e);return this.project(t,e)._subtract(n)},_latLngBoundsToNewLayerBounds:function(t,e,i){var n=this._getNewPixelOrigin(i,e);return B([this.project(t.getSouthWest(),e)._subtract(n),this.project(t.getNorthWest(),e)._subtract(n),this.project(t.getSouthEast(),e)._subtract(n),this.project(t.getNorthEast(),e)._subtract(n)])},_getCenterLayerPoint:function(){return this.containerPointToLayerPoint(this.getSize()._divideBy(2))},_getCenterOffset:function(t){return this.latLngToLayerPoint(t).subtract(this._getCenterLayerPoint())},_limitCenter:function(t,e,i){if(!i)return t;var n=this.project(t,e),r=this.getSize().divideBy(2),o=new z(n.subtract(r),n.add(r)),s=this._getBoundsOffset(o,i,e);return Math.abs(s.x)<=1&&Math.abs(s.y)<=1?t:this.unproject(n.add(s),e)},_limitOffset:function(t,e){if(!e)return t;var i=this.getPixelBounds(),n=new z(i.min.add(t),i.max.add(t));return t.add(this._getBoundsOffset(n,e))},_getBoundsOffset:function(t,e,i){var n=B(this.project(e.getNorthEast(),i),this.project(e.getSouthWest(),i)),r=n.min.subtract(t.min),o=n.max.subtract(t.max);return new I(this._rebound(r.x,-o.x),this._rebound(r.y,-o.y))},_rebound:function(t,e){return t+e>0?Math.round(t-e)/2:Math.max(0,Math.ceil(t))-Math.max(0,Math.floor(e))},_limitZoom:function(t){var e=this.getMinZoom(),i=this.getMaxZoom(),n=zt.any3d?this.options.zoomSnap:1;return n&&(t=Math.round(t/n)*n),Math.max(e,Math.min(i,t))},_onPanTransitionStep:function(){this.fire("move")},_onPanTransitionEnd:function(){de(this._mapPane,"leaflet-pan-anim"),this.fire("moveend")},_tryAnimatedPan:function(t,e){var i=this._getCenterOffset(t)._trunc();return!(!0!==(e&&e.animate)&&!this.getSize().contains(i)||(this.panBy(i,e),0))},_createAnimProxy:function(){var t=this._proxy=oe("div","leaflet-proxy leaflet-zoom-animated");this._panes.mapPane.appendChild(t),this.on("zoomanim",(function(t){var e=te,i=this._proxy.style[e];_e(this._proxy,this.project(t.center,t.zoom),this.getZoomScale(t.zoom,1)),i===this._proxy.style[e]&&this._animatingZoom&&this._onZoomTransitionEnd()}),this),this.on("load moveend",this._animMoveEnd,this),this._on("unload",this._destroyAnimProxy,this)},_destroyAnimProxy:function(){se(this._proxy),this.off("load moveend",this._animMoveEnd,this),delete this._proxy},_animMoveEnd:function(){var t=this.getCenter(),e=this.getZoom();_e(this._proxy,this.project(t,e),this.getZoomScale(e,1))},_catchTransitionEnd:function(t){this._animatingZoom&&t.propertyName.indexOf("transform")>=0&&this._onZoomTransitionEnd()},_nothingToAnimate:function(){return!this._container.getElementsByClassName("leaflet-zoom-animated").length},_tryAnimatedZoom:function(t,e,i){if(this._animatingZoom)return!0;if(i=i||{},!this._zoomAnimated||!1===i.animate||this._nothingToAnimate()||Math.abs(e-this._zoom)>this.options.zoomAnimationThreshold)return!1;var n=this.getZoomScale(e),r=this._getCenterOffset(t)._divideBy(1-1/n);return!(!0!==i.animate&&!this.getSize().contains(r)||(k((function(){this._moveStart(!0,i.noMoveStart||!1)._animateZoom(t,e,!0)}),this),0))},_animateZoom:function(t,e,i,r){this._mapPane&&(i&&(this._animatingZoom=!0,this._animateToCenter=t,this._animateToZoom=e,ue(this._mapPane,"leaflet-zoom-anim")),this.fire("zoomanim",{center:t,zoom:e,noUpdate:r}),this._tempFireZoomEvent||(this._tempFireZoomEvent=this._zoom!==this._animateToZoom),this._move(this._animateToCenter,this._animateToZoom,void 0,!0),setTimeout(n(this._onZoomTransitionEnd,this),250))},_onZoomTransitionEnd:function(){this._animatingZoom&&(this._mapPane&&de(this._mapPane,"leaflet-zoom-anim"),this._animatingZoom=!1,this._move(this._animateToCenter,this._animateToZoom,void 0,!0),this._tempFireZoomEvent&&this.fire("zoom"),delete this._tempFireZoomEvent,this.fire("move"),this._moveEnd(!0))}});var Ke=P.extend({options:{position:"topright"},initialize:function(t){d(this,t)},getPosition:function(){return this.options.position},setPosition:function(t){var e=this._map;return e&&e.removeControl(this),this.options.position=t,e&&e.addControl(this),this},getContainer:function(){return this._container},addTo:function(t){this.remove(),this._map=t;var e=this._container=this.onAdd(t),i=this.getPosition(),n=t._controlCorners[i];return ue(e,"leaflet-control"),-1!==i.indexOf("bottom")?n.insertBefore(e,n.firstChild):n.appendChild(e),this._map.on("unload",this.remove,this),this},remove:function(){return this._map?(se(this._container),this.onRemove&&this.onRemove(this._map),this._map.off("unload",this.remove,this),this._map=null,this):this},_refocusOnMap:function(t){this._map&&t&&t.screenX>0&&t.screenY>0&&this._map.getContainer().focus()}}),Ye=function(t){return new Ke(t)};We.include({addControl:function(t){return t.addTo(this),this},removeControl:function(t){return t.remove(),this},_initControlPos:function(){var t=this._controlCorners={},e="leaflet-",i=this._controlContainer=oe("div",e+"control-container",this._container);function n(n,r){var o=e+n+" "+e+r;t[n+r]=oe("div",o,i)}n("top","left"),n("top","right"),n("bottom","left"),n("bottom","right")},_clearControlPos:function(){for(var t in this._controlCorners)se(this._controlCorners[t]);se(this._controlContainer),delete this._controlCorners,delete this._controlContainer}});var Xe=Ke.extend({options:{collapsed:!0,position:"topright",autoZIndex:!0,hideSingleBase:!1,sortLayers:!1,sortFunction:function(t,e,i,n){return i<n?-1:n<i?1:0}},initialize:function(t,e,i){for(var n in d(this,i),this._layerControlInputs=[],this._layers=[],this._lastZIndex=0,this._handlingClick=!1,this._preventClick=!1,t)this._addLayer(t[n],n);for(n in e)this._addLayer(e[n],n,!0)},onAdd:function(t){this._initLayout(),this._update(),this._map=t,t.on("zoomend",this._checkDisabledLayers,this);for(var e=0;e<this._layers.length;e++)this._layers[e].layer.on("add remove",this._onLayerChange,this);return this._container},addTo:function(t){return Ke.prototype.addTo.call(this,t),this._expandIfNotCollapsed()},onRemove:function(){this._map.off("zoomend",this._checkDisabledLayers,this);for(var t=0;t<this._layers.length;t++)this._layers[t].layer.off("add remove",this._onLayerChange,this)},addBaseLayer:function(t,e){return this._addLayer(t,e),this._map?this._update():this},addOverlay:function(t,e){return this._addLayer(t,e,!0),this._map?this._update():this},removeLayer:function(t){t.off("add remove",this._onLayerChange,this);var e=this._getLayer(o(t));return e&&this._layers.splice(this._layers.indexOf(e),1),this._map?this._update():this},expand:function(){ue(this._container,"leaflet-control-layers-expanded"),this._section.style.height=null;var t=this._map.getSize().y-(this._container.offsetTop+50);return t<this._section.clientHeight?(ue(this._section,"leaflet-control-layers-scrollbar"),this._section.style.height=t+"px"):de(this._section,"leaflet-control-layers-scrollbar"),this._checkDisabledLayers(),this},collapse:function(){return de(this._container,"leaflet-control-layers-expanded"),this},_initLayout:function(){var t="leaflet-control-layers",e=this._container=oe("div",t),i=this.options.collapsed;e.setAttribute("aria-haspopup",!0),Re(e),Oe(e);var n=this._section=oe("section",t+"-list");i&&(this._map.on("click",this.collapse,this),Pe(e,{mouseenter:this._expandSafely,mouseleave:this.collapse},this));var r=this._layersLink=oe("a",t+"-toggle",e);r.href="#",r.title="Layers",r.setAttribute("role","button"),Pe(r,{keydown:function(t){13===t.keyCode&&this._expandSafely()},click:function(t){je(t),this._expandSafely()}},this),i||this.expand(),this._baseLayersList=oe("div",t+"-base",n),this._separator=oe("div",t+"-separator",n),this._overlaysList=oe("div",t+"-overlays",n),e.appendChild(n)},_getLayer:function(t){for(var e=0;e<this._layers.length;e++)if(this._layers[e]&&o(this._layers[e].layer)===t)return this._layers[e]},_addLayer:function(t,e,i){this._map&&t.on("add remove",this._onLayerChange,this),this._layers.push({layer:t,name:e,overlay:i}),this.options.sortLayers&&this._layers.sort(n((function(t,e){return this.options.sortFunction(t.layer,e.layer,t.name,e.name)}),this)),this.options.autoZIndex&&t.setZIndex&&(this._lastZIndex++,t.setZIndex(this._lastZIndex)),this._expandIfNotCollapsed()},_update:function(){if(!this._container)return this;ae(this._baseLayersList),ae(this._overlaysList),this._layerControlInputs=[];var t,e,i,n,r=0;for(i=0;i<this._layers.length;i++)n=this._layers[i],this._addItem(n),e=e||n.overlay,t=t||!n.overlay,r+=n.overlay?0:1;return this.options.hideSingleBase&&(t=t&&r>1,this._baseLayersList.style.display=t?"":"none"),this._separator.style.display=e&&t?"":"none",this},_onLayerChange:function(t){this._handlingClick||this._update();var e=this._getLayer(o(t.target)),i=e.overlay?"add"===t.type?"overlayadd":"overlayremove":"add"===t.type?"baselayerchange":null;i&&this._map.fire(i,e)},_createRadioElement:function(t,e){var i='<input type="radio" class="leaflet-control-layers-selector" name="'+t+'"'+(e?' checked="checked"':"")+"/>",n=document.createElement("div");return n.innerHTML=i,n.firstChild},_addItem:function(t){var e,i=document.createElement("label"),n=this._map.hasLayer(t.layer);t.overlay?((e=document.createElement("input")).type="checkbox",e.className="leaflet-control-layers-selector",e.defaultChecked=n):e=this._createRadioElement("leaflet-base-layers_"+o(this),n),this._layerControlInputs.push(e),e.layerId=o(t.layer),Pe(e,"click",this._onInputClick,this);var r=document.createElement("span");r.innerHTML=" "+t.name;var s=document.createElement("span");return i.appendChild(s),s.appendChild(e),s.appendChild(r),(t.overlay?this._overlaysList:this._baseLayersList).appendChild(i),this._checkDisabledLayers(),i},_onInputClick:function(){if(!this._preventClick){var t,e,i=this._layerControlInputs,n=[],r=[];this._handlingClick=!0;for(var o=i.length-1;o>=0;o--)t=i[o],e=this._getLayer(t.layerId).layer,t.checked?n.push(e):t.checked||r.push(e);for(o=0;o<r.length;o++)this._map.hasLayer(r[o])&&this._map.removeLayer(r[o]);for(o=0;o<n.length;o++)this._map.hasLayer(n[o])||this._map.addLayer(n[o]);this._handlingClick=!1,this._refocusOnMap()}},_checkDisabledLayers:function(){for(var t,e,i=this._layerControlInputs,n=this._map.getZoom(),r=i.length-1;r>=0;r--)t=i[r],e=this._getLayer(t.layerId).layer,t.disabled=void 0!==e.options.minZoom&&n<e.options.minZoom||void 0!==e.options.maxZoom&&n>e.options.maxZoom},_expandIfNotCollapsed:function(){return this._map&&!this.options.collapsed&&this.expand(),this},_expandSafely:function(){var t=this._section;this._preventClick=!0,Pe(t,"click",je),this.expand();var e=this;setTimeout((function(){Ee(t,"click",je),e._preventClick=!1}))}}),Je=Ke.extend({options:{position:"topleft",zoomInText:'<span aria-hidden="true">+</span>',zoomInTitle:"Zoom in",zoomOutText:'<span aria-hidden="true">&#x2212;</span>',zoomOutTitle:"Zoom out"},onAdd:function(t){var e="leaflet-control-zoom",i=oe("div",e+" leaflet-bar"),n=this.options;return this._zoomInButton=this._createButton(n.zoomInText,n.zoomInTitle,e+"-in",i,this._zoomIn),this._zoomOutButton=this._createButton(n.zoomOutText,n.zoomOutTitle,e+"-out",i,this._zoomOut),this._updateDisabled(),t.on("zoomend zoomlevelschange",this._updateDisabled,this),i},onRemove:function(t){t.off("zoomend zoomlevelschange",this._updateDisabled,this)},disable:function(){return this._disabled=!0,this._updateDisabled(),this},enable:function(){return this._disabled=!1,this._updateDisabled(),this},_zoomIn:function(t){!this._disabled&&this._map._zoom<this._map.getMaxZoom()&&this._map.zoomIn(this._map.options.zoomDelta*(t.shiftKey?3:1))},_zoomOut:function(t){!this._disabled&&this._map._zoom>this._map.getMinZoom()&&this._map.zoomOut(this._map.options.zoomDelta*(t.shiftKey?3:1))},_createButton:function(t,e,i,n,r){var o=oe("a",i,n);return o.innerHTML=t,o.href="#",o.title=e,o.setAttribute("role","button"),o.setAttribute("aria-label",e),Re(o),Pe(o,"click",Ne),Pe(o,"click",r,this),Pe(o,"click",this._refocusOnMap,this),o},_updateDisabled:function(){var t=this._map,e="leaflet-disabled";de(this._zoomInButton,e),de(this._zoomOutButton,e),this._zoomInButton.setAttribute("aria-disabled","false"),this._zoomOutButton.setAttribute("aria-disabled","false"),(this._disabled||t._zoom===t.getMinZoom())&&(ue(this._zoomOutButton,e),this._zoomOutButton.setAttribute("aria-disabled","true")),(this._disabled||t._zoom===t.getMaxZoom())&&(ue(this._zoomInButton,e),this._zoomInButton.setAttribute("aria-disabled","true"))}});We.mergeOptions({zoomControl:!0}),We.addInitHook((function(){this.options.zoomControl&&(this.zoomControl=new Je,this.addControl(this.zoomControl))}));var Qe=Ke.extend({options:{position:"bottomleft",maxWidth:100,metric:!0,imperial:!0},onAdd:function(t){var e="leaflet-control-scale",i=oe("div",e),n=this.options;return this._addScales(n,e+"-line",i),t.on(n.updateWhenIdle?"moveend":"move",this._update,this),t.whenReady(this._update,this),i},onRemove:function(t){t.off(this.options.updateWhenIdle?"moveend":"move",this._update,this)},_addScales:function(t,e,i){t.metric&&(this._mScale=oe("div",e,i)),t.imperial&&(this._iScale=oe("div",e,i))},_update:function(){var t=this._map,e=t.getSize().y/2,i=t.distance(t.containerPointToLatLng([0,e]),t.containerPointToLatLng([this.options.maxWidth,e]));this._updateScales(i)},_updateScales:function(t){this.options.metric&&t&&this._updateMetric(t),this.options.imperial&&t&&this._updateImperial(t)},_updateMetric:function(t){var e=this._getRoundNum(t),i=e<1e3?e+" m":e/1e3+" km";this._updateScale(this._mScale,i,e/t)},_updateImperial:function(t){var e,i,n,r=3.2808399*t;r>5280?(e=r/5280,i=this._getRoundNum(e),this._updateScale(this._iScale,i+" mi",i/e)):(n=this._getRoundNum(r),this._updateScale(this._iScale,n+" ft",n/r))},_updateScale:function(t,e,i){t.style.width=Math.round(this.options.maxWidth*i)+"px",t.innerHTML=e},_getRoundNum:function(t){var e=Math.pow(10,(Math.floor(t)+"").length-1),i=t/e;return e*(i>=10?10:i>=5?5:i>=3?3:i>=2?2:1)}}),$e=Ke.extend({options:{position:"bottomright",prefix:'<a href="https://leafletjs.com" title="A JavaScript library for interactive maps">'+(zt.inlineSvg?'<svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="12" height="8" viewBox="0 0 12 8" class="leaflet-attribution-flag"><path fill="#4C7BE1" d="M0 0h12v4H0z"/><path fill="#FFD500" d="M0 4h12v3H0z"/><path fill="#E0BC00" d="M0 7h12v1H0z"/></svg> ':"")+"Leaflet</a>"},initialize:function(t){d(this,t),this._attributions={}},onAdd:function(t){for(var e in t.attributionControl=this,this._container=oe("div","leaflet-control-attribution"),Re(this._container),t._layers)t._layers[e].getAttribution&&this.addAttribution(t._layers[e].getAttribution());return this._update(),t.on("layeradd",this._addAttribution,this),this._container},onRemove:function(t){t.off("layeradd",this._addAttribution,this)},_addAttribution:function(t){t.layer.getAttribution&&(this.addAttribution(t.layer.getAttribution()),t.layer.once("remove",(function(){this.removeAttribution(t.layer.getAttribution())}),this))},setPrefix:function(t){return this.options.prefix=t,this._update(),this},addAttribution:function(t){return t?(this._attributions[t]||(this._attributions[t]=0),this._attributions[t]++,this._update(),this):this},removeAttribution:function(t){return t?(this._attributions[t]&&(this._attributions[t]--,this._update()),this):this},_update:function(){if(this._map){var t=[];for(var e in this._attributions)this._attributions[e]&&t.push(e);var i=[];this.options.prefix&&i.push(this.options.prefix),t.length&&i.push(t.join(", ")),this._container.innerHTML=i.join(' <span aria-hidden="true">|</span> ')}}});We.mergeOptions({attributionControl:!0}),We.addInitHook((function(){this.options.attributionControl&&(new $e).addTo(this)}));Ke.Layers=Xe,Ke.Zoom=Je,Ke.Scale=Qe,Ke.Attribution=$e,Ye.layers=function(t,e,i){return new Xe(t,e,i)},Ye.zoom=function(t){return new Je(t)},Ye.scale=function(t){return new Qe(t)},Ye.attribution=function(t){return new $e(t)};var ti=P.extend({initialize:function(t){this._map=t},enable:function(){return this._enabled||(this._enabled=!0,this.addHooks()),this},disable:function(){return this._enabled?(this._enabled=!1,this.removeHooks(),this):this},enabled:function(){return!!this._enabled}});ti.addTo=function(t,e){return t.addHandler(e,this),this};var ei={Events:S},ii=zt.touch?"touchstart mousedown":"mousedown",ni=E.extend({options:{clickTolerance:3},initialize:function(t,e,i,n){d(this,n),this._element=t,this._dragStartTarget=e||t,this._preventOutline=i},enable:function(){this._enabled||(Pe(this._dragStartTarget,ii,this._onDown,this),this._enabled=!0)},disable:function(){this._enabled&&(ni._dragging===this&&this.finishDrag(!0),Ee(this._dragStartTarget,ii,this._onDown,this),this._enabled=!1,this._moved=!1)},_onDown:function(t){if(this._enabled&&(this._moved=!1,!ce(this._element,"leaflet-zoom-anim")))if(t.touches&&1!==t.touches.length)ni._dragging===this&&this.finishDrag();else if(!(ni._dragging||t.shiftKey||1!==t.which&&1!==t.button&&!t.touches||(ni._dragging=this,this._preventOutline&&Le(this._element),xe(),Yt(),this._moving))){this.fire("down");var e=t.touches?t.touches[0]:t,i=ke(this._element);this._startPoint=new I(e.clientX,e.clientY),this._startPos=ve(this._element),this._parentScale=Ce(i);var n="mousedown"===t.type;Pe(document,n?"mousemove":"touchmove",this._onMove,this),Pe(document,n?"mouseup":"touchend touchcancel",this._onUp,this)}},_onMove:function(t){if(this._enabled)if(t.touches&&t.touches.length>1)this._moved=!0;else{var e=t.touches&&1===t.touches.length?t.touches[0]:t,i=new I(e.clientX,e.clientY)._subtract(this._startPoint);(i.x||i.y)&&(Math.abs(i.x)+Math.abs(i.y)<this.options.clickTolerance||(i.x/=this._parentScale.x,i.y/=this._parentScale.y,je(t),this._moved||(this.fire("dragstart"),this._moved=!0,ue(document.body,"leaflet-dragging"),this._lastTarget=t.target||t.srcElement,window.SVGElementInstance&&this._lastTarget instanceof window.SVGElementInstance&&(this._lastTarget=this._lastTarget.correspondingUseElement),ue(this._lastTarget,"leaflet-drag-target")),this._newPos=this._startPos.add(i),this._moving=!0,this._lastEvent=t,this._updatePosition()))}},_updatePosition:function(){var t={originalEvent:this._lastEvent};this.fire("predrag",t),ye(this._element,this._newPos),this.fire("drag",t)},_onUp:function(){this._enabled&&this.finishDrag()},finishDrag:function(t){de(document.body,"leaflet-dragging"),this._lastTarget&&(de(this._lastTarget,"leaflet-drag-target"),this._lastTarget=null),Ee(document,"mousemove touchmove",this._onMove,this),Ee(document,"mouseup touchend touchcancel",this._onUp,this),we(),Xt();var e=this._moved&&this._moving;this._moving=!1,ni._dragging=!1,e&&this.fire("dragend",{noInertia:t,distance:this._newPos.distanceTo(this._startPos)})}});function ri(t,e,i){var n,r,o,s,a,l,h,c,u,d=[1,4,2,8];for(r=0,h=t.length;r<h;r++)t[r]._code=fi(t[r],e);for(s=0;s<4;s++){for(c=d[s],n=[],r=0,o=(h=t.length)-1;r<h;o=r++)a=t[r],l=t[o],a._code&c?l._code&c||((u=pi(l,a,c,e,i))._code=fi(u,e),n.push(u)):(l._code&c&&((u=pi(l,a,c,e,i))._code=fi(u,e),n.push(u)),n.push(a));t=n}return t}function oi(t,e){var i,n,r,o,s,a,l,h,c;if(!t||0===t.length)throw new Error("latlngs not passed");_i(t)||(console.warn("latlngs are not flat! Only the first ring will be used"),t=t[0]);var u=N([0,0]),d=R(t);d.getNorthWest().distanceTo(d.getSouthWest())*d.getNorthEast().distanceTo(d.getNorthWest())<1700&&(u=si(t));var p=t.length,f=[];for(i=0;i<p;i++){var m=N(t[i]);f.push(e.project(N([m.lat-u.lat,m.lng-u.lng])))}for(a=l=h=0,i=0,n=p-1;i<p;n=i++)r=f[i],o=f[n],s=r.y*o.x-o.y*r.x,l+=(r.x+o.x)*s,h+=(r.y+o.y)*s,a+=3*s;c=0===a?f[0]:[l/a,h/a];var g=e.unproject(D(c));return N([g.lat+u.lat,g.lng+u.lng])}function si(t){for(var e=0,i=0,n=0,r=0;r<t.length;r++){var o=N(t[r]);e+=o.lat,i+=o.lng,n++}return N([e/n,i/n])}var ai,li={__proto__:null,clipPolygon:ri,polygonCenter:oi,centroid:si};function hi(t,e){if(!e||!t.length)return t.slice();var i=e*e;return function(t,e){var i=t.length,n=new(typeof Uint8Array!=void 0+""?Uint8Array:Array)(i);n[0]=n[i-1]=1,ui(t,n,e,0,i-1);var r,o=[];for(r=0;r<i;r++)n[r]&&o.push(t[r]);return o}(t=function(t,e){for(var i=[t[0]],n=1,r=0,o=t.length;n<o;n++)mi(t[n],t[r])>e&&(i.push(t[n]),r=n);return r<o-1&&i.push(t[o-1]),i}(t,i),i)}function ci(t,e,i){return Math.sqrt(gi(t,e,i,!0))}function ui(t,e,i,n,r){var o,s,a,l=0;for(s=n+1;s<=r-1;s++)(a=gi(t[s],t[n],t[r],!0))>l&&(o=s,l=a);l>i&&(e[o]=1,ui(t,e,i,n,o),ui(t,e,i,o,r))}function di(t,e,i,n,r){var o,s,a,l=n?ai:fi(t,i),h=fi(e,i);for(ai=h;;){if(!(l|h))return[t,e];if(l&h)return!1;a=fi(s=pi(t,e,o=l||h,i,r),i),o===l?(t=s,l=a):(e=s,h=a)}}function pi(t,e,i,n,r){var o,s,a=e.x-t.x,l=e.y-t.y,h=n.min,c=n.max;return 8&i?(o=t.x+a*(c.y-t.y)/l,s=c.y):4&i?(o=t.x+a*(h.y-t.y)/l,s=h.y):2&i?(o=c.x,s=t.y+l*(c.x-t.x)/a):1&i&&(o=h.x,s=t.y+l*(h.x-t.x)/a),new I(o,s,r)}function fi(t,e){var i=0;return t.x<e.min.x?i|=1:t.x>e.max.x&&(i|=2),t.y<e.min.y?i|=4:t.y>e.max.y&&(i|=8),i}function mi(t,e){var i=e.x-t.x,n=e.y-t.y;return i*i+n*n}function gi(t,e,i,n){var r,o=e.x,s=e.y,a=i.x-o,l=i.y-s,h=a*a+l*l;return h>0&&((r=((t.x-o)*a+(t.y-s)*l)/h)>1?(o=i.x,s=i.y):r>0&&(o+=a*r,s+=l*r)),a=t.x-o,l=t.y-s,n?a*a+l*l:new I(o,s)}function _i(t){return!g(t[0])||"object"!=typeof t[0][0]&&void 0!==t[0][0]}function yi(t){return console.warn("Deprecated use of _flat, please use L.LineUtil.isFlat instead."),_i(t)}function vi(t,e){var i,n,r,o,s,a,l,h;if(!t||0===t.length)throw new Error("latlngs not passed");_i(t)||(console.warn("latlngs are not flat! Only the first ring will be used"),t=t[0]);var c=N([0,0]),u=R(t);u.getNorthWest().distanceTo(u.getSouthWest())*u.getNorthEast().distanceTo(u.getNorthWest())<1700&&(c=si(t));var d=t.length,p=[];for(i=0;i<d;i++){var f=N(t[i]);p.push(e.project(N([f.lat-c.lat,f.lng-c.lng])))}for(i=0,n=0;i<d-1;i++)n+=p[i].distanceTo(p[i+1])/2;if(0===n)h=p[0];else for(i=0,o=0;i<d-1;i++)if(s=p[i],a=p[i+1],(o+=r=s.distanceTo(a))>n){l=(o-n)/r,h=[a.x-l*(a.x-s.x),a.y-l*(a.y-s.y)];break}var m=e.unproject(D(h));return N([m.lat+c.lat,m.lng+c.lng])}var bi={__proto__:null,simplify:hi,pointToSegmentDistance:ci,closestPointOnSegment:function(t,e,i){return gi(t,e,i)},clipSegment:di,_getEdgeIntersection:pi,_getBitCode:fi,_sqClosestPointOnSegment:gi,isFlat:_i,_flat:yi,polylineCenter:vi},xi={project:function(t){return new I(t.lng,t.lat)},unproject:function(t){return new j(t.y,t.x)},bounds:new z([-180,-90],[180,90])},wi={R:6378137,R_MINOR:6356752.314245179,bounds:new z([-20037508.34279,-15496570.73972],[20037508.34279,18764656.23138]),project:function(t){var e=Math.PI/180,i=this.R,n=t.lat*e,r=this.R_MINOR/i,o=Math.sqrt(1-r*r),s=o*Math.sin(n),a=Math.tan(Math.PI/4-n/2)/Math.pow((1-s)/(1+s),o/2);return n=-i*Math.log(Math.max(a,1e-10)),new I(t.lng*e*i,n)},unproject:function(t){for(var e,i=180/Math.PI,n=this.R,r=this.R_MINOR/n,o=Math.sqrt(1-r*r),s=Math.exp(-t.y/n),a=Math.PI/2-2*Math.atan(s),l=0,h=.1;l<15&&Math.abs(h)>1e-7;l++)e=o*Math.sin(a),e=Math.pow((1-e)/(1+e),o/2),a+=h=Math.PI/2-2*Math.atan(s*e)-a;return new j(a*i,t.x*i/n)}},Li={__proto__:null,LonLat:xi,Mercator:wi,SphericalMercator:V},Mi=e({},U,{code:"EPSG:3395",projection:wi,transformation:function(){var t=.5/(Math.PI*wi.R);return q(t,.5,-t,.5)}()}),ki=e({},U,{code:"EPSG:4326",projection:xi,transformation:q(1/180,1,-1/180,.5)}),Ci=e({},G,{projection:xi,transformation:q(1,0,-1,0),scale:function(t){return Math.pow(2,t)},zoom:function(t){return Math.log(t)/Math.LN2},distance:function(t,e){var i=e.lng-t.lng,n=e.lat-t.lat;return Math.sqrt(i*i+n*n)},infinite:!0});G.Earth=U,G.EPSG3395=Mi,G.EPSG3857=W,G.EPSG900913=K,G.EPSG4326=ki,G.Simple=Ci;var Ai=E.extend({options:{pane:"overlayPane",attribution:null,bubblingMouseEvents:!0},addTo:function(t){return t.addLayer(this),this},remove:function(){return this.removeFrom(this._map||this._mapToAdd)},removeFrom:function(t){return t&&t.removeLayer(this),this},getPane:function(t){return this._map.getPane(t?this.options[t]||t:this.options.pane)},addInteractiveTarget:function(t){return this._map._targets[o(t)]=this,this},removeInteractiveTarget:function(t){return delete this._map._targets[o(t)],this},getAttribution:function(){return this.options.attribution},_layerAdd:function(t){var e=t.target;if(e.hasLayer(this)){if(this._map=e,this._zoomAnimated=e._zoomAnimated,this.getEvents){var i=this.getEvents();e.on(i,this),this.once("remove",(function(){e.off(i,this)}),this)}this.onAdd(e),this.fire("add"),e.fire("layeradd",{layer:this})}}});We.include({addLayer:function(t){if(!t._layerAdd)throw new Error("The provided object is not a Layer.");var e=o(t);return this._layers[e]||(this._layers[e]=t,t._mapToAdd=this,t.beforeAdd&&t.beforeAdd(this),this.whenReady(t._layerAdd,t)),this},removeLayer:function(t){var e=o(t);return this._layers[e]?(this._loaded&&t.onRemove(this),delete this._layers[e],this._loaded&&(this.fire("layerremove",{layer:t}),t.fire("remove")),t._map=t._mapToAdd=null,this):this},hasLayer:function(t){return o(t)in this._layers},eachLayer:function(t,e){for(var i in this._layers)t.call(e,this._layers[i]);return this},_addLayers:function(t){for(var e=0,i=(t=t?g(t)?t:[t]:[]).length;e<i;e++)this.addLayer(t[e])},_addZoomLimit:function(t){isNaN(t.options.maxZoom)&&isNaN(t.options.minZoom)||(this._zoomBoundLayers[o(t)]=t,this._updateZoomLevels())},_removeZoomLimit:function(t){var e=o(t);this._zoomBoundLayers[e]&&(delete this._zoomBoundLayers[e],this._updateZoomLevels())},_updateZoomLevels:function(){var t=1/0,e=-1/0,i=this._getZoomSpan();for(var n in this._zoomBoundLayers){var r=this._zoomBoundLayers[n].options;t=void 0===r.minZoom?t:Math.min(t,r.minZoom),e=void 0===r.maxZoom?e:Math.max(e,r.maxZoom)}this._layersMaxZoom=e===-1/0?void 0:e,this._layersMinZoom=t===1/0?void 0:t,i!==this._getZoomSpan()&&this.fire("zoomlevelschange"),void 0===this.options.maxZoom&&this._layersMaxZoom&&this.getZoom()>this._layersMaxZoom&&this.setZoom(this._layersMaxZoom),void 0===this.options.minZoom&&this._layersMinZoom&&this.getZoom()<this._layersMinZoom&&this.setZoom(this._layersMinZoom)}});var Pi=Ai.extend({initialize:function(t,e){var i,n;if(d(this,e),this._layers={},t)for(i=0,n=t.length;i<n;i++)this.addLayer(t[i])},addLayer:function(t){var e=this.getLayerId(t);return this._layers[e]=t,this._map&&this._map.addLayer(t),this},removeLayer:function(t){var e=t in this._layers?t:this.getLayerId(t);return this._map&&this._layers[e]&&this._map.removeLayer(this._layers[e]),delete this._layers[e],this},hasLayer:function(t){return("number"==typeof t?t:this.getLayerId(t))in this._layers},clearLayers:function(){return this.eachLayer(this.removeLayer,this)},invoke:function(t){var e,i,n=Array.prototype.slice.call(arguments,1);for(e in this._layers)(i=this._layers[e])[t]&&i[t].apply(i,n);return this},onAdd:function(t){this.eachLayer(t.addLayer,t)},onRemove:function(t){this.eachLayer(t.removeLayer,t)},eachLayer:function(t,e){for(var i in this._layers)t.call(e,this._layers[i]);return this},getLayer:function(t){return this._layers[t]},getLayers:function(){var t=[];return this.eachLayer(t.push,t),t},setZIndex:function(t){return this.invoke("setZIndex",t)},getLayerId:function(t){return o(t)}}),Si=Pi.extend({addLayer:function(t){return this.hasLayer(t)?this:(t.addEventParent(this),Pi.prototype.addLayer.call(this,t),this.fire("layeradd",{layer:t}))},removeLayer:function(t){return this.hasLayer(t)?(t in this._layers&&(t=this._layers[t]),t.removeEventParent(this),Pi.prototype.removeLayer.call(this,t),this.fire("layerremove",{layer:t})):this},setStyle:function(t){return this.invoke("setStyle",t)},bringToFront:function(){return this.invoke("bringToFront")},bringToBack:function(){return this.invoke("bringToBack")},getBounds:function(){var t=new O;for(var e in this._layers){var i=this._layers[e];t.extend(i.getBounds?i.getBounds():i.getLatLng())}return t}}),Ei=P.extend({options:{popupAnchor:[0,0],tooltipAnchor:[0,0],crossOrigin:!1},initialize:function(t){d(this,t)},createIcon:function(t){return this._createIcon("icon",t)},createShadow:function(t){return this._createIcon("shadow",t)},_createIcon:function(t,e){var i=this._getIconUrl(t);if(!i){if("icon"===t)throw new Error("iconUrl not set in Icon options (see the docs).");return null}var n=this._createImg(i,e&&"IMG"===e.tagName?e:null);return this._setIconStyles(n,t),(this.options.crossOrigin||""===this.options.crossOrigin)&&(n.crossOrigin=!0===this.options.crossOrigin?"":this.options.crossOrigin),n},_setIconStyles:function(t,e){var i=this.options,n=i[e+"Size"];"number"==typeof n&&(n=[n,n]);var r=D(n),o=D("shadow"===e&&i.shadowAnchor||i.iconAnchor||r&&r.divideBy(2,!0));t.className="leaflet-marker-"+e+" "+(i.className||""),o&&(t.style.marginLeft=-o.x+"px",t.style.marginTop=-o.y+"px"),r&&(t.style.width=r.x+"px",t.style.height=r.y+"px")},_createImg:function(t,e){return(e=e||document.createElement("img")).src=t,e},_getIconUrl:function(t){return zt.retina&&this.options[t+"RetinaUrl"]||this.options[t+"Url"]}});var Ii=Ei.extend({options:{iconUrl:"marker-icon.png",iconRetinaUrl:"marker-icon-2x.png",shadowUrl:"marker-shadow.png",iconSize:[25,41],iconAnchor:[12,41],popupAnchor:[1,-34],tooltipAnchor:[16,-28],shadowSize:[41,41]},_getIconUrl:function(t){return"string"!=typeof Ii.imagePath&&(Ii.imagePath=this._detectIconPath()),(this.options.imagePath||Ii.imagePath)+Ei.prototype._getIconUrl.call(this,t)},_stripUrl:function(t){var e=function(t,e,i){var n=e.exec(t);return n&&n[i]};return(t=e(t,/^url\((['"])?(.+)\1\)$/,2))&&e(t,/^(.*)marker-icon\.png$/,1)},_detectIconPath:function(){var t=oe("div","leaflet-default-icon-path",document.body),e=re(t,"background-image")||re(t,"backgroundImage");if(document.body.removeChild(t),e=this._stripUrl(e))return e;var i=document.querySelector('link[href$="leaflet.css"]');return i?i.href.substring(0,i.href.length-11-1):""}}),Ti=ti.extend({initialize:function(t){this._marker=t},addHooks:function(){var t=this._marker._icon;this._draggable||(this._draggable=new ni(t,t,!0)),this._draggable.on({dragstart:this._onDragStart,predrag:this._onPreDrag,drag:this._onDrag,dragend:this._onDragEnd},this).enable(),ue(t,"leaflet-marker-draggable")},removeHooks:function(){this._draggable.off({dragstart:this._onDragStart,predrag:this._onPreDrag,drag:this._onDrag,dragend:this._onDragEnd},this).disable(),this._marker._icon&&de(this._marker._icon,"leaflet-marker-draggable")},moved:function(){return this._draggable&&this._draggable._moved},_adjustPan:function(t){var e=this._marker,i=e._map,n=this._marker.options.autoPanSpeed,r=this._marker.options.autoPanPadding,o=ve(e._icon),s=i.getPixelBounds(),a=i.getPixelOrigin(),l=B(s.min._subtract(a).add(r),s.max._subtract(a).subtract(r));if(!l.contains(o)){var h=D((Math.max(l.max.x,o.x)-l.max.x)/(s.max.x-l.max.x)-(Math.min(l.min.x,o.x)-l.min.x)/(s.min.x-l.min.x),(Math.max(l.max.y,o.y)-l.max.y)/(s.max.y-l.max.y)-(Math.min(l.min.y,o.y)-l.min.y)/(s.min.y-l.min.y)).multiplyBy(n);i.panBy(h,{animate:!1}),this._draggable._newPos._add(h),this._draggable._startPos._add(h),ye(e._icon,this._draggable._newPos),this._onDrag(t),this._panRequest=k(this._adjustPan.bind(this,t))}},_onDragStart:function(){this._oldLatLng=this._marker.getLatLng(),this._marker.closePopup&&this._marker.closePopup(),this._marker.fire("movestart").fire("dragstart")},_onPreDrag:function(t){this._marker.options.autoPan&&(C(this._panRequest),this._panRequest=k(this._adjustPan.bind(this,t)))},_onDrag:function(t){var e=this._marker,i=e._shadow,n=ve(e._icon),r=e._map.layerPointToLatLng(n);i&&ye(i,n),e._latlng=r,t.latlng=r,t.oldLatLng=this._oldLatLng,e.fire("move",t).fire("drag",t)},_onDragEnd:function(t){C(this._panRequest),delete this._oldLatLng,this._marker.fire("moveend").fire("dragend",t)}}),Di=Ai.extend({options:{icon:new Ii,interactive:!0,keyboard:!0,title:"",alt:"Marker",zIndexOffset:0,opacity:1,riseOnHover:!1,riseOffset:250,pane:"markerPane",shadowPane:"shadowPane",bubblingMouseEvents:!1,autoPanOnFocus:!0,draggable:!1,autoPan:!1,autoPanPadding:[50,50],autoPanSpeed:10},initialize:function(t,e){d(this,e),this._latlng=N(t)},onAdd:function(t){this._zoomAnimated=this._zoomAnimated&&t.options.markerZoomAnimation,this._zoomAnimated&&t.on("zoomanim",this._animateZoom,this),this._initIcon(),this.update()},onRemove:function(t){this.dragging&&this.dragging.enabled()&&(this.options.draggable=!0,this.dragging.removeHooks()),delete this.dragging,this._zoomAnimated&&t.off("zoomanim",this._animateZoom,this),this._removeIcon(),this._removeShadow()},getEvents:function(){return{zoom:this.update,viewreset:this.update}},getLatLng:function(){return this._latlng},setLatLng:function(t){var e=this._latlng;return this._latlng=N(t),this.update(),this.fire("move",{oldLatLng:e,latlng:this._latlng})},setZIndexOffset:function(t){return this.options.zIndexOffset=t,this.update()},getIcon:function(){return this.options.icon},setIcon:function(t){return this.options.icon=t,this._map&&(this._initIcon(),this.update()),this._popup&&this.bindPopup(this._popup,this._popup.options),this},getElement:function(){return this._icon},update:function(){if(this._icon&&this._map){var t=this._map.latLngToLayerPoint(this._latlng).round();this._setPos(t)}return this},_initIcon:function(){var t=this.options,e="leaflet-zoom-"+(this._zoomAnimated?"animated":"hide"),i=t.icon.createIcon(this._icon),n=!1;i!==this._icon&&(this._icon&&this._removeIcon(),n=!0,t.title&&(i.title=t.title),"IMG"===i.tagName&&(i.alt=t.alt||"")),ue(i,e),t.keyboard&&(i.tabIndex="0",i.setAttribute("role","button")),this._icon=i,t.riseOnHover&&this.on({mouseover:this._bringToFront,mouseout:this._resetZIndex}),this.options.autoPanOnFocus&&Pe(i,"focus",this._panOnFocus,this);var r=t.icon.createShadow(this._shadow),o=!1;r!==this._shadow&&(this._removeShadow(),o=!0),r&&(ue(r,e),r.alt=""),this._shadow=r,t.opacity<1&&this._updateOpacity(),n&&this.getPane().appendChild(this._icon),this._initInteraction(),r&&o&&this.getPane(t.shadowPane).appendChild(this._shadow)},_removeIcon:function(){this.options.riseOnHover&&this.off({mouseover:this._bringToFront,mouseout:this._resetZIndex}),this.options.autoPanOnFocus&&Ee(this._icon,"focus",this._panOnFocus,this),se(this._icon),this.removeInteractiveTarget(this._icon),this._icon=null},_removeShadow:function(){this._shadow&&se(this._shadow),this._shadow=null},_setPos:function(t){this._icon&&ye(this._icon,t),this._shadow&&ye(this._shadow,t),this._zIndex=t.y+this.options.zIndexOffset,this._resetZIndex()},_updateZIndex:function(t){this._icon&&(this._icon.style.zIndex=this._zIndex+t)},_animateZoom:function(t){var e=this._map._latLngToNewLayerPoint(this._latlng,t.zoom,t.center).round();this._setPos(e)},_initInteraction:function(){if(this.options.interactive&&(ue(this._icon,"leaflet-interactive"),this.addInteractiveTarget(this._icon),Ti)){var t=this.options.draggable;this.dragging&&(t=this.dragging.enabled(),this.dragging.disable()),this.dragging=new Ti(this),t&&this.dragging.enable()}},setOpacity:function(t){return this.options.opacity=t,this._map&&this._updateOpacity(),this},_updateOpacity:function(){var t=this.options.opacity;this._icon&&me(this._icon,t),this._shadow&&me(this._shadow,t)},_bringToFront:function(){this._updateZIndex(this.options.riseOffset)},_resetZIndex:function(){this._updateZIndex(0)},_panOnFocus:function(){var t=this._map;if(t){var e=this.options.icon.options,i=e.iconSize?D(e.iconSize):D(0,0),n=e.iconAnchor?D(e.iconAnchor):D(0,0);t.panInside(this._latlng,{paddingTopLeft:n,paddingBottomRight:i.subtract(n)})}},_getPopupAnchor:function(){return this.options.icon.options.popupAnchor},_getTooltipAnchor:function(){return this.options.icon.options.tooltipAnchor}});var zi=Ai.extend({options:{stroke:!0,color:"#3388ff",weight:3,opacity:1,lineCap:"round",lineJoin:"round",dashArray:null,dashOffset:null,fill:!1,fillColor:null,fillOpacity:.2,fillRule:"evenodd",interactive:!0,bubblingMouseEvents:!0},beforeAdd:function(t){this._renderer=t.getRenderer(this)},onAdd:function(){this._renderer._initPath(this),this._reset(),this._renderer._addPath(this)},onRemove:function(){this._renderer._removePath(this)},redraw:function(){return this._map&&this._renderer._updatePath(this),this},setStyle:function(t){return d(this,t),this._renderer&&(this._renderer._updateStyle(this),this.options.stroke&&t&&Object.prototype.hasOwnProperty.call(t,"weight")&&this._updateBounds()),this},bringToFront:function(){return this._renderer&&this._renderer._bringToFront(this),this},bringToBack:function(){return this._renderer&&this._renderer._bringToBack(this),this},getElement:function(){return this._path},_reset:function(){this._project(),this._update()},_clickTolerance:function(){return(this.options.stroke?this.options.weight/2:0)+(this._renderer.options.tolerance||0)}}),Bi=zi.extend({options:{fill:!0,radius:10},initialize:function(t,e){d(this,e),this._latlng=N(t),this._radius=this.options.radius},setLatLng:function(t){var e=this._latlng;return this._latlng=N(t),this.redraw(),this.fire("move",{oldLatLng:e,latlng:this._latlng})},getLatLng:function(){return this._latlng},setRadius:function(t){return this.options.radius=this._radius=t,this.redraw()},getRadius:function(){return this._radius},setStyle:function(t){var e=t&&t.radius||this._radius;return zi.prototype.setStyle.call(this,t),this.setRadius(e),this},_project:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._updateBounds()},_updateBounds:function(){var t=this._radius,e=this._radiusY||t,i=this._clickTolerance(),n=[t+i,e+i];this._pxBounds=new z(this._point.subtract(n),this._point.add(n))},_update:function(){this._map&&this._updatePath()},_updatePath:function(){this._renderer._updateCircle(this)},_empty:function(){return this._radius&&!this._renderer._bounds.intersects(this._pxBounds)},_containsPoint:function(t){return t.distanceTo(this._point)<=this._radius+this._clickTolerance()}});var Oi=Bi.extend({initialize:function(t,i,n){if("number"==typeof i&&(i=e({},n,{radius:i})),d(this,i),this._latlng=N(t),isNaN(this.options.radius))throw new Error("Circle radius cannot be NaN");this._mRadius=this.options.radius},setRadius:function(t){return this._mRadius=t,this.redraw()},getRadius:function(){return this._mRadius},getBounds:function(){var t=[this._radius,this._radiusY||this._radius];return new O(this._map.layerPointToLatLng(this._point.subtract(t)),this._map.layerPointToLatLng(this._point.add(t)))},setStyle:zi.prototype.setStyle,_project:function(){var t=this._latlng.lng,e=this._latlng.lat,i=this._map,n=i.options.crs;if(n.distance===U.distance){var r=Math.PI/180,o=this._mRadius/U.R/r,s=i.project([e+o,t]),a=i.project([e-o,t]),l=s.add(a).divideBy(2),h=i.unproject(l).lat,c=Math.acos((Math.cos(o*r)-Math.sin(e*r)*Math.sin(h*r))/(Math.cos(e*r)*Math.cos(h*r)))/r;(isNaN(c)||0===c)&&(c=o/Math.cos(Math.PI/180*e)),this._point=l.subtract(i.getPixelOrigin()),this._radius=isNaN(c)?0:l.x-i.project([h,t-c]).x,this._radiusY=l.y-s.y}else{var u=n.unproject(n.project(this._latlng).subtract([this._mRadius,0]));this._point=i.latLngToLayerPoint(this._latlng),this._radius=this._point.x-i.latLngToLayerPoint(u).x}this._updateBounds()}});var Ri=zi.extend({options:{smoothFactor:1,noClip:!1},initialize:function(t,e){d(this,e),this._setLatLngs(t)},getLatLngs:function(){return this._latlngs},setLatLngs:function(t){return this._setLatLngs(t),this.redraw()},isEmpty:function(){return!this._latlngs.length},closestLayerPoint:function(t){for(var e,i,n=1/0,r=null,o=gi,s=0,a=this._parts.length;s<a;s++)for(var l=this._parts[s],h=1,c=l.length;h<c;h++){var u=o(t,e=l[h-1],i=l[h],!0);u<n&&(n=u,r=o(t,e,i))}return r&&(r.distance=Math.sqrt(n)),r},getCenter:function(){if(!this._map)throw new Error("Must add layer to map before using getCenter()");return vi(this._defaultShape(),this._map.options.crs)},getBounds:function(){return this._bounds},addLatLng:function(t,e){return e=e||this._defaultShape(),t=N(t),e.push(t),this._bounds.extend(t),this.redraw()},_setLatLngs:function(t){this._bounds=new O,this._latlngs=this._convertLatLngs(t)},_defaultShape:function(){return _i(this._latlngs)?this._latlngs:this._latlngs[0]},_convertLatLngs:function(t){for(var e=[],i=_i(t),n=0,r=t.length;n<r;n++)i?(e[n]=N(t[n]),this._bounds.extend(e[n])):e[n]=this._convertLatLngs(t[n]);return e},_project:function(){var t=new z;this._rings=[],this._projectLatlngs(this._latlngs,this._rings,t),this._bounds.isValid()&&t.isValid()&&(this._rawPxBounds=t,this._updateBounds())},_updateBounds:function(){var t=this._clickTolerance(),e=new I(t,t);this._rawPxBounds&&(this._pxBounds=new z([this._rawPxBounds.min.subtract(e),this._rawPxBounds.max.add(e)]))},_projectLatlngs:function(t,e,i){var n,r,o=t[0]instanceof j,s=t.length;if(o){for(r=[],n=0;n<s;n++)r[n]=this._map.latLngToLayerPoint(t[n]),i.extend(r[n]);e.push(r)}else for(n=0;n<s;n++)this._projectLatlngs(t[n],e,i)},_clipPoints:function(){var t=this._renderer._bounds;if(this._parts=[],this._pxBounds&&this._pxBounds.intersects(t))if(this.options.noClip)this._parts=this._rings;else{var e,i,n,r,o,s,a,l=this._parts;for(e=0,n=0,r=this._rings.length;e<r;e++)for(i=0,o=(a=this._rings[e]).length;i<o-1;i++)(s=di(a[i],a[i+1],t,i,!0))&&(l[n]=l[n]||[],l[n].push(s[0]),s[1]===a[i+1]&&i!==o-2||(l[n].push(s[1]),n++))}},_simplifyPoints:function(){for(var t=this._parts,e=this.options.smoothFactor,i=0,n=t.length;i<n;i++)t[i]=hi(t[i],e)},_update:function(){this._map&&(this._clipPoints(),this._simplifyPoints(),this._updatePath())},_updatePath:function(){this._renderer._updatePoly(this)},_containsPoint:function(t,e){var i,n,r,o,s,a,l=this._clickTolerance();if(!this._pxBounds||!this._pxBounds.contains(t))return!1;for(i=0,o=this._parts.length;i<o;i++)for(n=0,r=(s=(a=this._parts[i]).length)-1;n<s;r=n++)if((e||0!==n)&&ci(t,a[r],a[n])<=l)return!0;return!1}});Ri._flat=yi;var ji=Ri.extend({options:{fill:!0},isEmpty:function(){return!this._latlngs.length||!this._latlngs[0].length},getCenter:function(){if(!this._map)throw new Error("Must add layer to map before using getCenter()");return oi(this._defaultShape(),this._map.options.crs)},_convertLatLngs:function(t){var e=Ri.prototype._convertLatLngs.call(this,t),i=e.length;return i>=2&&e[0]instanceof j&&e[0].equals(e[i-1])&&e.pop(),e},_setLatLngs:function(t){Ri.prototype._setLatLngs.call(this,t),_i(this._latlngs)&&(this._latlngs=[this._latlngs])},_defaultShape:function(){return _i(this._latlngs[0])?this._latlngs[0]:this._latlngs[0][0]},_clipPoints:function(){var t=this._renderer._bounds,e=this.options.weight,i=new I(e,e);if(t=new z(t.min.subtract(i),t.max.add(i)),this._parts=[],this._pxBounds&&this._pxBounds.intersects(t))if(this.options.noClip)this._parts=this._rings;else for(var n,r=0,o=this._rings.length;r<o;r++)(n=ri(this._rings[r],t,!0)).length&&this._parts.push(n)},_updatePath:function(){this._renderer._updatePoly(this,!0)},_containsPoint:function(t){var e,i,n,r,o,s,a,l,h=!1;if(!this._pxBounds||!this._pxBounds.contains(t))return!1;for(r=0,a=this._parts.length;r<a;r++)for(o=0,s=(l=(e=this._parts[r]).length)-1;o<l;s=o++)i=e[o],n=e[s],i.y>t.y!=n.y>t.y&&t.x<(n.x-i.x)*(t.y-i.y)/(n.y-i.y)+i.x&&(h=!h);return h||Ri.prototype._containsPoint.call(this,t,!0)}});var Ni=Si.extend({initialize:function(t,e){d(this,e),this._layers={},t&&this.addData(t)},addData:function(t){var e,i,n,r=g(t)?t:t.features;if(r){for(e=0,i=r.length;e<i;e++)((n=r[e]).geometries||n.geometry||n.features||n.coordinates)&&this.addData(n);return this}var o=this.options;if(o.filter&&!o.filter(t))return this;var s=Fi(t,o);return s?(s.feature=Wi(t),s.defaultOptions=s.options,this.resetStyle(s),o.onEachFeature&&o.onEachFeature(t,s),this.addLayer(s)):this},resetStyle:function(t){return void 0===t?this.eachLayer(this.resetStyle,this):(t.options=e({},t.defaultOptions),this._setLayerStyle(t,this.options.style),this)},setStyle:function(t){return this.eachLayer((function(e){this._setLayerStyle(e,t)}),this)},_setLayerStyle:function(t,e){t.setStyle&&("function"==typeof e&&(e=e(t.feature)),t.setStyle(e))}});function Fi(t,e){var i,n,r,o,s="Feature"===t.type?t.geometry:t,a=s?s.coordinates:null,l=[],h=e&&e.pointToLayer,c=e&&e.coordsToLatLng||Ui;if(!a&&!s)return null;switch(s.type){case"Point":return Gi(h,t,i=c(a),e);case"MultiPoint":for(r=0,o=a.length;r<o;r++)i=c(a[r]),l.push(Gi(h,t,i,e));return new Si(l);case"LineString":case"MultiLineString":return n=Hi(a,"LineString"===s.type?0:1,c),new Ri(n,e);case"Polygon":case"MultiPolygon":return n=Hi(a,"Polygon"===s.type?1:2,c),new ji(n,e);case"GeometryCollection":for(r=0,o=s.geometries.length;r<o;r++){var u=Fi({geometry:s.geometries[r],type:"Feature",properties:t.properties},e);u&&l.push(u)}return new Si(l);case"FeatureCollection":for(r=0,o=s.features.length;r<o;r++){var d=Fi(s.features[r],e);d&&l.push(d)}return new Si(l);default:throw new Error("Invalid GeoJSON object.")}}function Gi(t,e,i,n){return t?t(e,i):new Di(i,n&&n.markersInheritOptions&&n)}function Ui(t){return new j(t[1],t[0],t[2])}function Hi(t,e,i){for(var n,r=[],o=0,s=t.length;o<s;o++)n=e?Hi(t[o],e-1,i):(i||Ui)(t[o]),r.push(n);return r}function Vi(t,e){return void 0!==(t=N(t)).alt?[h(t.lng,e),h(t.lat,e),h(t.alt,e)]:[h(t.lng,e),h(t.lat,e)]}function Zi(t,e,i,n){for(var r=[],o=0,s=t.length;o<s;o++)r.push(e?Zi(t[o],_i(t[o])?0:e-1,i,n):Vi(t[o],n));return!e&&i&&r.length>0&&r.push(r[0].slice()),r}function qi(t,i){return t.feature?e({},t.feature,{geometry:i}):Wi(i)}function Wi(t){return"Feature"===t.type||"FeatureCollection"===t.type?t:{type:"Feature",properties:{},geometry:t}}var Ki={toGeoJSON:function(t){return qi(this,{type:"Point",coordinates:Vi(this.getLatLng(),t)})}};function Yi(t,e){return new Ni(t,e)}Di.include(Ki),Oi.include(Ki),Bi.include(Ki),Ri.include({toGeoJSON:function(t){var e=!_i(this._latlngs);return qi(this,{type:(e?"Multi":"")+"LineString",coordinates:Zi(this._latlngs,e?1:0,!1,t)})}}),ji.include({toGeoJSON:function(t){var e=!_i(this._latlngs),i=e&&!_i(this._latlngs[0]),n=Zi(this._latlngs,i?2:e?1:0,!0,t);return e||(n=[n]),qi(this,{type:(i?"Multi":"")+"Polygon",coordinates:n})}}),Pi.include({toMultiPoint:function(t){var e=[];return this.eachLayer((function(i){e.push(i.toGeoJSON(t).geometry.coordinates)})),qi(this,{type:"MultiPoint",coordinates:e})},toGeoJSON:function(t){var e=this.feature&&this.feature.geometry&&this.feature.geometry.type;if("MultiPoint"===e)return this.toMultiPoint(t);var i="GeometryCollection"===e,n=[];return this.eachLayer((function(e){if(e.toGeoJSON){var r=e.toGeoJSON(t);if(i)n.push(r.geometry);else{var o=Wi(r);"FeatureCollection"===o.type?n.push.apply(n,o.features):n.push(o)}}})),i?qi(this,{geometries:n,type:"GeometryCollection"}):{type:"FeatureCollection",features:n}}});var Xi=Yi,Ji=Ai.extend({options:{opacity:1,alt:"",interactive:!1,crossOrigin:!1,errorOverlayUrl:"",zIndex:1,className:""},initialize:function(t,e,i){this._url=t,this._bounds=R(e),d(this,i)},onAdd:function(){this._image||(this._initImage(),this.options.opacity<1&&this._updateOpacity()),this.options.interactive&&(ue(this._image,"leaflet-interactive"),this.addInteractiveTarget(this._image)),this.getPane().appendChild(this._image),this._reset()},onRemove:function(){se(this._image),this.options.interactive&&this.removeInteractiveTarget(this._image)},setOpacity:function(t){return this.options.opacity=t,this._image&&this._updateOpacity(),this},setStyle:function(t){return t.opacity&&this.setOpacity(t.opacity),this},bringToFront:function(){return this._map&&le(this._image),this},bringToBack:function(){return this._map&&he(this._image),this},setUrl:function(t){return this._url=t,this._image&&(this._image.src=t),this},setBounds:function(t){return this._bounds=R(t),this._map&&this._reset(),this},getEvents:function(){var t={zoom:this._reset,viewreset:this._reset};return this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},setZIndex:function(t){return this.options.zIndex=t,this._updateZIndex(),this},getBounds:function(){return this._bounds},getElement:function(){return this._image},_initImage:function(){var t="IMG"===this._url.tagName,e=this._image=t?this._url:oe("img");ue(e,"leaflet-image-layer"),this._zoomAnimated&&ue(e,"leaflet-zoom-animated"),this.options.className&&ue(e,this.options.className),e.onselectstart=l,e.onmousemove=l,e.onload=n(this.fire,this,"load"),e.onerror=n(this._overlayOnError,this,"error"),(this.options.crossOrigin||""===this.options.crossOrigin)&&(e.crossOrigin=!0===this.options.crossOrigin?"":this.options.crossOrigin),this.options.zIndex&&this._updateZIndex(),t?this._url=e.src:(e.src=this._url,e.alt=this.options.alt)},_animateZoom:function(t){var e=this._map.getZoomScale(t.zoom),i=this._map._latLngBoundsToNewLayerBounds(this._bounds,t.zoom,t.center).min;_e(this._image,i,e)},_reset:function(){var t=this._image,e=new z(this._map.latLngToLayerPoint(this._bounds.getNorthWest()),this._map.latLngToLayerPoint(this._bounds.getSouthEast())),i=e.getSize();ye(t,e.min),t.style.width=i.x+"px",t.style.height=i.y+"px"},_updateOpacity:function(){me(this._image,this.options.opacity)},_updateZIndex:function(){this._image&&void 0!==this.options.zIndex&&null!==this.options.zIndex&&(this._image.style.zIndex=this.options.zIndex)},_overlayOnError:function(){this.fire("error");var t=this.options.errorOverlayUrl;t&&this._url!==t&&(this._url=t,this._image.src=t)},getCenter:function(){return this._bounds.getCenter()}}),Qi=Ji.extend({options:{autoplay:!0,loop:!0,keepAspectRatio:!0,muted:!1,playsInline:!0},_initImage:function(){var t="VIDEO"===this._url.tagName,e=this._image=t?this._url:oe("video");if(ue(e,"leaflet-image-layer"),this._zoomAnimated&&ue(e,"leaflet-zoom-animated"),this.options.className&&ue(e,this.options.className),e.onselectstart=l,e.onmousemove=l,e.onloadeddata=n(this.fire,this,"load"),t){for(var i=e.getElementsByTagName("source"),r=[],o=0;o<i.length;o++)r.push(i[o].src);this._url=i.length>0?r:[e.src]}else{g(this._url)||(this._url=[this._url]),!this.options.keepAspectRatio&&Object.prototype.hasOwnProperty.call(e.style,"objectFit")&&(e.style.objectFit="fill"),e.autoplay=!!this.options.autoplay,e.loop=!!this.options.loop,e.muted=!!this.options.muted,e.playsInline=!!this.options.playsInline;for(var s=0;s<this._url.length;s++){var a=oe("source");a.src=this._url[s],e.appendChild(a)}}}});var $i=Ji.extend({_initImage:function(){var t=this._image=this._url;ue(t,"leaflet-image-layer"),this._zoomAnimated&&ue(t,"leaflet-zoom-animated"),this.options.className&&ue(t,this.options.className),t.onselectstart=l,t.onmousemove=l}});var tn=Ai.extend({options:{interactive:!1,offset:[0,0],className:"",pane:void 0,content:""},initialize:function(t,e){t&&(t instanceof j||g(t))?(this._latlng=N(t),d(this,e)):(d(this,t),this._source=e),this.options.content&&(this._content=this.options.content)},openOn:function(t){return(t=arguments.length?t:this._source._map).hasLayer(this)||t.addLayer(this),this},close:function(){return this._map&&this._map.removeLayer(this),this},toggle:function(t){return this._map?this.close():(arguments.length?this._source=t:t=this._source,this._prepareOpen(),this.openOn(t._map)),this},onAdd:function(t){this._zoomAnimated=t._zoomAnimated,this._container||this._initLayout(),t._fadeAnimated&&me(this._container,0),clearTimeout(this._removeTimeout),this.getPane().appendChild(this._container),this.update(),t._fadeAnimated&&me(this._container,1),this.bringToFront(),this.options.interactive&&(ue(this._container,"leaflet-interactive"),this.addInteractiveTarget(this._container))},onRemove:function(t){t._fadeAnimated?(me(this._container,0),this._removeTimeout=setTimeout(n(se,void 0,this._container),200)):se(this._container),this.options.interactive&&(de(this._container,"leaflet-interactive"),this.removeInteractiveTarget(this._container))},getLatLng:function(){return this._latlng},setLatLng:function(t){return this._latlng=N(t),this._map&&(this._updatePosition(),this._adjustPan()),this},getContent:function(){return this._content},setContent:function(t){return this._content=t,this.update(),this},getElement:function(){return this._container},update:function(){this._map&&(this._container.style.visibility="hidden",this._updateContent(),this._updateLayout(),this._updatePosition(),this._container.style.visibility="",this._adjustPan())},getEvents:function(){var t={zoom:this._updatePosition,viewreset:this._updatePosition};return this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},isOpen:function(){return!!this._map&&this._map.hasLayer(this)},bringToFront:function(){return this._map&&le(this._container),this},bringToBack:function(){return this._map&&he(this._container),this},_prepareOpen:function(t){var e=this._source;if(!e._map)return!1;if(e instanceof Si){e=null;var i=this._source._layers;for(var n in i)if(i[n]._map){e=i[n];break}if(!e)return!1;this._source=e}if(!t)if(e.getCenter)t=e.getCenter();else if(e.getLatLng)t=e.getLatLng();else{if(!e.getBounds)throw new Error("Unable to get source layer LatLng.");t=e.getBounds().getCenter()}return this.setLatLng(t),this._map&&this.update(),!0},_updateContent:function(){if(this._content){var t=this._contentNode,e="function"==typeof this._content?this._content(this._source||this):this._content;if("string"==typeof e)t.innerHTML=e;else{for(;t.hasChildNodes();)t.removeChild(t.firstChild);t.appendChild(e)}this.fire("contentupdate")}},_updatePosition:function(){if(this._map){var t=this._map.latLngToLayerPoint(this._latlng),e=D(this.options.offset),i=this._getAnchor();this._zoomAnimated?ye(this._container,t.add(i)):e=e.add(t).add(i);var n=this._containerBottom=-e.y,r=this._containerLeft=-Math.round(this._containerWidth/2)+e.x;this._container.style.bottom=n+"px",this._container.style.left=r+"px"}},_getAnchor:function(){return[0,0]}});We.include({_initOverlay:function(t,e,i,n){var r=e;return r instanceof t||(r=new t(n).setContent(e)),i&&r.setLatLng(i),r}}),Ai.include({_initOverlay:function(t,e,i,n){var r=i;return r instanceof t?(d(r,n),r._source=this):(r=e&&!n?e:new t(n,this)).setContent(i),r}});var en=tn.extend({options:{pane:"popupPane",offset:[0,7],maxWidth:300,minWidth:50,maxHeight:null,autoPan:!0,autoPanPaddingTopLeft:null,autoPanPaddingBottomRight:null,autoPanPadding:[5,5],keepInView:!1,closeButton:!0,autoClose:!0,closeOnEscapeKey:!0,className:""},openOn:function(t){return!(t=arguments.length?t:this._source._map).hasLayer(this)&&t._popup&&t._popup.options.autoClose&&t.removeLayer(t._popup),t._popup=this,tn.prototype.openOn.call(this,t)},onAdd:function(t){tn.prototype.onAdd.call(this,t),t.fire("popupopen",{popup:this}),this._source&&(this._source.fire("popupopen",{popup:this},!0),this._source instanceof zi||this._source.on("preclick",Be))},onRemove:function(t){tn.prototype.onRemove.call(this,t),t.fire("popupclose",{popup:this}),this._source&&(this._source.fire("popupclose",{popup:this},!0),this._source instanceof zi||this._source.off("preclick",Be))},getEvents:function(){var t=tn.prototype.getEvents.call(this);return(void 0!==this.options.closeOnClick?this.options.closeOnClick:this._map.options.closePopupOnClick)&&(t.preclick=this.close),this.options.keepInView&&(t.moveend=this._adjustPan),t},_initLayout:function(){var t="leaflet-popup",e=this._container=oe("div",t+" "+(this.options.className||"")+" leaflet-zoom-animated"),i=this._wrapper=oe("div",t+"-content-wrapper",e);if(this._contentNode=oe("div",t+"-content",i),Re(e),Oe(this._contentNode),Pe(e,"contextmenu",Be),this._tipContainer=oe("div",t+"-tip-container",e),this._tip=oe("div",t+"-tip",this._tipContainer),this.options.closeButton){var n=this._closeButton=oe("a",t+"-close-button",e);n.setAttribute("role","button"),n.setAttribute("aria-label","Close popup"),n.href="#close",n.innerHTML='<span aria-hidden="true">&#215;</span>',Pe(n,"click",(function(t){je(t),this.close()}),this)}},_updateLayout:function(){var t=this._contentNode,e=t.style;e.width="",e.whiteSpace="nowrap";var i=t.offsetWidth;i=Math.min(i,this.options.maxWidth),i=Math.max(i,this.options.minWidth),e.width=i+1+"px",e.whiteSpace="",e.height="";var n=t.offsetHeight,r=this.options.maxHeight,o="leaflet-popup-scrolled";r&&n>r?(e.height=r+"px",ue(t,o)):de(t,o),this._containerWidth=this._container.offsetWidth},_animateZoom:function(t){var e=this._map._latLngToNewLayerPoint(this._latlng,t.zoom,t.center),i=this._getAnchor();ye(this._container,e.add(i))},_adjustPan:function(){if(this.options.autoPan)if(this._map._panAnim&&this._map._panAnim.stop(),this._autopanning)this._autopanning=!1;else{var t=this._map,e=parseInt(re(this._container,"marginBottom"),10)||0,i=this._container.offsetHeight+e,n=this._containerWidth,r=new I(this._containerLeft,-i-this._containerBottom);r._add(ve(this._container));var o=t.layerPointToContainerPoint(r),s=D(this.options.autoPanPadding),a=D(this.options.autoPanPaddingTopLeft||s),l=D(this.options.autoPanPaddingBottomRight||s),h=t.getSize(),c=0,u=0;o.x+n+l.x>h.x&&(c=o.x+n-h.x+l.x),o.x-c-a.x<0&&(c=o.x-a.x),o.y+i+l.y>h.y&&(u=o.y+i-h.y+l.y),o.y-u-a.y<0&&(u=o.y-a.y),(c||u)&&(this.options.keepInView&&(this._autopanning=!0),t.fire("autopanstart").panBy([c,u]))}},_getAnchor:function(){return D(this._source&&this._source._getPopupAnchor?this._source._getPopupAnchor():[0,0])}});We.mergeOptions({closePopupOnClick:!0}),We.include({openPopup:function(t,e,i){return this._initOverlay(en,t,e,i).openOn(this),this},closePopup:function(t){return(t=arguments.length?t:this._popup)&&t.close(),this}}),Ai.include({bindPopup:function(t,e){return this._popup=this._initOverlay(en,this._popup,t,e),this._popupHandlersAdded||(this.on({click:this._openPopup,keypress:this._onKeyPress,remove:this.closePopup,move:this._movePopup}),this._popupHandlersAdded=!0),this},unbindPopup:function(){return this._popup&&(this.off({click:this._openPopup,keypress:this._onKeyPress,remove:this.closePopup,move:this._movePopup}),this._popupHandlersAdded=!1,this._popup=null),this},openPopup:function(t){return this._popup&&(this instanceof Si||(this._popup._source=this),this._popup._prepareOpen(t||this._latlng)&&this._popup.openOn(this._map)),this},closePopup:function(){return this._popup&&this._popup.close(),this},togglePopup:function(){return this._popup&&this._popup.toggle(this),this},isPopupOpen:function(){return!!this._popup&&this._popup.isOpen()},setPopupContent:function(t){return this._popup&&this._popup.setContent(t),this},getPopup:function(){return this._popup},_openPopup:function(t){if(this._popup&&this._map){Ne(t);var e=t.layer||t.target;this._popup._source!==e||e instanceof zi?(this._popup._source=e,this.openPopup(t.latlng)):this._map.hasLayer(this._popup)?this.closePopup():this.openPopup(t.latlng)}},_movePopup:function(t){this._popup.setLatLng(t.latlng)},_onKeyPress:function(t){13===t.originalEvent.keyCode&&this._openPopup(t)}});var nn=tn.extend({options:{pane:"tooltipPane",offset:[0,0],direction:"auto",permanent:!1,sticky:!1,opacity:.9},onAdd:function(t){tn.prototype.onAdd.call(this,t),this.setOpacity(this.options.opacity),t.fire("tooltipopen",{tooltip:this}),this._source&&(this.addEventParent(this._source),this._source.fire("tooltipopen",{tooltip:this},!0))},onRemove:function(t){tn.prototype.onRemove.call(this,t),t.fire("tooltipclose",{tooltip:this}),this._source&&(this.removeEventParent(this._source),this._source.fire("tooltipclose",{tooltip:this},!0))},getEvents:function(){var t=tn.prototype.getEvents.call(this);return this.options.permanent||(t.preclick=this.close),t},_initLayout:function(){var t="leaflet-tooltip "+(this.options.className||"")+" leaflet-zoom-"+(this._zoomAnimated?"animated":"hide");this._contentNode=this._container=oe("div",t),this._container.setAttribute("role","tooltip"),this._container.setAttribute("id","leaflet-tooltip-"+o(this))},_updateLayout:function(){},_adjustPan:function(){},_setPosition:function(t){var e,i,n=this._map,r=this._container,o=n.latLngToContainerPoint(n.getCenter()),s=n.layerPointToContainerPoint(t),a=this.options.direction,l=r.offsetWidth,h=r.offsetHeight,c=D(this.options.offset),u=this._getAnchor();"top"===a?(e=l/2,i=h):"bottom"===a?(e=l/2,i=0):"center"===a?(e=l/2,i=h/2):"right"===a?(e=0,i=h/2):"left"===a?(e=l,i=h/2):s.x<o.x?(a="right",e=0,i=h/2):(a="left",e=l+2*(c.x+u.x),i=h/2),t=t.subtract(D(e,i,!0)).add(c).add(u),de(r,"leaflet-tooltip-right"),de(r,"leaflet-tooltip-left"),de(r,"leaflet-tooltip-top"),de(r,"leaflet-tooltip-bottom"),ue(r,"leaflet-tooltip-"+a),ye(r,t)},_updatePosition:function(){var t=this._map.latLngToLayerPoint(this._latlng);this._setPosition(t)},setOpacity:function(t){this.options.opacity=t,this._container&&me(this._container,t)},_animateZoom:function(t){var e=this._map._latLngToNewLayerPoint(this._latlng,t.zoom,t.center);this._setPosition(e)},_getAnchor:function(){return D(this._source&&this._source._getTooltipAnchor&&!this.options.sticky?this._source._getTooltipAnchor():[0,0])}});We.include({openTooltip:function(t,e,i){return this._initOverlay(nn,t,e,i).openOn(this),this},closeTooltip:function(t){return t.close(),this}}),Ai.include({bindTooltip:function(t,e){return this._tooltip&&this.isTooltipOpen()&&this.unbindTooltip(),this._tooltip=this._initOverlay(nn,this._tooltip,t,e),this._initTooltipInteractions(),this._tooltip.options.permanent&&this._map&&this._map.hasLayer(this)&&this.openTooltip(),this},unbindTooltip:function(){return this._tooltip&&(this._initTooltipInteractions(!0),this.closeTooltip(),this._tooltip=null),this},_initTooltipInteractions:function(t){if(t||!this._tooltipHandlersAdded){var e=t?"off":"on",i={remove:this.closeTooltip,move:this._moveTooltip};this._tooltip.options.permanent?i.add=this._openTooltip:(i.mouseover=this._openTooltip,i.mouseout=this.closeTooltip,i.click=this._openTooltip,this._map?this._addFocusListeners():i.add=this._addFocusListeners),this._tooltip.options.sticky&&(i.mousemove=this._moveTooltip),this[e](i),this._tooltipHandlersAdded=!t}},openTooltip:function(t){return this._tooltip&&(this instanceof Si||(this._tooltip._source=this),this._tooltip._prepareOpen(t)&&(this._tooltip.openOn(this._map),this.getElement?this._setAriaDescribedByOnLayer(this):this.eachLayer&&this.eachLayer(this._setAriaDescribedByOnLayer,this))),this},closeTooltip:function(){if(this._tooltip)return this._tooltip.close()},toggleTooltip:function(){return this._tooltip&&this._tooltip.toggle(this),this},isTooltipOpen:function(){return this._tooltip.isOpen()},setTooltipContent:function(t){return this._tooltip&&this._tooltip.setContent(t),this},getTooltip:function(){return this._tooltip},_addFocusListeners:function(){this.getElement?this._addFocusListenersOnLayer(this):this.eachLayer&&this.eachLayer(this._addFocusListenersOnLayer,this)},_addFocusListenersOnLayer:function(t){var e="function"==typeof t.getElement&&t.getElement();e&&(Pe(e,"focus",(function(){this._tooltip._source=t,this.openTooltip()}),this),Pe(e,"blur",this.closeTooltip,this))},_setAriaDescribedByOnLayer:function(t){var e="function"==typeof t.getElement&&t.getElement();e&&e.setAttribute("aria-describedby",this._tooltip._container.id)},_openTooltip:function(t){if(this._tooltip&&this._map)if(this._map.dragging&&this._map.dragging.moving()&&!this._openOnceFlag){this._openOnceFlag=!0;var e=this;this._map.once("moveend",(function(){e._openOnceFlag=!1,e._openTooltip(t)}))}else this._tooltip._source=t.layer||t.target,this.openTooltip(this._tooltip.options.sticky?t.latlng:void 0)},_moveTooltip:function(t){var e,i,n=t.latlng;this._tooltip.options.sticky&&t.originalEvent&&(e=this._map.mouseEventToContainerPoint(t.originalEvent),i=this._map.containerPointToLayerPoint(e),n=this._map.layerPointToLatLng(i)),this._tooltip.setLatLng(n)}});var rn=Ei.extend({options:{iconSize:[12,12],html:!1,bgPos:null,className:"leaflet-div-icon"},createIcon:function(t){var e=t&&"DIV"===t.tagName?t:document.createElement("div"),i=this.options;if(i.html instanceof Element?(ae(e),e.appendChild(i.html)):e.innerHTML=!1!==i.html?i.html:"",i.bgPos){var n=D(i.bgPos);e.style.backgroundPosition=-n.x+"px "+-n.y+"px"}return this._setIconStyles(e,"icon"),e},createShadow:function(){return null}});Ei.Default=Ii;var on=Ai.extend({options:{tileSize:256,opacity:1,updateWhenIdle:zt.mobile,updateWhenZooming:!0,updateInterval:200,zIndex:1,bounds:null,minZoom:0,maxZoom:void 0,maxNativeZoom:void 0,minNativeZoom:void 0,noWrap:!1,pane:"tilePane",className:"",keepBuffer:2},initialize:function(t){d(this,t)},onAdd:function(){this._initContainer(),this._levels={},this._tiles={},this._resetView()},beforeAdd:function(t){t._addZoomLimit(this)},onRemove:function(t){this._removeAllTiles(),se(this._container),t._removeZoomLimit(this),this._container=null,this._tileZoom=void 0},bringToFront:function(){return this._map&&(le(this._container),this._setAutoZIndex(Math.max)),this},bringToBack:function(){return this._map&&(he(this._container),this._setAutoZIndex(Math.min)),this},getContainer:function(){return this._container},setOpacity:function(t){return this.options.opacity=t,this._updateOpacity(),this},setZIndex:function(t){return this.options.zIndex=t,this._updateZIndex(),this},isLoading:function(){return this._loading},redraw:function(){if(this._map){this._removeAllTiles();var t=this._clampZoom(this._map.getZoom());t!==this._tileZoom&&(this._tileZoom=t,this._updateLevels()),this._update()}return this},getEvents:function(){var t={viewprereset:this._invalidateAll,viewreset:this._resetView,zoom:this._resetView,moveend:this._onMoveEnd};return this.options.updateWhenIdle||(this._onMove||(this._onMove=s(this._onMoveEnd,this.options.updateInterval,this)),t.move=this._onMove),this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},createTile:function(){return document.createElement("div")},getTileSize:function(){var t=this.options.tileSize;return t instanceof I?t:new I(t,t)},_updateZIndex:function(){this._container&&void 0!==this.options.zIndex&&null!==this.options.zIndex&&(this._container.style.zIndex=this.options.zIndex)},_setAutoZIndex:function(t){for(var e,i=this.getPane().children,n=-t(-1/0,1/0),r=0,o=i.length;r<o;r++)e=i[r].style.zIndex,i[r]!==this._container&&e&&(n=t(n,+e));isFinite(n)&&(this.options.zIndex=n+t(-1,1),this._updateZIndex())},_updateOpacity:function(){if(this._map&&!zt.ielt9){me(this._container,this.options.opacity);var t=+new Date,e=!1,i=!1;for(var n in this._tiles){var r=this._tiles[n];if(r.current&&r.loaded){var o=Math.min(1,(t-r.loaded)/200);me(r.el,o),o<1?e=!0:(r.active?i=!0:this._onOpaqueTile(r),r.active=!0)}}i&&!this._noPrune&&this._pruneTiles(),e&&(C(this._fadeFrame),this._fadeFrame=k(this._updateOpacity,this))}},_onOpaqueTile:l,_initContainer:function(){this._container||(this._container=oe("div","leaflet-layer "+(this.options.className||"")),this._updateZIndex(),this.options.opacity<1&&this._updateOpacity(),this.getPane().appendChild(this._container))},_updateLevels:function(){var t=this._tileZoom,e=this.options.maxZoom;if(void 0!==t){for(var i in this._levels)i=Number(i),this._levels[i].el.children.length||i===t?(this._levels[i].el.style.zIndex=e-Math.abs(t-i),this._onUpdateLevel(i)):(se(this._levels[i].el),this._removeTilesAtZoom(i),this._onRemoveLevel(i),delete this._levels[i]);var n=this._levels[t],r=this._map;return n||((n=this._levels[t]={}).el=oe("div","leaflet-tile-container leaflet-zoom-animated",this._container),n.el.style.zIndex=e,n.origin=r.project(r.unproject(r.getPixelOrigin()),t).round(),n.zoom=t,this._setZoomTransform(n,r.getCenter(),r.getZoom()),n.el.offsetWidth,this._onCreateLevel(n)),this._level=n,n}},_onUpdateLevel:l,_onRemoveLevel:l,_onCreateLevel:l,_pruneTiles:function(){if(this._map){var t,e,i=this._map.getZoom();if(i>this.options.maxZoom||i<this.options.minZoom)this._removeAllTiles();else{for(t in this._tiles)(e=this._tiles[t]).retain=e.current;for(t in this._tiles)if((e=this._tiles[t]).current&&!e.active){var n=e.coords;this._retainParent(n.x,n.y,n.z,n.z-5)||this._retainChildren(n.x,n.y,n.z,n.z+2)}for(t in this._tiles)this._tiles[t].retain||this._removeTile(t)}}},_removeTilesAtZoom:function(t){for(var e in this._tiles)this._tiles[e].coords.z===t&&this._removeTile(e)},_removeAllTiles:function(){for(var t in this._tiles)this._removeTile(t)},_invalidateAll:function(){for(var t in this._levels)se(this._levels[t].el),this._onRemoveLevel(Number(t)),delete this._levels[t];this._removeAllTiles(),this._tileZoom=void 0},_retainParent:function(t,e,i,n){var r=Math.floor(t/2),o=Math.floor(e/2),s=i-1,a=new I(+r,+o);a.z=+s;var l=this._tileCoordsToKey(a),h=this._tiles[l];return h&&h.active?(h.retain=!0,!0):(h&&h.loaded&&(h.retain=!0),s>n&&this._retainParent(r,o,s,n))},_retainChildren:function(t,e,i,n){for(var r=2*t;r<2*t+2;r++)for(var o=2*e;o<2*e+2;o++){var s=new I(r,o);s.z=i+1;var a=this._tileCoordsToKey(s),l=this._tiles[a];l&&l.active?l.retain=!0:(l&&l.loaded&&(l.retain=!0),i+1<n&&this._retainChildren(r,o,i+1,n))}},_resetView:function(t){var e=t&&(t.pinch||t.flyTo);this._setView(this._map.getCenter(),this._map.getZoom(),e,e)},_animateZoom:function(t){this._setView(t.center,t.zoom,!0,t.noUpdate)},_clampZoom:function(t){var e=this.options;return void 0!==e.minNativeZoom&&t<e.minNativeZoom?e.minNativeZoom:void 0!==e.maxNativeZoom&&e.maxNativeZoom<t?e.maxNativeZoom:t},_setView:function(t,e,i,n){var r=Math.round(e);r=void 0!==this.options.maxZoom&&r>this.options.maxZoom||void 0!==this.options.minZoom&&r<this.options.minZoom?void 0:this._clampZoom(r);var o=this.options.updateWhenZooming&&r!==this._tileZoom;n&&!o||(this._tileZoom=r,this._abortLoading&&this._abortLoading(),this._updateLevels(),this._resetGrid(),void 0!==r&&this._update(t),i||this._pruneTiles(),this._noPrune=!!i),this._setZoomTransforms(t,e)},_setZoomTransforms:function(t,e){for(var i in this._levels)this._setZoomTransform(this._levels[i],t,e)},_setZoomTransform:function(t,e,i){var n=this._map.getZoomScale(i,t.zoom),r=t.origin.multiplyBy(n).subtract(this._map._getNewPixelOrigin(e,i)).round();zt.any3d?_e(t.el,r,n):ye(t.el,r)},_resetGrid:function(){var t=this._map,e=t.options.crs,i=this._tileSize=this.getTileSize(),n=this._tileZoom,r=this._map.getPixelWorldBounds(this._tileZoom);r&&(this._globalTileRange=this._pxBoundsToTileRange(r)),this._wrapX=e.wrapLng&&!this.options.noWrap&&[Math.floor(t.project([0,e.wrapLng[0]],n).x/i.x),Math.ceil(t.project([0,e.wrapLng[1]],n).x/i.y)],this._wrapY=e.wrapLat&&!this.options.noWrap&&[Math.floor(t.project([e.wrapLat[0],0],n).y/i.x),Math.ceil(t.project([e.wrapLat[1],0],n).y/i.y)]},_onMoveEnd:function(){this._map&&!this._map._animatingZoom&&this._update()},_getTiledPixelBounds:function(t){var e=this._map,i=e._animatingZoom?Math.max(e._animateToZoom,e.getZoom()):e.getZoom(),n=e.getZoomScale(i,this._tileZoom),r=e.project(t,this._tileZoom).floor(),o=e.getSize().divideBy(2*n);return new z(r.subtract(o),r.add(o))},_update:function(t){var e=this._map;if(e){var i=this._clampZoom(e.getZoom());if(void 0===t&&(t=e.getCenter()),void 0!==this._tileZoom){var n=this._getTiledPixelBounds(t),r=this._pxBoundsToTileRange(n),o=r.getCenter(),s=[],a=this.options.keepBuffer,l=new z(r.getBottomLeft().subtract([a,-a]),r.getTopRight().add([a,-a]));if(!(isFinite(r.min.x)&&isFinite(r.min.y)&&isFinite(r.max.x)&&isFinite(r.max.y)))throw new Error("Attempted to load an infinite number of tiles");for(var h in this._tiles){var c=this._tiles[h].coords;c.z===this._tileZoom&&l.contains(new I(c.x,c.y))||(this._tiles[h].current=!1)}if(Math.abs(i-this._tileZoom)>1)this._setView(t,i);else{for(var u=r.min.y;u<=r.max.y;u++)for(var d=r.min.x;d<=r.max.x;d++){var p=new I(d,u);if(p.z=this._tileZoom,this._isValidTile(p)){var f=this._tiles[this._tileCoordsToKey(p)];f?f.current=!0:s.push(p)}}if(s.sort((function(t,e){return t.distanceTo(o)-e.distanceTo(o)})),0!==s.length){this._loading||(this._loading=!0,this.fire("loading"));var m=document.createDocumentFragment();for(d=0;d<s.length;d++)this._addTile(s[d],m);this._level.el.appendChild(m)}}}}},_isValidTile:function(t){var e=this._map.options.crs;if(!e.infinite){var i=this._globalTileRange;if(!e.wrapLng&&(t.x<i.min.x||t.x>i.max.x)||!e.wrapLat&&(t.y<i.min.y||t.y>i.max.y))return!1}if(!this.options.bounds)return!0;var n=this._tileCoordsToBounds(t);return R(this.options.bounds).overlaps(n)},_keyToBounds:function(t){return this._tileCoordsToBounds(this._keyToTileCoords(t))},_tileCoordsToNwSe:function(t){var e=this._map,i=this.getTileSize(),n=t.scaleBy(i),r=n.add(i);return[e.unproject(n,t.z),e.unproject(r,t.z)]},_tileCoordsToBounds:function(t){var e=this._tileCoordsToNwSe(t),i=new O(e[0],e[1]);return this.options.noWrap||(i=this._map.wrapLatLngBounds(i)),i},_tileCoordsToKey:function(t){return t.x+":"+t.y+":"+t.z},_keyToTileCoords:function(t){var e=t.split(":"),i=new I(+e[0],+e[1]);return i.z=+e[2],i},_removeTile:function(t){var e=this._tiles[t];e&&(se(e.el),delete this._tiles[t],this.fire("tileunload",{tile:e.el,coords:this._keyToTileCoords(t)}))},_initTile:function(t){ue(t,"leaflet-tile");var e=this.getTileSize();t.style.width=e.x+"px",t.style.height=e.y+"px",t.onselectstart=l,t.onmousemove=l,zt.ielt9&&this.options.opacity<1&&me(t,this.options.opacity)},_addTile:function(t,e){var i=this._getTilePos(t),r=this._tileCoordsToKey(t),o=this.createTile(this._wrapCoords(t),n(this._tileReady,this,t));this._initTile(o),this.createTile.length<2&&k(n(this._tileReady,this,t,null,o)),ye(o,i),this._tiles[r]={el:o,coords:t,current:!0},e.appendChild(o),this.fire("tileloadstart",{tile:o,coords:t})},_tileReady:function(t,e,i){e&&this.fire("tileerror",{error:e,tile:i,coords:t});var r=this._tileCoordsToKey(t);(i=this._tiles[r])&&(i.loaded=+new Date,this._map._fadeAnimated?(me(i.el,0),C(this._fadeFrame),this._fadeFrame=k(this._updateOpacity,this)):(i.active=!0,this._pruneTiles()),e||(ue(i.el,"leaflet-tile-loaded"),this.fire("tileload",{tile:i.el,coords:t})),this._noTilesToLoad()&&(this._loading=!1,this.fire("load"),zt.ielt9||!this._map._fadeAnimated?k(this._pruneTiles,this):setTimeout(n(this._pruneTiles,this),250)))},_getTilePos:function(t){return t.scaleBy(this.getTileSize()).subtract(this._level.origin)},_wrapCoords:function(t){var e=new I(this._wrapX?a(t.x,this._wrapX):t.x,this._wrapY?a(t.y,this._wrapY):t.y);return e.z=t.z,e},_pxBoundsToTileRange:function(t){var e=this.getTileSize();return new z(t.min.unscaleBy(e).floor(),t.max.unscaleBy(e).ceil().subtract([1,1]))},_noTilesToLoad:function(){for(var t in this._tiles)if(!this._tiles[t].loaded)return!1;return!0}});var sn=on.extend({options:{minZoom:0,maxZoom:18,subdomains:"abc",errorTileUrl:"",zoomOffset:0,tms:!1,zoomReverse:!1,detectRetina:!1,crossOrigin:!1,referrerPolicy:!1},initialize:function(t,e){this._url=t,(e=d(this,e)).detectRetina&&zt.retina&&e.maxZoom>0?(e.tileSize=Math.floor(e.tileSize/2),e.zoomReverse?(e.zoomOffset--,e.minZoom=Math.min(e.maxZoom,e.minZoom+1)):(e.zoomOffset++,e.maxZoom=Math.max(e.minZoom,e.maxZoom-1)),e.minZoom=Math.max(0,e.minZoom)):e.zoomReverse?e.minZoom=Math.min(e.maxZoom,e.minZoom):e.maxZoom=Math.max(e.minZoom,e.maxZoom),"string"==typeof e.subdomains&&(e.subdomains=e.subdomains.split("")),this.on("tileunload",this._onTileRemove)},setUrl:function(t,e){return this._url===t&&void 0===e&&(e=!0),this._url=t,e||this.redraw(),this},createTile:function(t,e){var i=document.createElement("img");return Pe(i,"load",n(this._tileOnLoad,this,e,i)),Pe(i,"error",n(this._tileOnError,this,e,i)),(this.options.crossOrigin||""===this.options.crossOrigin)&&(i.crossOrigin=!0===this.options.crossOrigin?"":this.options.crossOrigin),"string"==typeof this.options.referrerPolicy&&(i.referrerPolicy=this.options.referrerPolicy),i.alt="",i.src=this.getTileUrl(t),i},getTileUrl:function(t){var i={r:zt.retina?"@2x":"",s:this._getSubdomain(t),x:t.x,y:t.y,z:this._getZoomForUrl()};if(this._map&&!this._map.options.crs.infinite){var n=this._globalTileRange.max.y-t.y;this.options.tms&&(i.y=n),i["-y"]=n}return m(this._url,e(i,this.options))},_tileOnLoad:function(t,e){zt.ielt9?setTimeout(n(t,this,null,e),0):t(null,e)},_tileOnError:function(t,e,i){var n=this.options.errorTileUrl;n&&e.getAttribute("src")!==n&&(e.src=n),t(i,e)},_onTileRemove:function(t){t.tile.onload=null},_getZoomForUrl:function(){var t=this._tileZoom,e=this.options.maxZoom;return this.options.zoomReverse&&(t=e-t),t+this.options.zoomOffset},_getSubdomain:function(t){var e=Math.abs(t.x+t.y)%this.options.subdomains.length;return this.options.subdomains[e]},_abortLoading:function(){var t,e;for(t in this._tiles)if(this._tiles[t].coords.z!==this._tileZoom&&((e=this._tiles[t].el).onload=l,e.onerror=l,!e.complete)){e.src=y;var i=this._tiles[t].coords;se(e),delete this._tiles[t],this.fire("tileabort",{tile:e,coords:i})}},_removeTile:function(t){var e=this._tiles[t];if(e)return e.el.setAttribute("src",y),on.prototype._removeTile.call(this,t)},_tileReady:function(t,e,i){if(this._map&&(!i||i.getAttribute("src")!==y))return on.prototype._tileReady.call(this,t,e,i)}});function an(t,e){return new sn(t,e)}var ln=sn.extend({defaultWmsParams:{service:"WMS",request:"GetMap",layers:"",styles:"",format:"image/jpeg",transparent:!1,version:"1.1.1"},options:{crs:null,uppercase:!1},initialize:function(t,i){this._url=t;var n=e({},this.defaultWmsParams);for(var r in i)r in this.options||(n[r]=i[r]);var o=(i=d(this,i)).detectRetina&&zt.retina?2:1,s=this.getTileSize();n.width=s.x*o,n.height=s.y*o,this.wmsParams=n},onAdd:function(t){this._crs=this.options.crs||t.options.crs,this._wmsVersion=parseFloat(this.wmsParams.version);var e=this._wmsVersion>=1.3?"crs":"srs";this.wmsParams[e]=this._crs.code,sn.prototype.onAdd.call(this,t)},getTileUrl:function(t){var e=this._tileCoordsToNwSe(t),i=this._crs,n=B(i.project(e[0]),i.project(e[1])),r=n.min,o=n.max,s=(this._wmsVersion>=1.3&&this._crs===ki?[r.y,r.x,o.y,o.x]:[r.x,r.y,o.x,o.y]).join(","),a=sn.prototype.getTileUrl.call(this,t);return a+p(this.wmsParams,a,this.options.uppercase)+(this.options.uppercase?"&BBOX=":"&bbox=")+s},setParams:function(t,i){return e(this.wmsParams,t),i||this.redraw(),this}});sn.WMS=ln,an.wms=function(t,e){return new ln(t,e)};var hn=Ai.extend({options:{padding:.1},initialize:function(t){d(this,t),o(this),this._layers=this._layers||{}},onAdd:function(){this._container||(this._initContainer(),ue(this._container,"leaflet-zoom-animated")),this.getPane().appendChild(this._container),this._update(),this.on("update",this._updatePaths,this)},onRemove:function(){this.off("update",this._updatePaths,this),this._destroyContainer()},getEvents:function(){var t={viewreset:this._reset,zoom:this._onZoom,moveend:this._update,zoomend:this._onZoomEnd};return this._zoomAnimated&&(t.zoomanim=this._onAnimZoom),t},_onAnimZoom:function(t){this._updateTransform(t.center,t.zoom)},_onZoom:function(){this._updateTransform(this._map.getCenter(),this._map.getZoom())},_updateTransform:function(t,e){var i=this._map.getZoomScale(e,this._zoom),n=this._map.getSize().multiplyBy(.5+this.options.padding),r=this._map.project(this._center,e),o=n.multiplyBy(-i).add(r).subtract(this._map._getNewPixelOrigin(t,e));zt.any3d?_e(this._container,o,i):ye(this._container,o)},_reset:function(){for(var t in this._update(),this._updateTransform(this._center,this._zoom),this._layers)this._layers[t]._reset()},_onZoomEnd:function(){for(var t in this._layers)this._layers[t]._project()},_updatePaths:function(){for(var t in this._layers)this._layers[t]._update()},_update:function(){var t=this.options.padding,e=this._map.getSize(),i=this._map.containerPointToLayerPoint(e.multiplyBy(-t)).round();this._bounds=new z(i,i.add(e.multiplyBy(1+2*t)).round()),this._center=this._map.getCenter(),this._zoom=this._map.getZoom()}}),cn=hn.extend({options:{tolerance:0},getEvents:function(){var t=hn.prototype.getEvents.call(this);return t.viewprereset=this._onViewPreReset,t},_onViewPreReset:function(){this._postponeUpdatePaths=!0},onAdd:function(){hn.prototype.onAdd.call(this),this._draw()},_initContainer:function(){var t=this._container=document.createElement("canvas");Pe(t,"mousemove",this._onMouseMove,this),Pe(t,"click dblclick mousedown mouseup contextmenu",this._onClick,this),Pe(t,"mouseout",this._handleMouseOut,this),t._leaflet_disable_events=!0,this._ctx=t.getContext("2d")},_destroyContainer:function(){C(this._redrawRequest),delete this._ctx,se(this._container),Ee(this._container),delete this._container},_updatePaths:function(){if(!this._postponeUpdatePaths){for(var t in this._redrawBounds=null,this._layers)this._layers[t]._update();this._redraw()}},_update:function(){if(!this._map._animatingZoom||!this._bounds){hn.prototype._update.call(this);var t=this._bounds,e=this._container,i=t.getSize(),n=zt.retina?2:1;ye(e,t.min),e.width=n*i.x,e.height=n*i.y,e.style.width=i.x+"px",e.style.height=i.y+"px",zt.retina&&this._ctx.scale(2,2),this._ctx.translate(-t.min.x,-t.min.y),this.fire("update")}},_reset:function(){hn.prototype._reset.call(this),this._postponeUpdatePaths&&(this._postponeUpdatePaths=!1,this._updatePaths())},_initPath:function(t){this._updateDashArray(t),this._layers[o(t)]=t;var e=t._order={layer:t,prev:this._drawLast,next:null};this._drawLast&&(this._drawLast.next=e),this._drawLast=e,this._drawFirst=this._drawFirst||this._drawLast},_addPath:function(t){this._requestRedraw(t)},_removePath:function(t){var e=t._order,i=e.next,n=e.prev;i?i.prev=n:this._drawLast=n,n?n.next=i:this._drawFirst=i,delete t._order,delete this._layers[o(t)],this._requestRedraw(t)},_updatePath:function(t){this._extendRedrawBounds(t),t._project(),t._update(),this._requestRedraw(t)},_updateStyle:function(t){this._updateDashArray(t),this._requestRedraw(t)},_updateDashArray:function(t){if("string"==typeof t.options.dashArray){var e,i,n=t.options.dashArray.split(/[, ]+/),r=[];for(i=0;i<n.length;i++){if(e=Number(n[i]),isNaN(e))return;r.push(e)}t.options._dashArray=r}else t.options._dashArray=t.options.dashArray},_requestRedraw:function(t){this._map&&(this._extendRedrawBounds(t),this._redrawRequest=this._redrawRequest||k(this._redraw,this))},_extendRedrawBounds:function(t){if(t._pxBounds){var e=(t.options.weight||0)+1;this._redrawBounds=this._redrawBounds||new z,this._redrawBounds.extend(t._pxBounds.min.subtract([e,e])),this._redrawBounds.extend(t._pxBounds.max.add([e,e]))}},_redraw:function(){this._redrawRequest=null,this._redrawBounds&&(this._redrawBounds.min._floor(),this._redrawBounds.max._ceil()),this._clear(),this._draw(),this._redrawBounds=null},_clear:function(){var t=this._redrawBounds;if(t){var e=t.getSize();this._ctx.clearRect(t.min.x,t.min.y,e.x,e.y)}else this._ctx.save(),this._ctx.setTransform(1,0,0,1,0,0),this._ctx.clearRect(0,0,this._container.width,this._container.height),this._ctx.restore()},_draw:function(){var t,e=this._redrawBounds;if(this._ctx.save(),e){var i=e.getSize();this._ctx.beginPath(),this._ctx.rect(e.min.x,e.min.y,i.x,i.y),this._ctx.clip()}this._drawing=!0;for(var n=this._drawFirst;n;n=n.next)t=n.layer,(!e||t._pxBounds&&t._pxBounds.intersects(e))&&t._updatePath();this._drawing=!1,this._ctx.restore()},_updatePoly:function(t,e){if(this._drawing){var i,n,r,o,s=t._parts,a=s.length,l=this._ctx;if(a){for(l.beginPath(),i=0;i<a;i++){for(n=0,r=s[i].length;n<r;n++)o=s[i][n],l[n?"lineTo":"moveTo"](o.x,o.y);e&&l.closePath()}this._fillStroke(l,t)}}},_updateCircle:function(t){if(this._drawing&&!t._empty()){var e=t._point,i=this._ctx,n=Math.max(Math.round(t._radius),1),r=(Math.max(Math.round(t._radiusY),1)||n)/n;1!==r&&(i.save(),i.scale(1,r)),i.beginPath(),i.arc(e.x,e.y/r,n,0,2*Math.PI,!1),1!==r&&i.restore(),this._fillStroke(i,t)}},_fillStroke:function(t,e){var i=e.options;i.fill&&(t.globalAlpha=i.fillOpacity,t.fillStyle=i.fillColor||i.color,t.fill(i.fillRule||"evenodd")),i.stroke&&0!==i.weight&&(t.setLineDash&&t.setLineDash(e.options&&e.options._dashArray||[]),t.globalAlpha=i.opacity,t.lineWidth=i.weight,t.strokeStyle=i.color,t.lineCap=i.lineCap,t.lineJoin=i.lineJoin,t.stroke())},_onClick:function(t){for(var e,i,n=this._map.mouseEventToLayerPoint(t),r=this._drawFirst;r;r=r.next)(e=r.layer).options.interactive&&e._containsPoint(n)&&("click"!==t.type&&"preclick"!==t.type||!this._map._draggableMoved(e))&&(i=e);this._fireEvent(!!i&&[i],t)},_onMouseMove:function(t){if(this._map&&!this._map.dragging.moving()&&!this._map._animatingZoom){var e=this._map.mouseEventToLayerPoint(t);this._handleMouseHover(t,e)}},_handleMouseOut:function(t){var e=this._hoveredLayer;e&&(de(this._container,"leaflet-interactive"),this._fireEvent([e],t,"mouseout"),this._hoveredLayer=null,this._mouseHoverThrottled=!1)},_handleMouseHover:function(t,e){if(!this._mouseHoverThrottled){for(var i,r,o=this._drawFirst;o;o=o.next)(i=o.layer).options.interactive&&i._containsPoint(e)&&(r=i);r!==this._hoveredLayer&&(this._handleMouseOut(t),r&&(ue(this._container,"leaflet-interactive"),this._fireEvent([r],t,"mouseover"),this._hoveredLayer=r)),this._fireEvent(!!this._hoveredLayer&&[this._hoveredLayer],t),this._mouseHoverThrottled=!0,setTimeout(n((function(){this._mouseHoverThrottled=!1}),this),32)}},_fireEvent:function(t,e,i){this._map._fireDOMEvent(e,i||e.type,t)},_bringToFront:function(t){var e=t._order;if(e){var i=e.next,n=e.prev;i&&(i.prev=n,n?n.next=i:i&&(this._drawFirst=i),e.prev=this._drawLast,this._drawLast.next=e,e.next=null,this._drawLast=e,this._requestRedraw(t))}},_bringToBack:function(t){var e=t._order;if(e){var i=e.next,n=e.prev;n&&(n.next=i,i?i.prev=n:n&&(this._drawLast=n),e.prev=null,e.next=this._drawFirst,this._drawFirst.prev=e,this._drawFirst=e,this._requestRedraw(t))}}});function un(t){return zt.canvas?new cn(t):null}var dn=function(){try{return document.namespaces.add("lvml","urn:schemas-microsoft-com:vml"),function(t){return document.createElement("<lvml:"+t+' class="lvml">')}}catch(t){}return function(t){return document.createElement("<"+t+' xmlns="urn:schemas-microsoft.com:vml" class="lvml">')}}(),pn={_initContainer:function(){this._container=oe("div","leaflet-vml-container")},_update:function(){this._map._animatingZoom||(hn.prototype._update.call(this),this.fire("update"))},_initPath:function(t){var e=t._container=dn("shape");ue(e,"leaflet-vml-shape "+(this.options.className||"")),e.coordsize="1 1",t._path=dn("path"),e.appendChild(t._path),this._updateStyle(t),this._layers[o(t)]=t},_addPath:function(t){var e=t._container;this._container.appendChild(e),t.options.interactive&&t.addInteractiveTarget(e)},_removePath:function(t){var e=t._container;se(e),t.removeInteractiveTarget(e),delete this._layers[o(t)]},_updateStyle:function(t){var e=t._stroke,i=t._fill,n=t.options,r=t._container;r.stroked=!!n.stroke,r.filled=!!n.fill,n.stroke?(e||(e=t._stroke=dn("stroke")),r.appendChild(e),e.weight=n.weight+"px",e.color=n.color,e.opacity=n.opacity,n.dashArray?e.dashStyle=g(n.dashArray)?n.dashArray.join(" "):n.dashArray.replace(/( *, *)/g," "):e.dashStyle="",e.endcap=n.lineCap.replace("butt","flat"),e.joinstyle=n.lineJoin):e&&(r.removeChild(e),t._stroke=null),n.fill?(i||(i=t._fill=dn("fill")),r.appendChild(i),i.color=n.fillColor||n.color,i.opacity=n.fillOpacity):i&&(r.removeChild(i),t._fill=null)},_updateCircle:function(t){var e=t._point.round(),i=Math.round(t._radius),n=Math.round(t._radiusY||i);this._setPath(t,t._empty()?"M0 0":"AL "+e.x+","+e.y+" "+i+","+n+" 0,23592600")},_setPath:function(t,e){t._path.v=e},_bringToFront:function(t){le(t._container)},_bringToBack:function(t){he(t._container)}},fn=zt.vml?dn:Y,mn=hn.extend({_initContainer:function(){this._container=fn("svg"),this._container.setAttribute("pointer-events","none"),this._rootGroup=fn("g"),this._container.appendChild(this._rootGroup)},_destroyContainer:function(){se(this._container),Ee(this._container),delete this._container,delete this._rootGroup,delete this._svgSize},_update:function(){if(!this._map._animatingZoom||!this._bounds){hn.prototype._update.call(this);var t=this._bounds,e=t.getSize(),i=this._container;this._svgSize&&this._svgSize.equals(e)||(this._svgSize=e,i.setAttribute("width",e.x),i.setAttribute("height",e.y)),ye(i,t.min),i.setAttribute("viewBox",[t.min.x,t.min.y,e.x,e.y].join(" ")),this.fire("update")}},_initPath:function(t){var e=t._path=fn("path");t.options.className&&ue(e,t.options.className),t.options.interactive&&ue(e,"leaflet-interactive"),this._updateStyle(t),this._layers[o(t)]=t},_addPath:function(t){this._rootGroup||this._initContainer(),this._rootGroup.appendChild(t._path),t.addInteractiveTarget(t._path)},_removePath:function(t){se(t._path),t.removeInteractiveTarget(t._path),delete this._layers[o(t)]},_updatePath:function(t){t._project(),t._update()},_updateStyle:function(t){var e=t._path,i=t.options;e&&(i.stroke?(e.setAttribute("stroke",i.color),e.setAttribute("stroke-opacity",i.opacity),e.setAttribute("stroke-width",i.weight),e.setAttribute("stroke-linecap",i.lineCap),e.setAttribute("stroke-linejoin",i.lineJoin),i.dashArray?e.setAttribute("stroke-dasharray",i.dashArray):e.removeAttribute("stroke-dasharray"),i.dashOffset?e.setAttribute("stroke-dashoffset",i.dashOffset):e.removeAttribute("stroke-dashoffset")):e.setAttribute("stroke","none"),i.fill?(e.setAttribute("fill",i.fillColor||i.color),e.setAttribute("fill-opacity",i.fillOpacity),e.setAttribute("fill-rule",i.fillRule||"evenodd")):e.setAttribute("fill","none"))},_updatePoly:function(t,e){this._setPath(t,X(t._parts,e))},_updateCircle:function(t){var e=t._point,i=Math.max(Math.round(t._radius),1),n="a"+i+","+(Math.max(Math.round(t._radiusY),1)||i)+" 0 1,0 ",r=t._empty()?"M0 0":"M"+(e.x-i)+","+e.y+n+2*i+",0 "+n+2*-i+",0 ";this._setPath(t,r)},_setPath:function(t,e){t._path.setAttribute("d",e)},_bringToFront:function(t){le(t._path)},_bringToBack:function(t){he(t._path)}});function gn(t){return zt.svg||zt.vml?new mn(t):null}zt.vml&&mn.include(pn),We.include({getRenderer:function(t){var e=t.options.renderer||this._getPaneRenderer(t.options.pane)||this.options.renderer||this._renderer;return e||(e=this._renderer=this._createRenderer()),this.hasLayer(e)||this.addLayer(e),e},_getPaneRenderer:function(t){if("overlayPane"===t||void 0===t)return!1;var e=this._paneRenderers[t];return void 0===e&&(e=this._createRenderer({pane:t}),this._paneRenderers[t]=e),e},_createRenderer:function(t){return this.options.preferCanvas&&un(t)||gn(t)}});var _n=ji.extend({initialize:function(t,e){ji.prototype.initialize.call(this,this._boundsToLatLngs(t),e)},setBounds:function(t){return this.setLatLngs(this._boundsToLatLngs(t))},_boundsToLatLngs:function(t){return[(t=R(t)).getSouthWest(),t.getNorthWest(),t.getNorthEast(),t.getSouthEast()]}});mn.create=fn,mn.pointsToPath=X,Ni.geometryToLayer=Fi,Ni.coordsToLatLng=Ui,Ni.coordsToLatLngs=Hi,Ni.latLngToCoords=Vi,Ni.latLngsToCoords=Zi,Ni.getFeature=qi,Ni.asFeature=Wi,We.mergeOptions({boxZoom:!0});var yn=ti.extend({initialize:function(t){this._map=t,this._container=t._container,this._pane=t._panes.overlayPane,this._resetStateTimeout=0,t.on("unload",this._destroy,this)},addHooks:function(){Pe(this._container,"mousedown",this._onMouseDown,this)},removeHooks:function(){Ee(this._container,"mousedown",this._onMouseDown,this)},moved:function(){return this._moved},_destroy:function(){se(this._pane),delete this._pane},_resetState:function(){this._resetStateTimeout=0,this._moved=!1},_clearDeferredResetState:function(){0!==this._resetStateTimeout&&(clearTimeout(this._resetStateTimeout),this._resetStateTimeout=0)},_onMouseDown:function(t){if(!t.shiftKey||1!==t.which&&1!==t.button)return!1;this._clearDeferredResetState(),this._resetState(),Yt(),xe(),this._startPoint=this._map.mouseEventToContainerPoint(t),Pe(document,{contextmenu:Ne,mousemove:this._onMouseMove,mouseup:this._onMouseUp,keydown:this._onKeyDown},this)},_onMouseMove:function(t){this._moved||(this._moved=!0,this._box=oe("div","leaflet-zoom-box",this._container),ue(this._container,"leaflet-crosshair"),this._map.fire("boxzoomstart")),this._point=this._map.mouseEventToContainerPoint(t);var e=new z(this._point,this._startPoint),i=e.getSize();ye(this._box,e.min),this._box.style.width=i.x+"px",this._box.style.height=i.y+"px"},_finish:function(){this._moved&&(se(this._box),de(this._container,"leaflet-crosshair")),Xt(),we(),Ee(document,{contextmenu:Ne,mousemove:this._onMouseMove,mouseup:this._onMouseUp,keydown:this._onKeyDown},this)},_onMouseUp:function(t){if((1===t.which||1===t.button)&&(this._finish(),this._moved)){this._clearDeferredResetState(),this._resetStateTimeout=setTimeout(n(this._resetState,this),0);var e=new O(this._map.containerPointToLatLng(this._startPoint),this._map.containerPointToLatLng(this._point));this._map.fitBounds(e).fire("boxzoomend",{boxZoomBounds:e})}},_onKeyDown:function(t){27===t.keyCode&&(this._finish(),this._clearDeferredResetState(),this._resetState())}});We.addInitHook("addHandler","boxZoom",yn),We.mergeOptions({doubleClickZoom:!0});var vn=ti.extend({addHooks:function(){this._map.on("dblclick",this._onDoubleClick,this)},removeHooks:function(){this._map.off("dblclick",this._onDoubleClick,this)},_onDoubleClick:function(t){var e=this._map,i=e.getZoom(),n=e.options.zoomDelta,r=t.originalEvent.shiftKey?i-n:i+n;"center"===e.options.doubleClickZoom?e.setZoom(r):e.setZoomAround(t.containerPoint,r)}});We.addInitHook("addHandler","doubleClickZoom",vn),We.mergeOptions({dragging:!0,inertia:!0,inertiaDeceleration:3400,inertiaMaxSpeed:1/0,easeLinearity:.2,worldCopyJump:!1,maxBoundsViscosity:0});var bn=ti.extend({addHooks:function(){if(!this._draggable){var t=this._map;this._draggable=new ni(t._mapPane,t._container),this._draggable.on({dragstart:this._onDragStart,drag:this._onDrag,dragend:this._onDragEnd},this),this._draggable.on("predrag",this._onPreDragLimit,this),t.options.worldCopyJump&&(this._draggable.on("predrag",this._onPreDragWrap,this),t.on("zoomend",this._onZoomEnd,this),t.whenReady(this._onZoomEnd,this))}ue(this._map._container,"leaflet-grab leaflet-touch-drag"),this._draggable.enable(),this._positions=[],this._times=[]},removeHooks:function(){de(this._map._container,"leaflet-grab"),de(this._map._container,"leaflet-touch-drag"),this._draggable.disable()},moved:function(){return this._draggable&&this._draggable._moved},moving:function(){return this._draggable&&this._draggable._moving},_onDragStart:function(){var t=this._map;if(t._stop(),this._map.options.maxBounds&&this._map.options.maxBoundsViscosity){var e=R(this._map.options.maxBounds);this._offsetLimit=B(this._map.latLngToContainerPoint(e.getNorthWest()).multiplyBy(-1),this._map.latLngToContainerPoint(e.getSouthEast()).multiplyBy(-1).add(this._map.getSize())),this._viscosity=Math.min(1,Math.max(0,this._map.options.maxBoundsViscosity))}else this._offsetLimit=null;t.fire("movestart").fire("dragstart"),t.options.inertia&&(this._positions=[],this._times=[])},_onDrag:function(t){if(this._map.options.inertia){var e=this._lastTime=+new Date,i=this._lastPos=this._draggable._absPos||this._draggable._newPos;this._positions.push(i),this._times.push(e),this._prunePositions(e)}this._map.fire("move",t).fire("drag",t)},_prunePositions:function(t){for(;this._positions.length>1&&t-this._times[0]>50;)this._positions.shift(),this._times.shift()},_onZoomEnd:function(){var t=this._map.getSize().divideBy(2),e=this._map.latLngToLayerPoint([0,0]);this._initialWorldOffset=e.subtract(t).x,this._worldWidth=this._map.getPixelWorldBounds().getSize().x},_viscousLimit:function(t,e){return t-(t-e)*this._viscosity},_onPreDragLimit:function(){if(this._viscosity&&this._offsetLimit){var t=this._draggable._newPos.subtract(this._draggable._startPos),e=this._offsetLimit;t.x<e.min.x&&(t.x=this._viscousLimit(t.x,e.min.x)),t.y<e.min.y&&(t.y=this._viscousLimit(t.y,e.min.y)),t.x>e.max.x&&(t.x=this._viscousLimit(t.x,e.max.x)),t.y>e.max.y&&(t.y=this._viscousLimit(t.y,e.max.y)),this._draggable._newPos=this._draggable._startPos.add(t)}},_onPreDragWrap:function(){var t=this._worldWidth,e=Math.round(t/2),i=this._initialWorldOffset,n=this._draggable._newPos.x,r=(n-e+i)%t+e-i,o=(n+e+i)%t-e-i,s=Math.abs(r+i)<Math.abs(o+i)?r:o;this._draggable._absPos=this._draggable._newPos.clone(),this._draggable._newPos.x=s},_onDragEnd:function(t){var e=this._map,i=e.options,n=!i.inertia||t.noInertia||this._times.length<2;if(e.fire("dragend",t),n)e.fire("moveend");else{this._prunePositions(+new Date);var r=this._lastPos.subtract(this._positions[0]),o=(this._lastTime-this._times[0])/1e3,s=i.easeLinearity,a=r.multiplyBy(s/o),l=a.distanceTo([0,0]),h=Math.min(i.inertiaMaxSpeed,l),c=a.multiplyBy(h/l),u=h/(i.inertiaDeceleration*s),d=c.multiplyBy(-u/2).round();d.x||d.y?(d=e._limitOffset(d,e.options.maxBounds),k((function(){e.panBy(d,{duration:u,easeLinearity:s,noMoveStart:!0,animate:!0})}))):e.fire("moveend")}}});We.addInitHook("addHandler","dragging",bn),We.mergeOptions({keyboard:!0,keyboardPanDelta:80});var xn=ti.extend({keyCodes:{left:[37],right:[39],down:[40],up:[38],zoomIn:[187,107,61,171],zoomOut:[189,109,54,173]},initialize:function(t){this._map=t,this._setPanDelta(t.options.keyboardPanDelta),this._setZoomDelta(t.options.zoomDelta)},addHooks:function(){var t=this._map._container;t.tabIndex<=0&&(t.tabIndex="0"),Pe(t,{focus:this._onFocus,blur:this._onBlur,mousedown:this._onMouseDown},this),this._map.on({focus:this._addHooks,blur:this._removeHooks},this)},removeHooks:function(){this._removeHooks(),Ee(this._map._container,{focus:this._onFocus,blur:this._onBlur,mousedown:this._onMouseDown},this),this._map.off({focus:this._addHooks,blur:this._removeHooks},this)},_onMouseDown:function(){if(!this._focused){var t=document.body,e=document.documentElement,i=t.scrollTop||e.scrollTop,n=t.scrollLeft||e.scrollLeft;this._map._container.focus(),window.scrollTo(n,i)}},_onFocus:function(){this._focused=!0,this._map.fire("focus")},_onBlur:function(){this._focused=!1,this._map.fire("blur")},_setPanDelta:function(t){var e,i,n=this._panKeys={},r=this.keyCodes;for(e=0,i=r.left.length;e<i;e++)n[r.left[e]]=[-1*t,0];for(e=0,i=r.right.length;e<i;e++)n[r.right[e]]=[t,0];for(e=0,i=r.down.length;e<i;e++)n[r.down[e]]=[0,t];for(e=0,i=r.up.length;e<i;e++)n[r.up[e]]=[0,-1*t]},_setZoomDelta:function(t){var e,i,n=this._zoomKeys={},r=this.keyCodes;for(e=0,i=r.zoomIn.length;e<i;e++)n[r.zoomIn[e]]=t;for(e=0,i=r.zoomOut.length;e<i;e++)n[r.zoomOut[e]]=-t},_addHooks:function(){Pe(document,"keydown",this._onKeyDown,this)},_removeHooks:function(){Ee(document,"keydown",this._onKeyDown,this)},_onKeyDown:function(t){if(!(t.altKey||t.ctrlKey||t.metaKey)){var e,i=t.keyCode,n=this._map;if(i in this._panKeys){if(!n._panAnim||!n._panAnim._inProgress)if(e=this._panKeys[i],t.shiftKey&&(e=D(e).multiplyBy(3)),n.options.maxBounds&&(e=n._limitOffset(D(e),n.options.maxBounds)),n.options.worldCopyJump){var r=n.wrapLatLng(n.unproject(n.project(n.getCenter()).add(e)));n.panTo(r)}else n.panBy(e)}else if(i in this._zoomKeys)n.setZoom(n.getZoom()+(t.shiftKey?3:1)*this._zoomKeys[i]);else{if(27!==i||!n._popup||!n._popup.options.closeOnEscapeKey)return;n.closePopup()}Ne(t)}}});We.addInitHook("addHandler","keyboard",xn),We.mergeOptions({scrollWheelZoom:!0,wheelDebounceTime:40,wheelPxPerZoomLevel:60});var wn=ti.extend({addHooks:function(){Pe(this._map._container,"wheel",this._onWheelScroll,this),this._delta=0},removeHooks:function(){Ee(this._map._container,"wheel",this._onWheelScroll,this)},_onWheelScroll:function(t){var e=He(t),i=this._map.options.wheelDebounceTime;this._delta+=e,this._lastMousePos=this._map.mouseEventToContainerPoint(t),this._startTime||(this._startTime=+new Date);var r=Math.max(i-(+new Date-this._startTime),0);clearTimeout(this._timer),this._timer=setTimeout(n(this._performZoom,this),r),Ne(t)},_performZoom:function(){var t=this._map,e=t.getZoom(),i=this._map.options.zoomSnap||0;t._stop();var n=this._delta/(4*this._map.options.wheelPxPerZoomLevel),r=4*Math.log(2/(1+Math.exp(-Math.abs(n))))/Math.LN2,o=i?Math.ceil(r/i)*i:r,s=t._limitZoom(e+(this._delta>0?o:-o))-e;this._delta=0,this._startTime=null,s&&("center"===t.options.scrollWheelZoom?t.setZoom(e+s):t.setZoomAround(this._lastMousePos,e+s))}});We.addInitHook("addHandler","scrollWheelZoom",wn);We.mergeOptions({tapHold:zt.touchNative&&zt.safari&&zt.mobile,tapTolerance:15});var Ln=ti.extend({addHooks:function(){Pe(this._map._container,"touchstart",this._onDown,this)},removeHooks:function(){Ee(this._map._container,"touchstart",this._onDown,this)},_onDown:function(t){if(clearTimeout(this._holdTimeout),1===t.touches.length){var e=t.touches[0];this._startPos=this._newPos=new I(e.clientX,e.clientY),this._holdTimeout=setTimeout(n((function(){this._cancel(),this._isTapValid()&&(Pe(document,"touchend",je),Pe(document,"touchend touchcancel",this._cancelClickPrevent),this._simulateEvent("contextmenu",e))}),this),600),Pe(document,"touchend touchcancel contextmenu",this._cancel,this),Pe(document,"touchmove",this._onMove,this)}},_cancelClickPrevent:function t(){Ee(document,"touchend",je),Ee(document,"touchend touchcancel",t)},_cancel:function(){clearTimeout(this._holdTimeout),Ee(document,"touchend touchcancel contextmenu",this._cancel,this),Ee(document,"touchmove",this._onMove,this)},_onMove:function(t){var e=t.touches[0];this._newPos=new I(e.clientX,e.clientY)},_isTapValid:function(){return this._newPos.distanceTo(this._startPos)<=this._map.options.tapTolerance},_simulateEvent:function(t,e){var i=new MouseEvent(t,{bubbles:!0,cancelable:!0,view:window,screenX:e.screenX,screenY:e.screenY,clientX:e.clientX,clientY:e.clientY});i._simulated=!0,e.target.dispatchEvent(i)}});We.addInitHook("addHandler","tapHold",Ln),We.mergeOptions({touchZoom:zt.touch,bounceAtZoomLimits:!0});var Mn=ti.extend({addHooks:function(){ue(this._map._container,"leaflet-touch-zoom"),Pe(this._map._container,"touchstart",this._onTouchStart,this)},removeHooks:function(){de(this._map._container,"leaflet-touch-zoom"),Ee(this._map._container,"touchstart",this._onTouchStart,this)},_onTouchStart:function(t){var e=this._map;if(t.touches&&2===t.touches.length&&!e._animatingZoom&&!this._zooming){var i=e.mouseEventToContainerPoint(t.touches[0]),n=e.mouseEventToContainerPoint(t.touches[1]);this._centerPoint=e.getSize()._divideBy(2),this._startLatLng=e.containerPointToLatLng(this._centerPoint),"center"!==e.options.touchZoom&&(this._pinchStartLatLng=e.containerPointToLatLng(i.add(n)._divideBy(2))),this._startDist=i.distanceTo(n),this._startZoom=e.getZoom(),this._moved=!1,this._zooming=!0,e._stop(),Pe(document,"touchmove",this._onTouchMove,this),Pe(document,"touchend touchcancel",this._onTouchEnd,this),je(t)}},_onTouchMove:function(t){if(t.touches&&2===t.touches.length&&this._zooming){var e=this._map,i=e.mouseEventToContainerPoint(t.touches[0]),r=e.mouseEventToContainerPoint(t.touches[1]),o=i.distanceTo(r)/this._startDist;if(this._zoom=e.getScaleZoom(o,this._startZoom),!e.options.bounceAtZoomLimits&&(this._zoom<e.getMinZoom()&&o<1||this._zoom>e.getMaxZoom()&&o>1)&&(this._zoom=e._limitZoom(this._zoom)),"center"===e.options.touchZoom){if(this._center=this._startLatLng,1===o)return}else{var s=i._add(r)._divideBy(2)._subtract(this._centerPoint);if(1===o&&0===s.x&&0===s.y)return;this._center=e.unproject(e.project(this._pinchStartLatLng,this._zoom).subtract(s),this._zoom)}this._moved||(e._moveStart(!0,!1),this._moved=!0),C(this._animRequest);var a=n(e._move,e,this._center,this._zoom,{pinch:!0,round:!1},void 0);this._animRequest=k(a,this,!0),je(t)}},_onTouchEnd:function(){this._moved&&this._zooming?(this._zooming=!1,C(this._animRequest),Ee(document,"touchmove",this._onTouchMove,this),Ee(document,"touchend touchcancel",this._onTouchEnd,this),this._map.options.zoomAnimation?this._map._animateZoom(this._center,this._map._limitZoom(this._zoom),!0,this._map.options.zoomSnap):this._map._resetView(this._center,this._map._limitZoom(this._zoom))):this._zooming=!1}});We.addInitHook("addHandler","touchZoom",Mn),We.BoxZoom=yn,We.DoubleClickZoom=vn,We.Drag=bn,We.Keyboard=xn,We.ScrollWheelZoom=wn,We.TapHold=Ln,We.TouchZoom=Mn,t.Bounds=z,t.Browser=zt,t.CRS=G,t.Canvas=cn,t.Circle=Oi,t.CircleMarker=Bi,t.Class=P,t.Control=Ke,t.DivIcon=rn,t.DivOverlay=tn,t.DomEvent=Ze,t.DomUtil=Ae,t.Draggable=ni,t.Evented=E,t.FeatureGroup=Si,t.GeoJSON=Ni,t.GridLayer=on,t.Handler=ti,t.Icon=Ei,t.ImageOverlay=Ji,t.LatLng=j,t.LatLngBounds=O,t.Layer=Ai,t.LayerGroup=Pi,t.LineUtil=bi,t.Map=We,t.Marker=Di,t.Mixin=ei,t.Path=zi,t.Point=I,t.PolyUtil=li,t.Polygon=ji,t.Polyline=Ri,t.Popup=en,t.PosAnimation=qe,t.Projection=Li,t.Rectangle=_n,t.Renderer=hn,t.SVG=mn,t.SVGOverlay=$i,t.TileLayer=sn,t.Tooltip=nn,t.Transformation=Z,t.Util=A,t.VideoOverlay=Qi,t.bind=n,t.bounds=B,t.canvas=un,t.circle=function(t,e,i){return new Oi(t,e,i)},t.circleMarker=function(t,e){return new Bi(t,e)},t.control=Ye,t.divIcon=function(t){return new rn(t)},t.extend=e,t.featureGroup=function(t,e){return new Si(t,e)},t.geoJSON=Yi,t.geoJson=Xi,t.gridLayer=function(t){return new on(t)},t.icon=function(t){return new Ei(t)},t.imageOverlay=function(t,e,i){return new Ji(t,e,i)},t.latLng=N,t.latLngBounds=R,t.layerGroup=function(t,e){return new Pi(t,e)},t.map=function(t,e){return new We(t,e)},t.marker=function(t,e){return new Di(t,e)},t.point=D,t.polygon=function(t,e){return new ji(t,e)},t.polyline=function(t,e){return new Ri(t,e)},t.popup=function(t,e){return new en(t,e)},t.rectangle=function(t,e){return new _n(t,e)},t.setOptions=d,t.stamp=o,t.svg=gn,t.svgOverlay=function(t,e,i){return new $i(t,e,i)},t.tileLayer=an,t.tooltip=function(t,e){return new nn(t,e)},t.transformation=q,t.version="1.9.4",t.videoOverlay=function(t,e,i){return new Qi(t,e,i)};var kn=window.L;t.noConflict=function(){return window.L=kn,this},window.L=t}(e)},248:(t,e,i)=>{"use strict";i.r(e),i.d(e,{default:()=>li});var n=1,r=2,o=3,s=5,a=6378137,l=6356752.314,h=.0066943799901413165,c=484813681109536e-20,u=Math.PI/2,d=1e-10,p=.017453292519943295,f=57.29577951308232,m=Math.PI/4,g=2*Math.PI,_=3.14159265359,y={greenwich:0,lisbon:-9.131906111111,paris:2.337229166667,bogota:-74.080916666667,madrid:-3.687938888889,rome:12.452333333333,bern:7.439583333333,jakarta:106.807719444444,ferro:-17.666666666667,brussels:4.367975,stockholm:18.058277777778,athens:23.7163375,oslo:10.722916666667};const v={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}};var b=/[\s_\-\/\(\)]/g;function x(t,e){if(t[e])return t[e];for(var i,n=Object.keys(t),r=e.toLowerCase().replace(b,""),o=-1;++o<n.length;)if((i=n[o]).toLowerCase().replace(b,"")===r)return t[i]}function w(t){var e,i,n,r={},o=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,e){var i=e.split("=");return i.push(!0),t[i[0].toLowerCase()]=i[1],t}),{}),s={proj:"projName",datum:"datumCode",rf:function(t){r.rf=parseFloat(t)},lat_0:function(t){r.lat0=t*p},lat_1:function(t){r.lat1=t*p},lat_2:function(t){r.lat2=t*p},lat_ts:function(t){r.lat_ts=t*p},lon_0:function(t){r.long0=t*p},lon_1:function(t){r.long1=t*p},lon_2:function(t){r.long2=t*p},alpha:function(t){r.alpha=parseFloat(t)*p},gamma:function(t){r.rectified_grid_angle=parseFloat(t)},lonc:function(t){r.longc=t*p},x_0:function(t){r.x0=parseFloat(t)},y_0:function(t){r.y0=parseFloat(t)},k_0:function(t){r.k0=parseFloat(t)},k:function(t){r.k0=parseFloat(t)},a:function(t){r.a=parseFloat(t)},b:function(t){r.b=parseFloat(t)},r:function(t){r.a=r.b=parseFloat(t)},r_a:function(){r.R_A=!0},zone:function(t){r.zone=parseInt(t,10)},south:function(){r.utmSouth=!0},towgs84:function(t){r.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){r.to_meter=parseFloat(t)},units:function(t){r.units=t;var e=x(v,t);e&&(r.to_meter=e.to_meter)},from_greenwich:function(t){r.from_greenwich=t*p},pm:function(t){var e=x(y,t);r.from_greenwich=(e||parseFloat(t))*p},nadgrids:function(t){"@null"===t?r.datumCode="none":r.nadgrids=t},axis:function(t){var e="ewnsud";3===t.length&&-1!==e.indexOf(t.substr(0,1))&&-1!==e.indexOf(t.substr(1,1))&&-1!==e.indexOf(t.substr(2,1))&&(r.axis=t)},approx:function(){r.approx=!0}};for(e in o)i=o[e],e in s?"function"==typeof(n=s[e])?n(i):r[n]=i:r[e]=i;return"string"==typeof r.datumCode&&"WGS84"!==r.datumCode&&(r.datumCode=r.datumCode.toLowerCase()),r}const L=function(t){return new E(t).output()};var M=1,k=/\s/,C=/[A-Za-z]/,A=/[A-Za-z84_]/,P=/[,\]]/,S=/[\d\.E\-\+]/;function E(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=M}function I(t,e,i){Array.isArray(e)&&(i.unshift(e),e=null);var n=e?{}:t,r=i.reduce((function(t,e){return T(e,t),t}),n);e&&(t[e]=r)}function T(t,e){if(Array.isArray(t)){var i=t.shift();if("PARAMETER"===i&&(i=t.shift()),1===t.length)return Array.isArray(t[0])?(e[i]={},void T(t[0],e[i])):void(e[i]=t[0]);if(t.length)if("TOWGS84"!==i){if("AXIS"===i)return i in e||(e[i]=[]),void e[i].push(t);var n;switch(Array.isArray(i)||(e[i]={}),i){case"UNIT":case"PRIMEM":case"VERT_DATUM":return e[i]={name:t[0].toLowerCase(),convert:t[1]},void(3===t.length&&T(t[2],e[i]));case"SPHEROID":case"ELLIPSOID":return e[i]={name:t[0],a:t[1],rf:t[2]},void(4===t.length&&T(t[3],e[i]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return t[0]=["name",t[0]],void I(e,i,t);default:for(n=-1;++n<t.length;)if(!Array.isArray(t[n]))return T(t,e[i]);return I(e,i,t)}}else e[i]=t;else e[i]=!0}else e[t]=!0}E.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;k.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case M:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},E.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(P.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},E.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=M)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=M,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},E.prototype.number=function(t){if(!S.test(t)){if(P.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},E.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},E.prototype.keyword=function(t){if(A.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=M)}if(!P.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},E.prototype.neutral=function(t){if(C.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(S.test(t))return this.word=t,void(this.state=3);if(!P.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},E.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)};var D=.017453292519943295;function z(t){return t*D}function B(t){var e=L(t),i=e.shift(),n=e.shift();e.unshift(["name",n]),e.unshift(["type",i]);var r={};return T(e,r),function(t){if("GEOGCS"===t.type?t.projName="longlat":"LOCAL_CS"===t.type?(t.projName="identity",t.local=!0):"object"==typeof t.PROJECTION?t.projName=Object.keys(t.PROJECTION)[0]:t.projName=t.PROJECTION,t.AXIS){for(var e="",i=0,n=t.AXIS.length;i<n;++i){var r=[t.AXIS[i][0].toLowerCase(),t.AXIS[i][1].toLowerCase()];-1!==r[0].indexOf("north")||("y"===r[0]||"lat"===r[0])&&"north"===r[1]?e+="n":-1!==r[0].indexOf("south")||("y"===r[0]||"lat"===r[0])&&"south"===r[1]?e+="s":-1!==r[0].indexOf("east")||("x"===r[0]||"lon"===r[0])&&"east"===r[1]?e+="e":-1===r[0].indexOf("west")&&("x"!==r[0]&&"lon"!==r[0]||"west"!==r[1])||(e+="w")}2===e.length&&(e+="u"),3===e.length&&(t.axis=e)}t.UNIT&&(t.units=t.UNIT.name.toLowerCase(),"metre"===t.units&&(t.units="meter"),t.UNIT.convert&&("GEOGCS"===t.type?t.DATUM&&t.DATUM.SPHEROID&&(t.to_meter=t.UNIT.convert*t.DATUM.SPHEROID.a):t.to_meter=t.UNIT.convert));var o=t.GEOGCS;function s(e){return e*(t.to_meter||1)}"GEOGCS"===t.type&&(o=t),o&&(o.DATUM?t.datumCode=o.DATUM.name.toLowerCase():t.datumCode=o.name.toLowerCase(),"d_"===t.datumCode.slice(0,2)&&(t.datumCode=t.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==t.datumCode&&"new_zealand_1949"!==t.datumCode||(t.datumCode="nzgd49"),"wgs_1984"!==t.datumCode&&"world_geodetic_system_1984"!==t.datumCode||("Mercator_Auxiliary_Sphere"===t.PROJECTION&&(t.sphere=!0),t.datumCode="wgs84"),"_ferro"===t.datumCode.slice(-6)&&(t.datumCode=t.datumCode.slice(0,-6)),"_jakarta"===t.datumCode.slice(-8)&&(t.datumCode=t.datumCode.slice(0,-8)),~t.datumCode.indexOf("belge")&&(t.datumCode="rnb72"),o.DATUM&&o.DATUM.SPHEROID&&(t.ellps=o.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===t.ellps.toLowerCase().slice(0,13)&&(t.ellps="intl"),t.a=o.DATUM.SPHEROID.a,t.rf=parseFloat(o.DATUM.SPHEROID.rf,10)),o.DATUM&&o.DATUM.TOWGS84&&(t.datum_params=o.DATUM.TOWGS84),~t.datumCode.indexOf("osgb_1936")&&(t.datumCode="osgb36"),~t.datumCode.indexOf("osni_1952")&&(t.datumCode="osni52"),(~t.datumCode.indexOf("tm65")||~t.datumCode.indexOf("geodetic_datum_of_1965"))&&(t.datumCode="ire65"),"ch1903+"===t.datumCode&&(t.datumCode="ch1903"),~t.datumCode.indexOf("israel")&&(t.datumCode="isr93")),t.b&&!isFinite(t.b)&&(t.b=t.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_1","Latitude of 1st standard parallel"],["standard_parallel_2","Standard_Parallel_2"],["standard_parallel_2","Latitude of 2nd standard parallel"],["false_easting","False_Easting"],["false_easting","False easting"],["false-easting","Easting at false origin"],["false_northing","False_Northing"],["false_northing","False northing"],["false_northing","Northing at false origin"],["central_meridian","Central_Meridian"],["central_meridian","Longitude of natural origin"],["central_meridian","Longitude of false origin"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["latitude_of_origin","Latitude of natural origin"],["latitude_of_origin","Latitude of false origin"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",z],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",z],["x0","false_easting",s],["y0","false_northing",s],["long0","central_meridian",z],["lat0","latitude_of_origin",z],["lat0","standard_parallel_1",z],["lat1","standard_parallel_1",z],["lat2","standard_parallel_2",z],["azimuth","Azimuth"],["alpha","azimuth",z],["srsCode","name"]].forEach((function(e){return function(t,e){var i=e[0],n=e[1];!(i in t)&&n in t&&(t[i]=t[n],3===e.length&&(t[i]=e[2](t[i])))}(t,e)})),t.long0||!t.longc||"Albers_Conic_Equal_Area"!==t.projName&&"Lambert_Azimuthal_Equal_Area"!==t.projName||(t.long0=t.longc),t.lat_ts||!t.lat1||"Stereographic_South_Pole"!==t.projName&&"Polar Stereographic (variant B)"!==t.projName?!t.lat_ts&&t.lat0&&"Polar_Stereographic"===t.projName&&(t.lat_ts=t.lat0,t.lat0=z(t.lat0>0?90:-90)):(t.lat0=z(t.lat1>0?90:-90),t.lat_ts=t.lat1)}(r),r}function O(t){var e=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?O[t]=w(arguments[1]):O[t]=B(arguments[1]):O[t]=i}else if(1===arguments.length){if(Array.isArray(t))return t.map((function(t){Array.isArray(t)?O.apply(e,t):O(t)}));if("string"==typeof t){if(t in O)return O[t]}else"EPSG"in t?O["EPSG:"+t.EPSG]=t:"ESRI"in t?O["ESRI:"+t.ESRI]=t:"IAU2000"in t?O["IAU2000:"+t.IAU2000]=t:console.log(t);return}}!function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}(O);const R=O;var j=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"],N=["3857","900913","3785","102113"];function F(t,e){var i,n;if(t=t||{},!e)return t;for(n in e)void 0!==(i=e[n])&&(t[n]=i);return t}function G(t,e,i){var n=t*e;return i/Math.sqrt(1-n*n)}function U(t){return t<0?-1:1}function H(t){return Math.abs(t)<=_?t:t-U(t)*g}function V(t,e,i){var n=t*i,r=.5*t;return n=Math.pow((1-n)/(1+n),r),Math.tan(.5*(u-e))/n}function Z(t,e){for(var i,n,r=.5*t,o=u-2*Math.atan(e),s=0;s<=15;s++)if(i=t*Math.sin(o),o+=n=u-2*Math.atan(e*Math.pow((1-i)/(1+i),r))-o,Math.abs(n)<=1e-10)return o;return-9999}function q(t){return t}var W=[{init:function(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=G(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)},forward:function(t){var e,i,n=t.x,r=t.y;if(r*f>90&&r*f<-90&&n*f>180&&n*f<-180)return null;if(Math.abs(Math.abs(r)-u)<=d)return null;if(this.sphere)e=this.x0+this.a*this.k0*H(n-this.long0),i=this.y0+this.a*this.k0*Math.log(Math.tan(m+.5*r));else{var o=Math.sin(r),s=V(this.e,r,o);e=this.x0+this.a*this.k0*H(n-this.long0),i=this.y0-this.a*this.k0*Math.log(s)}return t.x=e,t.y=i,t},inverse:function(t){var e,i,n=t.x-this.x0,r=t.y-this.y0;if(this.sphere)i=u-2*Math.atan(Math.exp(-r/(this.a*this.k0)));else{var o=Math.exp(-r/(this.a*this.k0));if(-9999===(i=Z(this.e,o)))return null}return e=H(this.long0+n/(this.a*this.k0)),t.x=e,t.y=i,t},names:["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"]},{init:function(){},forward:q,inverse:q,names:["longlat","identity"]}],K={},Y=[];function X(t,e){var i=Y.length;return t.names?(Y[i]=t,t.names.forEach((function(t){K[t.toLowerCase()]=i})),this):(console.log(e),!0)}const J={start:function(){W.forEach(X)},add:X,get:function(t){if(!t)return!1;var e=t.toLowerCase();return void 0!==K[e]&&Y[K[e]]?Y[K[e]]:void 0}};var Q={MERIT:{a:6378137,rf:298.257,ellipseName:"MERIT 1983"},SGS85:{a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},GRS80:{a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},IAU76:{a:6378140,rf:298.257,ellipseName:"IAU 1976"},airy:{a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},APL4:{a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},NWL9D:{a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},mod_airy:{a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},andrae:{a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},aust_SA:{a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},GRS67:{a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},bessel:{a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},bess_nam:{a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},clrk66:{a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},clrk80:{a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},clrk80ign:{a:6378249.2,b:6356515,rf:293.4660213,ellipseName:"Clarke 1880 (IGN)"},clrk58:{a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},CPM:{a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},delmbr:{a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},engelis:{a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},evrst30:{a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},evrst48:{a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},evrst56:{a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},evrst69:{a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},evrstSS:{a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},fschr60:{a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},fschr60m:{a:6378155,rf:298.3,ellipseName:"Fischer 1960"},fschr68:{a:6378150,rf:298.3,ellipseName:"Fischer 1968"},helmert:{a:6378200,rf:298.3,ellipseName:"Helmert 1906"},hough:{a:6378270,rf:297,ellipseName:"Hough"},intl:{a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},kaula:{a:6378163,rf:298.24,ellipseName:"Kaula 1961"},lerch:{a:6378139,rf:298.257,ellipseName:"Lerch 1979"},mprts:{a:6397300,rf:191,ellipseName:"Maupertius 1738"},new_intl:{a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},plessis:{a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},krass:{a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},SEasia:{a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},walbeck:{a:6376896,b:6355834.8467,ellipseName:"Walbeck"},WGS60:{a:6378165,rf:298.3,ellipseName:"WGS 60"},WGS66:{a:6378145,rf:298.25,ellipseName:"WGS 66"},WGS7:{a:6378135,rf:298.26,ellipseName:"WGS 72"}},$=Q.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"};Q.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"};var tt={wgs84:{towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},ch1903:{towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},ggrs87:{towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},nad83:{towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},nad27:{nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},potsdam:{towgs84:"598.1,73.7,418.2,0.202,0.045,-2.455,6.7",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},carthage:{towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},hermannskogel:{towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Hermannskogel"},militargeographische_institut:{towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Militar-Geographische Institut"},osni52:{towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},ire65:{towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},rassadiran:{towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},nzgd49:{towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},osgb36:{towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},s_jtsk:{towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},beduaram:{towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},gunung_segara:{towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},rnb72:{towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}};var et={};function it(t){if(0===t.length)return null;var e="@"===t[0];return e&&(t=t.slice(1)),"null"===t?{name:"null",mandatory:!e,grid:null,isNull:!0}:{name:t,mandatory:!e,grid:et[t]||null,isNull:!1}}function nt(t){return t/3600*Math.PI/180}function rt(t,e,i){return String.fromCharCode.apply(null,new Uint8Array(t.buffer.slice(e,i)))}function ot(t){return t.map((function(t){return[nt(t.longitudeShift),nt(t.latitudeShift)]}))}function st(t,e,i){return{name:rt(t,e+8,e+16).trim(),parent:rt(t,e+24,e+24+8).trim(),lowerLatitude:t.getFloat64(e+72,i),upperLatitude:t.getFloat64(e+88,i),lowerLongitude:t.getFloat64(e+104,i),upperLongitude:t.getFloat64(e+120,i),latitudeInterval:t.getFloat64(e+136,i),longitudeInterval:t.getFloat64(e+152,i),gridNodeCount:t.getInt32(e+168,i)}}function at(t,e,i,n){for(var r=e+176,o=[],s=0;s<i.gridNodeCount;s++){var a={latitudeShift:t.getFloat32(r+16*s,n),longitudeShift:t.getFloat32(r+16*s+4,n),latitudeAccuracy:t.getFloat32(r+16*s+8,n),longitudeAccuracy:t.getFloat32(r+16*s+12,n)};o.push(a)}return o}function lt(t,e){if(!(this instanceof lt))return new lt(t);e=e||function(t){if(t)throw t};var i=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in R}(t))return R[t];if(function(t){return j.some((function(e){return t.indexOf(e)>-1}))}(t)){var e=B(t);if(function(t){var e=x(t,"authority");if(e){var i=x(e,"epsg");return i&&N.indexOf(i)>-1}}(e))return R["EPSG:3857"];var i=function(t){var e=x(t,"extension");if(e)return x(e,"proj4")}(e);return i?w(i):e}return function(t){return"+"===t[0]}(t)?w(t):void 0}(t);if("object"==typeof i){var a=lt.projections.get(i.projName);if(a){if(i.datumCode&&"none"!==i.datumCode){var l=x(tt,i.datumCode);l&&(i.datum_params=i.datum_params||(l.towgs84?l.towgs84.split(","):null),i.ellps=l.ellipse,i.datumName=l.datumName?l.datumName:i.datumCode)}i.k0=i.k0||1,i.axis=i.axis||"enu",i.ellps=i.ellps||"wgs84",i.lat1=i.lat1||i.lat0;var h,u,p,f,m,g,_=function(t,e,i,n,r){if(!t){var o=x(Q,n);o||(o=$),t=o.a,e=o.b,i=o.rf}return i&&!e&&(e=(1-1/i)*t),(0===i||Math.abs(t-e)<d)&&(r=!0,e=t),{a:t,b:e,rf:i,sphere:r}}(i.a,i.b,i.rf,i.ellps,i.sphere),y=(h=_.a,u=_.b,_.rf,m=((p=h*h)-(f=u*u))/p,g=0,i.R_A?(p=(h*=1-m*(.16666666666666666+m*(.04722222222222222+.022156084656084655*m)))*h,m=0):g=Math.sqrt(m),{es:m,e:g,ep2:(p-f)/f}),v=function(t){return void 0===t?null:t.split(",").map(it)}(i.nadgrids),b=i.datum||function(t,e,i,a,l,h,u){var d={};return d.datum_type=void 0===t||"none"===t?s:4,e&&(d.datum_params=e.map(parseFloat),0===d.datum_params[0]&&0===d.datum_params[1]&&0===d.datum_params[2]||(d.datum_type=n),d.datum_params.length>3&&(0===d.datum_params[3]&&0===d.datum_params[4]&&0===d.datum_params[5]&&0===d.datum_params[6]||(d.datum_type=r,d.datum_params[3]*=c,d.datum_params[4]*=c,d.datum_params[5]*=c,d.datum_params[6]=d.datum_params[6]/1e6+1))),u&&(d.datum_type=o,d.grids=u),d.a=i,d.b=a,d.es=l,d.ep2=h,d}(i.datumCode,i.datum_params,_.a,_.b,y.es,y.ep2,v);F(this,i),F(this,a),this.a=_.a,this.b=_.b,this.rf=_.rf,this.sphere=_.sphere,this.es=y.es,this.e=y.e,this.ep2=y.ep2,this.datum=b,this.init(),e(null,this)}else e(t)}else e(t)}lt.projections=J,lt.projections.start();const ht=lt;function ct(t,e,i){var n,r,o,s,a=t.x,l=t.y,h=t.z?t.z:0;if(l<-u&&l>-1.001*u)l=-u;else if(l>u&&l<1.001*u)l=u;else{if(l<-u)return{x:-1/0,y:-1/0,z:t.z};if(l>u)return{x:1/0,y:1/0,z:t.z}}return a>Math.PI&&(a-=2*Math.PI),r=Math.sin(l),s=Math.cos(l),o=r*r,{x:((n=i/Math.sqrt(1-e*o))+h)*s*Math.cos(a),y:(n+h)*s*Math.sin(a),z:(n*(1-e)+h)*r}}function ut(t,e,i,n){var r,o,s,a,l,h,c,u,d,p,f,m,g,_,y,v=t.x,b=t.y,x=t.z?t.z:0;if(r=Math.sqrt(v*v+b*b),o=Math.sqrt(v*v+b*b+x*x),r/i<1e-12){if(_=0,o/i<1e-12)return y=-n,{x:t.x,y:t.y,z:t.z}}else _=Math.atan2(b,v);s=x/o,u=(a=r/o)*(1-e)*(l=1/Math.sqrt(1-e*(2-e)*a*a)),d=s*l,g=0;do{g++,h=e*(c=i/Math.sqrt(1-e*d*d))/(c+(y=r*u+x*d-c*(1-e*d*d))),m=(f=s*(l=1/Math.sqrt(1-h*(2-h)*a*a)))*u-(p=a*(1-h)*l)*d,u=p,d=f}while(m*m>1e-24&&g<30);return{x:_,y:Math.atan(f/Math.abs(p)),z:y}}function dt(t){return t===n||t===r}function pt(t,e,i){if(null===t.grids||0===t.grids.length)return console.log("Grid shift grids not found"),-1;var n={x:-i.x,y:i.y},r={x:Number.NaN,y:Number.NaN},o=[];t:for(var s=0;s<t.grids.length;s++){var a=t.grids[s];if(o.push(a.name),a.isNull){r=n;break}if(a.mandatory,null!==a.grid)for(var l=a.grid.subgrids,h=0,c=l.length;h<c;h++){var u=l[h],d=(Math.abs(u.del[1])+Math.abs(u.del[0]))/1e4,p=u.ll[0]-d,m=u.ll[1]-d,g=u.ll[0]+(u.lim[0]-1)*u.del[0]+d,_=u.ll[1]+(u.lim[1]-1)*u.del[1]+d;if(!(m>n.y||p>n.x||_<n.y||g<n.x||(r=ft(n,e,u),isNaN(r.x))))break t}else if(a.mandatory)return console.log("Unable to find mandatory grid '"+a.name+"'"),-1}return isNaN(r.x)?(console.log("Failed to find a grid shift table for location '"+-n.x*f+" "+n.y*f+" tried: '"+o+"'"),-1):(i.x=-r.x,i.y=r.y,0)}function ft(t,e,i){var n={x:Number.NaN,y:Number.NaN};if(isNaN(t.x))return n;var r={x:t.x,y:t.y};r.x-=i.ll[0],r.y-=i.ll[1],r.x=H(r.x-Math.PI)+Math.PI;var o=mt(r,i);if(e){if(isNaN(o.x))return n;o.x=r.x-o.x,o.y=r.y-o.y;var s,a,l=9;do{if(a=mt(o,i),isNaN(a.x)){console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");break}s={x:r.x-(a.x+o.x),y:r.y-(a.y+o.y)},o.x+=s.x,o.y+=s.y}while(l--&&Math.abs(s.x)>1e-12&&Math.abs(s.y)>1e-12);if(l<0)return console.log("Inverse grid shift iterator failed to converge."),n;n.x=H(o.x+i.ll[0]),n.y=o.y+i.ll[1]}else isNaN(o.x)||(n.x=t.x+o.x,n.y=t.y+o.y);return n}function mt(t,e){var i,n={x:t.x/e.del[0],y:t.y/e.del[1]},r=Math.floor(n.x),o=Math.floor(n.y),s=n.x-1*r,a=n.y-1*o,l={x:Number.NaN,y:Number.NaN};if(r<0||r>=e.lim[0])return l;if(o<0||o>=e.lim[1])return l;i=o*e.lim[0]+r;var h=e.cvs[i][0],c=e.cvs[i][1];i++;var u=e.cvs[i][0],d=e.cvs[i][1];i+=e.lim[0];var p=e.cvs[i][0],f=e.cvs[i][1];i--;var m=e.cvs[i][0],g=e.cvs[i][1],_=s*a,y=s*(1-a),v=(1-s)*(1-a),b=(1-s)*a;return l.x=v*h+y*u+b*m+_*p,l.y=v*c+y*d+b*g+_*f,l}function gt(t,e,i){var n,r,o,s=i.x,a=i.y,l=i.z||0,h={};for(o=0;o<3;o++)if(!e||2!==o||void 0!==i.z)switch(0===o?(n=s,r=-1!=="ew".indexOf(t.axis[o])?"x":"y"):1===o?(n=a,r=-1!=="ns".indexOf(t.axis[o])?"y":"x"):(n=l,r="z"),t.axis[o]){case"e":case"n":h[r]=n;break;case"w":case"s":h[r]=-n;break;case"u":void 0!==i[r]&&(h.z=n);break;case"d":void 0!==i[r]&&(h.z=-n);break;default:return null}return h}function _t(t){var e={x:t[0],y:t[1]};return t.length>2&&(e.z=t[2]),t.length>3&&(e.m=t[3]),e}function yt(t){if("function"==typeof Number.isFinite){if(Number.isFinite(t))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof t||t!=t||!isFinite(t))throw new TypeError("coordinates must be finite numbers")}function vt(t,e,i,c){var u,d=void 0!==(i=Array.isArray(i)?_t(i):{x:i.x,y:i.y,z:i.z,m:i.m}).z;if(function(t){yt(t.x),yt(t.y)}(i),t.datum&&e.datum&&function(t,e){return(t.datum.datum_type===n||t.datum.datum_type===r||t.datum.datum_type===o)&&"WGS84"!==e.datumCode||(e.datum.datum_type===n||e.datum.datum_type===r||e.datum.datum_type===o)&&"WGS84"!==t.datumCode}(t,e)&&(i=vt(t,u=new ht("WGS84"),i,c),t=u),c&&"enu"!==t.axis&&(i=gt(t,!1,i)),"longlat"===t.projName)i={x:i.x*p,y:i.y*p,z:i.z||0};else if(t.to_meter&&(i={x:i.x*t.to_meter,y:i.y*t.to_meter,z:i.z||0}),!(i=t.inverse(i)))return;if(t.from_greenwich&&(i.x+=t.from_greenwich),i=function(t,e,i){if(function(t,e){return t.datum_type===e.datum_type&&!(t.a!==e.a||Math.abs(t.es-e.es)>5e-11)&&(t.datum_type===n?t.datum_params[0]===e.datum_params[0]&&t.datum_params[1]===e.datum_params[1]&&t.datum_params[2]===e.datum_params[2]:t.datum_type!==r||t.datum_params[0]===e.datum_params[0]&&t.datum_params[1]===e.datum_params[1]&&t.datum_params[2]===e.datum_params[2]&&t.datum_params[3]===e.datum_params[3]&&t.datum_params[4]===e.datum_params[4]&&t.datum_params[5]===e.datum_params[5]&&t.datum_params[6]===e.datum_params[6])}(t,e))return i;if(t.datum_type===s||e.datum_type===s)return i;var c=t.a,u=t.es;if(t.datum_type===o){if(0!==pt(t,!1,i))return;c=a,u=h}var d=e.a,p=e.b,f=e.es;return e.datum_type===o&&(d=a,p=l,f=h),u!==f||c!==d||dt(t.datum_type)||dt(e.datum_type)?(i=ct(i,u,c),dt(t.datum_type)&&(i=function(t,e,i){if(e===n)return{x:t.x+i[0],y:t.y+i[1],z:t.z+i[2]};if(e===r){var o=i[0],s=i[1],a=i[2],l=i[3],h=i[4],c=i[5],u=i[6];return{x:u*(t.x-c*t.y+h*t.z)+o,y:u*(c*t.x+t.y-l*t.z)+s,z:u*(-h*t.x+l*t.y+t.z)+a}}}(i,t.datum_type,t.datum_params)),dt(e.datum_type)&&(i=function(t,e,i){if(e===n)return{x:t.x-i[0],y:t.y-i[1],z:t.z-i[2]};if(e===r){var o=i[0],s=i[1],a=i[2],l=i[3],h=i[4],c=i[5],u=i[6],d=(t.x-o)/u,p=(t.y-s)/u,f=(t.z-a)/u;return{x:d+c*p-h*f,y:-c*d+p+l*f,z:h*d-l*p+f}}}(i,e.datum_type,e.datum_params)),i=ut(i,f,d,p),e.datum_type!==o||0===pt(e,!0,i)?i:void 0):i}(t.datum,e.datum,i))return e.from_greenwich&&(i={x:i.x-e.from_greenwich,y:i.y,z:i.z||0}),"longlat"===e.projName?i={x:i.x*f,y:i.y*f,z:i.z||0}:(i=e.forward(i),e.to_meter&&(i={x:i.x/e.to_meter,y:i.y/e.to_meter,z:i.z||0})),c&&"enu"!==e.axis?gt(e,!0,i):(i&&!d&&delete i.z,i)}var bt=ht("WGS84");function xt(t,e,i,n){var r,o,s;return Array.isArray(i)?(r=vt(t,e,i,n)||{x:NaN,y:NaN},i.length>2?void 0!==t.name&&"geocent"===t.name||void 0!==e.name&&"geocent"===e.name?"number"==typeof r.z?[r.x,r.y,r.z].concat(i.splice(3)):[r.x,r.y,i[2]].concat(i.splice(3)):[r.x,r.y].concat(i.splice(2)):[r.x,r.y]):(o=vt(t,e,i,n),2===(s=Object.keys(i)).length||s.forEach((function(n){if(void 0!==t.name&&"geocent"===t.name||void 0!==e.name&&"geocent"===e.name){if("x"===n||"y"===n||"z"===n)return}else if("x"===n||"y"===n)return;o[n]=i[n]})),o)}function wt(t){return t instanceof ht?t:t.oProj?t.oProj:ht(t)}const Lt=function(t,e,i){t=wt(t);var n,r=!1;return void 0===e?(e=t,t=bt,r=!0):(void 0!==e.x||Array.isArray(e))&&(i=e,e=t,t=bt,r=!0),e=wt(e),i?xt(t,e,i):(n={forward:function(i,n){return xt(t,e,i,n)},inverse:function(i,n){return xt(e,t,i,n)}},r&&(n.oProj=e),n)};var Mt=6,kt="AJSAJS",Ct="AFAFAF",At=65,Pt=73,St=79,Et=86,It=90;const Tt={forward:Dt,inverse:function(t){var e=Rt(Nt(t.toUpperCase()));return e.lat&&e.lon?[e.lon,e.lat,e.lon,e.lat]:[e.left,e.bottom,e.right,e.top]},toPoint:zt};function Dt(t,e){return e=e||5,function(t,e){var i,n,r,o,s,a,l,h,c,u,d,p="00000"+t.easting,f="00000"+t.northing;return t.zoneNumber+t.zoneLetter+(c=t.easting,u=t.northing,d=jt(t.zoneNumber),i=Math.floor(c/1e5),n=Math.floor(u/1e5)%20,r=d-1,o=kt.charCodeAt(r),s=Ct.charCodeAt(r),h=!1,(a=o+i-1)>It&&(a=a-It+At-1,h=!0),(a===Pt||o<Pt&&a>Pt||(a>Pt||o<Pt)&&h)&&a++,(a===St||o<St&&a>St||(a>St||o<St)&&h)&&++a===Pt&&a++,a>It&&(a=a-It+At-1),(l=s+n)>Et?(l=l-Et+At-1,h=!0):h=!1,(l===Pt||s<Pt&&l>Pt||(l>Pt||s<Pt)&&h)&&l++,(l===St||s<St&&l>St||(l>St||s<St)&&h)&&++l===Pt&&l++,l>Et&&(l=l-Et+At-1),String.fromCharCode(a)+String.fromCharCode(l))+p.substr(p.length-5,e)+f.substr(f.length-5,e)}(function(t){var e,i,n,r,o,s,a,l=t.lat,h=t.lon,c=6378137,u=.00669438,d=.9996,p=Bt(l),f=Bt(h);a=Math.floor((h+180)/6)+1,180===h&&(a=60),l>=56&&l<64&&h>=3&&h<12&&(a=32),l>=72&&l<84&&(h>=0&&h<9?a=31:h>=9&&h<21?a=33:h>=21&&h<33?a=35:h>=33&&h<42&&(a=37)),s=Bt(6*(a-1)-180+3),e=.006739496752268451,i=c/Math.sqrt(1-u*Math.sin(p)*Math.sin(p)),n=Math.tan(p)*Math.tan(p),r=e*Math.cos(p)*Math.cos(p);var m,g,_=d*i*((o=Math.cos(p)*(f-s))+(1-n+r)*o*o*o/6+(5-18*n+n*n+72*r-58*e)*o*o*o*o*o/120)+5e5,y=d*(c*(.9983242984503243*p-.002514607064228144*Math.sin(2*p)+2639046602129982e-21*Math.sin(4*p)-3.418046101696858e-9*Math.sin(6*p))+i*Math.tan(p)*(o*o/2+(5-n+9*r+4*r*r)*o*o*o*o/24+(61-58*n+n*n+600*r-2.2240339282485886)*o*o*o*o*o*o/720));return l<0&&(y+=1e7),{northing:Math.round(y),easting:Math.round(_),zoneNumber:a,zoneLetter:(m=l,g="Z",84>=m&&m>=72?g="X":72>m&&m>=64?g="W":64>m&&m>=56?g="V":56>m&&m>=48?g="U":48>m&&m>=40?g="T":40>m&&m>=32?g="S":32>m&&m>=24?g="R":24>m&&m>=16?g="Q":16>m&&m>=8?g="P":8>m&&m>=0?g="N":0>m&&m>=-8?g="M":-8>m&&m>=-16?g="L":-16>m&&m>=-24?g="K":-24>m&&m>=-32?g="J":-32>m&&m>=-40?g="H":-40>m&&m>=-48?g="G":-48>m&&m>=-56?g="F":-56>m&&m>=-64?g="E":-64>m&&m>=-72?g="D":-72>m&&m>=-80&&(g="C"),g)}}({lat:t[1],lon:t[0]}),e)}function zt(t){var e=Rt(Nt(t.toUpperCase()));return e.lat&&e.lon?[e.lon,e.lat]:[(e.left+e.right)/2,(e.top+e.bottom)/2]}function Bt(t){return t*(Math.PI/180)}function Ot(t){return t/Math.PI*180}function Rt(t){var e=t.northing,i=t.easting,n=t.zoneLetter,r=t.zoneNumber;if(r<0||r>60)return null;var o,s,a,l,h,c,u,d,p,f=.9996,m=6378137,g=.00669438,_=(1-Math.sqrt(.99330562))/(1+Math.sqrt(.99330562)),y=i-5e5,v=e;n<"N"&&(v-=1e7),u=6*(r-1)-180+3,o=.006739496752268451,p=(d=v/f/6367449.145945056)+(3*_/2-27*_*_*_/32)*Math.sin(2*d)+(21*_*_/16-55*_*_*_*_/32)*Math.sin(4*d)+151*_*_*_/96*Math.sin(6*d),s=m/Math.sqrt(1-g*Math.sin(p)*Math.sin(p)),a=Math.tan(p)*Math.tan(p),l=o*Math.cos(p)*Math.cos(p),h=.99330562*m/Math.pow(1-g*Math.sin(p)*Math.sin(p),1.5),c=y/(s*f);var b=p-s*Math.tan(p)/h*(c*c/2-(5+3*a+10*l-4*l*l-9*o)*c*c*c*c/24+(61+90*a+298*l+45*a*a-1.6983531815716497-3*l*l)*c*c*c*c*c*c/720);b=Ot(b);var x,w=(c-(1+2*a+l)*c*c*c/6+(5-2*l+28*a-3*l*l+8*o+24*a*a)*c*c*c*c*c/120)/Math.cos(p);if(w=u+Ot(w),t.accuracy){var L=Rt({northing:t.northing+t.accuracy,easting:t.easting+t.accuracy,zoneLetter:t.zoneLetter,zoneNumber:t.zoneNumber});x={top:L.lat,right:L.lon,bottom:b,left:w}}else x={lat:b,lon:w};return x}function jt(t){var e=t%Mt;return 0===e&&(e=Mt),e}function Nt(t){if(t&&0===t.length)throw"MGRSPoint coverting from nothing";for(var e,i=t.length,n=null,r="",o=0;!/[A-Z]/.test(e=t.charAt(o));){if(o>=2)throw"MGRSPoint bad conversion from: "+t;r+=e,o++}var s=parseInt(r,10);if(0===o||o+3>i)throw"MGRSPoint bad conversion from: "+t;var a=t.charAt(o++);if(a<="A"||"B"===a||"Y"===a||a>="Z"||"I"===a||"O"===a)throw"MGRSPoint zone letter "+a+" not handled: "+t;n=t.substring(o,o+=2);for(var l=jt(s),h=function(t,e){for(var i=kt.charCodeAt(e-1),n=1e5,r=!1;i!==t.charCodeAt(0);){if(++i===Pt&&i++,i===St&&i++,i>It){if(r)throw"Bad character: "+t;i=At,r=!0}n+=1e5}return n}(n.charAt(0),l),c=function(t,e){if(t>"V")throw"MGRSPoint given invalid Northing "+t;for(var i=Ct.charCodeAt(e-1),n=0,r=!1;i!==t.charCodeAt(0);){if(++i===Pt&&i++,i===St&&i++,i>Et){if(r)throw"Bad character: "+t;i=At,r=!0}n+=1e5}return n}(n.charAt(1),l);c<Ft(a);)c+=2e6;var u=i-o;if(u%2!=0)throw"MGRSPoint has to have an even number \nof digits after the zone letter and two 100km letters - front \nhalf for easting meters, second half for \nnorthing meters"+t;var d,p,f,m=u/2,g=0,_=0;return m>0&&(d=1e5/Math.pow(10,m),p=t.substring(o,o+m),g=parseFloat(p)*d,f=t.substring(o+m),_=parseFloat(f)*d),{easting:g+h,northing:_+c,zoneLetter:a,zoneNumber:s,accuracy:d}}function Ft(t){var e;switch(t){case"C":e=11e5;break;case"D":e=2e6;break;case"E":e=28e5;break;case"F":e=37e5;break;case"G":e=46e5;break;case"H":e=55e5;break;case"J":e=64e5;break;case"K":e=73e5;break;case"L":e=82e5;break;case"M":e=91e5;break;case"N":e=0;break;case"P":e=8e5;break;case"Q":e=17e5;break;case"R":e=26e5;break;case"S":e=35e5;break;case"T":e=44e5;break;case"U":e=53e5;break;case"V":e=62e5;break;case"W":e=7e6;break;case"X":e=79e5;break;default:e=-1}if(e>=0)return e;throw"Invalid zone letter: "+t}function Gt(t,e,i){if(!(this instanceof Gt))return new Gt(t,e,i);if(Array.isArray(t))this.x=t[0],this.y=t[1],this.z=t[2]||0;else if("object"==typeof t)this.x=t.x,this.y=t.y,this.z=t.z||0;else if("string"==typeof t&&void 0===e){var n=t.split(",");this.x=parseFloat(n[0],10),this.y=parseFloat(n[1],10),this.z=parseFloat(n[2],10)||0}else this.x=t,this.y=e,this.z=i||0;console.warn("proj4.Point will be removed in version 3, use proj4.toPoint")}Gt.fromMGRS=function(t){return new Gt(zt(t))},Gt.prototype.toMGRS=function(t){return Dt([this.x,this.y],t)};const Ut=Gt;var Ht=.046875,Vt=.01953125,Zt=.01068115234375;function qt(t){var e=[];e[0]=1-t*(.25+t*(Ht+t*(Vt+t*Zt))),e[1]=t*(.75-t*(Ht+t*(Vt+t*Zt)));var i=t*t;return e[2]=i*(.46875-t*(.013020833333333334+.007120768229166667*t)),i*=t,e[3]=i*(.3645833333333333-.005696614583333333*t),e[4]=i*t*.3076171875,e}function Wt(t,e,i,n){return i*=e,e*=e,n[0]*t-i*(n[1]+e*(n[2]+e*(n[3]+e*n[4])))}function Kt(t,e,i){for(var n=1/(1-e),r=t,o=20;o;--o){var s=Math.sin(r),a=1-e*s*s;if(r-=a=(Wt(r,s,Math.cos(r),i)-t)*(a*Math.sqrt(a))*n,Math.abs(a)<d)return r}return r}const Yt={init:function(){this.x0=void 0!==this.x0?this.x0:0,this.y0=void 0!==this.y0?this.y0:0,this.long0=void 0!==this.long0?this.long0:0,this.lat0=void 0!==this.lat0?this.lat0:0,this.es&&(this.en=qt(this.es),this.ml0=Wt(this.lat0,Math.sin(this.lat0),Math.cos(this.lat0),this.en))},forward:function(t){var e,i,n,r=t.x,o=t.y,s=H(r-this.long0),a=Math.sin(o),l=Math.cos(o);if(this.es){var h=l*s,c=Math.pow(h,2),u=this.ep2*Math.pow(l,2),p=Math.pow(u,2),f=Math.abs(l)>d?Math.tan(o):0,m=Math.pow(f,2),g=Math.pow(m,2);e=1-this.es*Math.pow(a,2),h/=Math.sqrt(e);var _=Wt(o,a,l,this.en);i=this.a*(this.k0*h*(1+c/6*(1-m+u+c/20*(5-18*m+g+14*u-58*m*u+c/42*(61+179*g-g*m-479*m)))))+this.x0,n=this.a*(this.k0*(_-this.ml0+a*s*h/2*(1+c/12*(5-m+9*u+4*p+c/30*(61+g-58*m+270*u-330*m*u+c/56*(1385+543*g-g*m-3111*m))))))+this.y0}else{var y=l*Math.sin(s);if(Math.abs(Math.abs(y)-1)<d)return 93;if(i=.5*this.a*this.k0*Math.log((1+y)/(1-y))+this.x0,n=l*Math.cos(s)/Math.sqrt(1-Math.pow(y,2)),(y=Math.abs(n))>=1){if(y-1>d)return 93;n=0}else n=Math.acos(n);o<0&&(n=-n),n=this.a*this.k0*(n-this.lat0)+this.y0}return t.x=i,t.y=n,t},inverse:function(t){var e,i,n,r,o=(t.x-this.x0)*(1/this.a),s=(t.y-this.y0)*(1/this.a);if(this.es)if(i=Kt(e=this.ml0+s/this.k0,this.es,this.en),Math.abs(i)<u){var a=Math.sin(i),l=Math.cos(i),h=Math.abs(l)>d?Math.tan(i):0,c=this.ep2*Math.pow(l,2),p=Math.pow(c,2),f=Math.pow(h,2),m=Math.pow(f,2);e=1-this.es*Math.pow(a,2);var g=o*Math.sqrt(e)/this.k0,_=Math.pow(g,2);n=i-(e*=h)*_/(1-this.es)*.5*(1-_/12*(5+3*f-9*c*f+c-4*p-_/30*(61+90*f-252*c*f+45*m+46*c-_/56*(1385+3633*f+4095*m+1574*m*f)))),r=H(this.long0+g*(1-_/6*(1+2*f+c-_/20*(5+28*f+24*m+8*c*f+6*c-_/42*(61+662*f+1320*m+720*m*f))))/l)}else n=u*U(s),r=0;else{var y=Math.exp(o/this.k0),v=.5*(y-1/y),b=this.lat0+s/this.k0,x=Math.cos(b);e=Math.sqrt((1-Math.pow(x,2))/(1+Math.pow(v,2))),n=Math.asin(e),s<0&&(n=-n),r=0===v&&0===x?0:H(Math.atan2(v,x)+this.long0)}return t.x=r,t.y=n,t},names:["Fast_Transverse_Mercator","Fast Transverse Mercator"]};function Xt(t){var e=Math.exp(t);return(e-1/e)/2}function Jt(t,e){t=Math.abs(t),e=Math.abs(e);var i=Math.max(t,e),n=Math.min(t,e)/(i||1);return i*Math.sqrt(1+Math.pow(n,2))}function Qt(t,e){for(var i,n=2*Math.cos(2*e),r=t.length-1,o=t[r],s=0;--r>=0;)i=n*o-s+t[r],s=o,o=i;return e+i*Math.sin(2*e)}function $t(t,e,i){for(var n,r,o=Math.sin(e),s=Math.cos(e),a=Xt(i),l=function(t){var e=Math.exp(t);return(e+1/e)/2}(i),h=2*s*l,c=-2*o*a,u=t.length-1,d=t[u],p=0,f=0,m=0;--u>=0;)n=f,r=p,d=h*(f=d)-n-c*(p=m)+t[u],m=c*f-r+h*p;return[(h=o*l)*d-(c=s*a)*m,h*m+c*d]}const te={init:function(){if(!this.approx&&(isNaN(this.es)||this.es<=0))throw new Error('Incorrect elliptical usage. Try using the +approx option in the proj string, or PROJECTION["Fast_Transverse_Mercator"] in the WKT.');this.approx&&(Yt.init.apply(this),this.forward=Yt.forward,this.inverse=Yt.inverse),this.x0=void 0!==this.x0?this.x0:0,this.y0=void 0!==this.y0?this.y0:0,this.long0=void 0!==this.long0?this.long0:0,this.lat0=void 0!==this.lat0?this.lat0:0,this.cgb=[],this.cbg=[],this.utg=[],this.gtu=[];var t=this.es/(1+Math.sqrt(1-this.es)),e=t/(2-t),i=e;this.cgb[0]=e*(2+e*(-2/3+e*(e*(116/45+e*(26/45+e*(-2854/675)))-2))),this.cbg[0]=e*(e*(2/3+e*(4/3+e*(-82/45+e*(32/45+e*(4642/4725)))))-2),i*=e,this.cgb[1]=i*(7/3+e*(e*(-227/45+e*(2704/315+e*(2323/945)))-1.6)),this.cbg[1]=i*(5/3+e*(-16/15+e*(-13/9+e*(904/315+e*(-1522/945))))),i*=e,this.cgb[2]=i*(56/15+e*(-136/35+e*(-1262/105+e*(73814/2835)))),this.cbg[2]=i*(-26/15+e*(34/21+e*(1.6+e*(-12686/2835)))),i*=e,this.cgb[3]=i*(4279/630+e*(-332/35+e*(-399572/14175))),this.cbg[3]=i*(1237/630+e*(e*(-24832/14175)-2.4)),i*=e,this.cgb[4]=i*(4174/315+e*(-144838/6237)),this.cbg[4]=i*(-734/315+e*(109598/31185)),i*=e,this.cgb[5]=i*(601676/22275),this.cbg[5]=i*(444337/155925),i=Math.pow(e,2),this.Qn=this.k0/(1+e)*(1+i*(1/4+i*(1/64+i/256))),this.utg[0]=e*(e*(2/3+e*(-37/96+e*(1/360+e*(81/512+e*(-96199/604800)))))-.5),this.gtu[0]=e*(.5+e*(-2/3+e*(5/16+e*(41/180+e*(-127/288+e*(7891/37800)))))),this.utg[1]=i*(-1/48+e*(-1/15+e*(437/1440+e*(-46/105+e*(1118711/3870720))))),this.gtu[1]=i*(13/48+e*(e*(557/1440+e*(281/630+e*(-1983433/1935360)))-.6)),i*=e,this.utg[2]=i*(-17/480+e*(37/840+e*(209/4480+e*(-5569/90720)))),this.gtu[2]=i*(61/240+e*(-103/140+e*(15061/26880+e*(167603/181440)))),i*=e,this.utg[3]=i*(-4397/161280+e*(11/504+e*(830251/7257600))),this.gtu[3]=i*(49561/161280+e*(-179/168+e*(6601661/7257600))),i*=e,this.utg[4]=i*(-4583/161280+e*(108847/3991680)),this.gtu[4]=i*(34729/80640+e*(-3418889/1995840)),i*=e,this.utg[5]=i*(-20648693/638668800),this.gtu[5]=.6650675310896665*i;var n=Qt(this.cbg,this.lat0);this.Zb=-this.Qn*(n+function(t,e){for(var i,n=2*Math.cos(e),r=t.length-1,o=t[r],s=0;--r>=0;)i=n*o-s+t[r],s=o,o=i;return Math.sin(e)*i}(this.gtu,2*n))},forward:function(t){var e=H(t.x-this.long0),i=t.y;i=Qt(this.cbg,i);var n=Math.sin(i),r=Math.cos(i),o=Math.sin(e),s=Math.cos(e);i=Math.atan2(n,s*r),e=Math.atan2(o*r,Jt(n,r*s)),e=function(t){var e=Math.abs(t);return e=function(t){var e=1+t,i=e-1;return 0===i?t:t*Math.log(e)/i}(e*(1+e/(Jt(1,e)+1))),t<0?-e:e}(Math.tan(e));var a,l,h=$t(this.gtu,2*i,2*e);return i+=h[0],e+=h[1],Math.abs(e)<=2.623395162778?(a=this.a*(this.Qn*e)+this.x0,l=this.a*(this.Qn*i+this.Zb)+this.y0):(a=1/0,l=1/0),t.x=a,t.y=l,t},inverse:function(t){var e,i,n=(t.x-this.x0)*(1/this.a),r=(t.y-this.y0)*(1/this.a);if(r=(r-this.Zb)/this.Qn,n/=this.Qn,Math.abs(n)<=2.623395162778){var o=$t(this.utg,2*r,2*n);r+=o[0],n+=o[1],n=Math.atan(Xt(n));var s=Math.sin(r),a=Math.cos(r),l=Math.sin(n),h=Math.cos(n);r=Math.atan2(s*h,Jt(l,h*a)),e=H((n=Math.atan2(l,h*a))+this.long0),i=Qt(this.cgb,r)}else e=1/0,i=1/0;return t.x=e,t.y=i,t},names:["Extended_Transverse_Mercator","Extended Transverse Mercator","etmerc","Transverse_Mercator","Transverse Mercator","Gauss Kruger","Gauss_Kruger","tmerc"]},ee={init:function(){var t=function(t,e){if(void 0===t){if((t=Math.floor(30*(H(e)+Math.PI)/Math.PI)+1)<0)return 0;if(t>60)return 60}return t}(this.zone,this.long0);if(void 0===t)throw new Error("unknown utm zone");this.lat0=0,this.long0=(6*Math.abs(t)-183)*p,this.x0=5e5,this.y0=this.utmSouth?1e7:0,this.k0=.9996,te.init.apply(this),this.forward=te.forward,this.inverse=te.inverse},names:["Universal Transverse Mercator System","utm"],dependsOn:"etmerc"};function ie(t,e){return Math.pow((1-t)/(1+t),e)}const ne={init:function(){var t=Math.sin(this.lat0),e=Math.cos(this.lat0);e*=e,this.rc=Math.sqrt(1-this.es)/(1-this.es*t*t),this.C=Math.sqrt(1+this.es*e*e/(1-this.es)),this.phic0=Math.asin(t/this.C),this.ratexp=.5*this.C*this.e,this.K=Math.tan(.5*this.phic0+m)/(Math.pow(Math.tan(.5*this.lat0+m),this.C)*ie(this.e*t,this.ratexp))},forward:function(t){var e=t.x,i=t.y;return t.y=2*Math.atan(this.K*Math.pow(Math.tan(.5*i+m),this.C)*ie(this.e*Math.sin(i),this.ratexp))-u,t.x=this.C*e,t},inverse:function(t){for(var e=t.x/this.C,i=t.y,n=Math.pow(Math.tan(.5*i+m)/this.K,1/this.C),r=20;r>0&&(i=2*Math.atan(n*ie(this.e*Math.sin(t.y),-.5*this.e))-u,!(Math.abs(i-t.y)<1e-14));--r)t.y=i;return r?(t.x=e,t.y=i,t):null},names:["gauss"]},re={init:function(){ne.init.apply(this),this.rc&&(this.sinc0=Math.sin(this.phic0),this.cosc0=Math.cos(this.phic0),this.R2=2*this.rc,this.title||(this.title="Oblique Stereographic Alternative"))},forward:function(t){var e,i,n,r;return t.x=H(t.x-this.long0),ne.forward.apply(this,[t]),e=Math.sin(t.y),i=Math.cos(t.y),n=Math.cos(t.x),r=this.k0*this.R2/(1+this.sinc0*e+this.cosc0*i*n),t.x=r*i*Math.sin(t.x),t.y=r*(this.cosc0*e-this.sinc0*i*n),t.x=this.a*t.x+this.x0,t.y=this.a*t.y+this.y0,t},inverse:function(t){var e,i,n,r,o;if(t.x=(t.x-this.x0)/this.a,t.y=(t.y-this.y0)/this.a,t.x/=this.k0,t.y/=this.k0,o=Jt(t.x,t.y)){var s=2*Math.atan2(o,this.R2);e=Math.sin(s),i=Math.cos(s),r=Math.asin(i*this.sinc0+t.y*e*this.cosc0/o),n=Math.atan2(t.x*e,o*this.cosc0*i-t.y*this.sinc0*e)}else r=this.phic0,n=0;return t.x=n,t.y=r,ne.inverse.apply(this,[t]),t.x=H(t.x+this.long0),t},names:["Stereographic_North_Pole","Oblique_Stereographic","sterea","Oblique Stereographic Alternative","Double_Stereographic"]},oe={init:function(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.coslat0=Math.cos(this.lat0),this.sinlat0=Math.sin(this.lat0),this.sphere?1===this.k0&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=d&&(this.k0=.5*(1+U(this.lat0)*Math.sin(this.lat_ts))):(Math.abs(this.coslat0)<=d&&(this.lat0>0?this.con=1:this.con=-1),this.cons=Math.sqrt(Math.pow(1+this.e,1+this.e)*Math.pow(1-this.e,1-this.e)),1===this.k0&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=d&&Math.abs(Math.cos(this.lat_ts))>d&&(this.k0=.5*this.cons*G(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts))/V(this.e,this.con*this.lat_ts,this.con*Math.sin(this.lat_ts))),this.ms1=G(this.e,this.sinlat0,this.coslat0),this.X0=2*Math.atan(this.ssfn_(this.lat0,this.sinlat0,this.e))-u,this.cosX0=Math.cos(this.X0),this.sinX0=Math.sin(this.X0))},forward:function(t){var e,i,n,r,o,s,a=t.x,l=t.y,h=Math.sin(l),c=Math.cos(l),p=H(a-this.long0);return Math.abs(Math.abs(a-this.long0)-Math.PI)<=d&&Math.abs(l+this.lat0)<=d?(t.x=NaN,t.y=NaN,t):this.sphere?(e=2*this.k0/(1+this.sinlat0*h+this.coslat0*c*Math.cos(p)),t.x=this.a*e*c*Math.sin(p)+this.x0,t.y=this.a*e*(this.coslat0*h-this.sinlat0*c*Math.cos(p))+this.y0,t):(i=2*Math.atan(this.ssfn_(l,h,this.e))-u,r=Math.cos(i),n=Math.sin(i),Math.abs(this.coslat0)<=d?(o=V(this.e,l*this.con,this.con*h),s=2*this.a*this.k0*o/this.cons,t.x=this.x0+s*Math.sin(a-this.long0),t.y=this.y0-this.con*s*Math.cos(a-this.long0),t):(Math.abs(this.sinlat0)<d?(e=2*this.a*this.k0/(1+r*Math.cos(p)),t.y=e*n):(e=2*this.a*this.k0*this.ms1/(this.cosX0*(1+this.sinX0*n+this.cosX0*r*Math.cos(p))),t.y=e*(this.cosX0*n-this.sinX0*r*Math.cos(p))+this.y0),t.x=e*r*Math.sin(p)+this.x0,t))},inverse:function(t){var e,i,n,r,o;t.x-=this.x0,t.y-=this.y0;var s=Math.sqrt(t.x*t.x+t.y*t.y);if(this.sphere){var a=2*Math.atan(s/(2*this.a*this.k0));return e=this.long0,i=this.lat0,s<=d?(t.x=e,t.y=i,t):(i=Math.asin(Math.cos(a)*this.sinlat0+t.y*Math.sin(a)*this.coslat0/s),e=Math.abs(this.coslat0)<d?this.lat0>0?H(this.long0+Math.atan2(t.x,-1*t.y)):H(this.long0+Math.atan2(t.x,t.y)):H(this.long0+Math.atan2(t.x*Math.sin(a),s*this.coslat0*Math.cos(a)-t.y*this.sinlat0*Math.sin(a))),t.x=e,t.y=i,t)}if(Math.abs(this.coslat0)<=d){if(s<=d)return i=this.lat0,e=this.long0,t.x=e,t.y=i,t;t.x*=this.con,t.y*=this.con,n=s*this.cons/(2*this.a*this.k0),i=this.con*Z(this.e,n),e=this.con*H(this.con*this.long0+Math.atan2(t.x,-1*t.y))}else r=2*Math.atan(s*this.cosX0/(2*this.a*this.k0*this.ms1)),e=this.long0,s<=d?o=this.X0:(o=Math.asin(Math.cos(r)*this.sinX0+t.y*Math.sin(r)*this.cosX0/s),e=H(this.long0+Math.atan2(t.x*Math.sin(r),s*this.cosX0*Math.cos(r)-t.y*this.sinX0*Math.sin(r)))),i=-1*Z(this.e,Math.tan(.5*(u+o)));return t.x=e,t.y=i,t},names:["stere","Stereographic_South_Pole","Polar Stereographic (variant B)","Polar_Stereographic"],ssfn_:function(t,e,i){return e*=i,Math.tan(.5*(u+t))*Math.pow((1-e)/(1+e),.5*i)}},se={init:function(){var t=this.lat0;this.lambda0=this.long0;var e=Math.sin(t),i=this.a,n=1/this.rf,r=2*n-Math.pow(n,2),o=this.e=Math.sqrt(r);this.R=this.k0*i*Math.sqrt(1-r)/(1-r*Math.pow(e,2)),this.alpha=Math.sqrt(1+r/(1-r)*Math.pow(Math.cos(t),4)),this.b0=Math.asin(e/this.alpha);var s=Math.log(Math.tan(Math.PI/4+this.b0/2)),a=Math.log(Math.tan(Math.PI/4+t/2)),l=Math.log((1+o*e)/(1-o*e));this.K=s-this.alpha*a+this.alpha*o/2*l},forward:function(t){var e=Math.log(Math.tan(Math.PI/4-t.y/2)),i=this.e/2*Math.log((1+this.e*Math.sin(t.y))/(1-this.e*Math.sin(t.y))),n=-this.alpha*(e+i)+this.K,r=2*(Math.atan(Math.exp(n))-Math.PI/4),o=this.alpha*(t.x-this.lambda0),s=Math.atan(Math.sin(o)/(Math.sin(this.b0)*Math.tan(r)+Math.cos(this.b0)*Math.cos(o))),a=Math.asin(Math.cos(this.b0)*Math.sin(r)-Math.sin(this.b0)*Math.cos(r)*Math.cos(o));return t.y=this.R/2*Math.log((1+Math.sin(a))/(1-Math.sin(a)))+this.y0,t.x=this.R*s+this.x0,t},inverse:function(t){for(var e=t.x-this.x0,i=t.y-this.y0,n=e/this.R,r=2*(Math.atan(Math.exp(i/this.R))-Math.PI/4),o=Math.asin(Math.cos(this.b0)*Math.sin(r)+Math.sin(this.b0)*Math.cos(r)*Math.cos(n)),s=Math.atan(Math.sin(n)/(Math.cos(this.b0)*Math.cos(n)-Math.sin(this.b0)*Math.tan(r))),a=this.lambda0+s/this.alpha,l=0,h=o,c=-1e3,u=0;Math.abs(h-c)>1e-7;){if(++u>20)return;l=1/this.alpha*(Math.log(Math.tan(Math.PI/4+o/2))-this.K)+this.e*Math.log(Math.tan(Math.PI/4+Math.asin(this.e*Math.sin(h))/2)),c=h,h=2*Math.atan(Math.exp(l))-Math.PI/2}return t.x=a,t.y=h,t},names:["somerc"]};var ae=1e-7;const le={init:function(){var t,e,i,n,r,o,s,a,l,h,c,f,_,y=0,v=0,b=0,x=0,w=0,L=0,M=0;this.no_off=(_="object"==typeof(f=this).PROJECTION?Object.keys(f.PROJECTION)[0]:f.PROJECTION,"no_uoff"in f||"no_off"in f||-1!==["Hotine_Oblique_Mercator","Hotine_Oblique_Mercator_Azimuth_Natural_Origin"].indexOf(_)),this.no_rot="no_rot"in this;var k=!1;"alpha"in this&&(k=!0);var C=!1;if("rectified_grid_angle"in this&&(C=!0),k&&(M=this.alpha),C&&(y=this.rectified_grid_angle*p),k||C)v=this.longc;else if(b=this.long1,w=this.lat1,x=this.long2,L=this.lat2,Math.abs(w-L)<=ae||(t=Math.abs(w))<=ae||Math.abs(t-u)<=ae||Math.abs(Math.abs(this.lat0)-u)<=ae||Math.abs(Math.abs(L)-u)<=ae)throw new Error;var A=1-this.es;e=Math.sqrt(A),Math.abs(this.lat0)>d?(a=Math.sin(this.lat0),i=Math.cos(this.lat0),t=1-this.es*a*a,this.B=i*i,this.B=Math.sqrt(1+this.es*this.B*this.B/A),this.A=this.B*this.k0*e/t,(r=(n=this.B*e/(i*Math.sqrt(t)))*n-1)<=0?r=0:(r=Math.sqrt(r),this.lat0<0&&(r=-r)),this.E=r+=n,this.E*=Math.pow(V(this.e,this.lat0,a),this.B)):(this.B=1/e,this.A=this.k0,this.E=n=r=1),k||C?(k?(c=Math.asin(Math.sin(M)/n),C||(y=M)):(c=y,M=Math.asin(n*Math.sin(c))),this.lam0=v-Math.asin(.5*(r-1/r)*Math.tan(c))/this.B):(o=Math.pow(V(this.e,w,Math.sin(w)),this.B),s=Math.pow(V(this.e,L,Math.sin(L)),this.B),r=this.E/o,l=(s-o)/(s+o),h=((h=this.E*this.E)-s*o)/(h+s*o),(t=b-x)<-Math.pi?x-=g:t>Math.pi&&(x+=g),this.lam0=H(.5*(b+x)-Math.atan(h*Math.tan(.5*this.B*(b-x))/l)/this.B),c=Math.atan(2*Math.sin(this.B*H(b-this.lam0))/(r-1/r)),y=M=Math.asin(n*Math.sin(c))),this.singam=Math.sin(c),this.cosgam=Math.cos(c),this.sinrot=Math.sin(y),this.cosrot=Math.cos(y),this.rB=1/this.B,this.ArB=this.A*this.rB,this.BrA=1/this.ArB,this.A,this.B,this.no_off?this.u_0=0:(this.u_0=Math.abs(this.ArB*Math.atan(Math.sqrt(n*n-1)/Math.cos(M))),this.lat0<0&&(this.u_0=-this.u_0)),r=.5*c,this.v_pole_n=this.ArB*Math.log(Math.tan(m-r)),this.v_pole_s=this.ArB*Math.log(Math.tan(m+r))},forward:function(t){var e,i,n,r,o,s,a,l,h={};if(t.x=t.x-this.lam0,Math.abs(Math.abs(t.y)-u)>d){if(e=.5*((o=this.E/Math.pow(V(this.e,t.y,Math.sin(t.y)),this.B))-(s=1/o)),i=.5*(o+s),r=Math.sin(this.B*t.x),n=(e*this.singam-r*this.cosgam)/i,Math.abs(Math.abs(n)-1)<d)throw new Error;l=.5*this.ArB*Math.log((1-n)/(1+n)),s=Math.cos(this.B*t.x),a=Math.abs(s)<ae?this.A*t.x:this.ArB*Math.atan2(e*this.cosgam+r*this.singam,s)}else l=t.y>0?this.v_pole_n:this.v_pole_s,a=this.ArB*t.y;return this.no_rot?(h.x=a,h.y=l):(a-=this.u_0,h.x=l*this.cosrot+a*this.sinrot,h.y=a*this.cosrot-l*this.sinrot),h.x=this.a*h.x+this.x0,h.y=this.a*h.y+this.y0,h},inverse:function(t){var e,i,n,r,o,s,a,l={};if(t.x=(t.x-this.x0)*(1/this.a),t.y=(t.y-this.y0)*(1/this.a),this.no_rot?(i=t.y,e=t.x):(i=t.x*this.cosrot-t.y*this.sinrot,e=t.y*this.cosrot+t.x*this.sinrot+this.u_0),r=.5*((n=Math.exp(-this.BrA*i))-1/n),o=.5*(n+1/n),a=((s=Math.sin(this.BrA*e))*this.cosgam+r*this.singam)/o,Math.abs(Math.abs(a)-1)<d)l.x=0,l.y=a<0?-u:u;else{if(l.y=this.E/Math.sqrt((1+a)/(1-a)),l.y=Z(this.e,Math.pow(l.y,1/this.B)),l.y===1/0)throw new Error;l.x=-this.rB*Math.atan2(r*this.cosgam-s*this.singam,Math.cos(this.BrA*e))}return l.x+=this.lam0,l},names:["Hotine_Oblique_Mercator","Hotine Oblique Mercator","Hotine_Oblique_Mercator_Azimuth_Natural_Origin","Hotine_Oblique_Mercator_Two_Point_Natural_Origin","Hotine_Oblique_Mercator_Azimuth_Center","Oblique_Mercator","omerc"]},he={init:function(){if(this.lat2||(this.lat2=this.lat1),this.k0||(this.k0=1),this.x0=this.x0||0,this.y0=this.y0||0,!(Math.abs(this.lat1+this.lat2)<d)){var t=this.b/this.a;this.e=Math.sqrt(1-t*t);var e=Math.sin(this.lat1),i=Math.cos(this.lat1),n=G(this.e,e,i),r=V(this.e,this.lat1,e),o=Math.sin(this.lat2),s=Math.cos(this.lat2),a=G(this.e,o,s),l=V(this.e,this.lat2,o),h=V(this.e,this.lat0,Math.sin(this.lat0));Math.abs(this.lat1-this.lat2)>d?this.ns=Math.log(n/a)/Math.log(r/l):this.ns=e,isNaN(this.ns)&&(this.ns=e),this.f0=n/(this.ns*Math.pow(r,this.ns)),this.rh=this.a*this.f0*Math.pow(h,this.ns),this.title||(this.title="Lambert Conformal Conic")}},forward:function(t){var e=t.x,i=t.y;Math.abs(2*Math.abs(i)-Math.PI)<=d&&(i=U(i)*(u-2e-10));var n,r,o=Math.abs(Math.abs(i)-u);if(o>d)n=V(this.e,i,Math.sin(i)),r=this.a*this.f0*Math.pow(n,this.ns);else{if((o=i*this.ns)<=0)return null;r=0}var s=this.ns*H(e-this.long0);return t.x=this.k0*(r*Math.sin(s))+this.x0,t.y=this.k0*(this.rh-r*Math.cos(s))+this.y0,t},inverse:function(t){var e,i,n,r,o,s=(t.x-this.x0)/this.k0,a=this.rh-(t.y-this.y0)/this.k0;this.ns>0?(e=Math.sqrt(s*s+a*a),i=1):(e=-Math.sqrt(s*s+a*a),i=-1);var l=0;if(0!==e&&(l=Math.atan2(i*s,i*a)),0!==e||this.ns>0){if(i=1/this.ns,n=Math.pow(e/(this.a*this.f0),i),-9999===(r=Z(this.e,n)))return null}else r=-u;return o=H(l/this.ns+this.long0),t.x=o,t.y=r,t},names:["Lambert Tangential Conformal Conic Projection","Lambert_Conformal_Conic","Lambert_Conformal_Conic_1SP","Lambert_Conformal_Conic_2SP","lcc","Lambert Conic Conformal (1SP)","Lambert Conic Conformal (2SP)"]},ce={init:function(){this.a=6377397.155,this.es=.006674372230614,this.e=Math.sqrt(this.es),this.lat0||(this.lat0=.863937979737193),this.long0||(this.long0=.4334234309119251),this.k0||(this.k0=.9999),this.s45=.785398163397448,this.s90=2*this.s45,this.fi0=this.lat0,this.e2=this.es,this.e=Math.sqrt(this.e2),this.alfa=Math.sqrt(1+this.e2*Math.pow(Math.cos(this.fi0),4)/(1-this.e2)),this.uq=1.04216856380474,this.u0=Math.asin(Math.sin(this.fi0)/this.alfa),this.g=Math.pow((1+this.e*Math.sin(this.fi0))/(1-this.e*Math.sin(this.fi0)),this.alfa*this.e/2),this.k=Math.tan(this.u0/2+this.s45)/Math.pow(Math.tan(this.fi0/2+this.s45),this.alfa)*this.g,this.k1=this.k0,this.n0=this.a*Math.sqrt(1-this.e2)/(1-this.e2*Math.pow(Math.sin(this.fi0),2)),this.s0=1.37008346281555,this.n=Math.sin(this.s0),this.ro0=this.k1*this.n0/Math.tan(this.s0),this.ad=this.s90-this.uq},forward:function(t){var e,i,n,r,o,s,a,l=t.x,h=t.y,c=H(l-this.long0);return e=Math.pow((1+this.e*Math.sin(h))/(1-this.e*Math.sin(h)),this.alfa*this.e/2),i=2*(Math.atan(this.k*Math.pow(Math.tan(h/2+this.s45),this.alfa)/e)-this.s45),n=-c*this.alfa,r=Math.asin(Math.cos(this.ad)*Math.sin(i)+Math.sin(this.ad)*Math.cos(i)*Math.cos(n)),o=Math.asin(Math.cos(i)*Math.sin(n)/Math.cos(r)),s=this.n*o,a=this.ro0*Math.pow(Math.tan(this.s0/2+this.s45),this.n)/Math.pow(Math.tan(r/2+this.s45),this.n),t.y=a*Math.cos(s)/1,t.x=a*Math.sin(s)/1,this.czech||(t.y*=-1,t.x*=-1),t},inverse:function(t){var e,i,n,r,o,s,a,l=t.x;t.x=t.y,t.y=l,this.czech||(t.y*=-1,t.x*=-1),o=Math.sqrt(t.x*t.x+t.y*t.y),r=Math.atan2(t.y,t.x)/Math.sin(this.s0),n=2*(Math.atan(Math.pow(this.ro0/o,1/this.n)*Math.tan(this.s0/2+this.s45))-this.s45),e=Math.asin(Math.cos(this.ad)*Math.sin(n)-Math.sin(this.ad)*Math.cos(n)*Math.cos(r)),i=Math.asin(Math.cos(n)*Math.sin(r)/Math.cos(e)),t.x=this.long0-i/this.alfa,s=e,a=0;var h=0;do{t.y=2*(Math.atan(Math.pow(this.k,-1/this.alfa)*Math.pow(Math.tan(e/2+this.s45),1/this.alfa)*Math.pow((1+this.e*Math.sin(s))/(1-this.e*Math.sin(s)),this.e/2))-this.s45),Math.abs(s-t.y)<1e-10&&(a=1),s=t.y,h+=1}while(0===a&&h<15);return h>=15?null:t},names:["Krovak","krovak"]};function ue(t,e,i,n,r){return t*r-e*Math.sin(2*r)+i*Math.sin(4*r)-n*Math.sin(6*r)}function de(t){return 1-.25*t*(1+t/16*(3+1.25*t))}function pe(t){return.375*t*(1+.25*t*(1+.46875*t))}function fe(t){return.05859375*t*t*(1+.75*t)}function me(t){return t*t*t*(35/3072)}function ge(t,e,i){var n=e*i;return t/Math.sqrt(1-n*n)}function _e(t){return Math.abs(t)<u?t:t-U(t)*Math.PI}function ye(t,e,i,n,r){var o,s;o=t/e;for(var a=0;a<15;a++)if(o+=s=(t-(e*o-i*Math.sin(2*o)+n*Math.sin(4*o)-r*Math.sin(6*o)))/(e-2*i*Math.cos(2*o)+4*n*Math.cos(4*o)-6*r*Math.cos(6*o)),Math.abs(s)<=1e-10)return o;return NaN}const ve={init:function(){this.sphere||(this.e0=de(this.es),this.e1=pe(this.es),this.e2=fe(this.es),this.e3=me(this.es),this.ml0=this.a*ue(this.e0,this.e1,this.e2,this.e3,this.lat0))},forward:function(t){var e,i,n=t.x,r=t.y;if(n=H(n-this.long0),this.sphere)e=this.a*Math.asin(Math.cos(r)*Math.sin(n)),i=this.a*(Math.atan2(Math.tan(r),Math.cos(n))-this.lat0);else{var o=Math.sin(r),s=Math.cos(r),a=ge(this.a,this.e,o),l=Math.tan(r)*Math.tan(r),h=n*Math.cos(r),c=h*h,u=this.es*s*s/(1-this.es);e=a*h*(1-c*l*(1/6-(8-l+8*u)*c/120)),i=this.a*ue(this.e0,this.e1,this.e2,this.e3,r)-this.ml0+a*o/s*c*(.5+(5-l+6*u)*c/24)}return t.x=e+this.x0,t.y=i+this.y0,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0;var e,i,n=t.x/this.a,r=t.y/this.a;if(this.sphere){var o=r+this.lat0;e=Math.asin(Math.sin(o)*Math.cos(n)),i=Math.atan2(Math.tan(n),Math.cos(o))}else{var s=ye(this.ml0/this.a+r,this.e0,this.e1,this.e2,this.e3);if(Math.abs(Math.abs(s)-u)<=d)return t.x=this.long0,t.y=u,r<0&&(t.y*=-1),t;var a=ge(this.a,this.e,Math.sin(s)),l=a*a*a/this.a/this.a*(1-this.es),h=Math.pow(Math.tan(s),2),c=n*this.a/a,p=c*c;e=s-a*Math.tan(s)/l*c*c*(.5-(1+3*h)*c*c/24),i=c*(1-p*(h/3+(1+3*h)*h*p/15))/Math.cos(s)}return t.x=H(i+this.long0),t.y=_e(e),t},names:["Cassini","Cassini_Soldner","cass"]};function be(t,e){var i;return t>1e-7?(1-t*t)*(e/(1-(i=t*e)*i)-.5/t*Math.log((1-i)/(1+i))):2*e}const xe={init:function(){var t,e=Math.abs(this.lat0);if(Math.abs(e-u)<d?this.mode=this.lat0<0?this.S_POLE:this.N_POLE:Math.abs(e)<d?this.mode=this.EQUIT:this.mode=this.OBLIQ,this.es>0)switch(this.qp=be(this.e,1),this.mmf=.5/(1-this.es),this.apa=function(t){var e,i=[];return i[0]=.3333333333333333*t,e=t*t,i[0]+=.17222222222222222*e,i[1]=.06388888888888888*e,e*=t,i[0]+=.10257936507936508*e,i[1]+=.0664021164021164*e,i[2]=.016415012942191543*e,i}(this.es),this.mode){case this.N_POLE:case this.S_POLE:this.dd=1;break;case this.EQUIT:this.rq=Math.sqrt(.5*this.qp),this.dd=1/this.rq,this.xmf=1,this.ymf=.5*this.qp;break;case this.OBLIQ:this.rq=Math.sqrt(.5*this.qp),t=Math.sin(this.lat0),this.sinb1=be(this.e,t)/this.qp,this.cosb1=Math.sqrt(1-this.sinb1*this.sinb1),this.dd=Math.cos(this.lat0)/(Math.sqrt(1-this.es*t*t)*this.rq*this.cosb1),this.ymf=(this.xmf=this.rq)/this.dd,this.xmf*=this.dd}else this.mode===this.OBLIQ&&(this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0))},forward:function(t){var e,i,n,r,o,s,a,l,h,c,p=t.x,f=t.y;if(p=H(p-this.long0),this.sphere){if(o=Math.sin(f),c=Math.cos(f),n=Math.cos(p),this.mode===this.OBLIQ||this.mode===this.EQUIT){if((i=this.mode===this.EQUIT?1+c*n:1+this.sinph0*o+this.cosph0*c*n)<=d)return null;e=(i=Math.sqrt(2/i))*c*Math.sin(p),i*=this.mode===this.EQUIT?o:this.cosph0*o-this.sinph0*c*n}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(this.mode===this.N_POLE&&(n=-n),Math.abs(f+this.lat0)<d)return null;i=m-.5*f,e=(i=2*(this.mode===this.S_POLE?Math.cos(i):Math.sin(i)))*Math.sin(p),i*=n}}else{switch(a=0,l=0,h=0,n=Math.cos(p),r=Math.sin(p),o=Math.sin(f),s=be(this.e,o),this.mode!==this.OBLIQ&&this.mode!==this.EQUIT||(a=s/this.qp,l=Math.sqrt(1-a*a)),this.mode){case this.OBLIQ:h=1+this.sinb1*a+this.cosb1*l*n;break;case this.EQUIT:h=1+l*n;break;case this.N_POLE:h=u+f,s=this.qp-s;break;case this.S_POLE:h=f-u,s=this.qp+s}if(Math.abs(h)<d)return null;switch(this.mode){case this.OBLIQ:case this.EQUIT:h=Math.sqrt(2/h),i=this.mode===this.OBLIQ?this.ymf*h*(this.cosb1*a-this.sinb1*l*n):(h=Math.sqrt(2/(1+l*n)))*a*this.ymf,e=this.xmf*h*l*r;break;case this.N_POLE:case this.S_POLE:s>=0?(e=(h=Math.sqrt(s))*r,i=n*(this.mode===this.S_POLE?h:-h)):e=i=0}}return t.x=this.a*e+this.x0,t.y=this.a*i+this.y0,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0;var e,i,n,r,o,s,a,l,h,c,p=t.x/this.a,f=t.y/this.a;if(this.sphere){var m,g=0,_=0;if((i=.5*(m=Math.sqrt(p*p+f*f)))>1)return null;switch(i=2*Math.asin(i),this.mode!==this.OBLIQ&&this.mode!==this.EQUIT||(_=Math.sin(i),g=Math.cos(i)),this.mode){case this.EQUIT:i=Math.abs(m)<=d?0:Math.asin(f*_/m),p*=_,f=g*m;break;case this.OBLIQ:i=Math.abs(m)<=d?this.lat0:Math.asin(g*this.sinph0+f*_*this.cosph0/m),p*=_*this.cosph0,f=(g-Math.sin(i)*this.sinph0)*m;break;case this.N_POLE:f=-f,i=u-i;break;case this.S_POLE:i-=u}e=0!==f||this.mode!==this.EQUIT&&this.mode!==this.OBLIQ?Math.atan2(p,f):0}else{if(a=0,this.mode===this.OBLIQ||this.mode===this.EQUIT){if(p/=this.dd,f*=this.dd,(s=Math.sqrt(p*p+f*f))<d)return t.x=this.long0,t.y=this.lat0,t;r=2*Math.asin(.5*s/this.rq),n=Math.cos(r),p*=r=Math.sin(r),this.mode===this.OBLIQ?(a=n*this.sinb1+f*r*this.cosb1/s,o=this.qp*a,f=s*this.cosb1*n-f*this.sinb1*r):(a=f*r/s,o=this.qp*a,f=s*n)}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(this.mode===this.N_POLE&&(f=-f),!(o=p*p+f*f))return t.x=this.long0,t.y=this.lat0,t;a=1-o/this.qp,this.mode===this.S_POLE&&(a=-a)}e=Math.atan2(p,f),c=(l=Math.asin(a))+l,i=l+(h=this.apa)[0]*Math.sin(c)+h[1]*Math.sin(c+c)+h[2]*Math.sin(c+c+c)}return t.x=H(this.long0+e),t.y=i,t},names:["Lambert Azimuthal Equal Area","Lambert_Azimuthal_Equal_Area","laea"],S_POLE:1,N_POLE:2,EQUIT:3,OBLIQ:4};function we(t){return Math.abs(t)>1&&(t=t>1?1:-1),Math.asin(t)}const Le={init:function(){Math.abs(this.lat1+this.lat2)<d||(this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e3=Math.sqrt(this.es),this.sin_po=Math.sin(this.lat1),this.cos_po=Math.cos(this.lat1),this.t1=this.sin_po,this.con=this.sin_po,this.ms1=G(this.e3,this.sin_po,this.cos_po),this.qs1=be(this.e3,this.sin_po),this.sin_po=Math.sin(this.lat2),this.cos_po=Math.cos(this.lat2),this.t2=this.sin_po,this.ms2=G(this.e3,this.sin_po,this.cos_po),this.qs2=be(this.e3,this.sin_po),this.sin_po=Math.sin(this.lat0),this.cos_po=Math.cos(this.lat0),this.t3=this.sin_po,this.qs0=be(this.e3,this.sin_po),Math.abs(this.lat1-this.lat2)>d?this.ns0=(this.ms1*this.ms1-this.ms2*this.ms2)/(this.qs2-this.qs1):this.ns0=this.con,this.c=this.ms1*this.ms1+this.ns0*this.qs1,this.rh=this.a*Math.sqrt(this.c-this.ns0*this.qs0)/this.ns0)},forward:function(t){var e=t.x,i=t.y;this.sin_phi=Math.sin(i),this.cos_phi=Math.cos(i);var n=be(this.e3,this.sin_phi),r=this.a*Math.sqrt(this.c-this.ns0*n)/this.ns0,o=this.ns0*H(e-this.long0),s=r*Math.sin(o)+this.x0,a=this.rh-r*Math.cos(o)+this.y0;return t.x=s,t.y=a,t},inverse:function(t){var e,i,n,r,o,s;return t.x-=this.x0,t.y=this.rh-t.y+this.y0,this.ns0>=0?(e=Math.sqrt(t.x*t.x+t.y*t.y),n=1):(e=-Math.sqrt(t.x*t.x+t.y*t.y),n=-1),r=0,0!==e&&(r=Math.atan2(n*t.x,n*t.y)),n=e*this.ns0/this.a,this.sphere?s=Math.asin((this.c-n*n)/(2*this.ns0)):(i=(this.c-n*n)/this.ns0,s=this.phi1z(this.e3,i)),o=H(r/this.ns0+this.long0),t.x=o,t.y=s,t},names:["Albers_Conic_Equal_Area","Albers","aea"],phi1z:function(t,e){var i,n,r,o,s=we(.5*e);if(t<d)return s;for(var a=t*t,l=1;l<=25;l++)if(s+=o=.5*(r=1-(n=t*(i=Math.sin(s)))*n)*r/Math.cos(s)*(e/(1-a)-i/r+.5/t*Math.log((1-n)/(1+n))),Math.abs(o)<=1e-7)return s;return null}},Me={init:function(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0),this.infinity_dist=1e3*this.a,this.rc=1},forward:function(t){var e,i,n,r,o,s,a,l=t.x,h=t.y;return n=H(l-this.long0),e=Math.sin(h),i=Math.cos(h),r=Math.cos(n),(o=this.sin_p14*e+this.cos_p14*i*r)>0||Math.abs(o)<=d?(s=this.x0+1*this.a*i*Math.sin(n)/o,a=this.y0+1*this.a*(this.cos_p14*e-this.sin_p14*i*r)/o):(s=this.x0+this.infinity_dist*i*Math.sin(n),a=this.y0+this.infinity_dist*(this.cos_p14*e-this.sin_p14*i*r)),t.x=s,t.y=a,t},inverse:function(t){var e,i,n,r,o,s;return t.x=(t.x-this.x0)/this.a,t.y=(t.y-this.y0)/this.a,t.x/=this.k0,t.y/=this.k0,(e=Math.sqrt(t.x*t.x+t.y*t.y))?(r=Math.atan2(e,this.rc),i=Math.sin(r),s=we((n=Math.cos(r))*this.sin_p14+t.y*i*this.cos_p14/e),o=Math.atan2(t.x*i,e*this.cos_p14*n-t.y*this.sin_p14*i),o=H(this.long0+o)):(s=this.phic0,o=0),t.x=o,t.y=s,t},names:["gnom"]},ke={init:function(){this.sphere||(this.k0=G(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)))},forward:function(t){var e,i,n=t.x,r=t.y,o=H(n-this.long0);if(this.sphere)e=this.x0+this.a*o*Math.cos(this.lat_ts),i=this.y0+this.a*Math.sin(r)/Math.cos(this.lat_ts);else{var s=be(this.e,Math.sin(r));e=this.x0+this.a*this.k0*o,i=this.y0+this.a*s*.5/this.k0}return t.x=e,t.y=i,t},inverse:function(t){var e,i;return t.x-=this.x0,t.y-=this.y0,this.sphere?(e=H(this.long0+t.x/this.a/Math.cos(this.lat_ts)),i=Math.asin(t.y/this.a*Math.cos(this.lat_ts))):(i=function(t,e){var i=1-(1-t*t)/(2*t)*Math.log((1-t)/(1+t));if(Math.abs(Math.abs(e)-i)<1e-6)return e<0?-1*u:u;for(var n,r,o,s,a=Math.asin(.5*e),l=0;l<30;l++)if(r=Math.sin(a),o=Math.cos(a),s=t*r,a+=n=Math.pow(1-s*s,2)/(2*o)*(e/(1-t*t)-r/(1-s*s)+.5/t*Math.log((1-s)/(1+s))),Math.abs(n)<=1e-10)return a;return NaN}(this.e,2*t.y*this.k0/this.a),e=H(this.long0+t.x/(this.a*this.k0))),t.x=e,t.y=i,t},names:["cea"]},Ce={init:function(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Equidistant Cylindrical (Plate Carre)",this.rc=Math.cos(this.lat_ts)},forward:function(t){var e=t.x,i=t.y,n=H(e-this.long0),r=_e(i-this.lat0);return t.x=this.x0+this.a*n*this.rc,t.y=this.y0+this.a*r,t},inverse:function(t){var e=t.x,i=t.y;return t.x=H(this.long0+(e-this.x0)/(this.a*this.rc)),t.y=_e(this.lat0+(i-this.y0)/this.a),t},names:["Equirectangular","Equidistant_Cylindrical","eqc"]},Ae={init:function(){this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=de(this.es),this.e1=pe(this.es),this.e2=fe(this.es),this.e3=me(this.es),this.ml0=this.a*ue(this.e0,this.e1,this.e2,this.e3,this.lat0)},forward:function(t){var e,i,n,r=t.x,o=t.y,s=H(r-this.long0);if(n=s*Math.sin(o),this.sphere)Math.abs(o)<=d?(e=this.a*s,i=-1*this.a*this.lat0):(e=this.a*Math.sin(n)/Math.tan(o),i=this.a*(_e(o-this.lat0)+(1-Math.cos(n))/Math.tan(o)));else if(Math.abs(o)<=d)e=this.a*s,i=-1*this.ml0;else{var a=ge(this.a,this.e,Math.sin(o))/Math.tan(o);e=a*Math.sin(n),i=this.a*ue(this.e0,this.e1,this.e2,this.e3,o)-this.ml0+a*(1-Math.cos(n))}return t.x=e+this.x0,t.y=i+this.y0,t},inverse:function(t){var e,i,n,r,o,s,a,l,h;if(n=t.x-this.x0,r=t.y-this.y0,this.sphere)if(Math.abs(r+this.a*this.lat0)<=d)e=H(n/this.a+this.long0),i=0;else{var c;for(s=this.lat0+r/this.a,a=n*n/this.a/this.a+s*s,l=s,o=20;o;--o)if(l+=h=-1*(s*(l*(c=Math.tan(l))+1)-l-.5*(l*l+a)*c)/((l-s)/c-1),Math.abs(h)<=d){i=l;break}e=H(this.long0+Math.asin(n*Math.tan(l)/this.a)/Math.sin(i))}else if(Math.abs(r+this.ml0)<=d)i=0,e=H(this.long0+n/this.a);else{var u,p,f,m,g;for(s=(this.ml0+r)/this.a,a=n*n/this.a/this.a+s*s,l=s,o=20;o;--o)if(g=this.e*Math.sin(l),u=Math.sqrt(1-g*g)*Math.tan(l),p=this.a*ue(this.e0,this.e1,this.e2,this.e3,l),f=this.e0-2*this.e1*Math.cos(2*l)+4*this.e2*Math.cos(4*l)-6*this.e3*Math.cos(6*l),l-=h=(s*(u*(m=p/this.a)+1)-m-.5*u*(m*m+a))/(this.es*Math.sin(2*l)*(m*m+a-2*s*m)/(4*u)+(s-m)*(u*f-2/Math.sin(2*l))-f),Math.abs(h)<=d){i=l;break}u=Math.sqrt(1-this.es*Math.pow(Math.sin(i),2))*Math.tan(i),e=H(this.long0+Math.asin(n*u/this.a)/Math.sin(i))}return t.x=e,t.y=i,t},names:["Polyconic","poly"]},Pe={init:function(){this.A=[],this.A[1]=.6399175073,this.A[2]=-.1358797613,this.A[3]=.063294409,this.A[4]=-.02526853,this.A[5]=.0117879,this.A[6]=-.0055161,this.A[7]=.0026906,this.A[8]=-.001333,this.A[9]=67e-5,this.A[10]=-34e-5,this.B_re=[],this.B_im=[],this.B_re[1]=.7557853228,this.B_im[1]=0,this.B_re[2]=.249204646,this.B_im[2]=.003371507,this.B_re[3]=-.001541739,this.B_im[3]=.04105856,this.B_re[4]=-.10162907,this.B_im[4]=.01727609,this.B_re[5]=-.26623489,this.B_im[5]=-.36249218,this.B_re[6]=-.6870983,this.B_im[6]=-1.1651967,this.C_re=[],this.C_im=[],this.C_re[1]=1.3231270439,this.C_im[1]=0,this.C_re[2]=-.577245789,this.C_im[2]=-.007809598,this.C_re[3]=.508307513,this.C_im[3]=-.112208952,this.C_re[4]=-.15094762,this.C_im[4]=.18200602,this.C_re[5]=1.01418179,this.C_im[5]=1.64497696,this.C_re[6]=1.9660549,this.C_im[6]=2.5127645,this.D=[],this.D[1]=1.5627014243,this.D[2]=.5185406398,this.D[3]=-.03333098,this.D[4]=-.1052906,this.D[5]=-.0368594,this.D[6]=.007317,this.D[7]=.0122,this.D[8]=.00394,this.D[9]=-.0013},forward:function(t){var e,i=t.x,n=t.y-this.lat0,r=i-this.long0,o=n/c*1e-5,s=r,a=1,l=0;for(e=1;e<=10;e++)a*=o,l+=this.A[e]*a;var h,u=l,d=s,p=1,f=0,m=0,g=0;for(e=1;e<=6;e++)h=f*u+p*d,p=p*u-f*d,f=h,m=m+this.B_re[e]*p-this.B_im[e]*f,g=g+this.B_im[e]*p+this.B_re[e]*f;return t.x=g*this.a+this.x0,t.y=m*this.a+this.y0,t},inverse:function(t){var e,i,n=t.x,r=t.y,o=n-this.x0,s=(r-this.y0)/this.a,a=o/this.a,l=1,h=0,u=0,d=0;for(e=1;e<=6;e++)i=h*s+l*a,l=l*s-h*a,h=i,u=u+this.C_re[e]*l-this.C_im[e]*h,d=d+this.C_im[e]*l+this.C_re[e]*h;for(var p=0;p<this.iterations;p++){var f,m=u,g=d,_=s,y=a;for(e=2;e<=6;e++)f=g*u+m*d,m=m*u-g*d,g=f,_+=(e-1)*(this.B_re[e]*m-this.B_im[e]*g),y+=(e-1)*(this.B_im[e]*m+this.B_re[e]*g);m=1,g=0;var v=this.B_re[1],b=this.B_im[1];for(e=2;e<=6;e++)f=g*u+m*d,m=m*u-g*d,g=f,v+=e*(this.B_re[e]*m-this.B_im[e]*g),b+=e*(this.B_im[e]*m+this.B_re[e]*g);var x=v*v+b*b;u=(_*v+y*b)/x,d=(y*v-_*b)/x}var w=u,L=d,M=1,k=0;for(e=1;e<=9;e++)M*=w,k+=this.D[e]*M;var C=this.lat0+k*c*1e5,A=this.long0+L;return t.x=A,t.y=C,t},names:["New_Zealand_Map_Grid","nzmg"]},Se={init:function(){},forward:function(t){var e=t.x,i=t.y,n=H(e-this.long0),r=this.x0+this.a*n,o=this.y0+this.a*Math.log(Math.tan(Math.PI/4+i/2.5))*1.25;return t.x=r,t.y=o,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0;var e=H(this.long0+t.x/this.a),i=2.5*(Math.atan(Math.exp(.8*t.y/this.a))-Math.PI/4);return t.x=e,t.y=i,t},names:["Miller_Cylindrical","mill"]},Ee={init:function(){this.sphere?(this.n=1,this.m=0,this.es=0,this.C_y=Math.sqrt((this.m+1)/this.n),this.C_x=this.C_y/(this.m+1)):this.en=qt(this.es)},forward:function(t){var e,i,n=t.x,r=t.y;if(n=H(n-this.long0),this.sphere){if(this.m)for(var o=this.n*Math.sin(r),s=20;s;--s){var a=(this.m*r+Math.sin(r)-o)/(this.m+Math.cos(r));if(r-=a,Math.abs(a)<d)break}else r=1!==this.n?Math.asin(this.n*Math.sin(r)):r;e=this.a*this.C_x*n*(this.m+Math.cos(r)),i=this.a*this.C_y*r}else{var l=Math.sin(r),h=Math.cos(r);i=this.a*Wt(r,l,h,this.en),e=this.a*n*h/Math.sqrt(1-this.es*l*l)}return t.x=e,t.y=i,t},inverse:function(t){var e,i,n;return t.x-=this.x0,i=t.x/this.a,t.y-=this.y0,e=t.y/this.a,this.sphere?(e/=this.C_y,i/=this.C_x*(this.m+Math.cos(e)),this.m?e=we((this.m*e+Math.sin(e))/this.n):1!==this.n&&(e=we(Math.sin(e)/this.n)),i=H(i+this.long0),e=_e(e)):(e=Kt(t.y/this.a,this.es,this.en),(n=Math.abs(e))<u?(n=Math.sin(e),i=H(this.long0+t.x*Math.sqrt(1-this.es*n*n)/(this.a*Math.cos(e)))):n-d<u&&(i=this.long0)),t.x=i,t.y=e,t},names:["Sinusoidal","sinu"]},Ie={init:function(){},forward:function(t){for(var e=t.x,i=t.y,n=H(e-this.long0),r=i,o=Math.PI*Math.sin(i);;){var s=-(r+Math.sin(r)-o)/(1+Math.cos(r));if(r+=s,Math.abs(s)<d)break}r/=2,Math.PI/2-Math.abs(i)<d&&(n=0);var a=.900316316158*this.a*n*Math.cos(r)+this.x0,l=1.4142135623731*this.a*Math.sin(r)+this.y0;return t.x=a,t.y=l,t},inverse:function(t){var e,i;t.x-=this.x0,t.y-=this.y0,i=t.y/(1.4142135623731*this.a),Math.abs(i)>.999999999999&&(i=.999999999999),e=Math.asin(i);var n=H(this.long0+t.x/(.900316316158*this.a*Math.cos(e)));n<-Math.PI&&(n=-Math.PI),n>Math.PI&&(n=Math.PI),i=(2*e+Math.sin(2*e))/Math.PI,Math.abs(i)>1&&(i=1);var r=Math.asin(i);return t.x=n,t.y=r,t},names:["Mollweide","moll"]},Te={init:function(){Math.abs(this.lat1+this.lat2)<d||(this.lat2=this.lat2||this.lat1,this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=de(this.es),this.e1=pe(this.es),this.e2=fe(this.es),this.e3=me(this.es),this.sinphi=Math.sin(this.lat1),this.cosphi=Math.cos(this.lat1),this.ms1=G(this.e,this.sinphi,this.cosphi),this.ml1=ue(this.e0,this.e1,this.e2,this.e3,this.lat1),Math.abs(this.lat1-this.lat2)<d?this.ns=this.sinphi:(this.sinphi=Math.sin(this.lat2),this.cosphi=Math.cos(this.lat2),this.ms2=G(this.e,this.sinphi,this.cosphi),this.ml2=ue(this.e0,this.e1,this.e2,this.e3,this.lat2),this.ns=(this.ms1-this.ms2)/(this.ml2-this.ml1)),this.g=this.ml1+this.ms1/this.ns,this.ml0=ue(this.e0,this.e1,this.e2,this.e3,this.lat0),this.rh=this.a*(this.g-this.ml0))},forward:function(t){var e,i=t.x,n=t.y;if(this.sphere)e=this.a*(this.g-n);else{var r=ue(this.e0,this.e1,this.e2,this.e3,n);e=this.a*(this.g-r)}var o=this.ns*H(i-this.long0),s=this.x0+e*Math.sin(o),a=this.y0+this.rh-e*Math.cos(o);return t.x=s,t.y=a,t},inverse:function(t){var e,i,n,r;t.x-=this.x0,t.y=this.rh-t.y+this.y0,this.ns>=0?(i=Math.sqrt(t.x*t.x+t.y*t.y),e=1):(i=-Math.sqrt(t.x*t.x+t.y*t.y),e=-1);var o=0;return 0!==i&&(o=Math.atan2(e*t.x,e*t.y)),this.sphere?(r=H(this.long0+o/this.ns),n=_e(this.g-i/this.a),t.x=r,t.y=n,t):(n=ye(this.g-i/this.a,this.e0,this.e1,this.e2,this.e3),r=H(this.long0+o/this.ns),t.x=r,t.y=n,t)},names:["Equidistant_Conic","eqdc"]},De={init:function(){this.R=this.a},forward:function(t){var e,i,n=t.x,r=t.y,o=H(n-this.long0);Math.abs(r)<=d&&(e=this.x0+this.R*o,i=this.y0);var s=we(2*Math.abs(r/Math.PI));(Math.abs(o)<=d||Math.abs(Math.abs(r)-u)<=d)&&(e=this.x0,i=r>=0?this.y0+Math.PI*this.R*Math.tan(.5*s):this.y0+Math.PI*this.R*-Math.tan(.5*s));var a=.5*Math.abs(Math.PI/o-o/Math.PI),l=a*a,h=Math.sin(s),c=Math.cos(s),p=c/(h+c-1),f=p*p,m=p*(2/h-1),g=m*m,_=Math.PI*this.R*(a*(p-g)+Math.sqrt(l*(p-g)*(p-g)-(g+l)*(f-g)))/(g+l);o<0&&(_=-_),e=this.x0+_;var y=l+p;return _=Math.PI*this.R*(m*y-a*Math.sqrt((g+l)*(l+1)-y*y))/(g+l),i=r>=0?this.y0+_:this.y0-_,t.x=e,t.y=i,t},inverse:function(t){var e,i,n,r,o,s,a,l,h,c,u,p;return t.x-=this.x0,t.y-=this.y0,u=Math.PI*this.R,o=(n=t.x/u)*n+(r=t.y/u)*r,u=3*(r*r/(l=-2*(s=-Math.abs(r)*(1+o))+1+2*r*r+o*o)+(2*(a=s-2*r*r+n*n)*a*a/l/l/l-9*s*a/l/l)/27)/(h=(s-a*a/3/l)/l)/(c=2*Math.sqrt(-h/3)),Math.abs(u)>1&&(u=u>=0?1:-1),p=Math.acos(u)/3,i=t.y>=0?(-c*Math.cos(p+Math.PI/3)-a/3/l)*Math.PI:-(-c*Math.cos(p+Math.PI/3)-a/3/l)*Math.PI,e=Math.abs(n)<d?this.long0:H(this.long0+Math.PI*(o-1+Math.sqrt(1+2*(n*n-r*r)+o*o))/2/n),t.x=e,t.y=i,t},names:["Van_der_Grinten_I","VanDerGrinten","vandg"]},ze={init:function(){this.sin_p12=Math.sin(this.lat0),this.cos_p12=Math.cos(this.lat0)},forward:function(t){var e,i,n,r,o,s,a,l,h,c,p,f,m,g,_,y,v,b,x,w,L,M,k=t.x,C=t.y,A=Math.sin(t.y),P=Math.cos(t.y),S=H(k-this.long0);return this.sphere?Math.abs(this.sin_p12-1)<=d?(t.x=this.x0+this.a*(u-C)*Math.sin(S),t.y=this.y0-this.a*(u-C)*Math.cos(S),t):Math.abs(this.sin_p12+1)<=d?(t.x=this.x0+this.a*(u+C)*Math.sin(S),t.y=this.y0+this.a*(u+C)*Math.cos(S),t):(b=this.sin_p12*A+this.cos_p12*P*Math.cos(S),v=(y=Math.acos(b))?y/Math.sin(y):1,t.x=this.x0+this.a*v*P*Math.sin(S),t.y=this.y0+this.a*v*(this.cos_p12*A-this.sin_p12*P*Math.cos(S)),t):(e=de(this.es),i=pe(this.es),n=fe(this.es),r=me(this.es),Math.abs(this.sin_p12-1)<=d?(o=this.a*ue(e,i,n,r,u),s=this.a*ue(e,i,n,r,C),t.x=this.x0+(o-s)*Math.sin(S),t.y=this.y0-(o-s)*Math.cos(S),t):Math.abs(this.sin_p12+1)<=d?(o=this.a*ue(e,i,n,r,u),s=this.a*ue(e,i,n,r,C),t.x=this.x0+(o+s)*Math.sin(S),t.y=this.y0+(o+s)*Math.cos(S),t):(a=A/P,l=ge(this.a,this.e,this.sin_p12),h=ge(this.a,this.e,A),c=Math.atan((1-this.es)*a+this.es*l*this.sin_p12/(h*P)),x=0===(p=Math.atan2(Math.sin(S),this.cos_p12*Math.tan(c)-this.sin_p12*Math.cos(S)))?Math.asin(this.cos_p12*Math.sin(c)-this.sin_p12*Math.cos(c)):Math.abs(Math.abs(p)-Math.PI)<=d?-Math.asin(this.cos_p12*Math.sin(c)-this.sin_p12*Math.cos(c)):Math.asin(Math.sin(S)*Math.cos(c)/Math.sin(p)),f=this.e*this.sin_p12/Math.sqrt(1-this.es),y=l*x*(1-(w=x*x)*(_=(m=this.e*this.cos_p12*Math.cos(p)/Math.sqrt(1-this.es))*m)*(1-_)/6+(L=w*x)/8*(g=f*m)*(1-2*_)+(M=L*x)/120*(_*(4-7*_)-3*f*f*(1-7*_))-M*x/48*g),t.x=this.x0+y*Math.sin(p),t.y=this.y0+y*Math.cos(p),t))},inverse:function(t){var e,i,n,r,o,s,a,l,h,c,p,f,m,g,_,y,v,b,x,w,L,M,k;if(t.x-=this.x0,t.y-=this.y0,this.sphere){if((e=Math.sqrt(t.x*t.x+t.y*t.y))>2*u*this.a)return;return i=e/this.a,n=Math.sin(i),r=Math.cos(i),o=this.long0,Math.abs(e)<=d?s=this.lat0:(s=we(r*this.sin_p12+t.y*n*this.cos_p12/e),a=Math.abs(this.lat0)-u,o=Math.abs(a)<=d?this.lat0>=0?H(this.long0+Math.atan2(t.x,-t.y)):H(this.long0-Math.atan2(-t.x,t.y)):H(this.long0+Math.atan2(t.x*n,e*this.cos_p12*r-t.y*this.sin_p12*n))),t.x=o,t.y=s,t}return l=de(this.es),h=pe(this.es),c=fe(this.es),p=me(this.es),Math.abs(this.sin_p12-1)<=d?(s=ye(((f=this.a*ue(l,h,c,p,u))-(e=Math.sqrt(t.x*t.x+t.y*t.y)))/this.a,l,h,c,p),o=H(this.long0+Math.atan2(t.x,-1*t.y)),t.x=o,t.y=s,t):Math.abs(this.sin_p12+1)<=d?(f=this.a*ue(l,h,c,p,u),s=ye(((e=Math.sqrt(t.x*t.x+t.y*t.y))-f)/this.a,l,h,c,p),o=H(this.long0+Math.atan2(t.x,t.y)),t.x=o,t.y=s,t):(e=Math.sqrt(t.x*t.x+t.y*t.y),_=Math.atan2(t.x,t.y),m=ge(this.a,this.e,this.sin_p12),y=Math.cos(_),b=-(v=this.e*this.cos_p12*y)*v/(1-this.es),x=3*this.es*(1-b)*this.sin_p12*this.cos_p12*y/(1-this.es),M=1-b*(L=(w=e/m)-b*(1+b)*Math.pow(w,3)/6-x*(1+3*b)*Math.pow(w,4)/24)*L/2-w*L*L*L/6,g=Math.asin(this.sin_p12*Math.cos(L)+this.cos_p12*Math.sin(L)*y),o=H(this.long0+Math.asin(Math.sin(_)*Math.sin(L)/Math.cos(g))),k=Math.sin(g),s=Math.atan2((k-this.es*M*this.sin_p12)*Math.tan(g),k*(1-this.es)),t.x=o,t.y=s,t)},names:["Azimuthal_Equidistant","aeqd"]},Be={init:function(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0)},forward:function(t){var e,i,n,r,o,s,a,l=t.x,h=t.y;return n=H(l-this.long0),e=Math.sin(h),i=Math.cos(h),r=Math.cos(n),((o=this.sin_p14*e+this.cos_p14*i*r)>0||Math.abs(o)<=d)&&(s=1*this.a*i*Math.sin(n),a=this.y0+1*this.a*(this.cos_p14*e-this.sin_p14*i*r)),t.x=s,t.y=a,t},inverse:function(t){var e,i,n,r,o,s,a;return t.x-=this.x0,t.y-=this.y0,i=we((e=Math.sqrt(t.x*t.x+t.y*t.y))/this.a),n=Math.sin(i),r=Math.cos(i),s=this.long0,Math.abs(e)<=d?(a=this.lat0,t.x=s,t.y=a,t):(a=we(r*this.sin_p14+t.y*n*this.cos_p14/e),o=Math.abs(this.lat0)-u,Math.abs(o)<=d?(s=this.lat0>=0?H(this.long0+Math.atan2(t.x,-t.y)):H(this.long0-Math.atan2(-t.x,t.y)),t.x=s,t.y=a,t):(s=H(this.long0+Math.atan2(t.x*n,e*this.cos_p14*r-t.y*this.sin_p14*n)),t.x=s,t.y=a,t))},names:["ortho"]};var Oe=1,Re=2,je=3,Ne=4;function Fe(t,e,i,n){var r;return t<d?(n.value=Oe,r=0):(r=Math.atan2(e,i),Math.abs(r)<=m?n.value=Oe:r>m&&r<=u+m?(n.value=Re,r-=u):r>u+m||r<=-(u+m)?(n.value=je,r=r>=0?r-_:r+_):(n.value=Ne,r+=u)),r}function Ge(t,e){var i=t+e;return i<-_?i+=g:i>+_&&(i-=g),i}const Ue={init:function(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Quadrilateralized Spherical Cube",this.lat0>=u-m/2?this.face=5:this.lat0<=-(u-m/2)?this.face=6:Math.abs(this.long0)<=m?this.face=1:Math.abs(this.long0)<=u+m?this.face=this.long0>0?2:4:this.face=3,0!==this.es&&(this.one_minus_f=1-(this.a-this.b)/this.a,this.one_minus_f_squared=this.one_minus_f*this.one_minus_f)},forward:function(t){var e,i,n,r,o,s,a={x:0,y:0},l={value:0};if(t.x-=this.long0,e=0!==this.es?Math.atan(this.one_minus_f_squared*Math.tan(t.y)):t.y,i=t.x,5===this.face)r=u-e,i>=m&&i<=u+m?(l.value=Oe,n=i-u):i>u+m||i<=-(u+m)?(l.value=Re,n=i>0?i-_:i+_):i>-(u+m)&&i<=-m?(l.value=je,n=i+u):(l.value=Ne,n=i);else if(6===this.face)r=u+e,i>=m&&i<=u+m?(l.value=Oe,n=-i+u):i<m&&i>=-m?(l.value=Re,n=-i):i<-m&&i>=-(u+m)?(l.value=je,n=-i-u):(l.value=Ne,n=i>0?-i+_:-i-_);else{var h,c,d,p,f,g;2===this.face?i=Ge(i,+u):3===this.face?i=Ge(i,+_):4===this.face&&(i=Ge(i,-u)),p=Math.sin(e),f=Math.cos(e),g=Math.sin(i),h=f*Math.cos(i),c=f*g,d=p,1===this.face?n=Fe(r=Math.acos(h),d,c,l):2===this.face?n=Fe(r=Math.acos(c),d,-h,l):3===this.face?n=Fe(r=Math.acos(-h),d,-c,l):4===this.face?n=Fe(r=Math.acos(-c),d,h,l):(r=n=0,l.value=Oe)}return s=Math.atan(12/_*(n+Math.acos(Math.sin(n)*Math.cos(m))-u)),o=Math.sqrt((1-Math.cos(r))/(Math.cos(s)*Math.cos(s))/(1-Math.cos(Math.atan(1/Math.cos(n))))),l.value===Re?s+=u:l.value===je?s+=_:l.value===Ne&&(s+=1.5*_),a.x=o*Math.cos(s),a.y=o*Math.sin(s),a.x=a.x*this.a+this.x0,a.y=a.y*this.a+this.y0,t.x=a.x,t.y=a.y,t},inverse:function(t){var e,i,n,r,o,s,a,l,h,c,d,p,f={lam:0,phi:0},m={value:0};if(t.x=(t.x-this.x0)/this.a,t.y=(t.y-this.y0)/this.a,i=Math.atan(Math.sqrt(t.x*t.x+t.y*t.y)),e=Math.atan2(t.y,t.x),t.x>=0&&t.x>=Math.abs(t.y)?m.value=Oe:t.y>=0&&t.y>=Math.abs(t.x)?(m.value=Re,e-=u):t.x<0&&-t.x>=Math.abs(t.y)?(m.value=je,e=e<0?e+_:e-_):(m.value=Ne,e+=u),h=_/12*Math.tan(e),o=Math.sin(h)/(Math.cos(h)-1/Math.sqrt(2)),s=Math.atan(o),(a=1-(n=Math.cos(e))*n*(r=Math.tan(i))*r*(1-Math.cos(Math.atan(1/Math.cos(s)))))<-1?a=-1:a>1&&(a=1),5===this.face)l=Math.acos(a),f.phi=u-l,m.value===Oe?f.lam=s+u:m.value===Re?f.lam=s<0?s+_:s-_:m.value===je?f.lam=s-u:f.lam=s;else if(6===this.face)l=Math.acos(a),f.phi=l-u,m.value===Oe?f.lam=-s+u:m.value===Re?f.lam=-s:m.value===je?f.lam=-s-u:f.lam=s<0?-s-_:-s+_;else{var g,y,v;h=(g=a)*g,y=(h+=(v=h>=1?0:Math.sqrt(1-h)*Math.sin(s))*v)>=1?0:Math.sqrt(1-h),m.value===Re?(h=y,y=-v,v=h):m.value===je?(y=-y,v=-v):m.value===Ne&&(h=y,y=v,v=-h),2===this.face?(h=g,g=-y,y=h):3===this.face?(g=-g,y=-y):4===this.face&&(h=g,g=y,y=-h),f.phi=Math.acos(-v)-u,f.lam=Math.atan2(y,g),2===this.face?f.lam=Ge(f.lam,-u):3===this.face?f.lam=Ge(f.lam,-_):4===this.face&&(f.lam=Ge(f.lam,+u))}return 0!==this.es&&(c=f.phi<0?1:0,d=Math.tan(f.phi),p=this.b/Math.sqrt(d*d+this.one_minus_f_squared),f.phi=Math.atan(Math.sqrt(this.a*this.a-p*p)/(this.one_minus_f*p)),c&&(f.phi=-f.phi)),f.lam+=this.long0,t.x=f.lam,t.y=f.phi,t},names:["Quadrilateralized Spherical Cube","Quadrilateralized_Spherical_Cube","qsc"]};var He=[[1,22199e-21,-715515e-10,31103e-10],[.9986,-482243e-9,-24897e-9,-13309e-10],[.9954,-83103e-8,-448605e-10,-9.86701e-7],[.99,-.00135364,-59661e-9,36777e-10],[.9822,-.00167442,-449547e-11,-572411e-11],[.973,-.00214868,-903571e-10,1.8736e-8],[.96,-.00305085,-900761e-10,164917e-11],[.9427,-.00382792,-653386e-10,-26154e-10],[.9216,-.00467746,-10457e-8,481243e-11],[.8962,-.00536223,-323831e-10,-543432e-11],[.8679,-.00609363,-113898e-9,332484e-11],[.835,-.00698325,-640253e-10,9.34959e-7],[.7986,-.00755338,-500009e-10,9.35324e-7],[.7597,-.00798324,-35971e-9,-227626e-11],[.7186,-.00851367,-701149e-10,-86303e-10],[.6732,-.00986209,-199569e-9,191974e-10],[.6213,-.010418,883923e-10,624051e-11],[.5722,-.00906601,182e-6,624051e-11],[.5322,-.00677797,275608e-9,624051e-11]],Ve=[[-520417e-23,.0124,121431e-23,-845284e-16],[.062,.0124,-1.26793e-9,4.22642e-10],[.124,.0124,5.07171e-9,-1.60604e-9],[.186,.0123999,-1.90189e-8,6.00152e-9],[.248,.0124002,7.10039e-8,-2.24e-8],[.31,.0123992,-2.64997e-7,8.35986e-8],[.372,.0124029,9.88983e-7,-3.11994e-7],[.434,.0123893,-369093e-11,-4.35621e-7],[.4958,.0123198,-102252e-10,-3.45523e-7],[.5571,.0121916,-154081e-10,-5.82288e-7],[.6176,.0119938,-241424e-10,-5.25327e-7],[.6769,.011713,-320223e-10,-5.16405e-7],[.7346,.0113541,-397684e-10,-6.09052e-7],[.7903,.0109107,-489042e-10,-104739e-11],[.8435,.0103431,-64615e-9,-1.40374e-9],[.8936,.00969686,-64636e-9,-8547e-9],[.9394,.00840947,-192841e-9,-42106e-10],[.9761,.00616527,-256e-6,-42106e-10],[1,.00328947,-319159e-9,-42106e-10]],Ze=.8487,qe=1.3523,We=f/5,Ke=1/We,Ye=function(t,e){return t[0]+e*(t[1]+e*(t[2]+e*t[3]))};const Xe={init:function(){this.x0=this.x0||0,this.y0=this.y0||0,this.long0=this.long0||0,this.es=0,this.title=this.title||"Robinson"},forward:function(t){var e=H(t.x-this.long0),i=Math.abs(t.y),n=Math.floor(i*We);n<0?n=0:n>=18&&(n=17);var r={x:Ye(He[n],i=f*(i-Ke*n))*e,y:Ye(Ve[n],i)};return t.y<0&&(r.y=-r.y),r.x=r.x*this.a*Ze+this.x0,r.y=r.y*this.a*qe+this.y0,r},inverse:function(t){var e={x:(t.x-this.x0)/(this.a*Ze),y:Math.abs(t.y-this.y0)/(this.a*qe)};if(e.y>=1)e.x/=He[18][0],e.y=t.y<0?-u:u;else{var i=Math.floor(18*e.y);for(i<0?i=0:i>=18&&(i=17);;)if(Ve[i][0]>e.y)--i;else{if(!(Ve[i+1][0]<=e.y))break;++i}var n=Ve[i],r=5*(e.y-n[0])/(Ve[i+1][0]-n[0]);r=function(t,e,i,n){for(var r=e;n;--n){var o=t(r);if(r-=o,Math.abs(o)<1e-10)break}return r}((function(t){return(Ye(n,t)-e.y)/function(t,e){return t[1]+e*(2*t[2]+3*e*t[3])}(n,t)}),r,0,100),e.x/=Ye(He[i],r),e.y=(5*i+r)*p,t.y<0&&(e.y=-e.y)}return e.x=H(e.x+this.long0),e},names:["Robinson","robin"]},Je={init:function(){this.name="geocent"},forward:function(t){return ct(t,this.es,this.a)},inverse:function(t){return ut(t,this.es,this.a,this.b)},names:["Geocentric","geocentric","geocent","Geocent"]};var Qe={h:{def:1e5,num:!0},azi:{def:0,num:!0,degrees:!0},tilt:{def:0,num:!0,degrees:!0},long0:{def:0,num:!0},lat0:{def:0,num:!0}};const $e={init:function(){if(Object.keys(Qe).forEach(function(t){if(void 0===this[t])this[t]=Qe[t].def;else{if(Qe[t].num&&isNaN(this[t]))throw new Error("Invalid parameter value, must be numeric "+t+" = "+this[t]);Qe[t].num&&(this[t]=parseFloat(this[t]))}Qe[t].degrees&&(this[t]=this[t]*p)}.bind(this)),Math.abs(Math.abs(this.lat0)-u)<d?this.mode=this.lat0<0?1:0:Math.abs(this.lat0)<d?this.mode=2:(this.mode=3,this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0)),this.pn1=this.h/this.a,this.pn1<=0||this.pn1>1e10)throw new Error("Invalid height");this.p=1+this.pn1,this.rp=1/this.p,this.h1=1/this.pn1,this.pfact=(this.p+1)*this.h1,this.es=0;var t=this.tilt,e=this.azi;this.cg=Math.cos(e),this.sg=Math.sin(e),this.cw=Math.cos(t),this.sw=Math.sin(t)},forward:function(t){t.x-=this.long0;var e,i,n,r,o=Math.sin(t.y),s=Math.cos(t.y),a=Math.cos(t.x);switch(this.mode){case 3:i=this.sinph0*o+this.cosph0*s*a;break;case 2:i=s*a;break;case 1:i=-o;break;case 0:i=o}switch(e=(i=this.pn1/(this.p-i))*s*Math.sin(t.x),this.mode){case 3:i*=this.cosph0*o-this.sinph0*s*a;break;case 2:i*=o;break;case 0:i*=-s*a;break;case 1:i*=s*a}return r=1/((n=i*this.cg+e*this.sg)*this.sw*this.h1+this.cw),e=(e*this.cg-i*this.sg)*this.cw*r,i=n*r,t.x=e*this.a,t.y=i*this.a,t},inverse:function(t){t.x/=this.a,t.y/=this.a;var e,i,n,r={x:t.x,y:t.y};n=1/(this.pn1-t.y*this.sw),e=this.pn1*t.x*n,i=this.pn1*t.y*this.cw*n,t.x=e*this.cg+i*this.sg,t.y=i*this.cg-e*this.sg;var o=Jt(t.x,t.y);if(Math.abs(o)<d)r.x=0,r.y=t.y;else{var s,a;switch(a=1-o*o*this.pfact,a=(this.p-Math.sqrt(a))/(this.pn1/o+o/this.pn1),s=Math.sqrt(1-a*a),this.mode){case 3:r.y=Math.asin(s*this.sinph0+t.y*a*this.cosph0/o),t.y=(s-this.sinph0*Math.sin(r.y))*o,t.x*=a*this.cosph0;break;case 2:r.y=Math.asin(t.y*a/o),t.y=s*o,t.x*=a;break;case 0:r.y=Math.asin(s),t.y=-t.y;break;case 1:r.y=-Math.asin(s)}r.x=Math.atan2(t.x,t.y)}return t.x=r.x+this.long0,t.y=r.y,t},names:["Tilted_Perspective","tpers"]},ti={init:function(){if(this.flip_axis="x"===this.sweep?1:0,this.h=Number(this.h),this.radius_g_1=this.h/this.a,this.radius_g_1<=0||this.radius_g_1>1e10)throw new Error;if(this.radius_g=1+this.radius_g_1,this.C=this.radius_g*this.radius_g-1,0!==this.es){var t=1-this.es,e=1/t;this.radius_p=Math.sqrt(t),this.radius_p2=t,this.radius_p_inv2=e,this.shape="ellipse"}else this.radius_p=1,this.radius_p2=1,this.radius_p_inv2=1,this.shape="sphere";this.title||(this.title="Geostationary Satellite View")},forward:function(t){var e,i,n,r,o=t.x,s=t.y;if(o-=this.long0,"ellipse"===this.shape){s=Math.atan(this.radius_p2*Math.tan(s));var a=this.radius_p/Jt(this.radius_p*Math.cos(s),Math.sin(s));if(i=a*Math.cos(o)*Math.cos(s),n=a*Math.sin(o)*Math.cos(s),r=a*Math.sin(s),(this.radius_g-i)*i-n*n-r*r*this.radius_p_inv2<0)return t.x=Number.NaN,t.y=Number.NaN,t;e=this.radius_g-i,this.flip_axis?(t.x=this.radius_g_1*Math.atan(n/Jt(r,e)),t.y=this.radius_g_1*Math.atan(r/e)):(t.x=this.radius_g_1*Math.atan(n/e),t.y=this.radius_g_1*Math.atan(r/Jt(n,e)))}else"sphere"===this.shape&&(e=Math.cos(s),i=Math.cos(o)*e,n=Math.sin(o)*e,r=Math.sin(s),e=this.radius_g-i,this.flip_axis?(t.x=this.radius_g_1*Math.atan(n/Jt(r,e)),t.y=this.radius_g_1*Math.atan(r/e)):(t.x=this.radius_g_1*Math.atan(n/e),t.y=this.radius_g_1*Math.atan(r/Jt(n,e))));return t.x=t.x*this.a,t.y=t.y*this.a,t},inverse:function(t){var e,i,n,r,o=-1,s=0,a=0;if(t.x=t.x/this.a,t.y=t.y/this.a,"ellipse"===this.shape){this.flip_axis?(a=Math.tan(t.y/this.radius_g_1),s=Math.tan(t.x/this.radius_g_1)*Jt(1,a)):(s=Math.tan(t.x/this.radius_g_1),a=Math.tan(t.y/this.radius_g_1)*Jt(1,s));var l=a/this.radius_p;if(e=s*s+l*l+o*o,(n=(i=2*this.radius_g*o)*i-4*e*this.C)<0)return t.x=Number.NaN,t.y=Number.NaN,t;r=(-i-Math.sqrt(n))/(2*e),o=this.radius_g+r*o,s*=r,a*=r,t.x=Math.atan2(s,o),t.y=Math.atan(a*Math.cos(t.x)/o),t.y=Math.atan(this.radius_p_inv2*Math.tan(t.y))}else if("sphere"===this.shape){if(this.flip_axis?(a=Math.tan(t.y/this.radius_g_1),s=Math.tan(t.x/this.radius_g_1)*Math.sqrt(1+a*a)):(s=Math.tan(t.x/this.radius_g_1),a=Math.tan(t.y/this.radius_g_1)*Math.sqrt(1+s*s)),e=s*s+a*a+o*o,(n=(i=2*this.radius_g*o)*i-4*e*this.C)<0)return t.x=Number.NaN,t.y=Number.NaN,t;r=(-i-Math.sqrt(n))/(2*e),o=this.radius_g+r*o,s*=r,a*=r,t.x=Math.atan2(s,o),t.y=Math.atan(a*Math.cos(t.x)/o)}return t.x=t.x+this.long0,t},names:["Geostationary Satellite View","Geostationary_Satellite","geos"]};var ei=1.340264,ii=-.081106,ni=893e-6,ri=.003796,oi=Math.sqrt(3)/2;const si={init:function(){this.es=0,this.long0=void 0!==this.long0?this.long0:0},forward:function(t){var e=H(t.x-this.long0),i=t.y,n=Math.asin(oi*Math.sin(i)),r=n*n,o=r*r*r;return t.x=e*Math.cos(n)/(oi*(ei+3*ii*r+o*(7*ni+9*ri*r))),t.y=n*(ei+ii*r+o*(ni+ri*r)),t.x=this.a*t.x+this.x0,t.y=this.a*t.y+this.y0,t},inverse:function(t){t.x=(t.x-this.x0)/this.a,t.y=(t.y-this.y0)/this.a;var e,i,n,r,o=t.y;for(r=0;r<12&&(o-=n=(o*(ei+ii*(e=o*o)+(i=e*e*e)*(ni+ri*e))-t.y)/(ei+3*ii*e+i*(7*ni+9*ri*e)),!(Math.abs(n)<1e-9));++r);return i=(e=o*o)*e*e,t.x=oi*t.x*(ei+3*ii*e+i*(7*ni+9*ri*e))/Math.cos(o),t.y=Math.asin(Math.sin(o)/oi),t.x=H(t.x+this.long0),t},names:["eqearth","Equal Earth","Equal_Earth"]};var ai;Lt.defaultDatum="WGS84",Lt.Proj=ht,Lt.WGS84=new Lt.Proj("WGS84"),Lt.Point=Ut,Lt.toPoint=_t,Lt.defs=R,Lt.nadgrid=function(t,e){var i=new DataView(e),n=function(t){var e=t.getInt32(8,!1);return 11!==e&&(11!==(e=t.getInt32(8,!0))&&console.warn("Failed to detect nadgrid endian-ness, defaulting to little-endian"),!0)}(i),r=function(t,e){return{nFields:t.getInt32(8,e),nSubgridFields:t.getInt32(24,e),nSubgrids:t.getInt32(40,e),shiftType:rt(t,56,64).trim(),fromSemiMajorAxis:t.getFloat64(120,e),fromSemiMinorAxis:t.getFloat64(136,e),toSemiMajorAxis:t.getFloat64(152,e),toSemiMinorAxis:t.getFloat64(168,e)}}(i,n),o=function(t,e,i){for(var n=176,r=[],o=0;o<e.nSubgrids;o++){var s=st(t,n,i),a=at(t,n,s,i),l=Math.round(1+(s.upperLongitude-s.lowerLongitude)/s.longitudeInterval),h=Math.round(1+(s.upperLatitude-s.lowerLatitude)/s.latitudeInterval);r.push({ll:[nt(s.lowerLongitude),nt(s.lowerLatitude)],del:[nt(s.longitudeInterval),nt(s.latitudeInterval)],lim:[l,h],count:s.gridNodeCount,cvs:ot(a)}),n+=176+16*s.gridNodeCount}return r}(i,r,n),s={header:r,subgrids:o};return et[t]=s,s},Lt.transform=vt,Lt.mgrs=Tt,Lt.version="__VERSION__",(ai=Lt).Proj.projections.add(Yt),ai.Proj.projections.add(te),ai.Proj.projections.add(ee),ai.Proj.projections.add(re),ai.Proj.projections.add(oe),ai.Proj.projections.add(se),ai.Proj.projections.add(le),ai.Proj.projections.add(he),ai.Proj.projections.add(ce),ai.Proj.projections.add(ve),ai.Proj.projections.add(xe),ai.Proj.projections.add(Le),ai.Proj.projections.add(Me),ai.Proj.projections.add(ke),ai.Proj.projections.add(Ce),ai.Proj.projections.add(Ae),ai.Proj.projections.add(Pe),ai.Proj.projections.add(Se),ai.Proj.projections.add(Ee),ai.Proj.projections.add(Ie),ai.Proj.projections.add(Te),ai.Proj.projections.add(De),ai.Proj.projections.add(ze),ai.Proj.projections.add(Be),ai.Proj.projections.add(Ue),ai.Proj.projections.add(Xe),ai.Proj.projections.add(Je),ai.Proj.projections.add($e),ai.Proj.projections.add(ti),ai.Proj.projections.add(si);const li=Lt},2600:(t,e,i)=>{var n,r,o;r=[i(4067),i(248)],void 0===(o="function"==typeof(n=function(t,e){return e.__esModule&&e.default&&(e=e.default),t.Proj={},t.Proj._isProj4Obj=function(t){return void 0!==t.inverse&&void 0!==t.forward},t.Proj.Projection=t.Class.extend({initialize:function(e,i,n){var r=t.Proj._isProj4Obj(e);this._proj=r?e:this._projFromCodeDef(e,i),this.bounds=r?i:n},project:function(e){var i=this._proj.forward([e.lng,e.lat]);return new t.Point(i[0],i[1])},unproject:function(e,i){var n=this._proj.inverse([e.x,e.y]);return new t.LatLng(n[1],n[0],i)},_projFromCodeDef:function(t,i){if(i)e.defs(t,i);else if(void 0===e.defs[t]){var n=t.split(":");if(n.length>3&&(t=n[n.length-3]+":"+n[n.length-1]),void 0===e.defs[t])throw"No projection definition for code "+t}return e(t)}}),t.Proj.CRS=t.Class.extend({includes:t.CRS,options:{transformation:new t.Transformation(1,0,-1,0)},initialize:function(e,i,n){var r,o,s,a;if(t.Proj._isProj4Obj(e)?(r=(o=e).srsCode,a=i||{},this.projection=new t.Proj.Projection(o,a.bounds)):(r=e,s=i,a=n||{},this.projection=new t.Proj.Projection(r,s,a.bounds)),t.Util.setOptions(this,a),this.code=r,this.transformation=this.options.transformation,this.options.origin&&(this.transformation=new t.Transformation(1,-this.options.origin[0],-1,this.options.origin[1])),this.options.scales)this._scales=this.options.scales;else if(this.options.resolutions){this._scales=[];for(var l=this.options.resolutions.length-1;l>=0;l--)this.options.resolutions[l]&&(this._scales[l]=1/this.options.resolutions[l])}this.infinite=!this.options.bounds},scale:function(t){var e,i=Math.floor(t);return t===i?this._scales[t]:(e=this._scales[i])+(this._scales[i+1]-e)*(t-i)},zoom:function(t){var e,i,n=this._closestElement(this._scales,t),r=this._scales.indexOf(n);return t===n?r:void 0===n?-1/0:(i=r+1,void 0===(e=this._scales[i])?1/0:(t-n)/(e-n)+r)},distance:t.CRS.Earth.distance,R:t.CRS.Earth.R,_closestElement:function(t,e){for(var i,n=t.length;n--;)t[n]<=e&&(void 0===i||i<t[n])&&(i=t[n]);return i}}),t.Proj.GeoJSON=t.GeoJSON.extend({initialize:function(e,i){this._callLevel=0,t.GeoJSON.prototype.initialize.call(this,e,i)},addData:function(e){var i;e&&(e.crs&&"name"===e.crs.type?i=new t.Proj.CRS(e.crs.properties.name):e.crs&&e.crs.type&&(i=new t.Proj.CRS(e.crs.type+":"+e.crs.properties.code)),void 0!==i&&(this.options.coordsToLatLng=function(e){var n=t.point(e[0],e[1]);return i.projection.unproject(n)})),this._callLevel++;try{t.GeoJSON.prototype.addData.call(this,e)}finally{this._callLevel--,0===this._callLevel&&delete this.options.coordsToLatLng}}}),t.Proj.geoJson=function(e,i){return new t.Proj.GeoJSON(e,i)},t.Proj.ImageOverlay=t.ImageOverlay.extend({initialize:function(e,i,n){t.ImageOverlay.prototype.initialize.call(this,e,null,n),this._projectedBounds=i},_animateZoom:function(e){var i=this._map.getZoomScale(e.zoom),n=t.point(this._projectedBounds.min.x,this._projectedBounds.max.y),r=this._projectedToNewLayerPoint(n,e.zoom,e.center);t.DomUtil.setTransform(this._image,r,i)},_reset:function(){var e=this._map.getZoom(),i=this._map.getPixelOrigin(),n=t.bounds(this._transform(this._projectedBounds.min,e)._subtract(i),this._transform(this._projectedBounds.max,e)._subtract(i)),r=n.getSize();t.DomUtil.setPosition(this._image,n.min),this._image.style.width=r.x+"px",this._image.style.height=r.y+"px"},_projectedToNewLayerPoint:function(t,e,i){var n=this._map.getSize()._divideBy(2),r=this._map.project(i,e)._subtract(n)._round().add(this._map._getMapPanePos());return this._transform(t,e)._subtract(r)},_transform:function(t,e){var i=this._map.options.crs,n=i.transformation,r=i.scale(e);return n.transform(t,r)}}),t.Proj.imageOverlay=function(e,i,n){return new t.Proj.ImageOverlay(e,i,n)},t.Proj})?n.apply(e,r):n)||(t.exports=o)},3544:(t,e,i)=>{var n=i(5072),r=i(1195);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},3058:(t,e,i)=>{var n=i(5072),r=i(1901);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},2389:(t,e,i)=>{var n=i(5072),r=i(7362);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},1339:(t,e,i)=>{var n=i(5072),r=i(6080);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},3795:(t,e,i)=>{var n=i(5072),r=i(6328);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},6680:(t,e,i)=>{var n=i(5072),r=i(9499);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},5616:(t,e,i)=>{var n=i(5072),r=i(3867);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},5786:(t,e,i)=>{var n=i(5072),r=i(3759);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},7609:(t,e,i)=>{var n=i(5072),r=i(8570);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},7536:(t,e,i)=>{var n=i(5072),r=i(2243);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},2942:(t,e,i)=>{var n=i(5072),r=i(3277);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},4759:(t,e,i)=>{var n=i(5072),r=i(8968);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},2274:(t,e,i)=>{var n=i(5072),r=i(1081);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},8168:(t,e,i)=>{var n=i(5072),r=i(5815);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.id,r,""]]);n(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},5072:(t,e,i)=>{"use strict";var n,r=function(){var t={};return function(e){if(void 0===t[e]){var i=document.querySelector(e);if(window.HTMLIFrameElement&&i instanceof window.HTMLIFrameElement)try{i=i.contentDocument.head}catch(t){i=null}t[e]=i}return t[e]}}(),o=[];function s(t){for(var e=-1,i=0;i<o.length;i++)if(o[i].identifier===t){e=i;break}return e}function a(t,e){for(var i={},n=[],r=0;r<t.length;r++){var a=t[r],l=e.base?a[0]+e.base:a[0],h=i[l]||0,c="".concat(l," ").concat(h);i[l]=h+1;var u=s(c),d={css:a[1],media:a[2],sourceMap:a[3]};-1!==u?(o[u].references++,o[u].updater(d)):o.push({identifier:c,updater:m(d,e),references:1}),n.push(c)}return n}function l(t){var e=document.createElement("style"),n=t.attributes||{};if(void 0===n.nonce){var o=i.nc;o&&(n.nonce=o)}if(Object.keys(n).forEach((function(t){e.setAttribute(t,n[t])})),"function"==typeof t.insert)t.insert(e);else{var s=r(t.insert||"head");if(!s)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");s.appendChild(e)}return e}var h,c=(h=[],function(t,e){return h[t]=e,h.filter(Boolean).join("\n")});function u(t,e,i,n){var r=i?"":n.media?"@media ".concat(n.media," {").concat(n.css,"}"):n.css;if(t.styleSheet)t.styleSheet.cssText=c(e,r);else{var o=document.createTextNode(r),s=t.childNodes;s[e]&&t.removeChild(s[e]),s.length?t.insertBefore(o,s[e]):t.appendChild(o)}}function d(t,e,i){var n=i.css,r=i.media,o=i.sourceMap;if(r?t.setAttribute("media",r):t.removeAttribute("media"),o&&"undefined"!=typeof btoa&&(n+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(o))))," */")),t.styleSheet)t.styleSheet.cssText=n;else{for(;t.firstChild;)t.removeChild(t.firstChild);t.appendChild(document.createTextNode(n))}}var p=null,f=0;function m(t,e){var i,n,r;if(e.singleton){var o=f++;i=p||(p=l(e)),n=u.bind(null,i,o,!1),r=u.bind(null,i,o,!0)}else i=l(e),n=d.bind(null,i,e),r=function(){!function(t){if(null===t.parentNode)return!1;t.parentNode.removeChild(t)}(i)};return n(t),function(e){if(e){if(e.css===t.css&&e.media===t.media&&e.sourceMap===t.sourceMap)return;n(t=e)}else r()}}t.exports=function(t,e){(e=e||{}).singleton||"boolean"==typeof e.singleton||(e.singleton=(void 0===n&&(n=Boolean(window&&document&&document.all&&!window.atob)),n));var i=a(t=t||[],e);return function(t){if(t=t||[],"[object Array]"===Object.prototype.toString.call(t)){for(var n=0;n<i.length;n++){var r=s(i[n]);o[r].references--}for(var l=a(t,e),h=0;h<i.length;h++){var c=s(i[h]);0===o[c].references&&(o[c].updater(),o.splice(c,1))}i=l}}}},8304:t=>{"use strict";t.exports="data:image/png;base64,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"},2223:t=>{"use strict";t.exports="data:image/png;base64,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"},5200:t=>{"use strict";t.exports="data:image/svg+xml;base64,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"},9766:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABoAAAA0CAYAAACU7CiIAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAACoSURBVFiF7ZZhDoAgCIWxdbF3suxkHM3+1FaOmNqyIr6fiHuJTyKklKgHQxcVF7rCKAUBiA5h5tCSR/T0iTakL9PWz05IZNEM3YSCt6BvCgFI2ps4Q9v3k9Ldgdrr8nrX9LYc7wwu5EIu9KCQT6rq+r8mVbV0ewBEIpqy8MzMsWR/8f+oxmES9u7olZPqLKQeYtqkWuy61V2xND/H3h35pNqMPTPYE1oAnZZStKN8jj8AAAAASUVORK5CYII="},6622:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADQAAABoCAYAAAC+NNNnAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAbrwAAG68BXhqRHAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAEhSURBVHic7dpBDoIwFADRj/FiPRlwsh4NN5CoiVKg1Ukzb43ApKK1dliWJXpy+/cN1GYQnUF0BtEZRHcvPTCldGhKkXMefnm+TXcjZBBd8TP0rvQ9ffb1R5+xTXcjZBCdQXQG0Q2u+sAZRGcQnUF0p9cUrv4eanW97kbIIDqD6AyiO70ut7du1mrdbU93I2QQnWsKdAbRGURnEJ1BdAbRGURnEJ1BdAbRueeUziA695zSGURnEN3pT7lvUkpTRIw7h80556n2tauPUGFMRMS4HltV9f+HWs3RSnX3DBlEZxCdQXQt9pzOUfbFuh179Xovqo/QOp35eKNPmkx9mszl1hudWpx7T3fPkEF0BtG555TOIDr3nNIZRGcQnUF0BtE9AF5WX48h7QeZAAAAAElFTkSuQmCC"},2434:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAYAAABWdVznAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAOxAAADsQBlSsOGwAAAS9JREFUKJGFkDFOAlEURc8dRphJFNmBHYnQYbTHDnsa0BDBRq1YC4naIQbWYEloqKQyswIXQEgwDIn5z2IATUR95X/nvpz7xWqq7XEYztO3QM2wAoCkyLCBt5zf9XrlGEAAtebkwPfdM+iQLWMQpVKu8nh/8qZqexyG7zuT3+DvoVwme+QlGmtYTcMGG8h4MnOtlUpxFs9ufKD2BbjTULqMwZlhobhaoO5mL+q+YQUlVZB0HoMF0EKwwLpC9XVApoL3w9UwgOk00LYuvqQIKK2dEw3rBrmFhSR6wMXqXOQbNhAqJQ9utECJhiAGc7KRZ1oF1FejMQxcZu9FUPznW19zmeyx1+uV41TKVQyiv2DnPs46nfxyU6zRGAaW3r02UZepsHYG9feD7EOnk18CfAKwIX1qvqPBeQAAAABJRU5ErkJggg=="},5953:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAOxAAADsQBlSsOGwAAApxJREFUSImtlr1PWlEYxp/ncE1KYWy6Gh3FwUZiOtiYuqlbGwxRaKJRjI5tqon/gf4BpqIxERC1doaNxLaD8SNxUOdqOukoiLHc83YALdwPhLbP+J5zfs977n3OPZeoo7Hp/XbTVGEArwEEBHhWHpErgmcQ5Kg8m+vLL364MehUjEzstZHGIiBvSKp6TYiIBvHFLKnZ9Fr3+aMG0cn9KKg+EXhaD+xgVaDm1PpqcKO6WtPdu9jBHKkSzcMBgD5RSEVjhx9qqtWdkyrRPNguAUaT8WD6wSAysddGZZz8XedODpIXMpCMBy8UAChlLNjgInmIHgTwvQ5qtzxHCjVV0k9gAQDU2PR+u4i8ta4kVSix0pMtGk8GAPnmBNc3xlBipScLkZB9EzI8Mn7UqkxThZ2iKNDzoZkT/85SZ75oeActJrv6xhhKpboKoZkTP6jm7Q1SGYYOK5QPkYP4ylsqZiKRY9/OUmde37QMiMhXK9xbus0C6HUiCNivAAScDcom9P7KRCLHvlSqqyDFlsFG4QBAoIPR2OEdgRZ3E6C6awBoBF7Zw13dz8D/kALk6pE5Nc/8z4t3TVeVeKkInjUK95Zus95SMVMnXRbJqYIg1ygcQG+ddNmkBTlF5dkUEW031wvuaalNF1T51FpkktwiAERjB9sEhy0OBYiEKofILS27Qlmk4DNAn2UsnYgHRw0AMEtq1jD0UO0k+kBmXMD36qOwz7Z54Frr0hxQuQ/Sa93n1Jx6BNaEOLmx+vLngwEArK8GNyD4+M9skffJePf2g5V1PBo7HKHIMkh/U1zgGuBkNRywXJkAkIwH00IGAGw5pssuE0Da49EBKxxw+au418j4Uath6LCA/QQ6AHleWXYJyKkW5EhuJePBCzfGbyl+TiY9AObiAAAAAElFTkSuQmCC"},1558:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAYAAABWdVznAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAOxAAADsQBlSsOGwAAASVJREFUKJF1kDFLAgEYhp/37tQ7KPMftAnZZtjSkg2B7S5KHLRVk3O/IQiEakzQra2h0SannOR+QWuLYKF03teQwkHeO3483/e+7ydWanZGQTDLXwMtwyoAkiLDBs5idt/r1ecAAmhdjHc9L3kF7bFBBpHrJo2nh8MPNTujIPjKjbPg9FKpUDxw/mJkw2Y8G3wL9qfz6ZUDtLLP2l0gQiACMNF21gVX+kzDvnQzx14ENQCZKk7K+s39cSoGkzQMOkmbepIioCpxHOeW57l4ceR5/nITDBZ5hg2EqgBCt7FXyMXY6X8YQH2F4dBPCtvvgv3M8oDBpFQo1pxerz533aRhq09kwUkSn3W75YXWwzAc+pbfujTRlqmyzgzq7/jFx263vAD4BStdctyYQ7zEAAAAAElFTkSuQmCC"},9181:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAOxAAADsQBlSsOGwAAAlZJREFUSImllr9PU1EYhp/3tJMyGqIuBhYNnQyXhMRJNlcHg0AxIC3pqhFi4iCLCf4FtFaUFgok/AMmBldSqpOwuAhhghFx6r2fAwX641Jy6zu+57vP+30n5+Rc0UYTmXKv77th4CGQMLhxumJHQrsYm3Kx1aXs/d+XMRRmjk1t9Ujx92CPJbl2TZhZgNjwq26mtNi/d2VAMlVOIrcguNYOHBJ1okDTS3lvpd5t6G48vT0ruUJ0OICum2M5ma68bHDrO5dcITq4VQajxZxXOg8Ym9rqkYv/7KzzsAT7Y1KimPP2HYBz8fn/gRv8bTCkLsE8gCYy5d5qVb+uOi1ttOQH1Tcxxb8i7l4MYYHvu17n+264c7h97rnVP7mSHzxAZBqHkIvHg2HH6SXqEO49n5tT8CxduWdGqaUCDTkgERlt9qkeHhjfJG421wn63MX1b8F8waiGwXtve1NXwWvV3aF7b5At5LxHOHtaHxINfioHdtRq6gfICtmBjbOQTuCgQye02zpBsDCerkwB1EIeRIcD2I7GU5XXiHchixaI1HJ24OOZEw0Ogdmsk4utmlkQMp6c8SGZKk92Agd8SWsCSKa314WehNeZmektkIkABygVct6oA/CrbgbsJLxOkpiLAjc49oPqLNTeg9Ji/54CTUfo7goptZIfPDgPAFjKeysYr/6bbfaimOtfP49qXk+mKyMyyyJ1ReLCMShVD4emJxOgmPNKJiWAtfDT1SIfKMViQaIZDpf8VZxpZPL7nXg8GDY0JOgD6659dgi2ExibktaKOW//MsY/pXkXxnBJQFMAAAAASUVORK5CYII="},4994:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAYAAABWdVznAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAOxAAADsQBlSsOGwAAAOhJREFUKJGVkTFug0AQRd+sgBOkyT1MvxVdipQpbDcBrsExAq4iipQWpbvt1xeJlBNgsZPCYK1sJ1GmfX//PM3CP0cAXqrjQwqVqmbG4N7b3AFsa29DwIrIeILuo1t9GYAUKqD4pbiYMyQAqpoBrt/lTZyaN7l16RsguzwwBreENq/HZ0TfEFEVrfs2H2Iu17s3pf/E8CSTmCDs+93qMebm9gyiMomZJNyyRWlbe7s4q2itInvBgFJe8wQgBOxc4Po2H4Ahbo15craQESjWpW9++AeLcrgonaBLzw3ZPW+UQxrG9i77a74B+z5bQloZOFAAAAAASUVORK5CYII="},9393:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAOxAAADsQBlSsOGwAAAXBJREFUSIntlb8uBFEUxn/n7hAV1XoIpazYll5ETbays56AZ+AJGBJBoRPUotVsRCmeACsRiUQx636KRWbHnzvIavi6c/J95zvnzJ174R8BWDaozTdnMK1iNpzNbycV4x3U4qaysVALo76zNnbwknPddm+Lf61bK5snyeaibkan+Ecd55Hn1eKm8g12T9AD9NwgClNgtnE64uRXgAlDQhyb2eJWUjkPaYO7nm2cjpS8P8EYzOYFdw6qIZPgipz8CsYg0l4K5VLqhhEHBkMeloP6EAGYAEjNGrtJ5WZzc7TlS1EMYNLkjw0MCWAgda/rbKcPhY4xFPnI4hhj6jHy63MLZ3E7fbB+F6133O0oJA9PYLYouMOYdr591V/qu8RsCulW/nHpSwa1uKn8/bKVVM4dVAWHSPdI98C+5Ks7G+MXIX2h/+D5KE4X4X46QS/wu1eFUMuwcn6PRd+DZ1xlg9x7QB3p+nu9dop7rP4D/V/EE6UhikMKpx/oAAAAAElFTkSuQmCC"},9155:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAOxAAADsQBlSsOGwAAAGJJREFUOI1jYGBgOM3AwPAfCTMwMDA8QxPDhT8xoAlIM5AG/jMi2QoDjKQYwITEkSFRM9w2qrkA5oqBc8EIDYNHDAzkp0I4QE/fMDF5YvnoBsiTwscWBiQBJgYGhpMU6D8CAJDrOVecOVsbAAAAAElFTkSuQmCC"},9852:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAOxAAADsQBlSsOGwAAALdJREFUWIXtl0EKwkAMRZ+iR1LwCC5ceekKHsSqN3ARF5pFi41lmGQU8iDQkkB/0k/aATgCV0AmQjkbNaXRAdy+FCmdgwDBSGzwRQBZGgUrZwEALBiOearGAwGwJhDCJwFbXl1rhAsIefdKesASoF5oJiD3QAi5B9IDuQeaeyDU8SNOwEOVRP4LDvirPSAe9yXd7oB1rXzJBKrm50ygasdj5kzAlZ/4FtwbPr8HOLwvPE6+VlyA/ROEjYEpRhLQZgAAAABJRU5ErkJggg=="},6630:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAYAAABWdVznAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEwAACxMBAJqcGAAAAY1JREFUKJF9kL9PEwEcxd/3y+XaXrwKCZsx4uLQiQQRZHOUmYEU45mL1CCVpH+JwxEx6CB6HfixM7KQ8sM2TB2cHHRzMCTt2cbe+zrUSxsHP+PLey/v+xX8ZaXWKHgddxNAmcYSACjQNpW69jtv9vYe9QBAAKActu44TnpMwlXRyEQuhzW2IMAWgcSZ4OMPOw++yUqtUfC6TgvEl8QflI9eL/3CGJVK0+uB+4TencoV59TruJsk3MwcvLiaCZ635rLA7u79hIm7qqR/3bt+qQDKKhplzTROm6aNp+ufq1kojme7prpNsTWlsTTanKEuRKIn683DtVfnxeGxcqHUkuI/iBj/1RwF2gZbAHCWiST7KlL79G5+Z2TlQwBtNZW6AFuVStMDgHSAHxOwxY9j5jA89QGpQiSWIDjJpzm/qeBXJu5qHM92xyeE4an/W3MHgN2aLEzOCwA827i8PUj1WEnfVLcFcjGaIVUjfxJcrr9f/C5ZUxCc5M29sTF8nZaGqrUhEt/MF99G0b0+APwB15Gn8fy9beQAAAAASUVORK5CYII="},1133:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEwAACxMBAJqcGAAAA41JREFUSImNlU9oVFcUxn/ne28UxKWIRKiYpRaqZpIUagm6aZfiQlLNRBzyT+nGNmiLe2nUtkLBJhnRxolRoVBc1GXqIoqZTEoW6sZN/VNqTXdWsJl553YxkzSkM5N8m/feved837mP891jNMCx44XmJFEnsA/3nQ6bAEzMG3pMYNIU3Rgb2f1bPQ6rtdjV82A7Fp8j+EFJalSEu7vJfkzKOjVxpeXpqgKZ3kImBIYlbagSlGS6G2Aa+APAjCag3d07JKWqUm/M1T92OX29rkB338xpsK8AHN5aCN/E5eji1at75muedGBus8oLJx1OSloPEEIYzOdav/6fQKa3kDHTNYDg4YlH0YHrI3seN/o9/wkV3rVEt81oroocyedaJ5YEunoebAc9lLQheHgS4tTe8eFdr9ZCvoijJ6a3eCm6Z0Yz7n8HaWd+NP1MAFI8JGmDw1uPogMrybPZ2SYINRtiEWOX2l8G6SD4AtJGgyEAO3a80Fwq8USSQghn87nWMyuTM30zA0Y4UEJdN0bTfzUS6u4pXED63N3dPWpWkqhTkty9FJeji/VT9VHkYe5IT/HDRgK2LlwAEkmKY+8UsA9Aprv1umVJQrY1Er909xa/rPfLxi61vwSmANzDfuG+E6Da52tBhHE201O880lfcVPNiBAKlYK0Q4v2p2qitcJkH0ce5jJ9xb01dn+vPH1zw2tgNUgWVo0xMQ9L9l87AndCKtmVH01P1djcWqV/FRt6DJW7ZU3ETtktnBnPpc9D7RN4oF0G4I9EYBLA3Tu6BuY2N+QOPHfzjvFc67l65NnsbJNkH1TibVKm6Ia7u6SUygsn65EH959tXbJ7PNd2v1ERpTgMAhGQmNlNA8j0zdwy7JC7/0NMeny47eHypKMnpreMXWr7s17Vi8gMFHaHMtOSUrhPXLvcdkQASVmnwN9IWm+Jbh89Mb1leWLFPI3Js9nZJnN+kpRyeJ3gpwEEMHGl5am5+gHMaPZSdK+r/9f3GhGurLwcJ/dB2wAM671++f0Xlfdl6O4tDmKcr3z5As53ti5cqNq/ZtWlOAwG90+XJlsIn13LtX67GFNjZM4cthBGkDZWlxJgqmL/RYeGrR5or3ZLBODw2rDe/GjLreV8NS+sTF/xHYMhdz+02tAHEtxvKcUXP3zf9nzlZsMhcjg7uy2OvdM97Je0A7zqE70Cf+TBJs3sZn40/awex78erYTTwi3/3gAAAABJRU5ErkJggg=="},9884:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAMCAYAAAC0qUeeAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEwAACxMBAJqcGAAAALlJREFUKJFjZEACcWmn5zMwMCbA+P///ZuzeI5ZKozPaF+/n4WBgYFB7gmfKiPj30PfeP/Irem3+h5SeIyT4yvLQxZGFuv7Eh/vMzAwMDDGpJz6wcTExM5AEPz7BbX+zH98ymDyTMiCsamnq7HRMICimJGRsQUbjVUxIUAvxf8ZqrDSSCoY49JO/UtLO8OFzbSkpCO8cSlnfjMwMDCwMDAw/mdgOD3nBwPDp7i0MxiK/0BsmMbAwMAAACl8PxDSJvyvAAAAAElFTkSuQmCC"},2387:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAYCAYAAAD+vg1LAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEwAACxMBAJqcGAAAAW5JREFUSIntlbtKA2EQhc8/axIVrUQFBRsRRLCL+gIRQeuAxbpNLq2laGklpLYxVkkh2lip4AsIZkmZRiy0sPCCoEYwlxmLJLLZi+wmYpXTnRnmm/mHYVfBQ+uJq/EwhfJQHANItWdZAFxWQfrRQfTZrZ68wGEtlIHCshMKNGK0EhLsedW7FDWn1bR7ACGImsllF26teSNVmIaSG2ZUVEQm8/tLLw5wPH6iPc6NtjWYehjaVkrtQnCey0bX3JobKfMMCqsQ7NxNvGesubHSkygjaX6CMOD1pM7EZRJCBUD9L7ECqv0YI22KkTalU5i93vMqutX/g/XkdVlPm29+vV19nh2JBoN43xN3qx64B3bK847B/CFEdd/eLzh3uDgcxNvVXIVYPvTi+lf5Xc4ay465DAAbieJsUKyRKM43EPzaijVXoYSlcEoKutKkZKTNoBM3MXRsAwMRrm5+aeERMMeIKNC1MDMrogvur221Yt/I6IasMWr/dwAAAABJRU5ErkJggg=="},7590:t=>{"use strict";t.exports="data:image/gif;base64,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"},5784:t=>{"use strict";t.exports="data:image/png;base64,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"},7717:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFAAAABQCAMAAAC5zwKfAAAABlBMVEV9fX3///+Kct39AAAAAnRSTlP/AOW3MEoAAAA9SURBVFjD7dehDQAwDANBZ/+l2wmKoiqR7pHRcaeaCxAIBAL/g7k9JxAIBAKBQCAQCAQC14H+MhAIBE4CD3fOFvGVBzhZAAAAAElFTkSuQmCC"},3419:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAQCAYAAACcN8ZaAAAB3klEQVR42s3U4UdDURzG8czMXJnJ1Vwzc6VJZjaZJdlMlpQsKdmUFNOUspRSSqUolfQfr+fF98Vx5mwv9qbDx7LdznnO7/7Omej3+/+Ga0QMUYkhbvBgmhzCQxwxibIGrGEF8CQhU+LLtKQkQNqScUgjxRxTBIxbgfgD/BgnhM8kM5KTeclLQYqGkkMRBckzR8ic/mAgd5BAZplsUaqyIg2sDtHg2brUZJk5SmwopErJUWE8SpmTMhNvya60Zd/SNrR4bkeaskG4uiwRZk6yrJEYFibGAxn+scECHTmTnuVCzvmty3PHciB7bGKN6lQkzysPqIrHmpFhYbKUtckC1/Ioz4ZHuZdbuSLYiRxRpSZVWXZVxAzC0R4Ik5SQsu6w8yd5l2/5kg95I9SdXMoZQfYIUjeqEUrgOkXGPeN4TYRhxy8E+ZUf+eS7B7miIoeybVSjKDnm8u3+gH3pDTYwu1igATvs/pXqvBKiR4i2bNJfi1ZfUAnjgrOG8wY2quNzBKuU/ZS+uSFEl5O0xRGuUIlZCcw7xG5QPkeHYUSNV5WXGou2sC3rBC0LjenqCXGO0WEiTJa0Lr4KixdHBrDGuGGiRqCUpFk8pGIpQtCU7p4YPwxYxEMCk1aAMQZh8Ac8PfbIzYPJOwAAAABJRU5ErkJggg=="},7669:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEYAAAAgCAYAAACvgw7DAAAFhElEQVR42tWZ/0ubVxSHZZQxpJQRwoqEUkJQQhlBCcEiQRGJiKFEQqQ4lKFYLA5FsSjKioqipRutbLJ2f627g+dyDmfvqfetzlLh+aFpcr88+dxzb+7bdwt/33wG974g/rhu+pdzwt86fJdA/82w7Un/18m6kRBXgD+5+4YHDt/fEtImfRppVlJ+MY4QEWEmbyZZUBQVP2TwMJGBDMx7aFP6K4gwJBlBecVYISIDCSJAJm0mUIJH8NhQdqjkh8/SNv2VRB6SjCAtJ2dKMGuFIEIEMHGZ2CAMQdXwxPDjNdQ++f+0Q9tD9F1RkgYYLwlCDmIg19IhJQiRVJToFAlMViYxHBiBOjQyGP0ETzMw76Ed+qC/YSVrSAkqiRySo1IjAnwkKSKlQKMIQQYS4sQZ/Bg0A+MwYZg0TKViPjeh+mjS72iUhKCqyCE5pCZdDEmxUmjwURQSZSCiqSbXCkwHZmAW2g7PEmkbZml/mj6nlKgm42rE9DDushHzQGpNohjefB8pD2NK6GSEjscZ1AyD7QTmAt1AD+YVz/Mjn6e9LswB0pCEICVnhFQPIabEfAoiJj0xkhaWj5LSoNMW39ocA14I/BRYCvwMy58NbdDe4r9twwLCEIUcEoSYCbWkhqk1g0lLyTv92bTQUBkpdZWSDoNbZAKrgbXAy8B64JdE1jN4SVsvAquwokUhaJ70dNTyaiEmLqUaYiqUArZu0qLF+EdjOa/wwWKsK2r5tPiGFhjoGhPcCmwHdgKvEtlRbMNWYDOwQbtIEjlGDIlhKUmNqZOWKuOPW3bRSct1iUGMbM2PabxBp20GtMygt5jkfuAg8DpwaOF1y6+BA9iDXdpDEoKQQ79LLKv5mBZVX8ZZQiO66Nqt2jngISFNTJkoPqXjLoOKUvaY5HHgJHDmcAoncBw4UtIOkLtnxJAapEid6aqkTKliW2f5VOPysXUFjJQ0Mf1KTAXzTb6VeeK8wQQOmeibwNvA7xn8xv+95X3nyIqCDiU9iGFJUXPWkLKo6krbLJ2GpIQdiJoiy8dJyg3E1IjoDDvCCgPfZ3LnCHgf+MNwwevveE+UE1N0RGKilJ0MIUv021Vb86QIYefJJUSkXF1d4eS6rdoXM0uUV5nA6ygFCZeBDxpe+1MEkSBJzbESs6uWzwu+gEWzdFpIidtxzWzHck5h6fgpETHI8cWYGlOMW7VKzEKWGCb/V+Bj4G/4wGtRzDsSc07SjjKSsqaEPFdCpkWIpMQc9UmJCLEXVVaGFXPP4G/XUnybjpg3TPhSS4GPKjHvVVJOY10hJduxyKpa0gt01Nlk3JxkbXEt+j8OBREhpIgRORzw6LiqdqUexXeTb/qUFFzE1MAly4vaQkpYNrHAqh1nSS2Ztl0yJiFsvyYhbh0RHDH+UvJSw7cxqM4xc9SZdbUrnaniewEiRBJyoBKyniGk4y8ZOY+kLhn4z19+MYLcw8ghr0ZqppnEMpPbZUmcIOAMTA1hubDTILenziKT5nBmt92B9G1XhOQQk3iliRgGU+JbqzOBttqdNkUOp1451e5LUWXJSFHtaCHebxunqKZJ4d+3LEZ2JwZWYcCjLKlnTHCZFGwgIB7MYjFdUculJwczKaZquVT9c4gUVKeG9P3fYuS3VPaPyRrf7CQ7Ro/0yDWD+qHn7C5j5ug+aO9m7c2+FZLndv/2xPin4BLJqcZf2wiaMbdxs3KzJncjzlWjFFM5lJl0+A/I7lpMX+bdDHKIe1WlZ0zuddXVIjJMMsr21t6mI+8DsbsXQ2pEDqdhuf+tsHM8YfJgbujZZh0Z/W4xNX9fXoz/+8nKKdlnSYqKTYctplYIfC1i7KFPnhwwUXnMah+dioxCsgyEfD1iIPMxrVAQ0p8ZexLuWsw/8PFSG0HPbPgAAAAASUVORK5CYII="},6111:(t,e,i)=>{"use strict";t.exports=i.p+"e52214306ad12a5c837e.png"},2369:(t,e,i)=>{"use strict";t.exports=i.p+"1f2cc17911c8d4a3fa01.png"},6577:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADQAAAA0CAQAAABvcdNgAAAEsklEQVR4AWL4TydIhpZK1kpWOlg0w3ZXP6D2soBtG42jeI6ZmQTHzAxiTbSJsYLjO9HhP+WOmcuhciVnmHVQcJnp7DFvScowZorad/+V/fVzMdMT2g9Cv9guXGv/7pYOrXh2U+RRR3dSd9JRx6bIFc/ekqHI29JC6pJ5ZEh1yWkhkbcFeSjxgx3L2m1cb1C7bceyxA+CNjT/Ifff+/kDk2u/w/33/IeCMOSaWZ4glosqT3DNnNZQ7Cs58/3Ce5HL78iZH/vKVIaYlqzfdLu8Vi7dnvUbEza5Idt36tquZFldl6N5Z/POLof0XLK61mZCmJSWjVF9tEjUluu74IUXvgttuVIHE7YxSkaYhJZam7yiM9Pv82JYfl9nptxZaxMJE4YSPty+vF0+Y2up9d3wwijfjZbabqm/3bZ9ecKHsiGmRflnn1MW4pjHf9oLufyn2z3y1D6n8g8TZhxyzipLNPnAUpsOiuWimg52psrTZYnOWYNDTMuWBWa0tJb4rgq1UvmutpaYEbZlwU3CLJm/ayYjHW5/h7xWLn9Hh1vepDkyf7dE7MtT5LR4e7yYpHrkhOUpEfssBLq2pPhAqoSWKUkk7EDqkmK6RrCEzqDjhNDWNE+XSMvkJRDWlZTmCW0l0PHQGRZY5t1L83kT0Y3l2SItk5JAWHl2dCOBm+fPu3fo5/3v61RMCO9Jx2EEYYhb0rmNQMX/vm7gqOEJLcXTGw3CAuRNeyaPWwjR8PRqKQ1PDA/dpv+on9Shox52WFnx0KY8onHayrJzm87i5h9xGw/tfkev0jGsQizqezUKjk12hBMKJ4kbCqGPVNXudyyrShovGw5CgxsRICxF6aRmSjlBnHRzg7Gx8fKqEubI2rahQYdR1YgDIRQO7JvQyD52hoIQx0mxa0ODtW2Iozn1le2iIRdzwWewedyZzewidueOGqlsn1MvcnQpuVwLGG3/IR1hIKxCjelIDZ8ldqWz25jWAsnldEnK0Zxro19TGVb2ffIZEsIO89EIEDvKMPrzmBOQcKQ+rroye6NgRRxqR4U8EAkz0CL6uSGOm6KQCdWjvjRiSP1BPalCRS5iQYiEIvxuBMJEWgzSoHADcVMuN7IuqqTeyUPq22qFimFtxDyBBJEwNyt6TM88blFHao/6tWWhuuOM4SAK4EI4QmFHA+SEyWlp4EQoJ13cYGzMu7yszEIBOm2rVmHUNqwAIQabISNMRstmdhNWcFLsSm+0tjJH1MdRxO5Nx0WDMhCtgD6OKgZeljJqJKc9po8juskR9XN0Y1lZ3mWjLR9JCO1jRDMd0fpYC2VnvjBSEFg7wBENc0R9HFlb0xvF1+TBEpF68d+DHR6IOWVv2BECtxo46hOFUBd/APU57WIoEwJhIi2CdpyZX0m93BZicktMj1AS9dClteUFAUNUIEygRZCtik5zSxI9MubTBH1GOiHsiLJ3OCoSZkILa9PxiN0EbvhsAo8tdAf9Seepd36lGWHmtNANTv5Jd0z4QYyeo/UEJqxKRpg5LZx6btLPsOaEmdMyxYdlc8LMaJnikDlhclqmPiQnTEpLUIZEwkRagjYkEibQErwhkTAKCLQEbUgkzJQWc/0PstHHcfEdQ+UAAAAASUVORK5CYII="},4648:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABoAAAAaCAQAAAADQ4RFAAACf0lEQVR4AY1UM3gkARTePdvdoTxXKc+qTl3aU5U6b2Kbkz3Gtq3Zw6ziLGNPzrYx7946Tr6/ee/XeCQ4D3ykPtL5tHno4n0d/h3+xfuWHGLX81cn7r0iTNzjr7LrlxCqPtkbTQEHeqOrTy4Yyt3VCi/IOB0v7rVC7q45Q3Gr5K6jt+3Gl5nCoDD4MtO+j96Wu8atmhGqcNGHObuf8OM/x3AMx38+4Z2sPqzCxRFK2aF2e5Jol56XTLyggAMTL56XOMoS1W4pOyjUcGGQdZxU6qRh7B9Zp+PfpOFlqt0zyDZckPi1ttmIp03jX8gyJ8a/PG2yutpS/Vol7peZIbZcKBAEEheEIAgFbDkz5H6Zrkm2hVWGiXKiF4Ycw0RWKdtC16Q7qe3X4iOMxruonzegJzWaXFrU9utOSsLUmrc0YjeWYjCW4PDMADElpJSSQ0vQvA1Tm6/JlKnqFs1EGyZiFCqnRZTEJJJiKRYzVYzJck2Rm6P4iH+cmSY0YzimYa8l0EtTODFWhcMIMVqdsI2uiTvKmTisIDHJ3od5GILVhBCarCfVRmo4uTjkhrhzkiBV7SsaqS+TzrzM1qpGGUFt28pIySQHR6h7F6KSwGWm97ay+Z+ZqMcEjEWebE7wxCSQwpkhJqoZA5ivCdZDjJepuJ9IQjGGUmuXJdBFUygxVqVsxFsLMbDe8ZbDYVCGKxs+W080max1hFCarCfV+C1KATwcnvE9gRRuMP2prdbWGowm1KB1y+zwMMENkM755cJ2yPDtqhTI6ED1M/82yIDtC/4j4BijjeObflpO9I9MwXTCsSX8jWAFeHr05WoLTJ5G8IQVS/7vwR6ohirYM7f6HzYpogfS3R2OAAAAAElFTkSuQmCC"},8249:t=>{"use strict";t.exports="data:image/png;base64,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"},7024:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAApCAYAAADAk4LOAAAFgUlEQVR4Aa1XA5BjWRTN2oW17d3YaZtr2962HUzbDNpjszW24mRt28p47v7zq/bXZtrp/lWnXr337j3nPCe85NcypgSFdugCpW5YoDAMRaIMqRi6aKq5E3YqDQO3qAwjVWrD8Ncq/RBpykd8oZUb/kaJutow8r1aP9II0WmLKLIsJyv1w/kqw9Ch2MYdB++12Onxee/QMwvf4/Dk/Lfp/i4nxTXtOoQ4pW5Aj7wpici1A9erdAN2OH64x8OSP9j3Ft3b7aWkTg/Fm91siTra0f9on5sQr9INejH6CUUUpavjFNq1B+Oadhxmnfa8RfEmN8VNAsQhPqF55xHkMzz3jSmChWU6f7/XZKNH+9+hBLOHYozuKQPxyMPUKkrX/K0uWnfFaJGS1QPRtZsOPtr3NsW0uyh6NNCOkU3Yz+bXbT3I8G3xE5EXLXtCXbbqwCO9zPQYPRTZ5vIDXD7U+w7rFDEoUUf7ibHIR4y6bLVPXrz8JVZEql13trxwue/uDivd3fkWRbS6/IA2bID4uk0UpF1N8qLlbBlXs4Ee7HLTfV1j54APvODnSfOWBqtKVvjgLKzF5YdEk5ewRkGlK0i33Eofffc7HT56jD7/6U+qH3Cx7SBLNntH5YIPvODnyfIXZYRVDPqgHtLs5ABHD3YzLuespb7t79FY34DjMwrVrcTuwlT55YMPvOBnRrJ4VXTdNnYug5ucHLBjEpt30701A3Ts+HEa73u6dT3FNWwflY86eMHPk+Yu+i6pzUpRrW7SNDg5JHR4KapmM5Wv2E8Tfcb1HoqqHMHU+uWDD7zg54mz5/2BSnizi9T1Dg4QQXLToGNCkb6tb1NU+QAlGr1++eADrzhn/u8Q2YZhQVlZ5+CAOtqfbhmaUCS1ezNFVm2imDbPmPng5wmz+gwh+oHDce0eUtQ6OGDIyR0uUhUsoO3vfDmmgOezH0mZN59x7MBi++WDL1g/eEiU3avlidO671bkLfwbw5XV2P8Pzo0ydy4t2/0eu33xYSOMOD8hTf4CrBtGMSoXfPLchX+J0ruSePw3LZeK0juPJbYzrhkH0io7B3k164hiGvawhOKMLkrQLyVpZg8rHFW7E2uHOL888IBPlNZ1FPzstSJM694fWr6RwpvcJK60+0HCILTBzZLFNdtAzJaohze60T8qBzyh5ZuOg5e7uwQppofEmf2++DYvmySqGBuKaicF1blQjhuHdvCIMvp8whTTfZzI7RldpwtSzL+F1+wkdZ2TBOW2gIF88PBTzD/gpeREAMEbxnJcaJHNHrpzji0gQCS6hdkEeYt9DF/2qPcEC8RM28Hwmr3sdNyht00byAut2k3gufWNtgtOEOFGUwcXWNDbdNbpgBGxEvKkOQsxivJx33iow0Vw5S6SVTrpVq11ysA2Rp7gTfPfktc6zhtXBBC+adRLshf6sG2RfHPZ5EAc4sVZ83yCN00Fk/4kggu40ZTvIEm5g24qtU4KjBrx/BTTH8ifVASAG7gKrnWxJDcU7x8X6Ecczhm3o6YicvsLXWfh3Ch1W0k8x0nXF+0fFxgt4phz8QvypiwCCFKMqXCnqXExjq10beH+UUA7+nG6mdG/Pu0f3LgFcGrl2s0kNNjpmoJ9o4B29CMO8dMT4Q5ox8uitF6fqsrJOr8qnwNbRzv6hSnG5wP+64C7h9lp30hKNtKdWjtdkbuPA19nJ7Tz3zR/ibgARbhb4AlhavcBebmTHcFl2fvYEnW0ox9xMxKBS8btJ+KiEbq9zA4RthQXDhPa0T9TEe69gWupwc6uBUphquXgf+/FrIjweHQS4/pduMe5ERUMHUd9xv8ZR98CxkS4F2n3EUrUZ10EYNw7BWm9x1GiPssi3GgiGRDKWRYZfXlON+dfNbM+GgIwYdwAAAAASUVORK5CYII="},1071:t=>{"use strict";t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACkAAAApCAQAAAACach9AAACMUlEQVR4Ae3ShY7jQBAE0Aoz/f9/HTMzhg1zrdKUrJbdx+Kd2nD8VNudfsL/Th///dyQN2TH6f3y/BGpC379rV+S+qqetBOxImNQXL8JCAr2V4iMQXHGNJxeCfZXhSRBcQMfvkOWUdtfzlLgAENmZDcmo2TVmt8OSM2eXxBp3DjHSMFutqS7SbmemzBiR+xpKCNUIRkdkkYxhAkyGoBvyQFEJEefwSmmvBfJuJ6aKqKWnAkvGZOaZXTUgFqYULWNSHUckZuR1HIIimUExutRxwzOLROIG4vKmCKQt364mIlhSyzAf1m9lHZHJZrlAOMMztRRiKimp/rpdJDc9Awry5xTZCte7FHtuS8wJgeYGrex28xNTd086Dik7vUMscQOa8y4DoGtCCSkAKlNwpgNtphjrC6MIHUkR6YWxxs6Sc5xqn222mmCRFzIt8lEdKx+ikCtg91qS2WpwVfBelJCiQJwvzixfI9cxZQWgiSJelKnwBElKYtDOb2MFbhmUigbReQBV0Cg4+qMXSxXSyGUn4UbF8l+7qdSGnTC0XLCmahIgUHLhLOhpVCtw4CzYXvLQWQbJNmxoCsOKAxSgBJno75avolkRw8iIAFcsdc02e9iyCd8tHwmeSSoKTowIgvscSGZUOA7PuCN5b2BX9mQM7S0wYhMNU74zgsPBj3HU7wguAfnxxjFQGBE6pwN+GjME9zHY7zGp8wVxMShYX9NXvEWD3HbwJf4giO4CFIQxXScH1/TM+04kkBiAAAAAElFTkSuQmCC"},2055:t=>{"use strict";t.exports=e},1308:e=>{"use strict";e.exports=t}},r={};function o(t){var e=r[t];if(void 0!==e)return e.exports;var i=r[t]={id:t,exports:{}};return n[t].call(i.exports,i,i.exports,o),i.exports}o.amdO={},o.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return o.d(e,{a:e}),e},o.d=(t,e)=>{for(var i in e)o.o(e,i)&&!o.o(t,i)&&Object.defineProperty(t,i,{enumerable:!0,get:e[i]})},o.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(t){if("object"==typeof window)return window}}(),o.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),o.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},o.p="",o.nc=void 0;var s={};return(()=>{"use strict";var t=o(1308),e=new URL(t.uri,document.location);e.pathname=e.pathname.slice(0,e.pathname.lastIndexOf("/")+1),o.p=`${e.origin}${e.pathname}`})(),(()=>{"use strict";o.r(s),o.d(s,{LeafletAntPathModel:()=>nr,LeafletAntPathView:()=>rr,LeafletAttributionControlModel:()=>xo,LeafletAttributionControlView:()=>wo,LeafletAwesomeIconModel:()=>or,LeafletAwesomeIconView:()=>sr,LeafletCircleMarkerModel:()=>cr,LeafletCircleMarkerView:()=>ur,LeafletCircleModel:()=>dr,LeafletCircleView:()=>pr,LeafletControlModel:()=>vo,LeafletControlView:()=>bo,LeafletDivIconModel:()=>fr,LeafletDivIconView:()=>mr,LeafletDrawControlModel:()=>Lo,LeafletDrawControlView:()=>Mo,LeafletFeatureGroupModel:()=>yr,LeafletFeatureGroupView:()=>vr,LeafletFullScreenControlModel:()=>Ao,LeafletFullScreenControlView:()=>Po,LeafletGeoJSONModel:()=>br,LeafletGeoJSONView:()=>xr,LeafletGeomanDrawControlModel:()=>ko,LeafletGeomanDrawControlView:()=>Co,LeafletHeatmapModel:()=>Mr,LeafletHeatmapView:()=>kr,LeafletIconModel:()=>Cr,LeafletIconView:()=>Ar,LeafletImageOverlayModel:()=>Sr,LeafletImageOverlayView:()=>Er,LeafletImageServiceModel:()=>Tr,LeafletImageServiceView:()=>Dr,LeafletLayerGroupModel:()=>gr,LeafletLayerGroupView:()=>_r,LeafletLayerModel:()=>Jn,LeafletLayerView:()=>$n,LeafletLayersControlModel:()=>So,LeafletLayersControlView:()=>Eo,LeafletLegendControlModel:()=>Io,LeafletLegendControlView:()=>To,LeafletLocalTileLayerModel:()=>Hr,LeafletLocalTileLayerView:()=>Vr,LeafletMagnifyingGlassModel:()=>Zr,LeafletMagnifyingGlassView:()=>qr,LeafletMapModel:()=>Yo,LeafletMapStyleModel:()=>Ko,LeafletMapView:()=>Xo,LeafletMarkerClusterModel:()=>Xr,LeafletMarkerClusterView:()=>Jr,LeafletMarkerModel:()=>Kr,LeafletMarkerView:()=>Yr,LeafletMeasureControlModel:()=>Do,LeafletMeasureControlView:()=>zo,LeafletPMTilesLayerModel:()=>Qr,LeafletPMTilesLayerView:()=>$r,LeafletPathModel:()=>ar,LeafletPathView:()=>lr,LeafletPolygonModel:()=>io,LeafletPolygonView:()=>no,LeafletPolylineModel:()=>to,LeafletPolylineView:()=>eo,LeafletPopupModel:()=>oo,LeafletPopupView:()=>so,LeafletRasterLayerModel:()=>wr,LeafletRasterLayerView:()=>Lr,LeafletRectangleModel:()=>ao,LeafletRectangleView:()=>lo,LeafletScaleControlModel:()=>Bo,LeafletScaleControlView:()=>Oo,LeafletSearchControlModel:()=>Ro,LeafletSearchControlView:()=>jo,LeafletSplitMapControlModel:()=>No,LeafletSplitMapControlView:()=>Go,LeafletTileLayerModel:()=>Gr,LeafletTileLayerView:()=>Ur,LeafletUILayerModel:()=>Qn,LeafletUILayerView:()=>tr,LeafletVectorLayerModel:()=>er,LeafletVectorLayerView:()=>ir,LeafletVectorTileLayerModel:()=>ho,LeafletVectorTileLayerView:()=>co,LeafletVelocityModel:()=>uo,LeafletVelocityView:()=>po,LeafletVideoOverlayModel:()=>mo,LeafletVideoOverlayView:()=>go,LeafletWMSLayerModel:()=>_o,LeafletWMSLayerView:()=>yo,LeafletWidgetControlModel:()=>Ho,LeafletWidgetControlView:()=>Vo,LeafletZoomControlModel:()=>Zo,LeafletZoomControlView:()=>qo,version:()=>Qo});var t=o(9894),e=o(4067),i=o.n(e);function n(t,i){var n=e.DomUtil.create("div",t,document.body),r=function(t){var e=l(t,"background-image");return e&&"none"!==e?e:l(t,"cursor")}(n),o=function(t,e){for(var i,n=/url\(['"]?([^"']*?)['"]?\)/gi,r=[],o=n.exec(t);o;)r.push(e?(i=o[1]).substr(i.lastIndexOf("/")+1):o[1]),o=n.exec(t);return r}(r,i),s=a(n,"width"),h=a(n,"height"),c=a(n,"margin-left"),u=a(n,"margin-top");return n.parentNode.removeChild(n),{Url:o[0],RetinaUrl:o[1],Size:[s,h],Anchor:[-c,-u]}}function r(t){var i=e.DomUtil.create("div",t,document.body),n=a(i,"margin-left"),r=a(i,"margin-top");return i.parentNode.removeChild(i),{Anchor:[n,r]}}function a(t,e){return parseInt(l(t,e),10)}function l(t,i){return e.DomUtil.getStyle(t,i)||e.DomUtil.getStyle(t,i.replace(/-(\w)/g,(function(t,e){return e.toUpperCase()})))}e.Icon.Default.mergeOptions({iconUrl:null,iconRetinaUrl:null,shadowUrl:null,iconSize:null,iconAnchor:null,popupAnchor:null,tooltipAnchor:null,shadowSize:null,classNamePrefix:"leaflet-default-icon-"}),e.Icon.Default.include({_needsInit:!0,_getIconUrl:function(t){var i=this.options.imagePath||e.Icon.Default.imagePath||"";return this._needsInit&&this._initializeOptions(i),i+e.Icon.prototype._getIconUrl.call(this,t)},_initializeOptions:function(t){this._setOptions("icon",n,t),this._setOptions("shadow",n,t),this._setOptions("popup",r),this._setOptions("tooltip",r),this._needsInit=!1},_setOptions:function(t,e,i){var n=this.options,r=e(n.classNamePrefix+t,i);for(var o in r)n[t+o]=n[t+o]||r[o]}}),o(8487),o(4495),o(2986),o(4554),o(2874),o(4504),o(3416),o(5854),o(9266),o(5151),o(1626),o(248),o(2600);var h=Object.create,c=Object.defineProperty,u=Object.getOwnPropertyDescriptor,d=Object.getOwnPropertyNames,p=Object.getOwnPropertySymbols,f=Object.getPrototypeOf,m=Object.prototype.hasOwnProperty,g=Object.prototype.propertyIsEnumerable,_=Math.pow,y=(t,e,i)=>e in t?c(t,e,{enumerable:!0,configurable:!0,writable:!0,value:i}):t[e]=i,v=(t,e)=>function(){return e||(0,t[d(t)[0]])((e={exports:{}}).exports,e),e.exports},b=(t,e,i)=>(i=null!=t?h(f(t)):{},((t,e,i,n)=>{if(e&&"object"==typeof e||"function"==typeof e)for(let i of d(e))m.call(t,i)||undefined===i||c(t,i,{get:()=>e[i],enumerable:!(n=u(e,i))||n.enumerable});return t})(!e&&t&&t.__esModule?i:c(i,"default",{value:t,enumerable:!0}),t)),x=(t,e,i)=>new Promise(((n,r)=>{var o=t=>{try{a(i.next(t))}catch(t){r(t)}},s=t=>{try{a(i.throw(t))}catch(t){r(t)}},a=t=>t.done?n(t.value):Promise.resolve(t.value).then(o,s);a((i=i.apply(t,e)).next())})),w=v({"node_modules/@mapbox/point-geometry/index.js"(t,e){function i(t,e){this.x=t,this.y=e}e.exports=i,i.prototype={clone:function(){return new i(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,i=t.y-this.y;return e*e+i*i},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[0]*this.x+t[1]*this.y,i=t[2]*this.x+t[3]*this.y;return this.x=e,this.y=i,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),i=Math.sin(t),n=e*this.x-i*this.y,r=i*this.x+e*this.y;return this.x=n,this.y=r,this},_rotateAround:function(t,e){var i=Math.cos(t),n=Math.sin(t),r=e.x+i*(this.x-e.x)-n*(this.y-e.y),o=e.y+n*(this.x-e.x)+i*(this.y-e.y);return this.x=r,this.y=o,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},i.convert=function(t){return t instanceof i?t:Array.isArray(t)?new i(t[0],t[1]):t}}}),M=v({"node_modules/@mapbox/unitbezier/index.js"(t,e){function i(t,e,i,n){this.cx=3*t,this.bx=3*(i-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=n,this.p2x=i,this.p2y=n}e.exports=i,i.prototype.sampleCurveX=function(t){return((this.ax*t+this.bx)*t+this.cx)*t},i.prototype.sampleCurveY=function(t){return((this.ay*t+this.by)*t+this.cy)*t},i.prototype.sampleCurveDerivativeX=function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},i.prototype.solveCurveX=function(t,e){var i,n,r,o,s;for(void 0===e&&(e=1e-6),r=t,s=0;s<8;s++){if(o=this.sampleCurveX(r)-t,Math.abs(o)<e)return r;var a=this.sampleCurveDerivativeX(r);if(Math.abs(a)<1e-6)break;r-=o/a}if((r=t)<(i=0))return i;if(r>(n=1))return n;for(;i<n;){if(o=this.sampleCurveX(r),Math.abs(o-t)<e)return r;t>o?i=r:n=r,r=.5*(n-i)+i}return r},i.prototype.solve=function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}}}),k=v({"node_modules/tinyqueue/tinyqueue.js"(t,e){var i,n;i=t,n=function(){var t=function(t,i){if(void 0===t&&(t=[]),void 0===i&&(i=e),this.data=t,this.length=this.data.length,this.compare=i,this.length>0)for(var n=(this.length>>1)-1;n>=0;n--)this._down(n)};function e(t,e){return t<e?-1:t>e?1:0}return t.prototype.push=function(t){this.data.push(t),this.length++,this._up(this.length-1)},t.prototype.pop=function(){if(0!==this.length){var t=this.data[0],e=this.data.pop();return this.length--,this.length>0&&(this.data[0]=e,this._down(0)),t}},t.prototype.peek=function(){return this.data[0]},t.prototype._up=function(t){for(var e=this.data,i=this.compare,n=e[t];t>0;){var r=t-1>>1,o=e[r];if(i(n,o)>=0)break;e[t]=o,t=r}e[t]=n},t.prototype._down=function(t){for(var e=this.data,i=this.compare,n=this.length>>1,r=e[t];t<n;){var o=1+(t<<1),s=e[o],a=o+1;if(a<this.length&&i(e[a],s)<0&&(o=a,s=e[a]),i(s,r)>=0)break;e[t]=s,t=o}e[t]=r},t},"object"==typeof t&&void 0!==e?e.exports=n():"function"==typeof define&&o.amdO?define(n):(i=i||self).TinyQueue=n()}}),C=v({"node_modules/polylabel/polylabel.js"(t,e){var i=k();function n(t,e,n){var s,a,l,h;e=e||1;for(var c=0;c<t[0].length;c++){var u=t[0][c];(!c||u[0]<s)&&(s=u[0]),(!c||u[1]<a)&&(a=u[1]),(!c||u[0]>l)&&(l=u[0]),(!c||u[1]>h)&&(h=u[1])}var d=l-s,p=h-a,f=Math.min(d,p),m=f/2;if(0===f){var g=[s,a];return g.distance=0,g}for(var _=new i(void 0,r),y=s;y<l;y+=f)for(var v=a;v<h;v+=f)_.push(new o(y+m,v+m,m,t));var b=function(t){for(var e=0,i=0,n=0,r=t[0],s=0,a=r.length,l=a-1;s<a;l=s++){var h=r[s],c=r[l],u=h[0]*c[1]-c[0]*h[1];i+=(h[0]+c[0])*u,n+=(h[1]+c[1])*u,e+=3*u}return 0===e?new o(r[0][0],r[0][1],0,t):new o(i/e,n/e,0,t)}(t),x=new o(s+d/2,a+p/2,0,t);x.d>b.d&&(b=x);for(var w=_.length;_.length;){var L=_.pop();L.d>b.d&&(b=L,n&&console.log("found best %d after %d probes",Math.round(1e4*L.d)/1e4,w)),L.max-b.d<=e||(m=L.h/2,_.push(new o(L.x-m,L.y-m,m,t)),_.push(new o(L.x+m,L.y-m,m,t)),_.push(new o(L.x-m,L.y+m,m,t)),_.push(new o(L.x+m,L.y+m,m,t)),w+=4)}n&&(console.log("num probes: "+w),console.log("best distance: "+b.d));var M=[b.x,b.y];return M.distance=b.d,M}function r(t,e){return e.max-t.max}function o(t,e,i,n){this.x=t,this.y=e,this.h=i,this.d=function(t,e,i){for(var n=!1,r=1/0,o=0;o<i.length;o++)for(var a=i[o],l=0,h=a.length,c=h-1;l<h;c=l++){var u=a[l],d=a[c];u[1]>e!=d[1]>e&&t<(d[0]-u[0])*(e-u[1])/(d[1]-u[1])+u[0]&&(n=!n),r=Math.min(r,s(t,e,u,d))}return 0===r?0:(n?1:-1)*Math.sqrt(r)}(t,e,n),this.max=this.d+this.h*Math.SQRT2}function s(t,e,i,n){var r=i[0],o=i[1],s=n[0]-r,a=n[1]-o;if(0!==s||0!==a){var l=((t-r)*s+(e-o)*a)/(s*s+a*a);l>1?(r=n[0],o=n[1]):l>0&&(r+=s*l,o+=a*l)}return(s=t-r)*s+(a=e-o)*a}i.default&&(i=i.default),e.exports=n,e.exports.default=n}}),A=v({"node_modules/@mapbox/vector-tile/lib/vectortilefeature.js"(t,e){var i=w();function n(t,e,i,n,o){this.properties={},this.extent=i,this.type=0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=o,t.readFields(r,this,e)}function r(t,e,i){1==t?e.id=i.readVarint():2==t?function(t,e){for(var i=t.readVarint()+t.pos;t.pos<i;){var n=e._keys[t.readVarint()],r=e._values[t.readVarint()];e.properties[n]=r}}(i,e):3==t?e.type=i.readVarint():4==t&&(e._geometry=i.pos)}function o(t){for(var e,i,n=0,r=0,o=t.length,s=o-1;r<o;s=r++)e=t[r],n+=((i=t[s]).x-e.x)*(e.y+i.y);return n}e.exports=n,n.types=["Unknown","Point","LineString","Polygon"],n.prototype.loadGeometry=function(){var t=this._pbf;t.pos=this._geometry;for(var e,n=t.readVarint()+t.pos,r=1,o=0,s=0,a=0,l=[];t.pos<n;){if(o<=0){var h=t.readVarint();r=7&h,o=h>>3}if(o--,1===r||2===r)s+=t.readSVarint(),a+=t.readSVarint(),1===r&&(e&&l.push(e),e=[]),e.push(new i(s,a));else{if(7!==r)throw new Error("unknown command "+r);e&&e.push(e[0].clone())}}return e&&l.push(e),l},n.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,i=1,n=0,r=0,o=0,s=1/0,a=-1/0,l=1/0,h=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();i=7&c,n=c>>3}if(n--,1===i||2===i)(r+=t.readSVarint())<s&&(s=r),r>a&&(a=r),(o+=t.readSVarint())<l&&(l=o),o>h&&(h=o);else if(7!==i)throw new Error("unknown command "+i)}return[s,l,a,h]},n.prototype.toGeoJSON=function(t,e,i){var r,s,a=this.extent*Math.pow(2,i),l=this.extent*t,h=this.extent*e,c=this.loadGeometry(),u=n.types[this.type];function d(t){for(var e=0;e<t.length;e++){var i=t[e],n=180-360*(i.y+h)/a;t[e]=[360*(i.x+l)/a-180,360/Math.PI*Math.atan(Math.exp(n*Math.PI/180))-90]}}switch(this.type){case 1:var p=[];for(r=0;r<c.length;r++)p[r]=c[r][0];d(c=p);break;case 2:for(r=0;r<c.length;r++)d(c[r]);break;case 3:for(c=function(t){var e=t.length;if(e<=1)return[t];for(var i,n,r=[],s=0;s<e;s++){var a=o(t[s]);0!==a&&(void 0===n&&(n=a<0),n===a<0?(i&&r.push(i),i=[t[s]]):i.push(t[s]))}return i&&r.push(i),r}(c),r=0;r<c.length;r++)for(s=0;s<c[r].length;s++)d(c[r][s])}1===c.length?c=c[0]:u="Multi"+u;var f={type:"Feature",geometry:{type:u,coordinates:c},properties:this.properties};return"id"in this&&(f.id=this.id),f}}}),P=v({"node_modules/@mapbox/vector-tile/lib/vectortilelayer.js"(t,e){var i=A();function n(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(r,this,e),this.length=this._features.length}function r(t,e,i){15===t?e.version=i.readVarint():1===t?e.name=i.readString():5===t?e.extent=i.readVarint():2===t?e._features.push(i.pos):3===t?e._keys.push(i.readString()):4===t&&e._values.push(function(t){for(var e=null,i=t.readVarint()+t.pos;t.pos<i;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null}return e}(i))}e.exports=n,n.prototype.feature=function(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];var e=this._pbf.readVarint()+this._pbf.pos;return new i(this._pbf,e,this.extent,this._keys,this._values)}}}),S=v({"node_modules/@mapbox/vector-tile/lib/vectortile.js"(t,e){var i=P();function n(t,e,n){if(3===t){var r=new i(n,n.readVarint()+n.pos);r.length&&(e[r.name]=r)}}e.exports=function(t,e){this.layers=t.readFields(n,{},e)}}}),E=v({"node_modules/@mapbox/vector-tile/index.js"(t,e){e.exports.VectorTile=S(),e.exports.VectorTileFeature=A(),e.exports.VectorTileLayer=P()}}),I=v({"node_modules/ieee754/index.js"(t){t.read=function(t,e,i,n,r){var o,s,a=8*r-n-1,l=(1<<a)-1,h=l>>1,c=-7,u=i?r-1:0,d=i?-1:1,p=t[e+u];for(u+=d,o=p&(1<<-c)-1,p>>=-c,c+=a;c>0;o=256*o+t[e+u],u+=d,c-=8);for(s=o&(1<<-c)-1,o>>=-c,c+=n;c>0;s=256*s+t[e+u],u+=d,c-=8);if(0===o)o=1-h;else{if(o===l)return s?NaN:1/0*(p?-1:1);s+=Math.pow(2,n),o-=h}return(p?-1:1)*s*Math.pow(2,o-n)},t.write=function(t,e,i,n,r,o){var s,a,l,h=8*o-r-1,c=(1<<h)-1,u=c>>1,d=23===r?Math.pow(2,-24)-Math.pow(2,-77):0,p=n?0:o-1,f=n?1:-1,m=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(a=isNaN(e)?1:0,s=c):(s=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-s))<1&&(s--,l*=2),(e+=s+u>=1?d/l:d*Math.pow(2,1-u))*l>=2&&(s++,l/=2),s+u>=c?(a=0,s=c):s+u>=1?(a=(e*l-1)*Math.pow(2,r),s+=u):(a=e*Math.pow(2,u-1)*Math.pow(2,r),s=0));r>=8;t[i+p]=255&a,p+=f,a/=256,r-=8);for(s=s<<r|a,h+=r;h>0;t[i+p]=255&s,p+=f,s/=256,h-=8);t[i+p-f]|=128*m}}}),T=v({"node_modules/pbf/index.js"(t,e){e.exports=n;var i=I();function n(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length}n.Varint=0,n.Fixed64=1,n.Bytes=2,n.Fixed32=5;var r=4294967296,o=1/r,s="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function a(t){return t.type===n.Bytes?t.readVarint()+t.pos:t.pos+1}function l(t,e,i){return i?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function h(t,e,i){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));i.realloc(n);for(var r=i.pos-1;r>=t;r--)i.buf[r+n]=i.buf[r]}function c(t,e){for(var i=0;i<t.length;i++)e.writeVarint(t[i])}function u(t,e){for(var i=0;i<t.length;i++)e.writeSVarint(t[i])}function d(t,e){for(var i=0;i<t.length;i++)e.writeFloat(t[i])}function p(t,e){for(var i=0;i<t.length;i++)e.writeDouble(t[i])}function f(t,e){for(var i=0;i<t.length;i++)e.writeBoolean(t[i])}function m(t,e){for(var i=0;i<t.length;i++)e.writeFixed32(t[i])}function g(t,e){for(var i=0;i<t.length;i++)e.writeSFixed32(t[i])}function _(t,e){for(var i=0;i<t.length;i++)e.writeFixed64(t[i])}function y(t,e){for(var i=0;i<t.length;i++)e.writeSFixed64(t[i])}function v(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function b(t,e,i){t[i]=e,t[i+1]=e>>>8,t[i+2]=e>>>16,t[i+3]=e>>>24}function x(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}n.prototype={destroy:function(){this.buf=null},readFields:function(t,e,i){for(i=i||this.length;this.pos<i;){var n=this.readVarint(),r=n>>3,o=this.pos;this.type=7&n,t(r,e,this),this.pos===o&&this.skip(n)}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=v(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=x(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=v(this.buf,this.pos)+v(this.buf,this.pos+4)*r;return this.pos+=8,t},readSFixed64:function(){var t=v(this.buf,this.pos)+x(this.buf,this.pos+4)*r;return this.pos+=8,t},readFloat:function(){var t=i.read(this.buf,this.pos,!0,23,4);return this.pos+=4,t},readDouble:function(){var t=i.read(this.buf,this.pos,!0,52,8);return this.pos+=8,t},readVarint:function(t){var e,i,n=this.buf;return e=127&(i=n[this.pos++]),i<128?e:(e|=(127&(i=n[this.pos++]))<<7,i<128?e:(e|=(127&(i=n[this.pos++]))<<14,i<128?e:(e|=(127&(i=n[this.pos++]))<<21,i<128?e:function(t,e,i){var n,r,o=i.buf;if(n=(112&(r=o[i.pos++]))>>4,r<128)return l(t,n,e);if(n|=(127&(r=o[i.pos++]))<<3,r<128)return l(t,n,e);if(n|=(127&(r=o[i.pos++]))<<10,r<128)return l(t,n,e);if(n|=(127&(r=o[i.pos++]))<<17,r<128)return l(t,n,e);if(n|=(127&(r=o[i.pos++]))<<24,r<128)return l(t,n,e);if(n|=(1&(r=o[i.pos++]))<<31,r<128)return l(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(i=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&s?function(t,e,i){return s.decode(t.subarray(e,i))}(this.buf,e,t):function(t,e,i){for(var n="",r=e;r<i;){var o,s,a,l=t[r],h=null,c=l>239?4:l>223?3:l>191?2:1;if(r+c>i)break;1===c?l<128&&(h=l):2===c?128==(192&(o=t[r+1]))&&(h=(31&l)<<6|63&o)<=127&&(h=null):3===c?(o=t[r+1],s=t[r+2],128==(192&o)&&128==(192&s)&&((h=(15&l)<<12|(63&o)<<6|63&s)<=2047||h>=55296&&h<=57343)&&(h=null)):4===c&&(o=t[r+1],s=t[r+2],a=t[r+3],128==(192&o)&&128==(192&s)&&128==(192&a)&&((h=(15&l)<<18|(63&o)<<12|(63&s)<<6|63&a)<=65535||h>=1114112)&&(h=null)),null===h?(h=65533,c=1):h>65535&&(h-=65536,n+=String.fromCharCode(h>>>10&1023|55296),h=56320|1023&h),n+=String.fromCharCode(h),r+=c}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,e){if(this.type!==n.Bytes)return t.push(this.readVarint(e));var i=a(this);for(t=t||[];this.pos<i;)t.push(this.readVarint(e));return t},readPackedSVarint:function(t){if(this.type!==n.Bytes)return t.push(this.readSVarint());var e=a(this);for(t=t||[];this.pos<e;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==n.Bytes)return t.push(this.readBoolean());var e=a(this);for(t=t||[];this.pos<e;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==n.Bytes)return t.push(this.readFloat());var e=a(this);for(t=t||[];this.pos<e;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==n.Bytes)return t.push(this.readDouble());var e=a(this);for(t=t||[];this.pos<e;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==n.Bytes)return t.push(this.readFixed32());var e=a(this);for(t=t||[];this.pos<e;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==n.Bytes)return t.push(this.readSFixed32());var e=a(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==n.Bytes)return t.push(this.readFixed64());var e=a(this);for(t=t||[];this.pos<e;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==n.Bytes)return t.push(this.readSFixed64());var e=a(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed64());return t},skip:function(t){var e=7&t;if(e===n.Varint)for(;this.buf[this.pos++]>127;);else if(e===n.Bytes)this.pos=this.readVarint()+this.pos;else if(e===n.Fixed32)this.pos+=4;else{if(e!==n.Fixed64)throw new Error("Unimplemented type: "+e);this.pos+=8}},writeTag:function(t,e){this.writeVarint(t<<3|e)},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var i=new Uint8Array(e);i.set(this.buf),this.buf=i,this.length=e}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),b(this.buf,t,this.pos),this.pos+=4},writeSFixed32:function(t){this.realloc(4),b(this.buf,t,this.pos),this.pos+=4},writeFixed64:function(t){this.realloc(8),b(this.buf,-1&t,this.pos),b(this.buf,Math.floor(t*o),this.pos+4),this.pos+=8},writeSFixed64:function(t){this.realloc(8),b(this.buf,-1&t,this.pos),b(this.buf,Math.floor(t*o),this.pos+4),this.pos+=8},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var i,n;if(t>=0?(i=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(i=~(-t%4294967296))?i=i+1|0:(i=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,i){i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos]=127&t}(i,0,e),function(t,e){var i=(7&t)<<4;e.buf[e.pos++]|=i|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))))}(n,e)}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))))},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t)},writeBoolean:function(t){this.writeVarint(Boolean(t))},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,i){for(var n,r,o=0;o<e.length;o++){if((n=e.charCodeAt(o))>55295&&n<57344){if(!r){n>56319||o+1===e.length?(t[i++]=239,t[i++]=191,t[i++]=189):r=n;continue}if(n<56320){t[i++]=239,t[i++]=191,t[i++]=189,r=n;continue}n=r-55296<<10|n-56320|65536,r=null}else r&&(t[i++]=239,t[i++]=191,t[i++]=189,r=null);n<128?t[i++]=n:(n<2048?t[i++]=n>>6|192:(n<65536?t[i++]=n>>12|224:(t[i++]=n>>18|240,t[i++]=n>>12&63|128),t[i++]=n>>6&63|128),t[i++]=63&n|128)}return i}(this.buf,t,this.pos);var i=this.pos-e;i>=128&&h(e,i,this),this.pos=e-1,this.writeVarint(i),this.pos+=i},writeFloat:function(t){this.realloc(4),i.write(this.buf,t,this.pos,!0,23,4),this.pos+=4},writeDouble:function(t){this.realloc(8),i.write(this.buf,t,this.pos,!0,52,8),this.pos+=8},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var i=0;i<e;i++)this.buf[this.pos++]=t[i]},writeRawMessage:function(t,e){this.pos++;var i=this.pos;t(e,this);var n=this.pos-i;n>=128&&h(i,n,this),this.pos=i-1,this.writeVarint(n),this.pos+=n},writeMessage:function(t,e,i){this.writeTag(t,n.Bytes),this.writeRawMessage(e,i)},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,c,e)},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,u,e)},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,f,e)},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,d,e)},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,p,e)},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,m,e)},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,g,e)},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,_,e)},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,y,e)},writeBytesField:function(t,e){this.writeTag(t,n.Bytes),this.writeBytes(e)},writeFixed32Field:function(t,e){this.writeTag(t,n.Fixed32),this.writeFixed32(e)},writeSFixed32Field:function(t,e){this.writeTag(t,n.Fixed32),this.writeSFixed32(e)},writeFixed64Field:function(t,e){this.writeTag(t,n.Fixed64),this.writeFixed64(e)},writeSFixed64Field:function(t,e){this.writeTag(t,n.Fixed64),this.writeSFixed64(e)},writeVarintField:function(t,e){this.writeTag(t,n.Varint),this.writeVarint(e)},writeSVarintField:function(t,e){this.writeTag(t,n.Varint),this.writeSVarint(e)},writeStringField:function(t,e){this.writeTag(t,n.Bytes),this.writeString(e)},writeFloatField:function(t,e){this.writeTag(t,n.Fixed32),this.writeFloat(e)},writeDoubleField:function(t,e){this.writeTag(t,n.Fixed64),this.writeDouble(e)},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e))}}}}),D=v({"node_modules/rbush/rbush.min.js"(t,e){var i,n;i=t,n=function(){function t(t,n,r,o,s){!function t(i,n,r,o,s){for(;o>r;){if(o-r>600){var a=o-r+1,l=n-r+1,h=Math.log(a),c=.5*Math.exp(2*h/3),u=.5*Math.sqrt(h*c*(a-c)/a)*(l-a/2<0?-1:1);t(i,n,Math.max(r,Math.floor(n-l*c/a+u)),Math.min(o,Math.floor(n+(a-l)*c/a+u)),s)}var d=i[n],p=r,f=o;for(e(i,r,n),s(i[o],d)>0&&e(i,r,o);p<f;){for(e(i,p,f),p++,f--;s(i[p],d)<0;)p++;for(;s(i[f],d)>0;)f--}0===s(i[r],d)?e(i,r,f):e(i,++f,o),f<=n&&(r=f+1),n<=f&&(o=f-1)}}(t,n,r||0,o||t.length-1,s||i)}function e(t,e,i){var n=t[e];t[e]=t[i],t[i]=n}function i(t,e){return t<e?-1:t>e?1:0}var n=function(t){void 0===t&&(t=9),this._maxEntries=Math.max(4,t),this._minEntries=Math.max(2,Math.ceil(.4*this._maxEntries)),this.clear()};function r(t,e,i){if(!i)return e.indexOf(t);for(var n=0;n<e.length;n++)if(i(t,e[n]))return n;return-1}function o(t,e){s(t,0,t.children.length,e,t)}function s(t,e,i,n,r){r||(r=f(null)),r.minX=1/0,r.minY=1/0,r.maxX=-1/0,r.maxY=-1/0;for(var o=e;o<i;o++){var s=t.children[o];a(r,t.leaf?n(s):s)}return r}function a(t,e){return t.minX=Math.min(t.minX,e.minX),t.minY=Math.min(t.minY,e.minY),t.maxX=Math.max(t.maxX,e.maxX),t.maxY=Math.max(t.maxY,e.maxY),t}function l(t,e){return t.minX-e.minX}function h(t,e){return t.minY-e.minY}function c(t){return(t.maxX-t.minX)*(t.maxY-t.minY)}function u(t){return t.maxX-t.minX+(t.maxY-t.minY)}function d(t,e){return t.minX<=e.minX&&t.minY<=e.minY&&e.maxX<=t.maxX&&e.maxY<=t.maxY}function p(t,e){return e.minX<=t.maxX&&e.minY<=t.maxY&&e.maxX>=t.minX&&e.maxY>=t.minY}function f(t){return{children:t,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function m(e,i,n,r,o){for(var s=[i,n];s.length;)if(!((n=s.pop())-(i=s.pop())<=r)){var a=i+Math.ceil((n-i)/r/2)*r;t(e,a,i,n,o),s.push(i,a,a,n)}}return n.prototype.all=function(){return this._all(this.data,[])},n.prototype.search=function(t){var e=this.data,i=[];if(!p(t,e))return i;for(var n=this.toBBox,r=[];e;){for(var o=0;o<e.children.length;o++){var s=e.children[o],a=e.leaf?n(s):s;p(t,a)&&(e.leaf?i.push(s):d(t,a)?this._all(s,i):r.push(s))}e=r.pop()}return i},n.prototype.collides=function(t){var e=this.data;if(!p(t,e))return!1;for(var i=[];e;){for(var n=0;n<e.children.length;n++){var r=e.children[n],o=e.leaf?this.toBBox(r):r;if(p(t,o)){if(e.leaf||d(t,o))return!0;i.push(r)}}e=i.pop()}return!1},n.prototype.load=function(t){if(!t||!t.length)return this;if(t.length<this._minEntries){for(var e=0;e<t.length;e++)this.insert(t[e]);return this}var i=this._build(t.slice(),0,t.length-1,0);if(this.data.children.length)if(this.data.height===i.height)this._splitRoot(this.data,i);else{if(this.data.height<i.height){var n=this.data;this.data=i,i=n}this._insert(i,this.data.height-i.height-1,!0)}else this.data=i;return this},n.prototype.insert=function(t){return t&&this._insert(t,this.data.height-1),this},n.prototype.clear=function(){return this.data=f([]),this},n.prototype.remove=function(t,e){if(!t)return this;for(var i,n,o,s=this.data,a=this.toBBox(t),l=[],h=[];s||l.length;){if(s||(s=l.pop(),n=l[l.length-1],i=h.pop(),o=!0),s.leaf){var c=r(t,s.children,e);if(-1!==c)return s.children.splice(c,1),l.push(s),this._condense(l),this}o||s.leaf||!d(s,a)?n?(i++,s=n.children[i],o=!1):s=null:(l.push(s),h.push(i),i=0,n=s,s=s.children[0])}return this},n.prototype.toBBox=function(t){return t},n.prototype.compareMinX=function(t,e){return t.minX-e.minX},n.prototype.compareMinY=function(t,e){return t.minY-e.minY},n.prototype.toJSON=function(){return this.data},n.prototype.fromJSON=function(t){return this.data=t,this},n.prototype._all=function(t,e){for(var i=[];t;)t.leaf?e.push.apply(e,t.children):i.push.apply(i,t.children),t=i.pop();return e},n.prototype._build=function(t,e,i,n){var r,s=i-e+1,a=this._maxEntries;if(s<=a)return o(r=f(t.slice(e,i+1)),this.toBBox),r;n||(n=Math.ceil(Math.log(s)/Math.log(a)),a=Math.ceil(s/Math.pow(a,n-1))),(r=f([])).leaf=!1,r.height=n;var l=Math.ceil(s/a),h=l*Math.ceil(Math.sqrt(a));m(t,e,i,h,this.compareMinX);for(var c=e;c<=i;c+=h){var u=Math.min(c+h-1,i);m(t,c,u,l,this.compareMinY);for(var d=c;d<=u;d+=l){var p=Math.min(d+l-1,u);r.children.push(this._build(t,d,p,n-1))}}return o(r,this.toBBox),r},n.prototype._chooseSubtree=function(t,e,i,n){for(;n.push(e),!e.leaf&&n.length-1!==i;){for(var r=1/0,o=1/0,s=void 0,a=0;a<e.children.length;a++){var l=e.children[a],h=c(l),u=(d=t,p=l,(Math.max(p.maxX,d.maxX)-Math.min(p.minX,d.minX))*(Math.max(p.maxY,d.maxY)-Math.min(p.minY,d.minY))-h);u<o?(o=u,r=h<r?h:r,s=l):u===o&&h<r&&(r=h,s=l)}e=s||e.children[0]}var d,p;return e},n.prototype._insert=function(t,e,i){var n=i?t:this.toBBox(t),r=[],o=this._chooseSubtree(n,this.data,e,r);for(o.children.push(t),a(o,n);e>=0&&r[e].children.length>this._maxEntries;)this._split(r,e),e--;this._adjustParentBBoxes(n,r,e)},n.prototype._split=function(t,e){var i=t[e],n=i.children.length,r=this._minEntries;this._chooseSplitAxis(i,r,n);var s=this._chooseSplitIndex(i,r,n),a=f(i.children.splice(s,i.children.length-s));a.height=i.height,a.leaf=i.leaf,o(i,this.toBBox),o(a,this.toBBox),e?t[e-1].children.push(a):this._splitRoot(i,a)},n.prototype._splitRoot=function(t,e){this.data=f([t,e]),this.data.height=t.height+1,this.data.leaf=!1,o(this.data,this.toBBox)},n.prototype._chooseSplitIndex=function(t,e,i){for(var n,r,o,a,l,h,u,d=1/0,p=1/0,f=e;f<=i-e;f++){var m=s(t,0,f,this.toBBox),g=s(t,f,i,this.toBBox),_=(r=m,o=g,a=Math.max(r.minX,o.minX),l=Math.max(r.minY,o.minY),h=Math.min(r.maxX,o.maxX),u=Math.min(r.maxY,o.maxY),Math.max(0,h-a)*Math.max(0,u-l)),y=c(m)+c(g);_<d?(d=_,n=f,p=y<p?y:p):_===d&&y<p&&(p=y,n=f)}return n||i-e},n.prototype._chooseSplitAxis=function(t,e,i){var n=t.leaf?this.compareMinX:l,r=t.leaf?this.compareMinY:h;this._allDistMargin(t,e,i,n)<this._allDistMargin(t,e,i,r)&&t.children.sort(n)},n.prototype._allDistMargin=function(t,e,i,n){t.children.sort(n);for(var r=this.toBBox,o=s(t,0,e,r),l=s(t,i-e,i,r),h=u(o)+u(l),c=e;c<i-e;c++){var d=t.children[c];a(o,t.leaf?r(d):d),h+=u(o)}for(var p=i-e-1;p>=e;p--){var f=t.children[p];a(l,t.leaf?r(f):f),h+=u(l)}return h},n.prototype._adjustParentBBoxes=function(t,e,i){for(var n=i;n>=0;n--)a(e[n],t)},n.prototype._condense=function(t){for(var e=t.length-1,i=void 0;e>=0;e--)0===t[e].children.length?e>0?(i=t[e-1].children).splice(i.indexOf(t[e]),1):this.clear():o(t[e],this.toBBox)},n},"object"==typeof t&&void 0!==e?e.exports=n():"function"==typeof define&&o.amdO?define(n):(i=i||self).RBush=n()}}),z=(b(w()),{earth:"#151515",glacier:"#1c1c1c",residential:"#252B2F",hospital:"#3E2C2C",cemetery:"#36483D",school:"#2C3440",industrial:"#33312C",wood:"#3A3E38",grass:"#4E604D",park:"#2C4034",water:"#4D5B73",sand:"#777777",buildings:"#464545",highwayCasing:"#000000",majorRoadCasing:"#1C1B1B",mediumRoadCasing:"#3E3E3E",minorRoadCasing:"#000000",highway:"#5B5B5B",majorRoad:"#595959",mediumRoad:"#4F4F4F",minorRoad:"#393939",boundaries:"#666666",mask:"#dddddd",countryLabel:"#ffffff",cityLabel:"#FFFFFF",stateLabel:"#ffffff",neighbourhoodLabel:"#FDFDFD",landuseLabel:"#DDDDDD",waterLabel:"#707E95",naturalLabel:"#4c4c4c",roadsLabel:"#C4C4C4",poisLabel:"#959393"}),B={earth:"#FFFBF6",glacier:"#ffffff",residential:"#F4F4F8",hospital:"#FFF6F6",cemetery:"#EFF2EE",school:"#F7F6FF",industrial:"#FFF9EF",wood:"#F4F9EF",grass:"#EBF9E3",park:"#E5F9D5",water:"#B7DFF2",sand:"#ebebeb",buildings:"#F2EDE8",highwayCasing:"#FFC3C3",majorRoadCasing:"#FFB9B9",mediumRoadCasing:"#FFCE8E",minorRoadCasing:"#cccccc",highway:"#FFCEBB",majorRoad:"#FFE4B3",mediumRoad:"#FFF2C8",minorRoad:"#ffffff",boundaries:"#9e9e9e",mask:"#dddddd",countryLabel:"#aaaaaa",cityLabel:"#6C6C6C",stateLabel:"#999999",neighbourhoodLabel:"#888888",landuseLabel:"#898989",waterLabel:"#41ABDC",naturalLabel:"#4B8F14",roadsLabel:"#888888",poisLabel:"#606060"};function O(t,e,i){return Math.min(Math.max(t,i),e)}var R=class extends Error{constructor(t){super(`Failed to parse color: "${t}"`)}},j=t=>parseInt(t.replace(/_/g,""),36),N="1q29ehhb 1n09sgk7 1kl1ekf_ _yl4zsno 16z9eiv3 1p29lhp8 _bd9zg04 17u0____ _iw9zhe5 _to73___ _r45e31e _7l6g016 _jh8ouiv _zn3qba8 1jy4zshs 11u87k0u 1ro9yvyo 1aj3xael 1gz9zjz0 _3w8l4xo 1bf1ekf_ _ke3v___ _4rrkb__ 13j776yz _646mbhl _nrjr4__ _le6mbhl 1n37ehkb _m75f91n _qj3bzfz 1939yygw 11i5z6x8 _1k5f8xs 1509441m 15t5lwgf _ae2th1n _tg1ugcv 1lp1ugcv 16e14up_ _h55rw7n _ny9yavn _7a11xb_ 1ih442g9 _pv442g9 1mv16xof 14e6y7tu 1oo9zkds 17d1cisi _4v9y70f _y98m8kc 1019pq0v 12o9zda8 _348j4f4 1et50i2o _8epa8__ _ts6senj 1o350i2o 1mi9eiuo 1259yrp0 1ln80gnw _632xcoy 1cn9zldc _f29edu4 1n490c8q _9f9ziet 1b94vk74 _m49zkct 1kz6s73a 1eu9dtog _q58s1rz 1dy9sjiq __u89jo3 _aj5nkwg _ld89jo3 13h9z6wx _qa9z2ii _l119xgq _bs5arju 1hj4nwk9 1qt4nwk9 1ge6wau6 14j9zlcw 11p1edc_ _ms1zcxe _439shk6 _jt9y70f _754zsow 1la40eju _oq5p___ _x279qkz 1fa5r3rv _yd2d9ip _424tcku _8y1di2_ _zi2uabw _yy7rn9h 12yz980_ __39ljp6 1b59zg0x _n39zfzp 1fy9zest _b33k___ _hp9wq92 1il50hz4 _io472ub _lj9z3eo 19z9ykg0 _8t8iu3a 12b9bl4a 1ak5yw0o _896v4ku _tb8k8lv _s59zi6t _c09ze0p 1lg80oqn 1id9z8wb _238nba5 1kq6wgdi _154zssg _tn3zk49 _da9y6tc 1sg7cv4f _r12jvtt 1gq5fmkz 1cs9rvci _lp9jn1c _xw1tdnb 13f9zje6 16f6973h _vo7ir40 _bt5arjf _rc45e4t _hr4e100 10v4e100 _hc9zke2 _w91egv_ _sj2r1kk 13c87yx8 _vqpds__ _ni8ggk8 _tj9yqfb 1ia2j4r4 _7x9b10u 1fc9ld4j 1eq9zldr _5j9lhpx _ez9zl6o _md61fzm".split(" ").reduce(((t,e)=>{const i=j(e.substring(0,3)),n=j(e.substring(3)).toString(16);let r="";for(let t=0;t<6-n.length;t++)r+="0";return t[i]=`${r}${n}`,t}),{}),F=(t,e)=>Array.from(Array(e)).map((()=>t)).join(""),G=new RegExp(`^#${F("([a-f0-9])",3)}([a-f0-9])?$`,"i"),U=new RegExp(`^#${F("([a-f0-9]{2})",3)}([a-f0-9]{2})?$`,"i"),H=new RegExp(`^rgba?\\(\\s*(\\d+)\\s*${F(",\\s*(\\d+)\\s*",2)}(?:,\\s*([\\d.]+))?\\s*\\)$`,"i"),V=/^hsla?\(\s*([\d.]+)\s*,\s*([\d.]+)%\s*,\s*([\d.]+)%(?:\s*,\s*([\d.]+))?\s*\)$/i,Z=/^[a-z]+$/i,q=t=>Math.round(255*t),W=(t,e,i)=>{let n=i/100;if(0===e)return[n,n,n].map(q);const r=(t%360+360)%360/60,o=(1-Math.abs(2*n-1))*(e/100),s=o*(1-Math.abs(r%2-1));let a=0,l=0,h=0;r>=0&&r<1?(a=o,l=s):r>=1&&r<2?(a=s,l=o):r>=2&&r<3?(l=o,h=s):r>=3&&r<4?(l=s,h=o):r>=4&&r<5?(a=s,h=o):r>=5&&r<6&&(a=o,h=s);const c=n-o/2;return[a+c,l+c,h+c].map(q)};function K(t){const[e,i,n,r]=function(t){if("string"!=typeof t)throw new R(t);if("transparent"===t.trim().toLowerCase())return[0,0,0,0];let e=t.trim();e=Z.test(t)?function(t){const e=t.toLowerCase().trim(),i=N[function(t){let e=5381,i=t.length;for(;i;)e=33*e^t.charCodeAt(--i);return(e>>>0)%2341}(e)];if(!i)throw new R(t);return`#${i}`}(t):t;const i=G.exec(e);if(i){const t=Array.from(i).slice(1);return[...t.slice(0,3).map((t=>parseInt(F(t,2),16))),parseInt(F(t[3]||"f",2),16)/255]}const n=U.exec(e);if(n){const t=Array.from(n).slice(1);return[...t.slice(0,3).map((t=>parseInt(t,16))),parseInt(t[3]||"ff",16)/255]}const r=H.exec(e);if(r){const t=Array.from(r).slice(1);return[...t.slice(0,3).map((t=>parseInt(t,10))),parseFloat(t[3]||"1")]}const o=V.exec(e);if(o){const[e,i,n,r]=Array.from(o).slice(1).map(parseFloat);if(O(0,100,i)!==i)throw new R(t);if(O(0,100,n)!==n)throw new R(t);return[...W(e,i,n),r||1]}throw new R(t)}(t).map(((t,e)=>3===e?t:t/255)),o=Math.max(e,i,n),s=Math.min(e,i,n),a=(o+s)/2;if(o===s)return[0,0,a,r];const l=o-s;return[60*(e===o?(i-n)/l+(i<n?6:0):i===o?(n-e)/l+2:(e-i)/l+4),a>.5?l/(2-o-s):l/(o+s),a,r]}function Y(t,e,i,n){return`hsla(${(t%360).toFixed()}, ${O(0,100,100*e).toFixed()}%, ${O(0,100,100*i).toFixed()}%, ${parseFloat(O(0,1,n).toFixed(3))})`}var X=b(w()),J=(b(M()),b(C())),Q=class{constructor(t,e){this.str=null!=t?t:e,this.per_feature="function"==typeof this.str&&2===this.str.length}get(t,e){return"function"==typeof this.str?this.str(t,e):this.str}},$=class{constructor(t,e=1){this.value=null!=t?t:e,this.per_feature="function"==typeof this.value&&2===this.value.length}get(t,e){return"function"==typeof this.value?this.value(t,e):this.value}},tt=class{constructor(t){var e;this.label_props=null!=(e=null==t?void 0:t.label_props)?e:["name"],this.textTransform=null==t?void 0:t.textTransform}get(t,e){let i,n,r;n="function"==typeof this.label_props?this.label_props(t,e):this.label_props;for(const t of n)if(e.props.hasOwnProperty(t)&&"string"==typeof e.props[t]){i=e.props[t];break}if(r="function"==typeof this.textTransform?this.textTransform(t,e):this.textTransform,i&&"uppercase"===r)i=i.toUpperCase();else if(i&&"lowercase"===r)i=i.toLowerCase();else if(i&&"capitalize"===r){const t=i.toLowerCase().split(" ");i=t.map((t=>t[0].toUpperCase()+t.slice(1))).join(" ")}return i}},et=class{constructor(t){var e,i;(null==t?void 0:t.font)?this.font=t.font:(this.family=null!=(e=null==t?void 0:t.fontFamily)?e:"sans-serif",this.size=null!=(i=null==t?void 0:t.fontSize)?i:12,this.weight=null==t?void 0:t.fontWeight,this.style=null==t?void 0:t.fontStyle)}get(t,e){if(this.font)return"function"==typeof this.font?this.font(t,e):this.font;let i="";this.style&&(i="function"==typeof this.style?`${this.style(t,e)} `:`${this.style} `);let n,r,o="";return this.weight&&(o="function"==typeof this.weight?`${this.weight(t,e)} `:`${this.weight} `),n="function"==typeof this.size?this.size(t,e):this.size,r="function"==typeof this.family?this.family(t,e):this.family,`${i}${o}${n}px ${r}`}},it=class{constructor(t,e=[]){this.value=null!=t?t:e,this.per_feature="function"==typeof this.value&&2===this.value.length}get(t,e){return"function"==typeof this.value?this.value(t,e):this.value}},nt=b(w()),rt=(t,e,i)=>{const n=[];let r,o,s,a=0,l=0,h=0,c=0,u=0,d=0,p=0,f=0,m=0,g=0,y=0,v=0;if(t.length<2)return[];if(2===t.length)return h=Math.sqrt(_(t[1].x-t[0].x,2)+_(t[1].y-t[0].y,2)),[{length:h,beginIndex:0,beginDistance:0,endIndex:2,endDistance:h}];for(c=Math.sqrt(_(t[1].x-t[0].x,2)+_(t[1].y-t[0].y,2)),a=1,l=t.length-1;a<l;a++)r=t[a-1],o=t[a],s=t[a+1],d=o.x-r.x,p=o.y-r.y,f=s.x-o.x,m=s.y-o.y,u=Math.sqrt(f*f+m*m),h+=c,g=Math.acos((d*f+p*m)/(c*u)),(g>e||h-v>i)&&(n.push({length:h-v,beginDistance:v,beginIndex:y,endIndex:a+1,endDistance:h}),y=a,v=h),c=u;return a-y>0&&n.push({length:h-v+u,beginIndex:y,beginDistance:v,endIndex:a+1,endDistance:h+u}),n};function ot(t,e,i,n){const r=e.x-t.x,o=e.y-t.y,s=Math.sqrt(_(e.x-t.x,2)+_(e.y-t.y,2)),a=[];for(let e=0;e<i+n;e+=2*n){const i=1*e/s;a.push({x:t.x+i*r,y:t.y+i*o})}return a}function st(t,e){if(t.length<=e)return[t];const i=e-1,n=t.lastIndexOf(" ",i),r=t.indexOf(" ",i);if(-1===n&&-1===r)return[t];let o,s;return-1===r||n>=0&&i-n<r-i?(o=t.substring(0,n),s=t.substring(n+1,t.length)):(o=t.substring(0,r),s=t.substring(r+1,t.length)),[o,...st(s,e)]}new RegExp("^[々-〇〡-〩〱-〵〸-〼㈠-㈩㉈-㉏㉑-㉟㊀-㊉㊱-㊿㐀-䶵一-鿪豈-舘並-龎 ]+$");var at=b(w()),lt=b(E()),ht=b(T()),ct=(t,e,i)=>new Promise(((n,r)=>{var o=t=>{try{a(i.next(t))}catch(t){r(t)}},s=t=>{try{a(i.throw(t))}catch(t){r(t)}},a=t=>t.done?n(t.value):Promise.resolve(t.value).then(o,s);a((i=i.apply(t,e)).next())})),ut=Uint8Array,dt=Uint16Array,pt=Uint32Array,ft=new ut([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0]),mt=new ut([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,0,0]),gt=new ut([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),_t=function(t,e){for(var i=new dt(31),n=0;n<31;++n)i[n]=e+=1<<t[n-1];var r=new pt(i[30]);for(n=1;n<30;++n)for(var o=i[n];o<i[n+1];++o)r[o]=o-i[n]<<5|n;return[i,r]},yt=_t(ft,2),vt=yt[0],bt=yt[1];vt[28]=258,bt[258]=28;var xt,wt=_t(mt,0),Lt=wt[0],Mt=(wt[1],new dt(32768));for(At=0;At<32768;++At)xt=(61680&(xt=(52428&(xt=(43690&At)>>>1|(21845&At)<<1))>>>2|(13107&xt)<<2))>>>4|(3855&xt)<<4,Mt[At]=((65280&xt)>>>8|(255&xt)<<8)>>>1;var kt=function(t,e,i){for(var n=t.length,r=0,o=new dt(e);r<n;++r)t[r]&&++o[t[r]-1];var s,a=new dt(e);for(r=0;r<e;++r)a[r]=a[r-1]+o[r-1]<<1;if(i){s=new dt(1<<e);var l=15-e;for(r=0;r<n;++r)if(t[r])for(var h=r<<4|t[r],c=e-t[r],u=a[t[r]-1]++<<c,d=u|(1<<c)-1;u<=d;++u)s[Mt[u]>>>l]=h}else for(s=new dt(n),r=0;r<n;++r)t[r]&&(s[r]=Mt[a[t[r]-1]++]>>>15-t[r]);return s},Ct=new ut(288);for(At=0;At<144;++At)Ct[At]=8;for(At=144;At<256;++At)Ct[At]=9;for(At=256;At<280;++At)Ct[At]=7;for(At=280;At<288;++At)Ct[At]=8;var At,Pt=new ut(32);for(At=0;At<32;++At)Pt[At]=5;var St=kt(Ct,9,1),Et=kt(Pt,5,1),It=function(t){for(var e=t[0],i=1;i<t.length;++i)t[i]>e&&(e=t[i]);return e},Tt=function(t,e,i){var n=e/8|0;return(t[n]|t[n+1]<<8)>>(7&e)&i},Dt=function(t,e){var i=e/8|0;return(t[i]|t[i+1]<<8|t[i+2]<<16)>>(7&e)},zt=["unexpected EOF","invalid block type","invalid length/literal","invalid distance","stream finished","no stream handler",,"no callback","invalid UTF-8 data","extra field too long","date not in range 1980-2099","filename too long","stream finishing","invalid zip data"],Bt=function(t,e,i){var n=new Error(e||zt[t]);if(n.code=t,Error.captureStackTrace&&Error.captureStackTrace(n,Bt),!i)throw n;return n},Ot=function(t,e,i){var n=t.length;if(!n||i&&i.f&&!i.l)return e||new ut(0);var r=!e||i,o=!i||i.i;i||(i={}),e||(e=new ut(3*n));var s=function(t){var i=e.length;if(t>i){var n=new ut(Math.max(2*i,t));n.set(e),e=n}},a=i.f||0,l=i.p||0,h=i.b||0,c=i.l,u=i.d,d=i.m,p=i.n,f=8*n;do{if(!c){a=Tt(t,l,1);var m=Tt(t,l+1,3);if(l+=3,!m){var g=t[(A=4+((l+7)/8|0))-4]|t[A-3]<<8,_=A+g;if(_>n){o&&Bt(0);break}r&&s(h+g),e.set(t.subarray(A,_),h),i.b=h+=g,i.p=l=8*_,i.f=a;continue}if(1==m)c=St,u=Et,d=9,p=5;else if(2==m){var y=Tt(t,l,31)+257,v=Tt(t,l+10,15)+4,b=y+Tt(t,l+5,31)+1;l+=14;for(var x=new ut(b),w=new ut(19),L=0;L<v;++L)w[gt[L]]=Tt(t,l+3*L,7);l+=3*v;var M=It(w),k=(1<<M)-1,C=kt(w,M,1);for(L=0;L<b;){var A,P=C[Tt(t,l,k)];if(l+=15&P,(A=P>>>4)<16)x[L++]=A;else{var S=0,E=0;for(16==A?(E=3+Tt(t,l,3),l+=2,S=x[L-1]):17==A?(E=3+Tt(t,l,7),l+=3):18==A&&(E=11+Tt(t,l,127),l+=7);E--;)x[L++]=S}}var I=x.subarray(0,y),T=x.subarray(y);d=It(I),p=It(T),c=kt(I,d,1),u=kt(T,p,1)}else Bt(1);if(l>f){o&&Bt(0);break}}r&&s(h+131072);for(var D=(1<<d)-1,z=(1<<p)-1,B=l;;B=l){var O=(S=c[Dt(t,l)&D])>>>4;if((l+=15&S)>f){o&&Bt(0);break}if(S||Bt(2),O<256)e[h++]=O;else{if(256==O){B=l,c=null;break}var R=O-254;if(O>264){var j=ft[L=O-257];R=Tt(t,l,(1<<j)-1)+vt[L],l+=j}var N=u[Dt(t,l)&z],F=N>>>4;if(N||Bt(3),l+=15&N,T=Lt[F],F>3&&(j=mt[F],T+=Dt(t,l)&(1<<j)-1,l+=j),l>f){o&&Bt(0);break}r&&s(h+131072);for(var G=h+R;h<G;h+=4)e[h]=e[h-T],e[h+1]=e[h+1-T],e[h+2]=e[h+2-T],e[h+3]=e[h+3-T];h=G}}i.l=c,i.p=B,i.b=h,i.f=a,c&&(a=1,i.m=d,i.d=u,i.n=p)}while(!a);return h==e.length?e:function(t,e,i){(null==e||e<0)&&(e=0),(null==i||i>t.length)&&(i=t.length);var n=new(2==t.BYTES_PER_ELEMENT?dt:4==t.BYTES_PER_ELEMENT?pt:ut)(i-e);return n.set(t.subarray(e,i)),n}(e,0,h)},Rt=new ut(0),jt=function(t){31==t[0]&&139==t[1]&&8==t[2]||Bt(6,"invalid gzip data");var e=t[3],i=10;4&e&&(i+=t[10]|2+(t[11]<<8));for(var n=(e>>3&1)+(e>>4&1);n>0;n-=!t[i++]);return i+(2&e)},Nt=function(t){var e=t.length;return(t[e-4]|t[e-3]<<8|t[e-2]<<16|t[e-1]<<24)>>>0},Ft=function(t){(8!=(15&t[0])||t[0]>>>4>7||(t[0]<<8|t[1])%31)&&Bt(6,"invalid zlib data"),32&t[1]&&Bt(6,"invalid zlib data: preset dictionaries not supported")};function Gt(t,e){return 31==t[0]&&139==t[1]&&8==t[2]?function(t,e){return Ot(t.subarray(jt(t),-8),e||new ut(Nt(t)))}(t,e):8!=(15&t[0])||t[0]>>4>7||(t[0]<<8|t[1])%31?function(t,e){return Ot(t,e)}(t,e):function(t,e){return Ot((Ft(t),t.subarray(2,-4)),e)}(t,e)}var Ut="undefined"!=typeof TextDecoder&&new TextDecoder;try{Ut.decode(Rt,{stream:!0})}catch(t){}var Ht=(t,e)=>t*Math.pow(2,e),Vt=(t,e)=>Math.floor(t/Math.pow(2,e)),Zt=(t,e)=>Ht(t.getUint16(e+1,!0),8)+t.getUint8(e),qt=(t,e)=>Ht(t.getUint32(e+2,!0),16)+t.getUint16(e,!0),Wt=(t,e,i,n,r)=>{if(t!=n.getUint8(r))return t-n.getUint8(r);const o=Zt(n,r+1);if(e!=o)return e-o;const s=Zt(n,r+4);return i!=s?i-s:0},Kt=(t,e,i,n)=>{const r=Yt(t,e,i,n);return r?{z:e,x:i,y:n,offset:r[0],length:r[1],is_dir:!1}:null},Yt=(t,e,i,n)=>{let r=0,o=t.byteLength/17-1;for(;r<=o;){const s=o+r>>1,a=Wt(e,i,n,t,17*s);if(a>0)r=s+1;else{if(!(a<0))return[qt(t,17*s+7),t.getUint32(17*s+13,!0)];o=s-1}}return null},Xt=(t,e)=>t.is_dir&&!e.is_dir?1:!t.is_dir&&e.is_dir?-1:t.z!==e.z?t.z-e.z:t.x!==e.x?t.x-e.x:t.y-e.y,Jt=(t,e)=>{const i=t.getUint8(17*e);return{z:127&i,x:Zt(t,17*e+1),y:Zt(t,17*e+4),offset:qt(t,17*e+7),length:t.getUint32(17*e+13,!0),is_dir:i>>7==1}},Qt=t=>{const e=[],i=new DataView(t);for(let t=0;t<i.byteLength/17;t++)e.push(Jt(i,t));return $t(e)},$t=t=>{t.sort(Xt);const e=new ArrayBuffer(17*t.length),i=new Uint8Array(e);for(let e=0;e<t.length;e++){const n=t[e];let r=n.z;n.is_dir&&(r|=128),i[17*e]=r,i[17*e+1]=255&n.x,i[17*e+2]=n.x>>8&255,i[17*e+3]=n.x>>16&255,i[17*e+4]=255&n.y,i[17*e+5]=n.y>>8&255,i[17*e+6]=n.y>>16&255,i[17*e+7]=255&n.offset,i[17*e+8]=255&Vt(n.offset,8),i[17*e+9]=255&Vt(n.offset,16),i[17*e+10]=255&Vt(n.offset,24),i[17*e+11]=255&Vt(n.offset,32),i[17*e+12]=255&Vt(n.offset,48),i[17*e+13]=255&n.length,i[17*e+14]=n.length>>8&255,i[17*e+15]=n.length>>16&255,i[17*e+16]=n.length>>24&255}return e},te={getHeader:function(t){return ct(this,null,(function*(){const e=yield t.getBytes(0,512e3),i=new DataView(e.data),n=i.getUint32(4,!0),r=i.getUint16(8,!0),o=new TextDecoder("utf-8"),s=JSON.parse(o.decode(new DataView(e.data,10,n)));let a=0;"gzip"===s.compression&&(a=2);let l=0;"minzoom"in s&&(l=+s.minzoom);let h=0;"maxzoom"in s&&(h=+s.maxzoom);let c=0,u=0,d=0,p=-180,f=-85,m=180,g=85;if(s.bounds){const t=s.bounds.split(",");p=+t[0],f=+t[1],m=+t[2],g=+t[3]}if(s.center){const t=s.center.split(",");c=+t[0],u=+t[1],d=+t[2]}return{specVersion:i.getUint16(2,!0),rootDirectoryOffset:10+n,rootDirectoryLength:17*r,jsonMetadataOffset:10,jsonMetadataLength:n,leafDirectoryOffset:0,leafDirectoryLength:void 0,tileDataOffset:0,tileDataLength:void 0,numAddressedTiles:0,numTileEntries:0,numTileContents:0,clustered:!1,internalCompression:1,tileCompression:a,tileType:1,minZoom:l,maxZoom:h,minLon:p,minLat:f,maxLon:m,maxLat:g,centerZoom:d,centerLon:c,centerLat:u,etag:e.etag}}))},getZxy:function(t,e,i,n,r,o,s){return ct(this,null,(function*(){let a=yield i.getArrayBuffer(e,t.rootDirectoryOffset,t.rootDirectoryLength,t);1===t.specVersion&&(a=Qt(a));const l=Kt(new DataView(a),n,r,o);if(l){let t=(yield e.getBytes(l.offset,l.length,s)).data;const i=new DataView(t);return 31==i.getUint8(0)&&139==i.getUint8(1)&&(t=Gt(new Uint8Array(t))),{data:t}}const h=((t,e)=>{if(t.byteLength<17)return null;const i=t.byteLength/17,n=Jt(t,i-1);if(n.is_dir){const t=n.z,i=e.z-t;return{z:t,x:Math.trunc(e.x/(1<<i)),y:Math.trunc(e.y/(1<<i))}}return null})(new DataView(a),{z:n,x:r,y:o});if(h){const l=((t,e,i,n)=>{const r=Yt(t,128|e,i,n);return r?{z:e,x:i,y:n,offset:r[0],length:r[1],is_dir:!0}:null})(new DataView(a),h.z,h.x,h.y);if(l){let a=yield i.getArrayBuffer(e,l.offset,l.length,t);1===t.specVersion&&(a=Qt(a));const h=Kt(new DataView(a),n,r,o);if(h){let t=(yield e.getBytes(h.offset,h.length,s)).data;const i=new DataView(t);return 31==i.getUint8(0)&&139==i.getUint8(1)&&(t=Gt(new Uint8Array(t))),{data:t}}}}}))}};function ee(t,e){return 4294967296*(e>>>0)+(t>>>0)}function ie(t){const e=t.buf;let i,n;return n=e[t.pos++],i=127&n,n<128?i:(n=e[t.pos++],i|=(127&n)<<7,n<128?i:(n=e[t.pos++],i|=(127&n)<<14,n<128?i:(n=e[t.pos++],i|=(127&n)<<21,n<128?i:(n=e[t.pos],i|=(15&n)<<28,function(t,e){const i=e.buf;let n,r;if(r=i[e.pos++],n=(112&r)>>4,r<128)return ee(t,n);if(r=i[e.pos++],n|=(127&r)<<3,r<128)return ee(t,n);if(r=i[e.pos++],n|=(127&r)<<10,r<128)return ee(t,n);if(r=i[e.pos++],n|=(127&r)<<17,r<128)return ee(t,n);if(r=i[e.pos++],n|=(127&r)<<24,r<128)return ee(t,n);if(r=i[e.pos++],n|=(1&r)<<31,r<128)return ee(t,n);throw new Error("Expected varint not more than 10 bytes")}(i,t)))))}function ne(t,e,i,n){if(0==n){1==i&&(e[0]=t-1-e[0],e[1]=t-1-e[1]);const n=e[0];e[0]=e[1],e[1]=n}}function re(t,e){return ct(this,null,(function*(){if(1===e||0===e)return t;if(2===e)return Gt(new Uint8Array(t));throw Error("Compression method not supported")}))}function oe(t,e){let i=0,n=t.length-1;for(;i<=n;){const r=n+i>>1,o=e-t[r].tileId;if(o>0)i=r+1;else{if(!(o<0))return t[r];n=r-1}}if(n>=0){if(0===t[n].runLength)return t[n];if(e-t[n].tileId<t[n].runLength)return t[n]}return null}var se=class{constructor(t){this.url=t}getKey(){return this.url}getBytes(t,e,i){return ct(this,null,(function*(){let n;i||(n=new AbortController,i=n.signal);let r=yield fetch(this.url,{signal:i,headers:{Range:"bytes="+t+"-"+(t+e-1)}});if(416===r.status&&0===t){const t=r.headers.get("Content-Range");if(!t||!t.startsWith("bytes */"))throw Error("Missing content-length on 416 response");const e=+t.substr(8);r=yield fetch(this.url,{signal:i,headers:{Range:"bytes=0-"+(e-1)}})}if(r.status>=300)throw Error("Bad response code: "+r.status);const o=r.headers.get("Content-Length");if(200===r.status&&(!o||+o>e))throw n&&n.abort(),Error("Server returned no content-length header or content-length exceeding request. Check that your storage backend supports HTTP Byte Serving.");return{data:yield r.arrayBuffer(),etag:r.headers.get("ETag")||void 0,cacheControl:r.headers.get("Cache-Control")||void 0,expires:r.headers.get("Expires")||void 0}}))}};function ae(t,e){const i=t.getUint32(e+4,!0),n=t.getUint32(e+0,!0);return i*Math.pow(2,32)+n}function le(t){const e={buf:new Uint8Array(t),pos:0},i=ie(e),n=[];let r=0;for(let t=0;t<i;t++){const t=ie(e);n.push({tileId:r+t,offset:0,length:0,runLength:1}),r+=t}for(let t=0;t<i;t++)n[t].runLength=ie(e);for(let t=0;t<i;t++)n[t].length=ie(e);for(let t=0;t<i;t++){const i=ie(e);n[t].offset=0===i&&t>0?n[t-1].offset+n[t-1].length:i-1}return n}var he=class extends Error{};var ce=class{constructor(t=100,e=!0,i=re){this.cache=new Map,this.maxCacheEntries=t,this.counter=1,this.prefetch=e,this.decompress=i}getHeader(t,e){return ct(this,null,(function*(){const i=t.getKey();if(this.cache.has(i))return this.cache.get(i).lastUsed=this.counter++,yield this.cache.get(i).data;const n=new Promise(((i,n)=>{(function(t,e,i,n){return ct(this,null,(function*(){const r=yield t.getBytes(0,16384);if(19792!==new DataView(r.data).getUint16(0,!0))throw new Error("Wrong magic number for PMTiles archive");if(function(t){const e=new DataView(t);return 2===e.getUint16(2,!0)?(console.warn("PMTiles spec version 2 has been deprecated; please see github.com/protomaps/PMTiles for tools to upgrade"),2):1===e.getUint16(2,!0)?(console.warn("PMTiles spec version 1 has been deprecated; please see github.com/protomaps/PMTiles for tools to upgrade"),1):3}(r.data)<3)return[yield te.getHeader(t)];const o=r.data.slice(0,127);let s=r.etag;n&&r.etag!=n&&(console.warn("ETag conflict detected; your HTTP server might not support content-based ETag headers. ETags disabled for "+t.getKey()),s=void 0);const a=function(t,e){const i=new DataView(t),n=i.getUint8(7);if(n>3)throw Error(`Archive is spec version ${n} but this library supports up to spec version 3`);return{specVersion:n,rootDirectoryOffset:ae(i,8),rootDirectoryLength:ae(i,16),jsonMetadataOffset:ae(i,24),jsonMetadataLength:ae(i,32),leafDirectoryOffset:ae(i,40),leafDirectoryLength:ae(i,48),tileDataOffset:ae(i,56),tileDataLength:ae(i,64),numAddressedTiles:ae(i,72),numTileEntries:ae(i,80),numTileContents:ae(i,88),clustered:1===i.getUint8(96),internalCompression:i.getUint8(97),tileCompression:i.getUint8(98),tileType:i.getUint8(99),minZoom:i.getUint8(100),maxZoom:i.getUint8(101),minLon:i.getInt32(102,!0)/1e7,minLat:i.getInt32(106,!0)/1e7,maxLon:i.getInt32(110,!0)/1e7,maxLat:i.getInt32(114,!0)/1e7,centerZoom:i.getUint8(118),centerLon:i.getInt32(119,!0)/1e7,centerLat:i.getInt32(123,!0)/1e7,etag:e}}(o,s);if(i){const i=r.data.slice(a.rootDirectoryOffset,a.rootDirectoryOffset+a.rootDirectoryLength),n=t.getKey()+"|"+(a.etag||"")+"|"+a.rootDirectoryOffset+"|"+a.rootDirectoryLength,o=le(yield e(i,a.internalCompression));return[a,[n,o.length,o]]}return[a,void 0]}))})(t,this.decompress,this.prefetch,e).then((t=>{t[1]&&this.cache.set(t[1][0],{lastUsed:this.counter++,data:Promise.resolve(t[1][2])}),i(t[0]),this.prune()})).catch((t=>{n(t)}))}));return this.cache.set(i,{lastUsed:this.counter++,data:n}),n}))}getDirectory(t,e,i,n){return ct(this,null,(function*(){const r=t.getKey()+"|"+(n.etag||"")+"|"+e+"|"+i;if(this.cache.has(r))return this.cache.get(r).lastUsed=this.counter++,yield this.cache.get(r).data;const o=new Promise(((r,o)=>{(function(t,e,i,n,r){return ct(this,null,(function*(){const o=yield t.getBytes(i,n);if(r.etag&&r.etag!==o.etag)throw new he(o.etag);const s=le(yield e(o.data,r.internalCompression));if(0===s.length)throw new Error("Empty directory is invalid");return s}))})(t,this.decompress,e,i,n).then((t=>{r(t),this.prune()})).catch((t=>{o(t)}))}));return this.cache.set(r,{lastUsed:this.counter++,data:o}),o}))}getArrayBuffer(t,e,i,n){return ct(this,null,(function*(){const r=t.getKey()+"|"+(n.etag||"")+"|"+e+"|"+i;if(this.cache.has(r))return this.cache.get(r).lastUsed=this.counter++,yield this.cache.get(r).data;const o=new Promise(((o,s)=>{t.getBytes(e,i).then((t=>{if(n.etag&&n.etag!==t.etag)throw new he(t.etag);o(t.data),this.cache.has(r),this.prune()})).catch((t=>{s(t)}))}));return this.cache.set(r,{lastUsed:this.counter++,data:o}),o}))}prune(){if(this.cache.size>=this.maxCacheEntries){let t,e=1/0;this.cache.forEach(((i,n)=>{i.lastUsed<e&&(e=i.lastUsed,t=n)})),t&&this.cache.delete(t)}}invalidate(t,e){return ct(this,null,(function*(){this.cache.delete(t.getKey()),yield this.getHeader(t,e)}))}},ue=class{constructor(t,e,i){this.source="string"==typeof t?new se(t):t,this.decompress=i||re,this.cache=e||new ce}getHeader(){return ct(this,null,(function*(){return yield this.cache.getHeader(this.source)}))}getZxyAttempt(t,e,i,n){return ct(this,null,(function*(){const r=function(t,e,i){if(t>26)throw Error("Tile zoom level exceeds max safe number limit (26)");if(e>Math.pow(2,t)-1||i>Math.pow(2,t)-1)throw Error("tile x/y outside zoom level bounds");let n=0,r=0;for(;r<t;)n+=Math.pow(2,r)*Math.pow(2,r),r++;let o=0,s=0,a=0;const l=[e,i];let h=Math.pow(2,t)/2;for(;h>0;)o=(l[0]&h)>0?1:0,s=(l[1]&h)>0?1:0,a+=h*h*(3*o^s),ne(h,l,o,s),h/=2;return n+a}(t,e,i),o=yield this.cache.getHeader(this.source);if(o.specVersion<3)return te.getZxy(o,this.source,this.cache,t,e,i,n);if(t<o.minZoom||t>o.maxZoom)return;let s=o.rootDirectoryOffset,a=o.rootDirectoryLength;for(let t=0;t<=3;t++){const t=oe(yield this.cache.getDirectory(this.source,s,a,o),r);if(!t)return;if(t.runLength>0){const e=yield this.source.getBytes(o.tileDataOffset+t.offset,t.length,n);if(o.etag&&o.etag!==e.etag)throw new he(e.etag);return{data:yield this.decompress(e.data,o.tileCompression),cacheControl:e.cacheControl,expires:e.expires}}s=o.leafDirectoryOffset+t.offset,a=t.length}throw Error("Maximum directory depth exceeded")}))}getZxy(t,e,i,n){return ct(this,null,(function*(){try{return yield this.getZxyAttempt(t,e,i,n)}catch(r){if(r instanceof he)return this.cache.invalidate(this.source,r.message),yield this.getZxyAttempt(t,e,i,n);throw r}}))}getMetadataAttempt(){return ct(this,null,(function*(){const t=yield this.cache.getHeader(this.source),e=yield this.source.getBytes(t.jsonMetadataOffset,t.jsonMetadataLength);if(t.etag&&t.etag!==e.etag)throw new he(e.etag);const i=yield this.decompress(e.data,t.internalCompression),n=new TextDecoder("utf-8");return JSON.parse(n.decode(i))}))}getMetadata(){return ct(this,null,(function*(){try{return yield this.getMetadataAttempt()}catch(t){if(t instanceof he)return this.cache.invalidate(this.source,t.message),yield this.getMetadataAttempt();throw t}}))}};function de(t){return`${t.x}:${t.y}:${t.z}`}var pe=(t,e,i)=>{t.pos=e;const n=t.readVarint()+t.pos;let r=1,o=0,s=0,a=0,l=1/0,h=-1/0,c=1/0,u=-1/0;const d=[];let p=[];for(;t.pos<n;){if(o<=0){const e=t.readVarint();r=7&e,o=e>>3}if(o--,1===r||2===r)s+=t.readSVarint()*i,a+=t.readSVarint()*i,s<l&&(l=s),s>h&&(h=s),a<c&&(c=a),a>u&&(u=a),1===r&&(p.length>0&&d.push(p),p=[]),p.push(new at.default(s,a));else{if(7!==r)throw new Error(`unknown command ${r}`);p&&p.push(p[0].clone())}}return p&&d.push(p),{geom:d,bbox:{minX:l,minY:c,maxX:h,maxY:u}}};function fe(t,e){const i=new lt.VectorTile(new ht.default(t)),n=new Map;for(const[t,r]of Object.entries(i.layers)){const i=[],o=r;for(let t=0;t<o.length;t++){const n=pe(o.feature(t)._pbf,o.feature(t)._geometry,e/o.extent);let r=0;for(const t of n.geom)r+=t.length;i.push({id:o.feature(t).id,geomType:o.feature(t).type,geom:n.geom,numVertices:r,bbox:n.bbox,props:o.feature(t).properties})}n.set(t,i)}return n}var me=class{constructor(t,e){this.p="string"==typeof t?new ue(t):t,this.zoomaborts=[],this.shouldCancelZooms=e}get(t,e){return x(this,null,(function*(){this.shouldCancelZooms&&(this.zoomaborts=this.zoomaborts.filter((e=>e.z===t.z||(e.controller.abort(),!1))));const i=new AbortController;this.zoomaborts.push({z:t.z,controller:i});const n=i.signal,r=yield this.p.getZxy(t.z,t.x,t.y,n);return r?fe(r.data,e):new Map}))}},ge=class{constructor(t,e){this.url=t,this.zoomaborts=[],this.shouldCancelZooms=e}get(t,e){return x(this,null,(function*(){this.shouldCancelZooms&&(this.zoomaborts=this.zoomaborts.filter((e=>e.z===t.z||(e.controller.abort(),!1))));const i=this.url.replace("{z}",t.z.toString()).replace("{x}",t.x.toString()).replace("{y}",t.y.toString()),n=new AbortController;this.zoomaborts.push({z:t.z,controller:n});const r=n.signal;return new Promise(((t,n)=>{fetch(i,{signal:r}).then((t=>t.arrayBuffer())).then((i=>{const n=fe(i,e);t(n)})).catch((t=>{n(t)}))}))}))}},_e=6378137,ye=85.0511287798,ve=_e*Math.PI;function be(t){return t*t}function xe(t,e){return be(t.x-e.x)+be(t.y-e.y)}function we(t,e,i){const n=xe(e,i);if(0===n)return xe(t,e);let r=((t.x-e.x)*(i.x-e.x)+(t.y-e.y)*(i.y-e.y))/n;return r=Math.max(0,Math.min(1,r)),xe(t,new at.default(e.x+r*(i.x-e.x),e.y+r*(i.y-e.y)))}function Le(t,e){let i=!1;for(let n=0,r=e.length-1;n<e.length;r=n++){const o=e[n].x,s=e[n].y,a=e[r].x,l=e[r].y;s>t.y!=l>t.y&&t.x<(a-o)*(t.y-s)/(l-s)+o&&(i=!i)}return i}function Me(t){let e=0;for(let i=0;i<t.length;i++){const n=(i+1)%t.length;e+=t[i].x*t[n].y,e-=t[n].x*t[i].y}return e<0}function ke(t,e){let i=!1;for(const n of e)if(Me(n))Le(t,n)&&(i=!1);else{if(i)return!0;Le(t,n)&&(i=!0)}return i}function Ce(t,e){let i=1/0;for(const n of e){const e=Math.sqrt(xe(t,n[0]));e<i&&(i=e)}return i}function Ae(t,e){let i=1/0;for(const n of e)for(let e=0;e<n.length-1;e++){const r=Math.sqrt(we(t,n[e],n[e+1]));r<i&&(i=r)}return i}var Pe=class{constructor(t,e){this.source=t,this.cache=new Map,this.inflight=new Map,this.tileSize=e}queryFeatures(t,e,i,n){const r=(t=>{const e=Math.PI/180,i=Math.max(Math.min(ye,t[0]),-ye),n=Math.sin(i*e);return new at.default(_e*t[1]*e,_e*Math.log((1+n)/(1-n))/2)})([e,t]),o=new at.default((r.x+ve)/(2*ve),1-(r.y+ve)/(2*ve));o.x>1&&(o.x=o.x-Math.floor(o.x));const s=o.mult(1<<i),a=Math.floor(s.x),l=Math.floor(s.y),h=de({z:i,x:a,y:l}),c=[],u=this.cache.get(h);if(u){const t=new at.default((s.x-a)*this.tileSize,(s.y-l)*this.tileSize);for(const[e,i]of u.data.entries())for(const r of i)1===r.geomType?Ce(t,r.geom)<n&&c.push({feature:r,layerName:e}):2===r.geomType?Ae(t,r.geom)<n&&c.push({feature:r,layerName:e}):ke(t,r.geom)&&c.push({feature:r,layerName:e})}return c}get(t){return x(this,null,(function*(){const e=de(t);return new Promise(((i,n)=>{const r=this.cache.get(e);if(r)r.used=performance.now(),i(r.data);else{const r=this.inflight.get(e);r?r.push([i,n]):(this.inflight.set(e,[]),this.source.get(t,this.tileSize).then((t=>{this.cache.set(e,{used:performance.now(),data:t});const n=this.inflight.get(e);if(n)for(const e of n)e[0](t);if(this.inflight.delete(e),i(t),this.cache.size>=64){let t,e=1/0;this.cache.forEach(((i,n)=>{i.used<e&&(e=i.used,t=n)})),t&&this.cache.delete(t)}})).catch((t=>{const i=this.inflight.get(e);if(i)for(const e of i)e[1](t);this.inflight.delete(e),n(t)})))}}))}))}},Se=class{constructor(t){var e;this.pattern=t.pattern,this.fill=new Q(t.fill,"black"),this.opacity=new $(t.opacity,1),this.stroke=new Q(t.stroke,"black"),this.width=new $(t.width,0),this.per_feature=null!=(e=this.fill.per_feature||this.opacity.per_feature||this.stroke.per_feature||this.width.per_feature||t.per_feature)&&e,this.do_stroke=!1}before(t,e){if(!this.per_feature){t.globalAlpha=this.opacity.get(e),t.fillStyle=this.fill.get(e),t.strokeStyle=this.stroke.get(e);const i=this.width.get(e);i>0&&(this.do_stroke=!0),t.lineWidth=i}if(this.pattern){const e=t.createPattern(this.pattern,"repeat");e&&(t.fillStyle=e)}}draw(t,e,i,n){let r=!1;if(this.per_feature){t.globalAlpha=this.opacity.get(i,n),t.fillStyle=this.fill.get(i,n);const e=this.width.get(i,n);e&&(r=!0,t.strokeStyle=this.stroke.get(i,n),t.lineWidth=e)}const o=()=>{t.fill(),(r||this.do_stroke)&&t.stroke()};let s=0;t.beginPath();for(const i of e){s+i.length>5400&&(o(),s=0,t.beginPath());for(let e=0;e<i.length;e++){const n=i[e];0===e?t.moveTo(n.x,n.y):t.lineTo(n.x,n.y)}s+=i.length}s>0&&o()}};function Ee(t,e){return i=>{if(e.length<1)return 0;if(i<=e[0][0])return e[0][1];if(i>=e[e.length-1][0])return e[e.length-1][1];const n=function(t,e){let i=0;for(;e[i+1][0]<t;)i++;return i}(i,e);return r=function(t,e,i,n){const r=n[e+1][0]-n[e][0],o=t-n[e][0];return 0===r?0:1===i?o/r:(_(i,o)-1)/(_(i,r)-1)}(i,n,t,e),o=e[n][1],s=e[n+1][1],r*(s-o)+o;var r,o,s}}var Ie=class{constructor(t){var e;this.color=new Q(t.color,"black"),this.width=new $(t.width),this.opacity=new $(t.opacity),this.dash=t.dash?new it(t.dash):null,this.dashColor=new Q(t.dashColor,"black"),this.dashWidth=new $(t.dashWidth,1),this.lineCap=new Q(t.lineCap,"butt"),this.lineJoin=new Q(t.lineJoin,"miter"),this.skip=!1,this.per_feature=!!((null==(e=this.dash)?void 0:e.per_feature)||this.color.per_feature||this.opacity.per_feature||this.width.per_feature||this.lineCap.per_feature||this.lineJoin.per_feature||t.per_feature)}before(t,e){this.per_feature||(t.strokeStyle=this.color.get(e),t.lineWidth=this.width.get(e),t.globalAlpha=this.opacity.get(e),t.lineCap=this.lineCap.get(e),t.lineJoin=this.lineJoin.get(e))}draw(t,e,i,n){if(this.skip)return;const r=()=>{this.per_feature&&(t.globalAlpha=this.opacity.get(i,n),t.lineCap=this.lineCap.get(i,n),t.lineJoin=this.lineJoin.get(i,n)),this.dash?(t.save(),this.per_feature?(t.lineWidth=this.dashWidth.get(i,n),t.strokeStyle=this.dashColor.get(i,n),t.setLineDash(this.dash.get(i,n))):t.setLineDash(this.dash.get(i)),t.stroke(),t.restore()):(t.save(),this.per_feature&&(t.lineWidth=this.width.get(i,n),t.strokeStyle=this.color.get(i,n)),t.stroke(),t.restore())};let o=0;t.beginPath();for(const i of e){o+i.length>5400&&(r(),o=0,t.beginPath());for(let e=0;e<i.length;e++){const n=i[e];0===e?t.moveTo(n.x,n.y):t.lineTo(n.x,n.y)}o+=i.length}o>0&&r()}},Te=class{constructor(t){this.radius=new $(t.radius,3),this.fill=new Q(t.fill,"black"),this.stroke=new Q(t.stroke,"white"),this.width=new $(t.width,0),this.opacity=new $(t.opacity)}draw(t,e,i,n){t.globalAlpha=this.opacity.get(i,n);const r=this.radius.get(i,n),o=this.width.get(i,n);o>0&&(t.strokeStyle=this.stroke.get(i,n),t.lineWidth=o,t.beginPath(),t.arc(e[0][0].x,e[0][0].y,r+o/2,0,2*Math.PI),t.stroke()),t.fillStyle=this.fill.get(i,n),t.beginPath(),t.arc(e[0][0].x,e[0][0].y,r,0,2*Math.PI),t.fill()}place(t,e,i){e[0];const n=new X.default(e[0][0].x,e[0][0].y),r=this.radius.get(t.zoom,i);return[{anchor:n,bboxes:[{minX:n.x-r,minY:n.y-r,maxX:n.x+r,maxY:n.y+r}],draw:e=>{this.draw(e,[[new X.default(0,0)]],t.zoom,i)}}]}},De=class{constructor(t){this.font=new et(t),this.text=new tt(t),this.fill=new Q(t.fill,"black"),this.background=new Q(t.background,"white"),this.padding=new $(t.padding,0)}place(t,e,i){const n=this.text.get(t.zoom,i);if(!n)return;const r=this.font.get(t.zoom,i);t.scratch.font=r;const o=t.scratch.measureText(n),s=o.width,a=o.actualBoundingBoxAscent,l=o.actualBoundingBoxDescent,h=(e[0],new X.default(e[0][0].x,e[0][0].y)),c=this.padding.get(t.zoom,i);return[{anchor:h,bboxes:[{minX:h.x-s/2-c,minY:h.y-a-c,maxX:h.x+s/2+c,maxY:h.y+l+c}],draw:e=>{e.globalAlpha=1,e.fillStyle=this.background.get(t.zoom,i),e.fillRect(-s/2-c,-a-c,s+2*c,a+l+2*c),e.fillStyle=this.fill.get(t.zoom,i),e.font=r,e.fillText(n,-s/2,0)}}]}},ze=class{constructor(t){this.list=t}place(t,e,i){let n=this.list[0].place(t,e,i);if(!n)return;let r=n[0];const o=r.anchor;let s=r.bboxes[0];const a=s.maxY-s.minY,l=[{draw:r.draw,translate:{x:0,y:0}}],h=[[new X.default(e[0][0].x,e[0][0].y+a)]];for(let e=1;e<this.list.length;e++)n=this.list[e].place(t,h,i),n&&(r=n[0],s=Be(s,r.bboxes[0]),l.push({draw:r.draw,translate:{x:0,y:a}}));return[{anchor:o,bboxes:[s],draw:t=>{for(const e of l)t.save(),t.translate(e.translate.x,e.translate.y),e.draw(t),t.restore()}}]}},Be=(t,e)=>({minX:Math.min(t.minX,e.minX),minY:Math.min(t.minY,e.minY),maxX:Math.max(t.maxX,e.maxX),maxY:Math.max(t.maxY,e.maxY)}),Oe=class{constructor(t){this.list=t}place(t,e,i){const n=this.list[0];if(!n)return;let r=n.place(t,e,i);if(!r)return;let o=r[0];const s=o.anchor;let a=o.bboxes[0];const l=[o.draw];for(let n=1;n<this.list.length;n++){if(r=this.list[n].place(t,e,i),!r)return;o=r[0],a=Be(a,o.bboxes[0]),l.push(o.draw)}return[{anchor:s,bboxes:[a],draw:t=>{for(const e of l)e(t)}}]}},Re=class{constructor(t){this.symbolizer=t}place(t,e,i){const n=e[0][0],r=this.symbolizer.place(t,[[new X.default(0,0)]],i);if(!r||0===r.length)return;const o=r[0],s=o.bboxes[0],a=s.maxX-s.minX,l=s.maxY-s.minY;return[{anchor:n,bboxes:[{minX:n.x-a/2,maxX:n.x+a/2,minY:n.y-l/2,maxY:n.y+l/2}],draw:t=>{t.translate(-a/2,l/2-s.maxY),o.draw(t,{justify:2})}}]}},je=class{constructor(t){this.font=new et(t),this.text=new tt(t),this.fill=new Q(t.fill,"black"),this.stroke=new Q(t.stroke,"black"),this.width=new $(t.width,0),this.lineHeight=new $(t.lineHeight,1),this.letterSpacing=new $(t.letterSpacing,0),this.maxLineCodeUnits=new $(t.maxLineChars,15),this.justify=t.justify}place(t,e,i){const n=this.text.get(t.zoom,i);if(!n)return;const r=this.font.get(t.zoom,i);t.scratch.font=r;const o=this.letterSpacing.get(t.zoom,i),s=st(n,this.maxLineCodeUnits.get(t.zoom,i));let a="",l=0;for(const t of s)t.length>l&&(l=t.length,a=t);const h=t.scratch.measureText(a),c=h.width+o*(l-1),u=h.actualBoundingBoxAscent,d=h.actualBoundingBoxDescent,p=(u+d)*this.lineHeight.get(t.zoom,i),f=new X.default(e[0][0].x,e[0][0].y);return[{anchor:f,bboxes:[{minX:f.x,minY:f.y-u,maxX:f.x+c,maxY:f.y+d+(s.length-1)*p}],draw:(e,n)=>{e.globalAlpha=1,e.font=r,e.fillStyle=this.fill.get(t.zoom,i);const a=this.width.get(t.zoom,i);let l=0;for(const r of s){let s=0;if(2===this.justify||n&&2===n.justify?s=(c-e.measureText(r).width)/2:(3===this.justify||n&&3===n.justify)&&(s=c-e.measureText(r).width),a)if(e.lineWidth=2*a,e.strokeStyle=this.stroke.get(t.zoom,i),o>0){let t=s;for(const i of r)e.strokeText(i,t,l),t+=e.measureText(i).width+o}else e.strokeText(r,s,l);if(o>0){let t=s;for(const i of r)e.fillText(i,t,l),t+=e.measureText(i).width+o}else e.fillText(r,s,l);l+=p}}}]}},Ne=class{constructor(t){this.centered=new Re(new je(t))}place(t,e,i){return this.centered.place(t,e,i)}},Fe=class{constructor(t,e){var i,n,r;this.symbolizer=t,this.offsetX=new $(e.offsetX,0),this.offsetY=new $(e.offsetY,0),this.justify=null!=(i=e.justify)?i:void 0,this.placements=null!=(n=e.placements)?n:[2,6,8,4,1,3,5,7],this.ddValues=null!=(r=e.ddValues)?r:()=>({})}place(t,e,i){if(1!==i.geomType)return;const n=e[0][0],r=this.symbolizer.place(t,[[new X.default(0,0)]],i);if(!r||0===r.length)return;const o=r[0],s=o.bboxes[0];let a=this.offsetX,l=this.offsetY,h=this.justify,c=this.placements;const{offsetX:u,offsetY:d,justify:p,placements:f}=this.ddValues(t.zoom,i)||{};u&&(a=new $(u,0)),d&&(l=new $(d,0)),p&&(h=p),f&&(c=f);const m=a.get(t.zoom,i),g=l.get(t.zoom,i);let _,y=new X.default(m,g);const v=t=>{t.translate(y.x,y.y),o.draw(t,{justify:_})},b=(e,i)=>{const r=((t,e)=>({minX:t.x+e.x+s.minX,minY:t.y+e.y+s.minY,maxX:t.x+e.x+s.maxX,maxY:t.y+e.y+s.maxY}))(e,i);if(!t.index.bboxCollides(r,t.order))return[{anchor:n,bboxes:[r],draw:v}]};for(const t of c){const e=this.computeXAxisOffset(m,s,t),i=this.computeYAxisOffset(g,s,t);return _=this.computeJustify(h,t),y=new X.default(e,i),b(n,y)}}computeXAxisOffset(t,e,i){const n=e.maxX,r=n/2;return[1,5].includes(i)?t-r:[8,7,6].includes(i)?t-n:t}computeYAxisOffset(t,e,i){const n=Math.abs(e.minY),r=e.maxY,o=(e.minY+e.maxY)/2;return[3,7].includes(i)?t-o:[8,2,1].includes(i)?t-r:[6,4,5].includes(i)?t+n:t}computeJustify(t,e){return t||([1,5].includes(e)?2:[2,3,4].includes(e)?1:3)}},Ge=class{constructor(t){this.symbolizer=new Fe(new je(t),t)}place(t,e,i){return this.symbolizer.place(t,e,i)}},Ue=class{constructor(t){var e;this.font=new et(t),this.text=new tt(t),this.fill=new Q(t.fill,"black"),this.stroke=new Q(t.stroke,"black"),this.width=new $(t.width,0),this.offset=new $(t.offset,0),this.position=null!=(e=t.position)?e:1,this.maxLabelCodeUnits=new $(t.maxLabelChars,40),this.repeatDistance=new $(t.repeatDistance,250)}place(t,e,i){const n=this.text.get(t.zoom,i);if(!n)return;if(n.length>this.maxLabelCodeUnits.get(t.zoom,i))return;const r=i.bbox;if(r.maxY-r.minY<20&&r.maxX-r.minX<20)return;const o=this.font.get(t.zoom,i);t.scratch.font=o;const s=t.scratch.measureText(n),a=s.width,l=s.actualBoundingBoxAscent+s.actualBoundingBoxDescent;let h=this.repeatDistance.get(t.zoom,i);t.overzoom>4&&(h*=1<<t.overzoom-4);const c=2*l,u=function(t,e,i,n){const r=[];for(const o of t){const t=rt(o,Math.PI/45,e);for(const s of t)if(s.length>=e+n){const t=new nt.default(o[s.beginIndex].x,o[s.beginIndex].y),a=o[s.endIndex-1],l=new nt.default((a.x-t.x)/s.length,(a.y-t.y)/s.length);for(let o=n;o<s.length-e;o+=i)r.push({start:t.add(l.mult(o)),end:t.add(l.mult(o+e))})}}return r}(e,a,h,c);if(0===u.length)return;const d=[];for(const e of u){const r=e.end.x-e.start.x,s=e.end.y-e.start.y,u=ot(e.start,e.end,a,c/2).map((t=>({minX:t.x-c/2,minY:t.y-c/2,maxX:t.x+c/2,maxY:t.y+c/2}))),p=e=>{e.globalAlpha=1,e.rotate(Math.atan2(s,r)),r<0&&(e.scale(-1,-1),e.translate(-a,0));let h=0;3===this.position?h+=l:2===this.position&&(h+=l/2),e.translate(0,h-this.offset.get(t.zoom,i)),e.font=o;const c=this.width.get(t.zoom,i);c&&(e.lineWidth=c,e.strokeStyle=this.stroke.get(t.zoom,i),e.strokeText(n,0,0)),e.fillStyle=this.fill.get(t.zoom,i),e.fillText(n,0,0)};d.push({anchor:e.start,bboxes:u,draw:p,deduplicationKey:n,deduplicationDistance:h})}return d}},He=class{constructor(t){this.symbolizer=new je(t)}place(t,e,i){const n=i.bbox;if((n.maxY-n.minY)*(n.maxX-n.minX)<2e4)return;const r=this.symbolizer.place(t,[[new X.default(0,0)]],i);if(!r||0===r.length)return;const o=r[0],s=o.bboxes[0],a=e[0],l=(0,J.default)([a.map((t=>[t.x,t.y]))]),h=new X.default(l[0],l[1]);return[{anchor:h,bboxes:[{minX:h.x-(s.maxX-s.minX)/2,minY:h.y-(s.maxY-s.minY)/2,maxX:h.x+(s.maxX-s.minX)/2,maxY:h.y+(s.maxY-s.minY)/2}],draw:t=>{t.translate(o.anchor.x-(s.maxX-s.minX)/2,o.anchor.y),o.draw(t)}}]}},Ve=(t,e)=>{const i=K(e),n=((t,e)=>{for(var i in e||(e={}))m.call(e,i)&&y(t,i,e[i]);if(p)for(var i of p(e))g.call(e,i)&&y(t,i,e[i]);return t})({},t);for(const[e,r]of Object.entries(t)){const t=K(r);n[e]=Y(i[0],i[1],t[2],t[3])}return n},Ze=(t,e)=>{let i=t;return e&&(i=Ve(t,e)),[{dataLayer:"earth",symbolizer:new Se({fill:i.earth})},{dataLayer:"natural",symbolizer:new Se({fill:i.glacier}),filter:(t,e)=>"glacier"===e.props.natural},{dataLayer:"landuse",symbolizer:new Se({fill:i.residential}),filter:(t,e)=>"residential"===e.props.landuse||"neighbourhood"===e.props.place},{dataLayer:"landuse",symbolizer:new Se({fill:i.hospital}),filter:(t,e)=>"hospital"===e.props.amenity},{dataLayer:"landuse",symbolizer:new Se({fill:i.cemetery}),filter:(t,e)=>"cemetery"===e.props.landuse},{dataLayer:"landuse",symbolizer:new Se({fill:i.school}),filter:(t,e)=>"school"===e.props.amenity||"kindergarten"===e.props.amenity||"university"===e.props.amenity||"college"===e.props.amenity},{dataLayer:"landuse",symbolizer:new Se({fill:i.industrial}),filter:(t,e)=>"industrial"===e.props.landuse},{dataLayer:"natural",symbolizer:new Se({fill:i.wood}),filter:(t,e)=>"wood"===e.props.natural},{dataLayer:"landuse",symbolizer:new Se({fill:i.grass}),filter:(t,e)=>"grass"===e.props.landuse},{dataLayer:"landuse",symbolizer:new Se({fill:i.park}),filter:(t,e)=>"park"===e.props.leisure},{dataLayer:"water",symbolizer:new Se({fill:i.water})},{dataLayer:"natural",symbolizer:new Se({fill:i.sand}),filter:(t,e)=>"sand"===e.props.natural},{dataLayer:"buildings",symbolizer:new Se({fill:i.buildings})},{dataLayer:"roads",symbolizer:new Ie({color:i.highwayCasing,width:Ee(1.4,[[5,1.5],[11,4],[16,9],[20,40]])}),filter:(t,e)=>"highway"===e.props["pmap:kind"]},{dataLayer:"roads",symbolizer:new Ie({color:i.majorRoadCasing,width:Ee(1.4,[[9,3],[12,4],[17,8],[20,22]])}),filter:(t,e)=>"major_road"===e.props["pmap:kind"]},{dataLayer:"roads",symbolizer:new Ie({color:i.mediumRoadCasing,width:Ee(1.4,[[13,3],[17,6],[20,18]])}),filter:(t,e)=>"medium_road"===e.props["pmap:kind"]},{dataLayer:"roads",symbolizer:new Ie({color:i.minorRoadCasing,width:Ee(1.4,[[14,2],[17,5],[20,15]])}),filter:(t,e)=>"minor_road"===e.props["pmap:kind"]},{dataLayer:"roads",symbolizer:new Ie({color:i.minorRoad,width:Ee(1.4,[[14,1],[17,3],[20,13]])}),filter:(t,e)=>"minor_road"===e.props["pmap:kind"]},{dataLayer:"roads",symbolizer:new Ie({color:i.mediumRoad,width:Ee(1.4,[[13,2],[17,4],[20,15]])}),filter:(t,e)=>"medium_road"===e.props["pmap:kind"]},{dataLayer:"roads",symbolizer:new Ie({color:i.majorRoad,width:Ee(1.4,[[9,2],[12,3],[17,6],[20,20]])}),filter:(t,e)=>"major_road"===e.props["pmap:kind"]},{dataLayer:"roads",symbolizer:new Ie({color:i.highway,width:Ee(1.4,[[5,.5],[11,2.5],[16,7],[20,30]])}),filter:(t,e)=>"highway"===e.props["pmap:kind"]},{dataLayer:"boundaries",symbolizer:new Ie({color:i.boundaries,width:2,opacity:.4})},{dataLayer:"mask",symbolizer:new Se({fill:i.mask})}]},qe=(t,e,i,n)=>{let r=t;e&&(r=Ve(t,e));let o=["name"];i&&(o=i);const s=(t,e)=>n?new ze(t instanceof Ge?[t,new Ge({fill:e,label_props:n})]:[t,new Ne({fill:e,label_props:n})]):t;return[{dataLayer:"places",symbolizer:s(new Ne({label_props:o,fill:r.countryLabel,lineHeight:1.5,font:(t,e)=>t<6?"200 14px sans-serif":"200 20px sans-serif",textTransform:"uppercase"}),r.countryLabel),filter:(t,e)=>"country"===e.props["pmap:kind"]},{dataLayer:"places",symbolizer:s(new Ne({label_props:o,fill:r.stateLabel,font:"300 16px sans-serif"}),r.stateLabel),filter:(t,e)=>"state"===e.props["pmap:kind"]},{id:"cities_high",dataLayer:"places",filter:(t,e)=>"city"===e.props["pmap:kind"],minzoom:7,symbolizer:s(new Ne({label_props:o,fill:r.cityLabel,font:(t,e)=>1===(null==e?void 0:e.props["pmap:rank"])?t>8?"600 20px sans-serif":"600 12px sans-serif":t>8?"600 16px sans-serif":"600 10px sans-serif"}),r.cityLabel),sort:(t,e)=>t["pmap:rank"]-e["pmap:rank"]},{id:"cities_low",dataLayer:"places",filter:(t,e)=>"city"===e.props["pmap:kind"],maxzoom:6,symbolizer:new Oe([new Te({radius:2,fill:r.cityLabel}),s(new Ge({label_props:o,fill:r.cityLabel,offsetX:2,offsetY:2,font:(t,e)=>1===(null==e?void 0:e.props["pmap:rank"])?t>8?"600 20px sans-serif":"600 12px sans-serif":t>8?"600 16px sans-serif":"600 10px sans-serif"}),r.cityLabel)]),sort:(t,e)=>t["pmap:rank"]-e["pmap:rank"]},{id:"neighbourhood",dataLayer:"places",symbolizer:s(new Ne({label_props:o,fill:r.neighbourhoodLabel,font:"500 10px sans-serif",textTransform:"uppercase"}),r.neighbourhoodLabel),filter:(t,e)=>"neighbourhood"===e.props["pmap:kind"]},{dataLayer:"landuse",symbolizer:s(new He({label_props:o,fill:r.landuseLabel,font:"300 12px sans-serif"}),r.landuseLabel)},{dataLayer:"water",symbolizer:s(new He({label_props:o,fill:r.waterLabel,font:"italic 600 12px sans-serif"}),r.waterLabel)},{dataLayer:"natural",symbolizer:s(new He({label_props:o,fill:r.naturalLabel,font:"italic 300 12px sans-serif"}),r.naturalLabel)},{dataLayer:"roads",symbolizer:s(new Ue({label_props:o,fill:r.roadsLabel,font:"500 12px sans-serif"}),r.roadsLabel),minzoom:12},{dataLayer:"roads",symbolizer:new De({label_props:["ref"],font:"600 9px sans-serif",background:r.highway,padding:2,fill:r.neighbourhoodLabel}),filter:(t,e)=>"highway"===e.props["pmap:kind"]},{dataLayer:"pois",symbolizer:new Oe([new Te({radius:2,fill:r.poisLabel}),s(new Ge({label_props:o,fill:r.poisLabel,offsetX:2,offsetY:2,font:"300 10px sans-serif"}),r.poisLabel)])}]},We=b(w()),Ke=b(D()),Ye=b(w()),Xe=(t,e,i)=>{const n=[];for(const r of t){const t=[];for(const n of r)t.push(n.clone().mult(e).add(i));n.push(t)}return n},Je=(t,e)=>{const i=1<<e;return t<0?i+t:t>=i?t%i:t},Qe=class{constructor(t,e,i){this.tileCache=t,this.maxDataLevel=e,this.levelDiff=i}dataTilesForBounds(t,e){const i=_(2,t)/_(2,Math.ceil(t)),n=[];let r=1;const o=this.tileCache.tileSize;if(t<this.levelDiff)r=1/(1<<this.levelDiff-t)*i,n.push({data_tile:{z:0,x:0,y:0},origin:new Ye.default(0,0),scale:r,dim:o*r});else if(t<=this.levelDiff+this.maxDataLevel){const r=1<<this.levelDiff,s=256*i,a=Math.ceil(t)-this.levelDiff,l=Math.floor(e.minX/r/s),h=Math.floor(e.minY/r/s),c=Math.floor(e.maxX/r/s),u=Math.floor(e.maxY/r/s);for(let t=l;t<=c;t++)for(let e=h;e<=u;e++){const l=new Ye.default(t*r*s,e*r*s);n.push({data_tile:{z:a,x:Je(t,a),y:Je(e,a)},origin:l,scale:i,dim:o*i})}}else{const s=1<<this.levelDiff;r=(1<<Math.ceil(t)-this.maxDataLevel-this.levelDiff)*i;const a=Math.floor(e.minX/s/256/r),l=Math.floor(e.minY/s/256/r),h=Math.floor(e.maxX/s/256/r),c=Math.floor(e.maxY/s/256/r);for(let t=a;t<=h;t++)for(let e=l;e<=c;e++){const i=new Ye.default(t*s*256*r,e*s*256*r);n.push({data_tile:{z:this.maxDataLevel,x:Je(t,this.maxDataLevel),y:Je(e,this.maxDataLevel)},origin:i,scale:r,dim:o*r})}}return n}dataTileForDisplayTile(t){let e,i,n=1,r=this.tileCache.tileSize;if(t.z<this.levelDiff)e={z:0,x:0,y:0},n=1/(1<<this.levelDiff-t.z),i=new Ye.default(0,0),r*=n;else if(t.z<=this.levelDiff+this.maxDataLevel){const n=1<<this.levelDiff;e={z:t.z-this.levelDiff,x:Math.floor(t.x/n),y:Math.floor(t.y/n)},i=new Ye.default(e.x*n*256,e.y*n*256)}else{n=1<<t.z-this.maxDataLevel-this.levelDiff;const o=1<<this.levelDiff;e={z:this.maxDataLevel,x:Math.floor(t.x/o/n),y:Math.floor(t.y/o/n)},i=new Ye.default(e.x*o*n*256,e.y*o*n*256),r*=n}return{data_tile:e,scale:n,origin:i,dim:r}}getBbox(t,e){return x(this,null,(function*(){const i=this.dataTilesForBounds(t,e);return(yield Promise.all(i.map((t=>this.tileCache.get(t.data_tile))))).map(((e,n)=>{const r=i[n];return{data:e,z:t,data_tile:r.data_tile,scale:r.scale,dim:r.dim,origin:r.origin}}))}))}getDisplayTile(t){return x(this,null,(function*(){const e=this.dataTileForDisplayTile(t);return{data:yield this.tileCache.get(e.data_tile),z:t.z,data_tile:e.data_tile,scale:e.scale,origin:e.origin,dim:e.dim}}))}queryFeatures(t,e,i){const n=Math.round(i),r=Math.min(n-this.levelDiff,this.maxDataLevel),o=16/(1<<n-r);return this.tileCache.queryFeatures(t,e,r,o)}},$e=class{constructor(t,e){this.tree=new Ke.default,this.current=new Map,this.dim=t,this.maxLabeledTiles=e}hasPrefix(t){for(const e of this.current.keys())if(e.startsWith(t))return!0;return!1}has(t){return this.current.has(t)}size(){return this.current.size}keys(){return this.current.keys()}searchBbox(t,e){const i=new Set;for(const n of this.tree.search(t))n.indexedLabel.order<=e&&i.add(n.indexedLabel);return i}searchLabel(t,e){const i=new Set;for(const n of t.bboxes)for(const t of this.tree.search(n))t.indexedLabel.order<=e&&i.add(t.indexedLabel);return i}bboxCollides(t,e){for(const i of this.tree.search(t))if(i.indexedLabel.order<=e)return!0;return!1}labelCollides(t,e){for(const i of t.bboxes)for(const t of this.tree.search(i))if(t.indexedLabel.order<=e)return!0;return!1}deduplicationCollides(t){if(!t.deduplicationKey||!t.deduplicationDistance)return!1;const e=t.deduplicationDistance,i={minX:t.anchor.x-e,minY:t.anchor.y-e,maxX:t.anchor.x+e,maxY:t.anchor.y+e};for(const n of this.tree.search(i))if(n.indexedLabel.deduplicationKey===t.deduplicationKey&&n.indexedLabel.anchor.dist(t.anchor)<e)return!0;return!1}makeEntry(t){this.current.get(t)&&console.log("consistency error 1");const e=new Set;this.current.set(t,e)}insert(t,e,i){const n={anchor:t.anchor,bboxes:t.bboxes,draw:t.draw,order:e,tileKey:i,deduplicationKey:t.deduplicationKey,deduplicationDistance:t.deduplicationDistance};let r=this.current.get(i);if(!r){const t=new Set;this.current.set(i,t),r=t}r.add(n);let o=!1,s=!1;for(const e of t.bboxes)this.tree.insert({minX:e.minX,minY:e.minY,maxX:e.maxX,maxY:e.maxY,indexedLabel:n}),e.minX<0&&(o=!0),e.maxX>this.dim&&(s=!0);if(o||s){const n=o?this.dim:-this.dim,r=[];for(const e of t.bboxes)r.push({minX:e.minX+n,minY:e.minY,maxX:e.maxX+n,maxY:e.maxY});const s={anchor:new We.default(t.anchor.x+n,t.anchor.y),bboxes:r,draw:t.draw,order:e,tileKey:i},a=this.current.get(i);a&&a.add(s);for(const t of r)this.tree.insert({minX:t.minX,minY:t.minY,maxX:t.maxX,maxY:t.maxY,indexedLabel:s})}}pruneOrNoop(t){const e=t.split(":");let i,n=0,r=0;for(const t of this.current.keys()){const o=t.split(":");if(o[3]===e[3]){r++;const s=Math.sqrt(_(+o[0]-+e[0],2)+_(+o[1]-+e[1],2));s>n&&(n=s,i=t)}i&&r>this.maxLabeledTiles&&this.pruneKey(i)}}pruneKey(t){const e=this.current.get(t);if(!e)return;const i=[];for(const t of this.tree.all())e.has(t.indexedLabel)&&i.push(t);for(const t of i)this.tree.remove(t);this.current.delete(t)}removeLabel(t){const e=[];for(const i of this.tree.all())t===i.indexedLabel&&e.push(i);for(const t of e)this.tree.remove(t);const i=this.current.get(t.tileKey);i&&i.delete(t)}},ti=class{constructor(t,e,i,n,r){this.index=new $e(256<<t,n),this.z=t,this.scratch=e,this.labelRules=i,this.callback=r}layout(t){const e=performance.now(),i=new Set;for(const[e,n]of t)for(const t of n){const n=`${de(t.data_tile)}:${e}`;this.index.has(n)||(this.index.makeEntry(n),i.add(n))}const n=new Set;for(const[e,r]of this.labelRules.entries()){if(!1===r.visible)continue;if(r.minzoom&&this.z<r.minzoom)continue;if(r.maxzoom&&this.z>r.maxzoom)continue;const o=r.dataSource||"",s=t.get(o);if(s)for(const t of s){const s=`${de(t.data_tile)}:${o}`;if(!i.has(s))continue;const a=t.data.get(r.dataLayer);if(void 0===a)continue;const l=a;r.sort&&l.sort(((t,e)=>r.sort?r.sort(t.props,e.props):0));const h={index:this.index,zoom:this.z,scratch:this.scratch,order:e,overzoom:this.z-t.data_tile.z};for(const i of l){if(r.filter&&!r.filter(this.z,i))continue;const o=Xe(i.geom,t.scale,t.origin),a=r.symbolizer.place(h,o,i);if(a)for(const i of a){let r=!1;if(!i.deduplicationKey||!this.index.deduplicationCollides(i)){if(this.index.labelCollides(i,1/0)){if(!this.index.labelCollides(i,e)){const o=this.index.searchLabel(i,1/0);for(const e of o){this.index.removeLabel(e);for(const i of e.bboxes)this.findInvalidatedTiles(n,t.dim,i,s)}this.index.insert(i,e,s),r=!0}}else this.index.insert(i,e,s),r=!0;if(r)for(const e of i.bboxes)(e.maxX>t.origin.x+t.dim||e.minX<t.origin.x||e.minY<t.origin.y||e.maxY>t.origin.y+t.dim)&&this.findInvalidatedTiles(n,t.dim,e,s)}}}}}for(const t of i)this.index.pruneOrNoop(t);return n.size>0&&this.callback&&this.callback(n),performance.now()-e}findInvalidatedTiles(t,e,i,n){const r=((t,e,i)=>{const n=256,r=e/n,o=Math.floor(i.minX/n),s=Math.floor(i.minY/n),a=Math.floor(i.maxX/n),l=Math.floor(i.maxY/n),h=Math.log2(r),c=[];for(let e=o;e<=a;e++){const i=e%(1<<t);for(let e=s;e<=l;e++)c.push({display:de({z:t,x:i,y:e}),key:de({z:t-h,x:Math.floor(i/r),y:Math.floor(e/r)})})}return c})(this.z,e,i);for(const e of r)e.key!==n&&this.index.hasPrefix(e.key)&&t.add(e.display)}add(t){let e=!0;for(const[i,n]of t)for(const t of n)this.index.has(`${de(t.data_tile)}:${i}`)||(e=!1);return e?0:this.layout(t)}},ei=class{constructor(t,e,i,n){this.labelers=new Map,this.scratch=t,this.labelRules=e,this.maxLabeledTiles=i,this.callback=n}add(t,e){let i=this.labelers.get(t);return i||(i=new ti(t,this.scratch,this.labelRules,this.maxLabeledTiles,this.callback),this.labelers.set(t,i)),i.add(e)}getIndex(t){const e=this.labelers.get(t);if(e)return e.index}},ii=b(w());var ni=(t,e,i)=>[{dataSource:t,dataLayer:e,symbolizer:new Te({opacity:.2,fill:i,radius:4}),filter:(t,e)=>1===e.geomType},{dataSource:t,dataLayer:e,symbolizer:new Ie({opacity:.2,color:i,width:2}),filter:(t,e)=>2===e.geomType},{dataSource:t,dataLayer:e,symbolizer:new Se({opacity:.2,fill:i,stroke:i,width:1}),filter:(t,e)=>3===e.geomType}],ri=(Math.PI,b(w())),oi=t=>t.then((t=>({status:"fulfilled",value:t})),(t=>({status:"rejected",reason:t}))),si=(t={})=>{class e extends L.GridLayer{constructor(t={}){t.noWrap&&!t.bounds&&(t.bounds=[[-90,-180],[90,180]]),null==t.attribution&&(t.attribution='<a href="https://protomaps.com">Protomaps</a> © <a href="https://openstreetmap.org/copyright">OpenStreetMap</a>'),super(t);const e=t.dark?z:B;this.paint_rules=t.paint_rules||Ze(e,t.shade),this.label_rules=t.label_rules||qe(e,t.shade,t.language1,t.language2),this.backgroundColor=t.backgroundColor,this.lastRequestedZ=void 0,this.xray=t.xray,this.tasks=t.tasks||[],this.views=(t=>{const e=t=>{const e=void 0===t.levelDiff?2:t.levelDiff,i=t.maxDataZoom||14;let n;n="string"==typeof t.url?t.url.endsWith(".pmtiles")?new me(t.url,!0):new ge(t.url,!0):new me(t.url,!0);const r=new Pe(n,256<<e);return new Qe(r,i,e)},i=new Map;if(t.sources)for(const n in t.sources)i.set(n,e(t.sources[n]));else i.set("",e(t));return i})(t),this.debug=t.debug;const i=document.createElement("canvas").getContext("2d");this.scratch=i,this.onTilesInvalidated=t=>{for(const e of t)this.rerenderTile(e)},this.labelers=new ei(this.scratch,this.label_rules,16,this.onTilesInvalidated),this.tile_size=256*window.devicePixelRatio,this.tileDelay=t.tileDelay||3,this.lang=t.lang,this.inspector=this.inspect(this)}setDefaultStyle(t,e,i,n){const r=t?z:B;this.paint_rules=Ze(r,e),this.label_rules=qe(r,e,i,n)}renderTile(t,e,i,n=(()=>{})){return x(this,null,(function*(){this.lastRequestedZ=t.z;const r=[];for(const[e,i]of this.views){const n=i.getDisplayTile(t);r.push({key:e,promise:n})}const o=yield Promise.all(r.map((t=>t.promise.then((e=>({status:"fulfilled",value:e,key:t.key})),(e=>({status:"rejected",reason:e,key:t.key})))))),s=new Map;for(const t of o)"fulfilled"===t.status?s.set(t.key,[t.value]):"AbortError"===t.reason.name||console.error(t.reason);if(e.key!==i)return;if(this.lastRequestedZ!==t.z)return;if(yield Promise.all(this.tasks.map(oi)),e.key!==i)return;if(this.lastRequestedZ!==t.z)return;const a=this.labelers.add(t.z,s);if(e.key!==i)return;if(this.lastRequestedZ!==t.z)return;const l=this.labelers.getIndex(t.z);if(!this._map)return;const h=this._map.getCenter().wrap(),c=this._getTiledPixelBounds(h),u=this._pxBoundsToTileRange(c).getCenter(),d=t.distanceTo(u)*this.tileDelay;var p;if(yield(p=d,new Promise(((t,e)=>{setTimeout((()=>{t()}),p)}))),e.key!==i)return;if(this.lastRequestedZ!==t.z)return;const f={minX:256*t.x-16,minY:256*t.y-16,maxX:256*(t.x+1)+16,maxY:256*(t.y+1)+16},m=new ri.default(256*t.x,256*t.y);e.width=this.tile_size,e.height=this.tile_size;const g=e.getContext("2d");g.setTransform(this.tile_size/256,0,0,this.tile_size/256,0,0),g.clearRect(0,0,256,256),this.backgroundColor&&(g.save(),g.fillStyle=this.backgroundColor,g.fillRect(0,0,256,256),g.restore());let _=0,y=this.paint_rules;if(this.xray&&(y=((t,e)=>{let i=[];for(const[n,r]of t)for(const t of r)for(const r of t.data.keys())n===e.dataSource&&r===e.dataLayer||(i=i.concat(ni(n,r,"steelblue")));return i=i.concat(ni(e.dataSource||"",e.dataLayer,"red")),i})(s,this.xray)),_=function(t,e,i,n,r,o,s,a,l){const h=performance.now();t.save(),t.miterLimit=2;for(const n of r){if(n.minzoom&&e<n.minzoom)continue;if(n.maxzoom&&e>n.maxzoom)continue;const r=i.get(n.dataSource||"");if(r)for(const e of r){const i=e.data.get(n.dataLayer);if(void 0===i)continue;n.symbolizer.before&&n.symbolizer.before(t,e.z);const r=e.origin,l=e.dim,h=e.scale;if(t.save(),a){t.beginPath();const e=Math.max(r.x-s.x,o.minX-s.x),i=Math.max(r.y-s.y,o.minY-s.y),n=Math.min(r.x-s.x+l,o.maxX-s.x),a=Math.min(r.y-s.y+l,o.maxY-s.y);t.rect(e,i,n-e,a-i),t.clip()}t.translate(r.x-s.x,r.y-s.y);for(const s of i){let i=s.geom;const a=s.bbox;a.maxX*h+r.x<o.minX||a.minX*h+r.x>o.maxX||a.minY*h+r.y>o.maxY||a.maxY*h+r.y<o.minY||n.filter&&!n.filter(e.z,s)||(1!==h&&(i=Xe(i,h,new ii.default(0,0))),n.symbolizer.draw(t,i,e.z,s))}t.restore()}}if(a&&(t.beginPath(),t.rect(o.minX-s.x,o.minY-s.y,o.maxX-o.minX,o.maxY-o.minY),t.clip()),n){const e=n.searchBbox(o,1/0);for(const i of e)if(t.save(),t.translate(i.anchor.x-s.x,i.anchor.y-s.y),i.draw(t),t.restore(),l){t.lineWidth=.5,t.strokeStyle=l,t.fillStyle=l,t.globalAlpha=1,t.fillRect(i.anchor.x-s.x-2,i.anchor.y-s.y-2,4,4);for(const e of i.bboxes)t.strokeRect(e.minX-s.x,e.minY-s.y,e.maxX-e.minX,e.maxY-e.minY)}}return t.restore(),performance.now()-h}(g,t.z,s,this.xray?null:l,y,f,m,!1,this.debug),this.debug){g.save(),g.fillStyle=this.debug,g.font="600 12px sans-serif",g.fillText(`${t.z} ${t.x} ${t.y}`,4,14),g.font="12px sans-serif";let e=28;for(const[t,i]of s){const n=i[0].data_tile;g.fillText(`${t+(t?" ":"")+n.z} ${n.x} ${n.y}`,4,e),e+=14}g.font="600 10px sans-serif",_>8&&(g.fillText(`${_.toFixed()} ms paint`,4,e),e+=14),a>8&&g.fillText(`${a.toFixed()} ms layout`,4,e),g.strokeStyle=this.debug,g.lineWidth=.5,g.beginPath(),g.moveTo(0,0),g.lineTo(0,256),g.stroke(),g.lineWidth=.5,g.beginPath(),g.moveTo(0,0),g.lineTo(256,0),g.stroke(),g.restore()}n()}))}rerenderTile(t){for(const e in this._tiles){const i=this._wrapCoords(this._keyToTileCoords(e));t===this._tileCoordsToKey(i)&&this.renderTile(i,this._tiles[e].el,t)}}clearLayout(){this.labelers=new ei(this.scratch,this.label_rules,16,this.onTilesInvalidated)}rerenderTiles(){for(const t in this._tiles){const e=this._wrapCoords(this._keyToTileCoords(t)),i=this._tileCoordsToKey(e);this.renderTile(e,this._tiles[t].el,i)}}createTile(t,e){const i=L.DomUtil.create("canvas","leaflet-tile");i.lang=this.lang;const n=this._tileCoordsToKey(t);return i.key=n,this.renderTile(t,i,n,(()=>{e(null,i)})),i}_removeTile(t){const e=this._tiles[t];e&&(e.el.removed=!0,e.el.key=void 0,L.DomUtil.removeClass(e.el,"leaflet-tile-loaded"),e.el.width=e.el.height=0,L.DomUtil.remove(e.el),delete this._tiles[t],this.fire("tileunload",{tile:e.el,coords:this._keyToTileCoords(t)}))}queryFeatures(t,e){const i=new Map;for(const[n,r]of this.views)i.set(n,r.queryFeatures(t,e,this._map.getZoom()));return i}inspect(t){return e=>{const i=["◎","⟍","◻"],n=t._map.wrapLatLng(e.latlng),r=t.queryFeatures(n.lng,n.lat);let o="",s=!0;for(const[t,e]of r)for(const n of e)if(!this.xray||!0===this.xray||(this.xray.dataSource||"")===t&&this.xray.dataLayer===n.layerName){o=`${o}<div style="margin-top:${s?0:.5}em">${i[n.feature.geomType-1]} <b>${t} ${t?"/":""} ${n.layerName}</b> ${n.feature.id||""}</div>`;for(const t in n.feature.props)o=`${o}<div style="font-size:0.9em">${t} = ${n.feature.props[t]}</div>`;s=!1}s&&(o="No features."),L.popup().setLatLng(e.latlng).setContent(`<div style="max-height:400px;overflow-y:scroll;padding-right:8px">${o}</div>`).openOn(t._map)}}addInspector(t){return t.on("click",this.inspector)}removeInspector(t){return t.off("click",this.inspector)}}return new e(t)};function ai(t,e){return"number"==typeof t?t:e}function li(t){if(t.includes("$type"))return t=>!0;if("=="===t[0])return(e,i)=>i.props[t[1]]===t[2];if("!="===t[0])return(e,i)=>i.props[t[1]]!==t[2];if("!"===t[0]){const e=li(t[1]);return(t,i)=>!e(t,i)}if("<"===t[0])return(e,i)=>ai(i.props[t[1]],1/0)<t[2];if("<="===t[0])return(e,i)=>ai(i.props[t[1]],1/0)<=t[2];if(">"===t[0])return(e,i)=>ai(i.props[t[1]],-1/0)>t[2];if(">="===t[0])return(e,i)=>ai(i.props[t[1]],-1/0)>=t[2];if("in"===t[0])return(e,i)=>t.slice(2,t.length).includes(i.props[t[1]]);if("!in"===t[0])return(e,i)=>!t.slice(2,t.length).includes(i.props[t[1]]);if("has"===t[0])return(e,i)=>i.props.hasOwnProperty(t[1]);if("!has"===t[0])return(e,i)=>!i.props.hasOwnProperty(t[1]);if("all"===t[0]){const e=t.slice(1,t.length).map((t=>li(t)));return(t,i)=>e.every((e=>e(t,i)))}if("any"===t[0]){const e=t.slice(1,t.length).map((t=>li(t)));return(t,i)=>e.some((e=>e(t,i)))}return console.log("Unimplemented filter: ",t[0]),t=>!1}function hi(t){if(t.base&&t.stops)return e=>Ee(t.base,t.stops)(e-1);if("interpolate"===t[0]&&"exponential"===t[1][0]&&"zoom"===t[2][0]){const e=t.slice(3),i=[];for(let t=0;t<e.length;t+=2)i.push([e[t],e[t+1]]);return e=>Ee(t[1][1],i)(e-1)}if("step"===t[0]&&"get"===t[1][0]){const e=t.slice(2),i=t[1][1];return(t,n)=>{const r=null==n?void 0:n.props[i];if("number"==typeof r){if(r<e[1])return e[0];for(let t=1;t<e.length;t+=2)if(r<=e[t])return e[t+1]}return e[e.length-1]}}return console.log("Unimplemented numeric fn: ",t),t=>1}function ci(t,e=0){return t?"number"==typeof t?t:(i,n)=>n?hi(t)(i,n):e:e}function ui(t,e){const i=ci(t,1),n=ci(e);return(t,e)=>{const r="number"==typeof i?i:i(t,e);return n?r+("number"==typeof n?n:n(t,e)):r}}function di(t,e){const i=[];for(const n of t["text-font"])e.hasOwnProperty(n)&&i.push(e[n]);0===i.length&&i.push({face:"sans-serif"});const n=t["text-size"];let r="";i.length&&i[0].weight&&(r=`${i[0].weight} `);let o="";if(i.length&&i[0].style&&(o=`${i[0].style} `),"number"==typeof n)return t=>`${o}${r}${n}px ${i.map((t=>t.face)).join(", ")}`;if(n.stops){let t=1.4;n.base?t=n.base:n.base=t;const e=hi(n);return(t,n)=>`${o}${r}${e(t,n)}px ${i.map((t=>t.face)).join(", ")}`}if("step"===n[0]){const t=hi(n);return(e,n)=>`${o}${r}${t(e,n)}px ${i.map((t=>t.face)).join(", ")}`}return console.log("Can't parse font: ",t),t=>"12px sans-serif"}function pi(t,e){const i=[],n=[],r=new Map;for(const o of t.layers){if(r.set(o.id,o),o.layout&&"none"===o.layout.visibility)continue;if(o.ref){const t=r.get(o.ref);o.type=t.type,o.filter=t.filter,o.source=t.source,o["source-layer"]=t["source-layer"]}let t;o["source-layer"],o.filter&&(t=li(o.filter)),"fill"===o.type?i.push({dataLayer:o["source-layer"],filter:t,symbolizer:new Se({fill:o.paint["fill-color"],opacity:o.paint["fill-opacity"]})}):"fill-extrusion"===o.type?i.push({dataLayer:o["source-layer"],filter:t,symbolizer:new Se({fill:o.paint["fill-extrusion-color"],opacity:o.paint["fill-extrusion-opacity"]})}):"line"===o.type?o.paint["line-dasharray"]?i.push({dataLayer:o["source-layer"],filter:t,symbolizer:new Ie({width:ui(o.paint["line-width"],o.paint["line-gap-width"]),dash:o.paint["line-dasharray"],dashColor:o.paint["line-color"]})}):i.push({dataLayer:o["source-layer"],filter:t,symbolizer:new Ie({color:o.paint["line-color"],width:ui(o.paint["line-width"],o.paint["line-gap-width"])})}):"symbol"===o.type?"line"===o.layout["symbol-placement"]?n.push({dataLayer:o["source-layer"],filter:t,symbolizer:new Ue({font:di(o.layout,e),fill:o.paint["text-color"],width:o.paint["text-halo-width"],stroke:o.paint["text-halo-color"],textTransform:o.layout["text-transform"],label_props:o.layout["text-field"]?[o.layout["text-field"]]:void 0})}):n.push({dataLayer:o["source-layer"],filter:t,symbolizer:new Ne({font:di(o.layout,e),fill:o.paint["text-color"],stroke:o.paint["text-halo-color"],width:o.paint["text-halo-width"],textTransform:o.layout["text-transform"],label_props:o.layout["text-field"]?[o.layout["text-field"]]:void 0})}):"circle"===o.type&&i.push({dataLayer:o["source-layer"],filter:t,symbolizer:new Te({radius:o.paint["circle-radius"],fill:o.paint["circle-color"],stroke:o.paint["circle-stroke-color"],width:o.paint["circle-stroke-width"]})})}return n.reverse(),{paint_rules:i,label_rules:n,tasks:[]}}function fi(t){if(!(this instanceof fi))return new fi(t);this._canvas=t="string"==typeof t?document.getElementById(t):t,this._ctx=t.getContext("2d"),this._width=t.width,this._height=t.height,this._max=1,this._data=[]}fi.prototype={defaultRadius:25,defaultGradient:{.4:"blue",.6:"cyan",.7:"lime",.8:"yellow",1:"red"},data:function(t){return this._data=t,this},max:function(t){return this._max=t,this},add:function(t){return this._data.push(t),this},clear:function(){return this._data=[],this},radius:function(t,e){e=void 0===e?15:e;var i=this._circle=this._createCanvas(),n=i.getContext("2d"),r=this._r=t+e;return i.width=i.height=2*r,n.shadowOffsetX=n.shadowOffsetY=2*r,n.shadowBlur=e,n.shadowColor="black",n.beginPath(),n.arc(-r,-r,t,0,2*Math.PI,!0),n.closePath(),n.fill(),this},resize:function(){this._width=this._canvas.width,this._height=this._canvas.height},gradient:function(t){var e=this._createCanvas(),i=e.getContext("2d"),n=i.createLinearGradient(0,0,0,256);for(var r in e.width=1,e.height=256,t)n.addColorStop(+r,t[r]);return i.fillStyle=n,i.fillRect(0,0,1,256),this._grad=i.getImageData(0,0,1,256).data,this},draw:function(t){this._circle||this.radius(this.defaultRadius),this._grad||this.gradient(this.defaultGradient);var e=this._ctx;e.clearRect(0,0,this._width,this._height);for(var i,n=0,r=this._data.length;n<r;n++)i=this._data[n],e.globalAlpha=Math.min(Math.max(i[2]/this._max,void 0===t?.05:t),1),e.drawImage(this._circle,i[0]-this._r,i[1]-this._r);var o=e.getImageData(0,0,this._width,this._height);return this._colorize(o.data,this._grad),e.putImageData(o,0,0),this},_colorize:function(t,e){for(var i,n=0,r=t.length;n<r;n+=4)(i=4*t[n+3])&&(t[n]=e[i],t[n+1]=e[i+1],t[n+2]=e[i+2])},_createCanvas:function(){return"undefined"!=typeof document?document.createElement("canvas"):new this._canvas.constructor}},L.HeatLayer=(L.Layer?L.Layer:L.Class).extend({options:{minOpacity:.05,maxZoom:18,radius:25,blur:15,max:1},initialize:function(t,e){this._latlngs=t,L.setOptions(this,e)},setLatLngs:function(t){return this._latlngs=t,this.redraw()},addLatLng:function(t){return this._latlngs.push(t),this.redraw()},setOptions:function(t){return L.setOptions(this,t),this._heat&&this._updateOptions(),this.redraw()},redraw:function(){return this._heat&&!this._frame&&this._map&&!this._map._animating&&(this._frame=L.Util.requestAnimFrame(this._redraw,this)),this},onAdd:function(t){this._map=t,this._canvas||this._initCanvas(),this.options.pane?this.getPane().appendChild(this._canvas):t._panes.overlayPane.appendChild(this._canvas),t.on("moveend",this._reset,this),t.options.zoomAnimation&&L.Browser.any3d&&t.on("zoomanim",this._animateZoom,this),this._reset()},onRemove:function(t){this.options.pane?this.getPane().removeChild(this._canvas):t.getPanes().overlayPane.removeChild(this._canvas),t.off("moveend",this._reset,this),t.options.zoomAnimation&&t.off("zoomanim",this._animateZoom,this)},addTo:function(t){return t.addLayer(this),this},_initCanvas:function(){var t=this._canvas=L.DomUtil.create("canvas","leaflet-heatmap-layer leaflet-layer"),e=L.DomUtil.testProp(["transformOrigin","WebkitTransformOrigin","msTransformOrigin"]);t.style[e]="50% 50%";var i=this._map.getSize();t.width=i.x,t.height=i.y;var n=this._map.options.zoomAnimation&&L.Browser.any3d;L.DomUtil.addClass(t,"leaflet-zoom-"+(n?"animated":"hide")),this._heat=fi(t),this._updateOptions()},_updateOptions:function(){this._heat.radius(this.options.radius||this._heat.defaultRadius,this.options.blur),this.options.gradient&&this._heat.gradient(this.options.gradient),this.options.max&&this._heat.max(this.options.max)},_reset:function(){var t=this._map.containerPointToLayerPoint([0,0]);L.DomUtil.setPosition(this._canvas,t);var e=this._map.getSize();this._heat._width!==e.x&&(this._canvas.width=this._heat._width=e.x),this._heat._height!==e.y&&(this._canvas.height=this._heat._height=e.y),this._redraw()},_redraw:function(){if(this._map){var t,e,i,n,r,o,s,a,l,h=[],c=this._heat._r,u=this._map.getSize(),d=new L.Bounds(L.point([-c,-c]),u.add([c,c])),p=void 0===this.options.max?1:this.options.max,f=void 0===this.options.maxZoom?this._map.getMaxZoom():this.options.maxZoom,m=1/Math.pow(2,Math.max(0,Math.min(f-this._map.getZoom(),12))),g=c/2,_=[],y=this._map._getMapPanePos(),v=y.x%g,b=y.y%g;for(t=0,e=this._latlngs.length;t<e;t++)i=this._map.latLngToContainerPoint(this._latlngs[t]),d.contains(i)&&(r=Math.floor((i.x-v)/g)+2,o=Math.floor((i.y-b)/g)+2,l=(void 0!==this._latlngs[t].alt?this._latlngs[t].alt:void 0!==this._latlngs[t][2]?+this._latlngs[t][2]:1)*m,_[o]=_[o]||[],(n=_[o][r])?(n[0]=(n[0]*n[2]+i.x*l)/(n[2]+l),n[1]=(n[1]*n[2]+i.y*l)/(n[2]+l),n[2]+=l):_[o][r]=[i.x,i.y,l]);for(t=0,e=_.length;t<e;t++)if(_[t])for(s=0,a=_[t].length;s<a;s++)(n=_[t][s])&&h.push([Math.round(n[0]),Math.round(n[1]),Math.min(n[2],p)]);this._heat.data(h).draw(this.options.minOpacity),this._frame=null}},_animateZoom:function(t){var e=this._map.getZoomScale(t.zoom),i=this._map._getCenterOffset(t.center)._multiplyBy(-e).subtract(this._map._getMapPanePos());L.DomUtil.setTransform?L.DomUtil.setTransform(this._canvas,i,e):this._canvas.style[L.DomUtil.TRANSFORM]=L.DomUtil.getTranslateString(i)+" scale("+e+")"}}),L.heatLayer=function(t,e){return new L.HeatLayer(t,e)},i().ImageService=i().Layer.extend({options:{url:"",f:"image",format:"jpgpng",pixelType:"UNKNOWN",noData:[],noDataInterpretation:"",interpolation:"",compressionQuality:"",bandIds:[],time:[],renderingRule:{},mosaicRule:{},endpoint:"",attribution:"",crs:null,interactive:!1,updateInterval:200},initialize:function(t){i().Util.setOptions(this,t)},updateUrl:function(){return"Esri"===this.options.endpoint?this._url=this.options.url+"/exportImage"+this._buildParams():this._url=this.options.url,this._bounds=this.toLatLngBounds(this._getBounds()),this._topLeft=this._map.getPixelBounds().min,this},onAdd:function(t){this._map=t,this.updateUrl(),this._image||this._initImage(),this._map.on("moveend",(()=>{i().Util.throttle(this.update(),this.options.updateInterval,this)})),this.options.interactive&&(i().DomUtil.addClass(this._image,"leaflet-interactive"),this.addInteractiveTarget(this._image)),this.getPane().appendChild(this._image),this._reset()},onRemove:function(){i().DomUtil.remove(this._image),this.options.interactive&&this.removeInteractiveTarget(this._image)},bringToFront:function(){return this._map&&i().DomUtil.toFront(this._image),this},bringToBack:function(){return this._map&&i().DomUtil.toBack(this._image),this},setUrl:function(t){return"Esri"===this.options.endpoint?this._url=t+"/exportImage"+this._buildParams():this._url=t,this._image&&(this._image.src=t),this},getEvents:function(){return{zoom:this._reset,viewreset:this._reset}},getBounds:function(){return this._bounds},toLatLngBounds:function(t,e){return t instanceof i().LatLngBounds?t:new(i().LatLngBounds)(t,e)},getElement:function(){return this._image},getCenter:function(){return this._bounds.getCenter()},_getBBox:function(){const t=this._map.getPixelBounds(),e=this._map.unproject(t.getBottomLeft()),i=this._map.unproject(t.getTopRight());return[this._map.options.crs.project(i).x,this._map.options.crs.project(i).y,this._map.options.crs.project(e).x,this._map.options.crs.project(e).y]},_getBounds:function(){return[[this._map.getBounds().getSouth(),this._map.getBounds().getWest()],[this._map.getBounds().getNorth(),this._map.getBounds().getEast()]]},_getSize:function(){const t=this._map.getSize();return[t.x,t.y]},_getEPSG:function(){const t=this.options.crs.code;return parseInt(t.split(":")[1],10)},_getTime:function(){return[new Date(this.options.time[0]).getTime().valueOf(),new Date(this.options.time[1]).getTime().valueOf()]},_buildParams:function(){const t={bbox:this._getBBox().join(","),size:this._getSize().join(","),bboxSR:this._getEPSG(),imageSR:this._getEPSG(),f:this.options.f};return this.options.format&&(t.format=this.options.format),this.options.pixelType&&(t.pixelType=this.options.pixelType),this.options.noDataInterpretation&&(t.noDataInterpretation=this.options.noDataInterpretation),this.options.interpolation&&(t.interpolation=this.options.interpolation),this.options.compressionQuality&&(t.compressionQuality=this.options.compressionQuality),this.options.noData.length&&(t.noData=this.options.noData.join(",")),this.options.bandIds.length&&(t.bandIds=this.options.bandIds.join(",")),this.options.time.length&&(t.time=this._getTime().join(",")),Object.keys(this.options.renderingRule).length&&(t.renderingRule=JSON.stringify(this.options.renderingRule)),Object.keys(this.options.mosaicRule).length&&(t.mosaicRule=JSON.stringify(this.options.mosaicRule)),i().Util.getParamString(t)},_initImage:function(){const t="IMG"===this._url.tagName,e=this._image=i().DomUtil.create("img");i().DomUtil.addClass(e,"leaflet-image-layer"),e.onselectstart=i().Util.falseFn,e.onmousemove=i().Util.falseFn,e.onload=i().Util.bind(this.fire,this,"load"),t?this._url=e.src:e.src=this._url},_reset:function(){const t=this._image,n=this._getSize();if(t.style.width=n[0]+"px",t.style.height=n[1]+"px",3857===this._getEPSG()){const n=new(i().Bounds)(this._map.latLngToLayerPoint(this._bounds.getNorthWest()),this._map.latLngToLayerPoint(this._bounds.getSouthEast()));i().DomUtil.setPosition(t,n.min??new e.Point(0,0))}else{const e=this._topLeft.subtract(this._map.getPixelOrigin());i().DomUtil.setPosition(t,e)}},update:function(){this._map&&(this._map._panTransition&&this._map._panTransition._inProgress||(this.updateUrl(),this._image&&this._map&&(this._image.src=this._url,this._reset())))}}),i().imageService=function(t){return new(i().ImageService)(t)},i().MagnifyingGlass=i().Layer.extend({options:{radius:100,zoomOffset:3,layers:[],fixedPosition:!1,latLng:[0,0],fixedZoom:-1},initialize:function(t){i().Util.setOptions(this,t),this._fixedZoom=-1!=this.options.fixedZoom,this._mainMap=null,this._glassMap=null},getMap:function(){return this._glassMap},_createMiniMap:function(t){return new(i().Map)(t,{layers:this.options.layers,zoom:this._getZoom(),maxZoom:this._mainMap.getMaxZoom(),minZoom:this._mainMap.getMinZoom(),crs:this._mainMap.options.crs,fadeAnimation:!1,attributionControl:!1,zoomControl:!1,boxZoom:!1,touchZoom:!1,scrollWheelZoom:!1,doubleClickZoom:!1,dragging:!1,keyboard:!1})},_getZoom:function(){return this._fixedZoom?this.options.fixedZoom:this._mainMap.getZoom()+this.options.zoomOffset},_updateZoom:function(){this._glassMap.setZoom(this._getZoom())},setRadius:function(t){this.options.radius=t,this._wrapperElt&&(this._wrapperElt.style.width=2*this.options.radius+"px",this._wrapperElt.style.height=2*this.options.radius+"px")},setLatLng:function(t){this.options.latLng=t,this._update(t)},_updateFromMouse:function(t){this._update(t.latlng,t.layerPoint)},_updateFixed:function(){this._update(this.options.latLng)},_update:function(t,e){this._glassMap.setView(t,this._getZoom(),{pan:{animate:!1}}),e=e||this._mainMap.latLngToLayerPoint(t),this._wrapperElt.style.left=e.x-this.options.radius+"px",this._wrapperElt.style.top=e.y-this.options.radius+"px"},onAdd:function(t){this._mainMap=t,this._wrapperElt=i().DomUtil.create("div","leaflet-magnifying-glass");var e=i().DomUtil.create("div","",this._wrapperElt);i().Browser.webkit&&i().DomUtil.addClass(e,"leaflet-magnifying-glass-webkit"),this._glassMap=this._createMiniMap(e),i().DomEvent.addListener(this._wrapperElt,"click",this._fireClick,this);var n=this.options;return this.setRadius(n.radius),this.setLatLng(n.latLng),this._glassMap.whenReady((()=>{n.fixedPosition?(this._mainMap.on("zoomend",this._updateFixed,this),i().DomUtil.addClass(this._wrapperElt,"leaflet-zoom-hide")):(this._mainMap.on("mousemove",this._updateFromMouse,this),this._fixedZoom||this._mainMap.on("zoomend",this._updateZoom,this))}),this),t.getPanes().popupPane.appendChild(this._wrapperElt),this._glassMap.invalidateSize(),this},_fireClick:function(t){this.fire("click",t),i().DomEvent.stopPropagation(t)},onRemove:function(t){t.off("viewreset",this._updateFixed,this),t.off("mousemove",this._updateFromMouse,this),t.off("zoomend",this._updateZoom,this);for(var e=0,n=this.options.layers.length;e<n;e++)this._glassMap.removeLayer(this.options.layers[e]);return this._glassMap.remove(),i().DomEvent.removeListener(this._wrapperElt,"click",this._fireClick),t.getPanes().popupPane.removeChild(this._wrapperElt),this._mainMap=null,this}}),i().magnifyingGlass=function(t){return new(i().MagnifyingGlass)(t)},i().Layer.include({_refreshTileUrl:function(t,e){const n=new Image;n.onload=()=>{i().Util.requestAnimFrame((()=>{t.el.src=e}))},n.src=e},refresh:function(){const t=this._map._fadeAnimated;this._map._fadeAnimated=!1;for(const t in this._tiles){const e=this._tiles[t];if(e.current&&e.active){const t=e.el.src,i=this.getTileUrl(e.coords);t!=i&&this._refreshTileUrl(e,i)}}t&&setTimeout((()=>{this._map._fadeAnimated=t}),5e3)}});const mi=i();var gi,_i,yi,vi,bi,xi=o(2055);function*wi(){}function Li(t,e){let i=0;for(const n of t)if(e(n,i++))return n}!function(t){function e(t,e,i=0,n=-1){let r,o=t.length;if(0===o)return-1;i=i<0?Math.max(0,i+o):Math.min(i,o-1),r=(n=n<0?Math.max(0,n+o):Math.min(n,o-1))<i?n+1+(o-i):n-i+1;for(let n=0;n<r;++n){let r=(i+n)%o;if(t[r]===e)return r}return-1}function i(t,e,i=-1,n=0){let r,o=t.length;if(0===o)return-1;r=(i=i<0?Math.max(0,i+o):Math.min(i,o-1))<(n=n<0?Math.max(0,n+o):Math.min(n,o-1))?i+1+(o-n):i-n+1;for(let n=0;n<r;++n){let r=(i-n+o)%o;if(t[r]===e)return r}return-1}function n(t,e,i=0,n=-1){let r,o=t.length;if(0===o)return-1;i=i<0?Math.max(0,i+o):Math.min(i,o-1),r=(n=n<0?Math.max(0,n+o):Math.min(n,o-1))<i?n+1+(o-i):n-i+1;for(let n=0;n<r;++n){let r=(i+n)%o;if(e(t[r],r))return r}return-1}function r(t,e,i=-1,n=0){let r,o=t.length;if(0===o)return-1;r=(i=i<0?Math.max(0,i+o):Math.min(i,o-1))<(n=n<0?Math.max(0,n+o):Math.min(n,o-1))?i+1+(o-n):i-n+1;for(let n=0;n<r;++n){let r=(i-n+o)%o;if(e(t[r],r))retur